
package jp.riken.brain.ni.samuraigraph.figure.java2d;

import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.JRadioButton;
import javax.swing.SpinnerNumberModel;
import jp.riken.brain.ni.samuraigraph.base.SGIPropertyDialogObserver;
import jp.riken.brain.ni.samuraigraph.base.SGPropertyDialog;
import jp.riken.brain.ni.samuraigraph.figure.SGIAxisBreakConstants;


/**
 * A dialog to set the properties of axis break symbols.
 */
public class SGAxisBreakDialog extends SGPropertyDialog
	implements SGIAxisBreakConstants
{

	/**
	 * 
	 */
	private static final long serialVersionUID = 8343507997626906363L;
	public static final String TITLE = "Axis Break Symbol Properties";


    /** Creates new form SGAxisBreakDialog */
    public SGAxisBreakDialog(java.awt.Frame parent, boolean modal)
    {
        super(parent, modal);
        initComponents();
        this.initProperty();
		this.initialize();
    }

    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    private void initComponents() {//GEN-BEGIN:initComponents
        java.awt.GridBagConstraints gridBagConstraints;

        mButtonPanel = new javax.swing.JPanel();
        mOKButton = new javax.swing.JButton();
        mCancelButton = new javax.swing.JButton();
        mPreviewButton = new javax.swing.JButton();
        mPanel = new javax.swing.JPanel();
        mSizeSeparator = new javax.swing.JSeparator();
        mFormSeparator = new javax.swing.JSeparator();
        mColorSeparator = new javax.swing.JSeparator();
        mDistortionLabel = new javax.swing.JLabel();
        mAngleLabel = new javax.swing.JLabel();
        mDistortionSpinner = new jp.riken.brain.ni.samuraigraph.base.SGSpinner();
        mAngleSpinner = new jp.riken.brain.ni.samuraigraph.base.SGSpinner();
        mSizeLabel = new javax.swing.JLabel();
        mFormLabel = new javax.swing.JLabel();
        mLengthLabel = new javax.swing.JLabel();
        mLengthSpinner = new jp.riken.brain.ni.samuraigraph.base.SGSpinner();
        mIntervalLabel = new javax.swing.JLabel();
        mIntervalSpinner = new jp.riken.brain.ni.samuraigraph.base.SGSpinner();
        mLineWidthLabel = new javax.swing.JLabel();
        mLineWidthSpinner = new jp.riken.brain.ni.samuraigraph.base.SGSpinner();
        mColorLabel = new javax.swing.JLabel();
        mInnerColorButton = new jp.riken.brain.ni.samuraigraph.base.SGColorSelectionButton();
        mLeftSpaceLabel = new javax.swing.JLabel();
        mRightSpaceLabel = new javax.swing.JLabel();
        mLineColorLabel = new javax.swing.JLabel();
        mLineColorButton = new jp.riken.brain.ni.samuraigraph.base.SGColorSelectionButton();
        mInnerColorLabel = new javax.swing.JLabel();
        mHorizontalRadioButton = new javax.swing.JRadioButton();
        mVerticalRadioButton = new javax.swing.JRadioButton();
        mLocationLabel = new javax.swing.JLabel();
        mLocationSeparator = new javax.swing.JSeparator();
        mXValueLabel = new javax.swing.JLabel();
        mXValueTextField = new jp.riken.brain.ni.samuraigraph.base.SGTextField();
        mYValueLabel = new javax.swing.JLabel();
        mYValueTextField = new jp.riken.brain.ni.samuraigraph.base.SGTextField();
        mAxisPanel = new jp.riken.brain.ni.samuraigraph.base.SGTwoAxesSelectionPanel();

        getContentPane().setLayout(new java.awt.GridBagLayout());

        mOKButton.setFont(new java.awt.Font("Dialog", 1, 12));
        mOKButton.setText("OK");
        mButtonPanel.add(mOKButton);

        mCancelButton.setFont(new java.awt.Font("Dialog", 1, 12));
        mCancelButton.setText("Cancel");
        mButtonPanel.add(mCancelButton);

        mPreviewButton.setFont(new java.awt.Font("Dialog", 1, 12));
        mPreviewButton.setText("Preview");
        mButtonPanel.add(mPreviewButton);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        getContentPane().add(mButtonPanel, gridBagConstraints);

        mPanel.setLayout(new java.awt.GridBagLayout());

        mPanel.setBorder(new javax.swing.border.BevelBorder(javax.swing.border.BevelBorder.RAISED));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        gridBagConstraints.insets = new java.awt.Insets(0, 35, 0, 0);
        mPanel.add(mSizeSeparator, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        gridBagConstraints.insets = new java.awt.Insets(0, 45, 0, 0);
        mPanel.add(mFormSeparator, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        gridBagConstraints.insets = new java.awt.Insets(0, 45, 0, 0);
        mPanel.add(mColorSeparator, gridBagConstraints);

        mDistortionLabel.setFont(new java.awt.Font("Dialog", 0, 12));
        mDistortionLabel.setText("Distortion");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 15, 5, 5);
        mPanel.add(mDistortionLabel, gridBagConstraints);

        mAngleLabel.setFont(new java.awt.Font("Dialog", 0, 12));
        mAngleLabel.setText("Angle");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 20, 5, 5);
        mPanel.add(mAngleLabel, gridBagConstraints);

        mDistortionSpinner.setFont(new java.awt.Font("Dialog", 0, 12));
        mDistortionSpinner.setPreferredSize(new java.awt.Dimension(70, 22));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        mPanel.add(mDistortionSpinner, gridBagConstraints);

        mAngleSpinner.setFont(new java.awt.Font("Dialog", 0, 12));
        mAngleSpinner.setPreferredSize(new java.awt.Dimension(70, 22));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        mPanel.add(mAngleSpinner, gridBagConstraints);

        mSizeLabel.setFont(new java.awt.Font("Dialog", 3, 12));
        mSizeLabel.setText("Size");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        mPanel.add(mSizeLabel, gridBagConstraints);

        mFormLabel.setFont(new java.awt.Font("Dialog", 3, 12));
        mFormLabel.setText("Form");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        mPanel.add(mFormLabel, gridBagConstraints);

        mLengthLabel.setFont(new java.awt.Font("Dialog", 0, 12));
        mLengthLabel.setText("Length");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 15, 5, 5);
        mPanel.add(mLengthLabel, gridBagConstraints);

        mLengthSpinner.setFont(new java.awt.Font("Dialog", 0, 12));
        mLengthSpinner.setPreferredSize(new java.awt.Dimension(70, 22));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        mPanel.add(mLengthSpinner, gridBagConstraints);

        mIntervalLabel.setFont(new java.awt.Font("Dialog", 0, 12));
        mIntervalLabel.setText("Interval");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 20, 5, 5);
        mPanel.add(mIntervalLabel, gridBagConstraints);

        mIntervalSpinner.setFont(new java.awt.Font("Dialog", 0, 12));
        mIntervalSpinner.setPreferredSize(new java.awt.Dimension(70, 22));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        mPanel.add(mIntervalSpinner, gridBagConstraints);

        mLineWidthLabel.setFont(new java.awt.Font("Dialog", 0, 12));
        mLineWidthLabel.setText("Line Width");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 15, 5, 5);
        mPanel.add(mLineWidthLabel, gridBagConstraints);

        mLineWidthSpinner.setFont(new java.awt.Font("Dialog", 0, 12));
        mLineWidthSpinner.setPreferredSize(new java.awt.Dimension(70, 22));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        mPanel.add(mLineWidthSpinner, gridBagConstraints);

        mColorLabel.setFont(new java.awt.Font("Dialog", 3, 12));
        mColorLabel.setText("Color");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        mPanel.add(mColorLabel, gridBagConstraints);

        mInnerColorButton.setPreferredSize(new java.awt.Dimension(65, 20));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(0, 5, 5, 5);
        mPanel.add(mInnerColorButton, gridBagConstraints);

        mLeftSpaceLabel.setText("    ");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        mPanel.add(mLeftSpaceLabel, gridBagConstraints);

        mRightSpaceLabel.setText("    ");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 2;
        mPanel.add(mRightSpaceLabel, gridBagConstraints);

        mLineColorLabel.setFont(new java.awt.Font("Dialog", 0, 12));
        mLineColorLabel.setText("Line");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 15, 10, 5);
        mPanel.add(mLineColorLabel, gridBagConstraints);

        mLineColorButton.setPreferredSize(new java.awt.Dimension(65, 20));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 10, 5);
        mPanel.add(mLineColorButton, gridBagConstraints);

        mInnerColorLabel.setFont(new java.awt.Font("Dialog", 0, 12));
        mInnerColorLabel.setText("Inner");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 20, 10, 5);
        mPanel.add(mInnerColorLabel, gridBagConstraints);

        mHorizontalRadioButton.setFont(new java.awt.Font("Dialog", 0, 12));
        mHorizontalRadioButton.setText("Horizontal");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 15, 5, 5);
        mPanel.add(mHorizontalRadioButton, gridBagConstraints);

        mVerticalRadioButton.setFont(new java.awt.Font("Dialog", 0, 12));
        mVerticalRadioButton.setText("Vertical");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 15, 5, 5);
        mPanel.add(mVerticalRadioButton, gridBagConstraints);

        mLocationLabel.setFont(new java.awt.Font("Dialog", 3, 12));
        mLocationLabel.setText("Location");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        mPanel.add(mLocationLabel, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        gridBagConstraints.insets = new java.awt.Insets(0, 60, 0, 0);
        mPanel.add(mLocationSeparator, gridBagConstraints);

        mXValueLabel.setFont(new java.awt.Font("Dialog", 0, 12));
        mXValueLabel.setText("X");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        mPanel.add(mXValueLabel, gridBagConstraints);

        mXValueTextField.setColumns(6);
        mXValueTextField.setFont(new java.awt.Font("Dialog", 0, 12));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        mPanel.add(mXValueTextField, gridBagConstraints);

        mYValueLabel.setFont(new java.awt.Font("Dialog", 0, 12));
        mYValueLabel.setText("Y");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        mPanel.add(mYValueLabel, gridBagConstraints);

        mYValueTextField.setColumns(6);
        mYValueTextField.setFont(new java.awt.Font("Dialog", 0, 12));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        mPanel.add(mYValueTextField, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        getContentPane().add(mPanel, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        getContentPane().add(mAxisPanel, gridBagConstraints);

        pack();
    }//GEN-END:initComponents
    
    
    // ϐ錾 - ҏWs//GEN-BEGIN:variables
    private javax.swing.JLabel mAngleLabel;
    private jp.riken.brain.ni.samuraigraph.base.SGSpinner mAngleSpinner;
    private jp.riken.brain.ni.samuraigraph.base.SGTwoAxesSelectionPanel mAxisPanel;
    private javax.swing.JPanel mButtonPanel;
    private javax.swing.JButton mCancelButton;
    private javax.swing.JLabel mColorLabel;
    private javax.swing.JSeparator mColorSeparator;
    private javax.swing.JLabel mDistortionLabel;
    private jp.riken.brain.ni.samuraigraph.base.SGSpinner mDistortionSpinner;
    private javax.swing.JLabel mFormLabel;
    private javax.swing.JSeparator mFormSeparator;
    private javax.swing.JRadioButton mHorizontalRadioButton;
    private jp.riken.brain.ni.samuraigraph.base.SGColorSelectionButton mInnerColorButton;
    private javax.swing.JLabel mInnerColorLabel;
    private javax.swing.JLabel mIntervalLabel;
    private jp.riken.brain.ni.samuraigraph.base.SGSpinner mIntervalSpinner;
    private javax.swing.JLabel mLeftSpaceLabel;
    private javax.swing.JLabel mLengthLabel;
    private jp.riken.brain.ni.samuraigraph.base.SGSpinner mLengthSpinner;
    private jp.riken.brain.ni.samuraigraph.base.SGColorSelectionButton mLineColorButton;
    private javax.swing.JLabel mLineColorLabel;
    private javax.swing.JLabel mLineWidthLabel;
    private jp.riken.brain.ni.samuraigraph.base.SGSpinner mLineWidthSpinner;
    private javax.swing.JLabel mLocationLabel;
    private javax.swing.JSeparator mLocationSeparator;
    private javax.swing.JButton mOKButton;
    private javax.swing.JPanel mPanel;
    private javax.swing.JButton mPreviewButton;
    private javax.swing.JLabel mRightSpaceLabel;
    private javax.swing.JLabel mSizeLabel;
    private javax.swing.JSeparator mSizeSeparator;
    private javax.swing.JRadioButton mVerticalRadioButton;
    private javax.swing.JLabel mXValueLabel;
    private jp.riken.brain.ni.samuraigraph.base.SGTextField mXValueTextField;
    private javax.swing.JLabel mYValueLabel;
    private jp.riken.brain.ni.samuraigraph.base.SGTextField mYValueTextField;
    // ϐ錾̏I//GEN-END:variables



	private JRadioButton mAdditionalDirectionRadioButton = new JRadioButton();



//	/**
//	 * 
//	 *
//	 */
//	public void dispose()
//	{
//		if( this.mAxisPanel!=null )
//		{
//			this.mAxisPanel.dispose();
//			this.mAxisPanel = null;
//		}
//		
//		this.mAdditionalDirectionRadioButton = null;
//
//		super.dispose();
//	}



	public static final double AXIS_BREAK_LENGTH_STEP = 0.10;
	public static final double AXIS_BREAK_INTERVAL_STEP = 0.10;
	public static final double AXIS_BREAK_DISTORTION_STEP = 0.10;
	public static final double AXIS_BREAK_ANGLE_STEP = 1.0;


	/**
	 * 
	 */
	private boolean initProperty()
	{

		// set the title
		this.setTitle( SGAxisBreakDialog.TITLE );


		//
		// set the spinner model
		//

		// length
		this.mLengthSpinner.initProperties(
			new SpinnerNumberModel(
				0.50, AXIS_BREAK_LENGTH_MIN, AXIS_BREAK_LENGTH_MAX, AXIS_BREAK_LENGTH_STEP ),
			AXIS_BREAK_LENGTH_UNIT, 1, 2 );

		// interval
		this.mIntervalSpinner.initProperties(
			new SpinnerNumberModel(
				0.50, AXIS_BREAK_INTERVAL_MIN, AXIS_BREAK_INTERVAL_MAX, AXIS_BREAK_INTERVAL_STEP ),
			AXIS_BREAK_INTERVAL_UNIT, 1, 2 );

		// distortion
		this.mDistortionSpinner.initProperties(
			new SpinnerNumberModel(
				0.0, AXIS_BREAK_DISTORTION_MIN, AXIS_BREAK_DISTORTION_MAX, AXIS_BREAK_DISTORTION_STEP ),
			null, 1, 2 );

		// angle
		this.mAngleSpinner.initProperties(
			new SpinnerNumberModel(
				0.0, AXIS_BERAK_ANGLE_MIN, AXIS_BREAK_ANGLE_MAX, AXIS_BREAK_ANGLE_STEP ),
			degree, 1, 2 );

		// line width
		this.mLineWidthSpinner.initProperties(
			getLineWidthSpinnerNumberModel(),
			LINE_WIDTH_UNIT, 1, 2 );


		//
		// create a radio-button-group
		//
		{
			final ButtonGroup group = new ButtonGroup();
			group.add( this.mHorizontalRadioButton );
			group.add( this.mVerticalRadioButton );
			group.add( this.mAdditionalDirectionRadioButton );
		}


		// tH[JXꂽF{^̏
		this.mFocusedColorSetButton = this.mLineColorButton;


		// set the name
		this.mXValueTextField.setDescription("Location-> X");
		this.mYValueTextField.setDescription("Location-> Y");
		this.mLengthSpinner.setDescription("Size-> Length");
		this.mIntervalSpinner.setDescription("Size-> Interval");
		this.mDistortionSpinner.setDescription("Form-> Distortion");
		this.mAngleSpinner.setDescription("Form-> Angle");
		this.mLineWidthSpinner.setDescription("Form-> Line Width");


		// add action listeners
		this.mOKButton.addActionListener(this);
		this.mCancelButton.addActionListener(this);
		this.mPreviewButton.addActionListener(this);


		return true;
	}



	
	/**
	 * 
	 * @return
	 */
	public Number getXValue()
	{
		return this.getNumber( this.mXValueTextField );
	}
	

	/**
	 * 
	 * @return
	 */
	public Number getYValue()
	{
		return this.getNumber( this.mYValueTextField );
	}
	
	
	/**
	 * 
	 * @return
	 */
	public Number getLength()
	{
		return this.mLengthSpinner.getNumber();
	}


	/**
	 * 
	 * @return
	 */
	public Number getInterval()
	{
		return this.mIntervalSpinner.getNumber();
	}


	/**
	 * 
	 * @return
	 */
	public Number getDistortion()
	{
		return this.mDistortionSpinner.getNumber();
	}


	/**
	 * 
	 * @return
	 */
	public Number getAngle()
	{
		return this.mAngleSpinner.getNumber();
	}


	/**
	 * 
	 * @return
	 */
	public Number getLineWidth()
	{
		return this.mLineWidthSpinner.getNumber();
	}


	/**
	 * 
	 * @return
	 */
	public Boolean isHorizontal()
	{
		if( this.mAdditionalDirectionRadioButton.isSelected() )
		{
			return null;
		}
		return new Boolean( this.mHorizontalRadioButton.isSelected() );
	}


	/**
	 * 
	 * @return
	 */
	public Color getLineColor()
	{
		return this.mLineColorButton.getColor();
	}


	/**
	 * 
	 * @return
	 */
	public Color getInnerColor()
	{
		return this.mInnerColorButton.getColor();
	}


	
	/**
	 * 
	 * @param obj
	 * @return
	 */
	public boolean setXValue( final Object obj )
	{
		return this.setValue( this.mXValueTextField, obj );
	}

	
	/**
	 * 
	 * @param obj
	 * @return
	 */
	public boolean setYValue( final Object obj )
	{
		return this.setValue( this.mYValueTextField, obj );
	}

	

	/**
	 * 
	 * @param obj
	 * @return
	 */
	public boolean setLength( final Object obj )
	{
		return this.setValue( this.mLengthSpinner, obj );
	}


	
	/**
	 * 
	 * @param obj
	 * @return
	 */
	public boolean setInterval( final Object obj )
	{
		return this.setValue( this.mIntervalSpinner, obj );
	}


	/**
	 * 
	 * @param obj
	 * @return
	 */
	public boolean setDistortion( final Object obj )
	{
		return this.setValue( this.mDistortionSpinner, obj );
	}


	/**
	 * 
	 * @param obj
	 * @return
	 */
	public boolean setAngle( final Object obj )
	{
		return this.setValue( this.mAngleSpinner, obj );
	}


	/**
	 * 
	 * @param obj
	 * @return
	 */
	public boolean setLineWidth( final Object obj )
	{
		return this.setValue( this.mLineWidthSpinner, obj );
	}



	/**
	 * 
	 * @param flag
	 * @return
	 */
	public boolean setHorizontal( final boolean flag )
	{
		this.mHorizontalRadioButton.setSelected( flag );
		this.mVerticalRadioButton.setSelected( !flag );

		return true;
	}



	/**
	 * 
	 * @param c
	 * @return
	 */
	public boolean setLineColor( final Color c )
	{
		this.mLineColorButton.setColor(c);
		return true;
	}


	/**
	 * 
	 * @param c
	 * @return
	 */
	public boolean setInnerColor( final Color c )
	{
		this.mInnerColorButton.setColor(c);
		return true;
	}


	/**
	 * 
	 */
	public List getTextFieldComponentsList()
	{
		final List list = this.getFormattedTextFieldsListFromSpinners();
		list.addAll( this.getNumberTextFieldList() );
		return list;
	}


	/**
	 * Returns a list of text fields to set number.
	 * @return
	 */
	public List getNumberTextFieldList()
	{
		ArrayList list = new ArrayList();
		list.add( this.mXValueTextField );
		list.add( this.mYValueTextField );
		return list;
	}


	/**
	 * 
	 */    
	public List getColorSelectionButtonsList()
	{
		ArrayList list = new ArrayList();
		list.add( this.mLineColorButton );
		list.add( this.mInnerColorButton );
		return list;
	}


	/**
	 * 
	 */    
	public List getSpinnerList()
	{
		ArrayList list = new ArrayList();
		list.add( this.mLengthSpinner );
		list.add( this.mIntervalSpinner );
		list.add( this.mDistortionSpinner );
		list.add( this.mAngleSpinner );
		list.add( this.mLineWidthSpinner );
		return list;
	}
    


	/**
	 * 
	 * @return
	 */
	public boolean setDialogProperty()
	{
//		final SGAxisBreakDialog dg = this;

		List list = this.mPropertyDialogObserverList;

		if( this.mAxisPanel.setSelected( list ) == false )
		{
			return false;
		}


		SGIAxisBreakDialogObserver abs0
			= (SGIAxisBreakDialogObserver)list.get(0);

		final double xValue0 = abs0.getXValue();
		final double yValue0 = abs0.getYValue();
		final float length0 = abs0.getLength( cm );
		final float interval0 = abs0.getInterval( cm );
		final float distortion0 = abs0.getDistortion();
		final float angle0 = abs0.getAngle();
		final float lineWidth0 = abs0.getLineWidth( pt );
		final boolean horizontal0 = abs0.isForHorizontalAxis();
		final Color lineColor0 = abs0.getLineColor();
		final Color innerColor0 = abs0.getInnerColor();

		Double xValue = new Double( xValue0 );
		Double yValue = new Double( yValue0 );
		Float length = new Float( length0 );
		Float interval = new Float( interval0 );
		Float distortion = new Float( distortion0 );
		Float angle = new Float( angle0 );
		Float lineWidth = new Float( lineWidth0 );
		Boolean horizontal = Boolean.valueOf( horizontal0 );
		Color lineColor = lineColor0;
		Color innerColor = innerColor0;

		if( list.size() > 1 )
		{
			for( int ii=1; ii<list.size(); ii++ )
			{
				SGIAxisBreakDialogObserver abs1
					= (SGIAxisBreakDialogObserver)list.get(ii);

				final double xValue1 = abs1.getXValue();
				if( xValue0!=xValue1 )
				{
					xValue = null;
					break;
				}
			}

			for( int ii=1; ii<list.size(); ii++ )
			{
				SGIAxisBreakDialogObserver abs1
					= (SGIAxisBreakDialogObserver)list.get(ii);

				final double yValue1 = abs1.getYValue();
				if( yValue0!=yValue1 )
				{
					yValue = null;
					break;
				}
			}

			for( int ii=1; ii<list.size(); ii++ )
			{
				SGIAxisBreakDialogObserver abs1
					= (SGIAxisBreakDialogObserver)list.get(ii);

				final float length1 = abs1.getLength( cm );
				if( length0!=length1 )
				{
					length = null;
					break;
				}
			}

			for( int ii=1; ii<list.size(); ii++ )
			{
				SGIAxisBreakDialogObserver abs1
					= (SGIAxisBreakDialogObserver)list.get(ii);

				final float interval1 = abs1.getInterval( cm );
				if( interval0!=interval1 )
				{
					interval = null;
					break;
				}
			}

			for( int ii=1; ii<list.size(); ii++ )
			{
				SGIAxisBreakDialogObserver abs1
					= (SGIAxisBreakDialogObserver)list.get(ii);

				final float distortion1 = abs1.getDistortion();
				if( distortion0!=distortion1 )
				{
					distortion = null;
					break;
				}
			}

			for( int ii=1; ii<list.size(); ii++ )
			{
				SGIAxisBreakDialogObserver abs1
					= (SGIAxisBreakDialogObserver)list.get(ii);

				final float angle1 = abs1.getAngle();
				if( angle0!=angle1 )
				{
					angle = null;
					break;
				}
			}

			for( int ii=1; ii<list.size(); ii++ )
			{
				SGIAxisBreakDialogObserver abs1
					= (SGIAxisBreakDialogObserver)list.get(ii);

				final float lineWidth1 = abs1.getLineWidth( pt );
				if( lineWidth0!=lineWidth1 )
				{
					lineWidth = null;
					break;
				}
			}

			for( int ii=1; ii<list.size(); ii++ )
			{
				SGIAxisBreakDialogObserver abs1
					= (SGIAxisBreakDialogObserver)list.get(ii);

				final boolean horizontal1 = abs1.isForHorizontalAxis();
				if( horizontal0!=horizontal1 )
				{
					horizontal = null;
					break;
				}
			}
			
			for( int ii=1; ii<list.size(); ii++ )
			{
				SGIAxisBreakDialogObserver abs1
					= (SGIAxisBreakDialogObserver)list.get(ii);

				final Color lineColor1 = abs1.getLineColor();
				if( lineColor0.equals(lineColor1) == false )
				{
					lineColor = null;
					break;
				}
			}

			for( int ii=1; ii<list.size(); ii++ )
			{
				SGIAxisBreakDialogObserver abs1
					= (SGIAxisBreakDialogObserver)list.get(ii);

				final Color innerColor1 = abs1.getInnerColor();
				if( innerColor0.equals(innerColor1) == false )
				{
					innerColor = null;
					break;
				}
			}
			
		}




		//
		this.setXValue( xValue );
		this.setYValue( yValue );

//		if( length!=null )
//		{
//			length = new Float( length.floatValue()*CM_POINT_RATIO );
//		}
		this.setLength( length );


//		if( interval!=null )		
//		{
//			interval = new Float( interval.floatValue()*CM_POINT_RATIO );
//		}
		this.setInterval( interval );

		this.setDistortion( distortion );
		
		if( angle!=null )
		{
			angle = new Float( angle.floatValue()/RADIAN_DEGREE_RATIO );
		}
		this.setAngle( angle );


		this.setLineWidth( lineWidth );

		if( horizontal!=null )
		{
			this.setHorizontal( horizontal.booleanValue() );
		}
		else
		{
			this.mAdditionalDirectionRadioButton.setSelected(true);
		}


		this.setLineColor( lineColor );
		
		this.setInnerColor( innerColor );


		this.setColorButtonBorder(true);

		return true;
	}



	/**
	 * 
	 */
	public boolean setPropertiesToListeners( SGIPropertyDialogObserver l )
	{

		SGIAxisBreakDialogObserver abs
			= (SGIAxisBreakDialogObserver)l;

		// get values
		final int xConfig = this.mAxisPanel.getXAxisConfiguration();
		final int yConfig = this.mAxisPanel.getYAxisConfiguration();
		final Number xValue = this.getXValue();
		final Number yValue = this.getYValue();
		final Number len = this.getLength();
		final Number interval = this.getInterval();
		final Number distortion = this.getDistortion();
		final Number angle = this.getAngle();
		final Number lineWidth = this.getLineWidth();
		final Boolean horizontal = this.isHorizontal();
		final Color lc = this.getLineColor();
		final Color ic = this.getInnerColor();


		// check values
		ArrayList list = new ArrayList();
		if( abs.hasValidXValue( xConfig, xValue ) == false )
		{
			list.add("X");
		}
		if( abs.hasValidYValue( yConfig, yValue ) == false )
		{
			list.add("Y");
		}
		if( list.size()!=0 )
		{
			String msg = ERRMSG_AXIS_VALUE_INVALID + ":\n";
			for( int ii=0; ii<list.size(); ii++ )
			{
				String str = (String)list.get(ii);
				msg += " - " + str + "\n";
			}
			this.setInputErrorMessage(msg);
			return false;
		}


		// set the related axes
		if( xConfig!=-1 )
		{
			abs.setXAxisLocation( xConfig );
		}

		if( yConfig!=-1 )
		{
			abs.setYAxisLocation( yConfig );
		}


		// x value
		if( xValue!=null )
		{
			abs.setXValue( xValue.doubleValue() );
		}

		// y value
		if( yValue!=null )
		{
			abs.setYValue( yValue.doubleValue() );
		}
		
		// length
		if( len!=null )
		{
//			abs.setLength( len.floatValue()/SGIConstants.CM_POINT_RATIO );
			abs.setLength( len.floatValue(), cm );
		}

		// interval
		if( interval!=null )
		{
//			abs.setInterval( interval.floatValue()/SGIConstants.CM_POINT_RATIO );
			abs.setInterval( interval.floatValue(), cm );
		}

		// distortion
		if( distortion!=null )
		{
			abs.setDistortion( distortion.floatValue() );
		}

		// angle
		if( angle!=null )
		{
			abs.setAngle( angle.floatValue()*RADIAN_DEGREE_RATIO );
		}

		// line width
		if( lineWidth!=null )
		{
//			abs.setLineWidth( lineWidth.floatValue() );
			abs.setLineWidth( lineWidth.floatValue(), pt );
		}

		// horizontal
		if( horizontal!=null )
		{
			abs.setForHorizontalAxisFlag( horizontal.booleanValue() );
		}

		// line color
		if( lc!=null )
		{
			abs.setLineColor(lc);
		}
		
		// inner color
		if( ic!=null )
		{
			abs.setInnerColor(ic);
		}

		return true;
	}


}

