
package jp.riken.brain.ni.samuraigraph.figure;

import java.awt.Color;

import jp.riken.brain.ni.samuraigraph.base.SGDrawingWindow;
import jp.riken.brain.ni.samuraigraph.base.SGFigure;
import jp.riken.brain.ni.samuraigraph.base.SGIFigureElementAxisBreak;
import jp.riken.brain.ni.samuraigraph.base.SGIDrawingElementConstants;
import jp.riken.brain.ni.samuraigraph.base.SGIFigureElement;
import jp.riken.brain.ni.samuraigraph.base.SGIFigureElementGrid;
import jp.riken.brain.ni.samuraigraph.base.SGIFigureElementShape;
import jp.riken.brain.ni.samuraigraph.base.SGIFigureElementSignificantDifference;
import jp.riken.brain.ni.samuraigraph.base.SGIFigureElementString;
import jp.riken.brain.ni.samuraigraph.base.SGIFigureElementTimingLine;
import jp.riken.brain.ni.samuraigraph.base.SGProperties;

/**
 *
 *
 */
public abstract class SGXYFigure extends SGFigure
	implements SGIXYFigureDialogObserver
{
//	/**
//	 * 
//	 */
//	public SGXYFigure()
//	{
//		super();
//	}

	/**
	 * @param wnd
	 */
	public SGXYFigure(SGDrawingWindow wnd)
	{
		super(wnd);
	}


	/**
	 * 
	 * @return
	 */
	public SGIFigureElementGrid getGridElement()
	{
		return (SGIFigureElementGrid)this.getIFigureElement( SGIFigureElementGrid.class );
	}

	
	public SGIFigureElement getSymbolElement( final int symbolElementType )
	{
		Class cl = null;
		switch( symbolElementType )
		{
		case SGIDrawingElementConstants.SYMBOL_ELEMENT_TYPE_STRING:
			cl = SGIFigureElementString.class;
			break;
		case SGIDrawingElementConstants.SYMBOL_ELEMENT_TYPE_AXISBREAK:
			cl = SGIFigureElementAxisBreak.class;
			break;
		case SGIDrawingElementConstants.SYMBOL_ELEMENT_TYPE_SIGDIFF:
			cl = SGIFigureElementSignificantDifference.class;
			break;
		case SGIDrawingElementConstants.SYMBOL_ELEMENT_TYPE_TIMINGLINE:
			cl = SGIFigureElementTimingLine.class;
			break;
		case SGIDrawingElementConstants.SYMBOL_ELEMENT_TYPE_SHAPE:
			cl = SGIFigureElementShape.class;
			break;
		}
		if ( cl == null )
			return null;
		return this.getIFigureElement( cl );
	}

	/**
	 * 
	 */
	public int getXAxisLocation()
	{
		return this.getGridElement().getXAxisLocation();
	}


	/**
	 * 
	 */
	public int getYAxisLocation()
	{
		return this.getGridElement().getYAxisLocation();
	}



	public boolean setXAxisLocation( final int location )
	{
		return this.getGridElement().setXAxisLocation( location );
	}

	public boolean setYAxisLocation( final int location )
	{
		return this.getGridElement().setYAxisLocation( location );
	}

	public boolean setGridVisible( final boolean b )
	{
		return this.getGridElement().setGridVisible(b);
	}

	public boolean setAutoCalculateRange( final boolean b )
	{
		return this.getGridElement().setAutoRangeFlag(b);
	}

	public boolean setGridStepValueX( final double value )
	{
		return this.getGridElement().setStepValueX(value);
	}

	public boolean setGridStepValueY( final double value )
	{
		return this.getGridElement().setStepValueY(value);
	}

	public boolean setGridBaselineValueX( final double value )
	{
		return this.getGridElement().setBaselineValueX(value);
	}

	public boolean setGridBaselineValueY( final double value )
	{
		return this.getGridElement().setBaselineValueY(value);
	}

	public boolean setGridLineWidth( final float width, final String unit )
	{
		return this.getGridElement().setLineWidth(width,unit);
	}

	public boolean setGridLineType( final int type )
	{
		return this.getGridElement().setLineType(type);
	}

	public boolean setGridLineColor( final Color cl )
	{
		return this.getGridElement().setColor(cl);
	}



	public boolean setXAxisLocationDirectly( final int location )
	{
		if( this.setDirectlyBefore() == false ) return false;
		if( this.getGridElement().setXAxisLocation( location ) == false ) return false;
		if( this.setDirectlyAfter() == false ) return false;
		return true;
	}

	public boolean setYAxisLocationDirectly( final int location )
	{
		if( this.setDirectlyBefore() == false ) return false;
		if( this.getGridElement().setYAxisLocation( location ) == false ) return false;
		if( this.setDirectlyAfter() == false ) return false;
		return true;
	}

	public boolean setGridVisibleDirectly( final boolean b )
	{
		if( this.setDirectlyBefore() == false ) return false;
		if( this.getGridElement().setGridVisible(b) == false ) return false;
		if( this.setDirectlyAfter() == false ) return false;
		return true;
	}

	public boolean setAutoCalculateRangeDirectly( final boolean b )
	{
		if( this.setDirectlyBefore() == false ) return false;
		if( this.getGridElement().setAutoRangeFlag(b) == false ) return false;
		if( this.setDirectlyAfter() == false ) return false;
		return true;
	}

	public boolean setGridStepValueXDirectly( final double value )
	{
		if( this.setDirectlyBefore() == false ) return false;
		if( this.getGridElement().setStepValueX(value) == false ) return false;
		if( this.setDirectlyAfter() == false ) return false;
		return true;
	}

	public boolean setGridStepValueYDirectly( final double value )
	{
		if( this.setDirectlyBefore() == false ) return false;
		if( this.getGridElement().setStepValueY(value) == false ) return false;
		if( this.setDirectlyAfter() == false ) return false;
		return true;
	}

	public boolean setGridBaselineValueXDirectly( final double value )
	{
		if( this.setDirectlyBefore() == false ) return false;
		if( this.getGridElement().setBaselineValueX(value) == false ) return false;
		if( this.setDirectlyAfter() == false ) return false;
		return true;
	}

	public boolean setGridBaselineValueYDirectly( final double value )
	{
		if( this.setDirectlyBefore() == false ) return false;
		if( this.getGridElement().setBaselineValueY(value) == false ) return false;
		if( this.setDirectlyAfter() == false ) return false;
		return true;
	}

	public boolean setGridLineWidthDirectly( final float value, final String unit )
	{
		if( this.setDirectlyBefore() == false ) return false;
		if( this.setGridLineWidth( value, unit ) == false ) return false;
		if( this.setDirectlyAfter() == false ) return false;
		return true;
	}

	public boolean setGridLineTypeDirectly( final int type )
	{
		if( this.setDirectlyBefore() == false ) return false;
		if( this.setGridLineType( type ) == false ) return false;
		if( this.setDirectlyAfter() == false ) return false;
		return true;
	}

	public boolean setGridLineColorDirectly( final Color cl )
	{
		if( this.setDirectlyBefore() == false ) return false;
		if( this.setGridLineColor( cl ) == false ) return false;
		if( this.setDirectlyAfter() == false ) return false;
		return true;
	}


	public boolean isGridVisible()
	{
		return this.getGridElement().isGridVisible();
	}
	
	public boolean isAutoCalculateRange()
	{
		return this.getGridElement().isAutoRange();
	}

	public double getGridStepValueX()
	{
		return this.getGridElement().getStepValueX();
	}

	public double getGridStepValueY()
	{
		return this.getGridElement().getStepValueY();
	}

	public double getGridBaselineValueX()
	{
		return this.getGridElement().getBaselineValueX();
	}
	public double getGridBaselineValueY()
	{
		return this.getGridElement().getBaselineValueY();
	}

	public float getGridLineWidth( final String unit )
	{
		return this.getGridElement().getLineWidth( unit );
	}

	public int getGridLineType()
	{
		return this.getGridElement().getLineType();
	}

	public Color getGridLineColor()
	{
		return this.getGridElement().getColor();
	}


	public boolean hasValidStepXValue( final Number step )
	{
		return this.getGridElement().hasValidStepXValue( step );
	}

	public boolean hasValidStepYValue( final Number step )
	{
		return this.getGridElement().hasValidStepYValue( step );
	}


	/**
	 * 
	 */
	public SGProperties getProperties()
	{
		XYFigureProperties p = new XYFigureProperties();
		if( this.getProperties(p) == false ) return null;
		return p;
	}


	/**
	 * 
	 * @param p
	 * @return
	 */
	public boolean getProperties( SGProperties p )
	{
		if( ( p instanceof XYFigureProperties ) == false ) return false;

		if( super.getProperties(p) == false ) return false;

		XYFigureProperties fp = (XYFigureProperties)p;

		SGIFigureElementGrid el = this.getGridElement();
		fp.mXAxisConfiguration = el.getXAxisLocation();
		fp.mYAxisConfiguration = el.getYAxisLocation();
		fp.mBaselineValueX = el.getBaselineValueX();
		fp.mBaselineValueY = el.getBaselineValueY();
		fp.mStepValueX = el.getStepValueX();
		fp.mStepValueY = el.getStepValueY();
		fp.mVisibleFlag = el.isGridVisible();
		fp.mAutoRangeFlag = el.isAutoRange();
		fp.mLineWidth = el.getLineWidth();
		fp.mLineType = el.getLineType();
		fp.mColor = el.getColor();

		return true;
	}



	/**
	 * 
	 */
	public boolean setProperties( SGProperties p )
	{
		if( ( p instanceof XYFigureProperties ) == false ) return false;

		if( super.setProperties(p) == false ) return false;

		XYFigureProperties fp = (XYFigureProperties)p;

		SGIFigureElementGrid el = this.getGridElement();
		el.setXAxisLocation( fp.mXAxisConfiguration );
		el.setYAxisLocation( fp.mYAxisConfiguration );
		el.setBaselineValueX( fp.mBaselineValueX );
		el.setBaselineValueY( fp.mBaselineValueY );
		el.setStepValueX( fp.mStepValueX );
		el.setStepValueY( fp.mStepValueY );
		el.setGridVisible( fp.mVisibleFlag );
		el.setAutoRangeFlag( fp.mAutoRangeFlag );
		el.setLineWidth( fp.mLineWidth );
		el.setLineType( fp.mLineType );
		el.setColor( fp.mColor );

		return true;
	}



	/**
	 * 
	 * @author kuromaru
	 *
	 * ̐ꂽRg̑}ev[gύX邽
	 * EBhE > ݒ > Java > R[h > R[hƃRg
	 */
	public static class XYFigureProperties extends FigureProperties
	{
		private int mXAxisConfiguration;
		private int mYAxisConfiguration;
		private double mStepValueX;
		private double mBaselineValueX;
		private double mStepValueY;
		private double mBaselineValueY;
		private boolean mVisibleFlag;
		private boolean mAutoRangeFlag;
		private float mLineWidth;
		private int mLineType;
		private Color mColor;

		/**
		 * 
		 *
		 */
		public XYFigureProperties()
		{
			super();
		}

		/**
		 * 
		 */
		public boolean equals( Object obj )
		{
			if( ( obj instanceof XYFigureProperties ) == false ) return false;
			
			if( super.equals(obj) == false ) return false;
			
			XYFigureProperties p = (XYFigureProperties)obj;

			if( this.mXAxisConfiguration!=p.mXAxisConfiguration ) return false;
			if( this.mYAxisConfiguration!=p.mYAxisConfiguration ) return false;
			if( this.mBaselineValueX!=p.mBaselineValueX ) return false;
			if( this.mStepValueX!=p.mStepValueX ) return false;
			if( this.mBaselineValueY!=p.mBaselineValueY ) return false;
			if( this.mStepValueY!=p.mStepValueY ) return false;
			if( this.mVisibleFlag!=p.mVisibleFlag ) return false;
			if( this.mAutoRangeFlag!=p.mAutoRangeFlag ) return false;
			if( this.mLineWidth!=p.mLineWidth ) return false;
			if( this.mLineType!=p.mLineType ) return false;
			if( this.mColor.equals(p.mColor) == false ) return false;
			
			return true;
		}


	}


}
