
package jp.riken.brain.ni.samuraigraph.figure;

import java.awt.Color;
import java.util.List;

import jp.riken.brain.ni.samuraigraph.base.SGDrawingElement;
import jp.riken.brain.ni.samuraigraph.base.SGIConstants;
import jp.riken.brain.ni.samuraigraph.base.SGProperties;
import jp.riken.brain.ni.samuraigraph.base.SGUtilityText;

import org.w3c.dom.Element;


/**
 * Symbol of the significant difference.
 */
public abstract class SGDrawingElementSignificantDifference extends SGDrawingElement
	implements SGISignificantDifferenceConstants, SGIStringConstants
{

	/**
	 * 
	 */
	private float mX;


	/**
	 * 
	 */
	private float mY;


	/**
	 * 
	 */
	private float mWidth;


	/**
	 * 
	 */
	private float mPerpendicularHeight1;


	/**
	 * 
	 */
	private float mPerpendicularHeight2;


	/**
	 * 
	 */
	private float mSpace;


	/**
	 * 
	 */
	private float mLineWidth;


	/**
	 * 
	 */
	private boolean mLineVisibleFlag = true;
	
	
	/**
	 * 
	 */
	private SGDrawingElementString mStringElement;

	/**
	 * 
	 */
	private SGDrawingElementLine mHorizontalLine;

	/**
	 * 
	 */
	private SGDrawingElementLine mPerpendicularLine1;

	/**
	 * 
	 */
	private SGDrawingElementLine mPerpendicularLine2;

	
	
	/**
	 * @return mLineVisibleFlag
	 */
	public boolean isLineVisible()
	{
		return this.mLineVisibleFlag;
	}

	/**
	 * @param lineVisibleFlag mLineVisibleFlag ݒ肵܂B
	 */
	public boolean setLineVisible( final boolean b )
	{
		this.mLineVisibleFlag = b;
		return true;
	}

	
	/**
	 * 
	 */
	public SGDrawingElementSignificantDifference()
	{
		super();
		this.mStringElement = this.createString();
		this.mHorizontalLine = this.createLine();
		this.mPerpendicularLine1 = this.createLine();
		this.mPerpendicularLine2 = this.createLine();
	}


	/**
	 * 
	 */
	public SGDrawingElementSignificantDifference(
		final float x,
		final float y,
		final float w,
		final float hl,
		final float hr )
	{
		super();
		this.setLocation(x,y);
		this.setSize(w,hl,hr);
	}

	protected abstract SGDrawingElementString createString();
	protected abstract SGDrawingElementLine createLine();

	/**
	 * 
	 */
	public void dispose()
	{
		super.dispose();
		this.mHorizontalLine.dispose();
		this.mPerpendicularLine1.dispose();
		this.mPerpendicularLine2.dispose();
		this.mStringElement.dispose();
		this.mHorizontalLine = null;
		this.mPerpendicularLine1 = null;
		this.mPerpendicularLine2 = null;
		this.mStringElement = null;
	}

	/**
	 * 
	 */
	public boolean contains( final int x, final int y )
	{
		if( this.isLineVisible() )
		{
			if( this.mHorizontalLine.contains(x,y) )
			{
				return true;
			}

			if( this.mPerpendicularLine1.contains(x,y) )
			{
				return true;
			}

			if( this.mPerpendicularLine2.contains(x,y) )
			{
				return true;
			}
		}

		if( this.mStringElement.contains(x,y) )
		{
			return true;
		}

		return false;
	}

	/**
	 * 
	 */
	public float getX()
	{
		return this.mX;
	}


	/**
	 * 
	 */
	public float getY()
	{
		return this.mY;
	}

	
	
	/**
	 * 
	 * @return
	 */
	public float getX1()
	{
		return this.getX();
	}
	
	
	/**
	 * 
	 * @return
	 */
	public float getX2()
	{
		return this.getX1() + this.getMagnification()*this.getWidth();
	}
	

	/**
	 * 
	 * @return
	 */
	public float getY1()
	{
		return this.getY() + this.getMagnification()*this.getPerpendicularHeight1();
	}
	

	
	/**
	 * 
	 * @return
	 */
	public float getY2()
	{
		return this.getY() + this.getMagnification()*this.getPerpendicularHeight2();
	}

	

	/**
	 * 
	 */
	public float getWidth()
	{
		return this.mWidth;
	}


	/**
	 * 
	 */
	public float getPerpendicularHeight1()
	{
		return this.mPerpendicularHeight1;
	}


	/**
	 * 
	 */
	public float getPerpendicularHeight2()
	{
		return this.mPerpendicularHeight2;
	}


	/**
	 * 
	 */
	public float getSpace()
	{
		return this.mSpace;
	}

	/**
	 * 
	 */
	public final SGDrawingElementString getStringElement()
	{
		return this.mStringElement;
	}
	
	protected final SGDrawingElementLine getHorizontalLine()
	{
		return this.mHorizontalLine;
	}

	protected final SGDrawingElementLine getPerpendicularLine1()
	{
		return this.mPerpendicularLine1;
	}
	
	protected final SGDrawingElementLine getPerpendicularLine2()
	{
		return this.mPerpendicularLine2;
	}

	/**
	 * 
	 */
	public String getText()
	{
		return this.mStringElement.getString();
	}


	/**
	 * 
	 */
	public float getFontSize()
	{
		return this.mStringElement.getFontSize();
	}


	/**
	 * 
	 */
	public int getFontStyle()
	{
		return this.mStringElement.getFontStyle();
	}


	/**
	 * 
	 */
	public String getFontName()
	{
		return this.mStringElement.getFontName();
	}


	/**
	 * 
	 */
	public float getLineWidth()
	{
		return this.mLineWidth;
	}


	/**
	 * 
	 */
	public Color getColor()
	{
		return this.getColor(0);
	}


	/**
	 * 
	 */
	public boolean setColorList( final List colorList )
	{
		super.setColorList( colorList );
		this.mStringElement.setColorList( colorList );
		return true;
	}


	/**
	 * 
	 */
	public boolean setColor( final Color color )
	{
		super.setColor( color );
		this.mStringElement.setColor( color );
		return true;
	}


	/**
	 * 
	 * @return
	 */
	public boolean addColor( final Color color )
	{
		super.addColor( color );
		this.mStringElement.addColor( color );
		return true;
	}




	/**
	 * 
	 */
	public boolean setLocation( final float x, final float y )
	{
		this.setX(x);
		this.setY(y);
		return true;
	}


	/**
	 * 
	 */
	public boolean setMagnification( final float mag )
	{
		super.setMagnification( mag );
		this.mStringElement.setMagnification( mag );
		this.mHorizontalLine.setMagnification( mag );
		this.mPerpendicularLine1.setMagnification( mag );
		this.mPerpendicularLine2.setMagnification( mag );
		return true;
	}



	/**
	 * 
	 * @param x
	 * @return
	 */
	public boolean setX( final float x )
	{
		this.mX = x;
		return true;
	}



	/**
	 * 
	 * @param y
	 * @return
	 */
	public boolean setY( final float y )
	{
		this.mY = y;
		return true;
	}



	/**
	 * 
	 */
	public boolean setSize( final float w, final float h1, final float h2 )
	{
		this.setWidth(w);
		this.setPerpendicularHeight1(h1);
		this.setPerpendicularHeight2(h2);
		return true;
	}


	/**
	 * 
	 */
	public boolean setWidth( final float w )
	{
		this.mWidth = w;
		return true;
	}


	/**
	 * 
	 */
	public boolean setWidth( final float w, final String unit )
	{
		return this.setWidth( (float)SGUtilityText.convertToPoint( w, unit ) );
	}


	/**
	 * 
	 */
	public boolean setPerpendicularHeight1( final float h )
	{
		this.mPerpendicularHeight1 = h;
		return true;
	}


	/**
	 * 
	 */
	public boolean setPerpendicularHeight1( final float h, final String unit )
	{
		return this.setPerpendicularHeight1( (float)SGUtilityText.convertToPoint( h, unit ) );
	}


	/**
	 * 
	 */
	public boolean setPerpendicularHeight2( final float h )
	{
		this.mPerpendicularHeight2 = h;
		return true;
	}


	/**
	 * 
	 */
	public boolean setPerpendicularHeight2( final float h, final String unit )
	{
		return this.setPerpendicularHeight2( (float)SGUtilityText.convertToPoint( h, unit ) );
	}


	/**
	 * 
	 */
	public boolean setSpace( final float space )
	{
		this.mSpace = space;
		return true;
	}


	/**
	 * 
	 */
	public boolean setSpace( final float space, final String unit )
	{
		return this.setSpace( (float)SGUtilityText.convertToPoint( space, unit ) );
	}


	/**
	 * 
	 */
	public boolean setText( final String text )
	{
		if( text==null )
		{
			throw new IllegalArgumentException("text==null");
		}
		this.mStringElement.setString( text );
		return true;
	}

	
	/**
	 * 
	 */
	public boolean setLineWidth( final float width )
	{
		if( width < Float.MIN_VALUE )
		{
			throw new IllegalArgumentException("lineWidth < Float.MIN_VALUE");
		}
		this.mLineWidth = width;
		this.mHorizontalLine.setLineWidth(width);
		this.mPerpendicularLine1.setLineWidth(width);
		this.mPerpendicularLine2.setLineWidth(width);
		return true;
	}


	/**
	 * 
	 */
	public boolean setLineWidth( final float lw, final String unit )
	{
		return this.setLineWidth( (float)SGUtilityText.convertToPoint( lw, unit ) );
	}

	/**
	 * 
	 * @param name
	 * @param style
	 * @param size
	 * @return
	 */
	public boolean setFont( final String name, final int style, final float size )
	{
		if( size < Float.MIN_VALUE )
		{
			throw new IllegalArgumentException("size < Float.MIN_VALUE");
		}
		this.mStringElement.setFont( name, style, size );
		return true;
	}


	/**
	 * 
	 * @param name
	 */
	public boolean setFontName( final String name )
	{
		final int style = this.mStringElement.getFontStyle();
		final float size = this.mStringElement.getFontSize();
		return this.setFont( name, style, size );
	}


	/**
	 * 
	 * @param size
	 */
	public boolean setFontSize( final float size )
	{
		final String name = this.mStringElement.getFontName();
		final int style = this.mStringElement.getFontStyle();
		return this.setFont( name, style, size );
	}


	/**
	 * 
	 */
	public boolean setFontSize( final float size, final String unit )
	{
		final double conv = SGUtilityText.convert( size, unit, FONT_SIZE_UNIT );
		if( conv < FONT_SIZE_MIN_VALUE ) return false;
		if( conv > FONT_SIZE_MAX_VALUE ) return false;

		return this.setFontSize( (float)SGUtilityText.convertToPoint( size, unit ) );
	}


	/**
	 * 
	 * @param style
	 */
	public boolean setFontStyle( final int style )
	{
		final String name = this.getFontName();
		final float size = this.getFontSize();
		return this.setFont( name, style, size );
	}


	/**
	 * 
	 * @return
	 */
	public boolean isFlippingHorizontal()
	{
		return ( this.mWidth < 0.0f );
	}


	/**
	 * 
	 * @return
	 */
	public boolean isFlippingVertical()
	{
		return ( this.isFlippingVertical1() & this.isFlippingVertical2() );
	}


	/**
	 * 
	 * @return
	 */
	public boolean isFlippingVertical1()
	{
		return ( this.mPerpendicularHeight1 < 0.0f );
	}


	/**
	 * 
	 * @return
	 */
	public boolean isFlippingVertical2()
	{
		return ( this.mPerpendicularHeight2 < 0.0f );
	}


	/**
	 * 
	 * @return
	 */
	public boolean isFlippingVerticalLeft()
	{
		return ( !this.isFlippingHorizontal() ? this.isFlippingVertical1() : this.isFlippingVertical2() );
	}


	/**
	 * 
	 * @return
	 */
	public boolean isFlippingVerticalRight()
	{
		return ( !this.isFlippingHorizontal() ? this.isFlippingVertical2() : this.isFlippingVertical1() );
	}



	/**
	 * 
	 * @return
	 */
	public float getLeftHeight()
	{
		if( !this.isFlippingHorizontal() )
		{
			return this.getPerpendicularHeight1();
		}
		return this.getPerpendicularHeight2();
	}


	/**
	 * 
	 * @return
	 */
	public float getRightHeight()
	{
		if( !this.isFlippingHorizontal() )
		{
			return this.getPerpendicularHeight2();
		}
		return this.getPerpendicularHeight1();
	}



	/**
	 * 
	 * @param h
	 * @return
	 */
	public boolean setLeftHeight( final float h )
	{
		if( !this.isFlippingHorizontal() )
		{
			this.setPerpendicularHeight1( h );
		}
		else
		{
			this.setPerpendicularHeight2( h );
		}
		return true;
	}



	/**
	 * 
	 * @param h
	 * @return
	 */
	public boolean setRightHeight( final float h )
	{
		if( !this.isFlippingHorizontal() )
		{
			this.setPerpendicularHeight2( h );
		}
		else
		{
			this.setPerpendicularHeight1( h );
		}
		return true;
	}


	
	/**
	 * 
	 * @param x
	 * @return
	 */
	public boolean setNodePointLocation(
		final float x1, final float y1, final float x2, final float y2, final float y )
	{
		final float mag = this.getMagnification();

		// x
		final float w = ( x2 - x1 )/mag;
		this.setX(x1);
		this.setWidth(w);

		// y
		this.setY(y);
		final float h1 = ( y1 - y )/mag;
		final float h2 = ( y2 - y )/mag;
		this.setPerpendicularHeight1(h1);
		this.setPerpendicularHeight2(h2);
		
		return true;
	}
	


	/**
	 * 
	 */
	public SGProperties getProperties()
	{
		SigDiffProperties p = new SigDiffProperties();

		if( this.getProperties(p) == false ) return null;

		return p;
	}



	/**
	 * 
	 */
	public boolean getProperties( SGProperties p )
	{
		if( ( p instanceof SigDiffProperties ) == false ) return false;

		if( super.getProperties(p) == false ) return false;

		SigDiffProperties sp = (SigDiffProperties)p;
		
		sp.mSpace = this.mSpace;
		sp.mLineVisible = this.mLineVisibleFlag;
		sp.mLineWidth = this.mLineWidth;
		sp.mText = this.getText();
		sp.mFontName = this.getFontName();
		sp.mFontSize = this.getFontSize();
		sp.mFontStyle = this.getFontStyle();
		
		return true;
	}
	
	

	/**
	 * 
	 */
	public boolean setProperties( final SGProperties p )
	{
		if( ( p instanceof SigDiffProperties ) == false ) return false;
		
		if( super.setProperties(p) == false ) return false;

		SigDiffProperties sp = (SigDiffProperties)p;

		this.mSpace = sp.mSpace;
		this.setText( sp.mText );
		this.setFont( sp.mFontName, sp.mFontStyle, sp.mFontSize );
		this.setLineVisible( sp.mLineVisible );
		this.setLineWidth( sp.mLineWidth );

		return true;
	}


	/**
	 * 
	 * @param el
	 * @return
	 */
	public boolean writeProperty( final Element el )
	{
		final float ratio = SGIConstants.CM_POINT_RATIO;
			
		el.setAttribute( KEY_TEXT, this.getText() );
		el.setAttribute( KEY_FONT_NAME, this.getFontName() );
		el.setAttribute( KEY_FONT_SIZE, Float.toString( this.getFontSize() ) + SGIConstants.pt );
		el.setAttribute( KEY_FONT_STYLE, SGUtilityText.getFontStyleName( this.getFontStyle() ) );
		el.setAttribute( KEY_DRAWING_ELEMENT_COLORS, SGUtilityText.getColorListString( this.getColorList() ) );
		el.setAttribute( KEY_LINE_VISIBLE, Boolean.toString( this.isLineVisible() ) );
		el.setAttribute( KEY_LINE_WIDTH, Float.toString( this.getLineWidth() ) + SGIConstants.pt );
		el.setAttribute( KEY_SPACE, Float.toString( this.getSpace()*ratio ) + SGIConstants.cm );

		return true;
	}

		

	/**
	 * 
	 */
	public boolean readProperty( final Element el )
	{
		String str = null;
		Number num = null;
//		Color cl = null;
		Boolean b = null;
		List list = null;

		// text
		str = el.getAttribute( KEY_TEXT );
		if( str.length()!=0 )
		{
			final String text = str;
			if( this.setText( text ) == false )
			{
				return false;
			}
		}
		
		
		// font name
		str = el.getAttribute( KEY_FONT_NAME );
		if( str.length()!=0 )
		{
			final String fontName = str;
			if( this.setFontName( fontName ) == false )
			{
				return false;
			}
		}
		
		
		// font size
		str = el.getAttribute( KEY_FONT_SIZE );
		if( str.length()!=0 )
		{
			StringBuffer uFontSize = new StringBuffer();
			num = SGUtilityText.getNumber( str, uFontSize );
			if( num==null )
			{
				return false;
			}
			final float fontSize = num.floatValue();
			if( this.setFontSize( fontSize, uFontSize.toString() ) == false )
			{
				return false;
			}
		}
		
		
		// font style
		str = el.getAttribute( KEY_FONT_STYLE );
		if( str.length()!=0 )
		{
			final int fontStyle = SGUtilityText.getFontStyle(str);
			if( fontStyle==-1 )
			{
				return false;
			}
			if( this.setFontStyle( fontStyle ) == false )
			{
				return false;
			}
		}
		
		
		// set color
		str = el.getAttribute( KEY_DRAWING_ELEMENT_COLORS );
		if( str.length()!=0 )
		{
			list = SGUtilityText.getColorList(str);
			if( list==null )
			{
				return false;
			}
			if( list.size()<1 )
			{
				return false;
			}
			final Color color = (Color)list.get(0);
			if( this.setColor( color ) == false )
			{
				return false;
			}
		}
		
			
		// line visible
		str = el.getAttribute( KEY_LINE_VISIBLE );
		if( str.length()!=0 )
		{
			b = SGUtilityText.getBoolean(str);
			if( b==null )
			{
				return false;
			}
			final boolean lineVisible = b.booleanValue();
			if( this.setLineVisible( lineVisible ) == false )
			{
				return false;
			}
		}

			
		// line width
		str = el.getAttribute( KEY_LINE_WIDTH );
		if( str.length()!=0 )
		{
			StringBuffer uLineWidth = new StringBuffer();
			num = SGUtilityText.getNumber( str, uLineWidth );
			if( num==null )
			{
				return false;
			}
			final float lineWidth = num.floatValue();
			if( this.setLineWidth( lineWidth, uLineWidth.toString() ) == false )
			{
				return false;
			}
		}

			
		// space
		str = el.getAttribute( KEY_SPACE );
		if( str.length()!=0 )
		{
			StringBuffer uSpace = new StringBuffer();
			num = SGUtilityText.getNumber( str, uSpace );
			if( num==null )
			{
				return false;
			}
			final float space = num.floatValue();
			if( this.setSpace( space, uSpace.toString() ) == false )
			{
				return false;
			}
		}


		return true;
	}



	/**
	 * 
	 */
	public static class SigDiffProperties extends SGDrawingElement.DrawingElementProperties
	{
		private float mSpace;
		private float mLineWidth;
		private String mText;
		private String mFontName;
		private float mFontSize;
		private int mFontStyle;
		private boolean mLineVisible;

		public SigDiffProperties()
		{
			super();
		}


		/**
		 * 
		 */
		public boolean equals( final Object obj )
		{
			if( ( obj instanceof SigDiffProperties ) == false ) return false;

			if( super.equals(obj) == false ) return false;

			SigDiffProperties p = (SigDiffProperties)obj;

			if( p.mSpace != this.mSpace ) return false;
			if( p.mLineWidth != this.mLineWidth ) return false;
			if( p.mText.equals(this.mText) == false ) return false;
			if( p.mFontName.equals(this.mFontName) == false ) return false;
			if( p.mFontSize != this.mFontSize ) return false;
			if( p.mFontStyle != this.mFontStyle ) return false;
			if( p.mLineVisible != this.mLineVisible ) return false;

			return true;
		}


		public Float getSpace()
		{
			return new Float( this.mSpace );
		}

		public Float getLineWidth()
		{
			return new Float( this.mLineWidth );
		}
		
		public String getText()
		{
			return this.mText;
		}
		
		public String getFontName()
		{
			return this.mFontName;
		}
		
		public Float getFontSize()
		{
			return new Float( this.mFontSize );
		}
		
		public Integer getFontStyle()
		{
			return new Integer( this.mFontStyle );
		}
		
		public Boolean getLineVisible()
		{
			return Boolean.valueOf( this.mLineVisible );
		}


		public void setSpace( final float value )
		{
			this.mSpace = value;
		}
		
		public void setLineWidth( final float value )
		{
			if( value<0.0f )
			{
				throw new IllegalArgumentException("value<0.0f");
			}
			this.mLineWidth = value;
		}
		
		public void setText( final String str )
		{
			if( str==null )
			{
				throw new IllegalArgumentException("str==null");
			}
			this.mText = str;
		}
		
		public void setFontName( final String str )
		{
			if( str==null )
			{
				throw new IllegalArgumentException("str==null");
			}
			this.mFontName = str;
		}

		public void setFontSize( final float value )
		{
			if( value<0.0f )
			{
				throw new IllegalArgumentException("value<0.0f");
			}
			this.mFontSize = value;
		}
		
		public void setFontStyle( final int style )
		{
			this.mFontStyle = style;
		}

		public void setLineVisible( final boolean b )
		{
			this.mLineVisible = b;
		}
	}



}

