
package jp.riken.brain.ni.samuraigraph.base;

import java.awt.Color;

/**
 * An observer of the figure dialog.
 */
public interface SGIFigureDialogObserver extends SGIPropertyDialogObserver
{

	public float getFigureX( final String unit );
	
	public float getFigureY( final String unit );
	
	public float getFigureWidth( final String unit );
	
	public float getFigureHeight( final String unit );

	public float getSpaceAxisLineAndNumber( final String unit );
	
	public float getSpaceNumberAndTitle( final String unit );

	/**
	 * @return
	 * @uml.property  name="transparent"
	 */
	public boolean isTransparent();

	/**
	 * @return
	 * @uml.property  name="backgroundColor"
	 */
	public Color getBackgroundColor();

	/**
	 * @return
	 * @uml.property  name="legendVisible"
	 */
	public boolean isLegendVisible();

	public boolean setFigureX( final float x, final String unit );

	public boolean setFigureY( final float y, final String unit );

	public boolean setFigureWidth( final float w, final String unit );

	public boolean setFigureHeight( final float h, final String unit );
	
	public boolean setSpaceAxisLineAndNumber( final float space, final String unit );

	public boolean setSpaceNumberAndTitle( final float space, final String unit );

	/**
	 * @param b
	 * @return
	 * @uml.property  name="transparent"
	 */
	public boolean setTransparent( final boolean b );

	/**
	 * @param cl
	 * @return
	 * @uml.property  name="backgroundColor"
	 */
	public boolean setBackgroundColor( final Color cl );

	/**
	 * @param b
	 * @return
	 * @uml.property  name="legendVisible"
	 */
	public boolean setLegendVisible( final boolean b );


}


