
package jp.riken.brain.ni.samuraigraph.application;


import java.awt.event.ActionEvent;
import java.awt.event.WindowEvent;
import javax.swing.ButtonGroup;
import jp.riken.brain.ni.samuraigraph.base.SGDialog;
import jp.riken.brain.ni.samuraigraph.base.SGUtility;



/**
 * A dialog to set the proxy connection.
 *
 */
public class SGProxySettingDialog extends SGDialog
{

	/**
	 * 
	 */
	private static final long serialVersionUID = -8514470147936484758L;
	public static final String TITLE = "Connection Settings";


    /** Creates new form JDialog */
    public SGProxySettingDialog(java.awt.Frame parent, boolean modal) {
        super(parent, modal);
        initComponents();
        this.initProperty();
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    private void initComponents() {//GEN-BEGIN:initComponents
        java.awt.GridBagConstraints gridBagConstraints;

        mButtonPanel = new javax.swing.JPanel();
        mOKButton = new javax.swing.JButton();
        mCancelButton = new javax.swing.JButton();
        mPanel = new javax.swing.JPanel();
        mDirectAccessRadioButton = new javax.swing.JRadioButton();
        mManualRadioButton = new javax.swing.JRadioButton();
        mHostNameLabel = new javax.swing.JLabel();
        mHostNameTextField = new javax.swing.JTextField();
        mPortNumberLabel = new javax.swing.JLabel();
        mPortNumberTextField = new javax.swing.JTextField();
        mSpaceLabel = new javax.swing.JLabel();

        getContentPane().setLayout(new java.awt.GridBagLayout());

        mOKButton.setFont(new java.awt.Font("Dialog", 1, 12));
        mOKButton.setText("OK");
        mButtonPanel.add(mOKButton);

        mCancelButton.setFont(new java.awt.Font("Dialog", 1, 12));
        mCancelButton.setText("Cancel");
        mButtonPanel.add(mCancelButton);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.SOUTHEAST;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        getContentPane().add(mButtonPanel, gridBagConstraints);

        mPanel.setLayout(new java.awt.GridBagLayout());

        mPanel.setBorder(new javax.swing.border.TitledBorder(null, "Configure Proxy to Access the Internet", javax.swing.border.TitledBorder.DEFAULT_JUSTIFICATION, javax.swing.border.TitledBorder.DEFAULT_POSITION, new java.awt.Font("Dialog", 1, 12)));
        mDirectAccessRadioButton.setFont(new java.awt.Font("Dialog", 0, 12));
        mDirectAccessRadioButton.setText("Direct connection to the Internet");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 10, 0, 0);
        mPanel.add(mDirectAccessRadioButton, gridBagConstraints);

        mManualRadioButton.setFont(new java.awt.Font("Dialog", 0, 12));
        mManualRadioButton.setText("Manual proxy configuration");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(3, 10, 0, 0);
        mPanel.add(mManualRadioButton, gridBagConstraints);

        mHostNameLabel.setFont(new java.awt.Font("Dialog", 0, 12));
        mHostNameLabel.setText("HTTP Proxy:");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new java.awt.Insets(4, 5, 10, 5);
        mPanel.add(mHostNameLabel, gridBagConstraints);

        mHostNameTextField.setColumns(20);
        mHostNameTextField.setFont(new java.awt.Font("Dialog", 0, 12));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new java.awt.Insets(4, 0, 10, 0);
        mPanel.add(mHostNameTextField, gridBagConstraints);

        mPortNumberLabel.setFont(new java.awt.Font("Dialog", 0, 12));
        mPortNumberLabel.setText("Port:");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new java.awt.Insets(4, 5, 10, 5);
        mPanel.add(mPortNumberLabel, gridBagConstraints);

        mPortNumberTextField.setColumns(3);
        mPortNumberTextField.setFont(new java.awt.Font("Dialog", 0, 12));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new java.awt.Insets(4, 0, 10, 10);
        mPanel.add(mPortNumberTextField, gridBagConstraints);

        mSpaceLabel.setText("        ");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new java.awt.Insets(4, 0, 10, 0);
        mPanel.add(mSpaceLabel, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new java.awt.Insets(10, 10, 0, 10);
        getContentPane().add(mPanel, gridBagConstraints);

        pack();
    }//GEN-END:initComponents
    
    
    // ϐ錾 - ҏWs//GEN-BEGIN:variables
    private javax.swing.JPanel mButtonPanel;
    private javax.swing.JButton mCancelButton;
    private javax.swing.JRadioButton mDirectAccessRadioButton;
    private javax.swing.JLabel mHostNameLabel;
    private javax.swing.JTextField mHostNameTextField;
    private javax.swing.JRadioButton mManualRadioButton;
    private javax.swing.JButton mOKButton;
    private javax.swing.JPanel mPanel;
    private javax.swing.JLabel mPortNumberLabel;
    private javax.swing.JTextField mPortNumberTextField;
    private javax.swing.JLabel mSpaceLabel;
    // ϐ錾̏I//GEN-END:variables

    

    private boolean mDirectAccessFlag = false;
    private String mHostName = null;
    private int mPortNumber = -1;

    
    private boolean initProperty()
    {
    	// set the title
    	this.setTitle( TITLE );
    	
    	// create a button group
    	ButtonGroup bg = new ButtonGroup();
    	bg.add(this.mDirectAccessRadioButton);
    	bg.add(this.mManualRadioButton);

    	// add this object as an action listener
    	this.mOKButton.addActionListener(this);
    	this.mCancelButton.addActionListener(this);
    	this.mDirectAccessRadioButton.addActionListener(this);
    	this.mManualRadioButton.addActionListener(this);
    	this.mHostNameTextField.addActionListener(this);
    	this.mPortNumberTextField.addActionListener(this);
    	
    	return true;
    }

    
    /**
     * 
     */
    public void actionPerformed( ActionEvent e )
    {
		Object source = e.getSource();
		String command = e.getActionCommand();
		
		if( command.equals( SGDialog.OK_BUTTON_TEXT )
				| source.equals( this.mHostNameTextField )
				| source.equals( this.mPortNumberTextField ) )
		{
			this.onOK();
		}
		else if( command.equals( SGDialog.CANCEL_BUTTON_TEXT ) )
		{
			this.onCanceled();
		}
		else if( source.equals( this.mDirectAccessRadioButton )
				| source.equals( this.mManualRadioButton ) )
		{
			this.setDirectAccess( this.isDirectAccessFromRadioButton() );
		}
    }


	/**
	 * 
	 */
	protected boolean onOK()
	{
		final String hostName = this.getHostFromTextField();
		final int num = this.getPortNumberFromTextField();
		final boolean direct = this.isDirectAccessFromRadioButton();
		final int len = hostName.length();
		if( direct==false )
		{
			if( len==0 | ( len!=0 && num==-1 ) )
			{
				SGUtility.showIllegalInputErrorMessageDialog(this);
				return false;
			}
		}

		// set attributes
		this.mHostName = hostName;
		this.mPortNumber = num;
		this.mDirectAccessFlag = direct;

		//
		this.setVisible(false);
		this.notifyToListener( OK_BUTTON_TEXT );
		return true;
	}


	/**
	 * 
	 */
	protected boolean onCanceled()
	{
		this.setVisible(false);
		this.notifyToListener( CANCEL_BUTTON_TEXT );
		return true;
	}

	
    /**
     * 
     * @return
     */
    private boolean isDirectAccessFromRadioButton()
    {
    	return this.mDirectAccessRadioButton.isSelected();
    }

    
    /**
     * 
     * @return
     */
    private String getHostFromTextField()
    {
    	return this.mHostNameTextField.getText();
    }


    /**
     * 
     * @return
     */
    private int getPortNumberFromTextField()
    {
    	int num = -1;
    	String text = this.mPortNumberTextField.getText();
    	try
		{
        	num = Integer.parseInt(text);
		}
    	catch( NumberFormatException ex )
		{
    		
		}
    	return num;
    }


    /**
     * 
     * @return
     */
    public boolean isDirectAccess()
    {
    	return this.mDirectAccessFlag;
    }

    
    /**
     * 
     * @return
     */
    public String getHostName()
    {
    	return this.mHostName;
    }

    
    /**
     * 
     * @return
     */
    public int getPortNumber()
    {
    	return this.mPortNumber;
    }

    
    /**
     * 
     * @param b
     */
    public void setDirectAccess( final boolean b )
    {
    	this.mDirectAccessFlag = b;
    	this.setManualComponents();
    }

    
    private void setManualComponents()
    {
    	final boolean b = !this.mDirectAccessFlag;
   		this.mManualRadioButton.setSelected(b);
    	this.mHostNameLabel.setEnabled(b);
    	this.mHostNameTextField.setEnabled(b);
    	this.mPortNumberLabel.setEnabled(b);
    	this.mPortNumberTextField.setEnabled(b);
    }

    
    /**
     * 
     * @param name
     */
    public void setHostName( final String name )
    {
    	this.mHostName = name;
    }


    /**
     * 
     * @param num
     */
    public void setPortNumber( final int num )
    {
    	this.mPortNumber = num;
    }


    /**
     * 
     */
    public void setVisible( final boolean b )
    {
    	this.mDirectAccessRadioButton.setSelected( this.mDirectAccessFlag );
    	this.mHostNameTextField.setText( this.mHostName );

    	String str = null;
    	if( this.mPortNumber > 0 )
    	{
    		str = Integer.toString( this.mPortNumber );
    	}
    	else
    	{
    		str = "";
    	}
    	this.mPortNumberTextField.setText( str );
    	super.setVisible(b);
    }


	/**
	 * 
	 */
	public void windowClosing(final WindowEvent e)
	{
		super.windowClosing(e);
		this.onCanceled();
	}

}

