/*
 * 쐬: 2005/08/25
 *
 */
package jp.riken.brain.ni.samuraigraph.application;

import java.io.InputStream;
import java.util.Properties;
import java.util.StringTokenizer;


public class SGApplicationProperties implements SGIApplicationConstants
{
	// version string
	private String mVersion = "-1.-1.-1";
	private int mMajorVersion = -1;
	private int mMinorVersion = -1;
	private int mMicroVersion = -1;
	
	private boolean mStatus = false;
	
	public SGApplicationProperties()
	{
	    this.mStatus = loadProperties();
	}
	
	public boolean getStatus()
	{
	    return this.mStatus;
	}
	
	/**
	 * get version string
	 * @return version
	 */
	public String getVersionString()
	{
	    return this.mVersion;
	}
	
	/**
	 * get major version
	 * @return major version
	 */
	public int getMajorVersion()
	{
	    return this.mMajorVersion;
	}
	
	/**
	 * get minor version
	 * @return minor version
	 */
	public int getMinorVersion()
	{
	    return this.mMinorVersion;
	}
	
	/**
	 * ger micro version
	 * @return micro version
	 */
	public int getMicroVersion()
	{
	    return this.mMicroVersion;
	}
	
	private boolean loadProperties()
	{
		try {
			Properties prop = new Properties();
			InputStream is = ClassLoader.getSystemResourceAsStream( APPLICATION_RESOURCE_DIRECTORY + "/" + APPLICATION_PROPERTY_FILENAME );
			prop.load( is );
			is.close();
			
			// version number
			String version = prop.getProperty( VERSION_PROPERTY_NAME );
			if( version == null ){
				return false;
			}
			// set version
			this.mVersion = version;
			StringTokenizer st = new StringTokenizer(version, ".");
			if (st.countTokens() != 3){
			    return false;
			}
			int major = Integer.valueOf(st.nextToken()).intValue();
			this.mMajorVersion = major;
			int minor = Integer.valueOf(st.nextToken()).intValue();
			this.mMinorVersion = minor;
			int micro = Integer.valueOf(st.nextToken()).intValue();
			this.mMicroVersion = micro;
		} catch (Exception e)
		{
			return false;
		}
		return true;
	}
}