@echo off

setlocal

set LOG_FILE=%cd%\samirai-graph.log

rem set directory

set CURRENT_PATH=%cd%\
set SCRIPT_PATH=%~d0%~p0
set CONTRIB_PATH=%SCRIPT_PATH%..\..
set TOOLS_PATH=%SCRIPT_PATH%..\..\..\tools

rem set absolute directory

cd /d %SCRIPT_PATH%
set SCRIPT_PATH=%cd%\
cd /d %CONTRIB_PATH%
set CONTRIB_PATH=%cd%\
cd /d %TOOLS_PATH%
set TOOLS_PATH=%cd%\
cd /d %CURRENT_PATH%

rem set done file

set DONE_FILE=%CONTRIB_PATH%_build_foxtrot_done

rem build depend jar files

rem class path
set CLASSPATH=

rem ant command
set ANT=%TOOLS_PATH%ant.bat

goto check_arguments

rem build functions

:build_foxtrot
set errcode=0
cd /d "%SCRIPT_PATH%"
if exist %DONE_FILE% goto build_foxtrot_done
  echo [foxtrot] creating foxtrot.jar ...
  call "%ANT%" > "%LOG_FILE%" 2>&1
  if errorlevel 0 goto build_foxtrot_success
  set errcode=1
  echo error
  type "%LOG_FILE%"
  goto build_foxtrot_clean
  :build_foxtrot_success
  copy nul "%DONE_FILE%" > nul 2>&1
  :build_foxtrot_clean
  del /f "%LOG_FILE%"
:build_foxtrot_done
cd /d "%CURRENT_PATH%"
goto %RETURN_LABEL%

:clean_foxtrot
set errcode=0
cd /d "%SCRIPT_PATH%"
if not exist %DONE_FILE% goto clean_foxtrot_done
echo [foxtrot] deleting foxtrot.jar ...
call "%ANT%" clean > "%LOG_FILE%" 2>&1
if errorlevel 0 goto clean_foxtrot_success
set errcode=1
echo error
type "%LOG_FILE%"
goto clean_foxtrot_clean
:clean_foxtrot_success
del /f "%DONE_FILE%"
:clean_foxtrot_clean
del /f "%LOG_FILE%"
:clean_foxtrot_done
cd /d "%CURRENT_PATH%"
goto %RETURN_LABEL%

:check_arguments
if "%1" == "" goto print_usage
if "%1" == "build" goto do_build
if "%1" == "rebuild" goto do_rebuild
if "%1" == "clean" goto do_clean

:print_usage
echo Usage: %0 { build, rebuild, clean }
goto finised

:do_build
set RETURN_LABEL=finised
goto build_foxtrot

:do_rebuild
set RETURN_LABEL=do_rebuild2
goto clean_foxtrot
:do_rebuild2
if %errcode% == 1 goto finised
set RETURN_LABEL=finised
goto build_foxtrot

:do_clean
set RETURN_LABEL=finised
goto clean_foxtrot

:finised

endlocal
