#!/bin/sh
CURRENT_PATH=`pwd`
SCRIPT_PATH=`dirname $0`
CONTRIB_PATH=$SCRIPT_PATH
VECTORGRAPHICS_PATH=$SCRIPT_PATH/vectorgraphics
FOXTROT_PATH=$SCRIPT_PATH/foxtrot

# function for getting absolute directory
get_absolute_dir() {
    current_dir=`pwd`
    cd "$1"
    absolute_dir=`pwd`
    cd $current_dir
    echo "$absolute_dir"
}

# set absolute directory
SCRIPT_PATH=`get_absolute_dir $SCRIPT_PATH`
CONTRIB_PATH=`get_absolute_dir $CONTRIB_PATH`
VECTORGRAPHICS_PATH=`get_absolute_dir $VECTORGRAPHICS_PATH`
FOXTROT_PATH=`get_absolute_dir $FOXTROT_PATH`

# build scripts
VECTORGRAPHICS_SCRIPT=$VECTORGRAPHICS_PATH/build.sh
FOXTROT_SCRIPT=$FOXTROT_PATH/build/build.sh

case "$1" in
rebuild)
  $VECTORGRAPHICS_SCRIPT rebuild
  $FOXTROT_SCRIPT rebuild
  ;;
build)
  $VECTORGRAPHICS_SCRIPT build
  $FOXTROT_SCRIPT build
  ;;
clean)
  $VECTORGRAPHICS_SCRIPT clean
  $FOXTROT_SCRIPT clean
  ;;
*)
  echo "Usage: ${0##*/}: { build | rebuild | clean }" 2>&1
  exit 65
  ;;
esac

exit 0
