#!/bin/sh

original=BrowserLauncher.java
original_newline=lf

cvsroot=:ext:cvs.sourceforge.jp:/cvsroot/samurai-graph
module=samurai-graph
srcdir=src/jp/riken/brain/ni/samuraigraph/base
srcfile=SGBrowserLauncher.java
src_newline=crlf

log=SAMURAIGRAPH-ChangeLog.txt
log_newline=crlf

# define which command
cmd_which () {
  COMMAND="$1"
  OUTPUT=
  IFS=:
  for dir in $PATH
  do
    if test -x "$dir/$COMMAND" ; then
      if test "x$OUTPUT" = "x" ; then
        OUTPUT="$dir/$COMMAND"
      fi
    fi
  done
  echo "$OUTPUT"
}
cmd_error () {
  COMMAND="$1"
  OUTPUT="$2"
  if test -z $OUTPUT; then
    echo "Error: $COMMAND not fould."
    exit
  fi
}

cvs=`cmd_which cvs`
cmd_error cvs $cvs
cvs2cl=`cmd_which cvs2cl`
cmd_error cvs2cl $cvs2cl
diff=`cmd_which diff`
cmd_error diff $diff
cat=`cmd_which cat`
cmd_error cat $cat
unix2dos=`cmd_which unix2dos`
cmd_error unix2dos $unix2dos
dos2unix=`cmd_which dos2unix`
cmd_error dos2unix $dos2unix

# set working directory
current_dir=`dirname $0`
cd $current_dir

# checkout current source
$cvs -z3 -d $cvsroot co -P $module/$srcdir/$srcfile > /dev/null 2>&1

# create change log
(cd $module/$srcdir && $cvs2cl $srcfile)
(cd $module/$srcdir && $unix2dos ChangeLog)

# copy original file to cvs directory
orig_work=$original
test $original = $srcfile && orig_work=$original.orig
cp $original $module/$srcdir/$orig_work

# convert newline code of source files to lf
if test $original_newline = crlf; then
  (cd $module/$srcdir && $dos2unix $orig_work)
fi
if test $src_newline = crlf; then
  (cd $module/$srcdir && $dos2unix $srcfile)
fi

# get diff
tmp=output.diff
(cd $module/$srcdir && diff -u $orig_work $srcfile > $tmp)
(cd $module/$srcdir && $unix2dos $tmp)

# append diff to changelog
(cd $module/$srcdir && $cat $tmp >> ChangeLog)

# copy log
cp $module/$srcdir/ChangeLog $log

test $log_newline = lf && $dos2unix $log

# cleanup
rm -rf $module
