/*
 * Decompiled with CFR 0.152.
 */
package jp.riken.brain.ni.samuraigraph.figure.java2d;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.BevelBorder;
import jp.riken.brain.ni.samuraigraph.base.SGColorSelectionButton;
import jp.riken.brain.ni.samuraigraph.base.SGIPropertyDialogObserver;
import jp.riken.brain.ni.samuraigraph.base.SGPropertyDialog;
import jp.riken.brain.ni.samuraigraph.base.SGSpinner;
import jp.riken.brain.ni.samuraigraph.base.SGTextField;
import jp.riken.brain.ni.samuraigraph.base.SGTwoAxesSelectionPanel;
import jp.riken.brain.ni.samuraigraph.base.SGUtility;
import jp.riken.brain.ni.samuraigraph.base.SGUtilityText;
import jp.riken.brain.ni.samuraigraph.figure.SGIStringConstants;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGILabelDialogObserver;

public class SGStringElementDialog
extends SGPropertyDialog
implements SGIStringConstants {
    private static final long serialVersionUID = -4468422972213746464L;
    public static final String TITLE = "Label Properties";
    private SGTwoAxesSelectionPanel mAxisPanel;
    private JPanel mButtonPanel;
    private JButton mCancelButton;
    private SGColorSelectionButton mColorButton;
    private JLabel mFontFamilyLabel;
    private JComboBox mFontNameComboBox;
    private JLabel mFontSizeLabel;
    private SGSpinner mFontSizeSpinner;
    private JComboBox mFontStyleComboBox;
    private JLabel mFontStyleLabel;
    private JLabel mLeftSpaceLabel;
    private JLabel mLocationLabel;
    private JSeparator mLocationSeparator;
    private JButton mOKButton;
    private JButton mPreviewButton;
    private JLabel mRightSpaceLabel;
    private JLabel mStringLabel;
    private JSeparator mStringSeparator;
    private JLabel mTextAngleLabel;
    private SGSpinner mTextAngleSpinner;
    private JLabel mTextColorLabel;
    private SGTextField mTextField;
    private JLabel mTextLabel;
    private JPanel mTextPanel;
    private JLabel mXValueLabel;
    private SGTextField mXValueTextField;
    private JLabel mYValueLabel;
    private SGTextField mYValueTextField;
    public static final double STRING_ANGLE_STEP = 1.0;

    public SGStringElementDialog(Frame frame, boolean bl) {
        super(frame, bl);
        this.initComponents();
        this.initProperty();
        this.initialize();
    }

    private void initComponents() {
        this.mTextPanel = new JPanel();
        this.mFontFamilyLabel = new JLabel();
        this.mFontStyleComboBox = new JComboBox();
        this.mFontSizeLabel = new JLabel();
        this.mTextAngleSpinner = new SGSpinner();
        this.mTextColorLabel = new JLabel();
        this.mTextAngleLabel = new JLabel();
        this.mFontSizeSpinner = new SGSpinner();
        this.mColorButton = new SGColorSelectionButton();
        this.mFontNameComboBox = new JComboBox();
        this.mRightSpaceLabel = new JLabel();
        this.mLeftSpaceLabel = new JLabel();
        this.mStringLabel = new JLabel();
        this.mStringSeparator = new JSeparator();
        this.mXValueLabel = new JLabel();
        this.mXValueTextField = new SGTextField();
        this.mYValueLabel = new JLabel();
        this.mYValueTextField = new SGTextField();
        this.mLocationLabel = new JLabel();
        this.mLocationSeparator = new JSeparator();
        this.mFontStyleLabel = new JLabel();
        this.mTextField = new SGTextField();
        this.mTextLabel = new JLabel();
        this.mButtonPanel = new JPanel();
        this.mOKButton = new JButton();
        this.mCancelButton = new JButton();
        this.mPreviewButton = new JButton();
        this.mAxisPanel = new SGTwoAxesSelectionPanel();
        this.getContentPane().setLayout(new GridBagLayout());
        this.mTextPanel.setLayout(new GridBagLayout());
        this.mTextPanel.setBorder(new BevelBorder(0));
        this.mFontFamilyLabel.setFont(new Font("Dialog", 0, 12));
        this.mFontFamilyLabel.setText("Family");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 15, 5, 5);
        this.mTextPanel.add((Component)this.mFontFamilyLabel, gridBagConstraints);
        this.mFontStyleComboBox.setFont(new Font("Dialog", 0, 12));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.mTextPanel.add((Component)this.mFontStyleComboBox, gridBagConstraints);
        this.mFontSizeLabel.setFont(new Font("Dialog", 0, 12));
        this.mFontSizeLabel.setText("Size");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 15, 10, 5);
        this.mTextPanel.add((Component)this.mFontSizeLabel, gridBagConstraints);
        this.mTextAngleSpinner.setFont(new Font("Dialog", 0, 12));
        this.mTextAngleSpinner.setPreferredSize(new Dimension(70, 22));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 10, 5);
        this.mTextPanel.add((Component)this.mTextAngleSpinner, gridBagConstraints);
        this.mTextColorLabel.setFont(new Font("Dialog", 0, 12));
        this.mTextColorLabel.setText("Color");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 20, 10, 5);
        this.mTextPanel.add((Component)this.mTextColorLabel, gridBagConstraints);
        this.mTextAngleLabel.setFont(new Font("Dialog", 0, 12));
        this.mTextAngleLabel.setText("Angle");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 20, 10, 5);
        this.mTextPanel.add((Component)this.mTextAngleLabel, gridBagConstraints);
        this.mFontSizeSpinner.setFont(new Font("Dialog", 0, 12));
        this.mFontSizeSpinner.setPreferredSize(new Dimension(70, 22));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 10, 5);
        this.mTextPanel.add((Component)this.mFontSizeSpinner, gridBagConstraints);
        this.mColorButton.setPreferredSize(new Dimension(65, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 10, 5);
        this.mTextPanel.add((Component)this.mColorButton, gridBagConstraints);
        this.mFontNameComboBox.setFont(new Font("Dialog", 0, 12));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.mTextPanel.add((Component)this.mFontNameComboBox, gridBagConstraints);
        this.mRightSpaceLabel.setText("    ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 7;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.mTextPanel.add((Component)this.mRightSpaceLabel, gridBagConstraints);
        this.mLeftSpaceLabel.setText("    ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.insets = new Insets(10, 0, 0, 0);
        this.mTextPanel.add((Component)this.mLeftSpaceLabel, gridBagConstraints);
        this.mStringLabel.setFont(new Font("Dialog", 3, 12));
        this.mStringLabel.setText("String");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.mTextPanel.add((Component)this.mStringLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(5, 45, 0, 0);
        this.mTextPanel.add((Component)this.mStringSeparator, gridBagConstraints);
        this.mXValueLabel.setFont(new Font("Dialog", 0, 12));
        this.mXValueLabel.setText("X");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 15, 5, 5);
        this.mTextPanel.add((Component)this.mXValueLabel, gridBagConstraints);
        this.mXValueTextField.setColumns(6);
        this.mXValueTextField.setFont(new Font("Dialog", 0, 12));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.mTextPanel.add((Component)this.mXValueTextField, gridBagConstraints);
        this.mYValueLabel.setFont(new Font("Dialog", 0, 12));
        this.mYValueLabel.setText("Y");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(5, 15, 5, 5);
        this.mTextPanel.add((Component)this.mYValueLabel, gridBagConstraints);
        this.mYValueTextField.setColumns(6);
        this.mYValueTextField.setFont(new Font("Dialog", 0, 12));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.mTextPanel.add((Component)this.mYValueTextField, gridBagConstraints);
        this.mLocationLabel.setFont(new Font("Dialog", 3, 12));
        this.mLocationLabel.setText("Location");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.mTextPanel.add((Component)this.mLocationLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(5, 4, 0, 0);
        this.mTextPanel.add((Component)this.mLocationSeparator, gridBagConstraints);
        this.mFontStyleLabel.setFont(new Font("Dialog", 0, 12));
        this.mFontStyleLabel.setText("Style");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 20, 5, 5);
        this.mTextPanel.add((Component)this.mFontStyleLabel, gridBagConstraints);
        this.mTextField.setColumns(16);
        this.mTextField.setFont(new Font("Dialog", 0, 12));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(10, 5, 5, 5);
        this.mTextPanel.add((Component)this.mTextField, gridBagConstraints);
        this.mTextLabel.setFont(new Font("Dialog", 0, 12));
        this.mTextLabel.setText("Text");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(10, 15, 5, 5);
        this.mTextPanel.add((Component)this.mTextLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.getContentPane().add((Component)this.mTextPanel, gridBagConstraints);
        this.mOKButton.setFont(new Font("Dialog", 1, 12));
        this.mOKButton.setText("OK");
        this.mButtonPanel.add(this.mOKButton);
        this.mCancelButton.setFont(new Font("Dialog", 1, 12));
        this.mCancelButton.setText("Cancel");
        this.mButtonPanel.add(this.mCancelButton);
        this.mPreviewButton.setFont(new Font("Dialog", 1, 12));
        this.mPreviewButton.setText("Preview");
        this.mButtonPanel.add(this.mPreviewButton);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 13;
        this.getContentPane().add((Component)this.mButtonPanel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        this.getContentPane().add((Component)this.mAxisPanel, gridBagConstraints);
        this.pack();
    }

    private boolean initProperty() {
        this.setTitle(TITLE);
        String[] stringArray = SGUtility.getAvailableFontFamilyNames();
        for (int i = 0; i < stringArray.length; ++i) {
            this.mFontNameComboBox.addItem(stringArray[i]);
        }
        String[] stringArray2 = new String[]{"Plain", "Italic", "Bold", "Bold Italic"};
        for (int i = 0; i < stringArray2.length; ++i) {
            this.mFontStyleComboBox.addItem(stringArray2[i]);
        }
        this.pack();
        this.mFontSizeSpinner.initProperties(SGStringElementDialog.getFontSizeSpinnerNumberModel(), "pt", 1, 2);
        this.mTextAngleSpinner.initProperties(new SpinnerNumberModel(0.0, -180.0, 180.0, 1.0), degree, 1, 2);
        this.mOKButton.addActionListener(this);
        this.mCancelButton.addActionListener(this);
        this.mPreviewButton.addActionListener(this);
        this.mFocusedColorSetButton = this.mColorButton;
        this.mTextField.setDescription("Text");
        this.mXValueTextField.setDescription("Location-> X");
        this.mYValueTextField.setDescription("Location-> Y");
        this.mFontSizeSpinner.setDescription("String-> Size");
        this.mTextAngleSpinner.setDescription("String-> Angle");
        return true;
    }

    public String getText() {
        return this.mTextField.getText();
    }

    public Number getXValue() {
        return this.getNumber(this.mXValueTextField);
    }

    public Number getYValue() {
        return this.getNumber(this.mYValueTextField);
    }

    public Number getFontSize() {
        return this.mFontSizeSpinner.getNumber();
    }

    public String getFontName() {
        return (String)this.mFontNameComboBox.getSelectedItem();
    }

    public int getFontStyle() {
        String string = (String)this.mFontStyleComboBox.getSelectedItem();
        return SGUtilityText.getFontStyle(string);
    }

    public Color getTextColor() {
        return this.mColorButton.getColor();
    }

    public Number getAngle() {
        return this.mTextAngleSpinner.getNumber();
    }

    public boolean setText(String string) {
        this.mTextField.setText(string);
        return true;
    }

    public boolean setFontSize(Object object) {
        return this.setValue(this.mFontSizeSpinner, object);
    }

    public boolean setFontName(String string) {
        this.mFontNameComboBox.setSelectedItem(string);
        return true;
    }

    public boolean setFontStyle(Integer n) {
        String string = null;
        if (n != null) {
            string = SGUtilityText.getFontStyleName(n);
        }
        this.mFontStyleComboBox.setSelectedItem(string);
        return true;
    }

    public boolean setTextColor(Color color) {
        this.mColorButton.setColor(color);
        return true;
    }

    public boolean setAngle(Object object) {
        return this.setValue(this.mTextAngleSpinner, object);
    }

    public boolean setXValue(Object object) {
        return this.setValue(this.mXValueTextField, object);
    }

    public boolean setYValue(Object object) {
        return this.setValue(this.mYValueTextField, object);
    }

    public List getColorSelectionButtonsList() {
        ArrayList<SGColorSelectionButton> arrayList = new ArrayList<SGColorSelectionButton>();
        arrayList.add(this.mColorButton);
        return arrayList;
    }

    public List getTextFieldComponentsList() {
        List list = this.getFormattedTextFieldsListFromSpinners();
        list.addAll(this.getNumberTextFieldList());
        list.add(this.mTextField);
        return list;
    }

    public List getNumberTextFieldList() {
        ArrayList<SGTextField> arrayList = new ArrayList<SGTextField>();
        arrayList.add(this.mXValueTextField);
        arrayList.add(this.mYValueTextField);
        return arrayList;
    }

    public List getSpinnerList() {
        ArrayList<SGSpinner> arrayList = new ArrayList<SGSpinner>();
        arrayList.add(this.mFontSizeSpinner);
        arrayList.add(this.mTextAngleSpinner);
        return arrayList;
    }

    public boolean setPropertiesToListeners(SGIPropertyDialogObserver sGIPropertyDialogObserver) {
        SGILabelDialogObserver sGILabelDialogObserver = (SGILabelDialogObserver)sGIPropertyDialogObserver;
        int n = this.mAxisPanel.getXAxisConfiguration();
        int n2 = this.mAxisPanel.getYAxisConfiguration();
        String string = this.getText();
        Number number = this.getXValue();
        Number number2 = this.getYValue();
        Number number3 = this.getFontSize();
        String string2 = this.getFontName();
        int n3 = this.getFontStyle();
        Number number4 = this.getAngle();
        Color color = this.getTextColor();
        ArrayList<String> arrayList = new ArrayList<String>();
        if (!sGILabelDialogObserver.hasValidXValue(n, number)) {
            arrayList.add("X");
        }
        if (!sGILabelDialogObserver.hasValidYValue(n2, number2)) {
            arrayList.add("Y");
        }
        if (arrayList.size() != 0) {
            String string3 = "Axis value is invalid.:\n";
            for (int i = 0; i < arrayList.size(); ++i) {
                String string4 = (String)arrayList.get(i);
                string3 = string3 + " - " + string4 + "\n";
            }
            this.setInputErrorMessage(string3);
            return false;
        }
        if (n != -1) {
            sGILabelDialogObserver.setXAxisLocation(n);
        }
        if (n2 != -1) {
            sGILabelDialogObserver.setYAxisLocation(n2);
        }
        if (string != null) {
            sGILabelDialogObserver.setString(string);
        }
        if (number != null) {
            sGILabelDialogObserver.setXValue(number.doubleValue());
        }
        if (number2 != null) {
            sGILabelDialogObserver.setYValue(number2.doubleValue());
        }
        if (number3 != null) {
            sGILabelDialogObserver.setFontSize(number3.floatValue(), "pt");
        }
        if (string2 != null) {
            sGILabelDialogObserver.setFontName(string2);
        }
        if (n3 != -1) {
            sGILabelDialogObserver.setFontStyle(n3);
        }
        if (number4 != null) {
            sGILabelDialogObserver.setAngle(number4.floatValue() * ((float)Math.PI / 180));
        }
        if (color != null) {
            sGILabelDialogObserver.setStringColor(color);
        }
        return true;
    }

    public boolean setDialogProperty() {
        List list = this.mPropertyDialogObserverList;
        if (!this.mAxisPanel.setSelected(list)) {
            return false;
        }
        SGILabelDialogObserver sGILabelDialogObserver = (SGILabelDialogObserver)list.get(0);
        String string = sGILabelDialogObserver.getString();
        double d = sGILabelDialogObserver.getXValue();
        double d2 = sGILabelDialogObserver.getYValue();
        String string2 = sGILabelDialogObserver.getFontName();
        float f = sGILabelDialogObserver.getFontSize("pt");
        int n = sGILabelDialogObserver.getFontStyle();
        float f2 = sGILabelDialogObserver.getAngle();
        Color color = sGILabelDialogObserver.getStringColor();
        String string3 = new String(string);
        Double d3 = new Double(d);
        Double d4 = new Double(d2);
        String string4 = new String(string2);
        Float f3 = new Float(f);
        Integer n2 = new Integer(n);
        Float f4 = new Float(f2);
        Color color2 = color;
        if (list.size() > 1) {
            String string5;
            SGILabelDialogObserver sGILabelDialogObserver2;
            int n3;
            for (n3 = 1; n3 < list.size(); ++n3) {
                sGILabelDialogObserver2 = (SGILabelDialogObserver)list.get(n3);
                string5 = sGILabelDialogObserver2.getString();
                if (string.equals(string5)) continue;
                string3 = null;
                break;
            }
            for (n3 = 1; n3 < list.size(); ++n3) {
                sGILabelDialogObserver2 = (SGILabelDialogObserver)list.get(n3);
                double d5 = sGILabelDialogObserver2.getXValue();
                if (d == d5) continue;
                d3 = null;
                break;
            }
            for (n3 = 1; n3 < list.size(); ++n3) {
                sGILabelDialogObserver2 = (SGILabelDialogObserver)list.get(n3);
                double d6 = sGILabelDialogObserver2.getYValue();
                if (d2 == d6) continue;
                d4 = null;
                break;
            }
            for (n3 = 1; n3 < list.size(); ++n3) {
                sGILabelDialogObserver2 = (SGILabelDialogObserver)list.get(n3);
                string5 = sGILabelDialogObserver2.getFontName();
                if (string2.equals(string5)) continue;
                string4 = null;
                break;
            }
            for (n3 = 1; n3 < list.size(); ++n3) {
                sGILabelDialogObserver2 = (SGILabelDialogObserver)list.get(n3);
                float f5 = sGILabelDialogObserver2.getFontSize("pt");
                if (f == f5) continue;
                f3 = null;
                break;
            }
            for (n3 = 1; n3 < list.size(); ++n3) {
                sGILabelDialogObserver2 = (SGILabelDialogObserver)list.get(n3);
                int n4 = sGILabelDialogObserver2.getFontStyle();
                if (n == n4) continue;
                n2 = null;
                break;
            }
            for (n3 = 1; n3 < list.size(); ++n3) {
                sGILabelDialogObserver2 = (SGILabelDialogObserver)list.get(n3);
                float f6 = sGILabelDialogObserver2.getAngle();
                if (f2 == f6) continue;
                f4 = null;
                break;
            }
            for (n3 = 1; n3 < list.size(); ++n3) {
                sGILabelDialogObserver2 = (SGILabelDialogObserver)list.get(n3);
                Color color3 = sGILabelDialogObserver2.getStringColor();
                if (color.equals(color3)) continue;
                color2 = null;
                break;
            }
        }
        this.setText(string3);
        this.setXValue(d3);
        this.setYValue(d4);
        this.setFontName(string4);
        this.setFontSize(f3);
        this.setFontStyle(n2);
        if (f4 != null) {
            f4 = new Float(f4.floatValue() / ((float)Math.PI / 180));
        }
        this.setAngle(f4);
        this.setTextColor(color2);
        this.setColorButtonBorder(true);
        return true;
    }

    protected boolean hasValidInputValues() {
        if (!super.hasValidInputValues()) {
            return false;
        }
        if (!this.mTextField.hasValidText()) {
            this.addInputErrorDescription(this.mTextField.getDescription());
            return false;
        }
        return true;
    }
}

