/*
 * Decompiled with CFR 0.152.
 */
package jp.riken.brain.ni.samuraigraph.figure.java2d;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JLabel;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import jp.riken.brain.ni.samuraigraph.base.SGAxis;
import jp.riken.brain.ni.samuraigraph.base.SGDrawingElement;
import jp.riken.brain.ni.samuraigraph.base.SGICopiable;
import jp.riken.brain.ni.samuraigraph.base.SGIDisposable;
import jp.riken.brain.ni.samuraigraph.base.SGIFigureElement;
import jp.riken.brain.ni.samuraigraph.base.SGIFigureElementAxis;
import jp.riken.brain.ni.samuraigraph.base.SGIFigureElementAxisBreak;
import jp.riken.brain.ni.samuraigraph.base.SGIFigureElementGraph;
import jp.riken.brain.ni.samuraigraph.base.SGIFigureElementGrid;
import jp.riken.brain.ni.samuraigraph.base.SGIFigureElementLegend;
import jp.riken.brain.ni.samuraigraph.base.SGIFigureElementShape;
import jp.riken.brain.ni.samuraigraph.base.SGIFigureElementSignificantDifference;
import jp.riken.brain.ni.samuraigraph.base.SGIFigureElementString;
import jp.riken.brain.ni.samuraigraph.base.SGIFigureElementTimingLine;
import jp.riken.brain.ni.samuraigraph.base.SGIMovable;
import jp.riken.brain.ni.samuraigraph.base.SGINode;
import jp.riken.brain.ni.samuraigraph.base.SGIPropertyDialogObserver;
import jp.riken.brain.ni.samuraigraph.base.SGISelectable;
import jp.riken.brain.ni.samuraigraph.base.SGIUndoable;
import jp.riken.brain.ni.samuraigraph.base.SGProperties;
import jp.riken.brain.ni.samuraigraph.base.SGPropertyDialog;
import jp.riken.brain.ni.samuraigraph.base.SGUndoManager;
import jp.riken.brain.ni.samuraigraph.base.SGUtility;
import jp.riken.brain.ni.samuraigraph.base.SGUtilityText;
import jp.riken.brain.ni.samuraigraph.figure.SGDrawingElementArrow;
import jp.riken.brain.ni.samuraigraph.figure.SGDrawingElementRectangle;
import jp.riken.brain.ni.samuraigraph.figure.SGFigureElement;
import jp.riken.brain.ni.samuraigraph.figure.SGIArrowConstants;
import jp.riken.brain.ni.samuraigraph.figure.SGIRectangleConstants;
import jp.riken.brain.ni.samuraigraph.figure.SGIShapeConstants;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGArrowDialog;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGDrawingElementArrow2D;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGDrawingElementRectangle2D;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGIArrowDialogObserver;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGIDrawingElementJava2D;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGIRectangularShapeDialogObserver;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGRectangularShapeDialog;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGUtilityForFigureElementJava2D;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SGFigureElementShape
extends SGFigureElement
implements SGIFigureElementShape,
SGIShapeConstants {
    private SGIFigureElementAxis mAxisElement = null;
    private SGRectangularShapeDialog mRectangularShapeDialog = null;
    private SGArrowDialog mArrowDialog = null;

    public void setAxisElement(SGIFigureElementAxis sGIFigureElementAxis) {
        this.mAxisElement = sGIFigureElementAxis;
    }

    public void dispose() {
        super.dispose();
        this.mAxisElement = null;
        this.mRectangularShapeDialog.dispose();
        this.mRectangularShapeDialog = null;
        this.mArrowDialog.dispose();
        this.mArrowDialog = null;
    }

    public SGIFigureElementAxis getAxisElement() {
        return this.mAxisElement;
    }

    public boolean setDialogOwner(Frame frame) {
        super.setDialogOwner(frame);
        this.createDialog();
        return true;
    }

    public String toString() {
        return "SGShapeElement";
    }

    private boolean createDialog() {
        SGArrowDialog sGArrowDialog;
        SGRectangularShapeDialog sGRectangularShapeDialog;
        this.mRectangularShapeDialog = sGRectangularShapeDialog = new SGRectangularShapeDialog(this.mDialogOwner, true);
        this.mArrowDialog = sGArrowDialog = new SGArrowDialog(this.mDialogOwner, true);
        return true;
    }

    public boolean synchronize(SGIFigureElement sGIFigureElement, String string) {
        boolean bl = true;
        if (!(sGIFigureElement instanceof SGIFigureElementGraph || sGIFigureElement instanceof SGIFigureElementString || sGIFigureElement instanceof SGIFigureElementLegend)) {
            if (sGIFigureElement instanceof SGIFigureElementAxis) {
                bl = this.synchronizeToAxisElement((SGIFigureElementAxis)sGIFigureElement, string);
            } else if (!(sGIFigureElement instanceof SGIFigureElementAxisBreak || sGIFigureElement instanceof SGIFigureElementSignificantDifference || sGIFigureElement instanceof SGIFigureElementTimingLine || sGIFigureElement instanceof SGIFigureElementGrid || sGIFigureElement instanceof SGIFigureElementShape)) {
                bl = sGIFigureElement.synchronizeArgument(this, string);
            }
        }
        return bl;
    }

    private boolean synchronizeToAxisElement(SGIFigureElementAxis sGIFigureElementAxis, String string) {
        ArrayList arrayList = this.getVisibleChildList();
        for (int i = 0; i < arrayList.size(); ++i) {
            ShapeObject shapeObject = (ShapeObject)arrayList.get(i);
            shapeObject.setShapeWithAxesValues();
        }
        return true;
    }

    public boolean synchronizeArgument(SGIFigureElement sGIFigureElement, String string) {
        throw new Error();
    }

    public boolean addShape(int n, int n2, int n3) {
        if (!this.getGraphRect().contains(n2, n3)) {
            return false;
        }
        SGAxis sGAxis = this.mAxisElement.getAxis("Bottom");
        SGAxis sGAxis2 = this.mAxisElement.getAxis("Left");
        float f = this.getMagnification();
        if (n == 0) {
            return this.addRectangle(sGAxis, sGAxis2, n2, n3);
        }
        if (n == 1) {
            return this.addEllipse(sGAxis, sGAxis2, n2, n3);
        }
        if (n == 2) {
            int n4 = n2 + (int)(f * 50.0f);
            int n5 = n3 + (int)(f * 40.0f);
            return this.addArrow(sGAxis, sGAxis2, n2, n3, n4, n5);
        }
        if (n == 3) {
            int n6 = n2 + (int)(f * 50.0f);
            int n7 = n3 + (int)(f * 40.0f);
            return this.addLine(sGAxis, sGAxis2, n2, n3, n6, n7);
        }
        return false;
    }

    private boolean addRectangle(SGAxis sGAxis, SGAxis sGAxis2, int n, int n2) {
        Rect rect = new Rect();
        rect.zoom(this.getMagnification());
        ShapeObject shapeObject = new ShapeObject(rect, sGAxis, sGAxis2);
        rect.setShapeObject(shapeObject);
        rect.setLocation(n, n2);
        rect.setAxisValuesWithShape();
        this.addShape(shapeObject);
        return true;
    }

    private boolean addEllipse(SGAxis sGAxis, SGAxis sGAxis2, int n, int n2) {
        Ellipse ellipse = new Ellipse();
        ellipse.zoom(this.getMagnification());
        ShapeObject shapeObject = new ShapeObject(ellipse, sGAxis, sGAxis2);
        ellipse.setShapeObject(shapeObject);
        ellipse.setLocation(n, n2);
        ellipse.setAxisValuesWithShape();
        this.addShape(shapeObject);
        return true;
    }

    private boolean addArrow(SGAxis sGAxis, SGAxis sGAxis2, int n, int n2, int n3, int n4) {
        Arrow arrow = new Arrow();
        return this.addArrow(arrow, -1, 10, sGAxis, sGAxis2, n, n2, n3, n4);
    }

    private boolean addLine(SGAxis sGAxis, SGAxis sGAxis2, int n, int n2, int n3, int n4) {
        Arrow arrow = new Arrow();
        return this.addArrow(arrow, -1, -1, sGAxis, sGAxis2, n, n2, n3, n4);
    }

    private boolean addArrow(Arrow arrow, int n, int n2, SGAxis sGAxis, SGAxis sGAxis2, int n3, int n4, int n5, int n6) {
        ShapeObject shapeObject = new ShapeObject(arrow, sGAxis, sGAxis2);
        arrow.zoom(this.getMagnification());
        arrow.setShapeObject(shapeObject);
        arrow.setStartHeadType(n);
        arrow.setEndHeadType(n2);
        arrow.setStartX(n3);
        arrow.setStartY(n4);
        arrow.setEndX(n5);
        arrow.setEndY(n6);
        arrow.setAxisValuesWithShape();
        this.addShape(shapeObject);
        return true;
    }

    private boolean addShape(ShapeObject shapeObject) {
        this.addToList(shapeObject);
        this.setChanged(true);
        shapeObject.initPropertiesHistory();
        this.notifyToRoot();
        return true;
    }

    private boolean clearFocusedObjectOtherThan(ShapeObject shapeObject) {
        Class<?> clazz = shapeObject.getIElement().getClass();
        ArrayList arrayList = this.getFocusedObjectsList();
        for (int i = 0; i < arrayList.size(); ++i) {
            ShapeObject shapeObject2 = (ShapeObject)arrayList.get(i);
            Class<?> clazz2 = shapeObject2.getIElement().getClass();
            if (!(!clazz2.isAssignableFrom(clazz) & !clazz.isAssignableFrom(clazz2))) continue;
            shapeObject2.setSelected(false);
        }
        return true;
    }

    public boolean zoom(float f) {
        super.zoom(f);
        List list = this.mChildList;
        for (int i = 0; i < list.size(); ++i) {
            ShapeObject shapeObject = (ShapeObject)list.get(i);
            shapeObject.zoom(f);
        }
        return true;
    }

    public boolean setGraphRect(float f, float f2, float f3, float f4) {
        if (!super.setGraphRect(f, f2, f3, f4)) {
            return false;
        }
        List list = this.mChildList;
        for (int i = 0; i < list.size(); ++i) {
            ShapeObject shapeObject = (ShapeObject)list.get(i);
            shapeObject.setShapeWithAxesValues();
        }
        return true;
    }

    public SGProperties getProperties() {
        ShapeElementProperties shapeElementProperties = new ShapeElementProperties();
        shapeElementProperties.visibleShapeList = this.getVisibleChildList();
        return shapeElementProperties;
    }

    public boolean setProperties(SGProperties sGProperties) {
        if (!(sGProperties instanceof ShapeElementProperties)) {
            return false;
        }
        ShapeElementProperties shapeElementProperties = (ShapeElementProperties)sGProperties;
        boolean bl = this.setVisibleChildList(shapeElementProperties.visibleShapeList);
        return bl;
    }

    public boolean setMementoBackward() {
        boolean bl = super.setMementoBackward();
        if (!bl) {
            return false;
        }
        this.clearFocusedObjects();
        this.notifyChangeOnUndo();
        return true;
    }

    public boolean setMementoForward() {
        boolean bl = super.setMementoForward();
        if (!bl) {
            return false;
        }
        this.clearFocusedObjects();
        this.notifyChangeOnUndo();
        return true;
    }

    public boolean duplicateFocusedObjects() {
        int n = (int)(this.mMagnification * 10.0f);
        int n2 = (int)(this.mMagnification * 10.0f);
        ArrayList arrayList = this.duplicateObjects();
        for (int i = 0; i < arrayList.size(); ++i) {
            ShapeObject shapeObject = (ShapeObject)arrayList.get(i);
            shapeObject.translate(n, n2);
            shapeObject.setSelected(true);
            this.addToList(shapeObject);
            shapeObject.initPropertiesHistory();
            int n3 = 0;
            ++n3;
        }
        if (arrayList.size() != 0) {
            this.setChanged(true);
        }
        return true;
    }

    public boolean paste(ArrayList arrayList) {
        float f = this.getMagnification();
        int n = (int)(f * 10.0f);
        int n2 = (int)(f * 10.0f);
        int n3 = 0;
        for (int i = 0; i < arrayList.size(); ++i) {
            Object e = arrayList.get(i);
            if (!(e instanceof ShapeObject)) continue;
            ShapeObject shapeObject = (ShapeObject)e;
            shapeObject.translate(n, n2);
            SGProperties sGProperties = shapeObject.getMemento();
            IElement iElement = (IElement)shapeObject.getIElement().copy();
            ShapeObject shapeObject2 = new ShapeObject(iElement);
            iElement.setShapeObject(shapeObject2);
            shapeObject2.setMagnification(f);
            shapeObject2.setMemento(sGProperties);
            shapeObject2.setXAxis(this.mAxisElement.getAxisInPlane(shapeObject.mTempXAxis));
            shapeObject2.setYAxis(this.mAxisElement.getAxisInPlane(shapeObject.mTempYAxis));
            shapeObject2.setShapeWithAxesValues();
            this.addToList(shapeObject2);
            shapeObject2.initPropertiesHistory();
            ++n3;
        }
        if (n3 != 0) {
            this.setChanged(true);
        }
        return true;
    }

    public String getTagName() {
        return "Shape";
    }

    public boolean writeProperty(Element element) {
        return true;
    }

    public boolean onKeyPressed(KeyEvent keyEvent) {
        boolean bl = false;
        int n = keyEvent.getKeyCode();
        int n2 = keyEvent.getModifiersEx();
        boolean bl2 = (n2 & 0x40) != 0;
        int n3 = 0;
        int n4 = 0;
        switch (n) {
            case 38: {
                if (bl2) {
                    n4 = -1;
                    break;
                }
                n4 = -10;
                break;
            }
            case 40: {
                if (bl2) {
                    n4 = 1;
                    break;
                }
                n4 = 10;
                break;
            }
            case 37: {
                if (bl2) {
                    n3 = -1;
                    break;
                }
                n3 = -10;
                break;
            }
            case 39: {
                n3 = bl2 ? 1 : 10;
            }
        }
        if (n3 != 0 || n4 != 0) {
            ArrayList arrayList = this.getVisibleChildList();
            for (int i = arrayList.size() - 1; i >= 0; --i) {
                ShapeObject shapeObject = (ShapeObject)arrayList.get(i);
                if (!shapeObject.isSelected()) continue;
                if (!this.setDirectlyBefore(shapeObject)) {
                    return false;
                }
                shapeObject.translate(n3, n4);
                if (!this.setDirectlyAfter(shapeObject)) {
                    return false;
                }
                bl = true;
            }
        }
        return bl;
    }

    public boolean onMouseClicked(MouseEvent mouseEvent) {
        ArrayList arrayList = this.getVisibleChildList();
        for (int i = arrayList.size() - 1; i >= 0; --i) {
            ShapeObject shapeObject = (ShapeObject)arrayList.get(i);
            if (!shapeObject.isValid() || !this.clickDrawingElements(shapeObject, mouseEvent)) continue;
            return true;
        }
        return false;
    }

    public ArrayList getPropertyDialogObserverList() {
        ArrayList arrayList = this.getFocusedObjectsList();
        ArrayList<IElement> arrayList2 = new ArrayList<IElement>();
        for (int i = 0; i < arrayList.size(); ++i) {
            ShapeObject shapeObject = (ShapeObject)arrayList.get(i);
            arrayList2.add(shapeObject.getIElement());
        }
        return arrayList2;
    }

    private boolean clickDrawingElements(ShapeObject shapeObject, MouseEvent mouseEvent) {
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        int n3 = mouseEvent.getClickCount();
        if (shapeObject.contains(n, n2)) {
            this.updateFocusedObjectsList((SGISelectable)shapeObject, mouseEvent);
            if (!(SwingUtilities.isLeftMouseButton(mouseEvent) & n3 == 1)) {
                if (SwingUtilities.isLeftMouseButton(mouseEvent) & n3 == 2) {
                    this.setPropertiesOfSelectedObjects();
                } else if (SwingUtilities.isRightMouseButton(mouseEvent) & n3 == 1) {
                    shapeObject.getPopupMenu().show(this.getComponent(), n, n2);
                }
            }
            return true;
        }
        return false;
    }

    public boolean onMousePressed(MouseEvent mouseEvent) {
        ArrayList arrayList = this.getVisibleChildList();
        for (int i = arrayList.size() - 1; i >= 0; --i) {
            ShapeObject shapeObject = (ShapeObject)arrayList.get(i);
            if (!shapeObject.isValid() || !shapeObject.press(mouseEvent)) continue;
            this.mPressedPoint = mouseEvent.getPoint();
            if (shapeObject.isSelected()) {
                this.mDraggableFlag = true;
            }
            return true;
        }
        return false;
    }

    public boolean onMouseDragged(MouseEvent mouseEvent) {
        if (this.mPressedPoint == null) {
            return false;
        }
        if (!this.mDraggableFlag) {
            return false;
        }
        ArrayList arrayList = this.getFocusedObjectsList();
        if (arrayList.size() == 1) {
            ShapeObject shapeObject = (ShapeObject)arrayList.get(0);
            if (!shapeObject.drag(mouseEvent)) {
                return false;
            }
            shapeObject.setAxisValuesWithShape();
        } else {
            int n = mouseEvent.getX() - this.mPressedPoint.x;
            int n2 = mouseEvent.getY() - this.mPressedPoint.y;
            for (int i = 0; i < arrayList.size(); ++i) {
                ShapeObject shapeObject = (ShapeObject)arrayList.get(i);
                if (!shapeObject.isValid()) continue;
                shapeObject.translate(n, n2);
                shapeObject.setAxisValuesWithShape();
            }
        }
        this.mPressedPoint = mouseEvent.getPoint();
        return true;
    }

    public boolean onMouseReleased(MouseEvent mouseEvent) {
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        ArrayList arrayList = this.getFocusedObjectsList();
        for (int i = 0; i < arrayList.size(); ++i) {
            ShapeObject shapeObject = (ShapeObject)arrayList.get(i);
            if (!shapeObject.isValid()) continue;
            if (shapeObject.contains(n, n2)) {
                this.setMouseCursor(12);
                continue;
            }
            this.setMouseCursor(0);
        }
        this.mDraggableFlag = false;
        this.notifyToRoot();
        return false;
    }

    public boolean onDrawingElement(int n, int n2) {
        ArrayList arrayList = this.getVisibleChildList();
        for (int i = arrayList.size() - 1; i >= 0; --i) {
            boolean bl;
            ShapeObject shapeObject = (ShapeObject)arrayList.get(i);
            if (!shapeObject.isValid() || !(bl = shapeObject.contains(n, n2))) continue;
            if (shapeObject.isSelected()) {
                int n3 = shapeObject.getMouseLocation(n, n2);
                shapeObject.mMouseLocation = n3;
                this.setMouseCursor(shapeObject.getCursor(n3));
                return true;
            }
            this.setMouseCursor(12);
            return true;
        }
        return false;
    }

    public Element createElement(Document document) {
        Element element = this.createThisElement(document);
        if (element == null) {
            return null;
        }
        ArrayList arrayList = this.getVisibleChildList();
        for (int i = 0; i < arrayList.size(); ++i) {
            ShapeObject shapeObject = (ShapeObject)arrayList.get(i);
            if (!shapeObject.isValid()) continue;
            Element element2 = shapeObject.createElement(document);
            if (element2 == null) {
                return null;
            }
            element.appendChild(element2);
        }
        return element;
    }

    public boolean readProperty(Element element) {
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (!(node instanceof Element)) continue;
            ShapeObject shapeObject = new ShapeObject();
            Element element2 = (Element)node;
            if (!shapeObject.readProperty(element2)) {
                return false;
            }
            shapeObject.initPropertiesHistory();
            this.addToList(shapeObject);
        }
        return true;
    }

    public boolean setTemporaryPropertiesOfFocusedObjects() {
        ArrayList arrayList = this.getFocusedObjectsList();
        for (int i = 0; i < arrayList.size(); ++i) {
            ShapeObject shapeObject = (ShapeObject)arrayList.get(i);
            shapeObject.mTemporaryProperties = shapeObject.getMemento();
        }
        return true;
    }

    public boolean setChangedFocusedObjects() {
        ArrayList arrayList = this.getFocusedObjectsList();
        for (int i = 0; i < arrayList.size(); ++i) {
            SGProperties sGProperties;
            ShapeObject shapeObject = (ShapeObject)arrayList.get(i);
            SGProperties sGProperties2 = shapeObject.mTemporaryProperties;
            if (sGProperties2 == null || (sGProperties = shapeObject.getMemento()).equals(sGProperties2)) continue;
            shapeObject.setChanged(true);
        }
        return true;
    }

    public void paintGraphics(Graphics graphics, boolean bl) {
        Object object;
        ShapeObject shapeObject;
        int n;
        Graphics2D graphics2D = (Graphics2D)graphics;
        ArrayList arrayList = this.getVisibleChildList();
        for (n = 0; n < arrayList.size(); ++n) {
            shapeObject = (ShapeObject)arrayList.get(n);
            if (!shapeObject.isValid()) continue;
            shapeObject.paintElement(graphics2D);
        }
        if (this.mSymbolsVisibleFlagAroundAllObjects) {
            for (n = 0; n < arrayList.size(); ++n) {
                shapeObject = (ShapeObject)arrayList.get(n);
                if (!shapeObject.isValid()) continue;
                object = shapeObject.getAnchorPointList();
                SGUtilityForFigureElementJava2D.drawAnchorAsChildObject((List)object, graphics2D);
            }
        }
        if (this.mSymbolsVisibleFlagAroundFocusedObjects) {
            ArrayList arrayList2 = new ArrayList();
            this.getFocusedObjectsList(arrayList2);
            for (int i = 0; i < arrayList2.size(); ++i) {
                object = (ShapeObject)arrayList2.get(i);
                if (!((ShapeObject)object).isValid()) continue;
                List list = ((ShapeObject)object).getAnchorPointList();
                SGUtilityForFigureElementJava2D.drawAnchorAsFocusedObject(list, graphics2D);
            }
        }
    }

    public ArrayList getChildNodes() {
        ArrayList<IElement> arrayList = new ArrayList<IElement>();
        ArrayList arrayList2 = new ArrayList(this.mChildList);
        for (int i = 0; i < arrayList2.size(); ++i) {
            ShapeObject shapeObject = (ShapeObject)arrayList2.get(i);
            if (!shapeObject.isVisible()) continue;
            arrayList.add(shapeObject.mElement);
        }
        return arrayList;
    }

    public String getClassDescription() {
        return "Shape";
    }

    private static boolean isInside(int n, int n2, int n3, int n4) {
        return Math.abs(n - n3) < 7 & Math.abs(n2 - n4) < 7;
    }

    protected Set getAvailableChildSet() {
        HashSet hashSet = new HashSet();
        List list = this.getMementoList();
        for (int i = 0; i < list.size(); ++i) {
            ShapeElementProperties shapeElementProperties = (ShapeElementProperties)list.get(i);
            hashSet.addAll(shapeElementProperties.visibleShapeList);
        }
        return hashSet;
    }

    private ShapeObject getShape(int n) {
        ShapeObject shapeObject = (ShapeObject)this.getChildObject(n);
        if (shapeObject == null) {
            return null;
        }
        if (!shapeObject.isVisible()) {
            return null;
        }
        return shapeObject;
    }

    private Rect getRectangularShape(int n) {
        ShapeObject shapeObject = this.getShape(n);
        if (shapeObject == null) {
            return null;
        }
        IElement iElement = shapeObject.mElement;
        if (iElement instanceof Rect) {
            return (Rect)iElement;
        }
        return null;
    }

    private Arrow getArrow(int n) {
        ShapeObject shapeObject = this.getShape(n);
        if (shapeObject == null) {
            return null;
        }
        IElement iElement = shapeObject.mElement;
        if (iElement instanceof Arrow) {
            return (Arrow)iElement;
        }
        return null;
    }

    private boolean setDirectlyBefore(IElement iElement) {
        return iElement.prepare();
    }

    private boolean setDirectlyAfter(IElement iElement) {
        if (!iElement.commit()) {
            return false;
        }
        this.notifyChange();
        this.notifyToRoot();
        this.repaint();
        return true;
    }

    public boolean setAxisXDirectly(int n, int n2) {
        ShapeObject shapeObject = this.getShape(n);
        if (shapeObject == null) {
            return false;
        }
        IElement iElement = shapeObject.mElement;
        if (!this.setDirectlyBefore(iElement)) {
            return false;
        }
        if (!shapeObject.setXAxis(n2)) {
            return false;
        }
        return this.setDirectlyAfter(iElement);
    }

    public boolean setAxisYDirectly(int n, int n2) {
        ShapeObject shapeObject = this.getShape(n);
        if (shapeObject == null) {
            return false;
        }
        IElement iElement = shapeObject.mElement;
        if (!this.setDirectlyBefore(iElement)) {
            return false;
        }
        if (!shapeObject.setYAxis(n2)) {
            return false;
        }
        return this.setDirectlyAfter(iElement);
    }

    public boolean setRectangleLeftXValueDirectly(int n, double d) {
        Rect rect = this.getRectangularShape(n);
        if (rect == null) {
            return false;
        }
        if (!this.setDirectlyBefore(rect)) {
            return false;
        }
        rect.setLeftXValue(d);
        return this.setDirectlyAfter(rect);
    }

    public boolean setRectangleRightXValueDirectly(int n, double d) {
        Rect rect = this.getRectangularShape(n);
        if (rect == null) {
            return false;
        }
        if (!this.setDirectlyBefore(rect)) {
            return false;
        }
        rect.setRightXValue(d);
        return this.setDirectlyAfter(rect);
    }

    public boolean setRectangleTopYValueDirectly(int n, double d) {
        Rect rect = this.getRectangularShape(n);
        if (rect == null) {
            return false;
        }
        if (!this.setDirectlyBefore(rect)) {
            return false;
        }
        rect.setTopYValue(d);
        return this.setDirectlyAfter(rect);
    }

    public boolean setRectangleBottomYValueDirectly(int n, double d) {
        Rect rect = this.getRectangularShape(n);
        if (rect == null) {
            return false;
        }
        if (!this.setDirectlyBefore(rect)) {
            return false;
        }
        rect.setBottomYValue(d);
        return this.setDirectlyAfter(rect);
    }

    public boolean setRectangleEdgeLineWidthDirectly(int n, float f, String string) {
        Rect rect = this.getRectangularShape(n);
        if (rect == null) {
            return false;
        }
        if (!this.setDirectlyBefore(rect)) {
            return false;
        }
        if (!rect.setLineWidth(f, string)) {
            return false;
        }
        return this.setDirectlyAfter(rect);
    }

    public boolean setRectangleEdgeLineTypeDirectly(int n, int n2) {
        Rect rect = this.getRectangularShape(n);
        if (rect == null) {
            return false;
        }
        if (!this.setDirectlyBefore(rect)) {
            return false;
        }
        if (!rect.setEdgeLineType(n2)) {
            return false;
        }
        return this.setDirectlyAfter(rect);
    }

    public boolean setRectangleEdgeLineColorDirectly(int n, Color color) {
        Rect rect = this.getRectangularShape(n);
        if (rect == null) {
            return false;
        }
        if (!this.setDirectlyBefore(rect)) {
            return false;
        }
        if (!rect.setEdgeLineColor(color)) {
            return false;
        }
        return this.setDirectlyAfter(rect);
    }

    public boolean setRectangleBackgroundColorDirectly(int n, Color color) {
        Rect rect = this.getRectangularShape(n);
        if (rect == null) {
            return false;
        }
        if (!this.setDirectlyBefore(rect)) {
            return false;
        }
        if (!rect.setInnerColor(color)) {
            return false;
        }
        return this.setDirectlyAfter(rect);
    }

    public boolean setRectangleBackgroundTransparentDirectly(int n, boolean bl) {
        Rect rect = this.getRectangularShape(n);
        if (rect == null) {
            return false;
        }
        if (!this.setDirectlyBefore(rect)) {
            return false;
        }
        if (!rect.setTransparent(bl)) {
            return false;
        }
        return this.setDirectlyAfter(rect);
    }

    public boolean setArrowStartXValueDirectly(int n, double d) {
        Arrow arrow = this.getArrow(n);
        if (arrow == null) {
            return false;
        }
        if (!this.setDirectlyBefore(arrow)) {
            return false;
        }
        if (!arrow.setStartXValue(d)) {
            return false;
        }
        return this.setDirectlyAfter(arrow);
    }

    public boolean setArrowStartYValueDirectly(int n, double d) {
        Arrow arrow = this.getArrow(n);
        if (arrow == null) {
            return false;
        }
        if (!this.setDirectlyBefore(arrow)) {
            return false;
        }
        if (!arrow.setStartYValue(d)) {
            return false;
        }
        return this.setDirectlyAfter(arrow);
    }

    public boolean setArrowEndXValueDirectly(int n, double d) {
        Arrow arrow = this.getArrow(n);
        if (arrow == null) {
            return false;
        }
        if (!this.setDirectlyBefore(arrow)) {
            return false;
        }
        if (!arrow.setEndXValue(d)) {
            return false;
        }
        return this.setDirectlyAfter(arrow);
    }

    public boolean setArrowEndYValueDirectly(int n, double d) {
        Arrow arrow = this.getArrow(n);
        if (arrow == null) {
            return false;
        }
        if (!this.setDirectlyBefore(arrow)) {
            return false;
        }
        if (!arrow.setEndYValue(d)) {
            return false;
        }
        return this.setDirectlyAfter(arrow);
    }

    public boolean setArrowLineWidthDirectly(int n, float f, String string) {
        Arrow arrow = this.getArrow(n);
        if (arrow == null) {
            return false;
        }
        if (!this.setDirectlyBefore(arrow)) {
            return false;
        }
        if (!arrow.setLineWidth(f, string)) {
            return false;
        }
        return this.setDirectlyAfter(arrow);
    }

    public boolean setArrowLineTypeDirectly(int n, int n2) {
        Arrow arrow = this.getArrow(n);
        if (arrow == null) {
            return false;
        }
        if (!this.setDirectlyBefore(arrow)) {
            return false;
        }
        if (!arrow.setLineType(n2)) {
            return false;
        }
        return this.setDirectlyAfter(arrow);
    }

    public boolean setArrowHeadSizeDirectly(int n, float f, String string) {
        Arrow arrow = this.getArrow(n);
        if (arrow == null) {
            return false;
        }
        if (!this.setDirectlyBefore(arrow)) {
            return false;
        }
        if (!arrow.setHeadSize(f, string)) {
            return false;
        }
        return this.setDirectlyAfter(arrow);
    }

    public boolean setArrowColorDirectly(int n, Color color) {
        Arrow arrow = this.getArrow(n);
        if (arrow == null) {
            return false;
        }
        if (!this.setDirectlyBefore(arrow)) {
            return false;
        }
        if (!arrow.setColor(color)) {
            return false;
        }
        return this.setDirectlyAfter(arrow);
    }

    public boolean setArrowStartTypeDirectly(int n, int n2) {
        Arrow arrow = this.getArrow(n);
        if (arrow == null) {
            return false;
        }
        if (!this.setDirectlyBefore(arrow)) {
            return false;
        }
        if (!arrow.setStartHeadType(n2)) {
            return false;
        }
        return this.setDirectlyAfter(arrow);
    }

    public boolean setArrowEndTypeDirectly(int n, int n2) {
        Arrow arrow = this.getArrow(n);
        if (arrow == null) {
            return false;
        }
        if (!this.setDirectlyBefore(arrow)) {
            return false;
        }
        if (!arrow.setEndHeadType(n2)) {
            return false;
        }
        return this.setDirectlyAfter(arrow);
    }

    public boolean setArrowOpenAngleDirectly(int n, float f) {
        Arrow arrow = this.getArrow(n);
        if (arrow == null) {
            return false;
        }
        if (!this.setDirectlyBefore(arrow)) {
            return false;
        }
        if (!arrow.setHeadOpenAngle(f)) {
            return false;
        }
        return this.setDirectlyAfter(arrow);
    }

    public boolean setArrowCloseAngleDirectly(int n, float f) {
        Arrow arrow = this.getArrow(n);
        if (arrow == null) {
            return false;
        }
        if (!this.setDirectlyBefore(arrow)) {
            return false;
        }
        if (!arrow.setHeadCloseAngle(f)) {
            return false;
        }
        return this.setDirectlyAfter(arrow);
    }

    private boolean setDirectlyBefore(ShapeObject shapeObject) {
        return shapeObject.prepare();
    }

    private boolean setDirectlyAfter(ShapeObject shapeObject) {
        if (!shapeObject.commit()) {
            return false;
        }
        this.notifyChange();
        this.notifyToRoot();
        this.repaint();
        return true;
    }

    private static class ArrowShapeProperties
    extends SGDrawingElementArrow.ArrowProperties
    implements PropertyWithAxes {
        private double mStartXValue = 0.0;
        private double mStartYValue = 0.0;
        private double mEndXValue = 0.0;
        private double mEndYValue = 0.0;
        private int mXAxisLocation = -1;
        private int mYAxisLocation = -1;

        public boolean equals(Object object) {
            if (!(object instanceof ArrowShapeProperties)) {
                return false;
            }
            if (!super.equals(object)) {
                return false;
            }
            ArrowShapeProperties arrowShapeProperties = (ArrowShapeProperties)object;
            if (arrowShapeProperties.mStartXValue != this.mStartXValue) {
                return false;
            }
            if (arrowShapeProperties.mStartYValue != this.mStartYValue) {
                return false;
            }
            if (arrowShapeProperties.mEndXValue != this.mEndXValue) {
                return false;
            }
            if (arrowShapeProperties.mEndYValue != this.mEndYValue) {
                return false;
            }
            if (this.mXAxisLocation != arrowShapeProperties.mXAxisLocation) {
                return false;
            }
            return this.mYAxisLocation == arrowShapeProperties.mYAxisLocation;
        }

        public Double getStartXValue() {
            return new Double(this.mStartXValue);
        }

        public Double getStartYValue() {
            return new Double(this.mStartYValue);
        }

        public Double getEndXValue() {
            return new Double(this.mEndXValue);
        }

        public Double getEndYValue() {
            return new Double(this.mEndYValue);
        }

        public int getXAxisLocation() {
            return this.mXAxisLocation;
        }

        public int getYAxisLocation() {
            return this.mYAxisLocation;
        }

        public boolean setStartXValue(double d) {
            this.mStartXValue = d;
            return true;
        }

        public boolean setStartYValue(double d) {
            this.mStartYValue = d;
            return true;
        }

        public boolean setEndXValue(double d) {
            this.mEndXValue = d;
            return true;
        }

        public boolean setEndYValue(double d) {
            this.mEndYValue = d;
            return true;
        }

        private boolean setXAxisLocation(int n) {
            this.mXAxisLocation = n;
            return true;
        }

        private boolean setYAxisLocation(int n) {
            this.mYAxisLocation = n;
            return true;
        }
    }

    private static class Arrow
    extends SGDrawingElementArrow2D
    implements IElement,
    SGIArrowConstants,
    SGIArrowDialogObserver {
        public static final String NAME = "Arrow";
        public static final String KEY_START_X_VALUE = "StartXValue";
        public static final String KEY_START_Y_VALUE = "StartYValue";
        public static final String KEY_END_X_VALUE = "EndXValue";
        public static final String KEY_END_Y_VALUE = "EndYValue";
        private float mStartX;
        private float mStartY;
        private float mEndX;
        private float mEndY;
        private double mStartXValue;
        private double mStartYValue;
        private double mEndXValue;
        private double mEndYValue;
        private ShapeObject mShape = null;
        private static final int START = 6;
        private static final int END = 8;
        private static final int BODY = 0;
        private SGProperties mTemporaryProperties = null;

        private Arrow() {
            this.init();
        }

        private boolean init() {
            this.setLineWidth(1.5f, "pt");
            this.setLineType(1);
            this.setColor(SGIShapeConstants.DEFAULT_SHAPE_ARROW_COLOR);
            this.setHeadSize(0.4f, "cm");
            this.setHeadOpenAngle(0.5235988f);
            this.setHeadCloseAngle(1.0471976f);
            return true;
        }

        public void dispose() {
            super.dispose();
            this.mShape.dispose();
            this.mShape = null;
            this.mTemporaryProperties = null;
        }

        protected SGFigureElementShape getShapeElement() {
            return this.mShape.getShapeElement();
        }

        public void setShapeObject(ShapeObject shapeObject) {
            this.mShape = shapeObject;
        }

        protected int getID() {
            return this.mShape.getID();
        }

        protected SGAxis getXAxis() {
            return this.mShape.getXAxis();
        }

        protected SGAxis getYAxis() {
            return this.mShape.getYAxis();
        }

        public int getMouseLocation(int n, int n2) {
            int n3 = (int)this.getStartX();
            int n4 = (int)this.getStartY();
            int n5 = (int)this.getEndX();
            int n6 = (int)this.getEndY();
            int n7 = -1;
            n7 = SGFigureElementShape.isInside(n3, n4, n, n2) ? 6 : (SGFigureElementShape.isInside(n5, n6, n, n2) ? 8 : 0);
            return n7;
        }

        public int getXAxisLocation() {
            return this.mShape.getAxisConfiguration(this.getXAxis());
        }

        public int getYAxisLocation() {
            return this.mShape.getAxisConfiguration(this.getYAxis());
        }

        public float getStartX() {
            return this.getShapeElement().getXFromGraphRectValue(this.mStartX);
        }

        public float getStartY() {
            return this.getShapeElement().getYFromGraphRectValue(this.mStartY);
        }

        public float getEndX() {
            return this.getShapeElement().getXFromGraphRectValue(this.mEndX);
        }

        public float getEndY() {
            return this.getShapeElement().getYFromGraphRectValue(this.mEndY);
        }

        public Color getColor() {
            return this.getColor(0);
        }

        public float getLineWidth(String string) {
            return (float)SGUtilityText.convertFromPoint(this.getLineWidth(), string);
        }

        public float getHeadSize(String string) {
            return (float)SGUtilityText.convertFromPoint(this.getHeadSize(), string);
        }

        public boolean setLineWidth(float f, String string) {
            double d = SGUtilityText.convert(f, string, "pt");
            if (d < 0.25) {
                return false;
            }
            if (d > 6.0) {
                return false;
            }
            return super.setLineWidth(f, string);
        }

        public boolean setHeadSize(float f, String string) {
            double d = SGUtilityText.convert(f, string, "cm");
            if (d < 0.05) {
                return false;
            }
            if (d > 2.0) {
                return false;
            }
            return super.setHeadSize(f, string);
        }

        public boolean setXAxisLocation(int n) {
            if (n != 0 & n != 1) {
                return false;
            }
            this.mShape.setXAxis(n);
            return true;
        }

        public boolean setYAxisLocation(int n) {
            if (n != 2 & n != 3) {
                return false;
            }
            this.mShape.setYAxis(n);
            return true;
        }

        public boolean setStartX(float f) {
            super.setStartX(f);
            this.mStartX = this.getShapeElement().getGraphRectValueX(f);
            return true;
        }

        public boolean setStartY(float f) {
            super.setStartY(f);
            this.mStartY = this.getShapeElement().getGraphRectValueY(f);
            return true;
        }

        public boolean setEndX(float f) {
            super.setEndX(f);
            this.mEndX = this.getShapeElement().getGraphRectValueX(f);
            return true;
        }

        public boolean setEndY(float f) {
            super.setEndY(f);
            this.mEndY = this.getShapeElement().getGraphRectValueY(f);
            return true;
        }

        public double getStartXValue() {
            return this.mStartXValue;
        }

        public double getStartYValue() {
            return this.mStartYValue;
        }

        public double getEndXValue() {
            return this.mEndXValue;
        }

        public double getEndYValue() {
            return this.mEndYValue;
        }

        public boolean setStartXValue(double d) {
            this.mStartXValue = d;
            return true;
        }

        public boolean setStartYValue(double d) {
            this.mStartYValue = d;
            return true;
        }

        public boolean setEndXValue(double d) {
            this.mEndXValue = d;
            return true;
        }

        public boolean setEndYValue(double d) {
            this.mEndYValue = d;
            return true;
        }

        public boolean hasValidStartXValue(int n, Number number) {
            SGIFigureElementAxis sGIFigureElementAxis = this.getShapeElement().getAxisElement();
            SGAxis sGAxis = n == -1 ? this.getXAxis() : sGIFigureElementAxis.getAxisInPlane(n);
            double d = number != null ? number.doubleValue() : this.getStartXValue();
            return sGAxis.isValidValue(d);
        }

        public boolean hasValidStartYValue(int n, Number number) {
            SGIFigureElementAxis sGIFigureElementAxis = this.getShapeElement().getAxisElement();
            SGAxis sGAxis = n == -1 ? this.getYAxis() : sGIFigureElementAxis.getAxisInPlane(n);
            double d = number != null ? number.doubleValue() : this.getStartYValue();
            return sGAxis.isValidValue(d);
        }

        public boolean hasValidEndXValue(int n, Number number) {
            SGIFigureElementAxis sGIFigureElementAxis = this.getShapeElement().getAxisElement();
            SGAxis sGAxis = n == -1 ? this.getXAxis() : sGIFigureElementAxis.getAxisInPlane(n);
            double d = number != null ? number.doubleValue() : this.getEndXValue();
            return sGAxis.isValidValue(d);
        }

        public boolean hasValidEndYValue(int n, Number number) {
            SGIFigureElementAxis sGIFigureElementAxis = this.getShapeElement().getAxisElement();
            SGAxis sGAxis = n == -1 ? this.mShape.getYAxis() : sGIFigureElementAxis.getAxisInPlane(n);
            double d = number != null ? number.doubleValue() : this.getEndYValue();
            return sGAxis.isValidValue(d);
        }

        public boolean hasValidAngle(Number number, Number number2) {
            float f = number != null ? number.floatValue() : this.getHeadOpenAngle();
            float f2 = number2 != null ? number2.floatValue() : this.getHeadCloseAngle();
            return f < f2;
        }

        public boolean setAxisValuesWithShape() {
            SGAxis sGAxis = this.getXAxis();
            SGAxis sGAxis2 = this.getYAxis();
            SGFigureElementShape sGFigureElementShape = this.getShapeElement();
            double d = sGFigureElementShape.calcValue(this.getStartX(), sGAxis, true);
            double d2 = sGFigureElementShape.calcValue(this.getStartY(), sGAxis2, false);
            double d3 = sGFigureElementShape.calcValue(this.getEndX(), sGAxis, true);
            double d4 = sGFigureElementShape.calcValue(this.getEndY(), sGAxis2, false);
            this.mStartXValue = sGFigureElementShape.getNumberInRangeOrder(d, sGAxis);
            this.mStartYValue = sGFigureElementShape.getNumberInRangeOrder(d2, sGAxis2);
            this.mEndXValue = sGFigureElementShape.getNumberInRangeOrder(d3, sGAxis);
            this.mEndYValue = sGFigureElementShape.getNumberInRangeOrder(d4, sGAxis2);
            return true;
        }

        public boolean setShapeWithAxesValues() {
            ShapeObject shapeObject = this.mShape;
            SGAxis sGAxis = this.getXAxis();
            SGAxis sGAxis2 = this.getYAxis();
            SGFigureElementShape sGFigureElementShape = this.getShapeElement();
            float f = sGFigureElementShape.calcLocation(this.mStartXValue, sGAxis, true);
            float f2 = sGFigureElementShape.calcLocation(this.mStartYValue, sGAxis2, false);
            float f3 = sGFigureElementShape.calcLocation(this.mEndXValue, sGAxis, true);
            float f4 = sGFigureElementShape.calcLocation(this.mEndYValue, sGAxis2, false);
            if (Float.isNaN(f) | Float.isNaN(f2) | Float.isNaN(f3) | Float.isNaN(f4)) {
                shapeObject.setValid(false);
                return false;
            }
            shapeObject.setValid(true);
            this.setStartX(f);
            this.setStartY(f2);
            this.setEndX(f3);
            this.setEndY(f4);
            return true;
        }

        public List getAnchorPointList() {
            ArrayList<Point2D.Float> arrayList = new ArrayList<Point2D.Float>();
            Point2D.Float float_ = new Point2D.Float(this.getStartX(), this.getStartY());
            Point2D.Float float_2 = new Point2D.Float(this.getEndX(), this.getEndY());
            arrayList.add(float_);
            arrayList.add(float_2);
            return arrayList;
        }

        public Object copy() {
            Arrow arrow = new Arrow();
            arrow.setShapeObject(this.mShape);
            arrow.setMagnification(this.getMagnification());
            arrow.setProperties(this.getProperties());
            arrow.setShapeWithAxesValues();
            return arrow;
        }

        public boolean drag(MouseEvent mouseEvent, Point point, int n) {
            int n2 = mouseEvent.getX() - point.x;
            int n3 = mouseEvent.getY() - point.y;
            point.setLocation(point.getX() + (double)n2, point.getY() + (double)n3);
            if (n == 6) {
                this.setStartX(this.getStartX() + (float)n2);
                this.setStartY(this.getStartY() + (float)n3);
            } else if (n == 8) {
                this.setEndX(this.getEndX() + (float)n2);
                this.setEndY(this.getEndY() + (float)n3);
            }
            return true;
        }

        public void translate(float f, float f2) {
            this.setStartX(this.getStartX() + f);
            this.setStartY(this.getStartY() + f2);
            this.setEndX(this.getEndX() + f);
            this.setEndY(this.getEndY() + f2);
            this.setAxisValuesWithShape();
        }

        public String getName() {
            return NAME;
        }

        public String getClassDescription() {
            return "";
        }

        public String getInstanceDescription() {
            SGIFigureElementAxis sGIFigureElementAxis = this.getShapeElement().getAxisElement();
            String string = sGIFigureElementAxis.getLocationName(this.getXAxis());
            String string2 = sGIFigureElementAxis.getLocationName(this.getYAxis());
            String string3 = "START=(" + this.mStartXValue + ", " + this.mStartYValue + ")";
            String string4 = "END=(" + this.mEndXValue + ", " + this.mEndYValue + ")";
            String string5 = this.getID() + ": " + this.getName() + ", ";
            string5 = string5 + string + ", " + string2 + ", " + string3 + ", " + string4;
            return string5;
        }

        public ArrayList getChildNodes() {
            return new ArrayList();
        }

        public SGProperties getMement() {
            return this.getProperties();
        }

        public boolean setMement(SGProperties sGProperties) {
            return this.setProperties(sGProperties);
        }

        public SGProperties getProperties() {
            ArrowShapeProperties arrowShapeProperties = new ArrowShapeProperties();
            if (!this.getProperties(arrowShapeProperties)) {
                return null;
            }
            return arrowShapeProperties;
        }

        public boolean getProperties(SGProperties sGProperties) {
            if (!(sGProperties instanceof ArrowShapeProperties)) {
                return false;
            }
            if (!super.getProperties(sGProperties)) {
                return false;
            }
            ArrowShapeProperties arrowShapeProperties = (ArrowShapeProperties)sGProperties;
            SGFigureElementShape sGFigureElementShape = this.getShapeElement();
            SGIFigureElementAxis sGIFigureElementAxis = sGFigureElementShape.getAxisElement();
            SGAxis sGAxis = this.getXAxis();
            SGAxis sGAxis2 = this.getYAxis();
            arrowShapeProperties.setXAxisLocation(sGIFigureElementAxis.getLocationInPlane(sGAxis));
            arrowShapeProperties.setYAxisLocation(sGIFigureElementAxis.getLocationInPlane(sGAxis2));
            arrowShapeProperties.setStartXValue(this.mStartXValue);
            arrowShapeProperties.setStartYValue(this.mStartYValue);
            arrowShapeProperties.setEndXValue(this.mEndXValue);
            arrowShapeProperties.setEndYValue(this.mEndYValue);
            return true;
        }

        public boolean setProperties(SGProperties sGProperties) {
            if (!(sGProperties instanceof ArrowShapeProperties)) {
                return false;
            }
            if (!super.setProperties(sGProperties)) {
                return false;
            }
            ArrowShapeProperties arrowShapeProperties = (ArrowShapeProperties)sGProperties;
            Double d = arrowShapeProperties.getStartXValue();
            if (d == null) {
                return false;
            }
            this.mStartXValue = d;
            Double d2 = arrowShapeProperties.getStartYValue();
            if (d2 == null) {
                return false;
            }
            this.mStartYValue = d2;
            Double d3 = arrowShapeProperties.getEndXValue();
            if (d3 == null) {
                return false;
            }
            this.mEndXValue = d3;
            Double d4 = arrowShapeProperties.getEndYValue();
            if (d4 == null) {
                return false;
            }
            this.mEndYValue = d4;
            return true;
        }

        public boolean prepare() {
            this.mTemporaryProperties = this.getProperties();
            return true;
        }

        public boolean commit() {
            SGProperties sGProperties = this.mTemporaryProperties;
            SGProperties sGProperties2 = this.getProperties();
            if (!sGProperties.equals(sGProperties2)) {
                this.mShape.setChanged(true);
            }
            this.setShapeWithAxesValues();
            SGFigureElementShape sGFigureElementShape = this.getShapeElement();
            sGFigureElementShape.repaint();
            sGFigureElementShape.notifyChange();
            return true;
        }

        public boolean cancel() {
            if (!this.setProperties(this.mTemporaryProperties)) {
                return false;
            }
            this.mTemporaryProperties = null;
            this.setShapeWithAxesValues();
            SGFigureElementShape sGFigureElementShape = this.getShapeElement();
            sGFigureElementShape.repaint();
            sGFigureElementShape.notifyChange();
            return true;
        }

        public boolean preview() {
            this.setShapeWithAxesValues();
            SGFigureElementShape sGFigureElementShape = this.getShapeElement();
            sGFigureElementShape.repaint();
            sGFigureElementShape.notifyChange();
            return true;
        }

        public SGPropertyDialog getPropertyDialog() {
            SGFigureElementShape sGFigureElementShape = this.getShapeElement();
            return sGFigureElementShape.mArrowDialog;
        }

        public boolean writeProperty(Element element) {
            if (!super.writeProperty(element)) {
                return false;
            }
            element.setAttribute(KEY_START_X_VALUE, Double.toString(this.getStartXValue()));
            element.setAttribute(KEY_START_Y_VALUE, Double.toString(this.getStartYValue()));
            element.setAttribute(KEY_END_X_VALUE, Double.toString(this.getEndXValue()));
            element.setAttribute(KEY_END_Y_VALUE, Double.toString(this.getEndYValue()));
            return true;
        }

        public boolean readProperty(Element element) {
            double d;
            if (!super.readProperty(element)) {
                return false;
            }
            String string = null;
            Double d2 = null;
            string = element.getAttribute(KEY_START_X_VALUE);
            if (string.length() != 0) {
                d2 = SGUtilityText.getDouble(string);
                if (d2 == null) {
                    return false;
                }
                d = d2;
                if (!this.setStartXValue(d)) {
                    return false;
                }
            }
            if ((string = element.getAttribute(KEY_START_Y_VALUE)).length() != 0) {
                d2 = SGUtilityText.getDouble(string);
                if (d2 == null) {
                    return false;
                }
                d = d2;
                if (!this.setStartYValue(d)) {
                    return false;
                }
            }
            if ((string = element.getAttribute(KEY_END_X_VALUE)).length() != 0) {
                d2 = SGUtilityText.getDouble(string);
                if (d2 == null) {
                    return false;
                }
                d = d2;
                if (!this.setEndXValue(d)) {
                    return false;
                }
            }
            if ((string = element.getAttribute(KEY_END_Y_VALUE)).length() != 0) {
                d2 = SGUtilityText.getDouble(string);
                if (d2 == null) {
                    return false;
                }
                d = d2;
                if (!this.setEndYValue(d)) {
                    return false;
                }
            }
            return true;
        }
    }

    private static class RectangularShapeProperties
    extends SGDrawingElementRectangle.RectangleProperties
    implements PropertyWithAxes {
        private double mXValue1 = 0.0;
        private double mYValue1 = 0.0;
        private double mXValue2 = 0.0;
        private double mYValue2 = 0.0;
        private int mXAxisLocation = -1;
        private int mYAxisLocation = -1;

        public boolean equals(Object object) {
            if (!(object instanceof RectangularShapeProperties)) {
                return false;
            }
            if (!super.equals(object)) {
                return false;
            }
            RectangularShapeProperties rectangularShapeProperties = (RectangularShapeProperties)object;
            if (rectangularShapeProperties.mXValue1 != this.mXValue1) {
                return false;
            }
            if (rectangularShapeProperties.mYValue1 != this.mYValue1) {
                return false;
            }
            if (rectangularShapeProperties.mXValue2 != this.mXValue2) {
                return false;
            }
            if (rectangularShapeProperties.mYValue2 != this.mYValue2) {
                return false;
            }
            if (this.mXAxisLocation != rectangularShapeProperties.mXAxisLocation) {
                return false;
            }
            return this.mYAxisLocation == rectangularShapeProperties.mYAxisLocation;
        }

        public Double getXValue1() {
            return new Double(this.mXValue1);
        }

        public Double getYValue1() {
            return new Double(this.mYValue1);
        }

        public Double getXValue2() {
            return new Double(this.mXValue2);
        }

        public Double getYValue2() {
            return new Double(this.mYValue2);
        }

        public int getXAxisLocation() {
            return this.mXAxisLocation;
        }

        public int getYAxisLocation() {
            return this.mYAxisLocation;
        }

        public boolean setXValue1(double d) {
            this.mXValue1 = d;
            return true;
        }

        public boolean setYValue1(double d) {
            this.mYValue1 = d;
            return true;
        }

        public boolean setXValue2(double d) {
            this.mXValue2 = d;
            return true;
        }

        public boolean setYValue2(double d) {
            this.mYValue2 = d;
            return true;
        }

        private boolean setXAxisLocation(int n) {
            this.mXAxisLocation = n;
            return true;
        }

        private boolean setYAxisLocation(int n) {
            this.mYAxisLocation = n;
            return true;
        }
    }

    private static class Ellipse
    extends Rect {
        public static final String NAME = "Ellipse";

        private Ellipse() {
        }

        protected Shape getRectShape() {
            Rectangle2D rectangle2D = this.getElementBounds();
            Ellipse2D.Float float_ = new Ellipse2D.Float((float)rectangle2D.getX(), (float)rectangle2D.getY(), (float)rectangle2D.getWidth(), (float)rectangle2D.getHeight());
            return float_;
        }

        public Object copy() {
            Ellipse ellipse = new Ellipse();
            ellipse.setShapeObject(this.getShapeObject());
            ellipse.setMagnification(this.getMagnification());
            ellipse.setProperties(this.getProperties());
            ellipse.setShapeWithAxesValues();
            return ellipse;
        }

        public String getName() {
            return NAME;
        }
    }

    private static class Rect
    extends SGDrawingElementRectangle2D
    implements IElement,
    SGIRectangleConstants,
    SGIRectangularShapeDialogObserver {
        public static final String NAME = "Rectangle";
        public static final String KEY_LEFT_X_VALUE = "LeftXValue";
        public static final String KEY_RIGHT_X_VALUE = "RightXValue";
        public static final String KEY_BOTTOM_Y_VALUE = "BottomYValue";
        public static final String KEY_TOP_Y_VALUE = "TopYValue";
        private ShapeObject mShape = null;
        private double mXValue1;
        private double mYValue1;
        private double mXValue2;
        private double mYValue2;
        private SGProperties mTemporaryProperties = null;

        private Rect() {
            this.init();
        }

        private boolean init() {
            this.setWidth(5.0f, "cm");
            this.setHeight(4.0f, "cm");
            this.setColor(SGIShapeConstants.DEFAULT_SHAPE_RECTANGLE_INNER_COLOR);
            this.setEdgeLineWidth(1.5f, "pt");
            this.setEdgeLineType(1);
            this.setEdgeLineColor(SGIShapeConstants.DEFAULT_SHAPE_RECTANGLE_EDGE_LINE_COLOR);
            return true;
        }

        public void dispose() {
            super.dispose();
            this.mShape.dispose();
            this.mShape = null;
            this.mTemporaryProperties = null;
        }

        protected ShapeObject getShapeObject() {
            return this.mShape;
        }

        public void setShapeObject(ShapeObject shapeObject) {
            this.mShape = shapeObject;
        }

        protected SGFigureElementShape getShapeElement() {
            return this.mShape.getShapeElement();
        }

        protected int getID() {
            return this.mShape.getID();
        }

        protected SGAxis getXAxis() {
            return this.mShape.getXAxis();
        }

        protected SGAxis getYAxis() {
            return this.mShape.getYAxis();
        }

        public float getLineWidth(String string) {
            return (float)SGUtilityText.convertFromPoint(this.getLineWidth(), string);
        }

        public boolean setLineWidth(float f, String string) {
            double d = SGUtilityText.convert(f, string, "pt");
            if (d < 0.25) {
                return false;
            }
            if (d > 6.0) {
                return false;
            }
            return this.setEdgeLineWidth((float)SGUtilityText.convertToPoint(f, string));
        }

        protected boolean isHorizontallyReversed() {
            return this.getWidth() < 0.0f;
        }

        protected boolean isPerpendicularlyReversed() {
            return this.getHeight() < 0.0f;
        }

        public float getX1() {
            return this.getShapeElement().getXFromGraphRectValue(super.getX());
        }

        public float getX() {
            return this.getX1();
        }

        public float getX2() {
            return this.getX1() + this.getMagnification() * this.getWidth();
        }

        public float getY1() {
            return this.getShapeElement().getYFromGraphRectValue(super.getY());
        }

        public float getY() {
            return this.getY1();
        }

        public float getY2() {
            return this.getY1() + this.getMagnification() * this.getHeight();
        }

        public float getLeftX() {
            return !this.isHorizontallyReversed() ? this.getX1() : this.getX2();
        }

        public float getRightX() {
            return !this.isHorizontallyReversed() ? this.getX2() : this.getX1();
        }

        public float getCenterX() {
            return this.getX1() + 0.5f * this.getMagnification() * this.getWidth();
        }

        public float getTopY() {
            return !this.isPerpendicularlyReversed() ? this.getY1() : this.getY2();
        }

        public float getBottomY() {
            return !this.isPerpendicularlyReversed() ? this.getY2() : this.getY1();
        }

        public float getCenterY() {
            return this.getY1() + 0.5f * this.getMagnification() * this.getHeight();
        }

        public void setLeftX(float f) {
            if (!this.isHorizontallyReversed()) {
                this.setX1(f);
            } else {
                this.setX2(f);
            }
        }

        public void setRightX(float f) {
            if (!this.isHorizontallyReversed()) {
                this.setX2(f);
            } else {
                this.setX1(f);
            }
        }

        public void setTopY(float f) {
            if (!this.isPerpendicularlyReversed()) {
                this.setY1(f);
            } else {
                this.setY2(f);
            }
        }

        public void setBottomY(float f) {
            if (!this.isPerpendicularlyReversed()) {
                this.setY2(f);
            } else {
                this.setY1(f);
            }
        }

        public boolean setX1(float f) {
            return this.setX(f);
        }

        public boolean setX2(float f) {
            return this.setX(f - this.getMagnification() * this.getWidth());
        }

        public boolean setY1(float f) {
            return this.setY(f);
        }

        public boolean setY2(float f) {
            return this.setY(f - this.getMagnification() * this.getHeight());
        }

        public boolean setX(float f) {
            return super.setX(this.getShapeElement().getGraphRectValueX(f));
        }

        public boolean setY(float f) {
            return super.setY(this.getShapeElement().getGraphRectValueY(f));
        }

        public boolean setShapeWithAxesValues() {
            ShapeObject shapeObject = this.mShape;
            SGAxis sGAxis = this.getXAxis();
            SGAxis sGAxis2 = this.getYAxis();
            SGFigureElementShape sGFigureElementShape = this.getShapeElement();
            float f = sGFigureElementShape.calcLocation(this.mXValue1, sGAxis, true);
            float f2 = sGFigureElementShape.calcLocation(this.mYValue1, sGAxis2, false);
            float f3 = sGFigureElementShape.calcLocation(this.mXValue2, sGAxis, true);
            float f4 = sGFigureElementShape.calcLocation(this.mYValue2, sGAxis2, false);
            if (Float.isNaN(f) | Float.isNaN(f2) | Float.isNaN(f3) | Float.isNaN(f4)) {
                shapeObject.setValid(false);
                return false;
            }
            shapeObject.setValid(true);
            float f5 = this.getMagnification();
            float f6 = (f3 - f) / f5;
            float f7 = (f4 - f2) / f5;
            this.setLocation(f, f2);
            this.setWidth(f6);
            this.setHeight(f7);
            return true;
        }

        public boolean setAxisValuesWithShape() {
            SGAxis sGAxis = this.getXAxis();
            SGAxis sGAxis2 = this.getYAxis();
            SGFigureElementShape sGFigureElementShape = this.getShapeElement();
            double d = sGFigureElementShape.calcValue(this.getX1(), sGAxis, true);
            double d2 = sGFigureElementShape.calcValue(this.getY1(), sGAxis2, false);
            double d3 = sGFigureElementShape.calcValue(this.getX2(), sGAxis, true);
            double d4 = sGFigureElementShape.calcValue(this.getY2(), sGAxis2, false);
            this.mXValue1 = sGFigureElementShape.getNumberInRangeOrder(d, sGAxis);
            this.mYValue1 = sGFigureElementShape.getNumberInRangeOrder(d2, sGAxis2);
            this.mXValue2 = sGFigureElementShape.getNumberInRangeOrder(d3, sGAxis);
            this.mYValue2 = sGFigureElementShape.getNumberInRangeOrder(d4, sGAxis2);
            return true;
        }

        public int getMouseLocation(int n, int n2) {
            int n3 = (int)this.getLeftX();
            int n4 = (int)this.getRightX();
            int n5 = (int)this.getTopY();
            int n6 = (int)this.getBottomY();
            int n7 = (int)this.getCenterX();
            int n8 = (int)this.getCenterY();
            int n9 = -1;
            if (SGFigureElementShape.isInside(n3, n5, n, n2)) {
                n9 = 5;
            } else if (SGFigureElementShape.isInside(n3, n8, n, n2)) {
                n9 = 3;
            } else if (SGFigureElementShape.isInside(n3, n6, n, n2)) {
                n9 = 7;
            } else if (SGFigureElementShape.isInside(n4, n5, n, n2)) {
                n9 = 6;
            } else if (SGFigureElementShape.isInside(n4, n8, n, n2)) {
                n9 = 4;
            } else if (SGFigureElementShape.isInside(n4, n6, n, n2)) {
                n9 = 8;
            } else if (SGFigureElementShape.isInside(n7, n5, n, n2)) {
                n9 = 1;
            } else if (SGFigureElementShape.isInside(n7, n6, n, n2)) {
                n9 = 2;
            } else if (this.getElementBounds().contains(n, n2)) {
                n9 = 0;
            }
            return n9;
        }

        public List getAnchorPointList() {
            ArrayList<Point2D.Float> arrayList = new ArrayList<Point2D.Float>();
            float f = this.getMagnification();
            float f2 = this.getX();
            float f3 = this.getY();
            float f4 = f * this.getWidth();
            float f5 = f * this.getHeight();
            float f6 = f2 + 0.5f * f4;
            float f7 = f3 + 0.5f * f5;
            Point2D.Float float_ = new Point2D.Float(f2, f3);
            Point2D.Float float_2 = new Point2D.Float(f2 + f4, f3);
            Point2D.Float float_3 = new Point2D.Float(f2, f3 + f5);
            Point2D.Float float_4 = new Point2D.Float(f2 + f4, f3 + f5);
            Point2D.Float float_5 = new Point2D.Float(f2, f7);
            Point2D.Float float_6 = new Point2D.Float(f2 + f4, f7);
            Point2D.Float float_7 = new Point2D.Float(f6, f3);
            Point2D.Float float_8 = new Point2D.Float(f6, f3 + f5);
            arrayList.add(float_);
            arrayList.add(float_2);
            arrayList.add(float_3);
            arrayList.add(float_4);
            arrayList.add(float_5);
            arrayList.add(float_6);
            arrayList.add(float_7);
            arrayList.add(float_8);
            return arrayList;
        }

        public boolean drag(MouseEvent mouseEvent, Point point, int n) {
            Rectangle2D rectangle2D = this.getElementBounds();
            SGUtility.resizeRectangle(rectangle2D, point, mouseEvent, n);
            float f = this.getMagnification();
            float f2 = (float)rectangle2D.getX();
            float f3 = (float)rectangle2D.getY();
            float f4 = (float)rectangle2D.getWidth() / f;
            float f5 = (float)rectangle2D.getHeight() / f;
            this.setWidth(f4);
            this.setHeight(f5);
            this.setLeftX(f2);
            this.setTopY(f3);
            return true;
        }

        public Object copy() {
            Rect rect = new Rect();
            rect.setShapeObject(this.mShape);
            rect.setMagnification(this.getMagnification());
            rect.setProperties(this.getProperties());
            rect.setShapeWithAxesValues();
            return rect;
        }

        public void translate(float f, float f2) {
            this.setLocation(this.getX() + f, this.getY() + f2);
            this.setAxisValuesWithShape();
        }

        public boolean contains(int n, int n2) {
            if (super.contains(n, n2)) {
                return true;
            }
            if (this.mShape.isSelected()) {
                int n3 = (int)this.getLeftX();
                int n4 = (int)this.getRightX();
                int n5 = (int)this.getTopY();
                int n6 = (int)this.getBottomY();
                int n7 = (int)this.getCenterX();
                int n8 = (int)this.getCenterY();
                boolean bl = SGFigureElementShape.isInside(n3, n5, n, n2) | SGFigureElementShape.isInside(n3, n8, n, n2) | SGFigureElementShape.isInside(n3, n6, n, n2) | SGFigureElementShape.isInside(n4, n5, n, n2) | SGFigureElementShape.isInside(n4, n8, n, n2) | SGFigureElementShape.isInside(n4, n6, n, n2) | SGFigureElementShape.isInside(n7, n5, n, n2) | SGFigureElementShape.isInside(n7, n6, n, n2);
                if (bl) {
                    return true;
                }
            }
            return false;
        }

        public String getName() {
            return NAME;
        }

        public String getClassDescription() {
            return "";
        }

        public String getInstanceDescription() {
            SGIFigureElementAxis sGIFigureElementAxis = this.getShapeElement().getAxisElement();
            String string = sGIFigureElementAxis.getLocationName(this.getXAxis());
            String string2 = sGIFigureElementAxis.getLocationName(this.getYAxis());
            String string3 = this.getID() + ": " + this.getName() + ", ";
            string3 = string3 + string + ", " + string2 + ", ";
            string3 = string3 + "( X=" + this.mXValue1 + ", Y=" + this.mYValue1 + " )";
            return string3;
        }

        public ArrayList getChildNodes() {
            return new ArrayList();
        }

        public SGProperties getProperties() {
            RectangularShapeProperties rectangularShapeProperties = new RectangularShapeProperties();
            if (!this.getProperties(rectangularShapeProperties)) {
                return null;
            }
            return rectangularShapeProperties;
        }

        public boolean getProperties(SGProperties sGProperties) {
            if (!(sGProperties instanceof RectangularShapeProperties)) {
                return false;
            }
            if (!super.getProperties(sGProperties)) {
                return false;
            }
            RectangularShapeProperties rectangularShapeProperties = (RectangularShapeProperties)sGProperties;
            SGFigureElementShape sGFigureElementShape = this.getShapeElement();
            SGIFigureElementAxis sGIFigureElementAxis = sGFigureElementShape.getAxisElement();
            SGAxis sGAxis = this.getXAxis();
            SGAxis sGAxis2 = this.getYAxis();
            rectangularShapeProperties.setXAxisLocation(sGIFigureElementAxis.getLocationInPlane(sGAxis));
            rectangularShapeProperties.setYAxisLocation(sGIFigureElementAxis.getLocationInPlane(sGAxis2));
            rectangularShapeProperties.setXValue1(this.mXValue1);
            rectangularShapeProperties.setYValue1(this.mYValue1);
            rectangularShapeProperties.setXValue2(this.mXValue2);
            rectangularShapeProperties.setYValue2(this.mYValue2);
            return true;
        }

        public boolean setProperties(SGProperties sGProperties) {
            if (!(sGProperties instanceof RectangularShapeProperties)) {
                return false;
            }
            if (!super.setProperties(sGProperties)) {
                return false;
            }
            RectangularShapeProperties rectangularShapeProperties = (RectangularShapeProperties)sGProperties;
            Double d = rectangularShapeProperties.getXValue1();
            if (d == null) {
                return false;
            }
            this.mXValue1 = d;
            Double d2 = rectangularShapeProperties.getYValue1();
            if (d2 == null) {
                return false;
            }
            this.mYValue1 = d2;
            Double d3 = rectangularShapeProperties.getXValue2();
            if (d3 == null) {
                return false;
            }
            this.mXValue2 = d3;
            Double d4 = rectangularShapeProperties.getYValue2();
            if (d4 == null) {
                return false;
            }
            this.mYValue2 = d4;
            return true;
        }

        public SGProperties getMement() {
            return this.getProperties();
        }

        public boolean setMement(SGProperties sGProperties) {
            return this.setProperties(sGProperties);
        }

        public double getLeftXValue() {
            return !this.isHorizontallyReversed() ? this.mXValue1 : this.mXValue2;
        }

        public double getTopYValue() {
            return !this.isPerpendicularlyReversed() ? this.mYValue1 : this.mYValue2;
        }

        public double getRightXValue() {
            return !this.isHorizontallyReversed() ? this.mXValue2 : this.mXValue1;
        }

        public double getBottomYValue() {
            return !this.isPerpendicularlyReversed() ? this.mYValue2 : this.mYValue1;
        }

        public float getLineWidth() {
            return this.getEdgeLineWidth();
        }

        public int getLineType() {
            return this.getEdgeLineType();
        }

        public Color getInnerColor() {
            return this.getColor(0);
        }

        public Color getLineColor() {
            return this.getEdgeLineColor();
        }

        public void setLeftXValue(double d) {
            if (!this.isHorizontallyReversed()) {
                this.mXValue1 = d;
            } else {
                this.mXValue2 = d;
            }
        }

        public void setTopYValue(double d) {
            if (!this.isPerpendicularlyReversed()) {
                this.mYValue1 = d;
            } else {
                this.mYValue2 = d;
            }
        }

        public void setRightXValue(double d) {
            if (!this.isHorizontallyReversed()) {
                this.mXValue2 = d;
            } else {
                this.mXValue1 = d;
            }
        }

        public void setBottomYValue(double d) {
            if (!this.isPerpendicularlyReversed()) {
                this.mYValue2 = d;
            } else {
                this.mYValue1 = d;
            }
        }

        public boolean setLineType(int n) {
            return this.setEdgeLineType(n);
        }

        public boolean setInnerColor(Color color) {
            return this.setColor(color);
        }

        public boolean setLineColor(Color color) {
            return this.setEdgeLineColor(color);
        }

        public int getXAxisLocation() {
            return this.mShape.getAxisConfiguration(this.getXAxis());
        }

        public int getYAxisLocation() {
            return this.mShape.getAxisConfiguration(this.getYAxis());
        }

        public boolean setXAxisLocation(int n) {
            if (n != 0 & n != 1) {
                return false;
            }
            this.mShape.setXAxis(n);
            return true;
        }

        public boolean setYAxisLocation(int n) {
            if (n != 2 & n != 3) {
                return false;
            }
            this.mShape.setYAxis(n);
            return true;
        }

        public boolean hasValidLeftXValue(int n, Number number) {
            SGIFigureElementAxis sGIFigureElementAxis = this.getShapeElement().getAxisElement();
            SGAxis sGAxis = n == -1 ? this.getXAxis() : sGIFigureElementAxis.getAxisInPlane(n);
            double d = number != null ? number.doubleValue() : this.getLeftXValue();
            return sGAxis.isValidValue(d);
        }

        public boolean hasValidTopYValue(int n, Number number) {
            SGIFigureElementAxis sGIFigureElementAxis = this.getShapeElement().getAxisElement();
            SGAxis sGAxis = n == -1 ? this.mShape.getYAxis() : sGIFigureElementAxis.getAxisInPlane(n);
            double d = number != null ? number.doubleValue() : this.getTopYValue();
            return sGAxis.isValidValue(d);
        }

        public boolean hasValidRightXValue(int n, Number number) {
            SGIFigureElementAxis sGIFigureElementAxis = this.getShapeElement().getAxisElement();
            SGAxis sGAxis = n == -1 ? this.getXAxis() : sGIFigureElementAxis.getAxisInPlane(n);
            double d = number != null ? number.doubleValue() : this.getRightXValue();
            return sGAxis.isValidValue(d);
        }

        public boolean hasValidBottomYValue(int n, Number number) {
            SGIFigureElementAxis sGIFigureElementAxis = this.getShapeElement().getAxisElement();
            SGAxis sGAxis = n == -1 ? this.getYAxis() : sGIFigureElementAxis.getAxisInPlane(n);
            double d = number != null ? number.doubleValue() : this.getBottomYValue();
            return sGAxis.isValidValue(d);
        }

        public boolean prepare() {
            this.mTemporaryProperties = this.getProperties();
            return true;
        }

        public boolean commit() {
            SGProperties sGProperties = this.mTemporaryProperties;
            SGProperties sGProperties2 = this.getProperties();
            if (!sGProperties.equals(sGProperties2)) {
                this.mShape.setChanged(true);
            }
            this.setShapeWithAxesValues();
            SGFigureElementShape sGFigureElementShape = this.getShapeElement();
            sGFigureElementShape.repaint();
            sGFigureElementShape.notifyChange();
            return true;
        }

        public boolean cancel() {
            if (!this.setProperties(this.mTemporaryProperties)) {
                return false;
            }
            this.mTemporaryProperties = null;
            this.setShapeWithAxesValues();
            SGFigureElementShape sGFigureElementShape = this.getShapeElement();
            sGFigureElementShape.repaint();
            sGFigureElementShape.notifyChange();
            return true;
        }

        public boolean preview() {
            this.setShapeWithAxesValues();
            SGFigureElementShape sGFigureElementShape = this.getShapeElement();
            sGFigureElementShape.repaint();
            sGFigureElementShape.notifyChange();
            return true;
        }

        public SGPropertyDialog getPropertyDialog() {
            SGFigureElementShape sGFigureElementShape = this.getShapeElement();
            return sGFigureElementShape.mRectangularShapeDialog;
        }

        public void dump() {
            System.out.println(this.mXValue1 + "  " + this.mXValue2);
            System.out.println(this.mYValue1 + "  " + this.mYValue2);
            System.out.println();
        }

        public boolean writeProperty(Element element) {
            if (!super.writeProperty(element)) {
                return false;
            }
            element.setAttribute(KEY_LEFT_X_VALUE, Double.toString(this.getLeftXValue()));
            element.setAttribute(KEY_RIGHT_X_VALUE, Double.toString(this.getRightXValue()));
            element.setAttribute(KEY_BOTTOM_Y_VALUE, Double.toString(this.getBottomYValue()));
            element.setAttribute(KEY_TOP_Y_VALUE, Double.toString(this.getTopYValue()));
            return true;
        }

        public boolean readProperty(Element element) {
            double d;
            if (!super.readProperty(element)) {
                return false;
            }
            String string = null;
            Double d2 = null;
            SGAxis sGAxis = this.getXAxis();
            SGAxis sGAxis2 = this.getYAxis();
            string = element.getAttribute(KEY_LEFT_X_VALUE);
            if (string.length() != 0) {
                d2 = SGUtilityText.getDouble(string);
                if (d2 == null) {
                    return false;
                }
                d = d2;
                if (!sGAxis.isValidValue(d)) {
                    return false;
                }
                this.setLeftXValue(d);
            }
            if ((string = element.getAttribute(KEY_RIGHT_X_VALUE)).length() != 0) {
                d2 = SGUtilityText.getDouble(string);
                if (d2 == null) {
                    return false;
                }
                d = d2;
                if (!sGAxis.isValidValue(d)) {
                    return false;
                }
                this.setRightXValue(d);
            }
            if ((string = element.getAttribute(KEY_BOTTOM_Y_VALUE)).length() != 0) {
                d2 = SGUtilityText.getDouble(string);
                if (d2 == null) {
                    return false;
                }
                d = d2;
                if (!sGAxis2.isValidValue(d)) {
                    return false;
                }
                this.setBottomYValue(d);
            }
            if ((string = element.getAttribute(KEY_TOP_Y_VALUE)).length() != 0) {
                d2 = SGUtilityText.getDouble(string);
                if (d2 == null) {
                    return false;
                }
                d = d2;
                if (!sGAxis2.isValidValue(d)) {
                    return false;
                }
                this.setTopYValue(d);
            }
            return true;
        }
    }

    private class ShapeObject
    extends SGDrawingElement
    implements SGIUndoable,
    SGISelectable,
    SGIMovable,
    SGICopiable,
    ActionListener,
    SGIDisposable,
    SGFigureElement.ChildObject {
        private int mID;
        private SGAxis mXAxis;
        private SGAxis mYAxis;
        private IElement mElement = null;
        private SGUndoManager mUndoManager = new SGUndoManager(this);
        private int mTempXAxis = -1;
        private int mTempYAxis = -1;
        private SGProperties mTemporaryProperties = null;
        private JPopupMenu mPopupMenu = new JPopupMenu();
        private boolean mValidFlag = true;
        private int mMouseLocation;
        private boolean mSelectedFlag = false;

        public int getID() {
            return this.mID;
        }

        public boolean setID(int n) {
            this.mID = n;
            return true;
        }

        private ShapeObject() {
            this.init();
        }

        private ShapeObject(IElement iElement) {
            this.setIElement(iElement);
            this.init();
        }

        private ShapeObject(IElement iElement, SGAxis sGAxis, SGAxis sGAxis2) {
            this.setIElement(iElement);
            this.setXAxis(sGAxis);
            this.setYAxis(sGAxis2);
            this.init();
        }

        private void init() {
            this.createPopupMenu();
        }

        public void finalize() {
        }

        public void dispose() {
            super.dispose();
            this.mElement.dispose();
            this.mElement = null;
            this.mPopupMenu = null;
            this.mTemporaryProperties = null;
            this.mUndoManager.dispose();
            this.mUndoManager = null;
            this.mXAxis = null;
            this.mYAxis = null;
        }

        private boolean createPopupMenu() {
            JPopupMenu jPopupMenu = this.mPopupMenu;
            jPopupMenu.setBounds(0, 0, 100, 100);
            jPopupMenu.add(new JLabel("  -- Significant Difference --"));
            jPopupMenu.addSeparator();
            SGUtility.addItem(jPopupMenu, this, "Move to Front");
            SGUtility.addItem(jPopupMenu, this, "Move to Back");
            jPopupMenu.addSeparator();
            SGUtility.addItem(jPopupMenu, this, "Cut");
            SGUtility.addItem(jPopupMenu, this, "Copy");
            SGUtility.addItem(jPopupMenu, this, "Paste");
            jPopupMenu.addSeparator();
            SGUtility.addItem(jPopupMenu, this, "Delete");
            SGUtility.addItem(jPopupMenu, this, "Duplicate");
            jPopupMenu.addSeparator();
            SGUtility.addItem(jPopupMenu, this, "Property");
            return true;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if (string.equals("Property")) {
                SGFigureElementShape.this.clearFocusedObjectOtherThan(this);
                SGFigureElementShape.this.setPropertiesOfSelectedObjects();
            } else if (string.equals("Copy") | string.equals("Cut") | string.equals("Paste") | string.equals("Delete") | string.equals("Duplicate") | string.equals("Move to Front") | string.equals("Move to Back")) {
                SGFigureElementShape.this.notifyToListener(string);
            }
        }

        public boolean prepare() {
            return this.mElement.prepare();
        }

        public boolean commit() {
            return this.mElement.commit();
        }

        public IElement getIElement() {
            return this.mElement;
        }

        public void setIElement(IElement iElement) {
            this.mElement = iElement;
        }

        private SGFigureElementShape getShapeElement() {
            return SGFigureElementShape.this;
        }

        private SGIFigureElementAxis getAxisElement() {
            return this.getShapeElement().getAxisElement();
        }

        public SGAxis getXAxis() {
            return this.mXAxis;
        }

        public SGAxis getYAxis() {
            return this.mYAxis;
        }

        public void setXAxis(SGAxis sGAxis) {
            this.mXAxis = sGAxis;
        }

        public void setYAxis(SGAxis sGAxis) {
            this.mYAxis = sGAxis;
        }

        private SGDrawingElement getDrawingElement() {
            return (SGDrawingElement)((Object)this.mElement);
        }

        private SGIDrawingElementJava2D getDrawingElement2D() {
            return (SGIDrawingElementJava2D)((Object)this.mElement);
        }

        public void setVisible(boolean bl) {
            super.setVisible(bl);
            this.getDrawingElement().setVisible(bl);
        }

        private void paintElement(Graphics2D graphics2D) {
            if (this.isValid()) {
                this.getDrawingElement2D().paintElement(graphics2D);
            }
        }

        public boolean zoom(float f) {
            return this.getDrawingElement().zoom(f);
        }

        public boolean isValid() {
            return this.mValidFlag;
        }

        public void setValid(boolean bl) {
            this.mValidFlag = bl;
        }

        public boolean setAxisValuesWithShape() {
            return this.mElement.setAxisValuesWithShape();
        }

        public boolean setShapeWithAxesValues() {
            return this.mElement.setShapeWithAxesValues();
        }

        public boolean contains(int n, int n2) {
            return ((SGDrawingElement)((Object)this.mElement)).contains(n, n2);
        }

        public JPopupMenu getPopupMenu() {
            return this.mPopupMenu;
        }

        private List getAnchorPointList() {
            return this.mElement.getAnchorPointList();
        }

        private int getMouseLocation(int n, int n2) {
            return this.mElement.getMouseLocation(n, n2);
        }

        private Cursor getCursor(int n) {
            Cursor cursor = null;
            switch (n) {
                case 1: {
                    cursor = new Cursor(8);
                    break;
                }
                case 2: {
                    cursor = new Cursor(9);
                    break;
                }
                case 3: {
                    cursor = new Cursor(10);
                    break;
                }
                case 4: {
                    cursor = new Cursor(11);
                    break;
                }
                case 5: {
                    cursor = new Cursor(6);
                    break;
                }
                case 7: {
                    cursor = new Cursor(4);
                    break;
                }
                case 6: {
                    cursor = new Cursor(7);
                    break;
                }
                case 8: {
                    cursor = new Cursor(5);
                    break;
                }
                default: {
                    cursor = new Cursor(12);
                }
            }
            return cursor;
        }

        private boolean press(MouseEvent mouseEvent) {
            int n;
            int n2 = mouseEvent.getX();
            if (this.contains(n2, n = mouseEvent.getY())) {
                this.mMouseLocation = this.getMouseLocation(n2, n);
                Cursor cursor = null;
                if (this.mMouseLocation == 0) {
                    cursor = Cursor.getPredefinedCursor(13);
                } else {
                    this.getCursor(this.mMouseLocation);
                }
                SGFigureElementShape.this.setMouseCursor(cursor);
                return true;
            }
            return false;
        }

        private boolean drag(MouseEvent mouseEvent) {
            if (SGFigureElementShape.this.mPressedPoint == null) {
                return false;
            }
            if (this.mMouseLocation == 0) {
                boolean bl = this.dragOtherPoint(mouseEvent);
                return bl;
            }
            Point point = new Point(SGFigureElementShape.this.mPressedPoint);
            this.mElement.drag(mouseEvent, point, this.mMouseLocation);
            SGFigureElementShape.this.mPressedPoint.setLocation(point);
            return true;
        }

        private boolean dragOtherPoint(MouseEvent mouseEvent) {
            if (SGFigureElementShape.this.mPressedPoint != null) {
                int n = mouseEvent.getX() - ((SGFigureElementShape)SGFigureElementShape.this).mPressedPoint.x;
                int n2 = mouseEvent.getY() - ((SGFigureElementShape)SGFigureElementShape.this).mPressedPoint.y;
                this.translate(n, n2);
                SGFigureElementShape.this.mPressedPoint = mouseEvent.getPoint();
            }
            return true;
        }

        public boolean isSelected() {
            return this.mSelectedFlag;
        }

        public void setSelected(boolean bl) {
            this.mSelectedFlag = bl;
        }

        public int getAxisConfiguration(SGAxis sGAxis) {
            return SGFigureElementShape.this.mAxisElement.getLocationInPlane(sGAxis);
        }

        public boolean setXAxis(int n) {
            if (n != 0 & n != 1) {
                return false;
            }
            this.setXAxis(SGFigureElementShape.this.mAxisElement.getAxisInPlane(n));
            return true;
        }

        public boolean setYAxis(int n) {
            if (n != 2 & n != 3) {
                return false;
            }
            this.setYAxis(SGFigureElementShape.this.mAxisElement.getAxisInPlane(n));
            return true;
        }

        public Object copy() {
            IElement iElement = (IElement)this.mElement.copy();
            SGAxis sGAxis = this.getXAxis();
            SGAxis sGAxis2 = this.getYAxis();
            int n = this.getAxisConfiguration(this.getXAxis());
            int n2 = this.getAxisConfiguration(this.getYAxis());
            ShapeObject shapeObject = new ShapeObject(iElement);
            iElement.setShapeObject(shapeObject);
            shapeObject.setXAxis(sGAxis);
            shapeObject.setYAxis(sGAxis2);
            shapeObject.mTempXAxis = n;
            shapeObject.mTempYAxis = n2;
            return shapeObject;
        }

        public void translate(float f, float f2) {
            this.mElement.translate(f, f2);
        }

        public boolean isChanged() {
            return this.mUndoManager.isChanged();
        }

        public void setChanged(boolean bl) {
            this.mUndoManager.setChanged(bl);
        }

        public boolean isChangedRoot() {
            return this.isChanged();
        }

        public boolean initPropertiesHistory() {
            return this.mUndoManager.initPropertiesHistory();
        }

        public void notifyToRoot() {
            SGFigureElementShape.this.notifyToRoot();
        }

        public boolean updateHistory() {
            return this.mUndoManager.updateHistory();
        }

        public void initUndoBuffer() {
            this.mUndoManager.initUndoBuffer();
        }

        public boolean setMementoBackward() {
            if (!this.mUndoManager.setMementoBackward()) {
                return false;
            }
            this.setShapeWithAxesValues();
            return true;
        }

        public boolean setMementoForward() {
            if (!this.mUndoManager.setMementoForward()) {
                return false;
            }
            this.setShapeWithAxesValues();
            return true;
        }

        public boolean undo() {
            return this.setMementoBackward();
        }

        public boolean redo() {
            return this.setMementoForward();
        }

        public SGProperties getMemento() {
            return this.mElement.getMement();
        }

        public boolean setMemento(SGProperties sGProperties) {
            if (!(sGProperties instanceof PropertyWithAxes)) {
                return false;
            }
            if (!super.setProperties(sGProperties)) {
                return false;
            }
            PropertyWithAxes propertyWithAxes = (PropertyWithAxes)((Object)sGProperties);
            SGAxis sGAxis = SGFigureElementShape.this.mAxisElement.getAxisInPlane(propertyWithAxes.getXAxisLocation());
            if (sGAxis == null) {
                return false;
            }
            this.setXAxis(sGAxis);
            SGAxis sGAxis2 = SGFigureElementShape.this.mAxisElement.getAxisInPlane(propertyWithAxes.getYAxisLocation());
            if (sGAxis2 == null) {
                return false;
            }
            this.setYAxis(sGAxis2);
            return this.mElement.setMement(sGProperties);
        }

        public boolean isUndoable() {
            return this.mUndoManager.isUndoable();
        }

        public boolean isRedoable() {
            return this.mUndoManager.isRedoable();
        }

        public Element createElement(Document document) {
            Element element = document.createElement(this.mElement.getName());
            if (!this.writeProperty(element)) {
                return null;
            }
            return element;
        }

        public boolean writeProperty(Element element) {
            SGIFigureElementAxis sGIFigureElementAxis = this.getAxisElement();
            element.setAttribute("XAxisPosition", sGIFigureElementAxis.getLocationName(this.getXAxis()));
            element.setAttribute("YAxisPosition", sGIFigureElementAxis.getLocationName(this.getYAxis()));
            return this.mElement.writeProperty(element);
        }

        public boolean readProperty(Element element) {
            SGIFigureElementAxis sGIFigureElementAxis = this.getAxisElement();
            String string = null;
            String string2 = element.getTagName();
            SGDrawingElement sGDrawingElement = null;
            if (string2.equals("Rectangle")) {
                sGDrawingElement = new Rect();
            } else if (string2.equals("Ellipse")) {
                sGDrawingElement = new Ellipse();
            } else if (string2.equals("Arrow")) {
                sGDrawingElement = new Arrow();
            } else {
                return false;
            }
            this.setIElement((IElement)((Object)sGDrawingElement));
            sGDrawingElement.setShapeObject(this);
            string = element.getAttribute("XAxisPosition");
            if (string.length() == 0) {
                return false;
            }
            SGAxis sGAxis = sGIFigureElementAxis.getAxis(string);
            if (sGAxis == null) {
                return false;
            }
            string = element.getAttribute("YAxisPosition");
            if (string.length() == 0) {
                return false;
            }
            SGAxis sGAxis2 = sGIFigureElementAxis.getAxis(string);
            if (sGAxis2 == null) {
                return false;
            }
            this.setXAxis(sGAxis);
            this.setYAxis(sGAxis2);
            return sGDrawingElement.readProperty(element);
        }
    }

    private static interface PropertyWithAxes {
        public int getXAxisLocation();

        public int getYAxisLocation();
    }

    private static interface IElement
    extends SGINode,
    SGIPropertyDialogObserver,
    SGIDisposable {
        public void setShapeObject(ShapeObject var1);

        public Object copy();

        public void translate(float var1, float var2);

        public SGProperties getMement();

        public boolean setMement(SGProperties var1);

        public String getName();

        public String getClassDescription();

        public String getInstanceDescription();

        public boolean setAxisValuesWithShape();

        public boolean setShapeWithAxesValues();

        public List getAnchorPointList();

        public int getMouseLocation(int var1, int var2);

        public boolean drag(MouseEvent var1, Point var2, int var3);

        public boolean writeProperty(Element var1);

        public boolean readProperty(Element var1);
    }

    private static class ShapeElementProperties
    extends SGProperties {
        ArrayList visibleShapeList = new ArrayList();

        public void dispose() {
            this.visibleShapeList.clear();
            this.visibleShapeList = null;
        }

        public boolean equals(Object object) {
            if (!(object instanceof ShapeElementProperties)) {
                return false;
            }
            ShapeElementProperties shapeElementProperties = (ShapeElementProperties)object;
            return shapeElementProperties.visibleShapeList.equals(this.visibleShapeList);
        }

        public String toString() {
            String string = new String("[");
            string = string + this.visibleShapeList.toString();
            string = string + new String("]");
            return string;
        }
    }
}

