/*
 * Decompiled with CFR 0.152.
 */
package jp.riken.brain.ni.samuraigraph.figure.java2d;

import java.awt.BasicStroke;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import jp.riken.brain.ni.samuraigraph.figure.SGDrawingElementSymbol;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGIDrawingElementJava2D;

public class SGDrawingElementSymbol2D
extends SGDrawingElementSymbol
implements SGIDrawingElementJava2D {
    public static final float MIN_SIZE = 6.0f;

    public boolean contains(int n, int n2) {
        Shape shape = this.getSymbolShape();
        if (shape == null) {
            return false;
        }
        Rectangle2D rectangle2D = shape.getBounds2D();
        if (rectangle2D.getWidth() < 6.0 | rectangle2D.getHeight() < 6.0) {
            float f = (float)rectangle2D.getCenterX();
            float f2 = (float)rectangle2D.getCenterY();
            rectangle2D = new Rectangle2D.Float(f - 3.0f, f2 - 3.0f, 6.0f, 6.0f);
        }
        return rectangle2D.contains(n, n2);
    }

    public Rectangle2D getElementBounds() {
        Shape shape = this.getSymbolShape();
        if (shape == null) {
            return new Rectangle2D.Float(this.getX(), this.getY(), 0.0f, 0.0f);
        }
        return shape.getBounds2D();
    }

    public Shape getSymbolShape() {
        float f = this.getX();
        float f2 = this.getY();
        float f3 = this.getMagnification() * this.getSize();
        float f4 = 0.5f * f3;
        int n = this.getType();
        Shape shape = null;
        switch (n) {
            case 1: {
                shape = new Ellipse2D.Float(f - f4, f2 - f4, f3, f3);
                break;
            }
            case 2: {
                shape = new Rectangle2D.Float(f - f4, f2 - f4, f3, f3);
                break;
            }
            case 3: {
                float f5 = f3 / (float)Math.sqrt(2.0);
                float f6 = f - f5;
                float f7 = f + f5;
                float f8 = f2 - f5;
                float f9 = f2 + f5;
                Line2D.Float float_ = new Line2D.Float(f, f9, f7, f2);
                Line2D.Float float_2 = new Line2D.Float(f7, f2, f, f8);
                Line2D.Float float_3 = new Line2D.Float(f, f8, f6, f2);
                Line2D.Float float_4 = new Line2D.Float(f6, f2, f, f9);
                GeneralPath generalPath = new GeneralPath();
                generalPath.append(float_, true);
                generalPath.append(float_2, true);
                generalPath.append(float_3, true);
                generalPath.append(float_4, true);
                generalPath.append(float_, true);
                shape = generalPath;
                break;
            }
            case 4: {
                float f10 = f3 / (float)Math.sqrt(3.0);
                float f11 = f;
                float f12 = f2 - f10;
                float f13 = f + f4;
                float f14 = f2 + 0.5f * f10;
                float f15 = f - f4;
                float f16 = f14;
                Line2D.Float float_ = new Line2D.Float(f11, f12, f13, f14);
                Line2D.Float float_5 = new Line2D.Float(f13, f14, f15, f16);
                Line2D.Float float_6 = new Line2D.Float(f15, f16, f11, f12);
                GeneralPath generalPath = new GeneralPath();
                generalPath.append(float_, true);
                generalPath.append(float_5, true);
                generalPath.append(float_6, true);
                generalPath.append(float_, true);
                shape = generalPath;
                break;
            }
            case 5: {
                float f17 = -f3 / (float)Math.sqrt(3.0);
                float f18 = f;
                float f19 = f2 - f17;
                float f20 = f + f4;
                float f21 = f2 + 0.5f * f17;
                float f22 = f - f4;
                float f23 = f21;
                Line2D.Float float_ = new Line2D.Float(f18, f19, f20, f21);
                Line2D.Float float_7 = new Line2D.Float(f20, f21, f22, f23);
                Line2D.Float float_8 = new Line2D.Float(f22, f23, f18, f19);
                GeneralPath generalPath = new GeneralPath();
                generalPath.append(float_, true);
                generalPath.append(float_7, true);
                generalPath.append(float_8, true);
                generalPath.append(float_, true);
                shape = generalPath;
                break;
            }
            case 6: {
                float f24 = f - f4;
                float f25 = f + f4;
                float f26 = f2 - f4;
                float f27 = f2 + f4;
                Line2D.Float float_ = new Line2D.Float(f24, f26, f25, f27);
                Line2D.Float float_9 = new Line2D.Float(f25, f26, f24, f27);
                GeneralPath generalPath = new GeneralPath();
                generalPath.append(float_, false);
                generalPath.append(float_9, false);
                shape = generalPath;
                break;
            }
            case 7: {
                Line2D.Float float_ = new Line2D.Float(f - f4, f2, f + f4, f2);
                Line2D.Float float_10 = new Line2D.Float(f, f2 - f4, f, f2 + f4);
                GeneralPath generalPath = new GeneralPath();
                generalPath.append(float_, false);
                generalPath.append(float_10, false);
                shape = generalPath;
                break;
            }
            case 8: {
                shape = new Line2D.Float(f - f4, f2, f + f4, f2);
                break;
            }
        }
        if (Math.abs(this.getAngle()) > Float.MIN_VALUE && shape != null) {
            AffineTransform affineTransform = this.getAffineTransform();
            Shape shape2 = affineTransform.createTransformedShape(shape);
            shape = shape2;
        }
        return shape;
    }

    protected AffineTransform getAffineTransform() {
        AffineTransform affineTransform = new AffineTransform();
        affineTransform.translate(this.getX(), this.getY());
        affineTransform.rotate(this.getAngle());
        affineTransform.translate(-this.getX(), -this.getY());
        return affineTransform;
    }

    public void paintElement(Graphics2D graphics2D) {
        if (!this.isVisible()) {
            return;
        }
        Shape shape = this.getSymbolShape();
        if (shape == null) {
            return;
        }
        this.paintInner(graphics2D, shape);
        this.paintLine(graphics2D, shape);
    }

    protected void paintInner(Graphics2D graphics2D, Shape shape) {
        graphics2D.setPaint(this.getColor(0));
        graphics2D.fill(shape);
    }

    protected void paintLine(Graphics2D graphics2D, Shape shape) {
        BasicStroke basicStroke = new BasicStroke(this.getMagnification() * this.getLineWidth(), 0, 0);
        graphics2D.setStroke(basicStroke);
        graphics2D.setPaint(this.getLineColor());
        graphics2D.draw(shape);
    }

    public void paint(Graphics2D graphics2D, Rectangle2D rectangle2D) {
        if (rectangle2D == null) {
            this.paintElement(graphics2D);
        } else {
            if (!this.isVisible()) {
                return;
            }
            Shape shape = this.getSymbolShape();
            if (shape == null) {
                return;
            }
            Area area = new Area(rectangle2D);
            this.paintInner(graphics2D, area, shape);
            this.paintLine(graphics2D, area, shape);
        }
    }

    protected void paintInner(Graphics2D graphics2D, Area area, Shape shape) {
        Area area2 = new Area(shape);
        area2.intersect(area);
        graphics2D.setPaint(this.getColor(0));
        graphics2D.fill(area2);
    }

    protected void paintLine(Graphics2D graphics2D, Area area, Shape shape) {
        BasicStroke basicStroke = new BasicStroke(this.getMagnification() * this.getLineWidth(), 0, 0);
        Shape shape2 = basicStroke.createStrokedShape(shape);
        Area area2 = new Area(shape2);
        area2.intersect(area);
        graphics2D.setPaint(this.getLineColor());
        graphics2D.fill(area2);
    }
}

