/*
 * Decompiled with CFR 0.152.
 */
package jp.riken.brain.ni.samuraigraph.figure.java2d;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.SpinnerNumberModel;
import jp.riken.brain.ni.samuraigraph.base.SGColorSelectionButton;
import jp.riken.brain.ni.samuraigraph.base.SGPropertyDialog;
import jp.riken.brain.ni.samuraigraph.base.SGPropertyPanel;
import jp.riken.brain.ni.samuraigraph.base.SGSpinner;
import jp.riken.brain.ni.samuraigraph.base.SGTextField;
import jp.riken.brain.ni.samuraigraph.base.SGUtility;
import jp.riken.brain.ni.samuraigraph.figure.SGDrawingElementArrow;
import jp.riken.brain.ni.samuraigraph.figure.SGDrawingElementLine;
import jp.riken.brain.ni.samuraigraph.figure.SGIArrowConstants;
import jp.riken.brain.ni.samuraigraph.figure.SGIFigureDrawingElementConstants;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGIArrowPanelObserver;

public class SGArrowPanel
extends SGPropertyPanel
implements SGIFigureDrawingElementConstants,
SGIArrowConstants {
    private static final long serialVersionUID = -9105514967167799562L;
    public static final String MSG_ANGLE_ERROR = "Open angle must be smaller than close angle.";
    private JLabel mCloseAngleLabel;
    private SGSpinner mCloseAngleSpinner;
    private SGColorSelectionButton mColorButton;
    private JLabel mColorLabel;
    private JComboBox mEndHeadTypeComboBox;
    private JLabel mEndHeadTypeLabel;
    private JLabel mHeadSizeLabel;
    private SGSpinner mHeadSizeSpinner;
    private JComboBox mLineTypeComboBox;
    private JLabel mLineTypeLabel;
    private JLabel mLineWidthLabel;
    private SGSpinner mLineWidthSpinner;
    private JLabel mOpenAngleLabel;
    private SGSpinner mOpenAngleSpinner;
    private JComboBox mStartHeadTypeComboBox;
    private JLabel mStartHeadTypeLabel;
    public static final double ARROW_HEAD_SIZE_STEP = 0.05;
    public static final double ARROW_HEAD_ANGLE_STEP = 1.0;
    private ArrayList mObserverList = new ArrayList();

    public SGArrowPanel() {
        this.initComponents();
        this.initProperty();
    }

    private void initComponents() {
        this.mHeadSizeSpinner = new SGSpinner();
        this.mHeadSizeLabel = new JLabel();
        this.mColorLabel = new JLabel();
        this.mColorButton = new SGColorSelectionButton();
        this.mLineWidthLabel = new JLabel();
        this.mLineWidthSpinner = new SGSpinner();
        this.mLineTypeLabel = new JLabel();
        this.mLineTypeComboBox = new JComboBox();
        this.mCloseAngleSpinner = new SGSpinner();
        this.mCloseAngleLabel = new JLabel();
        this.mOpenAngleSpinner = new SGSpinner();
        this.mOpenAngleLabel = new JLabel();
        this.mStartHeadTypeLabel = new JLabel();
        this.mStartHeadTypeComboBox = new JComboBox();
        this.mEndHeadTypeLabel = new JLabel();
        this.mEndHeadTypeComboBox = new JComboBox();
        this.setLayout(new GridBagLayout());
        this.mHeadSizeSpinner.setFont(new Font("Dialog", 0, 12));
        this.mHeadSizeSpinner.setPreferredSize(new Dimension(75, 22));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.mHeadSizeSpinner, gridBagConstraints);
        this.mHeadSizeLabel.setFont(new Font("Dialog", 0, 12));
        this.mHeadSizeLabel.setText("Head Size");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.mHeadSizeLabel, gridBagConstraints);
        this.mColorLabel.setFont(new Font("Dialog", 0, 12));
        this.mColorLabel.setText("Color");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(5, 20, 5, 5);
        this.add((Component)this.mColorLabel, gridBagConstraints);
        this.mColorButton.setPreferredSize(new Dimension(65, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.mColorButton, gridBagConstraints);
        this.mLineWidthLabel.setFont(new Font("Dialog", 0, 12));
        this.mLineWidthLabel.setText("Line Width");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(5, 15, 5, 5);
        this.add((Component)this.mLineWidthLabel, gridBagConstraints);
        this.mLineWidthSpinner.setFont(new Font("Dialog", 0, 12));
        this.mLineWidthSpinner.setPreferredSize(new Dimension(75, 22));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.mLineWidthSpinner, gridBagConstraints);
        this.mLineTypeLabel.setFont(new Font("Dialog", 0, 12));
        this.mLineTypeLabel.setText("Line Type");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(10, 20, 5, 5);
        this.add((Component)this.mLineTypeLabel, gridBagConstraints);
        this.mLineTypeComboBox.setFont(new Font("Dialog", 0, 12));
        this.mLineTypeComboBox.setPreferredSize(new Dimension(140, 22));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(10, 5, 5, 5);
        this.add((Component)this.mLineTypeComboBox, gridBagConstraints);
        this.mCloseAngleSpinner.setFont(new Font("Dialog", 0, 12));
        this.mCloseAngleSpinner.setPreferredSize(new Dimension(75, 22));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.insets = new Insets(5, 5, 10, 5);
        gridBagConstraints.anchor = 17;
        this.add((Component)this.mCloseAngleSpinner, gridBagConstraints);
        this.mCloseAngleLabel.setFont(new Font("Dialog", 0, 12));
        this.mCloseAngleLabel.setText("Close Angle");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.insets = new Insets(5, 10, 10, 5);
        gridBagConstraints.anchor = 13;
        this.add((Component)this.mCloseAngleLabel, gridBagConstraints);
        this.mOpenAngleSpinner.setFont(new Font("Dialog", 0, 12));
        this.mOpenAngleSpinner.setPreferredSize(new Dimension(75, 22));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.insets = new Insets(5, 5, 10, 5);
        gridBagConstraints.anchor = 17;
        this.add((Component)this.mOpenAngleSpinner, gridBagConstraints);
        this.mOpenAngleLabel.setFont(new Font("Dialog", 0, 12));
        this.mOpenAngleLabel.setText("Open Angle");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.insets = new Insets(5, 5, 10, 5);
        gridBagConstraints.anchor = 13;
        this.add((Component)this.mOpenAngleLabel, gridBagConstraints);
        this.mStartHeadTypeLabel.setFont(new Font("Dialog", 0, 12));
        this.mStartHeadTypeLabel.setText("Start Type");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 10);
        gridBagConstraints.anchor = 13;
        this.add((Component)this.mStartHeadTypeLabel, gridBagConstraints);
        this.mStartHeadTypeComboBox.setFont(new Font("Dialog", 0, 12));
        this.mStartHeadTypeComboBox.setPreferredSize(new Dimension(150, 22));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.anchor = 17;
        this.add((Component)this.mStartHeadTypeComboBox, gridBagConstraints);
        this.mEndHeadTypeLabel.setFont(new Font("Dialog", 0, 12));
        this.mEndHeadTypeLabel.setText("End Type");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 10);
        gridBagConstraints.anchor = 13;
        this.add((Component)this.mEndHeadTypeLabel, gridBagConstraints);
        this.mEndHeadTypeComboBox.setFont(new Font("Dialog", 0, 12));
        this.mEndHeadTypeComboBox.setPreferredSize(new Dimension(150, 22));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.anchor = 17;
        this.add((Component)this.mEndHeadTypeComboBox, gridBagConstraints);
    }

    private void initProperty() {
        int n;
        Object[] objectArray = new String[]{"Solid", "Broken", "Dotted", "Dashed", "Double Dashed"};
        for (n = 0; n < objectArray.length; ++n) {
            this.mLineTypeComboBox.addItem(objectArray[n]);
        }
        objectArray = new Object[]{"Arrow Head", "Circle", "Triangle", "Inverted Triangle", "Square", "Diamond", "Transverse Line", "Cross", "No Symbol"};
        for (n = 0; n < objectArray.length; ++n) {
            this.mStartHeadTypeComboBox.addItem(objectArray[n]);
            this.mEndHeadTypeComboBox.addItem(objectArray[n]);
        }
        this.mLineWidthSpinner.initProperties(SGPropertyDialog.getLineWidthSpinnerNumberModel(), "pt", 1, 2);
        this.mHeadSizeSpinner.initProperties(new SpinnerNumberModel(0.1, 0.05, 2.0, 0.05), "cm", 1, 2);
        this.mOpenAngleSpinner.initProperties(new SpinnerNumberModel(10.0, 5.0, 85.0, 1.0), degree, 1, 2);
        this.mCloseAngleSpinner.initProperties(new SpinnerNumberModel(10.0, 5.0, 175.0, 1.0), degree, 1, 2);
        this.mLineWidthSpinner.setDescription("Form-> Line Width");
        this.mHeadSizeSpinner.setDescription("Form-> Head Size");
        this.mOpenAngleSpinner.setDescription("Form-> Open Angle");
        this.mCloseAngleSpinner.setDescription("Form-> Close Angle");
    }

    public void dispose() {
        super.dispose();
        this.mObserverList.clear();
        this.mObserverList = null;
    }

    public ArrayList getColorSelectionButtonsList() {
        ArrayList<SGColorSelectionButton> arrayList = new ArrayList<SGColorSelectionButton>();
        arrayList.add(this.mColorButton);
        return arrayList;
    }

    public ArrayList getSpinnerList() {
        ArrayList<SGSpinner> arrayList = new ArrayList<SGSpinner>();
        arrayList.add(this.mLineWidthSpinner);
        arrayList.add(this.mHeadSizeSpinner);
        arrayList.add(this.mOpenAngleSpinner);
        arrayList.add(this.mCloseAngleSpinner);
        return arrayList;
    }

    protected boolean setValue(SGTextField sGTextField, Object object) {
        return SGUtility.setValue(sGTextField, object);
    }

    protected boolean setValue(SGSpinner sGSpinner, Object object) {
        return SGUtility.setValue(sGSpinner, object);
    }

    public boolean addObserver(SGIArrowPanelObserver sGIArrowPanelObserver) {
        this.mObserverList.add(sGIArrowPanelObserver);
        return true;
    }

    public boolean removeObserver(SGIArrowPanelObserver sGIArrowPanelObserver) {
        this.mObserverList.remove(sGIArrowPanelObserver);
        return true;
    }

    public boolean removeAllObserver() {
        this.mObserverList.clear();
        return true;
    }

    public Number getLineWidth() {
        return this.mLineWidthSpinner.getNumber();
    }

    public Integer getLineType() {
        String string = (String)this.mLineTypeComboBox.getSelectedItem();
        if (string == null) {
            return null;
        }
        Integer n = SGDrawingElementLine.getLineTypeFromName(string);
        return n;
    }

    public Color getColor() {
        return this.mColorButton.getColor();
    }

    public Number getHeadSize() {
        return this.mHeadSizeSpinner.getNumber();
    }

    public Integer getStartHeadType() {
        String string = (String)this.mStartHeadTypeComboBox.getSelectedItem();
        if (string == null) {
            return null;
        }
        Integer n = SGDrawingElementArrow.getSymbolTypeFromName(string);
        return n;
    }

    public Integer getEndHeadType() {
        String string = (String)this.mEndHeadTypeComboBox.getSelectedItem();
        if (string == null) {
            return null;
        }
        Integer n = SGDrawingElementArrow.getSymbolTypeFromName(string);
        return n;
    }

    public Number getHeadOpenAngle() {
        return this.mOpenAngleSpinner.getNumber();
    }

    public Number getHeadCloseAngle() {
        return this.mCloseAngleSpinner.getNumber();
    }

    public boolean setLineWidth(Object object) {
        return this.setValue(this.mLineWidthSpinner, object);
    }

    public boolean setLineType(Integer n) {
        if (n != null) {
            String string = SGDrawingElementLine.getLineTypeName(n);
            this.mLineTypeComboBox.setSelectedItem(string);
        } else {
            this.mLineTypeComboBox.setSelectedItem(null);
        }
        return true;
    }

    public boolean setColor(Color color) {
        this.mColorButton.setColor(color);
        return true;
    }

    public boolean setStartHeadType(Integer n) {
        if (n != null) {
            String string = SGDrawingElementArrow.getSymbolTypeName(n);
            this.mStartHeadTypeComboBox.setSelectedItem(string);
        } else {
            this.mStartHeadTypeComboBox.setSelectedItem(null);
        }
        return true;
    }

    public boolean setEndHeadType(Integer n) {
        if (n != null) {
            String string = SGDrawingElementArrow.getSymbolTypeName(n);
            this.mEndHeadTypeComboBox.setSelectedItem(string);
        } else {
            this.mEndHeadTypeComboBox.setSelectedItem(null);
        }
        return true;
    }

    public boolean setHeadSize(Object object) {
        return this.setValue(this.mHeadSizeSpinner, object);
    }

    public boolean setOpenAngle(Object object) {
        return this.setValue(this.mOpenAngleSpinner, object);
    }

    public boolean setCloseAngle(Object object) {
        return this.setValue(this.mCloseAngleSpinner, object);
    }

    public boolean setComponentsProperty() {
        ArrayList arrayList = this.mObserverList;
        SGIArrowPanelObserver sGIArrowPanelObserver = (SGIArrowPanelObserver)arrayList.get(0);
        float f = sGIArrowPanelObserver.getLineWidth("pt");
        int n = sGIArrowPanelObserver.getLineType();
        Color color = sGIArrowPanelObserver.getColor();
        float f2 = sGIArrowPanelObserver.getHeadSize("cm");
        int n2 = sGIArrowPanelObserver.getStartHeadType();
        int n3 = sGIArrowPanelObserver.getEndHeadType();
        float f3 = sGIArrowPanelObserver.getHeadOpenAngle();
        float f4 = sGIArrowPanelObserver.getHeadCloseAngle();
        Float f5 = new Float(f);
        Integer n4 = new Integer(n);
        Color color2 = color;
        Float f6 = new Float(f2);
        Integer n5 = new Integer(n2);
        Integer n6 = new Integer(n3);
        Float f7 = new Float(f3);
        Float f8 = new Float(f4);
        if (arrayList.size() > 1) {
            float f9;
            SGIArrowPanelObserver sGIArrowPanelObserver2;
            int n7;
            for (n7 = 1; n7 < arrayList.size(); ++n7) {
                sGIArrowPanelObserver2 = (SGIArrowPanelObserver)arrayList.get(n7);
                f9 = sGIArrowPanelObserver2.getLineWidth("pt");
                if (f == f9) continue;
                f5 = null;
                break;
            }
            for (n7 = 1; n7 < arrayList.size(); ++n7) {
                sGIArrowPanelObserver2 = (SGIArrowPanelObserver)arrayList.get(n7);
                int n8 = sGIArrowPanelObserver2.getLineType();
                if (n == n8) continue;
                n4 = null;
                break;
            }
            for (n7 = 1; n7 < arrayList.size(); ++n7) {
                sGIArrowPanelObserver2 = (SGIArrowPanelObserver)arrayList.get(n7);
                Color color3 = sGIArrowPanelObserver2.getColor();
                if (color.equals(color3)) continue;
                color2 = null;
                break;
            }
            for (n7 = 1; n7 < arrayList.size(); ++n7) {
                sGIArrowPanelObserver2 = (SGIArrowPanelObserver)arrayList.get(n7);
                f9 = sGIArrowPanelObserver2.getHeadSize("cm");
                if (f2 == f9) continue;
                f6 = null;
                break;
            }
            for (n7 = 1; n7 < arrayList.size(); ++n7) {
                sGIArrowPanelObserver2 = (SGIArrowPanelObserver)arrayList.get(n7);
                int n9 = sGIArrowPanelObserver2.getStartHeadType();
                if (n2 == n9) continue;
                n5 = null;
                break;
            }
            for (n7 = 1; n7 < arrayList.size(); ++n7) {
                sGIArrowPanelObserver2 = (SGIArrowPanelObserver)arrayList.get(n7);
                int n10 = sGIArrowPanelObserver2.getEndHeadType();
                if (n3 == n10) continue;
                n6 = null;
                break;
            }
            for (n7 = 1; n7 < arrayList.size(); ++n7) {
                sGIArrowPanelObserver2 = (SGIArrowPanelObserver)arrayList.get(n7);
                float f10 = sGIArrowPanelObserver2.getHeadOpenAngle();
                if (f3 == f10) continue;
                f7 = null;
                break;
            }
            for (n7 = 1; n7 < arrayList.size(); ++n7) {
                sGIArrowPanelObserver2 = (SGIArrowPanelObserver)arrayList.get(n7);
                float f11 = sGIArrowPanelObserver2.getHeadCloseAngle();
                if (f4 == f11) continue;
                f8 = null;
                break;
            }
        }
        this.setLineWidth(f5);
        this.setLineType(n4);
        this.setColor(color2);
        this.setHeadSize(f6);
        this.setStartHeadType(n5);
        this.setEndHeadType(n6);
        if (f7 != null) {
            f7 = new Float(f7.floatValue() / ((float)Math.PI / 180));
        }
        this.setOpenAngle(f7);
        if (f8 != null) {
            f8 = new Float(f8.floatValue() / ((float)Math.PI / 180));
        }
        this.setCloseAngle(f8);
        return true;
    }

    public boolean setPropertiesToListeners(SGIArrowPanelObserver sGIArrowPanelObserver) {
        Float f;
        Number number = this.getLineWidth();
        Integer n = this.getLineType();
        Number number2 = this.getHeadSize();
        Color color = this.getColor();
        Integer n2 = this.getStartHeadType();
        Integer n3 = this.getEndHeadType();
        Number number3 = this.getHeadOpenAngle();
        Number number4 = this.getHeadCloseAngle();
        Float f2 = number3 != null ? new Float(number3.floatValue() * ((float)Math.PI / 180)) : null;
        Float f3 = f = number4 != null ? new Float(number4.floatValue() * ((float)Math.PI / 180)) : null;
        if (!sGIArrowPanelObserver.hasValidAngle(f2, f)) {
            this.setInputErrorMessage(MSG_ANGLE_ERROR);
            return false;
        }
        if (number != null) {
            sGIArrowPanelObserver.setLineWidth(number.floatValue(), "pt");
        }
        if (n != null) {
            sGIArrowPanelObserver.setLineType(n);
        }
        if (number2 != null) {
            sGIArrowPanelObserver.setHeadSize(number2.floatValue(), "cm");
        }
        if (color != null) {
            sGIArrowPanelObserver.setColor(color);
        }
        if (n2 != null) {
            sGIArrowPanelObserver.setStartHeadType(n2);
        }
        if (n3 != null) {
            sGIArrowPanelObserver.setEndHeadType(n3);
        }
        if (f2 != null) {
            sGIArrowPanelObserver.setHeadOpenAngle(((Number)f2).floatValue());
        }
        if (f != null) {
            sGIArrowPanelObserver.setHeadCloseAngle(((Number)f).floatValue());
        }
        return true;
    }
}

