/*
 * Decompiled with CFR 0.152.
 */
package jp.riken.brain.ni.samuraigraph.figure;

import java.awt.Color;
import java.util.List;
import jp.riken.brain.ni.samuraigraph.base.SGDrawingElement;
import jp.riken.brain.ni.samuraigraph.base.SGProperties;
import jp.riken.brain.ni.samuraigraph.base.SGTuple2f;
import jp.riken.brain.ni.samuraigraph.base.SGUtilityText;
import jp.riken.brain.ni.samuraigraph.figure.SGDrawingElementArrow;
import jp.riken.brain.ni.samuraigraph.figure.SGIArrowConstants;
import jp.riken.brain.ni.samuraigraph.figure.SGIErrorBarConstants;

public abstract class SGDrawingElementErrorBar
extends SGDrawingElement
implements SGIArrowConstants,
SGIErrorBarConstants {
    private SGDrawingElementArrow mArrowElement = this.createArrowInstance();
    private int mHeadType;
    private int mErrorBarStyle = 1;

    protected abstract SGDrawingElementArrow createArrowInstance();

    protected final SGDrawingElementArrow getArrow() {
        return this.mArrowElement;
    }

    public void dispose() {
        super.dispose();
        this.mArrowElement.dispose();
        this.mArrowElement = null;
    }

    public static Integer getErrorBarStyleFromName(String string) {
        int n;
        if (string == null) {
            return null;
        }
        String string2 = string.toLowerCase();
        if (string2.equals("Bothsides".toLowerCase())) {
            n = 1;
        } else if (string2.equals("Upside".toLowerCase())) {
            n = 2;
        } else if (string2.equals("Downside".toLowerCase())) {
            n = 3;
        } else {
            return null;
        }
        return new Integer(n);
    }

    public static String getErrorBarStyleName(int n) {
        String string = null;
        switch (n) {
            case 1: {
                string = "Bothsides";
                break;
            }
            case 2: {
                string = "Upside";
                break;
            }
            case 3: {
                string = "Downside";
                break;
            }
        }
        return string;
    }

    public static Integer getHeadTypeFromName(String string) {
        int n;
        if (string == null) {
            return null;
        }
        String string2 = string.toLowerCase();
        if (string2.equals("Circle".toLowerCase())) {
            n = 1;
        } else if (string2.equals("Transverse Line".toLowerCase())) {
            n = 8;
        } else if (string2.equals("No Symbol".toLowerCase())) {
            n = -1;
        } else {
            return null;
        }
        return new Integer(n);
    }

    public static String getHeadTypeName(int n) {
        String string = null;
        switch (n) {
            case 1: {
                string = "Circle";
                break;
            }
            case 8: {
                string = "Transverse Line";
                break;
            }
            case -1: {
                string = "No Symbol";
                break;
            }
        }
        return string;
    }

    public boolean setTermPoints(SGTuple2f sGTuple2f, SGTuple2f sGTuple2f2) {
        return this.mArrowElement.setTermPoints(sGTuple2f, sGTuple2f2);
    }

    public boolean setColor(Color color) {
        super.setColor(color);
        this.mArrowElement.setColor(color);
        return true;
    }

    public boolean setColorList(List list) {
        super.setColorList(list);
        this.mArrowElement.setColorList(list);
        return true;
    }

    public boolean setMagnification(float f) {
        super.setMagnification(f);
        this.mArrowElement.setMagnification(f);
        return true;
    }

    public float getLineWidth() {
        return this.mArrowElement.getLineWidth();
    }

    public boolean setLineWidth(float f) {
        return this.mArrowElement.setLineWidth(f);
    }

    public boolean setLineWidth(float f, String string) {
        double d = SGUtilityText.convertToPoint(f, string);
        return this.setLineWidth((float)d);
    }

    public float getHeadSize() {
        return this.mArrowElement.getHeadSize();
    }

    public boolean setHeadSize(float f) {
        return this.mArrowElement.setHeadSize(f);
    }

    public boolean setHeadSize(float f, String string) {
        double d = SGUtilityText.convertToPoint(f, string);
        return this.setHeadSize((float)d);
    }

    public int getErrorBarStyle() {
        return this.mErrorBarStyle;
    }

    public boolean setErrorBarStyle(int n) {
        this.mErrorBarStyle = n;
        int n2 = this.getHeadType();
        SGDrawingElementArrow sGDrawingElementArrow = this.mArrowElement;
        switch (n) {
            case 1: {
                sGDrawingElementArrow.setStartHeadType(n2);
                sGDrawingElementArrow.setEndHeadType(n2);
                break;
            }
            case 2: {
                sGDrawingElementArrow.setStartHeadType(-1);
                sGDrawingElementArrow.setEndHeadType(n2);
                break;
            }
            case 3: {
                sGDrawingElementArrow.setStartHeadType(n2);
                sGDrawingElementArrow.setEndHeadType(-1);
                break;
            }
            default: {
                throw new Error();
            }
        }
        return true;
    }

    public int getHeadType() {
        return this.mHeadType;
    }

    public boolean setHeadType(int n) {
        this.mHeadType = n;
        SGDrawingElementArrow sGDrawingElementArrow = this.mArrowElement;
        switch (this.mErrorBarStyle) {
            case 1: {
                sGDrawingElementArrow.setStartHeadType(n);
                sGDrawingElementArrow.setEndHeadType(n);
                break;
            }
            case 2: {
                sGDrawingElementArrow.setStartHeadType(-1);
                sGDrawingElementArrow.setEndHeadType(n);
                break;
            }
            case 3: {
                sGDrawingElementArrow.setStartHeadType(n);
                sGDrawingElementArrow.setEndHeadType(-1);
                break;
            }
            default: {
                throw new Error();
            }
        }
        return true;
    }

    public SGProperties getProperties() {
        ErrorBarProperties errorBarProperties = new ErrorBarProperties();
        this.getProperties(errorBarProperties);
        return errorBarProperties;
    }

    public boolean getProperties(SGProperties sGProperties) {
        if (sGProperties == null) {
            return false;
        }
        if (!(sGProperties instanceof ErrorBarProperties)) {
            return false;
        }
        if (!super.getProperties(sGProperties)) {
            return false;
        }
        ErrorBarProperties errorBarProperties = (ErrorBarProperties)sGProperties;
        errorBarProperties.setLineWidth(this.getLineWidth());
        errorBarProperties.setHeadSize(this.getHeadSize());
        errorBarProperties.setHeadType(this.getHeadType());
        errorBarProperties.setErrorBarStyle(this.getErrorBarStyle());
        return true;
    }

    public static class ErrorBarProperties
    extends SGDrawingElement.DrawingElementProperties {
        private SGDrawingElementArrow.ArrowProperties mArrowProperties = new SGDrawingElementArrow.ArrowProperties();
        private int mErrorBarStyle = 1;
        private int mHeadType;

        public ErrorBarProperties() {
            this.mArrowProperties.setLineType(1);
        }

        public boolean equals(Object object) {
            if (!(object instanceof ErrorBarProperties)) {
                return false;
            }
            if (!super.equals(object)) {
                return false;
            }
            ErrorBarProperties errorBarProperties = (ErrorBarProperties)object;
            if (!this.mArrowProperties.equals(errorBarProperties.mArrowProperties)) {
                return false;
            }
            if (this.mErrorBarStyle != errorBarProperties.mErrorBarStyle) {
                return false;
            }
            return this.mHeadType == errorBarProperties.mHeadType;
        }

        public Float getLineWidth() {
            return this.mArrowProperties.getLineWidth();
        }

        public Float getHeadSize() {
            return this.mArrowProperties.getHeadSize();
        }

        public Integer getHeadType() {
            return new Integer(this.mHeadType);
        }

        public Integer getErrorBarStyle() {
            return new Integer(this.mErrorBarStyle);
        }

        public void setColor(Color color) {
            super.setColor(color);
            this.mArrowProperties.setColor(color);
        }

        public void setColor(List list) {
            super.setColor(list);
            this.mArrowProperties.setColor(list);
        }

        public void setLineWidth(float f) {
            this.mArrowProperties.setLineWidth(f);
        }

        public void setHeadType(int n) {
            this.mHeadType = n;
            SGDrawingElementArrow.ArrowProperties arrowProperties = this.mArrowProperties;
            switch (this.mErrorBarStyle) {
                case 1: {
                    arrowProperties.setStartHeadType(n);
                    arrowProperties.setEndHeadType(n);
                    break;
                }
                case 2: {
                    arrowProperties.setStartHeadType(-1);
                    arrowProperties.setEndHeadType(n);
                    break;
                }
                case 3: {
                    arrowProperties.setStartHeadType(n);
                    arrowProperties.setEndHeadType(-1);
                    break;
                }
                default: {
                    throw new Error();
                }
            }
        }

        public void setHeadSize(float f) {
            this.mArrowProperties.setHeadSize(f);
        }

        public void setErrorBarStyle(int n) {
            this.mErrorBarStyle = n;
            int n2 = this.getHeadType();
            SGDrawingElementArrow.ArrowProperties arrowProperties = this.mArrowProperties;
            switch (n) {
                case 1: {
                    arrowProperties.setStartHeadType(n2);
                    arrowProperties.setEndHeadType(n2);
                    break;
                }
                case 2: {
                    arrowProperties.setStartHeadType(-1);
                    arrowProperties.setEndHeadType(n2);
                    break;
                }
                case 3: {
                    arrowProperties.setStartHeadType(n2);
                    arrowProperties.setEndHeadType(-1);
                    break;
                }
                default: {
                    throw new Error();
                }
            }
        }
    }
}

