/*
 * Decompiled with CFR 0.152.
 */
package jp.riken.brain.ni.samuraigraph.application;

import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.StringTokenizer;
import java.util.prefs.Preferences;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JProgressBar;
import jp.riken.brain.ni.samuraigraph.application.SGApplicationProperties;
import jp.riken.brain.ni.samuraigraph.application.SGApplicationUtility;
import jp.riken.brain.ni.samuraigraph.application.SGDrawingServer;
import jp.riken.brain.ni.samuraigraph.application.SGIPreferencesConstants;
import jp.riken.brain.ni.samuraigraph.application.SGIUpgradeConstants;
import jp.riken.brain.ni.samuraigraph.application.SGProgressMonitorDialog;
import jp.riken.brain.ni.samuraigraph.application.SGProxyManager;
import jp.riken.brain.ni.samuraigraph.application.SGScrollPaneDialog;
import jp.riken.brain.ni.samuraigraph.application.SGUpgradeConfirmDialog;
import jp.riken.brain.ni.samuraigraph.application.SGUpgradeDialog;
import jp.riken.brain.ni.samuraigraph.base.SGExtensionFileFilter;
import jp.riken.brain.ni.samuraigraph.base.SGFileChooser;
import jp.riken.brain.ni.samuraigraph.base.SGIConstants;
import jp.riken.brain.ni.samuraigraph.base.SGUtility;
import jp.riken.brain.ni.samuraigraph.base.SGUtilityText;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

class SGUpgradeManager
implements ActionListener,
SGIConstants,
SGIUpgradeConstants,
SGIPreferencesConstants {
    private static final String MSG_LATEST_VERSION_INSTALLED = "The latest version is already installed.";
    private static final String MSG_NEW_VERSION_FOUND_BEFORE = "Samurai Graph Ver.";
    private static final String MSG_NEW_VERSION_FOUND_AFTER = " is found.\nDownload now?\n";
    private static final String MSG_UPGRADE_FAILED = "Upgrade is failed for some reason.";
    private static final String MSG_UPGRADE_WARNING = "This application will be terminated.\nPresent work will be lost.";
    private static final String TITLE_WARNING = "Warning";
    private static final String MSG_LOCAL_FILE_NOT_FOUND = "Local file is not found.";
    private static final String MSG_CONNECTION_FAILED = "Connection Failed.";
    private JFileChooser mUpgradeFileChooser;
    private SGUpgradeDialog mUpgradeDialog;
    private SGProxyManager mProxyManager;
    private SGApplicationProperties mAppProp;

    public SGUpgradeManager(SGProxyManager sGProxyManager, SGApplicationProperties sGApplicationProperties) {
        this.mProxyManager = sGProxyManager;
        this.mAppProp = sGApplicationProperties;
        this.mUpgradeFileChooser = new SGFileChooser();
        this.mUpgradeFileChooser.setCurrentDirectory(new File(USER_HOME));
    }

    public void actionPerformed(ActionEvent actionEvent) {
        SGUpgradeDialog sGUpgradeDialog;
        Object object = actionEvent.getSource();
        String string = actionEvent.getActionCommand();
        if (string.equals("OK")) {
            int n;
            String string2 = this.mUpgradeDialog.getUpgradeCycle();
            if (string2.equals("No Upgrade")) {
                n = 0;
            } else if (string2.equals("Every Time")) {
                n = 1;
            } else if (string2.equals("Every Day")) {
                n = 2;
            } else if (string2.equals("Every Week")) {
                n = 3;
            } else if (string2.equals("Every Month")) {
                n = 4;
            } else {
                throw new Error();
            }
            Preferences preferences = Preferences.userNodeForPackage(this.getClass());
            preferences.putInt("Upgrade Cycle", n);
        } else if (string.equals("Check for Update Now") && !this.upgradeByCommand(sGUpgradeDialog = (SGUpgradeDialog)object)) {
            return;
        }
    }

    public boolean showUpgradeDialog(Frame frame) {
        this.mUpgradeDialog = new SGUpgradeDialog(frame, true);
        this.mUpgradeDialog.addActionListener(this);
        this.mUpgradeDialog.setCenter(frame);
        Preferences preferences = Preferences.userNodeForPackage(this.getClass());
        int n = preferences.getInt("Upgrade Cycle", 0);
        String string = null;
        switch (n) {
            case 0: {
                string = "No Upgrade";
                break;
            }
            case 1: {
                string = "Every Time";
                break;
            }
            case 2: {
                string = "Every Day";
                break;
            }
            case 3: {
                string = "Every Week";
                break;
            }
            case 4: {
                string = "Every Month";
                break;
            }
            default: {
                string = "No Upgrade";
            }
        }
        this.mUpgradeDialog.setUpgradeCycle(string);
        this.mUpgradeDialog.setVisible(true);
        return true;
    }

    public boolean upgradeWithCheckDate(Window window) {
        if (!this.checkDate()) {
            return false;
        }
        return this.upgrade(window, true);
    }

    private boolean upgradeByCommand(Window window) {
        return this.upgrade(window, false);
    }

    private boolean upgrade(Window window, boolean bl) {
        Object object;
        boolean bl2 = this.mProxyManager.isDirectAccess();
        String string = this.mProxyManager.getProxyHostName();
        int n = this.mProxyManager.getProxyPortNumber();
        URL uRL = null;
        try {
            uRL = bl2 ? new URL("http://samurai-graph.sourceforge.jp/product.xml") : new URL("http", string, n, "http://samurai-graph.sourceforge.jp/product.xml");
        }
        catch (MalformedURLException malformedURLException) {
            return false;
        }
        Document document = SGUtilityText.getDocument(uRL);
        if (document == null) {
            return false;
        }
        if (bl) {
            object = Preferences.userNodeForPackage(this.getClass());
            ((Preferences)object).putLong("Date", System.currentTimeMillis());
        }
        if (this.compareVersion((Element)(object = document.getDocumentElement()))) {
            if (!this.installLatestVersion((Element)object, window, bl)) {
                return false;
            }
        } else if (!bl) {
            JOptionPane.showMessageDialog(window, MSG_LATEST_VERSION_INSTALLED);
        }
        return true;
    }

    private boolean compareVersion(Element element) {
        int n = this.mAppProp.getMajorVersion();
        int n2 = this.mAppProp.getMinorVersion();
        int n3 = this.mAppProp.getMicroVersion();
        int n4 = this.getVersion(element, "majorver");
        int n5 = this.getVersion(element, "minorver");
        int n6 = this.getVersion(element, "microver");
        boolean bl = SGApplicationUtility.compareVersionNumber(n, n2, n3, n4, n5, n6);
        return bl;
    }

    private int getVersion(Element element, String string) {
        Element element2 = (Element)element.getElementsByTagName(string).item(0);
        String string2 = element2.getFirstChild().getNodeValue();
        int n = Integer.parseInt(string2);
        return n;
    }

    private boolean installLatestVersion(Element element, Window window, boolean bl) {
        Object object;
        Element element2;
        Object object2;
        Object object3;
        int n;
        int n2 = this.mAppProp.getMajorVersion();
        int n3 = this.mAppProp.getMinorVersion();
        int n4 = this.mAppProp.getMicroVersion();
        NodeList nodeList = element.getElementsByTagName("release");
        Element element3 = null;
        ArrayList<Element> arrayList = new ArrayList<Element>();
        for (n = 0; n < nodeList.getLength(); ++n) {
            int n5;
            int n6;
            int n7;
            Element element4 = (Element)nodeList.item(n);
            String string = element4.getAttribute("latest");
            if (Boolean.TRUE.toString().equals(string)) {
                element3 = element4;
            }
            if (!SGApplicationUtility.compareVersionNumber(n2, n3, n4, n7 = this.getVersion(element4, "majorver"), n6 = this.getVersion(element4, "minorver"), n5 = this.getVersion(element4, "microver"))) continue;
            arrayList.add(element4);
        }
        if (element3 == null) {
            return false;
        }
        n = this.getVersion(element3, "majorver");
        int n8 = this.getVersion(element3, "minorver");
        int n9 = this.getVersion(element3, "microver");
        String string = new Integer(n).toString();
        String string2 = new Integer(n8).toString();
        String string3 = new Integer(n9).toString();
        String string4 = MSG_NEW_VERSION_FOUND_BEFORE + string + "." + string2 + "." + string3 + MSG_NEW_VERSION_FOUND_AFTER;
        StringBuffer stringBuffer = new StringBuffer("<html><head></head><body>-- New Features --");
        String string5 = "<font size=\"3\">";
        stringBuffer.append(string5);
        for (int i = 0; i < arrayList.size(); ++i) {
            object3 = (Element)arrayList.get(i);
            object2 = new StringBuffer();
            NodeList nodeList2 = object3.getElementsByTagName("releaseinfo");
            element2 = (Element)nodeList2.item(0);
            object = element2.getElementsByTagName("changelog");
            Element element5 = (Element)object.item(0);
            this.printNode(element5, (StringBuffer)object2);
            stringBuffer.append((StringBuffer)object2);
        }
        SGScrollPaneDialog sGScrollPaneDialog = null;
        if (window instanceof Frame) {
            sGScrollPaneDialog = new SGUpgradeConfirmDialog((Frame)window, true);
        } else if (window instanceof Dialog) {
            sGScrollPaneDialog = new SGUpgradeConfirmDialog((Dialog)window, true);
        }
        sGScrollPaneDialog.setMessage(string4);
        ((SGUpgradeConfirmDialog)sGScrollPaneDialog).setPage(new String(stringBuffer));
        sGScrollPaneDialog.pack();
        sGScrollPaneDialog.setCenter(window);
        sGScrollPaneDialog.setVisible(true);
        if (sGScrollPaneDialog.isCanceled()) {
            return true;
        }
        object3 = null;
        object3 = SGUtility.identifyOS("windows") ? "win32" : (SGUtility.identifyOS("mac os x") ? "macosx" : "other");
        object2 = element3.getElementsByTagName("package");
        for (int i = 0; i < object2.getLength(); ++i) {
            element2 = (Element)object2.item(i);
            object = element2.getAttribute("category");
            if (((String)object).equals("win32")) {
                if (!((String)object3).equals("win32")) continue;
                if (this.forWin32(element2, string, string2, string3, window, bl)) break;
                return false;
            }
            if (((String)object).equals("macosx")) {
                if (!((String)object3).equals("macosx")) continue;
                if (this.forMacOSX(element2, string, string2, string3, window, bl)) break;
                return false;
            }
            if (((String)object).equals("bin")) {
                if (!((String)object3).equals("other")) continue;
                if (this.forOtherPlatform(element2, string, string2, string3, window, bl)) break;
                return false;
            }
            if (!((String)object).equals("src")) continue;
        }
        return true;
    }

    private boolean forWin32(Element element, String string, String string2, String string3, Window window, boolean bl) {
        Object object;
        Object[] objectArray;
        int n;
        String string4 = "samurai-graph-win32-" + string + "." + string2 + "." + string3 + ".exe ";
        if (!(bl || (n = JOptionPane.showOptionDialog(window, MSG_UPGRADE_WARNING, TITLE_WARNING, -1, 2, null, objectArray = new Object[]{"OK", "Cancel"}, objectArray[0])) != 1 && n != -1)) {
            return true;
        }
        objectArray = System.getProperty("java.class.path");
        StringTokenizer stringTokenizer = new StringTokenizer((String)objectArray, PATH_SEPARATOR);
        String string5 = null;
        while (stringTokenizer.hasMoreTokens()) {
            object = stringTokenizer.nextToken();
            if (!((String)object).endsWith("samurai-graph.jar")) continue;
            string5 = new File((String)object).getParent();
            break;
        }
        if (string5 == null) {
            JOptionPane.showMessageDialog(window, MSG_UPGRADE_FAILED);
            return false;
        }
        object = new File(string5 + FILE_SEPARATOR + "lib" + FILE_SEPARATOR + "upgrade-helper.jar");
        if (!((File)object).exists()) {
            JOptionPane.showMessageDialog(window, MSG_UPGRADE_FAILED);
            return false;
        }
        File file = new File(TMP_DIR + FILE_SEPARATOR + "SamuraiGraphTemp");
        if (!file.mkdir()) {
            JOptionPane.showMessageDialog(window, MSG_UPGRADE_FAILED);
            return false;
        }
        file.deleteOnExit();
        File file2 = new File(file.getAbsolutePath() + FILE_SEPARATOR + "upgrade-helper.jar");
        file2.deleteOnExit();
        try {
            SGApplicationUtility.copyBinaryFile((File)object, file2);
        }
        catch (IOException iOException) {
            JOptionPane.showMessageDialog(window, MSG_UPGRADE_FAILED);
            return false;
        }
        File file3 = null;
        file3 = new File(file.getAbsolutePath() + FILE_SEPARATOR + string4);
        if (!this.download(element, window, file3)) {
            JOptionPane.showMessageDialog(window, MSG_UPGRADE_FAILED);
            file2.delete();
            file.delete();
            return false;
        }
        String string6 = new File(string5).getParent();
        String string7 = file3.getAbsolutePath();
        String string8 = string5;
        String[] stringArray = new String[]{System.getProperty("java.home") + FILE_SEPARATOR + "bin" + FILE_SEPARATOR + "javaw.exe", "-jar", file2.getAbsolutePath(), string5, string7, string8};
        if (!file2.exists()) {
            JOptionPane.showMessageDialog(window, MSG_UPGRADE_FAILED);
            return false;
        }
        try {
            Runtime.getRuntime().exec(stringArray, null, new File(string6));
        }
        catch (IOException iOException) {
            JOptionPane.showMessageDialog(window, MSG_UPGRADE_FAILED);
            return false;
        }
        if (!SGDrawingServer.quitHandler()) {
            JOptionPane.showMessageDialog(window, "Failed to terminate Samurai Graph application.");
            return false;
        }
        return true;
    }

    private boolean forOtherPlatform(Element element, String string, String string2, String string3, Window window, boolean bl) {
        return this.downloadWithFileChooser(element, string, string2, string3, window, bl, "samurai-graph-bin", "zip", "Zip Archive");
    }

    private boolean forMacOSX(Element element, String string, String string2, String string3, Window window, boolean bl) {
        return this.downloadWithFileChooser(element, string, string2, string3, window, bl, "samurai-graph-mac", "dmg.gz", "Compressed Disk Image");
    }

    private boolean downloadWithFileChooser(Element element, String string, String string2, String string3, Window window, boolean bl, String string4, String string5, String string6) {
        JFileChooser jFileChooser = this.mUpgradeFileChooser;
        jFileChooser.resetChoosableFileFilters();
        SGExtensionFileFilter sGExtensionFileFilter = new SGExtensionFileFilter();
        sGExtensionFileFilter.setDescription(string6);
        sGExtensionFileFilter.addExtension(string5);
        jFileChooser.setFileFilter(sGExtensionFileFilter);
        String string7 = string4 + "-" + string + "." + string2 + "." + string3 + "." + string5;
        jFileChooser.setSelectedFile(new File(string7));
        int n = jFileChooser.showSaveDialog(window);
        File file = null;
        switch (n) {
            case 0: {
                file = jFileChooser.getSelectedFile();
                break;
            }
            case 1: {
                return true;
            }
            case -1: {
                throw new Error();
            }
        }
        String string8 = file.getAbsolutePath();
        File file2 = new File(string8);
        return this.download(element, window, file2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean download(Element element, Window window, File file) {
        int n;
        BufferedOutputStream bufferedOutputStream = null;
        BufferedInputStream bufferedInputStream = null;
        SGProgressMonitorDialog sGProgressMonitorDialog = null;
        boolean bl = false;
        try {
            bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file));
            NodeList nodeList = element.getElementsByTagName("url");
            for (n = 0; n < nodeList.getLength(); ++n) {
                Element element2 = (Element)nodeList.item(n);
                String string = element2.getFirstChild().getNodeValue();
                URL uRL = null;
                try {
                    uRL = new URL(string);
                }
                catch (MalformedURLException malformedURLException) {
                    continue;
                }
                URLConnection uRLConnection = null;
                try {
                    uRLConnection = uRL.openConnection();
                    bufferedInputStream = new BufferedInputStream(uRLConnection.getInputStream());
                }
                catch (IOException iOException) {
                    continue;
                }
                String string2 = file.getAbsolutePath();
                int n2 = uRLConnection.getContentLength();
                boolean bl2 = true;
                if (window instanceof Dialog) {
                    sGProgressMonitorDialog = new SGProgressMonitorDialog((Dialog)window, bl2);
                } else if (window instanceof JFrame) {
                    sGProgressMonitorDialog = new SGProgressMonitorDialog((Frame)window, bl2);
                }
                JProgressBar jProgressBar = sGProgressMonitorDialog.getProgressBar();
                jProgressBar.setMinimum(0);
                jProgressBar.setMaximum(n2);
                jProgressBar.setStringPainted(true);
                sGProgressMonitorDialog.setInputSize(n2);
                sGProgressMonitorDialog.setInputStream(bufferedInputStream);
                sGProgressMonitorDialog.setOutputStream(bufferedOutputStream);
                sGProgressMonitorDialog.setLabel(string2);
                sGProgressMonitorDialog.pack();
                sGProgressMonitorDialog.setCenter(window);
                window.setCursor(Cursor.getPredefinedCursor(3));
                Thread thread = new Thread(sGProgressMonitorDialog);
                thread.start();
                sGProgressMonitorDialog.setVisible(true);
                if (sGProgressMonitorDialog.isCanceled()) {
                    boolean bl3 = false;
                    return bl3;
                }
                bl = true;
                break;
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            JOptionPane.showMessageDialog(window, MSG_LOCAL_FILE_NOT_FOUND);
            n = 0;
            return n != 0;
        }
        finally {
            window.setCursor(Cursor.getDefaultCursor());
            sGProgressMonitorDialog.setInputStream(null);
            sGProgressMonitorDialog.setOutputStream(null);
            if (bufferedInputStream != null) {
                try {
                    bufferedInputStream.close();
                }
                catch (IOException iOException) {}
            }
            if (bufferedOutputStream != null) {
                try {
                    bufferedOutputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        if (!bl) {
            JOptionPane.showMessageDialog(window, MSG_CONNECTION_FAILED);
            return false;
        }
        return true;
    }

    private void printNode(Element element, StringBuffer stringBuffer) {
        this.printNodeRecursively(element, stringBuffer, -1);
    }

    private void printNodeRecursively(Element element, StringBuffer stringBuffer, int n) {
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (node instanceof Element) {
                Element element2 = (Element)node;
                String string = element2.getTagName();
                if (string.equals("item")) {
                    NodeList nodeList2 = element2.getChildNodes();
                    int n2 = nodeList2.getLength();
                    if (n2 == 1) {
                        stringBuffer.append("<li>");
                        this.printFirstChild(element2, stringBuffer, n);
                        stringBuffer.append("</li>");
                        continue;
                    }
                    if (n2 <= 1) continue;
                    stringBuffer.append("<li>");
                    this.printFirstChild(element2, stringBuffer, n);
                    stringBuffer.append("<ul>");
                    for (int j = 0; j < n2; ++j) {
                        Node node2 = nodeList2.item(j);
                        if (!(node2 instanceof Element)) continue;
                        Element element3 = (Element)node2;
                        this.printNodeRecursively(element3, stringBuffer, n + 1);
                    }
                    stringBuffer.append("</ul>");
                    stringBuffer.append("</li>");
                    continue;
                }
                if (!string.equals("itemize")) continue;
                stringBuffer.append("<ul>");
                this.printNodeRecursively(element2, stringBuffer, n + 1);
                stringBuffer.append("</ul>");
                continue;
            }
            if (!(node instanceof Text)) continue;
        }
    }

    private void printFirstChild(Node node, StringBuffer stringBuffer, int n) {
        Node node2 = node.getFirstChild();
        this.printText(node2, stringBuffer, n);
    }

    private void printText(Node node, StringBuffer stringBuffer, int n) {
        String string = node.getNodeValue();
        String string2 = this.tokenize(string);
        if (string2.length() != 0) {
            stringBuffer.append(string2);
        }
    }

    private String tokenize(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        ArrayList<String> arrayList = new ArrayList<String>();
        while (stringTokenizer.hasMoreTokens()) {
            arrayList.add(stringTokenizer.nextToken());
        }
        String string2 = "";
        for (int i = 0; i < arrayList.size(); ++i) {
            String string3 = (String)arrayList.get(i);
            string2 = string2 + string3;
            if (i == arrayList.size() - 1) continue;
            string2 = string2 + " ";
        }
        return string2;
    }

    private boolean checkDate() {
        boolean bl;
        Preferences preferences = Preferences.userNodeForPackage(this.getClass());
        long l = preferences.getLong("Date", 0L);
        long l2 = System.currentTimeMillis();
        long l3 = l2 - l;
        int n = preferences.getInt("Upgrade Cycle", 1);
        switch (n) {
            case 0: {
                bl = false;
                break;
            }
            case 1: {
                bl = true;
                break;
            }
            case 2: {
                bl = l3 > 86400000L;
                break;
            }
            case 3: {
                bl = l3 > 604800000L;
                break;
            }
            case 4: {
                bl = l3 > 2592000000L;
                break;
            }
            default: {
                bl = false;
            }
        }
        return bl;
    }
}

