/*
 * Decompiled with CFR 0.152.
 */
package jp.riken.brain.ni.samuraigraph.application;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import jp.riken.brain.ni.samuraigraph.base.SGDialog;

public class SGUpgradeDialog
extends SGDialog {
    private static final long serialVersionUID = -8581885673785013955L;
    public static final String TITLE = "Auto Upgrade Settings";
    private JPanel mButtonPanel;
    private JButton mCancelButton;
    private JButton mOKButton;
    private JPanel mPanel;
    private JButton mUpgradeButton;
    private JComboBox mUpgradeCycleComboBox;
    private JLabel mUpgradeCycleLabel;
    public static final String NO_UPGRADE = "No Upgrade";
    public static final String EVERY_TIME = "Every Time";
    public static final String EVERY_DAY = "Every Day";
    public static final String EVERY_WEEK = "Every Week";
    public static final String EVERY_MONTH = "Every Month";
    public static final String UPGRADE_NOW = "Check for Update Now";
    private String mUpgrade = null;

    public SGUpgradeDialog() {
        this.initComponents();
        this.initProperty();
    }

    public SGUpgradeDialog(Frame frame, boolean bl) {
        super(frame, bl);
        this.initComponents();
        this.initProperty();
    }

    private void initComponents() {
        this.mPanel = new JPanel();
        this.mUpgradeCycleComboBox = new JComboBox();
        this.mUpgradeButton = new JButton();
        this.mUpgradeCycleLabel = new JLabel();
        this.mButtonPanel = new JPanel();
        this.mOKButton = new JButton();
        this.mCancelButton = new JButton();
        this.getContentPane().setLayout(new GridBagLayout());
        this.mPanel.setLayout(new GridBagLayout());
        this.mPanel.setBorder(new TitledBorder(null, "Configure Auto Upgrade", 0, 0, new Font("Dialog", 1, 12)));
        this.mUpgradeCycleComboBox.setFont(new Font("Dialog", 0, 12));
        this.mUpgradeCycleComboBox.setPreferredSize(new Dimension(111, 25));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(10, 5, 0, 10);
        this.mPanel.add((Component)this.mUpgradeCycleComboBox, gridBagConstraints);
        this.mUpgradeButton.setFont(new Font("Dialog", 1, 12));
        this.mUpgradeButton.setText(UPGRADE_NOW);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.ipadx = 1;
        gridBagConstraints.insets = new Insets(13, 10, 10, 10);
        this.mPanel.add((Component)this.mUpgradeButton, gridBagConstraints);
        this.mUpgradeCycleLabel.setFont(new Font("Dialog", 0, 12));
        this.mUpgradeCycleLabel.setText("Update Check Cycle");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(10, 10, 0, 5);
        this.mPanel.add((Component)this.mUpgradeCycleLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(10, 10, 0, 10);
        this.getContentPane().add((Component)this.mPanel, gridBagConstraints);
        this.mButtonPanel.setBorder(new EmptyBorder(new Insets(1, 1, 1, 1)));
        this.mOKButton.setFont(new Font("Dialog", 1, 12));
        this.mOKButton.setText("OK");
        this.mButtonPanel.add(this.mOKButton);
        this.mCancelButton.setFont(new Font("Dialog", 1, 12));
        this.mCancelButton.setText("Cancel");
        this.mButtonPanel.add(this.mCancelButton);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.getContentPane().add((Component)this.mButtonPanel, gridBagConstraints);
        this.pack();
    }

    private boolean initProperty() {
        this.setTitle(TITLE);
        String[] stringArray = new String[]{NO_UPGRADE, EVERY_TIME, EVERY_DAY, EVERY_WEEK, EVERY_MONTH};
        for (int i = 0; i < stringArray.length; ++i) {
            this.mUpgradeCycleComboBox.addItem(stringArray[i]);
        }
        this.pack();
        this.mOKButton.addActionListener(this);
        this.mCancelButton.addActionListener(this);
        this.mUpgradeButton.addActionListener(this);
        return true;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals("OK")) {
            this.onOK();
        } else if (string.equals("Cancel")) {
            this.onCanceled();
        } else if (string.equals(UPGRADE_NOW)) {
            this.notifyToListener(string);
        }
    }

    public String getUpgradeCycle() {
        return this.mUpgrade;
    }

    public void setUpgradeCycle(String string) {
        this.mUpgrade = string;
    }

    public void setVisible(boolean bl) {
        this.mUpgradeCycleComboBox.setSelectedItem(this.mUpgrade);
        super.setVisible(bl);
    }

    protected boolean onOK() {
        this.mUpgrade = (String)this.mUpgradeCycleComboBox.getSelectedItem();
        this.setVisible(false);
        this.notifyToListener("OK");
        return true;
    }

    protected boolean onCanceled() {
        this.setVisible(false);
        this.notifyToListener("Cancel");
        return true;
    }
}

