/*
 * Decompiled with CFR 0.152.
 */
package jp.riken.brain.ni.samuraigraph.application;

import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.WindowEvent;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import jp.riken.brain.ni.samuraigraph.base.SGDialog;
import jp.riken.brain.ni.samuraigraph.base.SGUtility;

public class SGProxySettingDialog
extends SGDialog {
    private static final long serialVersionUID = -8514470147936484758L;
    public static final String TITLE = "Connection Settings";
    private JPanel mButtonPanel;
    private JButton mCancelButton;
    private JRadioButton mDirectAccessRadioButton;
    private JLabel mHostNameLabel;
    private JTextField mHostNameTextField;
    private JRadioButton mManualRadioButton;
    private JButton mOKButton;
    private JPanel mPanel;
    private JLabel mPortNumberLabel;
    private JTextField mPortNumberTextField;
    private JLabel mSpaceLabel;
    private boolean mDirectAccessFlag = false;
    private String mHostName = null;
    private int mPortNumber = -1;

    public SGProxySettingDialog(Frame frame, boolean bl) {
        super(frame, bl);
        this.initComponents();
        this.initProperty();
    }

    private void initComponents() {
        this.mButtonPanel = new JPanel();
        this.mOKButton = new JButton();
        this.mCancelButton = new JButton();
        this.mPanel = new JPanel();
        this.mDirectAccessRadioButton = new JRadioButton();
        this.mManualRadioButton = new JRadioButton();
        this.mHostNameLabel = new JLabel();
        this.mHostNameTextField = new JTextField();
        this.mPortNumberLabel = new JLabel();
        this.mPortNumberTextField = new JTextField();
        this.mSpaceLabel = new JLabel();
        this.getContentPane().setLayout(new GridBagLayout());
        this.mOKButton.setFont(new Font("Dialog", 1, 12));
        this.mOKButton.setText("OK");
        this.mButtonPanel.add(this.mOKButton);
        this.mCancelButton.setFont(new Font("Dialog", 1, 12));
        this.mCancelButton.setText("Cancel");
        this.mButtonPanel.add(this.mCancelButton);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 14;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.getContentPane().add((Component)this.mButtonPanel, gridBagConstraints);
        this.mPanel.setLayout(new GridBagLayout());
        this.mPanel.setBorder(new TitledBorder(null, "Configure Proxy to Access the Internet", 0, 0, new Font("Dialog", 1, 12)));
        this.mDirectAccessRadioButton.setFont(new Font("Dialog", 0, 12));
        this.mDirectAccessRadioButton.setText("Direct connection to the Internet");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 10, 0, 0);
        this.mPanel.add((Component)this.mDirectAccessRadioButton, gridBagConstraints);
        this.mManualRadioButton.setFont(new Font("Dialog", 0, 12));
        this.mManualRadioButton.setText("Manual proxy configuration");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 10, 0, 0);
        this.mPanel.add((Component)this.mManualRadioButton, gridBagConstraints);
        this.mHostNameLabel.setFont(new Font("Dialog", 0, 12));
        this.mHostNameLabel.setText("HTTP Proxy:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(4, 5, 10, 5);
        this.mPanel.add((Component)this.mHostNameLabel, gridBagConstraints);
        this.mHostNameTextField.setColumns(20);
        this.mHostNameTextField.setFont(new Font("Dialog", 0, 12));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(4, 0, 10, 0);
        this.mPanel.add((Component)this.mHostNameTextField, gridBagConstraints);
        this.mPortNumberLabel.setFont(new Font("Dialog", 0, 12));
        this.mPortNumberLabel.setText("Port:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(4, 5, 10, 5);
        this.mPanel.add((Component)this.mPortNumberLabel, gridBagConstraints);
        this.mPortNumberTextField.setColumns(3);
        this.mPortNumberTextField.setFont(new Font("Dialog", 0, 12));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(4, 0, 10, 10);
        this.mPanel.add((Component)this.mPortNumberTextField, gridBagConstraints);
        this.mSpaceLabel.setText("        ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(4, 0, 10, 0);
        this.mPanel.add((Component)this.mSpaceLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(10, 10, 0, 10);
        this.getContentPane().add((Component)this.mPanel, gridBagConstraints);
        this.pack();
    }

    private boolean initProperty() {
        this.setTitle(TITLE);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.mDirectAccessRadioButton);
        buttonGroup.add(this.mManualRadioButton);
        this.mOKButton.addActionListener(this);
        this.mCancelButton.addActionListener(this);
        this.mDirectAccessRadioButton.addActionListener(this);
        this.mManualRadioButton.addActionListener(this);
        this.mHostNameTextField.addActionListener(this);
        this.mPortNumberTextField.addActionListener(this);
        return true;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        String string = actionEvent.getActionCommand();
        if (string.equals("OK") | object.equals(this.mHostNameTextField) | object.equals(this.mPortNumberTextField)) {
            this.onOK();
        } else if (string.equals("Cancel")) {
            this.onCanceled();
        } else if (object.equals(this.mDirectAccessRadioButton) | object.equals(this.mManualRadioButton)) {
            this.setDirectAccess(this.isDirectAccessFromRadioButton());
        }
    }

    protected boolean onOK() {
        String string = this.getHostFromTextField();
        int n = this.getPortNumberFromTextField();
        boolean bl = this.isDirectAccessFromRadioButton();
        int n2 = string.length();
        if (!bl && n2 == 0 | (n2 != 0 && n == -1)) {
            SGUtility.showIllegalInputErrorMessageDialog(this);
            return false;
        }
        this.mHostName = string;
        this.mPortNumber = n;
        this.mDirectAccessFlag = bl;
        this.setVisible(false);
        this.notifyToListener("OK");
        return true;
    }

    protected boolean onCanceled() {
        this.setVisible(false);
        this.notifyToListener("Cancel");
        return true;
    }

    private boolean isDirectAccessFromRadioButton() {
        return this.mDirectAccessRadioButton.isSelected();
    }

    private String getHostFromTextField() {
        return this.mHostNameTextField.getText();
    }

    private int getPortNumberFromTextField() {
        int n = -1;
        String string = this.mPortNumberTextField.getText();
        try {
            n = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return n;
    }

    public boolean isDirectAccess() {
        return this.mDirectAccessFlag;
    }

    public String getHostName() {
        return this.mHostName;
    }

    public int getPortNumber() {
        return this.mPortNumber;
    }

    public void setDirectAccess(boolean bl) {
        this.mDirectAccessFlag = bl;
        this.setManualComponents();
    }

    private void setManualComponents() {
        boolean bl = !this.mDirectAccessFlag;
        this.mManualRadioButton.setSelected(bl);
        this.mHostNameLabel.setEnabled(bl);
        this.mHostNameTextField.setEnabled(bl);
        this.mPortNumberLabel.setEnabled(bl);
        this.mPortNumberTextField.setEnabled(bl);
    }

    public void setHostName(String string) {
        this.mHostName = string;
    }

    public void setPortNumber(int n) {
        this.mPortNumber = n;
    }

    public void setVisible(boolean bl) {
        this.mDirectAccessRadioButton.setSelected(this.mDirectAccessFlag);
        this.mHostNameTextField.setText(this.mHostName);
        String string = null;
        string = this.mPortNumber > 0 ? Integer.toString(this.mPortNumber) : "";
        this.mPortNumberTextField.setText(string);
        super.setVisible(bl);
    }

    public void windowClosing(WindowEvent windowEvent) {
        super.windowClosing(windowEvent);
        this.onCanceled();
    }
}

