/*
 * Decompiled with CFR 0.152.
 */
package jp.riken.brain.ni.samuraigraph.application;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.lang.reflect.Method;
import java.net.ServerSocket;
import javax.swing.JOptionPane;
import javax.swing.UIManager;
import jp.riken.brain.ni.samuraigraph.application.SGApplicationProperties;
import jp.riken.brain.ni.samuraigraph.application.SGIApplicationConstants;
import jp.riken.brain.ni.samuraigraph.application.SGIApplicationTextConstants;
import jp.riken.brain.ni.samuraigraph.application.SGMainFunctions;
import jp.riken.brain.ni.samuraigraph.base.SGUtilityText;

public class SGDrawingServer
implements SGIApplicationConstants,
SGIApplicationTextConstants {
    public static String LOOK_AND_FEEL = null;
    public static int PORT_NUMBER = 5555;
    public static String PROPERTY_FILE_NAME = null;
    public static String DATASET_FILE_NAME = null;
    public static boolean INPUT_FLAG = false;
    private static SGMainFunctions mAppMain = null;
    private static SGApplicationProperties mAppProp = null;
    private static Connect mConnect = null;

    public static void main(String[] stringArray) {
        SGDrawingServer.interpretCommands(stringArray);
        mAppProp = new SGApplicationProperties();
        if (!mAppProp.getStatus()) {
            System.exit(1);
        }
        if (!SGDrawingServer.setLookAndFeel()) {
            System.exit(1);
        }
        SGMainFunctions sGMainFunctions = null;
        sGMainFunctions = PROPERTY_FILE_NAME != null ? new SGMainFunctions(PROPERTY_FILE_NAME, 1, mAppProp) : (DATASET_FILE_NAME != null ? new SGMainFunctions(DATASET_FILE_NAME, 2, mAppProp) : new SGMainFunctions(mAppProp));
        try {
            sGMainFunctions.waitInit();
            mAppMain = sGMainFunctions;
            SGDrawingServer.MacOSXRegistration();
            if (INPUT_FLAG) {
                ServerSocket serverSocket = null;
                mConnect = new Connect(sGMainFunctions, serverSocket);
            }
        }
        catch (Exception exception) {
            JOptionPane.showOptionDialog(null, "Failed to start up Samurai Graph.", "Error", -1, 2, null, null, null);
        }
    }

    private static void interpretCommands(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            Object object;
            if (stringArray[i].equals("-p")) {
                if (i + 1 >= stringArray.length || (object = SGUtilityText.getInteger(stringArray[i + 1])) == null) continue;
                PORT_NUMBER = (Integer)object;
                continue;
            }
            if (stringArray[i].equals("-prop")) {
                if (i + 1 >= stringArray.length) continue;
                PROPERTY_FILE_NAME = stringArray[i + 1];
                continue;
            }
            if (stringArray[i].equals("-dataset")) {
                if (i + 1 >= stringArray.length) continue;
                DATASET_FILE_NAME = stringArray[i + 1];
                continue;
            }
            if (stringArray[i].equals("-i")) {
                INPUT_FLAG = true;
                continue;
            }
            if (!stringArray[i].equals("-laf") || i + 1 >= stringArray.length || (object = SGDrawingServer.getLookAndFeelClassName(stringArray[i + 1].toLowerCase())) == null) continue;
            LOOK_AND_FEEL = object;
        }
    }

    private static String getLookAndFeelClassName(String string) {
        if (string == null) {
            throw new IllegalArgumentException("name==null");
        }
        UIManager.LookAndFeelInfo[] lookAndFeelInfoArray = UIManager.getInstalledLookAndFeels();
        for (int i = 0; i < lookAndFeelInfoArray.length; ++i) {
            String string2 = lookAndFeelInfoArray[i].getName().toLowerCase();
            if (!string2.equals(string.toLowerCase())) continue;
            LOOK_AND_FEEL = lookAndFeelInfoArray[i].getClassName();
        }
        return null;
    }

    private static boolean setLookAndFeel() {
        try {
            if (LOOK_AND_FEEL == null) {
                UIManager.getInstalledLookAndFeels();
                UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            } else {
                UIManager.setLookAndFeel(LOOK_AND_FEEL);
            }
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    private static void MacOSXRegistration() {
        boolean bl = System.getProperty("os.name").toLowerCase().startsWith("mac os x");
        if (bl) {
            try {
                Class<?> clazz = Class.forName("jp.riken.brain.ni.samuraigraph.platform.macosx.SGMacOSXAdapter");
                Method method = clazz.getMethod("registerMacOSXApplication", null);
                if (method != null) {
                    method.invoke(clazz, null);
                }
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                System.err.println("This version of Mac OS X does not support the Apple EAWT.  Application Menu handling has been disabled (" + noClassDefFoundError + ")");
            }
            catch (ClassNotFoundException classNotFoundException) {
                System.err.println("This version of Mac OS X does not support the Apple EAWT.  Application Menu handling has been disabled (" + classNotFoundException + ")");
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public static boolean quitHandler() {
        if (mAppMain == null) {
            return false;
        }
        mAppMain.exit();
        return true;
    }

    public static boolean aboutHandler() {
        if (mAppMain == null) {
            return false;
        }
        return mAppMain.showAboutDialog(null);
    }

    public static boolean openFileHandler(String string) {
        if (mAppMain == null) {
            return false;
        }
        return mAppMain.openFile(null, string);
    }

    private static class Connect
    extends Thread {
        private ServerSocket mServerSocket = null;
        private SGMainFunctions mMain;

        private Connect(SGMainFunctions sGMainFunctions, ServerSocket serverSocket) {
            this.mMain = sGMainFunctions;
            this.mServerSocket = serverSocket;
            this.start();
        }

        public void run() {
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in));
            BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(System.out));
            try {
                while (true) {
                    String string;
                    if ((string = bufferedReader.readLine()) == null) {
                        continue;
                    }
                    int n = this.mMain.exec(string);
                    String string2 = Integer.toString(n) + "\n";
                    bufferedWriter.write(string2);
                    bufferedWriter.flush();
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                return;
            }
        }
    }
}

