/*
 * Decompiled with CFR 0.152.
 */
package jp.riken.brain.ni.samuraigraph.application;

import java.awt.Window;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import jp.riken.brain.ni.samuraigraph.application.SGIApplicationTextConstants;
import jp.riken.brain.ni.samuraigraph.base.SGIConstants;
import jp.riken.brain.ni.samuraigraph.base.SGUtility;
import org.w3c.dom.DOMImplementation;

public class SGApplicationUtility
implements SGIApplicationTextConstants {
    public static void deleteRecursively(File file) {
        if (file.isDirectory()) {
            String string = SGIConstants.FILE_SEPARATOR;
            String[] stringArray = file.list();
            for (int i = 0; i < stringArray.length; ++i) {
                File file2 = new File(file + string + stringArray[i]);
                SGApplicationUtility.deleteRecursively(file2);
            }
        }
        file.delete();
    }

    public static void deleteOnExitRecursively(File file) {
        if (file.isDirectory()) {
            String string = SGIConstants.FILE_SEPARATOR;
            String[] stringArray = file.list();
            for (int i = 0; i < stringArray.length; ++i) {
                File file2 = new File(file + string + stringArray[i]);
                SGApplicationUtility.deleteOnExitRecursively(file2);
            }
        }
        file.deleteOnExit();
    }

    public static boolean copyBinaryFile(File file, File file2) throws IOException {
        int n;
        if (file == null | file2 == null) {
            return false;
        }
        FileInputStream fileInputStream = null;
        FileOutputStream fileOutputStream = null;
        try {
            fileInputStream = new FileInputStream(file);
            fileOutputStream = new FileOutputStream(file2);
        }
        catch (FileNotFoundException fileNotFoundException) {
            if (fileInputStream != null) {
                fileInputStream.close();
            }
            if (fileOutputStream != null) {
                fileOutputStream.close();
            }
            return false;
        }
        BufferedInputStream bufferedInputStream = new BufferedInputStream(fileInputStream);
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(fileOutputStream);
        byte[] byArray = new byte[1024];
        while ((n = bufferedInputStream.read(byArray, 0, 1024)) != -1) {
            bufferedOutputStream.write(byArray, 0, n);
        }
        bufferedInputStream.close();
        bufferedOutputStream.close();
        return true;
    }

    public static boolean copyBinaryFile(String string, String string2) throws IOException {
        if (string == null || string2 == null) {
            return false;
        }
        return SGApplicationUtility.copyBinaryFile(new File(string), new File(string2));
    }

    public static DOMImplementation getDOMImplementation() {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = null;
        try {
            documentBuilder = documentBuilderFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            return null;
        }
        DOMImplementation dOMImplementation = documentBuilder.getDOMImplementation();
        return dOMImplementation;
    }

    public static void findFiles(File file, String string, ArrayList arrayList) {
        if (!file.isDirectory()) {
            return;
        }
        File[] fileArray = file.listFiles();
        for (int i = 0; i < fileArray.length; ++i) {
            if (fileArray[i].isDirectory()) {
                SGApplicationUtility.findFiles(fileArray[i], string, arrayList);
                continue;
            }
            String string2 = fileArray[i].getName();
            if (!string2.equals(string)) continue;
            arrayList.add(fileArray[i].getAbsolutePath());
        }
    }

    public static boolean compareVersionNumber(int n, int n2, int n3, int n4, int n5, int n6) {
        boolean bl = n < n4 ? true : (n == n4 ? (n2 < n5 ? true : (n2 == n5 ? n3 < n6 : false)) : false);
        return bl;
    }

    public static final void showDataFileInvalidMessageDialog(Window window) {
        SGUtility.showErrorMessageDialog(window, "The data file is invalid.", "Error");
    }

    public static final void showDataTypeInvalidMessageDialog(Window window) {
        SGUtility.showErrorMessageDialog(window, "The data type is invalid.", "Error");
    }
}

