/*
 * Decompiled with CFR 0.152.
 */
package jp.riken.brain.ni.samuraigraph.figure;

import java.awt.Color;
import java.awt.Font;
import java.util.List;
import jp.riken.brain.ni.samuraigraph.base.SGDrawingElement;
import jp.riken.brain.ni.samuraigraph.base.SGIConstants;
import jp.riken.brain.ni.samuraigraph.base.SGIDrawingElementConstants;
import jp.riken.brain.ni.samuraigraph.base.SGProperties;
import jp.riken.brain.ni.samuraigraph.base.SGTuple2f;
import jp.riken.brain.ni.samuraigraph.base.SGUtilityText;
import jp.riken.brain.ni.samuraigraph.figure.SGIStringConstants;
import org.w3c.dom.Element;

public abstract class SGDrawingElementString
extends SGDrawingElement
implements SGIStringConstants,
SGIDrawingElementConstants {
    private String mString = null;
    private Font mFont = null;
    private String mFontName = "Serif";
    private int mFontStyle = 0;
    private float mFontSize = 16.0f;
    private float mAngle = 0.0f;
    private float mX = 0.0f;
    private float mY = 0.0f;

    public SGDrawingElementString() {
        this.mString = new String("");
        super.setColor(DEFAULT_STRING_FONT_COLOR);
        this.updateFont();
    }

    public SGDrawingElementString(String string) {
        this.mString = new String(string);
        super.setColor(DEFAULT_STRING_FONT_COLOR);
        this.updateFont();
    }

    public SGDrawingElementString(SGDrawingElementString sGDrawingElementString) {
        this.mString = new String(sGDrawingElementString.mString);
        this.mX = sGDrawingElementString.mX;
        this.mY = sGDrawingElementString.mY;
        this.mFontName = sGDrawingElementString.getFontName();
        this.mFontStyle = sGDrawingElementString.getFontStyle();
        this.mFontSize = sGDrawingElementString.getFontSize();
        this.mAngle = sGDrawingElementString.mAngle;
        super.setColorList(sGDrawingElementString.getColorList());
        super.setMagnification(sGDrawingElementString.getMagnification());
        this.updateFont();
    }

    public SGDrawingElementString(String string, String string2, int n, float f, Color color, float f2, float f3) {
        this.mString = new String(string);
        this.mFontName = string2;
        this.mFontStyle = n;
        this.mFontSize = f;
        this.mAngle = f3;
        super.setColor(color);
        super.setMagnification(f2);
        this.updateFont();
    }

    public void dispose() {
        super.dispose();
        this.mString = null;
        this.mFont = null;
        this.mFontName = null;
    }

    public final String toString() {
        return this.getString();
    }

    public boolean setString(String string) {
        this.mString = new String(string);
        return true;
    }

    public boolean setMagnification(float f) {
        super.setMagnification(f);
        this.updateFont();
        return true;
    }

    public final boolean setFontName(String string) {
        return this.setFont(string, this.mFontStyle, this.mFontSize);
    }

    public final boolean setFontStyle(int n) {
        return this.setFont(this.mFontName, n, this.mFontSize);
    }

    public final boolean setFontSize(float f) {
        return this.setFont(this.mFontName, this.mFontStyle, f);
    }

    public final boolean setFontSize(float f, String string) {
        double d = SGUtilityText.convert(f, string, "pt");
        if (d < 6.0) {
            return false;
        }
        if (d > 96.0) {
            return false;
        }
        return this.setFontSize((float)SGUtilityText.convertToPoint(f, string));
    }

    public boolean setFont(String string, int n, float f) {
        this.mFontName = string;
        this.mFontStyle = n;
        this.mFontSize = f;
        this.updateFont();
        return true;
    }

    private boolean updateFont() {
        this.mFont = new Font(this.mFontName, this.mFontStyle, (int)(this.getMagnification() * this.mFontSize));
        return true;
    }

    public final boolean setLocation(SGTuple2f sGTuple2f) {
        if (sGTuple2f == null) {
            throw new IllegalArgumentException("pos==null");
        }
        this.setLocation(sGTuple2f.x, sGTuple2f.y);
        return true;
    }

    public final boolean setLocation(float f, float f2) {
        this.setX(f);
        this.setY(f2);
        return true;
    }

    public final void translate(float f, float f2) {
        this.setLocation(this.getX() + f, this.getY() + f2);
    }

    public boolean setX(float f) {
        this.mX = f;
        return true;
    }

    public boolean setY(float f) {
        this.mY = f;
        return true;
    }

    public boolean setAngle(float f) {
        this.mAngle = f;
        return true;
    }

    public final String getString() {
        return new String(this.mString);
    }

    public float getX() {
        return this.mX;
    }

    public float getY() {
        return this.mY;
    }

    public final SGTuple2f getLocation() {
        return new SGTuple2f(this.getX(), this.getY());
    }

    public final Font getFont() {
        return this.mFont;
    }

    public final String getFontName() {
        return this.mFontName;
    }

    public final float getFontSize() {
        return this.mFontSize;
    }

    public final int getFontStyle() {
        return this.mFontStyle;
    }

    public final float getAngle() {
        return this.mAngle;
    }

    public SGProperties getProperties() {
        StringProperties stringProperties = new StringProperties();
        this.getProperties(stringProperties);
        return stringProperties;
    }

    public boolean getProperties(SGProperties sGProperties) {
        if (sGProperties == null) {
            return false;
        }
        if (!(sGProperties instanceof StringProperties)) {
            return false;
        }
        super.getProperties(sGProperties);
        StringProperties stringProperties = (StringProperties)sGProperties;
        stringProperties.setFontName(this.mFontName);
        stringProperties.setFontSize(this.mFontSize);
        stringProperties.setFontStyle(this.mFontStyle);
        stringProperties.setAngle(this.mAngle);
        return true;
    }

    public boolean setProperties(SGProperties sGProperties) {
        if (!(sGProperties instanceof StringProperties)) {
            return false;
        }
        if (!super.setProperties(sGProperties)) {
            return false;
        }
        StringProperties stringProperties = (StringProperties)sGProperties;
        this.setFont(stringProperties.getFontName(), stringProperties.getFontStyle(), stringProperties.getFontSize().floatValue());
        this.setAngle(stringProperties.getAngle().floatValue());
        return true;
    }

    public boolean writeProperty(Element element) {
        element.setAttribute("Text", this.getString());
        element.setAttribute("FontName", this.getFontName());
        element.setAttribute("FontSize", Float.toString(this.getFontSize()) + "pt");
        element.setAttribute("FontStyle", SGUtilityText.getFontStyleName(this.getFontStyle()));
        element.setAttribute("StringColor", SGUtilityText.getColorListString(this.getColorList()));
        element.setAttribute("Angle", Float.toString(this.getAngle() / ((float)Math.PI / 180)) + SGIConstants.degree);
        return true;
    }

    public boolean readProperty(Element element) {
        CharSequence charSequence;
        String string = null;
        Number number = null;
        Object var4_4 = null;
        Object var5_5 = null;
        List list = null;
        string = element.getAttribute("Text");
        if (string.length() != 0 && !this.setString((String)(charSequence = string))) {
            return false;
        }
        string = element.getAttribute("FontName");
        if (string.length() != 0 && !this.setFontName((String)(charSequence = string))) {
            return false;
        }
        string = element.getAttribute("FontSize");
        if (string.length() != 0) {
            charSequence = new StringBuffer();
            number = SGUtilityText.getNumber(string, (StringBuffer)charSequence);
            if (number == null) {
                return false;
            }
            float f = number.floatValue();
            if (!this.setFontSize(f, ((StringBuffer)charSequence).toString())) {
                return false;
            }
        }
        if ((string = element.getAttribute("FontStyle")).length() != 0) {
            int n = SGUtilityText.getFontStyle(string);
            if (n == -1) {
                return false;
            }
            if (!this.setFontStyle(n)) {
                return false;
            }
        }
        if ((string = element.getAttribute("StringColor")).length() != 0) {
            list = SGUtilityText.getColorList(string);
            if (list == null) {
                return false;
            }
            if (list.size() < 1) {
                return false;
            }
            Color color = (Color)list.get(0);
            if (!this.setColor(color)) {
                return false;
            }
        }
        if ((string = element.getAttribute("Angle")).length() != 0) {
            number = SGUtilityText.getFloat(string, SGIConstants.degree);
            if (number == null) {
                return false;
            }
            float f = number.floatValue() * ((float)Math.PI / 180);
            if (!this.setAngle(f)) {
                return false;
            }
        }
        return true;
    }

    public static class StringProperties
    extends SGDrawingElement.DrawingElementProperties {
        private float mFontSize = 0.0f;
        private int mFontStyle = -1;
        private String mFontName = null;
        private float mAngle = 0.0f;

        public boolean equals(Object object) {
            if (!(object instanceof StringProperties)) {
                return false;
            }
            if (!super.equals(object)) {
                return false;
            }
            StringProperties stringProperties = (StringProperties)object;
            if (this.mFontSize != stringProperties.mFontSize) {
                return false;
            }
            if (this.mFontStyle != stringProperties.mFontStyle) {
                return false;
            }
            if (!this.mFontName.equals(stringProperties.mFontName)) {
                return false;
            }
            return this.mAngle == stringProperties.mAngle;
        }

        public String getFontName() {
            return this.mFontName;
        }

        public Float getFontSize() {
            return new Float(this.mFontSize);
        }

        public Integer getFontStyle() {
            return new Integer(this.mFontStyle);
        }

        public Float getAngle() {
            return new Float(this.mAngle);
        }

        public boolean setFontName(String string) {
            this.mFontName = string;
            return true;
        }

        public boolean setFontSize(float f) {
            this.mFontSize = f;
            return true;
        }

        public boolean setFontStyle(int n) {
            this.mFontStyle = n;
            return true;
        }

        public boolean setAngle(float f) {
            this.mAngle = f;
            return true;
        }
    }
}

