/*
 * Decompiled with CFR 0.152.
 */
package foxtrot.pumps;

import foxtrot.EventPump;
import foxtrot.Task;
import foxtrot.pumps.EventFilter;
import foxtrot.pumps.EventFilterable;
import java.awt.AWTEvent;
import java.awt.ActiveEvent;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.MenuComponent;
import java.awt.Toolkit;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;

public class JDK13QueueEventPump
implements EventPump,
EventFilterable {
    private static final boolean debug = false;
    private EventFilter filter;

    public void setEventFilter(EventFilter filter) {
        this.filter = filter;
    }

    public EventFilter getEventFilter() {
        return this.filter;
    }

    public void pumpEvents(Task task) {
        if (task == null) {
            return;
        }
        EventQueue queue = this.getEventQueue();
        while (!task.isCompleted()) {
            try {
                AWTEvent event = queue.getNextEvent();
                if (this.filter != null && !this.filter.accept(event)) continue;
                try {
                    this.dispatchEvent(queue, event);
                }
                catch (Throwable x) {
                    this.handleThrowable(x);
                }
            }
            catch (InterruptedException x) {
                Thread.currentThread().interrupt();
                break;
            }
        }
    }

    protected void dispatchEvent(EventQueue queue, AWTEvent event) {
        Object source = event.getSource();
        if (event instanceof ActiveEvent) {
            ((ActiveEvent)((Object)event)).dispatch();
        } else if (source instanceof Component) {
            ((Component)source).dispatchEvent(event);
        } else if (source instanceof MenuComponent) {
            ((MenuComponent)source).dispatchEvent(event);
        } else {
            System.err.println("[JDK13QueueEventPump] Unable to dispatch event " + event);
        }
    }

    protected void handleThrowable(Throwable x) {
        String handlerName = (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return System.getProperty("sun.awt.exception.handler");
            }
        });
        if (handlerName != null) {
            try {
                Object handler = Thread.currentThread().getContextClassLoader().loadClass(handlerName).newInstance();
                Method handle = handler.getClass().getMethod("handle", Throwable.class);
                handle.invoke(handler, x);
                return;
            }
            catch (Throwable ignored) {
                System.err.println("[JDK13QueueEventPump] Exception occurred while invoking AWT exception handler: " + ignored);
            }
        }
        System.err.println("[JDK13QueueEventPump] Exception occurred during event dispatching:");
        x.printStackTrace();
    }

    private EventQueue getEventQueue() {
        return (EventQueue)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return Toolkit.getDefaultToolkit().getSystemEventQueue();
            }
        });
    }
}

