package jp.riken.brain.ni.samuraigraph.base;


/**
 * 
 */
public interface SGIProgressControl
{
	
	/**
	 * Start the timer of the Progress Bar.
	 * 
	 */
	public boolean startProgress();

	/**
	 * End the timer of the Progress Bar.
	 */
	public boolean endProgress();

	/**
	 * Set the value (0~1) to the Progress Bar
	 * 
	 * @param ratio
	 *            progress ratio
	 */
	public void setProgressValue( final float ratio );

	/**
	 * Set the Indeterminate mode of the Progress Bar
	 * 
	 * @param mode
	 *            indeterminate mode
	 */
	public void setIndeterminateProgress( final boolean mode );

	/**
	 * Set the messsage of the Progress bar.
	 * @param msg
	 *            progress messasge
	 */
	public void setProgressMessage( final String msg );
}
