
package jp.riken.brain.ni.samuraigraph.base;


import java.awt.Color;
import java.util.ArrayList;


/**
 * An object to manage axes.
 */
public interface SGIFigureElementAxis extends SGIFigureElement
{

	/**
	 * 
	 */
	public static final int TWO_DIMENSIONAL_AXIS = 0;
	public static final int THREE_DIMENSIONAL_AXIS = 1;


	/**
	 * 
	 */
	public static final int AXIS_HORIZONTAL_1 = 0;
	public static final int AXIS_HORIZONTAL_2 = 1;
	public static final int AXIS_PERPENDICULAR_1 = 2;
	public static final int AXIS_PERPENDICULAR_2 = 3;


	/**
	 * 
	 */
	public static final int VIEW_XY = 0;
	public static final int VIEW_XZ = 1;
	public static final int VIEW_YZ = 2;


	/**
	 * 
	 */
	public static final int LOCATION_XAXIS_1 = 1;
	public static final int LOCATION_XAXIS_2 = 2;
	public static final int LOCATION_XAXIS_3 = 3;
	public static final int LOCATION_XAXIS_4 = 4;
	public static final int LOCATION_YAXIS_1 = 5;
	public static final int LOCATION_YAXIS_2 = 6;
	public static final int LOCATION_YAXIS_3 = 7;
	public static final int LOCATION_YAXIS_4 = 8;
	public static final int LOCATION_ZAXIS_1 = 9;
	public static final int LOCATION_ZAXIS_2 = 10;
	public static final int LOCATION_ZAXIS_3 = 11;
	public static final int LOCATION_ZAXIS_4 = 12;


	/**
	 * 
	 */
	public static final String AXIS_TOP = "Top";
	public static final String AXIS_BOTTOM = "Bottom";
	public static final String AXIS_LEFT = "Left";
	public static final String AXIS_RIGHT = "Right";

	
	/**
	 * 
	 */	
	public static final String LEFT_TOP = "Left-Top";
	public static final String LEFT_BOTTOM = "Left-Bottom";
	public static final String RIGHT_TOP = "Right-Top";
	public static final String RIGHT_BOTTOM = "Right-Bottom";
	
	
	public static final String MENUCMD_HIDE = "Hide Axis";

	public static final String MENUCMD_DRAW_LATER = "Draw Later";

	
	/**
	 * 
	 * @return
	 */
	public ArrayList getXAxisList();


	/**
	 * 
	 * @return
	 */
	public ArrayList getYAxisList();


	/**
	 * 
	 * @return
	 */
	public ArrayList getZAxisList();



	/**
	 * 
	 * @return
	 */
	public ArrayList getAxisList();


	/**
	 * 
	 */
	public ArrayList getHorizontalAxisList();


	/**
	 * 
	 */
	public ArrayList getPerpendicularAxisList();


	/**
	 * 
	 */
	public ArrayList getNormalAxisList();

	
	/**
	 * 
	 * @param axis
	 * @return
	 */
	public boolean isHorizontal( final SGAxis axis );

	
	/**
	 * 
	 * @param axis
	 * @return
	 */
	public boolean isPerpendicular( final SGAxis axis );
	

	/**
	 * 
	 * @param axis
	 * @return
	 */
	public boolean isNormal( final SGAxis axis );


	
	/**
	 * Returns string representation of the axis location.
	 * @param locationInPlane - One of the following parameters:
	 * AXIS_HORIZONTAL_1, AXIS_HORIZONTAL_2, AXIS_PERPENDICULAR_1 and AXIS_PERPENDICULAR_2
	 * @return	String representation of the axis location
	 */
	public String getLocationName( final int locationInPlane );
	
	
	/**
	 * Returns string representation of the axis location.
	 * @param axis	an axis
	 * @return	String representation of the axis location
	 */
	public String getLocationName( final SGAxis axis );


	/**
	 * 
	 * @return
	 */
	public int getLocationInCube( final int locationInPlane );

	
	/**
	 * 
	 * @param axis
	 * @return
	 */
	public int getLocationInCube( final SGAxis axis );


	/**
	 * 
	 */
	public int getLocationInPlane( final SGAxis axis );


	/**
	 * 
	 */
	public SGAxis getAxisInCube( final int locationInCube );


	/**
	 * 
	 */
	public SGAxis getAxisInPlane( final int locationInPlane );


	/**
	 * 
	 * @return
	 */
	public int getLocationInPlane( final int locationInCube );


	/**
	 * 
	 */
	public String getLocationString( final int locationInCube );


	/**
	 * 
	 */
	public int getLocationInCube( final String str );


	/**
	 * 
	 * @param str
	 * @return
	 */
	public SGAxis getAxis( final String str );

	

	/**
	 * @return
	 * @uml.property  name="spaceAxisLineAndNumber"
	 */
	public boolean setSpaceAxisLineAndNumber( final float space );


	/**
	 * @return
	 * @uml.property  name="spaceNumberAndTitle"
	 */
	public boolean setSpaceNumberAndTitle( final float space );




	/**
	 * @uml.property  name="spaceAxisLineAndNumber"
	 */
	public float getSpaceAxisLineAndNumber();


	/**
	 * @uml.property  name="spaceNumberAndTitle"
	 */
	public float getSpaceNumberAndTitle();



	/**
	 * 
	 */
	public float getNumberFontSize();


	/**
	 * 
	 */
	public float getTitleFontSize();


	/**
	 * 
	 * @param config
	 * @param x
	 * @param y
	 * @return
	 */	
	public double getValue( final int config, final int x, final int y );



	public static final String TAG_NAME_AXES = "Axes";
//	public static final String KEY_VIEW_DIRECTION = "ViewDirection";
	public static final String KEY_LINE_COLOR = "LineColor";
	public static final String KEY_AXIS_LINE_WIDTH = "AxisLineWidth";
	public static final String KEY_TICK_MARK_WIDTH = "TickMarkWidth";
	public static final String KEY_TICK_MARK_LENGTH = "TickMarkLength";
	public static final String KEY_FRAME_LINE_VISIBLE = "FrameLineVisible";
	public static final String KEY_FRAME_LINE_WIDTH = "FrameLineWidth";
	public static final String KEY_FRAME_LINE_COLOR = "FrameLineColor";
	public static final String KEY_AXIS_STRING_COLOR = "StringColor";
	
	public static final String TAG_NAME_AXIS = "Axis";
	public static final String KEY_POSITION = "Position";
	public static final String KEY_AXIS_MIN_VALUE = "MinValue";
	public static final String KEY_AXIS_MAX_VALUE = "MaxValue";
	public static final String KEY_AXIS_INVERT_COORDINATES = "InvertCoordinates";
	public static final String KEY_AXIS_SCALE_TYPE = "ScaleType";
	public static final String KEY_STEP_VALUE = "StepValue";
	public static final String KEY_BASELINE_VALUE = "BaselineValue";
	public static final String KEY_AUTO_CALC_NUMBER = "AutomaticCalculationOfTick";
	public static final String KEY_TITLE_TEXT = "Title";
	public static final String KEY_AXIS_VISIBLE = "AxisVisible";
	public static final String KEY_TITLE_VISIBLE = "TitleVisible";
	public static final String KEY_TICK_MARK_VISIBLE = "TickMarkVisible";
	public static final String KEY_NUMBER_VISIBLE = "NumberVisible";
	public static final String KEY_TICK_MARK_INSIDE = "TickMarkInside";
	public static final String KEY_NUMBER_INTEGER = "NumberInteger";
	public static final String KEY_EXPONENT_VISIBLE = "Exponent";
	public static final String KEY_EXPONENT_VALUE = "ExponentValue";


	public boolean setFontNameDirectly( final String value );
	public boolean setFontStyleDirectly( final int value );
	public boolean setFontSizeDirectly( final float value, final String unit );
	public boolean setFontColorDirectly( final Color value );
	public boolean setFrameVisibleDirectly( final boolean value );
	public boolean setFrameLineWidthDirectly( final float value, final String unit );
	public boolean setFrameLineColorDirectly( final Color value );
	public boolean setAxisLineWidthDirectly( final float value, final String unit );
	public boolean setTickMarkWidthDirectly( final float value, final String unit );
	public boolean setTickMarkLengthDirectly( final float value, final String unit );
	public boolean setLineColorDirectly( final Color value );


	public boolean setAxisVisibleDirectly( final String location, final boolean value );
	public boolean setTitleVisibleDirectly( final String location, final boolean value );
	public boolean setTitleDirectly( final String location, final String value );
	public boolean setMinValueDirectly( final String location, final double value );
	public boolean setMaxValueDirectly( final String location, final double value );
	public boolean setScaleTypeDirectly( final String location, final int value );
	public boolean setTickMarkVisibleDirectly( final String location, final boolean value );
	public boolean setTickMarkAutoDirectly( final String location, final boolean value );
	public boolean setTickMarkStepDirectly( final String location, final double value );
	public boolean setTickMarkBaseDirectly( final String location, final double value );
	public boolean setTickMarkInnerDirectly( final String location, final boolean value );
	public boolean setFormatVisibleDirectly( final String location, final boolean value );
	public boolean setFormatIntegerDirectly( final String location, final boolean value );
	public boolean setFormatExponentVisibleDirectly( final String location, final boolean value );
	public boolean setFormatExponentValueDirectly( final String location, final int value );


}

