@echo off

setlocal

set LOG_FILE=%cd%\samirai-graph.log

rem set directory

set CURRENT_PATH=%cd%\
set SCRIPT_PATH=%~d0%~p0
set CONTRIB_PATH=%SCRIPT_PATH%..
set TOOLS_PATH=%SCRIPT_PATH%..\..\tools
set FREEHEP_PATH=%SCRIPT_PATH%
set FREEHEP_TOOLS_PATH=%SCRIPT_PATH%tools

rem set absolute directory

cd /d %SCRIPT_PATH%
set SCRIPT_PATH=%cd%\
cd /d %CONTRIB_PATH%
set CONTRIB_PATH=%cd%\
cd /d %TOOLS_PATH%
set TOOLS_PATH=%cd%\
cd /d %FREEHEP_PATH%
set FREEHEP_PATH=%cd%\
cd /d %FREEHEP_TOOLS_PATH%
set FREEHEP_TOOLS_PATH=%cd%\
cd /d %CURRENT_PATH%

rem set done file

set DONE_FILE=%CONTRIB_PATH%_build_vectorgraphics_done

rem build depend jar files
set FREEHEP_BUILDTOOLS_JAR=%FREEHEP_TOOLS_PATH%freehep-buildtools.jar
set JNLP_JAR=%TOOLS_PATH%jnlp.jar

rem class path
set CLASSPATH=%FREEHEP_BUILDTOOLS_JAR%;%JNLP_JAR%

rem ant command
set ANT=%TOOLS_PATH%ant.bat

goto check_arguments

rem build functions

:build_vectorgraphics
set errcode=0
cd /d "%SCRIPT_PATH%"
if exist %DONE_FILE% goto build_vectorgraphics_done
  set JARFILES=base graphics2d graphicsio graphicsio-cgm graphicsio-emf graphicsio-gif graphicsio-java graphicsio-pdf graphicsio-ppm graphicsio-ps graphicsio-svg graphicsio-swf
  for %%i in ( %JARFILES% ) do (
    echo [vectorgraphics] creating freehep-%%i.jar ...
    call "%ANT%" -Djar=%%i > "%LOG_FILE%" 2>&1
    if errorlevel 1 (
      set errcode=1;
      echo error
      type "%LOG_FILE%"
      del /f "%LOG_FILE%" 
      exit /b 1
    )
    del /f "%LOG_FILE%" 
  )
  :build_vectorgraphics_success
  copy nul "%DONE_FILE%" > nul 2>&1
:build_vectorgraphics_done
cd /d "%CURRENT_PATH%"
goto %RETURN_LABEL%

:clean_vectorgraphics
set errcode=0
cd /d "%SCRIPT_PATH%"
if not exist %DONE_FILE% goto clean_vectorgraphics_done
del /f %FREEHEP_PATH%lib\freehep-version.txt 2>&1
echo [vectorgraphics] deleting jar files ...
call "%ANT%" veryclean > "%LOG_FILE%" 2>&1
if errorlevel 0 goto clean_vectorgraphics_success
set errcode=1
echo error
type "%LOG_FILE%"
goto clean_vectorgraphics_clean
:clean_vectorgraphics_success
del /f "%DONE_FILE%"
:clean_vectorgraphics_clean
del /f "%LOG_FILE%"
:clean_vectorgraphics_done
cd /d "%CURRENT_PATH%"
goto %RETURN_LABEL%

:check_arguments
if "%1" == "" goto print_usage
if "%1" == "build" goto do_build
if "%1" == "rebuild" goto do_rebuild
if "%1" == "clean" goto do_clean

:print_usage
echo Usage: %0 { build, rebuild, clean }
goto finised

:do_build
set RETURN_LABEL=finised
goto build_vectorgraphics

:do_rebuild
set RETURN_LABEL=do_rebuild2
goto clean_vectorgraphics
:do_rebuild2
if %errcode% == 1 goto finised
set RETURN_LABEL=finised
goto build_vectorgraphics

:do_clean
set RETURN_LABEL=finised
goto clean_vectorgraphics

:finised

endlocal
