/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio.java;

import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.FlatteningPathIterator;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public class JAVAGeneralPath
implements Shape {
    private int rule;
    private PathElement[] path;
    private float minX;
    private float minY = Float.MAX_VALUE;
    private float maxX;
    private float maxY = Float.MIN_VALUE;

    public JAVAGeneralPath(int rule, PathElement[] path) {
        this.rule = rule;
        this.path = path;
        for (int i = 0; i < path.length; ++i) {
            this.minX = Math.min(this.minX, path[i].getMinX());
            this.maxX = Math.max(this.maxX, path[i].getMaxX());
            this.minY = Math.min(this.minY, path[i].getMinY());
            this.maxY = Math.max(this.maxY, path[i].getMaxY());
        }
    }

    public Rectangle getBounds() {
        return this.getBounds2D().getBounds();
    }

    public Rectangle2D getBounds2D() {
        return new Rectangle2D.Float(this.minX, this.minY, this.maxX - this.minX, this.maxY - this.minY);
    }

    public boolean contains(double x, double y) {
        return this.getBounds2D().contains(x, y);
    }

    public boolean contains(Point2D p) {
        return this.contains(p.getX(), p.getY());
    }

    public boolean intersects(double x, double y, double w, double h) {
        return this.getBounds2D().intersects(x, y, w, h);
    }

    public boolean intersects(Rectangle2D r) {
        return this.intersects(r.getX(), r.getY(), r.getWidth(), r.getHeight());
    }

    public boolean contains(double x, double y, double w, double h) {
        return this.getBounds2D().contains(x, y, w, h);
    }

    public boolean contains(Rectangle2D r) {
        return this.contains(r.getX(), r.getY(), r.getWidth(), r.getHeight());
    }

    public PathIterator getPathIterator(final AffineTransform at) {
        return new PathIterator(){
            private int index = 0;
            private AffineTransform transform = at;

            public int getWindingRule() {
                return JAVAGeneralPath.this.rule;
            }

            public boolean isDone() {
                return this.index >= JAVAGeneralPath.this.path.length;
            }

            public void next() {
                if (!this.isDone()) {
                    ++this.index;
                }
            }

            public int currentSegment(float[] coords) {
                int type = JAVAGeneralPath.this.path[this.index].currentSegment(coords);
                this.transform.transform(coords, 0, coords, 0, coords.length / 2);
                return type;
            }

            public int currentSegment(double[] coords) {
                int type = JAVAGeneralPath.this.path[this.index].currentSegment(coords);
                this.transform.transform(coords, 0, coords, 0, coords.length / 2);
                return type;
            }
        };
    }

    public PathIterator getPathIterator(AffineTransform at, double flatness) {
        return new FlatteningPathIterator(this.getPathIterator(at), flatness);
    }

    public static class ClosePath
    extends PathElement {
        public float getMinX() {
            return Float.MAX_VALUE;
        }

        public float getMaxX() {
            return Float.MIN_VALUE;
        }

        public float getMinY() {
            return Float.MAX_VALUE;
        }

        public float getMaxY() {
            return Float.MIN_VALUE;
        }

        public int currentSegment(float[] coords) {
            return 4;
        }

        public int currentSegment(double[] coords) {
            return 4;
        }
    }

    public static class CurveTo
    extends PathElement {
        private float x1;
        private float y1;
        private float x2;
        private float y2;
        private float x3;
        private float y3;

        public CurveTo(float x1, float y1, float x2, float y2, float x3, float y3) {
            this.x1 = x1;
            this.y1 = y1;
            this.x2 = x2;
            this.y2 = y2;
            this.x3 = x3;
            this.y3 = y3;
        }

        public float getMinX() {
            return Math.min(this.x1, Math.min(this.x2, this.x3));
        }

        public float getMaxX() {
            return Math.max(this.x1, Math.max(this.x2, this.x3));
        }

        public float getMinY() {
            return Math.min(this.y1, Math.min(this.y2, this.y3));
        }

        public float getMaxY() {
            return Math.max(this.y1, Math.max(this.y2, this.y3));
        }

        public int currentSegment(float[] coords) {
            coords[0] = this.x1;
            coords[1] = this.y1;
            coords[2] = this.x2;
            coords[3] = this.y2;
            coords[4] = this.x3;
            coords[5] = this.y3;
            return 3;
        }

        public int currentSegment(double[] coords) {
            coords[0] = this.x1;
            coords[1] = this.y1;
            coords[2] = this.x2;
            coords[3] = this.y2;
            coords[4] = this.x3;
            coords[5] = this.y3;
            return 3;
        }
    }

    public static class QuadTo
    extends PathElement {
        private float x1;
        private float y1;
        private float x2;
        private float y2;

        public QuadTo(float x1, float y1, float x2, float y2) {
            this.x1 = x1;
            this.y1 = y1;
            this.x2 = x2;
            this.y2 = y2;
        }

        public float getMinX() {
            return Math.min(this.x1, this.x2);
        }

        public float getMaxX() {
            return Math.max(this.x1, this.x2);
        }

        public float getMinY() {
            return Math.min(this.y1, this.y2);
        }

        public float getMaxY() {
            return Math.max(this.y1, this.y2);
        }

        public int currentSegment(float[] coords) {
            coords[0] = this.x1;
            coords[1] = this.y1;
            coords[2] = this.x2;
            coords[3] = this.y2;
            return 2;
        }

        public int currentSegment(double[] coords) {
            coords[0] = this.x1;
            coords[1] = this.y1;
            coords[2] = this.x2;
            coords[3] = this.y2;
            return 2;
        }
    }

    public static class LineTo
    extends Point {
        public LineTo(float x, float y) {
            super(x, y);
        }

        public int currentSegment(float[] coords) {
            this.fill(coords);
            return 1;
        }

        public int currentSegment(double[] coords) {
            this.fill(coords);
            return 1;
        }
    }

    public static class MoveTo
    extends Point {
        public MoveTo(float x, float y) {
            super(x, y);
        }

        public int currentSegment(float[] coords) {
            this.fill(coords);
            return 0;
        }

        public int currentSegment(double[] coords) {
            this.fill(coords);
            return 0;
        }
    }

    public static abstract class Point
    extends PathElement {
        private float x;
        private float y;

        public Point(float x, float y) {
            this.x = x;
            this.y = y;
        }

        public float getMinX() {
            return this.x;
        }

        public float getMaxX() {
            return this.x;
        }

        public float getMinY() {
            return this.y;
        }

        public float getMaxY() {
            return this.y;
        }

        protected void fill(float[] coords) {
            coords[0] = this.x;
            coords[1] = this.y;
        }

        protected void fill(double[] coords) {
            coords[0] = this.x;
            coords[1] = this.y;
        }
    }

    public static abstract class PathElement {
        public abstract float getMinX();

        public abstract float getMaxX();

        public abstract float getMinY();

        public abstract float getMaxY();

        public abstract int currentSegment(float[] var1);

        public abstract int currentSegment(double[] var1);
    }
}

