/*
 * Decompiled with CFR 0.152.
 */
package jp.riken.brain.ni.samuraigraph.application;

import foxtrot.Task;
import foxtrot.Worker;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.prefs.Preferences;
import javax.print.attribute.standard.MediaSize;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import jp.riken.brain.ni.samuraigraph.application.SGAboutDialog;
import jp.riken.brain.ni.samuraigraph.application.SGApplicationProperties;
import jp.riken.brain.ni.samuraigraph.application.SGApplicationUtility;
import jp.riken.brain.ni.samuraigraph.application.SGArchiveFileCreator;
import jp.riken.brain.ni.samuraigraph.application.SGArchiveFileExtractor;
import jp.riken.brain.ni.samuraigraph.application.SGChangeLogDialog;
import jp.riken.brain.ni.samuraigraph.application.SGCloseWindowConfirmPanel;
import jp.riken.brain.ni.samuraigraph.application.SGDataCreator;
import jp.riken.brain.ni.samuraigraph.application.SGFigureCreator;
import jp.riken.brain.ni.samuraigraph.application.SGFigureIDSelectionWizardDialog;
import jp.riken.brain.ni.samuraigraph.application.SGIApplicationCommandConstants;
import jp.riken.brain.ni.samuraigraph.application.SGIApplicationConstants;
import jp.riken.brain.ni.samuraigraph.application.SGIApplicationTextConstants;
import jp.riken.brain.ni.samuraigraph.application.SGIArchiveFileConstants;
import jp.riken.brain.ni.samuraigraph.application.SGIImageConstants;
import jp.riken.brain.ni.samuraigraph.application.SGIPreferencesConstants;
import jp.riken.brain.ni.samuraigraph.application.SGIPropertyFileConstants;
import jp.riken.brain.ni.samuraigraph.application.SGIUpgradeConstants;
import jp.riken.brain.ni.samuraigraph.application.SGImageExportManager;
import jp.riken.brain.ni.samuraigraph.application.SGMultiDataFileChooserWizardDialog;
import jp.riken.brain.ni.samuraigraph.application.SGPropertyFileChooserWizardDialog;
import jp.riken.brain.ni.samuraigraph.application.SGPropertyFileCreator;
import jp.riken.brain.ni.samuraigraph.application.SGProxyManager;
import jp.riken.brain.ni.samuraigraph.application.SGSingleDataFileChooserWizardDialog;
import jp.riken.brain.ni.samuraigraph.application.SGSplashWindow;
import jp.riken.brain.ni.samuraigraph.application.SGUpgradeManager;
import jp.riken.brain.ni.samuraigraph.application.SGWizardDialog;
import jp.riken.brain.ni.samuraigraph.application.SGXYDataTypeSelectionWizardDialog;
import jp.riken.brain.ni.samuraigraph.base.SGData;
import jp.riken.brain.ni.samuraigraph.base.SGDrawingWindow;
import jp.riken.brain.ni.samuraigraph.base.SGExtensionFileFilter;
import jp.riken.brain.ni.samuraigraph.base.SGFigure;
import jp.riken.brain.ni.samuraigraph.base.SGFileChooser;
import jp.riken.brain.ni.samuraigraph.base.SGIConstants;
import jp.riken.brain.ni.samuraigraph.base.SGIFigureElement;
import jp.riken.brain.ni.samuraigraph.base.SGIFigureElementAxis;
import jp.riken.brain.ni.samuraigraph.base.SGIFigureElementAxisBreak;
import jp.riken.brain.ni.samuraigraph.base.SGIFigureElementGraph;
import jp.riken.brain.ni.samuraigraph.base.SGIFigureElementGraphSXY;
import jp.riken.brain.ni.samuraigraph.base.SGIFigureElementGraphVXY;
import jp.riken.brain.ni.samuraigraph.base.SGIFigureElementLegend;
import jp.riken.brain.ni.samuraigraph.base.SGIFigureElementShape;
import jp.riken.brain.ni.samuraigraph.base.SGIFigureElementSignificantDifference;
import jp.riken.brain.ni.samuraigraph.base.SGIFigureElementString;
import jp.riken.brain.ni.samuraigraph.base.SGIFigureElementTimingLine;
import jp.riken.brain.ni.samuraigraph.base.SGIProgressControl;
import jp.riken.brain.ni.samuraigraph.base.SGIRootObjectConstants;
import jp.riken.brain.ni.samuraigraph.base.SGUtility;
import jp.riken.brain.ni.samuraigraph.base.SGUtilityText;
import jp.riken.brain.ni.samuraigraph.figure.SGDrawingElementArrow;
import jp.riken.brain.ni.samuraigraph.figure.SGDrawingElementErrorBar;
import jp.riken.brain.ni.samuraigraph.figure.SGDrawingElementLine;
import jp.riken.brain.ni.samuraigraph.figure.SGDrawingElementSymbol;
import jp.riken.brain.ni.samuraigraph.figure.SGSXYFigure;
import jp.riken.brain.ni.samuraigraph.figure.SGVXYFigure;
import jp.riken.brain.ni.samuraigraph.figure.SGXYFigure;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

class SGMainFunctions
implements ActionListener,
SGIConstants,
SGIUpgradeConstants,
SGIApplicationCommandConstants,
SGIApplicationConstants,
SGIPropertyFileConstants,
SGIPreferencesConstants,
SGIApplicationTextConstants,
SGIRootObjectConstants,
SGIImageConstants,
SGIArchiveFileConstants {
    private SGApplicationProperties mAppProp = null;
    private DataSetManager mDataSetManager;
    private SGProxyManager mProxyManager;
    private SGUpgradeManager mUpgradeManager;
    private SGDataCreator mDataCreator;
    private WindowManager mWindowManager = null;
    private ClipBoardManager mClipBoardManager = null;
    private PropertyManager mPropertyManager = null;
    private PropertyFileManager mPropertyFileManager = null;
    private SGFigureCreator mFigureCreator = null;
    private SGFigure mActiveFigure = null;
    private Initializer mInit = null;
    private Thread mLongTask = null;
    private SGFigureIDSelectionWizardDialog mFigureIDSelectionWizardDialog = null;
    private SGSingleDataFileChooserWizardDialog mSingleDataFileChooserWizardDilaog = null;
    private SGXYDataTypeSelectionWizardDialog mXYDataTypeSelectionWizardDialog = null;
    private SGXYDataTypeSelectionWizardDialog mXYDataTypeSelectionWizardDialogFromCLorDD = null;
    private String mCurrentDataFileName = null;
    private String mCurrentPropertyFileName = null;
    private String mCurrentImageFileName = null;
    private String mCurrentArchiveFileName = null;
    public static final String TAG_NAME_FOCUSED_FIGURES = "FocusedFigures";
    static /* synthetic */ Class class$jp$riken$brain$ni$samuraigraph$data$SGSXYData;
    static /* synthetic */ Class class$jp$riken$brain$ni$samuraigraph$data$SGVXYData;
    static /* synthetic */ Class class$jp$riken$brain$ni$samuraigraph$data$SGSXYMultipleData;
    static /* synthetic */ Class class$jp$riken$brain$ni$samuraigraph$data$SGSXYSamplingData;
    static /* synthetic */ Class class$jp$riken$brain$ni$samuraigraph$data$SGSXYDateData;

    public SGMainFunctions(SGApplicationProperties sGApplicationProperties) {
        this.mAppProp = sGApplicationProperties;
        this.mInit = new Initializer();
        this.mInit.start();
    }

    public SGMainFunctions(String string, int n, SGApplicationProperties sGApplicationProperties) {
        this.mAppProp = sGApplicationProperties;
        this.mInit = new Initializer(string, n);
        this.mInit.start();
    }

    public boolean waitInit() {
        try {
            this.mInit.join();
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        this.mInit = null;
        return true;
    }

    public int exec(String string) {
        SGDrawingWindow sGDrawingWindow = this.mWindowManager.getActiveWindow();
        SGFigure sGFigure = this.mActiveFigure;
        ArrayList arrayList = new ArrayList();
        String string2 = this.parseCommand(string, arrayList);
        if (string2 == null) {
            return -1;
        }
        int n = arrayList.size();
        int n2 = this.execBasicCommand(string2, arrayList);
        if (n2 != 1) {
            return n2;
        }
        n2 = this.execMenuBarCommand(string2, arrayList);
        if (n2 != 1) {
            return n2;
        }
        n2 = this.mPropertyManager.setWindowProperties(string2, sGDrawingWindow, arrayList);
        if (n2 != 1) {
            return n2;
        }
        n2 = this.mPropertyManager.setFigureProperties(string2, sGFigure, arrayList);
        if (n2 != 1) {
            return n2;
        }
        n2 = this.mPropertyManager.setFigureElementProperties(string2, sGFigure, arrayList);
        if (n2 != 1) {
            return n2;
        }
        return 1;
    }

    private int execBasicCommand(String string, ArrayList arrayList) {
        int n = arrayList.size();
        SGDrawingWindow sGDrawingWindow = this.mWindowManager.getActiveWindow();
        if (string.equals("chwin")) {
            if (n < 1) {
                return -1;
            }
            String string2 = (String)arrayList.get(0);
            Integer n2 = SGUtilityText.getInteger(string2);
            if (n2 == null) {
                return -1;
            }
            int n3 = n2;
            SGDrawingWindow sGDrawingWindow2 = this.mWindowManager.getWindow(n3);
            if (sGDrawingWindow2 == null) {
                return -1;
            }
            this.mWindowManager.setActiveWindow(sGDrawingWindow2);
            return 0;
        }
        if (string.equals("chfig")) {
            if (n != 1) {
                return -1;
            }
            if (sGDrawingWindow == null) {
                return -1;
            }
            String string3 = (String)arrayList.get(0);
            Integer n4 = SGUtilityText.getInteger(string3);
            if (n4 == null) {
                return -1;
            }
            int n5 = n4;
            SGFigure sGFigure = sGDrawingWindow.getFigure(n5);
            if (sGFigure == null) {
                return -1;
            }
            this.mActiveFigure = sGFigure;
            return 0;
        }
        if (string.equals("selectFigure")) {
            if (n < 1) {
                return -1;
            }
            if (sGDrawingWindow == null) {
                return -1;
            }
            int[] nArray = new int[arrayList.size()];
            for (int i = 0; i < arrayList.size(); ++i) {
                String string4 = (String)arrayList.get(i);
                Integer n6 = SGUtilityText.getInteger(string4);
                if (n6 == null) {
                    return -1;
                }
                nArray[i] = n6;
            }
            sGDrawingWindow.setSelectedFigure(nArray);
            return 0;
        }
        if (string.equals("tree")) {
            if (sGDrawingWindow == null) {
                return -1;
            }
            StringBuffer stringBuffer = new StringBuffer();
            sGDrawingWindow.createTree(stringBuffer);
            System.out.println(stringBuffer);
            return 0;
        }
        if (string.equals("zoom")) {
            if (n < 1) {
                return -1;
            }
            if (sGDrawingWindow == null) {
                return -1;
            }
            String string5 = (String)arrayList.get(0);
            Double d = SGUtilityText.getDouble(string5);
            if (d == null) {
                return -1;
            }
            if (!sGDrawingWindow.setZoomValue(d)) {
                return -1;
            }
            return 0;
        }
        return 1;
    }

    private int execMenuBarCommand(String string, ArrayList arrayList) {
        int n = this.execMenuBarCommandFile(string, arrayList);
        if (n != 1) {
            return n;
        }
        n = this.execMenuBarCommandEdit(string, arrayList);
        if (n != 1) {
            return n;
        }
        n = this.execMenuBarCommandInsert(string, arrayList);
        if (n != 1) {
            return n;
        }
        n = this.execMenuBarCommandLayout(string, arrayList);
        if (n != 1) {
            return n;
        }
        return 1;
    }

    private int execMenuBarCommandFile(String string, ArrayList arrayList) {
        int n = arrayList.size();
        SGDrawingWindow sGDrawingWindow = this.mWindowManager.getActiveWindow();
        if (string.equals("wopen")) {
            SGDrawingWindow sGDrawingWindow2 = this.mWindowManager.createNewWindow();
            if (sGDrawingWindow2 == null) {
                return -1;
            }
            sGDrawingWindow2.setVisible(true);
            return 0;
        }
        if (string.equals("wclose")) {
            if (n == 0) {
                if (sGDrawingWindow != null) {
                    this.mWindowManager.closeWindow(sGDrawingWindow);
                }
            } else if (n == 1) {
                String string2 = (String)arrayList.get(0);
                Integer n2 = SGUtilityText.getInteger(string2);
                if (n2 == null) {
                    return -1;
                }
                int n3 = n2;
                this.mWindowManager.closeWindow(n3);
            } else {
                return -1;
            }
            return 0;
        }
        if (string.equals("drawGraph")) {
            if (n < 3) {
                return -1;
            }
            if (sGDrawingWindow == null) {
                return -1;
            }
            String string3 = (String)arrayList.get(0);
            String string4 = (String)arrayList.get(1);
            String string5 = (String)arrayList.get(2);
            Integer n4 = SGUtilityText.getInteger(string3);
            if (n4 == null) {
                return -1;
            }
            int n5 = n4;
            String string6 = string4;
            File file = new File(string6);
            if (!file.exists()) {
                return -1;
            }
            String string7 = string5;
            ArrayList<Object> arrayList2 = new ArrayList<Object>();
            arrayList2.add(string7);
            if (string7.equals("SXY_SAMPLING")) {
                if (arrayList.size() < 4) {
                    return -1;
                }
                String string8 = (String)arrayList.get(3);
                Double d = SGUtilityText.getDouble(string8);
                if (d == null) {
                    return -1;
                }
                arrayList2.add(d);
            }
            if (!this.drawGraph(sGDrawingWindow, n5, arrayList2, string6, false)) {
                return -1;
            }
            return 0;
        }
        if (string.equals("loadProperty")) {
            Object object;
            if (n < 1) {
                return -1;
            }
            if (sGDrawingWindow == null) {
                return -1;
            }
            String string9 = (String)arrayList.get(0);
            File file = new File(string9);
            if (!file.exists()) {
                return -1;
            }
            String string10 = SGUtility.getCanonicalPath(file.getPath());
            if (string10 == null) {
                return -1;
            }
            URL uRL = null;
            try {
                uRL = file.toURL();
            }
            catch (MalformedURLException malformedURLException) {
                return -1;
            }
            Document document = SGUtilityText.getDocument(uRL);
            if (document == null) {
                return -1;
            }
            Element element = this.mPropertyFileManager.getWindowElement(document);
            NodeList nodeList = element.getElementsByTagName("Figure");
            int n6 = nodeList.getLength();
            int n7 = 0;
            int[] nArray = new int[n6];
            for (int i = 0; i < n6; ++i) {
                object = nodeList.item(i);
                if (!(object instanceof Element)) {
                    return -1;
                }
                Element element2 = (Element)object;
                NodeList nodeList2 = element2.getElementsByTagName("Data");
                nArray[i] = nodeList2.getLength();
                n7 += nArray[i];
            }
            if (n7 != n - 1) {
                return -1;
            }
            ArrayList arrayList3 = new ArrayList(arrayList.subList(1, n));
            object = new TreeMap();
            n7 = 0;
            for (int i = 0; i < n6; ++i) {
                int n8 = nArray[i];
                ArrayList arrayList4 = new ArrayList();
                for (int j = 0; j < n8; ++j) {
                    arrayList4.add(arrayList3.get(n7 + j));
                }
                object.put(new Integer(i), arrayList4);
                n7 += n8;
            }
            if (!this.mPropertyFileManager.setPropertyFileFromEventDispatchThread(sGDrawingWindow, document, (Map)object)) {
                return -1;
            }
            return 0;
        }
        if (string.equals("saveProperty")) {
            if (n < 1) {
                return -1;
            }
            if (sGDrawingWindow == null) {
                return -1;
            }
            if (sGDrawingWindow.getVisibleFigureList().size() == 0) {
                return -1;
            }
            String string11 = (String)arrayList.get(0);
            int n9 = this.mPropertyFileManager.saveProperties(sGDrawingWindow, string11);
            sGDrawingWindow.setSaved(n9 == 0);
            return 0;
        }
        if (string.equals("loadDataSet")) {
            if (n < 1) {
                return -1;
            }
            if (sGDrawingWindow == null) {
                return -1;
            }
            String string12 = (String)arrayList.get(0);
            File file = new File(string12);
            if (!file.exists()) {
                return -1;
            }
            if (!this.mDataSetManager.loadDataSetFromEventDispatchThread(sGDrawingWindow, file)) {
                return -1;
            }
            return 0;
        }
        if (string.equals("saveDataSet")) {
            if (n < 1) {
                return -1;
            }
            if (sGDrawingWindow == null) {
                return -1;
            }
            if (sGDrawingWindow.getVisibleFigureList().size() == 0) {
                return -1;
            }
            String string13 = (String)arrayList.get(0);
            int n10 = this.mDataSetManager.saveDataSet(sGDrawingWindow, string13);
            sGDrawingWindow.setSaved(n10 == 0);
            return 0;
        }
        if (string.equals("loadBackgroundImage")) {
            if (n < 1) {
                return -1;
            }
            if (sGDrawingWindow == null) {
                return -1;
            }
            String string14 = (String)arrayList.get(0);
            File file = new File(string14);
            if (!file.exists()) {
                return -1;
            }
            if (!sGDrawingWindow.setImage(file)) {
                return -1;
            }
            return 0;
        }
        if (string.equals("exportAsImage")) {
            if (n < 2) {
                return -1;
            }
            if (sGDrawingWindow == null) {
                return -1;
            }
            String string15 = (String)arrayList.get(0);
            String string16 = (String)arrayList.get(1);
            Properties properties = new Properties();
            for (int i = 2; i < n; ++i) {
                String string17 = (String)arrayList.get(i);
                if (this.getProperties(string17, properties)) continue;
                return -1;
            }
            return sGDrawingWindow.exportAsImage(properties, string15, string16);
        }
        if (string.equals("print")) {
            if (n != 0) {
                return -1;
            }
            if (sGDrawingWindow == null) {
                return -1;
            }
            if (!sGDrawingWindow.printImage(true)) {
                return -1;
            }
            return 0;
        }
        if (string.equals("exit")) {
            if (n != 0) {
                return -1;
            }
            this.exit();
            return 0;
        }
        return 1;
    }

    private boolean getProperties(String string, Properties properties) {
        int n = string.indexOf("=");
        if (n == -1 | n == 0 | n == string.length() - 1) {
            return false;
        }
        String string2 = string.substring(0, n);
        String string3 = string.substring(n + 1, string.length());
        properties.setProperty(string2, string3);
        return true;
    }

    private int execMenuBarCommandEdit(String string, ArrayList arrayList) {
        int n = arrayList.size();
        SGDrawingWindow sGDrawingWindow = this.mWindowManager.getActiveWindow();
        if (string.equals("undo")) {
            if (sGDrawingWindow == null) {
                return -1;
            }
            sGDrawingWindow.undo();
            sGDrawingWindow.repaintContentPane();
            return 0;
        }
        if (string.equals("redo")) {
            if (sGDrawingWindow == null) {
                return -1;
            }
            sGDrawingWindow.redo();
            sGDrawingWindow.repaintContentPane();
            return 0;
        }
        if (string.equals("clearUndoBuffer")) {
            sGDrawingWindow.clearUndoBuffer();
            return 0;
        }
        if (string.equals("cut")) {
            sGDrawingWindow.doCut();
            return 0;
        }
        if (string.equals("copy")) {
            sGDrawingWindow.doCopy();
            return 0;
        }
        if (string.equals("paste")) {
            sGDrawingWindow.doPaste();
            return 0;
        }
        if (string.equals("delete")) {
            sGDrawingWindow.doDelete();
            return 0;
        }
        if (string.equals("duplicate")) {
            sGDrawingWindow.doDuplicate();
            return 0;
        }
        if (string.equals("deleteBackgroundImage")) {
            if (!sGDrawingWindow.deleteImage()) {
                return -1;
            }
            return 0;
        }
        return 1;
    }

    private Number getNumber(String string, StringBuffer stringBuffer) {
        return SGUtilityText.getNumber(string, stringBuffer);
    }

    private int execMenuBarCommandInsert(String string, ArrayList arrayList) {
        SGFigure sGFigure = this.mActiveFigure;
        if (sGFigure == null) {
            return 1;
        }
        int n = arrayList.size();
        if (string.equals("insertLabel")) {
            if (n == 1) {
                String string2 = (String)arrayList.get(0);
                if (string2.length() == 0) {
                    return -1;
                }
                sGFigure.addString(0, 0, string2);
            } else if (n == 3) {
                String string3 = (String)arrayList.get(0);
                String string4 = (String)arrayList.get(1);
                String string5 = (String)arrayList.get(2);
                StringBuffer stringBuffer = new StringBuffer();
                StringBuffer stringBuffer2 = new StringBuffer();
                Number number = SGUtilityText.getNumber(string3, stringBuffer);
                if (number == null) {
                    return -1;
                }
                Number number2 = SGUtilityText.getNumber(string4, stringBuffer2);
                if (number2 == null) {
                    return -1;
                }
                double d = SGUtilityText.convertToPoint(number.doubleValue(), stringBuffer.toString());
                double d2 = SGUtilityText.convertToPoint(number2.doubleValue(), stringBuffer2.toString());
                double d3 = (double)sGFigure.getFigureX() + d;
                double d4 = (double)sGFigure.getFigureY() + d2;
                sGFigure.addString((int)d3, (int)d4, string5);
            } else {
                return -1;
            }
            return 0;
        }
        if (string.equals("insertAxisBreak") | string.equals("insertSignificantDifference") | string.equals("insertRectangle") | string.equals("insertEllipse") | string.equals("insertArrow") | string.equals("insertLine") | string.equals("insertTimingLine")) {
            if (n == 2) {
                String string6 = (String)arrayList.get(0);
                String string7 = (String)arrayList.get(1);
                StringBuffer stringBuffer = new StringBuffer();
                StringBuffer stringBuffer3 = new StringBuffer();
                Number number = SGUtilityText.getNumber(string6, stringBuffer);
                if (number == null) {
                    return -1;
                }
                Number number3 = SGUtilityText.getNumber(string7, stringBuffer3);
                if (number3 == null) {
                    return -1;
                }
                double d = SGUtilityText.convertToPoint(number.doubleValue(), stringBuffer.toString());
                double d5 = SGUtilityText.convertToPoint(number3.doubleValue(), stringBuffer3.toString());
                float f = sGFigure.getMagnification();
                int n2 = (int)((double)sGFigure.getGraphRectX() + (double)f * d);
                int n3 = (int)((double)sGFigure.getGraphRectY() + (double)f * d5);
                if (string.equals("insertAxisBreak")) {
                    sGFigure.addAxisBreakSymbol(n2, n3);
                } else if (string.equals("insertSignificantDifference")) {
                    sGFigure.addSignificantDifferenceSymbol(n2, n3);
                } else if (string.equals("insertTimingLine")) {
                    sGFigure.addTimingLine(n2, n3);
                } else if (string.equals("insertRectangle")) {
                    sGFigure.addShape(0, n2, n3);
                } else if (string.equals("insertEllipse")) {
                    sGFigure.addShape(1, n2, n3);
                } else if (string.equals("insertArrow")) {
                    sGFigure.addShape(2, n2, n3);
                } else if (string.equals("insertLine")) {
                    sGFigure.addShape(3, n2, n3);
                }
            } else {
                return -1;
            }
            sGFigure.repaint();
            return 0;
        }
        return 1;
    }

    private int execMenuBarCommandLayout(String string, ArrayList arrayList) {
        int n = arrayList.size();
        SGDrawingWindow sGDrawingWindow = this.mWindowManager.getActiveWindow();
        if (sGDrawingWindow == null) {
            return -1;
        }
        if (string.equals("paperAlignment")) {
            return 0;
        }
        if (string.equals("boundingBox")) {
            if (!sGDrawingWindow.setBoundingBox()) {
                return -1;
            }
            return 0;
        }
        if (string.equals("autoArrangement")) {
            if (!sGDrawingWindow.alignFigures()) {
                return -1;
            }
            return 0;
        }
        if (string.equals("autoZoom")) {
            if (n < 1) {
                return -1;
            }
            String string2 = (String)arrayList.get(0);
            Boolean bl = SGUtilityText.getBoolean(SGUtilityText.getBooleanString(string2));
            if (bl == null) {
                return -1;
            }
            sGDrawingWindow.setAutoZoom(bl);
            return 0;
        }
        if (string.equals("lock")) {
            if (n < 1) {
                return -1;
            }
            String string3 = (String)arrayList.get(0);
            Boolean bl = SGUtilityText.getBoolean(SGUtilityText.getBooleanString(string3));
            if (bl == null) {
                return -1;
            }
            sGDrawingWindow.setLocked(bl);
            return 0;
        }
        return 1;
    }

    private String parseCommand(String string, ArrayList arrayList) {
        int n;
        int n2 = string.indexOf(40);
        if (n2 == -1 | (n = string.indexOf(41)) == -1) {
            return string;
        }
        if (n2 > n) {
            return string;
        }
        if (n2 == 0) {
            return string;
        }
        String string2 = string.substring(0, n2);
        String string3 = string.substring(n2 + 1, n);
        if (!SGUtilityText.tokenize(string3, arrayList, false)) {
            return string;
        }
        return string2;
    }

    private String getSimpleFileName(String string) {
        String string2 = SGIConstants.FILE_SEPARATOR;
        StringTokenizer stringTokenizer = new StringTokenizer(string, string2);
        String string3 = null;
        while (stringTokenizer.hasMoreTokens()) {
            string3 = stringTokenizer.nextToken();
        }
        if (string3 == null) {
            throw new Error();
        }
        String string4 = null;
        StringTokenizer stringTokenizer2 = new StringTokenizer(string3, Character.toString('.'));
        if (stringTokenizer2.hasMoreTokens()) {
            string4 = stringTokenizer2.nextToken();
        }
        if (string4 == null) {
            string4 = string3;
        }
        return string4;
    }

    private String getNewDataName(SGFigure sGFigure, String string) {
        String string2 = this.getSimpleFileName(string);
        if (string2 == null) {
            return null;
        }
        List list = sGFigure.getVisibleDataList();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < list.size(); ++i) {
            SGData sGData = (SGData)list.get(i);
            String string3 = sGFigure.getDataName(sGData);
            arrayList.add(string3);
        }
        string2 = SGUtilityText.getSerialName(arrayList, string2);
        return string2;
    }

    private boolean setWindowLocation(SGDrawingWindow sGDrawingWindow) {
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        int n = (int)(dimension.getWidth() - (double)sGDrawingWindow.getWidth()) / 2;
        int n2 = (int)(dimension.getHeight() - (double)sGDrawingWindow.getHeight()) / 2;
        sGDrawingWindow.setLocation(n, n2);
        return true;
    }

    private int createDataFromFile(String string, ArrayList arrayList, SGDrawingWindow sGDrawingWindow) throws FileNotFoundException {
        ArrayList arrayList2 = new ArrayList();
        int n = this.readFile(string, arrayList2);
        if (n != 0) {
            return n;
        }
        SGData sGData = this.mDataCreator.create(string, arrayList2, sGDrawingWindow);
        if (sGData == null) {
            return -1;
        }
        arrayList.add(sGData);
        return 0;
    }

    private boolean createAllWizardDialogsForDataAdditionFromToolBar(SGDrawingWindow sGDrawingWindow) {
        this.mFigureIDSelectionWizardDialog = new SGFigureIDSelectionWizardDialog((Frame)sGDrawingWindow, true);
        this.mFigureIDSelectionWizardDialog.getOKButton().setVisible(false);
        this.mFigureIDSelectionWizardDialog.getPreviousButton().setVisible(false);
        this.mFigureIDSelectionWizardDialog.pack();
        this.mSingleDataFileChooserWizardDilaog = new SGSingleDataFileChooserWizardDialog((Frame)sGDrawingWindow, true);
        this.mSingleDataFileChooserWizardDilaog.getOKButton().setVisible(false);
        this.mSingleDataFileChooserWizardDilaog.pack();
        String string = this.getCurrentFileDirectory();
        this.mSingleDataFileChooserWizardDilaog.setFile(string, this.mCurrentDataFileName);
        this.mXYDataTypeSelectionWizardDialog = new SGXYDataTypeSelectionWizardDialog((Frame)sGDrawingWindow, true);
        this.mXYDataTypeSelectionWizardDialog.getNextButton().setVisible(false);
        this.mXYDataTypeSelectionWizardDialog.pack();
        this.mFigureIDSelectionWizardDialog.setNext(this.mSingleDataFileChooserWizardDilaog);
        this.mSingleDataFileChooserWizardDilaog.setPrevious(this.mFigureIDSelectionWizardDialog);
        this.mSingleDataFileChooserWizardDilaog.setNext(this.mXYDataTypeSelectionWizardDialog);
        this.mXYDataTypeSelectionWizardDialog.setPrevious(this.mSingleDataFileChooserWizardDilaog);
        this.mFigureIDSelectionWizardDialog.addActionListener(this);
        this.mSingleDataFileChooserWizardDilaog.addActionListener(this);
        this.mXYDataTypeSelectionWizardDialog.addActionListener(this);
        return true;
    }

    private String getCurrentFileDirectory() {
        Object object;
        Preferences preferences = Preferences.userNodeForPackage(this.getClass());
        Object object2 = preferences.get("Current Directory", null);
        boolean bl = false;
        if (object2 == null) {
            bl = true;
        } else {
            object = new File((String)object2);
            if (!((File)object).exists()) {
                bl = true;
            }
        }
        if (bl) {
            object = SGIConstants.USER_HOME;
            if (SGUtility.identifyOS("windows")) {
                object = (String)object + SGIConstants.FILE_SEPARATOR + "My Documents";
            }
            this.setCurrentFileDirectory((String)object);
            object2 = object;
        }
        return object2;
    }

    private void setCurrentFileDirectory(String string) {
        Preferences preferences = Preferences.userNodeForPackage(this.getClass());
        preferences.put("Current Directory", string);
    }

    private int readFile(String string, ArrayList arrayList) {
        Window window = this.mXYDataTypeSelectionWizardDialogFromCLorDD.getOwner();
        ArrayList arrayList2 = new ArrayList();
        try {
            if (!this.mDataCreator.getFileTypeCandidateList(string, arrayList2)) {
                return -1;
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            return -1;
        }
        if (arrayList2.size() == 0) {
            return -1;
        }
        String string2 = null;
        if (!this.mXYDataTypeSelectionWizardDialogFromCLorDD.setEffectiveDataType(arrayList2)) {
            return -1;
        }
        this.mXYDataTypeSelectionWizardDialogFromCLorDD.setCenter(window);
        this.mXYDataTypeSelectionWizardDialogFromCLorDD.setVisible(true);
        int n = this.mXYDataTypeSelectionWizardDialogFromCLorDD.getCloseOption();
        if (n == 1) {
            return 1;
        }
        string2 = this.mXYDataTypeSelectionWizardDialogFromCLorDD.getSelectedDataType();
        if (string2 == null) {
            return -1;
        }
        arrayList.add(string2);
        if (string2.equals("SXY_SAMPLING")) {
            Double d = this.mXYDataTypeSelectionWizardDialogFromCLorDD.getSamplingRate();
            if (d == null) {
                return -1;
            }
            arrayList.add(d);
        } else if (string2.equals("VXY")) {
            boolean bl = this.mXYDataTypeSelectionWizardDialogFromCLorDD.isPolarSelected();
            arrayList.add(bl);
        }
        return 0;
    }

    public boolean showAboutDialog(SGDrawingWindow sGDrawingWindow) {
        if (sGDrawingWindow == null) {
            sGDrawingWindow = this.mWindowManager.getActiveWindow();
        }
        if (sGDrawingWindow == null) {
            return false;
        }
        SGAboutDialog sGAboutDialog = new SGAboutDialog((Frame)sGDrawingWindow, true, this.mAppProp.getVersionString());
        int n = sGAboutDialog.getWidth();
        int n2 = sGAboutDialog.getHeight();
        int n3 = sGDrawingWindow.getX() + sGDrawingWindow.getWidth() / 2 - n / 2;
        int n4 = sGDrawingWindow.getY() + sGDrawingWindow.getHeight() / 2 - n2 / 2;
        sGAboutDialog.setLocation(n3, n4);
        sGAboutDialog.setVisible(true);
        sGAboutDialog.dispose();
        return true;
    }

    private boolean duplicateFocusedFigures(SGDrawingWindow sGDrawingWindow) {
        Object object;
        Object object2;
        DOMImplementation dOMImplementation = SGApplicationUtility.getDOMImplementation();
        if (dOMImplementation == null) {
            return false;
        }
        Document document = dOMImplementation.createDocument("", TAG_NAME_FOCUSED_FIGURES, null);
        if (!sGDrawingWindow.createDOMTree(document, 3)) {
            return false;
        }
        TreeMap<String, Object> treeMap = new TreeMap<String, Object>();
        ArrayList arrayList = sGDrawingWindow.getFocusedObjectsList();
        for (int i = 0; i < arrayList.size(); ++i) {
            object2 = (SGFigure)arrayList.get(i);
            object = new ArrayList(((SGFigure)object2).getVisibleDataList());
            object = (ArrayList)((ArrayList)object).clone();
            treeMap.put(Integer.toString(((SGFigure)object2).getID()), object);
        }
        Element element = document.getDocumentElement();
        object2 = element.getElementsByTagName("Window");
        if (object2.getLength() == 0) {
            return false;
        }
        object = (Element)object2.item(0);
        int n = sGDrawingWindow.getFigureList().size();
        int n2 = this.createFiguresFromPropertyFile((Element)object, sGDrawingWindow, treeMap);
        if (n2 != 0) {
            return false;
        }
        int n3 = sGDrawingWindow.getFigureList().size();
        sGDrawingWindow.setChanged(n != n3);
        return true;
    }

    private int beforeDiscard(SGDrawingWindow sGDrawingWindow) {
        int n = this.confirmBeforeDiscard(sGDrawingWindow);
        if (n != 0) {
            if (n == 1 | n == -1) {
                return 1;
            }
            if (n == 2) {
                int n2 = this.mPropertyFileManager.savePropertiesByDialog(sGDrawingWindow);
                return n2;
            }
        }
        return 0;
    }

    private int confirmBeforeClosing(SGDrawingWindow sGDrawingWindow) {
        Object[] objectArray = new Object[]{"Close without saving", "Cancel", "Save"};
        return this._showConfirmationDialog(sGDrawingWindow, objectArray, new SGCloseWindowConfirmPanel());
    }

    private int confirmBeforeDiscard(SGDrawingWindow sGDrawingWindow) {
        Object[] objectArray = new Object[]{"Close without saving", "Cancel", "Save"};
        return this._showConfirmationDialog(sGDrawingWindow, objectArray, new SGCloseWindowConfirmPanel());
    }

    private int _showConfirmationDialog(Component component, Object[] objectArray, Object object) {
        Toolkit.getDefaultToolkit().beep();
        int n = JOptionPane.showOptionDialog(component, object, "Confirmation", 1, 2, null, objectArray, objectArray[2]);
        return n;
    }

    private Document createChangeLogDocument() {
        Class<?> clazz = this.getClass();
        URL uRL = clazz.getResource("/resources/ChangeLog.xml");
        if (uRL == null) {
            return null;
        }
        Document document = SGUtilityText.getDocument(uRL.toString());
        return document;
    }

    private boolean showChangeLogDialog(Frame frame) {
        SGChangeLogDialog sGChangeLogDialog = new SGChangeLogDialog(frame, true);
        sGChangeLogDialog.addActionListener(this);
        sGChangeLogDialog.setCenter(frame);
        String string = "Change Log of Samurai Graph.";
        sGChangeLogDialog.setMessage(string);
        Class<?> clazz = this.getClass();
        URL uRL = clazz.getResource("/resources/ChangeLog.html");
        if (uRL == null) {
            JOptionPane.showMessageDialog(frame, "Failed to get log information.");
            return false;
        }
        sGChangeLogDialog.setPage(uRL);
        sGChangeLogDialog.pack();
        sGChangeLogDialog.setVisible(true);
        sGChangeLogDialog.dispose();
        return true;
    }

    private boolean fromCLorDDWizardDialog(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        SGWizardDialog sGWizardDialog = (SGWizardDialog)object;
        String string = actionEvent.getActionCommand();
        return true;
    }

    private boolean addDataByToolBar(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        SGWizardDialog sGWizardDialog = (SGWizardDialog)object;
        SGWizardDialog sGWizardDialog2 = sGWizardDialog.getPrevious();
        SGWizardDialog sGWizardDialog3 = sGWizardDialog.getNext();
        String string = actionEvent.getActionCommand();
        Window window = sGWizardDialog.getOwner();
        if (string.equals("Cancel")) {
            sGWizardDialog.setVisible(false);
            return true;
        }
        if (string.equals("<Prev")) {
            sGWizardDialog.showPrevious();
            return true;
        }
        if (object.equals(this.mFigureIDSelectionWizardDialog)) {
            if (string.equals("Next>")) {
                sGWizardDialog.showNext();
            }
        } else if (object.equals(this.mSingleDataFileChooserWizardDilaog)) {
            if (string.equals("Next>")) {
                File file = this.mSingleDataFileChooserWizardDilaog.getSelectedFileFromTextField();
                if (!file.exists()) {
                    SGUtility.showFileNotFoundMessageDialog(this.mSingleDataFileChooserWizardDilaog);
                    return false;
                }
                String string2 = file.getPath();
                ArrayList arrayList = new ArrayList();
                ArrayList arrayList2 = new ArrayList();
                try {
                    if (!this.mDataCreator.getFileTypeCandidateList(string2, arrayList2)) {
                        SGApplicationUtility.showDataFileInvalidMessageDialog(window);
                        return false;
                    }
                }
                catch (FileNotFoundException fileNotFoundException) {
                    SGUtility.showFileNotFoundMessageDialog(window);
                    return false;
                }
                if (arrayList2.size() == 0) {
                    SGApplicationUtility.showDataFileInvalidMessageDialog(window);
                    return false;
                }
                if (!this.mXYDataTypeSelectionWizardDialog.setEffectiveDataType(arrayList2)) {
                    SGApplicationUtility.showDataFileInvalidMessageDialog(window);
                    return false;
                }
                this.mSingleDataFileChooserWizardDilaog.setSelectedFile(file);
                sGWizardDialog.showNext();
            }
        } else if (object.equals(this.mXYDataTypeSelectionWizardDialog) && string.equals("OK")) {
            sGWizardDialog.setVisible(false);
            SGDrawingWindow sGDrawingWindow = sGWizardDialog.getOwnerWindow();
            int n = this.mFigureIDSelectionWizardDialog.getFigureID();
            File file = this.mSingleDataFileChooserWizardDilaog.getSelectedFile();
            String string3 = file.getPath();
            String string4 = this.mXYDataTypeSelectionWizardDialog.getSelectedDataType();
            if (string4 == null) {
                SGUtility.showMessageDialog(window, "Failed to get the data type.", "Error", 2);
                return false;
            }
            ArrayList<Object> arrayList = new ArrayList<Object>();
            arrayList.add(string4);
            if (string4.equals("SXY_SAMPLING")) {
                Double d = this.mXYDataTypeSelectionWizardDialog.getSamplingRate();
                if (d == null) {
                    return false;
                }
                arrayList.add(d);
            } else if (string4.equals("VXY")) {
                boolean bl = this.mXYDataTypeSelectionWizardDialog.isPolarSelected();
                arrayList.add(bl);
            }
            if (!this.drawGraph(sGDrawingWindow, n, arrayList, string3, true)) {
                return false;
            }
        }
        return true;
    }

    private boolean drawGraphFromDialog(SGDrawingWindow sGDrawingWindow) {
        this.createAllWizardDialogsForDataAdditionFromToolBar(sGDrawingWindow);
        this.mFigureIDSelectionWizardDialog.setCenter(sGDrawingWindow);
        this.mFigureIDSelectionWizardDialog.setVisible(true);
        File file = this.mSingleDataFileChooserWizardDilaog.getSelectedFile();
        if (file == null) {
            return false;
        }
        this.updateCurrentFile(file, 0);
        return true;
    }

    private boolean drawGraph(final SGDrawingWindow sGDrawingWindow, final int n, final ArrayList arrayList, final String string, final boolean bl) {
        Boolean bl2 = null;
        sGDrawingWindow.setWaitCursor(true);
        try {
            bl2 = (Boolean)Worker.post((Task)new Task(){

                public Object run() throws Exception {
                    boolean bl3;
                    SGData sGData;
                    if (sGDrawingWindow == null | arrayList == null | string == null) {
                        return Boolean.FALSE;
                    }
                    if (arrayList.size() == 0) {
                        return Boolean.FALSE;
                    }
                    SGFigure sGFigure = sGDrawingWindow.getFigure(n);
                    try {
                        sGData = SGMainFunctions.this.mDataCreator.create(string, arrayList, sGDrawingWindow);
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                        if (bl) {
                            SGUtility.showFileNotFoundMessageDialog(sGDrawingWindow);
                        }
                        return Boolean.FALSE;
                    }
                    if (sGData == null) {
                        if (bl) {
                            SGUtility.showMessageDialog(sGDrawingWindow, "Failed to create a data object.", "Error", 2);
                        }
                        return Boolean.FALSE;
                    }
                    boolean bl2 = bl3 = sGFigure == null;
                    if (sGFigure != null && !sGFigure.isVisible()) {
                        bl3 = true;
                    }
                    if (bl3) {
                        String string2 = SGMainFunctions.this.getSimpleFileName(string);
                        if (string2 == null) {
                            return Boolean.FALSE;
                        }
                        if (!SGMainFunctions.this.mFigureCreator.createNewFigure(sGDrawingWindow, n, sGData, new Point(), string2)) {
                            return Boolean.FALSE;
                        }
                    } else {
                        String string3 = SGMainFunctions.this.getNewDataName(sGFigure, string);
                        if (string3 == null) {
                            return Boolean.FALSE;
                        }
                        SGDrawingWindow sGDrawingWindow2 = sGDrawingWindow;
                        sGDrawingWindow2.endProgress();
                        sGDrawingWindow2.startProgress();
                        sGDrawingWindow2.setProgressMessage("Add Data");
                        if (!sGFigure.addData(sGData, string3, sGDrawingWindow2, 0.0f, 1.0f)) {
                            sGDrawingWindow2.endProgress();
                            if (bl) {
                                SGApplicationUtility.showDataFileInvalidMessageDialog(sGDrawingWindow);
                            }
                        }
                        sGDrawingWindow2.endProgress();
                    }
                    sGDrawingWindow.repaint();
                    return Boolean.TRUE;
                }
            });
        }
        catch (Exception exception) {
            bl2 = Boolean.FALSE;
        }
        sGDrawingWindow.setWaitCursor(false);
        return bl2;
    }

    private void updateCurrentFile(File file, int n) {
        String string = file.getPath();
        String string2 = file.getParent();
        this.setCurrentFileDirectory(string2);
        String string3 = string.substring(string2.length() + 1);
        if (n == 0) {
            this.mCurrentDataFileName = string3;
        } else if (n == 1) {
            this.mCurrentPropertyFileName = string3;
        } else if (n == 3) {
            this.mCurrentImageFileName = string3;
        } else if (n == 2) {
            this.mCurrentArchiveFileName = string3;
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        String string = actionEvent.getActionCommand();
        if (object.equals(this.mXYDataTypeSelectionWizardDialogFromCLorDD)) {
            this.fromCLorDDWizardDialog(actionEvent);
        }
        if (object.equals(this.mFigureIDSelectionWizardDialog) || object.equals(this.mSingleDataFileChooserWizardDilaog) || object.equals(this.mXYDataTypeSelectionWizardDialog)) {
            this.addDataByToolBar(actionEvent);
        }
    }

    public void exit() {
        this.mWindowManager.closeAllWindow();
    }

    private void exitApplication(int n) {
        if (n != 0) {
            String string = "A fatal error has occured.\nThe current application will be terminated.";
            String string2 = " Forced termination";
            SGUtility.showMessageDialog(null, string, string2, 0);
        }
        System.exit(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean openFile(SGDrawingWindow sGDrawingWindow, String string) {
        block20: {
            if (sGDrawingWindow == null) {
                sGDrawingWindow = this.mWindowManager.getActiveWindow();
            }
            if (sGDrawingWindow == null) {
                return false;
            }
            sGDrawingWindow.setWaitCursor(true);
            try {
                ArrayList arrayList = new ArrayList();
                File file = null;
                File file2 = null;
                Object var6_7 = null;
                File file3 = new File(string);
                String string2 = file3.getAbsolutePath();
                boolean bl = string2.endsWith("sgp");
                boolean bl2 = string2.endsWith("sga");
                if (bl) {
                    file = file3;
                } else if (bl2) {
                    file2 = file3;
                } else {
                    boolean bl3 = false;
                    return bl3;
                }
                if (file != null) {
                    boolean bl4;
                    if (sGDrawingWindow.needsConfirmationBeforeDiscard() && (bl4 = this.beforeDiscard(sGDrawingWindow))) {
                        boolean bl5 = true;
                        return bl5;
                    }
                    if (!this.mPropertyFileManager.showMultiDataFileChooserDialog(file, arrayList, sGDrawingWindow)) {
                        bl4 = false;
                        return bl4;
                    }
                    break block20;
                }
                if (file2 != null) {
                    boolean bl6;
                    if (sGDrawingWindow.needsConfirmationBeforeDiscard() && (bl6 = this.beforeDiscard(sGDrawingWindow))) {
                        boolean bl7 = true;
                        return bl7;
                    }
                    bl6 = this.mDataSetManager.loadDataSetFromEventDispatchThread(sGDrawingWindow, file2);
                    sGDrawingWindow.setSaved(bl6);
                    break block20;
                }
                boolean bl8 = false;
                return bl8;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            finally {
                sGDrawingWindow.setWaitCursor(false);
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean fromDragAndDrop(int n, int n2, SGDrawingWindow sGDrawingWindow, ArrayList arrayList) {
        sGDrawingWindow.setWaitCursor(true);
        try {
            int n3;
            ArrayList<File> arrayList2 = new ArrayList<File>();
            File file = null;
            File file2 = null;
            File file3 = null;
            for (n3 = 0; n3 < arrayList.size(); ++n3) {
                File file4 = (File)arrayList.get(n3);
                String string = file4.getAbsolutePath();
                boolean bl = string.endsWith("sgp");
                boolean bl2 = string.endsWith("sga");
                boolean bl3 = false;
                String[] stringArray = SGIImageConstants.DRAWABLE_IMAGE_EXTENSIONS;
                for (int i = 0; i < stringArray.length; ++i) {
                    if (!(string.endsWith(stringArray[i]) | string.endsWith(stringArray[i].toUpperCase()))) continue;
                    bl3 = true;
                    break;
                }
                if (bl) {
                    file = file4;
                    continue;
                }
                if (bl2) {
                    file2 = file4;
                    continue;
                }
                if (bl3) {
                    file3 = file4;
                    continue;
                }
                arrayList2.add(file4);
            }
            if (file != null) {
                if (sGDrawingWindow.needsConfirmationBeforeDiscard() && (n3 = this.beforeDiscard(sGDrawingWindow)) == 1) {
                    boolean bl = true;
                    return bl;
                }
                if (!this.mPropertyFileManager.showMultiDataFileChooserDialog(file, arrayList2, sGDrawingWindow)) {
                    n3 = 0;
                    return n3 != 0;
                }
            } else if (file2 != null) {
                if (sGDrawingWindow.needsConfirmationBeforeDiscard() && (n3 = this.beforeDiscard(sGDrawingWindow)) == 1) {
                    boolean bl = true;
                    return bl;
                }
                n3 = this.mDataSetManager.loadDataSet(sGDrawingWindow, file2) ? 1 : 0;
                sGDrawingWindow.setSaved(n3 != 0);
            } else if (file3 != null) {
                if (!sGDrawingWindow.setImage(file3)) {
                    n3 = 0;
                    return n3 != 0;
                }
            } else if (!this.addDataByDragAndDrop(n, n2, sGDrawingWindow, arrayList2)) {
                n3 = 0;
                return n3 != 0;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            sGDrawingWindow.setWaitCursor(false);
        }
        return true;
    }

    private void updateToolBarPatternInPreferences(String[] stringArray) {
        Preferences preferences = Preferences.userNodeForPackage(this.getClass());
        String string = "";
        for (int i = 0; i < stringArray.length; ++i) {
            string = string + stringArray[i];
            if (i == stringArray.length - 1) continue;
            string = string + ",";
        }
        preferences.put("Tool Bar Pattern", string);
    }

    private int createSingleFigureFromPropertyFile(Element element, SGDrawingWindow sGDrawingWindow, ArrayList arrayList) {
        int n;
        float f;
        StringBuffer stringBuffer;
        String string = null;
        Number number = null;
        Object var7_6 = null;
        Object var8_7 = null;
        string = element.getAttribute("Type");
        if (string.length() == 0) {
            return 1;
        }
        SGXYFigure sGXYFigure = null;
        if (string.equals("SXY")) {
            sGXYFigure = new SGSXYFigure(sGDrawingWindow);
        } else if (string.equals("VXY")) {
            sGXYFigure = new SGVXYFigure(sGDrawingWindow);
        } else {
            return 1;
        }
        int n2 = sGDrawingWindow.getCurrentFigureId();
        sGXYFigure.setID(n2);
        if (!sGXYFigure.readProperty(element)) {
            return 1;
        }
        if (this.mFigureCreator.createFigureElementFromPropertyFile(sGXYFigure, element) == 1) {
            return 1;
        }
        string = element.getAttribute("SpaceAxisLineAndNumber");
        if (string.length() != 0) {
            stringBuffer = new StringBuffer();
            number = SGUtilityText.getNumber(string, stringBuffer);
            if (number == null) {
                return 1;
            }
            f = number.floatValue();
            if (!sGXYFigure.setSpaceAxisLineAndNumber(f, stringBuffer.toString())) {
                return 1;
            }
        }
        if ((string = element.getAttribute("SpaceNumberAndTitle")).length() != 0) {
            stringBuffer = new StringBuffer();
            number = SGUtilityText.getNumber(string, stringBuffer);
            if (number == null) {
                return 1;
            }
            f = number.floatValue();
            if (!sGXYFigure.setSpaceNumberAndTitle(f, stringBuffer.toString())) {
                return 1;
            }
        }
        if ((n = this.createDataObjectsFromPropertyFile(element, sGXYFigure, arrayList, sGDrawingWindow)) != 0) {
            return n;
        }
        sGDrawingWindow.addFigure(sGXYFigure);
        sGXYFigure.initPropertiesHistory();
        return 0;
    }

    private int createDataObjectsFromPropertyFile(Element element, SGFigure sGFigure, ArrayList arrayList, SGIProgressControl sGIProgressControl) {
        NodeList nodeList = element.getElementsByTagName("Data");
        if (nodeList.getLength() != arrayList.size()) {
            return 1;
        }
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            Object object;
            Element element2;
            block35: {
                Object object2;
                Object object3;
                Node node = nodeList.item(i);
                if (!(node instanceof Element)) continue;
                element2 = (Element)node;
                ArrayList<Object> arrayList2 = new ArrayList<Object>();
                String string = element2.getAttribute("Type");
                if (string == null) {
                    return 1;
                }
                arrayList2.add(string);
                String string2 = null;
                if (string.equals("SXY")) {
                    string2 = (class$jp$riken$brain$ni$samuraigraph$data$SGSXYData == null ? SGMainFunctions.class$("jp.riken.brain.ni.samuraigraph.data.SGSXYData") : class$jp$riken$brain$ni$samuraigraph$data$SGSXYData).getName();
                } else if (string.equals("VXY")) {
                    string2 = (class$jp$riken$brain$ni$samuraigraph$data$SGVXYData == null ? SGMainFunctions.class$("jp.riken.brain.ni.samuraigraph.data.SGVXYData") : class$jp$riken$brain$ni$samuraigraph$data$SGVXYData).getName();
                    object3 = element2.getAttribute("Polar");
                    if (((String)object3).length() == 0) {
                        return 1;
                    }
                    object = SGUtilityText.getBoolean((String)object3);
                    if (object == null) {
                        return 1;
                    }
                    arrayList2.add(object);
                } else if (string.equals("SXY_MULTIPLE")) {
                    string2 = (class$jp$riken$brain$ni$samuraigraph$data$SGSXYMultipleData == null ? SGMainFunctions.class$("jp.riken.brain.ni.samuraigraph.data.SGSXYMultipleData") : class$jp$riken$brain$ni$samuraigraph$data$SGSXYMultipleData).getName();
                } else if (string.equals("SXY_SAMPLING")) {
                    string2 = (class$jp$riken$brain$ni$samuraigraph$data$SGSXYSamplingData == null ? SGMainFunctions.class$("jp.riken.brain.ni.samuraigraph.data.SGSXYSamplingData") : class$jp$riken$brain$ni$samuraigraph$data$SGSXYSamplingData).getName();
                    object3 = element2.getAttribute("SamplingRate");
                    if (((String)object3).length() == 0) {
                        return 1;
                    }
                    object = SGUtilityText.getDouble((String)object3);
                    if (object == null) {
                        return 1;
                    }
                    arrayList2.add(object);
                } else if (string.equals("SXY_DATE")) {
                    string2 = (class$jp$riken$brain$ni$samuraigraph$data$SGSXYDateData == null ? SGMainFunctions.class$("jp.riken.brain.ni.samuraigraph.data.SGSXYDateData") : class$jp$riken$brain$ni$samuraigraph$data$SGSXYDateData).getName();
                } else {
                    return 1;
                }
                object3 = null;
                try {
                    object3 = Class.forName(string2);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    return 1;
                }
                if (object3 == null) {
                    return 1;
                }
                object = null;
                try {
                    object = (SGData)((Class)object3).newInstance();
                }
                catch (Exception exception) {
                    return 1;
                }
                if (object == null) {
                    return 1;
                }
                if (arrayList.size() == 0) {
                    return 3;
                }
                Object e = arrayList.get(i);
                if (e instanceof String) {
                    object2 = (String)e;
                    ArrayList arrayList3 = new ArrayList();
                    SGDrawingWindow sGDrawingWindow = sGFigure.getWindow();
                    try {
                        if (!this.mDataCreator.getFileTypeCandidateList((String)object2, arrayList3)) {
                            return 2;
                        }
                        if (arrayList3.size() == 0 || !arrayList3.contains(string)) {
                            return 2;
                        }
                        SGData sGData = this.mDataCreator.create((String)object2, arrayList2, sGIProgressControl);
                        if (sGData == null) {
                            return 2;
                        }
                        if (!((SGData)object).setData(sGData)) {
                            return 2;
                        }
                        break block35;
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                        return 5;
                    }
                }
                if (e instanceof SGData) {
                    object2 = (SGData)e;
                    if (!((SGData)object).setData((SGData)object2)) {
                        return 1;
                    }
                } else {
                    return 1;
                }
            }
            if (sGFigure.createDataObjectFromPropertyFile(element2, (SGData)object)) continue;
            return 1;
        }
        SGIFigureElement[] sGIFigureElementArray = sGFigure.getIFigureElementArray();
        for (int i = 0; i < sGIFigureElementArray.length; ++i) {
            sGIFigureElementArray[i].initPropertiesHistory();
        }
        return 0;
    }

    private int createFiguresFromPropertyFile(Element element, SGDrawingWindow sGDrawingWindow, Map map) {
        SGDrawingWindow sGDrawingWindow2 = sGDrawingWindow;
        Set set = map.keySet();
        ArrayList arrayList = new ArrayList(map.values());
        NodeList nodeList = element.getElementsByTagName("Figure");
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            int n2;
            Node node = nodeList.item(i);
            if (!(node instanceof Element)) continue;
            Element element2 = (Element)node;
            ArrayList arrayList2 = (ArrayList)arrayList.get(i);
            if (arrayList2.contains("NO_DATA")) {
                arrayList2 = new ArrayList();
            }
            if ((n2 = this.createSingleFigureFromPropertyFile(element2, sGDrawingWindow, arrayList2)) == 0) continue;
            return n2;
        }
        return 0;
    }

    private boolean addDataByDragAndDrop(int n, int n2, SGDrawingWindow sGDrawingWindow, ArrayList arrayList) {
        int n3;
        this.mXYDataTypeSelectionWizardDialogFromCLorDD = new SGXYDataTypeSelectionWizardDialog((Frame)sGDrawingWindow, true);
        this.mXYDataTypeSelectionWizardDialogFromCLorDD.addActionListener(this);
        this.mXYDataTypeSelectionWizardDialogFromCLorDD.mPreviousButton.setVisible(false);
        this.mXYDataTypeSelectionWizardDialogFromCLorDD.mNextButton.setVisible(false);
        this.mXYDataTypeSelectionWizardDialogFromCLorDD.pack();
        File file = (File)arrayList.get(0);
        ArrayList arrayList2 = new ArrayList();
        try {
            n3 = this.createDataFromFile(file.getPath(), arrayList2, sGDrawingWindow);
        }
        catch (FileNotFoundException fileNotFoundException) {
            SGUtility.showFileNotFoundMessageDialog(sGDrawingWindow);
            return false;
        }
        if (n3 == -1) {
            SGApplicationUtility.showDataFileInvalidMessageDialog(sGDrawingWindow);
            return false;
        }
        if (n3 == 1) {
            return true;
        }
        if (arrayList2.size() == 0) {
            return false;
        }
        SGData sGData = (SGData)arrayList2.get(0);
        String string = file.getAbsolutePath();
        Object object = sGDrawingWindow.getComponent(n, n2);
        if (object instanceof SGDrawingWindow) {
            int n4 = sGDrawingWindow.getCurrentFigureId();
            SGFigure sGFigure = sGDrawingWindow.getFigure(n4);
            if (sGFigure == null) {
                String string2 = this.getSimpleFileName(string);
                if (string2 == null) {
                    return false;
                }
                Point point = new Point(n, n2);
                if (!this.mFigureCreator.createNewFigure(sGDrawingWindow, n4, sGData, point, string2)) {
                    return false;
                }
            } else {
                String string3 = this.getNewDataName(sGFigure, string);
                if (string3 == null) {
                    return false;
                }
                SGDrawingWindow sGDrawingWindow2 = sGDrawingWindow;
                sGDrawingWindow2.startProgress();
                sGDrawingWindow2.setProgressMessage("Add Data");
                if (!sGFigure.addData(sGData, string3, sGDrawingWindow2, 0.0f, 1.0f)) {
                    sGDrawingWindow2.endProgress();
                    SGApplicationUtility.showDataTypeInvalidMessageDialog(sGDrawingWindow);
                    return false;
                }
                sGDrawingWindow2.endProgress();
            }
        } else if (object instanceof SGFigure) {
            SGFigure sGFigure = (SGFigure)object;
            String string4 = this.getNewDataName(sGFigure, string);
            if (string4 == null) {
                return false;
            }
            SGDrawingWindow sGDrawingWindow3 = sGDrawingWindow;
            sGDrawingWindow3.startProgress();
            sGDrawingWindow3.setProgressMessage("Add Data");
            if (!sGFigure.addData(sGData, string4, sGDrawingWindow3, 0.0f, 1.0f)) {
                sGDrawingWindow3.endProgress();
                SGApplicationUtility.showDataTypeInvalidMessageDialog(sGDrawingWindow);
                return false;
            }
            sGDrawingWindow3.endProgress();
        } else {
            return false;
        }
        return true;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class DropEventHandler
    extends Thread {
        private DropTargetDropEvent mDropTargetDropEvent = null;
        private ArrayList mDroppedFileList = null;

        private DropEventHandler(DropTargetDropEvent dropTargetDropEvent, ArrayList arrayList) {
            this.mDropTargetDropEvent = dropTargetDropEvent;
            this.mDroppedFileList = arrayList;
            this.start();
        }

        public void run() {
            DropTargetDropEvent dropTargetDropEvent = this.mDropTargetDropEvent;
            DropTarget dropTarget = (DropTarget)dropTargetDropEvent.getSource();
            Component component = dropTarget.getComponent();
            SGDrawingWindow sGDrawingWindow = (SGDrawingWindow)component;
            Point point = dropTargetDropEvent.getLocation();
            SGMainFunctions.this.fromDragAndDrop(point.x, point.y, sGDrawingWindow, this.mDroppedFileList);
            sGDrawingWindow.getContentPane().repaint();
            this.mDropTargetDropEvent = null;
            this.mDroppedFileList = null;
        }
    }

    private class PropertyFileManager
    implements ActionListener {
        private Document mPropertyFileDocument = null;
        private SGPropertyFileCreator mPropertyFileCreator = new SGPropertyFileCreator();
        private SGPropertyFileChooserWizardDialog mPropertyFileChooserWizardDilaog = null;
        private SGMultiDataFileChooserWizardDialog mMultiDataFileChooserWizardDialog = null;
        private SGMultiDataFileChooserWizardDialog mMultiDataFileChooserWizardDialogDD = null;

        private PropertyFileManager() {
        }

        public int saveProperties(SGDrawingWindow sGDrawingWindow, String string) {
            return this.mPropertyFileCreator.create(sGDrawingWindow, new File(string));
        }

        public int savePropertiesByDialog(SGDrawingWindow sGDrawingWindow) {
            return this._savePropertiesByDialog(sGDrawingWindow, SGMainFunctions.this.getCurrentFileDirectory(), SGMainFunctions.this.mCurrentPropertyFileName);
        }

        private int _savePropertiesByDialog(SGDrawingWindow sGDrawingWindow, String string, String string2) {
            this.mPropertyFileCreator.setFile(string, string2);
            int n = this.mPropertyFileCreator.create(sGDrawingWindow);
            if (n != 0) {
                return n;
            }
            File file = this.mPropertyFileCreator.getSelectedFile();
            if (file != null) {
                SGMainFunctions.this.updateCurrentFile(file, 1);
            }
            return 0;
        }

        private boolean loadPropertyFromDialog(SGDrawingWindow sGDrawingWindow) {
            this.createAllWizardDialogsToLoadPropertyFromToolBar(sGDrawingWindow);
            this.mPropertyFileChooserWizardDilaog.setCenter(sGDrawingWindow);
            this.mPropertyFileChooserWizardDilaog.setVisible(true);
            File file = this.mPropertyFileChooserWizardDilaog.getSelectedFile();
            File file2 = this.mMultiDataFileChooserWizardDialog.getSelectedFile();
            long l = this.mPropertyFileChooserWizardDilaog.lastUsed();
            long l2 = this.mMultiDataFileChooserWizardDialog.lastUsed();
            if (file != null & file2 != null) {
                if (l < l2) {
                    SGMainFunctions.this.updateCurrentFile(file2, 0);
                } else {
                    SGMainFunctions.this.updateCurrentFile(file, 1);
                }
            } else if (file != null) {
                SGMainFunctions.this.updateCurrentFile(file, 1);
            } else if (file2 != null) {
                SGMainFunctions.this.updateCurrentFile(file2, 0);
            }
            return true;
        }

        private boolean loadProperty(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            String string = actionEvent.getActionCommand();
            SGWizardDialog sGWizardDialog = (SGWizardDialog)object;
            if (object instanceof SGPropertyFileChooserWizardDialog) {
                SGPropertyFileChooserWizardDialog sGPropertyFileChooserWizardDialog = (SGPropertyFileChooserWizardDialog)sGWizardDialog;
                File file = sGPropertyFileChooserWizardDialog.getSelectedFile();
                if (file != null) {
                    SGMainFunctions.this.updateCurrentFile(file, 1);
                    this.mMultiDataFileChooserWizardDialog.setFile(SGMainFunctions.this.getCurrentFileDirectory(), SGMainFunctions.this.mCurrentDataFileName);
                }
                if (!this.fromPropertyFileChooserDialog(actionEvent, sGWizardDialog)) {
                    return false;
                }
            } else if (object instanceof SGMultiDataFileChooserWizardDialog) {
                SGMultiDataFileChooserWizardDialog sGMultiDataFileChooserWizardDialog = (SGMultiDataFileChooserWizardDialog)sGWizardDialog;
                File file = sGMultiDataFileChooserWizardDialog.getSelectedFile();
                if (file != null) {
                    SGMainFunctions.this.updateCurrentFile(file, 0);
                    if (object.equals(this.mMultiDataFileChooserWizardDialog)) {
                        this.mPropertyFileChooserWizardDilaog.setFile(SGMainFunctions.this.getCurrentFileDirectory(), SGMainFunctions.this.mCurrentPropertyFileName);
                    }
                }
                if (!this.fromMultiDataFileChooser(actionEvent)) {
                    return false;
                }
            }
            if (string.equals("Cancel")) {
                sGWizardDialog.setVisible(false);
            } else if (string.equals("<Prev")) {
                sGWizardDialog.showPrevious();
            }
            return true;
        }

        private boolean setMultiDataFileChooser(ArrayList arrayList, ArrayList arrayList2, ArrayList arrayList3, SGMultiDataFileChooserWizardDialog sGMultiDataFileChooserWizardDialog) {
            int n = arrayList3.size();
            sGMultiDataFileChooserWizardDialog.setFileNumber(n);
            String[] stringArray = new String[n];
            for (int i = 0; i < n; ++i) {
                stringArray[i] = ((Integer)arrayList.get(i)).toString();
            }
            ArrayList<Integer> arrayList4 = new ArrayList<Integer>();
            String[] stringArray2 = new String[n];
            for (int i = 0; i < n; ++i) {
                Object object = arrayList2.get(i);
                if (object == null) {
                    object = "NO_DATA";
                    arrayList4.add(new Integer(i));
                }
                stringArray2[i] = (String)object;
            }
            String[] stringArray3 = new String[n];
            for (int i = 0; i < n; ++i) {
                Object object = arrayList3.get(i);
                if (arrayList4.contains(new Integer(i))) {
                    object = "NO_DATA";
                }
                stringArray3[i] = (String)object;
            }
            String[] stringArray4 = new String[n];
            for (int i = 0; i < n; ++i) {
                if (!arrayList4.contains(new Integer(i))) continue;
                stringArray4[i] = "NO_DATA";
            }
            sGMultiDataFileChooserWizardDialog.setFigureIDArray(stringArray);
            sGMultiDataFileChooserWizardDialog.setDataNameArray(stringArray2);
            sGMultiDataFileChooserWizardDialog.setDataTypeArray(stringArray3);
            sGMultiDataFileChooserWizardDialog.setFileNameArray(stringArray4);
            return true;
        }

        private boolean setPropertyFile(SGDrawingWindow sGDrawingWindow, Document document, Map map) {
            int n;
            Element element = this.getWindowElement(document);
            sGDrawingWindow.startProgress();
            sGDrawingWindow.setProgressMessage("Read Property");
            boolean bl = sGDrawingWindow.readProperty(element, 0.0f, 1.0f);
            sGDrawingWindow.endProgress();
            if (!bl) {
                n = 1;
            } else {
                n = SGMainFunctions.this.createFiguresFromPropertyFile(element, sGDrawingWindow, map);
                if (n == 0) {
                    sGDrawingWindow.initPropertiesHistory();
                    sGDrawingWindow.initSavedHistory();
                    sGDrawingWindow.setSaved(true);
                }
            }
            String string = null;
            switch (n) {
                case 0: {
                    string = "Successful completion.";
                    break;
                }
                case 3: {
                    string = "Data number shortage.";
                    break;
                }
                case 4: {
                    string = "Data number excess.";
                    break;
                }
                case 5: {
                    string = "Cannot open the selected file.";
                    break;
                }
                case 1: {
                    string = "The property file is invalid.";
                    break;
                }
                case 2: {
                    string = "The data file is invalid.";
                    break;
                }
                default: {
                    string = "Unknown error occured";
                }
            }
            if (string != "Successful completion.") {
                SGUtility.showMessageDialog(null, string, "Property file", 0);
                return false;
            }
            return true;
        }

        private boolean setPropertyFileFromEventDispatchThread(SGDrawingWindow sGDrawingWindow, Document document, Map map) {
            sGDrawingWindow.setWaitCursor(true);
            Boolean bl = Boolean.FALSE;
            try {
                bl = (Boolean)Worker.post((Task)new Task(this, sGDrawingWindow, document, map){
                    private final /* synthetic */ SGDrawingWindow val$wnd;
                    private final /* synthetic */ Document val$doc;
                    private final /* synthetic */ Map val$dataMap;
                    private final /* synthetic */ PropertyFileManager this$1;
                    {
                        this.this$1 = propertyFileManager;
                        this.val$wnd = sGDrawingWindow;
                        this.val$doc = document;
                        this.val$dataMap = map;
                    }

                    public Object run() throws Exception {
                        if (!PropertyFileManager.access$2300(this.this$1, this.val$wnd, this.val$doc, this.val$dataMap)) {
                            return Boolean.FALSE;
                        }
                        return Boolean.TRUE;
                    }
                });
            }
            catch (Exception exception) {
                bl = Boolean.FALSE;
            }
            sGDrawingWindow.setWaitCursor(false);
            return bl;
        }

        private Element getWindowElement(Document document) {
            Element element = document.getDocumentElement();
            NodeList nodeList = element.getElementsByTagName("Window");
            if (nodeList.getLength() == 0) {
                return null;
            }
            Element element2 = (Element)nodeList.item(0);
            return element2;
        }

        private boolean getInfoFromPropertyFile(File file, Component component, ArrayList arrayList, ArrayList arrayList2, ArrayList arrayList3) {
            String string = SGUtility.getCanonicalPath(file.getPath());
            if (string == null) {
                SGUtility.showMessageDialog(component, "Cannot open the selected file.", "File open failure", 0);
                return false;
            }
            URL uRL = null;
            try {
                uRL = file.toURL();
            }
            catch (MalformedURLException malformedURLException) {
                return false;
            }
            Document document = SGUtilityText.getDocument(uRL);
            if (document == null) {
                SGUtility.showMessageDialog(component, "The property file is invalid.", "File open failure", 0);
                return false;
            }
            this.mPropertyFileDocument = document;
            NodeList nodeList = document.getElementsByTagName("Figure");
            if (nodeList.getLength() == 0) {
                SGUtility.showMessageDialog(component, "The property file is invalid.", "File open failure", 0);
                return false;
            }
            int n = nodeList.getLength();
            for (int i = 0; i < n; ++i) {
                Node node = nodeList.item(i);
                if (!(node instanceof Element)) continue;
                Element element = (Element)node;
                NodeList nodeList2 = element.getElementsByTagName("Data");
                int n2 = i + 1;
                int n3 = nodeList2.getLength();
                if (n3 == 0) {
                    arrayList.add(new Integer(n2));
                    continue;
                }
                for (int j = 0; j < n3; ++j) {
                    arrayList.add(new Integer(n2));
                }
            }
            if (!this.getDataInfoFromPropertyFile(document, arrayList2, arrayList3)) {
                SGUtility.showMessageDialog(component, "The property file is invalid.", "File open failure", 0);
                return false;
            }
            if (arrayList3.size() != arrayList.size()) {
                SGUtility.showMessageDialog(component, "The property file is invalid.", "File open failure", 0);
                return false;
            }
            return true;
        }

        private boolean getDataInfoFromPropertyFile(Document document, ArrayList arrayList, ArrayList arrayList2) {
            Element element = document.getDocumentElement();
            NodeList nodeList = element.getElementsByTagName("Window");
            if (nodeList.getLength() == 0) {
                return false;
            }
            Element element2 = (Element)nodeList.item(0);
            NodeList nodeList2 = element2.getElementsByTagName("Figure");
            for (int i = 0; i < nodeList2.getLength(); ++i) {
                Node node = nodeList2.item(i);
                if (!(node instanceof Element)) continue;
                Element element3 = (Element)node;
                NodeList nodeList3 = element3.getElementsByTagName("Data");
                int n = nodeList3.getLength();
                if (n == 0) {
                    arrayList.add(null);
                    arrayList2.add(null);
                    continue;
                }
                for (int j = 0; j < n; ++j) {
                    Node node2 = nodeList3.item(j);
                    if (!(node2 instanceof Element)) continue;
                    Element element4 = (Element)node2;
                    String string = element4.getAttribute("Name");
                    arrayList.add(string);
                    String string2 = element4.getAttribute("Type");
                    arrayList2.add(string2);
                }
            }
            return true;
        }

        private boolean fromPropertyFileChooserDialog(ActionEvent actionEvent, SGWizardDialog sGWizardDialog) {
            String string = actionEvent.getActionCommand();
            Window window = sGWizardDialog.getOwner();
            SGWizardDialog sGWizardDialog2 = sGWizardDialog.getNext();
            if (!(sGWizardDialog instanceof SGPropertyFileChooserWizardDialog)) {
                return false;
            }
            if (!(sGWizardDialog2 instanceof SGMultiDataFileChooserWizardDialog)) {
                return false;
            }
            SGPropertyFileChooserWizardDialog sGPropertyFileChooserWizardDialog = (SGPropertyFileChooserWizardDialog)sGWizardDialog;
            SGMultiDataFileChooserWizardDialog sGMultiDataFileChooserWizardDialog = (SGMultiDataFileChooserWizardDialog)sGWizardDialog2;
            return !string.equals("Next>") || this.fromPropertyFileChooserDialogNext(sGPropertyFileChooserWizardDialog, sGMultiDataFileChooserWizardDialog);
        }

        private boolean fromMultiDataFileChooser(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            SGWizardDialog sGWizardDialog = (SGWizardDialog)object;
            String string = actionEvent.getActionCommand();
            SGMultiDataFileChooserWizardDialog sGMultiDataFileChooserWizardDialog = (SGMultiDataFileChooserWizardDialog)sGWizardDialog;
            Window window = sGWizardDialog.getOwner();
            if (string.equals("OK")) {
                SGDrawingWindow sGDrawingWindow = (SGDrawingWindow)window;
                sGDrawingWindow.deleteImage();
                sGDrawingWindow.clearUndoBuffer();
                sGDrawingWindow.removeAllFigures();
                sGDrawingWindow.updateClientRect();
                TreeMap treeMap = sGMultiDataFileChooserWizardDialog.getSelectedFilePathListMap();
                if (!this.setPropertyFileFromEventDispatchThread(sGDrawingWindow, this.mPropertyFileDocument, treeMap)) {
                    return false;
                }
                sGDrawingWindow.updateClientRect();
                sGWizardDialog.setVisible(false);
            } else if (string.equals("Cancel")) {
                sGWizardDialog.setVisible(false);
            }
            return true;
        }

        private boolean fromPropertyFileChooserDialogNext(SGPropertyFileChooserWizardDialog sGPropertyFileChooserWizardDialog, SGMultiDataFileChooserWizardDialog sGMultiDataFileChooserWizardDialog) {
            File file = sGPropertyFileChooserWizardDialog.getSelectedFileFromTextField();
            if (!file.exists()) {
                SGUtility.showFileNotFoundMessageDialog(sGPropertyFileChooserWizardDialog);
                return false;
            }
            sGPropertyFileChooserWizardDialog.setSelectedFile(file);
            ArrayList arrayList = new ArrayList();
            ArrayList arrayList2 = new ArrayList();
            ArrayList arrayList3 = new ArrayList();
            if (!this.getInfoFromPropertyFile(file, sGPropertyFileChooserWizardDialog, arrayList, arrayList2, arrayList3)) {
                return false;
            }
            sGMultiDataFileChooserWizardDialog.init(arrayList.size());
            if (!this.setMultiDataFileChooser(arrayList, arrayList2, arrayList3, sGMultiDataFileChooserWizardDialog)) {
                return false;
            }
            sGPropertyFileChooserWizardDialog.showNext();
            return true;
        }

        private boolean createAllWizardDialogsToLoadPropertyFromToolBar(SGDrawingWindow sGDrawingWindow) {
            this.mPropertyFileChooserWizardDilaog = new SGPropertyFileChooserWizardDialog((Frame)sGDrawingWindow, true);
            this.mPropertyFileChooserWizardDilaog.getPreviousButton().setVisible(false);
            this.mPropertyFileChooserWizardDilaog.getOKButton().setVisible(false);
            this.mPropertyFileChooserWizardDilaog.pack();
            this.mMultiDataFileChooserWizardDialog = new SGMultiDataFileChooserWizardDialog((Frame)sGDrawingWindow, true);
            this.mMultiDataFileChooserWizardDialog.getNextButton().setVisible(false);
            this.mMultiDataFileChooserWizardDialog.pack();
            SGExtensionFileFilter sGExtensionFileFilter = new SGExtensionFileFilter();
            sGExtensionFileFilter.setDescription("Samurai Graph Property File");
            sGExtensionFileFilter.addExtension("sgp");
            this.mPropertyFileChooserWizardDilaog.setFileFilter(sGExtensionFileFilter);
            String string = SGMainFunctions.this.getCurrentFileDirectory();
            this.mPropertyFileChooserWizardDilaog.setFile(string, SGMainFunctions.this.mCurrentPropertyFileName);
            this.mMultiDataFileChooserWizardDialog.setFile(string, SGMainFunctions.this.mCurrentDataFileName);
            this.mPropertyFileChooserWizardDilaog.setNext(this.mMultiDataFileChooserWizardDialog);
            this.mMultiDataFileChooserWizardDialog.setPrevious(this.mPropertyFileChooserWizardDilaog);
            this.mPropertyFileChooserWizardDilaog.addActionListener(this);
            this.mMultiDataFileChooserWizardDialog.addActionListener(this);
            return true;
        }

        private boolean showMultiDataFileChooserDialog(File file, ArrayList arrayList, Frame frame) {
            if (!file.exists()) {
                SGUtility.showMessageDialog(frame, "Cannot open the selected file.", "File open failure", 0);
                return false;
            }
            SGMultiDataFileChooserWizardDialog sGMultiDataFileChooserWizardDialog = this.mMultiDataFileChooserWizardDialogDD = new SGMultiDataFileChooserWizardDialog(frame, true);
            sGMultiDataFileChooserWizardDialog.getPreviousButton().setVisible(false);
            sGMultiDataFileChooserWizardDialog.getNextButton().setVisible(false);
            sGMultiDataFileChooserWizardDialog.pack();
            sGMultiDataFileChooserWizardDialog.addActionListener(this);
            this.mMultiDataFileChooserWizardDialogDD.setFile(SGMainFunctions.this.getCurrentFileDirectory(), SGMainFunctions.this.mCurrentDataFileName);
            ArrayList arrayList2 = new ArrayList();
            ArrayList arrayList3 = new ArrayList();
            ArrayList arrayList4 = new ArrayList();
            if (!this.getInfoFromPropertyFile(file, frame, arrayList2, arrayList3, arrayList4)) {
                return false;
            }
            sGMultiDataFileChooserWizardDialog.init(arrayList2.size());
            if (!this.setMultiDataFileChooser(arrayList2, arrayList3, arrayList4, sGMultiDataFileChooserWizardDialog)) {
                return false;
            }
            if (frame != null) {
                sGMultiDataFileChooserWizardDialog.setCenter(frame);
            } else {
                sGMultiDataFileChooserWizardDialog.setLocationRelativeTo(null);
            }
            sGMultiDataFileChooserWizardDialog.setVisible(true);
            return true;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            String string = actionEvent.getActionCommand();
            if (object.equals(this.mPropertyFileChooserWizardDilaog) || object.equals(this.mMultiDataFileChooserWizardDialog) || object.equals(this.mMultiDataFileChooserWizardDialogDD)) {
                this.loadProperty(actionEvent);
            }
        }
    }

    private class PropertyManager {
        private PropertyManager() {
        }

        private boolean contains(String[] stringArray, String string) {
            ArrayList<String> arrayList = new ArrayList<String>(Arrays.asList(stringArray));
            return arrayList.contains(string);
        }

        private int getAxisLocation(String string) {
            String string2 = string.toLowerCase();
            int n = -1;
            if ("Bottom".toLowerCase().equals(string2)) {
                n = 0;
            } else if ("Top".toLowerCase().equals(string2)) {
                n = 1;
            } else if ("Left".toLowerCase().equals(string2)) {
                n = 2;
            } else if ("Right".toLowerCase().equals(string2)) {
                n = 3;
            }
            return n;
        }

        private int getLineType(String string) {
            Integer n = SGUtilityText.getInteger(string);
            if (n != null) {
                int n2 = n;
                if (SGDrawingElementLine.getLineTypeName(n2) != null) {
                    return n2;
                }
                return -1;
            }
            String string2 = string.toLowerCase();
            int n3 = -1;
            Integer n4 = SGDrawingElementLine.getLineTypeFromName(string2);
            if (n4 != null) {
                n3 = n4;
            }
            return n3;
        }

        private int getSymbolType(String string) {
            Integer n = SGUtilityText.getInteger(string);
            if (n != null) {
                int n2 = n;
                if (SGDrawingElementSymbol.getSymbolTypeName(n2) != null) {
                    return n2;
                }
                return -1;
            }
            String string2 = string.toLowerCase();
            int n3 = -1;
            Integer n4 = SGDrawingElementSymbol.getSymbolTypeFromName(string2);
            if (n4 != null) {
                n3 = n4;
            }
            return n3;
        }

        private int getFontStyle(String string) {
            Integer n = SGUtilityText.getInteger(string);
            if (n != null) {
                int n2 = n;
                if (SGUtilityText.getFontStyleName(n2) != null) {
                    return n2;
                }
                return -1;
            }
            String string2 = string.toLowerCase();
            int n3 = SGUtilityText.getFontStyle(string2);
            return n3;
        }

        private int getScaleType(String string) {
            Integer n = SGUtilityText.getInteger(string);
            if (n != null) {
                int n2 = n;
                if (SGUtilityText.getScaleTypeName(n2) != null) {
                    return n2;
                }
                return -1;
            }
            String string2 = string.toLowerCase();
            int n3 = SGUtilityText.getScaleType(string2);
            return n3;
        }

        private int getErrorBarStyle(String string) {
            Integer n = SGUtilityText.getInteger(string);
            if (n != null) {
                int n2 = n;
                if (SGDrawingElementErrorBar.getErrorBarStyleName(n2) != null) {
                    return n2;
                }
                return -1;
            }
            String string2 = string.toLowerCase();
            int n3 = -1;
            Integer n4 = SGDrawingElementErrorBar.getErrorBarStyleFromName(string2);
            if (n4 != null) {
                n3 = n4;
            }
            return n3;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private int setWindowProperties(String string, SGDrawingWindow sGDrawingWindow, ArrayList arrayList) {
            String[] stringArray = new String[]{"paperWidth", "paperHeight", "paperSize", "paperGridInterval", "paperGridLineWidth", "paperGridVisible", "paperGridColor", "paperBackgroundColor", "imageLocationX", "imageLocationY", "imageScalingFactor", "cutFigure", "copyFigure", "pasteFigure", "deleteFigure", "duplicateFigure", "moveToFrontFigure", "moveToBackFigure"};
            if (!this.contains(stringArray, string)) {
                return 1;
            }
            if (sGDrawingWindow == null) {
                return -1;
            }
            int n = arrayList.size();
            if (string.equals("paperWidth")) {
                StringBuffer stringBuffer;
                if (n != 1) {
                    return -1;
                }
                String string2 = (String)arrayList.get(0);
                Number number = SGUtilityText.getNumber(string2, stringBuffer = new StringBuffer());
                if (number == null) {
                    return -1;
                }
                if (sGDrawingWindow.setPaperWidthDirectly(number.floatValue(), stringBuffer.toString())) return 0;
                return -1;
            }
            if (string.equals("paperHeight")) {
                StringBuffer stringBuffer;
                if (n != 1) {
                    return -1;
                }
                String string3 = (String)arrayList.get(0);
                Number number = SGUtilityText.getNumber(string3, stringBuffer = new StringBuffer());
                if (number == null) {
                    return -1;
                }
                if (sGDrawingWindow.setPaperHeightDirectly(number.floatValue(), stringBuffer.toString())) return 0;
                return -1;
            }
            if (string.equals("paperSize")) {
                StringBuffer stringBuffer;
                StringBuffer stringBuffer2;
                if (n == 1) {
                    String string4 = (String)arrayList.get(0);
                    MediaSize mediaSize = SGUtilityText.getMediaSize(string4);
                    if (mediaSize == null) {
                        return -1;
                    }
                    if (sGDrawingWindow.setPaperSizeDirectly(mediaSize)) return 0;
                    return -1;
                }
                if (n != 2) return 0;
                String string5 = (String)arrayList.get(0);
                Number number = SGUtilityText.getNumber(string5, stringBuffer2 = new StringBuffer());
                if (number == null) {
                    return -1;
                }
                String string6 = (String)arrayList.get(1);
                Number number2 = SGUtilityText.getNumber(string6, stringBuffer = new StringBuffer());
                if (number2 == null) {
                    return -1;
                }
                if (sGDrawingWindow.setPaperSizeDirectly(number.floatValue(), stringBuffer2.toString(), number2.floatValue(), stringBuffer.toString())) return 0;
                return -1;
            }
            if (string.equals("paperGridInterval")) {
                StringBuffer stringBuffer;
                if (n != 1) {
                    return -1;
                }
                String string7 = (String)arrayList.get(0);
                Number number = SGUtilityText.getNumber(string7, stringBuffer = new StringBuffer());
                if (number == null) {
                    return -1;
                }
                if (sGDrawingWindow.setGridLineIntervalDirectly(number.floatValue(), stringBuffer.toString())) return 0;
                return -1;
            }
            if (string.equals("paperGridLineWidth")) {
                StringBuffer stringBuffer;
                if (n != 1) {
                    return -1;
                }
                String string8 = (String)arrayList.get(0);
                Number number = SGUtilityText.getNumber(string8, stringBuffer = new StringBuffer());
                if (number == null) {
                    return -1;
                }
                if (sGDrawingWindow.setGridLineWidthDirectly(number.floatValue(), stringBuffer.toString())) return 0;
                return -1;
            }
            if (string.equals("paperGridVisible")) {
                if (n != 1) {
                    return -1;
                }
                String string9 = (String)arrayList.get(0);
                String string10 = SGUtilityText.getBooleanString(string9);
                if (string10 == null) {
                    return -1;
                }
                Boolean bl = Boolean.valueOf(string10);
                if (sGDrawingWindow.setGridLineVisibleDirectly(bl)) return 0;
                return -1;
            }
            if (string.equals("paperGridColor")) {
                String string11;
                String string12;
                if (n == 1) {
                    String string13 = (String)arrayList.get(0);
                    Color color = SGUtilityText.getColor(string13);
                    if (color == null) {
                        return -1;
                    }
                    if (sGDrawingWindow.setGridLineColorDirectly(color)) return 0;
                    return -1;
                }
                if (n != 3) return -1;
                String string14 = (String)arrayList.get(0);
                Color color = SGUtilityText.getColor(string14, string12 = (String)arrayList.get(1), string11 = (String)arrayList.get(2));
                if (color == null) {
                    return -1;
                }
                if (sGDrawingWindow.setGridLineColorDirectly(color)) return 0;
                return -1;
            }
            if (string.equals("paperBackgroundColor")) {
                String string15;
                String string16;
                if (n == 1) {
                    String string17 = (String)arrayList.get(0);
                    Color color = SGUtilityText.getColor(string17);
                    if (color == null) {
                        return -1;
                    }
                    if (sGDrawingWindow.setPaperColorDirectly(color)) return 0;
                    return -1;
                }
                if (n != 3) return -1;
                String string18 = (String)arrayList.get(0);
                Color color = SGUtilityText.getColor(string18, string16 = (String)arrayList.get(1), string15 = (String)arrayList.get(2));
                if (color == null) {
                    return -1;
                }
                if (sGDrawingWindow.setPaperColorDirectly(color)) return 0;
                return -1;
            }
            if (string.equals("imageLocationX")) {
                StringBuffer stringBuffer;
                if (n != 1) {
                    return -1;
                }
                String string19 = (String)arrayList.get(0);
                Number number = SGUtilityText.getNumber(string19, stringBuffer = new StringBuffer());
                if (number == null) {
                    return -1;
                }
                if (sGDrawingWindow.setImageLocationXDirectly(number.floatValue(), stringBuffer.toString())) return 0;
                return -1;
            }
            if (string.equals("imageLocationY")) {
                StringBuffer stringBuffer;
                if (n != 1) {
                    return -1;
                }
                String string20 = (String)arrayList.get(0);
                Number number = SGUtilityText.getNumber(string20, stringBuffer = new StringBuffer());
                if (number == null) {
                    return -1;
                }
                if (sGDrawingWindow.setImageLocationYDirectly(number.floatValue(), stringBuffer.toString())) return 0;
                return -1;
            }
            if (string.equals("imageScalingFactor")) {
                if (n != 1) {
                    return -1;
                }
                String string21 = (String)arrayList.get(0);
                Float f = SGUtilityText.getFloat(string21);
                if (f == null) {
                    return -1;
                }
                if (sGDrawingWindow.setImageScalingFactorDirectly(((Number)f).floatValue())) return 0;
                return -1;
            }
            if (string.equals("deleteFigure")) {
                if (n != 1) {
                    return -1;
                }
                String string22 = (String)arrayList.get(0);
                Integer n2 = SGUtilityText.getInteger(string22);
                if (n2 == null) {
                    return -1;
                }
                if (sGDrawingWindow.hideFigure(n2)) return 0;
                return -1;
            }
            if (string.equals("duplicateFigure")) {
                if (n != 1) {
                    return -1;
                }
                String string23 = (String)arrayList.get(0);
                Integer n3 = SGUtilityText.getInteger(string23);
                if (n3 == null) {
                    return -1;
                }
                if (sGDrawingWindow.hideFigure(n3)) return 0;
                return -1;
            }
            if (string.equals("moveToFrontFigure")) {
                if (n != 1) {
                    return -1;
                }
                String string24 = (String)arrayList.get(0);
                Integer n4 = SGUtilityText.getInteger(string24);
                if (n4 == null) {
                    return -1;
                }
                if (sGDrawingWindow.moveFigure(n4, true)) return 0;
                return -1;
            }
            if (!string.equals("moveToBackFigure")) return 0;
            if (n != 1) {
                return -1;
            }
            String string25 = (String)arrayList.get(0);
            Integer n5 = SGUtilityText.getInteger(string25);
            if (n5 == null) {
                return -1;
            }
            if (sGDrawingWindow.moveFigure(n5, false)) return 0;
            return -1;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private int setFigureProperties(String string, SGFigure sGFigure, ArrayList arrayList) {
            Object object;
            Object object2;
            Object object3;
            Object object4;
            if (sGFigure == null) {
                return -1;
            }
            String[] stringArray = new String[]{"figureLocationX", "figureLocationY", "figureWidth", "figureHeight", "figureSpaceToScale", "figureSpaceToTitle", "figureBackgroundColor", "figureBackgroundTransparent", "figureGridAxisX", "figureGridAxisY", "figureGridVisible", "figureGridAuto", "figureGridStepX", "figureGridStepY", "figureGridBaseX", "figureGridBaseY", "figureGridLineWidth", "figureGridLineType", "figureGridColor"};
            if (!this.contains(stringArray, string)) {
                return 1;
            }
            int n = arrayList.size();
            if (n < 1) {
                return -1;
            }
            String string2 = (String)arrayList.get(0);
            if (string.equals("figureLocationX")) {
                object4 = new StringBuffer();
                object3 = SGUtilityText.getNumber(string2, (StringBuffer)object4);
                if (object3 == null) {
                    return -1;
                }
                if (!sGFigure.setFigureXDirectly(((Number)object3).floatValue(), ((StringBuffer)object4).toString())) {
                    return -1;
                }
            } else if (string.equals("figureLocationY")) {
                object4 = new StringBuffer();
                object3 = SGUtilityText.getNumber(string2, (StringBuffer)object4);
                if (object3 == null) {
                    return -1;
                }
                if (!sGFigure.setFigureYDirectly(((Number)object3).floatValue(), ((StringBuffer)object4).toString())) {
                    return -1;
                }
            } else if (string.equals("figureWidth")) {
                object4 = new StringBuffer();
                object3 = SGUtilityText.getNumber(string2, (StringBuffer)object4);
                if (object3 == null) {
                    return -1;
                }
                if (!sGFigure.setFigureWidthDirectly(((Number)object3).floatValue(), ((StringBuffer)object4).toString())) {
                    return -1;
                }
            } else if (string.equals("figureHeight")) {
                object4 = new StringBuffer();
                object3 = SGUtilityText.getNumber(string2, (StringBuffer)object4);
                if (object3 == null) {
                    return -1;
                }
                if (!sGFigure.setFigureHeightDirectly(((Number)object3).floatValue(), ((StringBuffer)object4).toString())) {
                    return -1;
                }
            } else if (string.equals("figureSpaceToScale")) {
                object4 = new StringBuffer();
                object3 = SGUtilityText.getNumber(string2, (StringBuffer)object4);
                if (object3 == null) {
                    return -1;
                }
                if (!sGFigure.setSpaceAxisLineAndNumberDirectly(((Number)object3).floatValue(), ((StringBuffer)object4).toString())) {
                    return -1;
                }
            } else if (string.equals("figureSpaceToTitle")) {
                object4 = new StringBuffer();
                object3 = SGUtilityText.getNumber(string2, (StringBuffer)object4);
                if (object3 == null) {
                    return -1;
                }
                if (!sGFigure.setSpaceNumberAndTitleDirectly(((Number)object3).floatValue(), ((StringBuffer)object4).toString())) {
                    return -1;
                }
            } else if (string.equals("figureBackgroundColor")) {
                if (n == 1) {
                    object4 = SGUtilityText.getColor(string2);
                    if (object4 == null) {
                        return -1;
                    }
                    if (!sGFigure.setBackgroundColorDirectly((Color)object4)) {
                        return -1;
                    }
                } else {
                    if (n != 3) return -1;
                    object4 = string2;
                    object3 = (String)arrayList.get(1);
                    object = SGUtilityText.getColor((String)object4, (String)object3, (String)(object2 = (String)arrayList.get(2)));
                    if (object == null) {
                        return -1;
                    }
                    if (!sGFigure.setBackgroundColorDirectly((Color)object)) {
                        return -1;
                    }
                }
            } else if (string.equals("figureBackgroundTransparent") && !sGFigure.setTransparentDirectly((Boolean)(object4 = SGUtilityText.getBoolean(SGUtilityText.getBooleanString(string2))))) {
                return -1;
            }
            if (!(sGFigure instanceof SGXYFigure)) return 0;
            object4 = (SGXYFigure)sGFigure;
            if (string.equals("figureGridAxisX")) {
                int n2 = this.getAxisLocation(string2);
                if (n2 == -1) {
                    return -1;
                }
                if (((SGXYFigure)object4).setXAxisLocationDirectly(n2)) return 0;
                return -1;
            }
            if (string.equals("figureGridAxisY")) {
                int n3 = this.getAxisLocation(string2);
                if (n3 == -1) {
                    return -1;
                }
                if (((SGXYFigure)object4).setYAxisLocationDirectly(n3)) return 0;
                return -1;
            }
            if (string.equals("figureGridVisible")) {
                object3 = SGUtilityText.getBoolean(SGUtilityText.getBooleanString(string2));
                if (object3 == null) {
                    return -1;
                }
                if (((SGXYFigure)object4).setGridVisibleDirectly((Boolean)object3)) return 0;
                return -1;
            }
            if (string.equals("figureGridAuto")) {
                object3 = SGUtilityText.getBoolean(SGUtilityText.getBooleanString(string2));
                if (object3 == null) {
                    return -1;
                }
                if (((SGXYFigure)object4).setAutoCalculateRangeDirectly((Boolean)object3)) return 0;
                return -1;
            }
            if (string.equals("figureGridStepX")) {
                object3 = SGUtilityText.getDouble(string2);
                if (object3 == null) {
                    return -1;
                }
                if (((SGXYFigure)object4).setGridStepValueXDirectly(((Number)object3).doubleValue())) return 0;
                return -1;
            }
            if (string.equals("figureGridStepY")) {
                object3 = SGUtilityText.getDouble(string2);
                if (object3 == null) {
                    return -1;
                }
                if (((SGXYFigure)object4).setGridStepValueYDirectly(((Number)object3).doubleValue())) return 0;
                return -1;
            }
            if (string.equals("figureGridBaseX")) {
                object3 = SGUtilityText.getDouble(string2);
                if (object3 == null) {
                    return -1;
                }
                if (((SGXYFigure)object4).setGridBaselineValueXDirectly(((Number)object3).doubleValue())) return 0;
                return -1;
            }
            if (string.equals("figureGridBaseY")) {
                object3 = SGUtilityText.getDouble(string2);
                if (object3 == null) {
                    return -1;
                }
                if (((SGXYFigure)object4).setGridBaselineValueYDirectly(((Number)object3).doubleValue())) return 0;
                return -1;
            }
            if (string.equals("figureGridLineWidth")) {
                object3 = new StringBuffer();
                object2 = SGUtilityText.getNumber(string2, (StringBuffer)object3);
                if (object2 == null) {
                    return -1;
                }
                if (((SGXYFigure)object4).setGridLineWidthDirectly(((Number)object2).floatValue(), ((StringBuffer)object3).toString())) return 0;
                return -1;
            }
            if (string.equals("figureGridLineType")) {
                int n4 = this.getLineType(string2);
                if (n4 == -1) {
                    return -1;
                }
                if (((SGXYFigure)object4).setGridLineTypeDirectly(n4)) return 0;
                return -1;
            }
            if (!string.equals("figureGridColor")) return 0;
            object3 = null;
            if (n == 1) {
                object3 = SGUtilityText.getColor(string2);
            } else {
                if (n != 3) return -1;
                object2 = (String)arrayList.get(0);
                object = (String)arrayList.get(1);
                String string3 = (String)arrayList.get(2);
                object3 = SGUtilityText.getColor((String)object2, (String)object, string3);
            }
            if (object3 == null) {
                return -1;
            }
            if (((SGXYFigure)object4).setGridLineColorDirectly((Color)object3)) return 0;
            return -1;
        }

        private int setDataProperties(String string, SGIFigureElementGraph sGIFigureElementGraph, ArrayList arrayList) {
            String[] stringArray = new String[]{"dataAxisX", "dataAxisY", "dataVisibleInLegend", "dataName", "dataLineVisible", "dataLineWidth", "dataLineType", "dataLineColor", "dataSymbolVisible", "dataSymbolType", "dataSymbolSize", "dataSymbolBodyColor", "dataSymbolLineWidth", "dataSymbolLineColor", "dataBarVisible", "dataBarBaseline", "dataBarBodyWidth", "dataBarBodyColor", "dataBarEdgeLineWidth", "dataBarLineColor", "dataErrorBarVisible", "dataErrorBarSymbolType", "dataErrorBarSymbolSize", "dataErrorBarColor", "dataErrorBarLineWidth", "dataErrorBarStyle", "dataTickLabelVisible", "dataTickLabelFontName", "dataTickLabelFontStyle", "dataTickLabelFontSize", "dataTickLabelFontColor", "dataTickLabelHorizontal", "dataArrowMagnitudePerCM", "dataArrowDirectionInvariant", "dataArrowLineWidth", "dataArrowLineType", "dataArrowHeadSize", "dataArrowColor", "dataArrowStartType", "dataArrowEndType", "dataArrowOpenAngle", "dataArrowCloseAngle", "deleteData", "moveToFrontData", "moveToBackData"};
            if (!this.contains(stringArray, string)) {
                return 1;
            }
            int n = arrayList.size();
            if (arrayList.size() < 1) {
                return -1;
            }
            String string2 = (String)arrayList.get(0);
            Integer n2 = SGUtilityText.getInteger(string2);
            if (n2 == null) {
                return -1;
            }
            if (n == 1) {
                if (string.equals("deleteData") ? !sGIFigureElementGraph.hideChildObject(n2) : (string.equals("moveToFrontData") ? !sGIFigureElementGraph.moveChildObject(n2, true) : string.equals("moveToBackData") && !sGIFigureElementGraph.moveChildObject(n2, false))) {
                    return -1;
                }
                return 0;
            }
            String string3 = (String)arrayList.get(1);
            if (string.equals("dataAxisX")) {
                int n3 = this.getAxisLocation(string3);
                if (n3 == -1) {
                    return -1;
                }
                if (!sGIFigureElementGraph.setAxisXDirectly(n2, n3)) {
                    return -1;
                }
            } else if (string.equals("dataAxisY")) {
                int n4 = this.getAxisLocation(string3);
                if (n4 == -1) {
                    return -1;
                }
                if (!sGIFigureElementGraph.setAxisYDirectly(n2, n4)) {
                    return -1;
                }
            } else if (string.equals("dataVisibleInLegend")) {
                Boolean bl = SGUtilityText.getBoolean(SGUtilityText.getBooleanString(string3));
                if (bl == null) {
                    return -1;
                }
                if (!sGIFigureElementGraph.setVisibleInLegendDirectly(n2, bl)) {
                    return -1;
                }
            } else if (string.equals("dataName") && !sGIFigureElementGraph.setNameDirectly(n2, string3)) {
                return -1;
            }
            if (sGIFigureElementGraph instanceof SGIFigureElementGraphSXY) {
                SGIFigureElementGraphSXY sGIFigureElementGraphSXY = (SGIFigureElementGraphSXY)sGIFigureElementGraph;
                if (string.equals("dataLineVisible")) {
                    Boolean bl = SGUtilityText.getBoolean(SGUtilityText.getBooleanString(string3));
                    if (bl == null) {
                        return -1;
                    }
                    if (!sGIFigureElementGraphSXY.setLineVisibleDirectly(n2, bl)) {
                        return -1;
                    }
                } else if (string.equals("dataLineWidth")) {
                    StringBuffer stringBuffer = new StringBuffer();
                    Number number = SGUtilityText.getNumber(string3, stringBuffer);
                    if (number == null) {
                        return -1;
                    }
                    if (!sGIFigureElementGraphSXY.setLineWidthDirectly(n2, number.floatValue(), stringBuffer.toString())) {
                        return -1;
                    }
                } else if (string.equals("dataLineType")) {
                    int n5 = this.getLineType(string3);
                    if (n5 == -1) {
                        return -1;
                    }
                    if (!sGIFigureElementGraphSXY.setLineTypeDirectly(n2, n5)) {
                        return -1;
                    }
                } else if (string.equals("dataLineColor")) {
                    Color color = null;
                    if (n == 2) {
                        color = SGUtilityText.getColor(string3);
                    } else if (n == 4) {
                        String string4 = (String)arrayList.get(2);
                        String string5 = (String)arrayList.get(3);
                        color = SGUtilityText.getColor(string3, string4, string5);
                    } else {
                        return -1;
                    }
                    if (color == null) {
                        return -1;
                    }
                    if (!sGIFigureElementGraphSXY.setLineColorDirectly(n2, color)) {
                        return -1;
                    }
                } else if (string.equals("dataSymbolVisible")) {
                    Boolean bl = SGUtilityText.getBoolean(SGUtilityText.getBooleanString(string3));
                    if (bl == null) {
                        return -1;
                    }
                    if (!sGIFigureElementGraphSXY.setSymbolVisibleDirectly(n2, bl)) {
                        return -1;
                    }
                } else if (string.equals("dataSymbolType")) {
                    int n6 = this.getSymbolType(string3);
                    if (n6 == -1) {
                        return -1;
                    }
                    if (!sGIFigureElementGraphSXY.setSymbolTypeDirectly(n2, n6)) {
                        return -1;
                    }
                } else if (string.equals("dataSymbolSize")) {
                    StringBuffer stringBuffer = new StringBuffer();
                    Number number = SGUtilityText.getNumber(string3, stringBuffer);
                    if (number == null) {
                        return -1;
                    }
                    if (!sGIFigureElementGraphSXY.setSymbolSizeDirectly(n2, number.floatValue(), stringBuffer.toString())) {
                        return -1;
                    }
                } else if (string.equals("dataSymbolLineWidth")) {
                    StringBuffer stringBuffer = new StringBuffer();
                    Number number = SGUtilityText.getNumber(string3, stringBuffer);
                    if (number == null) {
                        return -1;
                    }
                    if (!sGIFigureElementGraphSXY.setSymbolLineWidthDirectly(n2, number.floatValue(), stringBuffer.toString())) {
                        return -1;
                    }
                } else if (string.equals("dataSymbolBodyColor")) {
                    Color color = null;
                    if (n == 2) {
                        color = SGUtilityText.getColor(string3);
                    } else if (n == 4) {
                        String string6 = (String)arrayList.get(2);
                        String string7 = (String)arrayList.get(3);
                        color = SGUtilityText.getColor(string3, string6, string7);
                    } else {
                        return -1;
                    }
                    if (color == null) {
                        return -1;
                    }
                    if (!sGIFigureElementGraphSXY.setSymbolInnerColorDirectly(n2, color)) {
                        return -1;
                    }
                } else if (string.equals("dataSymbolLineColor")) {
                    Color color = null;
                    if (n == 2) {
                        color = SGUtilityText.getColor(string3);
                    } else if (n == 4) {
                        String string8 = (String)arrayList.get(2);
                        String string9 = (String)arrayList.get(3);
                        color = SGUtilityText.getColor(string3, string8, string9);
                    } else {
                        return -1;
                    }
                    if (color == null) {
                        return -1;
                    }
                    if (!sGIFigureElementGraphSXY.setSymbolLineColorDirectly(n2, color)) {
                        return -1;
                    }
                } else if (string.equals("dataBarVisible")) {
                    Boolean bl = SGUtilityText.getBoolean(SGUtilityText.getBooleanString(string3));
                    if (bl == null) {
                        return -1;
                    }
                    if (!sGIFigureElementGraphSXY.setBarVisibleDirectly(n2, bl)) {
                        return -1;
                    }
                } else if (string.equals("dataBarBaseline")) {
                    Double d = SGUtilityText.getDouble(string3);
                    if (d == null) {
                        return -1;
                    }
                    if (!sGIFigureElementGraphSXY.setBarBaselineDirectly(n2, ((Number)d).floatValue())) {
                        return -1;
                    }
                } else if (string.equals("dataBarBodyWidth")) {
                    Double d = SGUtilityText.getDouble(string3);
                    if (d == null) {
                        return -1;
                    }
                    if (!sGIFigureElementGraphSXY.setBarWidthDirectly(n2, ((Number)d).floatValue())) {
                        return -1;
                    }
                } else if (string.equals("dataBarEdgeLineWidth")) {
                    StringBuffer stringBuffer = new StringBuffer();
                    Number number = SGUtilityText.getNumber(string3, stringBuffer);
                    if (number == null) {
                        return -1;
                    }
                    if (!sGIFigureElementGraphSXY.setBarEdgeLineWidthDirectly(n2, number.floatValue(), stringBuffer.toString())) {
                        return -1;
                    }
                } else if (string.equals("dataBarBodyColor")) {
                    Color color = null;
                    if (n == 2) {
                        color = SGUtilityText.getColor(string3);
                    } else if (n == 4) {
                        String string10 = (String)arrayList.get(2);
                        String string11 = (String)arrayList.get(3);
                        color = SGUtilityText.getColor(string3, string10, string11);
                    } else {
                        return -1;
                    }
                    if (color == null) {
                        return -1;
                    }
                    if (!sGIFigureElementGraphSXY.setBarInnerColorDirectly(n2, color)) {
                        return -1;
                    }
                } else if (string.equals("dataBarLineColor")) {
                    Color color = null;
                    if (n == 2) {
                        color = SGUtilityText.getColor(string3);
                    } else if (n == 4) {
                        String string12 = (String)arrayList.get(2);
                        String string13 = (String)arrayList.get(3);
                        color = SGUtilityText.getColor(string3, string12, string13);
                    } else {
                        return -1;
                    }
                    if (color == null) {
                        return -1;
                    }
                    if (!sGIFigureElementGraphSXY.setBarLineColorDirectly(n2, color)) {
                        return -1;
                    }
                } else if (string.equals("dataErrorBarVisible")) {
                    Boolean bl = SGUtilityText.getBoolean(SGUtilityText.getBooleanString(string3));
                    if (bl == null) {
                        return -1;
                    }
                    if (!sGIFigureElementGraphSXY.setErrorBarVisibleDirectly(n2, bl)) {
                        return -1;
                    }
                } else if (string.equals("dataErrorBarSymbolType")) {
                    Integer n7 = SGDrawingElementErrorBar.getHeadTypeFromName(string3);
                    if (n7 == null) {
                        return -1;
                    }
                    if (!sGIFigureElementGraphSXY.setErrorBarSymbolTypeDirectly(n2, n7)) {
                        return -1;
                    }
                } else if (string.equals("dataErrorBarSymbolSize")) {
                    StringBuffer stringBuffer = new StringBuffer();
                    Number number = SGUtilityText.getNumber(string3, stringBuffer);
                    if (number == null) {
                        return -1;
                    }
                    if (!sGIFigureElementGraphSXY.setErrorBarSymbolSizeDirectly(n2, number.floatValue(), stringBuffer.toString())) {
                        return -1;
                    }
                } else if (string.equals("dataErrorBarLineWidth")) {
                    StringBuffer stringBuffer = new StringBuffer();
                    Number number = SGUtilityText.getNumber(string3, stringBuffer);
                    if (number == null) {
                        return -1;
                    }
                    if (!sGIFigureElementGraphSXY.setErrorBarLineWidthDirectly(n2, number.floatValue(), stringBuffer.toString())) {
                        return -1;
                    }
                } else if (string.equals("dataErrorBarColor")) {
                    Color color = null;
                    if (n == 2) {
                        color = SGUtilityText.getColor(string3);
                    } else if (n == 4) {
                        String string14 = (String)arrayList.get(2);
                        String string15 = (String)arrayList.get(3);
                        color = SGUtilityText.getColor(string3, string14, string15);
                    } else {
                        return -1;
                    }
                    if (color == null) {
                        return -1;
                    }
                    if (!sGIFigureElementGraphSXY.setErrorBarColorDirectly(n2, color)) {
                        return -1;
                    }
                } else if (string.equals("dataErrorBarStyle")) {
                    int n8 = this.getErrorBarStyle(string3);
                    if (n8 == -1) {
                        return -1;
                    }
                    if (!sGIFigureElementGraphSXY.setErrorBarStyleDirectly(n2, n8)) {
                        return -1;
                    }
                } else if (string.equals("dataTickLabelVisible")) {
                    Boolean bl = SGUtilityText.getBoolean(SGUtilityText.getBooleanString(string3));
                    if (bl == null) {
                        return -1;
                    }
                    if (!sGIFigureElementGraphSXY.setTickLabelVisibleDirectly(n2, bl)) {
                        return -1;
                    }
                } else if (string.equals("dataTickLabelFontName")) {
                    if (!sGIFigureElementGraphSXY.setTickLabelFontNameDirectly(n2, string3)) {
                        return -1;
                    }
                } else if (string.equals("dataTickLabelFontStyle")) {
                    int n9 = this.getFontStyle(string3);
                    if (n9 == -1) {
                        return -1;
                    }
                    if (!sGIFigureElementGraphSXY.setTickLabelFontStyleDirectly(n2, n9)) {
                        return -1;
                    }
                } else if (string.equals("dataTickLabelFontSize")) {
                    StringBuffer stringBuffer = new StringBuffer();
                    Number number = SGUtilityText.getNumber(string3, stringBuffer);
                    if (number == null) {
                        return -1;
                    }
                    if (!sGIFigureElementGraphSXY.setTickLabelFontSizeDirectly(n2, number.floatValue(), stringBuffer.toString())) {
                        return -1;
                    }
                } else if (string.equals("dataTickLabelFontColor")) {
                    Color color = null;
                    if (n == 2) {
                        color = SGUtilityText.getColor(string3);
                    } else if (n == 4) {
                        String string16 = (String)arrayList.get(2);
                        String string17 = (String)arrayList.get(3);
                        color = SGUtilityText.getColor(string3, string16, string17);
                    } else {
                        return -1;
                    }
                    if (color == null) {
                        return -1;
                    }
                    if (!sGIFigureElementGraphSXY.setTickLabelFontColorDirectly(n2, color)) {
                        return -1;
                    }
                } else if (string.equals("dataTickLabelHorizontal")) {
                    Boolean bl = SGUtilityText.getBoolean(SGUtilityText.getBooleanString(string3));
                    if (bl == null) {
                        return -1;
                    }
                    if (!sGIFigureElementGraphSXY.setTickLabelAngleDirectly(n2, bl)) {
                        return -1;
                    }
                }
            } else if (sGIFigureElementGraph instanceof SGIFigureElementGraphVXY) {
                SGIFigureElementGraphVXY sGIFigureElementGraphVXY = (SGIFigureElementGraphVXY)sGIFigureElementGraph;
                if (string.equals("dataArrowMagnitudePerCM")) {
                    Float f = SGUtilityText.getFloat(string3);
                    if (f == null) {
                        return -1;
                    }
                    if (!sGIFigureElementGraphVXY.setMagnitudePerCMDirectly(n2, ((Number)f).floatValue())) {
                        return -1;
                    }
                } else if (string.equals("dataArrowDirectionInvariant")) {
                    Boolean bl = SGUtilityText.getBoolean(string3);
                    if (bl == null) {
                        return -1;
                    }
                    if (!sGIFigureElementGraphVXY.setDirectionInvariantDirectly(n2, bl)) {
                        return -1;
                    }
                } else if (string.equals("dataArrowLineWidth")) {
                    StringBuffer stringBuffer = new StringBuffer();
                    Number number = SGUtilityText.getNumber(string3, stringBuffer);
                    if (number == null) {
                        return -1;
                    }
                    if (!sGIFigureElementGraphVXY.setLineWidthDirectly(n2, number.floatValue(), stringBuffer.toString())) {
                        return -1;
                    }
                } else if (string.equals("dataArrowLineType")) {
                    int n10 = this.getLineType(string3);
                    if (n10 == -1) {
                        return -1;
                    }
                    if (!sGIFigureElementGraphVXY.setLineTypeDirectly(n2, n10)) {
                        return -1;
                    }
                } else if (string.equals("dataArrowHeadSize")) {
                    StringBuffer stringBuffer = new StringBuffer();
                    Number number = SGUtilityText.getNumber(string3, stringBuffer);
                    if (number == null) {
                        return -1;
                    }
                    if (!sGIFigureElementGraphVXY.setHeadSizeDirectly(n2, number.floatValue(), stringBuffer.toString())) {
                        return -1;
                    }
                } else if (string.equals("dataArrowColor")) {
                    Color color = null;
                    if (n == 2) {
                        color = SGUtilityText.getColor(string3);
                    } else if (n == 4) {
                        String string18 = (String)arrayList.get(2);
                        String string19 = (String)arrayList.get(3);
                        color = SGUtilityText.getColor(string3, string18, string19);
                    } else {
                        return -1;
                    }
                    if (color == null) {
                        return -1;
                    }
                    if (!sGIFigureElementGraphVXY.setColorDirectly(n2, color)) {
                        return -1;
                    }
                } else if (string.equals("dataArrowStartType")) {
                    Integer n11 = SGDrawingElementArrow.getSymbolTypeFromName(string3);
                    if (n11 == null) {
                        return -1;
                    }
                    if (!sGIFigureElementGraphVXY.setStartTypeDirectly(n2, n11)) {
                        return -1;
                    }
                } else if (string.equals("dataArrowEndType")) {
                    Integer n12 = SGDrawingElementArrow.getSymbolTypeFromName(string3);
                    if (n12 == null) {
                        return -1;
                    }
                    if (!sGIFigureElementGraphVXY.setEndTypeDirectly(n2, n12)) {
                        return -1;
                    }
                } else if (string.equals("dataArrowOpenAngle")) {
                    Double d = SGUtilityText.getDouble(string3);
                    if (d == null) {
                        return -1;
                    }
                    float f = ((Number)d).floatValue() * ((float)Math.PI / 180);
                    if (!sGIFigureElementGraphVXY.setOpenAngleDirectly(n2, f)) {
                        return -1;
                    }
                } else if (string.equals("dataArrowCloseAngle")) {
                    Double d = SGUtilityText.getDouble(string3);
                    if (d == null) {
                        return -1;
                    }
                    float f = ((Number)d).floatValue() * ((float)Math.PI / 180);
                    if (!sGIFigureElementGraphVXY.setCloseAngleDirectly(n2, f)) {
                        return -1;
                    }
                }
            }
            return 0;
        }

        private int setFigureElementProperties(String string, SGFigure sGFigure, ArrayList arrayList) {
            int n;
            if (sGFigure == null) {
                return 1;
            }
            SGIFigureElementGraph sGIFigureElementGraph = sGFigure.getGraphElement();
            if (sGIFigureElementGraph != null && (n = this.setDataProperties(string, sGIFigureElementGraph, arrayList)) != 1) {
                return n;
            }
            SGIFigureElementAxis sGIFigureElementAxis = sGFigure.getAxisElement();
            if (sGIFigureElementAxis != null && (n = this.setAxisProperties(string, sGIFigureElementAxis, arrayList)) != 1) {
                return n;
            }
            SGIFigureElementLegend sGIFigureElementLegend = sGFigure.getLegendElement();
            if (sGIFigureElementLegend != null && (n = this.setLegendProperties(string, sGIFigureElementLegend, arrayList)) != 1) {
                return n;
            }
            if (sGFigure instanceof SGXYFigure) {
                SGXYFigure sGXYFigure = (SGXYFigure)sGFigure;
                SGIFigureElementString sGIFigureElementString = (SGIFigureElementString)sGXYFigure.getSymbolElement(0);
                if (sGIFigureElementString != null && (n = this.setLabelProperties(string, sGIFigureElementString, arrayList)) != 1) {
                    return n;
                }
                SGIFigureElementSignificantDifference sGIFigureElementSignificantDifference = (SGIFigureElementSignificantDifference)sGXYFigure.getSymbolElement(2);
                if (sGIFigureElementSignificantDifference != null && (n = this.setSigDiffProperties(string, sGIFigureElementSignificantDifference, arrayList)) != 1) {
                    return n;
                }
                SGIFigureElementAxisBreak sGIFigureElementAxisBreak = (SGIFigureElementAxisBreak)sGXYFigure.getSymbolElement(1);
                if (sGIFigureElementAxisBreak != null && (n = this.setAxisBreakProperties(string, sGIFigureElementAxisBreak, arrayList)) != 1) {
                    return n;
                }
                SGIFigureElementTimingLine sGIFigureElementTimingLine = (SGIFigureElementTimingLine)sGXYFigure.getSymbolElement(3);
                if (sGIFigureElementTimingLine != null && (n = this.setTimingLineProperties(string, sGIFigureElementTimingLine, arrayList)) != 1) {
                    return n;
                }
                SGIFigureElementShape sGIFigureElementShape = (SGIFigureElementShape)sGXYFigure.getSymbolElement(4);
                if (sGIFigureElementShape != null && (n = this.setShapeProperties(string, sGIFigureElementShape, arrayList)) != 1) {
                    return n;
                }
            }
            return 1;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private int setAxisProperties(String string, SGIFigureElementAxis sGIFigureElementAxis, ArrayList arrayList) {
            String[] stringArray = new String[]{"axisFont", "axisFontName", "axisFontStyle", "axisFontSize", "axisFontColor", "axisFrame", "axisFrameVisible", "axisFrameLineWidth", "axisFrameColor", "axisLineWidth", "tickMarkWidth", "tickMarkLength", "axisLineColor", "axisVisible", "axisTitleVisible", "axisTitleLabel", "axisScaleMin", "axisScaleMax", "axisScaleType", "axisTickMarkVisible", "axisTickMarkAuto", "axisTickMarkStep", "axisTickMarkBase", "axisTickMarkInner", "axisFormatVisible", "axisFormatInteger", "axisFormatExponentVisible", "axisFormatExponentValue"};
            if (!this.contains(stringArray, string)) {
                return 1;
            }
            int n = arrayList.size();
            if (string.equals("axisFontName")) {
                String string2 = (String)arrayList.get(0);
                sGIFigureElementAxis.setFontNameDirectly(string2);
                return 0;
            } else {
                if (string.equals("axisFontStyle")) {
                    if (arrayList.size() < 1) {
                        return -1;
                    }
                    String string3 = (String)arrayList.get(0);
                    int n2 = this.getFontStyle(string3);
                    if (n2 == -1) {
                        return -1;
                    }
                    if (sGIFigureElementAxis.setFontStyleDirectly(n2)) return 0;
                    return -1;
                }
                if (string.equals("axisFontSize")) {
                    StringBuffer stringBuffer;
                    if (arrayList.size() < 1) {
                        return -1;
                    }
                    String string4 = (String)arrayList.get(0);
                    Number number = SGUtilityText.getNumber(string4, stringBuffer = new StringBuffer());
                    if (number == null) {
                        return -1;
                    }
                    if (sGIFigureElementAxis.setFontSizeDirectly(number.floatValue(), stringBuffer.toString())) return 0;
                    return -1;
                }
                if (string.equals("axisFontColor")) {
                    String string5;
                    String string6;
                    if (arrayList.size() == 1) {
                        String string7 = (String)arrayList.get(0);
                        Color color = SGUtilityText.getColor(string7);
                        if (color == null) {
                            return -1;
                        }
                        if (sGIFigureElementAxis.setFontColorDirectly(color)) return 0;
                        return -1;
                    }
                    if (arrayList.size() != 3) return -1;
                    String string8 = (String)arrayList.get(0);
                    Color color = SGUtilityText.getColor(string8, string6 = (String)arrayList.get(1), string5 = (String)arrayList.get(2));
                    if (color == null) {
                        return -1;
                    }
                    if (sGIFigureElementAxis.setFontColorDirectly(color)) return 0;
                    return -1;
                }
                if (string.equals("axisFrameVisible")) {
                    if (arrayList.size() < 1) {
                        return -1;
                    }
                    String string9 = (String)arrayList.get(0);
                    Boolean bl = SGUtilityText.getBoolean(SGUtilityText.getBooleanString(string9));
                    if (bl == null) {
                        return -1;
                    }
                    if (sGIFigureElementAxis.setFrameVisibleDirectly(bl)) return 0;
                    return -1;
                }
                if (string.equals("axisFrameLineWidth")) {
                    StringBuffer stringBuffer;
                    if (arrayList.size() < 1) {
                        return -1;
                    }
                    String string10 = (String)arrayList.get(0);
                    Number number = SGUtilityText.getNumber(string10, stringBuffer = new StringBuffer());
                    if (number == null) {
                        return -1;
                    }
                    if (sGIFigureElementAxis.setFrameLineWidthDirectly(number.floatValue(), stringBuffer.toString())) return 0;
                    return -1;
                }
                if (string.equals("axisFrameColor")) {
                    String string11;
                    String string12;
                    if (arrayList.size() == 1) {
                        String string13 = (String)arrayList.get(0);
                        Color color = SGUtilityText.getColor(string13);
                        if (color == null) {
                            return -1;
                        }
                        if (sGIFigureElementAxis.setFrameLineColorDirectly(color)) return 0;
                        return -1;
                    }
                    if (arrayList.size() != 3) return -1;
                    String string14 = (String)arrayList.get(0);
                    Color color = SGUtilityText.getColor(string14, string12 = (String)arrayList.get(1), string11 = (String)arrayList.get(2));
                    if (color == null) {
                        return -1;
                    }
                    if (sGIFigureElementAxis.setFrameLineColorDirectly(color)) return 0;
                    return -1;
                }
                if (string.equals("axisLineWidth")) {
                    StringBuffer stringBuffer;
                    if (arrayList.size() < 1) {
                        return -1;
                    }
                    String string15 = (String)arrayList.get(0);
                    Number number = SGUtilityText.getNumber(string15, stringBuffer = new StringBuffer());
                    if (number == null) {
                        return -1;
                    }
                    if (sGIFigureElementAxis.setAxisLineWidthDirectly(number.floatValue(), stringBuffer.toString())) return 0;
                    return -1;
                }
                if (string.equals("tickMarkWidth")) {
                    StringBuffer stringBuffer;
                    if (arrayList.size() < 1) {
                        return -1;
                    }
                    String string16 = (String)arrayList.get(0);
                    Number number = SGUtilityText.getNumber(string16, stringBuffer = new StringBuffer());
                    if (number == null) {
                        return -1;
                    }
                    if (sGIFigureElementAxis.setTickMarkWidthDirectly(number.floatValue(), stringBuffer.toString())) return 0;
                    return -1;
                }
                if (string.equals("tickMarkLength")) {
                    StringBuffer stringBuffer;
                    if (arrayList.size() < 1) {
                        return -1;
                    }
                    String string17 = (String)arrayList.get(0);
                    Number number = SGUtilityText.getNumber(string17, stringBuffer = new StringBuffer());
                    if (number == null) {
                        return -1;
                    }
                    if (sGIFigureElementAxis.setTickMarkLengthDirectly(number.floatValue(), stringBuffer.toString())) return 0;
                    return -1;
                }
                if (string.equals("axisLineColor")) {
                    String string18;
                    String string19;
                    if (arrayList.size() == 1) {
                        String string20 = (String)arrayList.get(0);
                        Color color = SGUtilityText.getColor(string20);
                        if (color == null) {
                            return -1;
                        }
                        if (sGIFigureElementAxis.setLineColorDirectly(color)) return 0;
                        return -1;
                    }
                    if (arrayList.size() != 3) return -1;
                    String string21 = (String)arrayList.get(0);
                    Color color = SGUtilityText.getColor(string21, string19 = (String)arrayList.get(1), string18 = (String)arrayList.get(2));
                    if (color == null) {
                        return -1;
                    }
                    if (sGIFigureElementAxis.setLineColorDirectly(color)) return 0;
                    return -1;
                }
                if (string.equals("axisVisible")) {
                    if (arrayList.size() < 2) {
                        return -1;
                    }
                    String string22 = (String)arrayList.get(0);
                    String string23 = (String)arrayList.get(1);
                    Boolean bl = SGUtilityText.getBoolean(SGUtilityText.getBooleanString(string23));
                    if (bl == null) {
                        return -1;
                    }
                    if (sGIFigureElementAxis.setAxisVisibleDirectly(string22, bl)) return 0;
                    return -1;
                }
                if (string.equals("axisTitleVisible")) {
                    if (arrayList.size() < 2) {
                        return -1;
                    }
                    String string24 = (String)arrayList.get(0);
                    String string25 = (String)arrayList.get(1);
                    Boolean bl = SGUtilityText.getBoolean(SGUtilityText.getBooleanString(string25));
                    if (bl == null) {
                        return -1;
                    }
                    if (sGIFigureElementAxis.setTitleVisibleDirectly(string24, bl)) return 0;
                    return -1;
                }
                if (string.equals("axisTitleLabel")) {
                    String string26;
                    if (arrayList.size() < 2) {
                        return -1;
                    }
                    String string27 = (String)arrayList.get(0);
                    if (sGIFigureElementAxis.setTitleDirectly(string27, string26 = (String)arrayList.get(1))) return 0;
                    return -1;
                }
                if (string.equals("axisScaleMin")) {
                    if (arrayList.size() < 2) {
                        return -1;
                    }
                    String string28 = (String)arrayList.get(0);
                    String string29 = (String)arrayList.get(1);
                    Double d = SGUtilityText.getDouble(string29);
                    if (d == null) {
                        return -1;
                    }
                    if (sGIFigureElementAxis.setMinValueDirectly(string28, d)) return 0;
                    return -1;
                }
                if (string.equals("axisScaleMax")) {
                    if (arrayList.size() < 2) {
                        return -1;
                    }
                    String string30 = (String)arrayList.get(0);
                    String string31 = (String)arrayList.get(1);
                    Double d = SGUtilityText.getDouble(string31);
                    if (d == null) {
                        return -1;
                    }
                    if (sGIFigureElementAxis.setMaxValueDirectly(string30, d)) return 0;
                    return -1;
                }
                if (string.equals("axisScaleType")) {
                    if (arrayList.size() < 2) {
                        return -1;
                    }
                    String string32 = (String)arrayList.get(0);
                    String string33 = (String)arrayList.get(1);
                    int n3 = this.getScaleType(string33);
                    if (n3 == -1) {
                        return -1;
                    }
                    if (sGIFigureElementAxis.setScaleTypeDirectly(string32, n3)) return 0;
                    return -1;
                }
                if (string.equals("axisTickMarkVisible")) {
                    if (arrayList.size() < 2) {
                        return -1;
                    }
                    String string34 = (String)arrayList.get(0);
                    String string35 = (String)arrayList.get(1);
                    Boolean bl = SGUtilityText.getBoolean(SGUtilityText.getBooleanString(string35));
                    if (bl == null) {
                        return -1;
                    }
                    if (sGIFigureElementAxis.setTickMarkVisibleDirectly(string34, bl)) return 0;
                    return -1;
                }
                if (string.equals("axisTickMarkAuto")) {
                    if (arrayList.size() < 2) {
                        return -1;
                    }
                    String string36 = (String)arrayList.get(0);
                    String string37 = (String)arrayList.get(1);
                    Boolean bl = SGUtilityText.getBoolean(SGUtilityText.getBooleanString(string37));
                    if (bl == null) {
                        return -1;
                    }
                    if (sGIFigureElementAxis.setTickMarkAutoDirectly(string36, bl)) return 0;
                    return -1;
                }
                if (string.equals("axisTickMarkStep")) {
                    if (arrayList.size() < 2) {
                        return -1;
                    }
                    String string38 = (String)arrayList.get(0);
                    String string39 = (String)arrayList.get(1);
                    Double d = SGUtilityText.getDouble(string39);
                    if (d == null) {
                        return -1;
                    }
                    if (sGIFigureElementAxis.setTickMarkStepDirectly(string38, d)) return 0;
                    return -1;
                }
                if (string.equals("axisTickMarkBase")) {
                    if (arrayList.size() < 2) {
                        return -1;
                    }
                    String string40 = (String)arrayList.get(0);
                    String string41 = (String)arrayList.get(1);
                    Double d = SGUtilityText.getDouble(string41);
                    if (d == null) {
                        return -1;
                    }
                    if (sGIFigureElementAxis.setTickMarkBaseDirectly(string40, d)) return 0;
                    return -1;
                }
                if (string.equals("axisTickMarkInner")) {
                    if (arrayList.size() < 2) {
                        return -1;
                    }
                    String string42 = (String)arrayList.get(0);
                    String string43 = (String)arrayList.get(1);
                    Boolean bl = SGUtilityText.getBoolean(SGUtilityText.getBooleanString(string43));
                    if (bl == null) {
                        return -1;
                    }
                    if (sGIFigureElementAxis.setTickMarkInnerDirectly(string42, bl)) return 0;
                    return -1;
                }
                if (string.equals("axisFormatVisible")) {
                    if (arrayList.size() < 2) {
                        return -1;
                    }
                    String string44 = (String)arrayList.get(0);
                    String string45 = (String)arrayList.get(1);
                    Boolean bl = SGUtilityText.getBoolean(SGUtilityText.getBooleanString(string45));
                    if (bl == null) {
                        return -1;
                    }
                    if (sGIFigureElementAxis.setFormatVisibleDirectly(string44, bl)) return 0;
                    return -1;
                }
                if (string.equals("axisFormatInteger")) {
                    if (arrayList.size() < 2) {
                        return -1;
                    }
                    String string46 = (String)arrayList.get(0);
                    String string47 = (String)arrayList.get(1);
                    Boolean bl = SGUtilityText.getBoolean(SGUtilityText.getBooleanString(string47));
                    if (bl == null) {
                        return -1;
                    }
                    if (sGIFigureElementAxis.setFormatIntegerDirectly(string46, bl)) return 0;
                    return -1;
                }
                if (string.equals("axisFormatExponentVisible")) {
                    if (arrayList.size() < 2) {
                        return -1;
                    }
                    String string48 = (String)arrayList.get(0);
                    String string49 = (String)arrayList.get(1);
                    Boolean bl = SGUtilityText.getBoolean(SGUtilityText.getBooleanString(string49));
                    if (bl == null) {
                        return -1;
                    }
                    if (sGIFigureElementAxis.setFormatExponentVisibleDirectly(string48, bl)) return 0;
                    return -1;
                }
                if (!string.equals("axisFormatExponentValue")) return 0;
                if (arrayList.size() < 2) {
                    return -1;
                }
                String string50 = (String)arrayList.get(0);
                String string51 = (String)arrayList.get(1);
                Integer n4 = SGUtilityText.getInteger(string51);
                if (n4 == null) {
                    return -1;
                }
                if (sGIFigureElementAxis.setFormatExponentValueDirectly(string50, n4)) return 0;
                return -1;
            }
        }

        private int setLabelProperties(String string, SGIFigureElementString sGIFigureElementString, ArrayList arrayList) {
            String[] stringArray = new String[]{"labelAxisX", "labelAxisY", "labelText", "labelLocationX", "labelLocationY", "labelFontName", "labelFontStyle", "labelFontSize", "labelFontColor", "labelAngle", "deleteLabel", "moveToFrontLabel", "moveToBackLabel"};
            if (!this.contains(stringArray, string)) {
                return 1;
            }
            int n = arrayList.size();
            if (arrayList.size() < 1) {
                return -1;
            }
            String string2 = (String)arrayList.get(0);
            Integer n2 = SGUtilityText.getInteger(string2);
            if (n2 == null) {
                return -1;
            }
            if (n == 1) {
                if (string.equals("deleteLabel") ? !sGIFigureElementString.hideChildObject(n2) : (string.equals("moveToFrontLabel") ? !sGIFigureElementString.moveChildObject(n2, true) : string.equals("moveToBackLabel") && !sGIFigureElementString.moveChildObject(n2, false))) {
                    return -1;
                }
                return 0;
            }
            String string3 = (String)arrayList.get(1);
            if (string.equals("labelAxisX")) {
                int n3 = this.getAxisLocation(string3);
                if (n3 == -1) {
                    return -1;
                }
                if (!sGIFigureElementString.setAxisXDirectly(n2, n3)) {
                    return -1;
                }
            } else if (string.equals("labelAxisY")) {
                int n4 = this.getAxisLocation(string3);
                if (n4 == -1) {
                    return -1;
                }
                if (!sGIFigureElementString.setAxisYDirectly(n2, n4)) {
                    return -1;
                }
            } else if (string.equals("labelText")) {
                if (!sGIFigureElementString.setTextDirectly(n2, string3)) {
                    return -1;
                }
            } else if (string.equals("labelLocationX")) {
                Double d = SGUtilityText.getDouble(string3);
                if (d == null) {
                    return -1;
                }
                if (!sGIFigureElementString.setLocationXDirectly(n2, ((Number)d).floatValue())) {
                    return -1;
                }
            } else if (string.equals("labelLocationY")) {
                Double d = SGUtilityText.getDouble(string3);
                if (d == null) {
                    return -1;
                }
                if (!sGIFigureElementString.setLocationYDirectly(n2, ((Number)d).floatValue())) {
                    return -1;
                }
            } else if (string.equals("labelFontName")) {
                if (!sGIFigureElementString.setFontNameDirectly(n2, string3)) {
                    return -1;
                }
            } else if (string.equals("labelFontStyle")) {
                int n5 = this.getFontStyle(string3);
                if (n5 == -1) {
                    return -1;
                }
                if (!sGIFigureElementString.setFontStyleDirectly(n2, n5)) {
                    return -1;
                }
            } else if (string.equals("labelFontSize")) {
                StringBuffer stringBuffer = new StringBuffer();
                Number number = SGUtilityText.getNumber(string3, stringBuffer);
                if (number == null) {
                    return -1;
                }
                if (!sGIFigureElementString.setFontSizeDirectly(n2, number.floatValue(), stringBuffer.toString())) {
                    return -1;
                }
            } else if (string.equals("labelFontColor")) {
                Color color = null;
                if (n == 2) {
                    color = SGUtilityText.getColor(string3);
                } else if (n == 4) {
                    String string4 = (String)arrayList.get(2);
                    String string5 = (String)arrayList.get(3);
                    color = SGUtilityText.getColor(string3, string4, string5);
                } else {
                    return -1;
                }
                if (color == null) {
                    return -1;
                }
                if (!sGIFigureElementString.setFontColorDirectly(n2, color)) {
                    return -1;
                }
            } else if (string.equals("labelAngle")) {
                Double d = SGUtilityText.getDouble(string3);
                if (d == null) {
                    return -1;
                }
                float f = ((Number)d).floatValue() * ((float)Math.PI / 180);
                if (!sGIFigureElementString.setAngleDirectly(n2, f)) {
                    return -1;
                }
            }
            return 0;
        }

        private int setSigDiffProperties(String string, SGIFigureElementSignificantDifference sGIFigureElementSignificantDifference, ArrayList arrayList) {
            String[] stringArray = new String[]{"sigdiffAxisX", "sigdiffAxisY", "sigdiffHorizontalY", "sigdiffLeftX", "sigdiffLeftY", "sigdiffRightX", "sigdiffRightY", "sigdiffLineVisible", "sigdiffSpace", "sigdiffLineWidth", "sigdiffText", "sigdiffFontName", "sigdiffFontStyle", "sigdiffFontSize", "sigdiffColor", "deleteSigdiff", "moveToFrontSigdiff", "moveToBackSigdiff"};
            if (!this.contains(stringArray, string)) {
                return 1;
            }
            int n = arrayList.size();
            if (arrayList.size() < 1) {
                return -1;
            }
            String string2 = (String)arrayList.get(0);
            Integer n2 = SGUtilityText.getInteger(string2);
            if (n2 == null) {
                return -1;
            }
            if (n == 1) {
                if (string.equals("deleteSigdiff") ? !sGIFigureElementSignificantDifference.hideChildObject(n2) : (string.equals("moveToFrontSigdiff") ? !sGIFigureElementSignificantDifference.moveChildObject(n2, true) : string.equals("moveToBackSigdiff") && !sGIFigureElementSignificantDifference.moveChildObject(n2, false))) {
                    return -1;
                }
                return 0;
            }
            String string3 = (String)arrayList.get(1);
            if (string.equals("sigdiffAxisX")) {
                int n3 = this.getAxisLocation(string3);
                if (n3 == -1) {
                    return -1;
                }
                if (!sGIFigureElementSignificantDifference.setAxisXDirectly(n2, n3)) {
                    return -1;
                }
            } else if (string.equals("sigdiffAxisY")) {
                int n4 = this.getAxisLocation(string3);
                if (n4 == -1) {
                    return -1;
                }
                if (!sGIFigureElementSignificantDifference.setAxisYDirectly(n2, n4)) {
                    return -1;
                }
            } else if (string.equals("labelText")) {
                if (!sGIFigureElementSignificantDifference.setTextDirectly(n2, string3)) {
                    return -1;
                }
            } else if (string.equals("sigdiffHorizontalY")) {
                Double d = SGUtilityText.getDouble(string3);
                if (d == null) {
                    return -1;
                }
                if (!sGIFigureElementSignificantDifference.setLocationHorizontalYDirectly(n2, d)) {
                    return -1;
                }
            } else if (string.equals("sigdiffLeftX")) {
                Double d = SGUtilityText.getDouble(string3);
                if (d == null) {
                    return -1;
                }
                if (!sGIFigureElementSignificantDifference.setLocationLeftXDirectly(n2, d)) {
                    return -1;
                }
            } else if (string.equals("sigdiffLeftY")) {
                Double d = SGUtilityText.getDouble(string3);
                if (d == null) {
                    return -1;
                }
                if (!sGIFigureElementSignificantDifference.setLocationLeftYDirectly(n2, d)) {
                    return -1;
                }
            } else if (string.equals("sigdiffRightX")) {
                Double d = SGUtilityText.getDouble(string3);
                if (d == null) {
                    return -1;
                }
                if (!sGIFigureElementSignificantDifference.setLocationRightXDirectly(n2, d)) {
                    return -1;
                }
            } else if (string.equals("sigdiffRightY")) {
                Double d = SGUtilityText.getDouble(string3);
                if (d == null) {
                    return -1;
                }
                if (!sGIFigureElementSignificantDifference.setLocationRightYDirectly(n2, d)) {
                    return -1;
                }
            } else if (string.equals("sigdiffFontName")) {
                if (!sGIFigureElementSignificantDifference.setFontNameDirectly(n2, string3)) {
                    return -1;
                }
            } else if (string.equals("sigdiffFontStyle")) {
                int n5 = this.getFontStyle(string3);
                if (n5 == -1) {
                    return -1;
                }
                if (!sGIFigureElementSignificantDifference.setFontStyleDirectly(n2, n5)) {
                    return -1;
                }
            } else if (string.equals("sigdiffFontSize")) {
                StringBuffer stringBuffer = new StringBuffer();
                Number number = SGUtilityText.getNumber(string3, stringBuffer);
                if (number == null) {
                    return -1;
                }
                if (!sGIFigureElementSignificantDifference.setFontSizeDirectly(n2, number.floatValue(), stringBuffer.toString())) {
                    return -1;
                }
            } else if (string.equals("sigdiffColor")) {
                Color color = null;
                if (n == 2) {
                    color = SGUtilityText.getColor(string3);
                } else if (n == 4) {
                    String string4 = (String)arrayList.get(2);
                    String string5 = (String)arrayList.get(3);
                    color = SGUtilityText.getColor(string3, string4, string5);
                } else {
                    return -1;
                }
                if (color == null) {
                    return -1;
                }
                if (!sGIFigureElementSignificantDifference.setFontColorDirectly(n2, color)) {
                    return -1;
                }
            } else if (string.equals("sigdiffLineVisible")) {
                Boolean bl = SGUtilityText.getBoolean(SGUtilityText.getBooleanString(string3));
                if (bl == null) {
                    return -1;
                }
                if (!sGIFigureElementSignificantDifference.setLineVisibleDirectly(n2, bl)) {
                    return -1;
                }
            } else if (string.equals("sigdiffSpace")) {
                StringBuffer stringBuffer = new StringBuffer();
                Number number = SGUtilityText.getNumber(string3, stringBuffer);
                if (number == null) {
                    return -1;
                }
                if (!sGIFigureElementSignificantDifference.setSpaceDirectly(n2, number.floatValue(), stringBuffer.toString())) {
                    return -1;
                }
            } else if (string.equals("sigdiffLineWidth")) {
                StringBuffer stringBuffer = new StringBuffer();
                Number number = SGUtilityText.getNumber(string3, stringBuffer);
                if (number == null) {
                    return -1;
                }
                if (!sGIFigureElementSignificantDifference.setLineWidthDirectly(n2, number.floatValue(), stringBuffer.toString())) {
                    return -1;
                }
            } else if (string.equals("sigdiffText") && !sGIFigureElementSignificantDifference.setTextDirectly(n2, string3)) {
                return -1;
            }
            return 0;
        }

        private int setAxisBreakProperties(String string, SGIFigureElementAxisBreak sGIFigureElementAxisBreak, ArrayList arrayList) {
            String[] stringArray = new String[]{"breakAxisX", "breakAxisY", "breakLocationX", "breakLocationY", "breakLength", "breakInterval", "breakDistortion", "breakAngle", "breakLineWidth", "breakAlignment", "breakLineColor", "breakInnerColor", "deleteBreak", "moveToFrontBreak", "moveToBackBreak"};
            if (!this.contains(stringArray, string)) {
                return 1;
            }
            int n = arrayList.size();
            if (arrayList.size() < 1) {
                return -1;
            }
            String string2 = (String)arrayList.get(0);
            Integer n2 = SGUtilityText.getInteger(string2);
            if (n2 == null) {
                return -1;
            }
            if (n == 1) {
                if (string.equals("deleteBreak") ? !sGIFigureElementAxisBreak.hideChildObject(n2) : (string.equals("moveToFrontBreak") ? !sGIFigureElementAxisBreak.moveChildObject(n2, true) : string.equals("moveToBackBreak") && !sGIFigureElementAxisBreak.moveChildObject(n2, false))) {
                    return -1;
                }
                return 0;
            }
            String string3 = (String)arrayList.get(1);
            if (string.equals("breakAxisX")) {
                int n3 = this.getAxisLocation(string3);
                if (n3 == -1) {
                    return -1;
                }
                if (!sGIFigureElementAxisBreak.setAxisXDirectly(n2, n3)) {
                    return -1;
                }
            } else if (string.equals("breakAxisY")) {
                int n4 = this.getAxisLocation(string3);
                if (n4 == -1) {
                    return -1;
                }
                if (!sGIFigureElementAxisBreak.setAxisYDirectly(n2, n4)) {
                    return -1;
                }
            } else if (string.equals("breakLocationX")) {
                Double d = SGUtilityText.getDouble(string3);
                if (d == null) {
                    return -1;
                }
                if (!sGIFigureElementAxisBreak.setLocationXDirectly(n2, d)) {
                    return -1;
                }
            } else if (string.equals("breakLocationY")) {
                Double d = SGUtilityText.getDouble(string3);
                if (d == null) {
                    return -1;
                }
                if (!sGIFigureElementAxisBreak.setLocationYDirectly(n2, d)) {
                    return -1;
                }
            } else if (string.equals("breakLength")) {
                StringBuffer stringBuffer = new StringBuffer();
                Number number = SGUtilityText.getNumber(string3, stringBuffer);
                if (number == null) {
                    return -1;
                }
                if (!sGIFigureElementAxisBreak.setLengthDirectly(n2, number.floatValue(), stringBuffer.toString())) {
                    return -1;
                }
            } else if (string.equals("breakInterval")) {
                StringBuffer stringBuffer = new StringBuffer();
                Number number = SGUtilityText.getNumber(string3, stringBuffer);
                if (number == null) {
                    return -1;
                }
                if (!sGIFigureElementAxisBreak.setIntervalDirectly(n2, number.floatValue(), stringBuffer.toString())) {
                    return -1;
                }
            } else if (string.equals("breakDistortion")) {
                Double d = SGUtilityText.getDouble(string3);
                if (d == null) {
                    return -1;
                }
                if (!sGIFigureElementAxisBreak.setDistortionDirectly(n2, ((Number)d).floatValue())) {
                    return -1;
                }
            } else if (string.equals("breakAngle")) {
                Double d = SGUtilityText.getDouble(string3);
                if (d == null) {
                    return -1;
                }
                float f = ((Number)d).floatValue() * ((float)Math.PI / 180);
                if (!sGIFigureElementAxisBreak.setAngleDirectly(n2, f)) {
                    return -1;
                }
            } else if (string.equals("breakLineWidth")) {
                StringBuffer stringBuffer = new StringBuffer();
                Number number = SGUtilityText.getNumber(string3, stringBuffer);
                if (number == null) {
                    return -1;
                }
                if (!sGIFigureElementAxisBreak.setLineWidthDirectly(n2, number.floatValue(), stringBuffer.toString())) {
                    return -1;
                }
            } else if (string.equals("breakAlignment")) {
                Boolean bl = SGUtilityText.getBoolean(SGUtilityText.getBooleanString(string3));
                if (bl == null) {
                    return -1;
                }
                if (!sGIFigureElementAxisBreak.setAlignmentDirectly(n2, bl)) {
                    return -1;
                }
            } else if (string.equals("breakLineColor")) {
                Color color = null;
                if (n == 2) {
                    color = SGUtilityText.getColor(string3);
                } else if (n == 4) {
                    String string4 = (String)arrayList.get(2);
                    String string5 = (String)arrayList.get(3);
                    color = SGUtilityText.getColor(string3, string4, string5);
                } else {
                    return -1;
                }
                if (color == null) {
                    return -1;
                }
                if (!sGIFigureElementAxisBreak.setLineColorDirectly(n2, color)) {
                    return -1;
                }
            } else if (string.equals("breakInnerColor")) {
                Color color = null;
                if (n == 2) {
                    color = SGUtilityText.getColor(string3);
                } else if (n == 4) {
                    String string6 = (String)arrayList.get(2);
                    String string7 = (String)arrayList.get(3);
                    color = SGUtilityText.getColor(string3, string6, string7);
                } else {
                    return -1;
                }
                if (color == null) {
                    return -1;
                }
                if (!sGIFigureElementAxisBreak.setInnerColorDirectly(n2, color)) {
                    return -1;
                }
            }
            return 0;
        }

        private int setTimingLineProperties(String string, SGIFigureElementTimingLine sGIFigureElementTimingLine, ArrayList arrayList) {
            String[] stringArray = new String[]{"timingLineAxis", "timingLineWidth", "timingLineType", "timingLineColor", "deleteTimingLine", "moveToFrontTimingLine", "moveToBackTimingLine"};
            if (!this.contains(stringArray, string)) {
                return 1;
            }
            int n = arrayList.size();
            if (arrayList.size() < 1) {
                return -1;
            }
            String string2 = (String)arrayList.get(0);
            Integer n2 = SGUtilityText.getInteger(string2);
            if (n2 == null) {
                return -1;
            }
            if (n == 1) {
                if (string.equals("deleteTimingLine") ? !sGIFigureElementTimingLine.hideChildObject(n2) : (string.equals("moveToFrontTimingLine") ? !sGIFigureElementTimingLine.moveChildObject(n2, true) : string.equals("moveToBackTimingLine") && !sGIFigureElementTimingLine.moveChildObject(n2, false))) {
                    return -1;
                }
                return 0;
            }
            String string3 = (String)arrayList.get(1);
            if (string.equals("timingLineAxis")) {
                int n3 = this.getAxisLocation(string3);
                if (n3 == -1) {
                    return -1;
                }
                if (!sGIFigureElementTimingLine.setAxisDirectly(n2, n3)) {
                    return -1;
                }
            } else if (string.equals("timingLineWidth")) {
                StringBuffer stringBuffer = new StringBuffer();
                Number number = SGUtilityText.getNumber(string3, stringBuffer);
                if (number == null) {
                    return -1;
                }
                if (!sGIFigureElementTimingLine.setLineWidthDirectly(n2, number.floatValue(), stringBuffer.toString())) {
                    return -1;
                }
            } else if (string.equals("timingLineType")) {
                int n4 = this.getLineType(string3);
                if (n4 == -1) {
                    return -1;
                }
                if (!sGIFigureElementTimingLine.setLineTypeDirectly(n2, n4)) {
                    return -1;
                }
            } else if (string.equals("timingLineColor")) {
                Color color = null;
                if (n == 2) {
                    color = SGUtilityText.getColor(string3);
                } else if (n == 4) {
                    String string4 = (String)arrayList.get(2);
                    String string5 = (String)arrayList.get(3);
                    color = SGUtilityText.getColor(string3, string4, string5);
                } else {
                    return -1;
                }
                if (color == null) {
                    return -1;
                }
                if (!sGIFigureElementTimingLine.setColorDirectly(n2, color)) {
                    return -1;
                }
            }
            return 0;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private int setLegendProperties(String string, SGIFigureElementLegend sGIFigureElementLegend, ArrayList arrayList) {
            StringBuffer stringBuffer;
            String[] stringArray = new String[]{"legendAxisX", "legendAxisY", "legendLocationX", "legendLocationY", "legendVisible", "legendFontName", "legendFontStyle", "legendFontSize", "legendFontColor", "legendFrameVisible", "legendFrameLineWidth", "legendFrameColor", "legendBackgroundTransparent", "legendBackgroundColor", "legendSymbolSpan"};
            if (!this.contains(stringArray, string)) {
                return 1;
            }
            int n = arrayList.size();
            if (string.equals("legendAxisX")) {
                if (arrayList.size() < 1) {
                    return -1;
                }
                String string2 = (String)arrayList.get(0);
                int n2 = this.getAxisLocation(string2);
                if (n2 == -1) {
                    return -1;
                }
                if (sGIFigureElementLegend.setAxisXDirectly(n2)) return 0;
                return -1;
            }
            if (string.equals("legendAxisY")) {
                if (arrayList.size() < 1) {
                    return -1;
                }
                String string3 = (String)arrayList.get(0);
                int n3 = this.getAxisLocation(string3);
                if (n3 == -1) {
                    return -1;
                }
                if (sGIFigureElementLegend.setAxisYDirectly(n3)) return 0;
                return -1;
            }
            if (string.equals("legendLocationX")) {
                if (arrayList.size() < 1) {
                    return -1;
                }
                String string4 = (String)arrayList.get(0);
                Double d = SGUtilityText.getDouble(string4);
                if (d == null) {
                    return -1;
                }
                if (sGIFigureElementLegend.setXValueDirectly(d)) return 0;
                return -1;
            }
            if (string.equals("legendLocationY")) {
                if (arrayList.size() < 1) {
                    return -1;
                }
                String string5 = (String)arrayList.get(0);
                Double d = SGUtilityText.getDouble(string5);
                if (d == null) {
                    return -1;
                }
                if (sGIFigureElementLegend.setYValueDirectly(d)) return 0;
                return -1;
            }
            if (string.equals("legendVisible")) {
                if (arrayList.size() < 1) {
                    return -1;
                }
                String string6 = (String)arrayList.get(0);
                Boolean bl = SGUtilityText.getBoolean(SGUtilityText.getBooleanString(string6));
                if (bl == null) {
                    return -1;
                }
                if (sGIFigureElementLegend.setLegendVisibleDirectly(bl)) return 0;
                return -1;
            }
            if (string.equals("legendFontName")) {
                if (arrayList.size() < 1) {
                    return -1;
                }
                String string7 = (String)arrayList.get(0);
                if (sGIFigureElementLegend.setFontNameDirectly(string7)) return 0;
                return -1;
            }
            if (string.equals("legendFontStyle")) {
                if (arrayList.size() < 1) {
                    return -1;
                }
                String string8 = (String)arrayList.get(0);
                int n4 = this.getFontStyle(string8);
                if (n4 == -1) {
                    return -1;
                }
                if (sGIFigureElementLegend.setFontStyleDirectly(n4)) return 0;
                return -1;
            }
            if (string.equals("legendFontSize")) {
                StringBuffer stringBuffer2;
                if (arrayList.size() < 1) {
                    return -1;
                }
                String string9 = (String)arrayList.get(0);
                Number number = SGUtilityText.getNumber(string9, stringBuffer2 = new StringBuffer());
                if (number == null) {
                    return -1;
                }
                if (sGIFigureElementLegend.setFontSizeDirectly(number.floatValue(), stringBuffer2.toString())) return 0;
                return -1;
            }
            if (string.equals("legendFontColor")) {
                String string10;
                String string11;
                if (arrayList.size() == 1) {
                    String string12 = (String)arrayList.get(0);
                    Color color = SGUtilityText.getColor(string12);
                    if (color == null) {
                        return -1;
                    }
                    if (sGIFigureElementLegend.setFontColorDirectly(color)) return 0;
                    return -1;
                }
                if (arrayList.size() != 3) return -1;
                String string13 = (String)arrayList.get(0);
                Color color = SGUtilityText.getColor(string13, string11 = (String)arrayList.get(1), string10 = (String)arrayList.get(2));
                if (color == null) {
                    return -1;
                }
                if (sGIFigureElementLegend.setFontColorDirectly(color)) return 0;
                return -1;
            }
            if (string.equals("legendFrameVisible")) {
                if (arrayList.size() < 1) {
                    return -1;
                }
                String string14 = (String)arrayList.get(0);
                Boolean bl = SGUtilityText.getBoolean(SGUtilityText.getBooleanString(string14));
                if (bl == null) {
                    return -1;
                }
                if (sGIFigureElementLegend.setFrameVisibleDirectly(bl)) return 0;
                return -1;
            }
            if (string.equals("legendFrameLineWidth")) {
                StringBuffer stringBuffer3;
                if (arrayList.size() < 1) {
                    return -1;
                }
                String string15 = (String)arrayList.get(0);
                Number number = SGUtilityText.getNumber(string15, stringBuffer3 = new StringBuffer());
                if (number == null) {
                    return -1;
                }
                if (sGIFigureElementLegend.setFrameLineWidthDirectly(number.floatValue(), stringBuffer3.toString())) return 0;
                return -1;
            }
            if (string.equals("legendFrameColor")) {
                String string16;
                String string17;
                if (arrayList.size() == 1) {
                    String string18 = (String)arrayList.get(0);
                    Color color = SGUtilityText.getColor(string18);
                    if (color == null) {
                        return -1;
                    }
                    if (sGIFigureElementLegend.setFrameColorDirectly(color)) return 0;
                    return -1;
                }
                if (arrayList.size() != 3) return -1;
                String string19 = (String)arrayList.get(0);
                Color color = SGUtilityText.getColor(string19, string17 = (String)arrayList.get(1), string16 = (String)arrayList.get(2));
                if (color == null) {
                    return -1;
                }
                if (sGIFigureElementLegend.setFrameColorDirectly(color)) return 0;
                return -1;
            }
            if (string.equals("legendBackgroundTransparent")) {
                if (arrayList.size() < 1) {
                    return -1;
                }
                String string20 = (String)arrayList.get(0);
                Boolean bl = SGUtilityText.getBoolean(SGUtilityText.getBooleanString(string20));
                if (bl == null) {
                    return -1;
                }
                if (sGIFigureElementLegend.setBackgroundTransparentDirectly(bl)) return 0;
                return -1;
            }
            if (string.equals("legendBackgroundColor")) {
                String string21;
                String string22;
                if (arrayList.size() == 1) {
                    String string23 = (String)arrayList.get(0);
                    Color color = SGUtilityText.getColor(string23);
                    if (color == null) {
                        return -1;
                    }
                    if (sGIFigureElementLegend.setBackgroundColorDirectly(color)) return 0;
                    return -1;
                }
                if (arrayList.size() != 3) return -1;
                String string24 = (String)arrayList.get(0);
                Color color = SGUtilityText.getColor(string24, string22 = (String)arrayList.get(1), string21 = (String)arrayList.get(2));
                if (color == null) {
                    return -1;
                }
                if (sGIFigureElementLegend.setBackgroundColorDirectly(color)) return 0;
                return -1;
            }
            if (!string.equals("legendSymbolSpan")) return 0;
            if (arrayList.size() < 1) {
                return -1;
            }
            String string25 = (String)arrayList.get(0);
            Number number = SGUtilityText.getNumber(string25, stringBuffer = new StringBuffer());
            if (number == null) {
                return -1;
            }
            if (sGIFigureElementLegend.setSymbolSpanDirectly(number.floatValue(), stringBuffer.toString())) return 0;
            return -1;
        }

        private int setShapeProperties(String string, SGIFigureElementShape sGIFigureElementShape, ArrayList arrayList) {
            String[] stringArray = new String[]{"shapeAxisX", "shapeAxisY", "rectangleLeftX", "rectangleRightX", "rectangleTopY", "rectangleBottomY", "rectangleEdgeLineWidth", "rectangleEdgeLineType", "rectangleEdgeLineColor", "rectangleBackgroundTransparent", "rectangleBackgroundColor", "arrowStartX", "arrowStartY", "arrowEndX", "arrowEndY", "arrowLineWidth", "arrowLineType", "arrowHeadSize", "arrowColor", "arrowStartType", "arrowEndType", "arrowOpenAngle", "arrowCloseAngle", "deleteShape", "moveToFrontShape", "moveToBackShape"};
            if (!this.contains(stringArray, string)) {
                return 1;
            }
            int n = arrayList.size();
            if (arrayList.size() < 1) {
                return -1;
            }
            String string2 = (String)arrayList.get(0);
            Integer n2 = SGUtilityText.getInteger(string2);
            if (n2 == null) {
                return -1;
            }
            if (n == 1) {
                if (string.equals("deleteShape") ? !sGIFigureElementShape.hideChildObject(n2) : (string.equals("moveToFrontShape") ? !sGIFigureElementShape.moveChildObject(n2, true) : string.equals("moveToBackShape") && !sGIFigureElementShape.moveChildObject(n2, false))) {
                    return -1;
                }
                return 0;
            }
            String string3 = (String)arrayList.get(1);
            if (string.equals("shapeAxisX")) {
                int n3 = this.getAxisLocation(string3);
                if (n3 == -1) {
                    return -1;
                }
                if (!sGIFigureElementShape.setAxisXDirectly(n2, n3)) {
                    return -1;
                }
            } else if (string.equals("shapeAxisY")) {
                int n4 = this.getAxisLocation(string3);
                if (n4 == -1) {
                    return -1;
                }
                if (!sGIFigureElementShape.setAxisYDirectly(n2, n4)) {
                    return -1;
                }
            } else if (string.equals("rectangleLeftX")) {
                Double d = SGUtilityText.getDouble(string3);
                if (d == null) {
                    return -1;
                }
                if (!sGIFigureElementShape.setRectangleLeftXValueDirectly(n2, ((Number)d).floatValue())) {
                    return -1;
                }
            } else if (string.equals("rectangleRightX")) {
                Double d = SGUtilityText.getDouble(string3);
                if (d == null) {
                    return -1;
                }
                if (!sGIFigureElementShape.setRectangleRightXValueDirectly(n2, ((Number)d).floatValue())) {
                    return -1;
                }
            } else if (string.equals("rectangleTopY")) {
                Double d = SGUtilityText.getDouble(string3);
                if (d == null) {
                    return -1;
                }
                if (!sGIFigureElementShape.setRectangleTopYValueDirectly(n2, ((Number)d).floatValue())) {
                    return -1;
                }
            } else if (string.equals("rectangleBottomY")) {
                Double d = SGUtilityText.getDouble(string3);
                if (d == null) {
                    return -1;
                }
                if (!sGIFigureElementShape.setRectangleBottomYValueDirectly(n2, ((Number)d).floatValue())) {
                    return -1;
                }
            } else if (string.equals("rectangleEdgeLineWidth")) {
                StringBuffer stringBuffer = new StringBuffer();
                Number number = SGUtilityText.getNumber(string3, stringBuffer);
                if (number == null) {
                    return -1;
                }
                if (!sGIFigureElementShape.setRectangleEdgeLineWidthDirectly(n2, number.floatValue(), stringBuffer.toString())) {
                    return -1;
                }
            } else if (string.equals("rectangleEdgeLineType")) {
                int n5 = this.getLineType(string3);
                if (n5 == -1) {
                    return -1;
                }
                if (!sGIFigureElementShape.setRectangleEdgeLineTypeDirectly(n2, n5)) {
                    return -1;
                }
            } else if (string.equals("rectangleEdgeLineColor")) {
                Color color = null;
                if (n == 2) {
                    color = SGUtilityText.getColor(string3);
                } else if (n == 4) {
                    String string4 = (String)arrayList.get(2);
                    String string5 = (String)arrayList.get(3);
                    color = SGUtilityText.getColor(string3, string4, string5);
                } else {
                    return -1;
                }
                if (color == null) {
                    return -1;
                }
                if (!sGIFigureElementShape.setRectangleEdgeLineColorDirectly(n2, color)) {
                    return -1;
                }
            } else if (string.equals("rectangleBackgroundTransparent")) {
                Boolean bl = SGUtilityText.getBoolean(SGUtilityText.getBooleanString(string3));
                if (bl == null) {
                    return -1;
                }
                if (!sGIFigureElementShape.setRectangleBackgroundTransparentDirectly(n2, bl)) {
                    return -1;
                }
            } else if (string.equals("rectangleBackgroundColor")) {
                Color color = null;
                if (n == 2) {
                    color = SGUtilityText.getColor(string3);
                } else if (n == 4) {
                    String string6 = (String)arrayList.get(2);
                    String string7 = (String)arrayList.get(3);
                    color = SGUtilityText.getColor(string3, string6, string7);
                } else {
                    return -1;
                }
                if (color == null) {
                    return -1;
                }
                if (!sGIFigureElementShape.setRectangleBackgroundColorDirectly(n2, color)) {
                    return -1;
                }
            } else if (string.equals("arrowStartX")) {
                Double d = SGUtilityText.getDouble(string3);
                if (d == null) {
                    return -1;
                }
                if (!sGIFigureElementShape.setArrowStartXValueDirectly(n2, ((Number)d).floatValue())) {
                    return -1;
                }
            } else if (string.equals("arrowStartY")) {
                Double d = SGUtilityText.getDouble(string3);
                if (d == null) {
                    return -1;
                }
                if (!sGIFigureElementShape.setArrowStartYValueDirectly(n2, ((Number)d).floatValue())) {
                    return -1;
                }
            } else if (string.equals("arrowEndX")) {
                Double d = SGUtilityText.getDouble(string3);
                if (d == null) {
                    return -1;
                }
                if (!sGIFigureElementShape.setArrowEndXValueDirectly(n2, ((Number)d).floatValue())) {
                    return -1;
                }
            } else if (string.equals("arrowEndY")) {
                Double d = SGUtilityText.getDouble(string3);
                if (d == null) {
                    return -1;
                }
                if (!sGIFigureElementShape.setArrowEndYValueDirectly(n2, ((Number)d).floatValue())) {
                    return -1;
                }
            } else if (string.equals("arrowLineWidth")) {
                StringBuffer stringBuffer = new StringBuffer();
                Number number = SGUtilityText.getNumber(string3, stringBuffer);
                if (number == null) {
                    return -1;
                }
                if (!sGIFigureElementShape.setArrowLineWidthDirectly(n2, number.floatValue(), stringBuffer.toString())) {
                    return -1;
                }
            } else if (string.equals("arrowLineType")) {
                int n6 = this.getLineType(string3);
                if (n6 == -1) {
                    return -1;
                }
                if (!sGIFigureElementShape.setArrowLineTypeDirectly(n2, n6)) {
                    return -1;
                }
            } else if (string.equals("arrowHeadSize")) {
                StringBuffer stringBuffer = new StringBuffer();
                Number number = SGUtilityText.getNumber(string3, stringBuffer);
                if (number == null) {
                    return -1;
                }
                if (!sGIFigureElementShape.setArrowHeadSizeDirectly(n2, number.floatValue(), stringBuffer.toString())) {
                    return -1;
                }
            } else if (string.equals("arrowColor")) {
                Color color = null;
                if (n == 2) {
                    color = SGUtilityText.getColor(string3);
                } else if (n == 4) {
                    String string8 = (String)arrayList.get(2);
                    String string9 = (String)arrayList.get(3);
                    color = SGUtilityText.getColor(string3, string8, string9);
                } else {
                    return -1;
                }
                if (color == null) {
                    return -1;
                }
                if (!sGIFigureElementShape.setArrowColorDirectly(n2, color)) {
                    return -1;
                }
            } else if (string.equals("arrowStartType")) {
                Integer n7 = SGDrawingElementArrow.getSymbolTypeFromName(string3);
                if (n7 == null) {
                    return -1;
                }
                if (!sGIFigureElementShape.setArrowStartTypeDirectly(n2, n7)) {
                    return -1;
                }
            } else if (string.equals("arrowEndType")) {
                Integer n8 = SGDrawingElementArrow.getSymbolTypeFromName(string3);
                if (n8 == null) {
                    return -1;
                }
                if (!sGIFigureElementShape.setArrowEndTypeDirectly(n2, n8)) {
                    return -1;
                }
            } else if (string.equals("arrowOpenAngle")) {
                Double d = SGUtilityText.getDouble(string3);
                if (d == null) {
                    return -1;
                }
                float f = ((Number)d).floatValue() * ((float)Math.PI / 180);
                if (!sGIFigureElementShape.setArrowOpenAngleDirectly(n2, f)) {
                    return -1;
                }
            } else if (string.equals("arrowCloseAngle")) {
                Double d = SGUtilityText.getDouble(string3);
                if (d == null) {
                    return -1;
                }
                float f = ((Number)d).floatValue() * ((float)Math.PI / 180);
                if (!sGIFigureElementShape.setArrowCloseAngleDirectly(n2, f)) {
                    return -1;
                }
            }
            return 0;
        }
    }

    private class ClipBoardManager {
        private ArrayList mCopiedObjectsBuffer = null;
        private ArrayList mCopiedDataObjectBuffer = null;
        private ArrayList mCopiedDataNameBuffer = null;
        private ArrayList mCopiedDataPropertiesBuffer = null;
        private ArrayList mCopiedDataPropertiesForLegendBuffer = null;
        private WindowInfo mWindowInfo;

        private ClipBoardManager(SGSplashWindow sGSplashWindow, float f, float f2) {
            float f3 = (f2 - f) / 6.0f;
            sGSplashWindow.setProgressValue(f + f3);
            this.mCopiedObjectsBuffer = new ArrayList();
            sGSplashWindow.setProgressValue(f + f3 * 2.0f);
            this.mCopiedDataObjectBuffer = new ArrayList();
            sGSplashWindow.setProgressValue(f + f3 * 3.0f);
            this.mCopiedDataNameBuffer = new ArrayList();
            sGSplashWindow.setProgressValue(f + f3 * 4.0f);
            this.mCopiedDataPropertiesBuffer = new ArrayList();
            sGSplashWindow.setProgressValue(f + f3 * 5.0f);
            this.mCopiedDataPropertiesForLegendBuffer = new ArrayList();
        }

        private boolean cutAndCopy(SGDrawingWindow sGDrawingWindow, boolean bl) {
            this.mCopiedObjectsBuffer.clear();
            this.mCopiedDataObjectBuffer.clear();
            this.mCopiedDataNameBuffer.clear();
            this.mCopiedDataPropertiesBuffer.clear();
            ArrayList arrayList = sGDrawingWindow.getCopiedObjectsList();
            this.mCopiedObjectsBuffer.addAll(arrayList);
            ArrayList arrayList2 = sGDrawingWindow.getCopiedObjectsDataList();
            this.mCopiedDataObjectBuffer.addAll(arrayList2);
            ArrayList arrayList3 = sGDrawingWindow.getCopiedDataNameList();
            this.mCopiedDataNameBuffer.addAll(arrayList3);
            ArrayList arrayList4 = sGDrawingWindow.getCopiedDataPropertiesMapList();
            this.mCopiedDataPropertiesBuffer.addAll(arrayList4);
            WindowInfo windowInfo = new WindowInfo();
            if (bl ? !this.copyFigures(sGDrawingWindow, windowInfo) : !this.cutFigures(sGDrawingWindow, windowInfo)) {
                return false;
            }
            this.mWindowInfo = windowInfo;
            SGMainFunctions.this.mWindowManager.setPasteMenuEnabled();
            return true;
        }

        private boolean cutFigures(SGDrawingWindow sGDrawingWindow, WindowInfo windowInfo) {
            if (!this.copyFigures(sGDrawingWindow, windowInfo)) {
                return false;
            }
            if (windowInfo.mDataListMap.size() != 0) {
                sGDrawingWindow.hideSelectedObjects();
            }
            return true;
        }

        private boolean copyFigures(SGDrawingWindow sGDrawingWindow, WindowInfo windowInfo) {
            DOMImplementation dOMImplementation = SGApplicationUtility.getDOMImplementation();
            if (dOMImplementation == null) {
                return false;
            }
            Document document = dOMImplementation.createDocument("", SGMainFunctions.TAG_NAME_FOCUSED_FIGURES, null);
            if (!sGDrawingWindow.createDOMTree(document, 3)) {
                return false;
            }
            TreeMap<String, ArrayList> treeMap = new TreeMap<String, ArrayList>();
            ArrayList arrayList = sGDrawingWindow.getCopiedFiguresList();
            for (int i = 0; i < arrayList.size(); ++i) {
                SGFigure sGFigure = (SGFigure)arrayList.get(i);
                ArrayList arrayList2 = new ArrayList(sGFigure.getVisibleDataList());
                arrayList2 = (ArrayList)arrayList2.clone();
                String string = Integer.toString(sGFigure.getID());
                treeMap.put(string, arrayList2);
            }
            windowInfo.mDocument = document;
            windowInfo.mDataListMap = treeMap;
            return true;
        }

        private boolean pasteToWindow(SGDrawingWindow sGDrawingWindow) {
            sGDrawingWindow.pasteToFigures(this.mCopiedObjectsBuffer, this.mCopiedDataObjectBuffer, this.mCopiedDataNameBuffer, this.mCopiedDataPropertiesBuffer);
            WindowInfo windowInfo = this.mWindowInfo;
            if (windowInfo == null) {
                return false;
            }
            Map map = windowInfo.mDataListMap;
            Element element = windowInfo.mDocument.getDocumentElement();
            NodeList nodeList = element.getElementsByTagName("Window");
            if (nodeList.getLength() == 0) {
                return false;
            }
            Element element2 = (Element)nodeList.item(0);
            int n = sGDrawingWindow.getFigureList().size();
            int n2 = SGMainFunctions.this.createFiguresFromPropertyFile(element2, sGDrawingWindow, map);
            if (n2 != 0) {
                return false;
            }
            int n3 = sGDrawingWindow.getFigureList().size();
            sGDrawingWindow.setChanged(n != n3);
            return true;
        }

        private boolean getPasteMenuStatus() {
            boolean bl = this.mCopiedObjectsBuffer.size() != 0;
            boolean bl2 = this.mCopiedDataObjectBuffer.size() != 0;
            boolean bl3 = false;
            if (this.mWindowInfo != null) {
                Document document = this.mWindowInfo.mDocument;
                NodeList nodeList = document.getElementsByTagName("Figure");
                int n = nodeList.getLength();
                bl3 = n != 0;
            }
            boolean bl4 = bl | bl2 | bl3;
            return bl4;
        }

        private class WindowInfo {
            private Document mDocument;
            private Map mDataListMap = new TreeMap();

            private WindowInfo() {
            }
        }
    }

    private class WindowManager
    implements ActionListener,
    DropTargetListener,
    PropertyChangeListener,
    WindowListener {
        private SGImageExportManager mImageFileCreator = null;
        private TreeMap mWndMap = null;
        private SGDrawingWindow mActiveWindow = null;
        public static final String WINDOW_TITLE_PREFIX = "Samurai Graph - Window : ";

        private WindowManager(SGSplashWindow sGSplashWindow, float f, float f2) {
            float f3 = (f2 - f) / 3.0f;
            sGSplashWindow.setProgressValue(f + f3);
            this.mWndMap = new TreeMap();
            sGSplashWindow.setProgressValue(f + f3 * 2.0f);
            this.mImageFileCreator = new SGImageExportManager();
        }

        public SGDrawingWindow createWindow(int n) {
            String[] stringArray;
            SGDrawingWindow sGDrawingWindow = new SGDrawingWindow();
            sGDrawingWindow.setID(n);
            this.mWndMap.put(new Integer(n), sGDrawingWindow);
            sGDrawingWindow.setDefaultCloseOperation(0);
            String string = WINDOW_TITLE_PREFIX + sGDrawingWindow.getID();
            sGDrawingWindow.setTitle(string);
            sGDrawingWindow.addActionListener(this);
            sGDrawingWindow.addWindowListener(this);
            sGDrawingWindow.addPropertyChangeListener(this);
            DropTarget dropTarget = new DropTarget(sGDrawingWindow, 3, this, true);
            sGDrawingWindow.setDropTarget(dropTarget);
            sGDrawingWindow.setImageFileCreator(this.mImageFileCreator);
            Preferences preferences = Preferences.userNodeForPackage(this.getClass());
            String string2 = preferences.get("Tool Bar Pattern", null);
            if (string2 != null) {
                ArrayList arrayList = new ArrayList();
                if (SGUtilityText.tokenize(string2, arrayList, false)) {
                    int n2;
                    ArrayList<String> arrayList2 = new ArrayList<String>();
                    for (n2 = 0; n2 < arrayList.size(); ++n2) {
                        String string3 = (String)arrayList.get(n2);
                        if (string3 == null) continue;
                        arrayList2.add(string3);
                    }
                    stringArray = new String[arrayList2.size()];
                    for (n2 = 0; n2 < arrayList2.size(); ++n2) {
                        stringArray[n2] = (String)arrayList2.get(n2);
                    }
                } else {
                    stringArray = SGIRootObjectConstants.TOOLBAR_MENUCMD_ARRAY;
                }
            } else {
                stringArray = new String[]{"File", "Insert", "Zoom"};
                SGMainFunctions.this.updateToolBarPatternInPreferences(stringArray);
            }
            sGDrawingWindow.setToolBarPattern(stringArray);
            sGDrawingWindow.setLocation(100, 100);
            if (!sGDrawingWindow.init()) {
                return null;
            }
            this.setPasteMenuEnabled();
            return sGDrawingWindow;
        }

        public SGDrawingWindow getWindow(int n) {
            return (SGDrawingWindow)this.mWndMap.get(new Integer(n));
        }

        public SGDrawingWindow getActiveWindow() {
            return this.mActiveWindow;
        }

        private SGDrawingWindow createWindow() {
            int n = this.getCurrentWindowID();
            SGDrawingWindow sGDrawingWindow = this.createWindow(n);
            return sGDrawingWindow;
        }

        private int getCurrentWindowID() {
            int n = this.mWndMap.size() == 0 ? 1 : (Integer)this.mWndMap.lastKey() + 1;
            return n;
        }

        public int getWindowNumber() {
            return this.mWndMap.size();
        }

        public SGDrawingWindow createNewWindow() {
            SGDrawingWindow sGDrawingWindow = this.createWindow();
            if (sGDrawingWindow == null) {
                return null;
            }
            sGDrawingWindow.initPropertiesHistory();
            return sGDrawingWindow;
        }

        public void closeWindow(int n) {
            SGDrawingWindow sGDrawingWindow = this.getWindow(n);
            if (sGDrawingWindow == null) {
                return;
            }
            this.closeWindow(sGDrawingWindow);
        }

        public int closeWindow(SGDrawingWindow sGDrawingWindow) {
            if (sGDrawingWindow.needsConfirmationBeforeDiscard()) {
                int n = SGMainFunctions.this.confirmBeforeClosing(sGDrawingWindow);
                if (n == 0) {
                    this.removeWindow(sGDrawingWindow);
                } else {
                    if (n == 1 | n == -1) {
                        return 1;
                    }
                    if (n == 2) {
                        int n2 = SGMainFunctions.this.mPropertyFileManager.savePropertiesByDialog(sGDrawingWindow);
                        if (n2 == 0) {
                            this.removeWindow(sGDrawingWindow);
                        }
                        return n2;
                    }
                }
            } else {
                this.removeWindow(sGDrawingWindow);
            }
            return 0;
        }

        public void closeAllWindow() {
            SGDrawingWindow sGDrawingWindow;
            int n;
            ArrayList arrayList = new ArrayList(this.mWndMap.values());
            for (int i = arrayList.size() - 1; i >= 0 && (n = this.closeWindow(sGDrawingWindow = (SGDrawingWindow)arrayList.get(i))) != 1; --i) {
            }
        }

        public void setActiveWindow(SGDrawingWindow sGDrawingWindow) {
            this.mActiveWindow = sGDrawingWindow;
        }

        private void setPasteMenuEnabled() {
            boolean bl = SGMainFunctions.this.mClipBoardManager.getPasteMenuStatus();
            ArrayList arrayList = new ArrayList(this.mWndMap.values());
            for (int i = 0; i < arrayList.size(); ++i) {
                SGDrawingWindow sGDrawingWindow = (SGDrawingWindow)arrayList.get(i);
                sGDrawingWindow.setPasteMenuEnabled(bl);
            }
        }

        private boolean removeWindow(SGDrawingWindow sGDrawingWindow) {
            int n = sGDrawingWindow.getID();
            this.mWndMap.remove(new Integer(n));
            sGDrawingWindow.removeWindowListener(this);
            sGDrawingWindow.removeActionListener(this);
            sGDrawingWindow.setVisible(false);
            sGDrawingWindow.dispose();
            System.gc();
            if (this.mWndMap.size() == 0) {
                SGMainFunctions.this.exitApplication(0);
            }
            return true;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            String string = actionEvent.getActionCommand();
            SGDrawingWindow sGDrawingWindow = (SGDrawingWindow)object;
            if (string.equals("Create New Window")) {
                SGDrawingWindow sGDrawingWindow2 = this.createNewWindow();
                if (sGDrawingWindow2 == null) {
                    return;
                }
                sGDrawingWindow2.setVisible(true);
            } else if (string.equals("Close Window")) {
                this.closeWindow(sGDrawingWindow);
            } else if (string.equals("Exit")) {
                this.closeAllWindow();
            } else if (string.equals("Draw Graph")) {
                SGMainFunctions.this.drawGraphFromDialog(sGDrawingWindow);
            } else if (string.equals("Save Property")) {
                int n = SGMainFunctions.this.mPropertyFileManager.savePropertiesByDialog(sGDrawingWindow);
                sGDrawingWindow.setSaved(n == 0);
            } else if (string.equals("Load Property")) {
                int n;
                if (sGDrawingWindow.needsConfirmationBeforeDiscard() && (n = SGMainFunctions.this.beforeDiscard(sGDrawingWindow)) == 1) {
                    return;
                }
                SGMainFunctions.this.mPropertyFileManager.loadPropertyFromDialog(sGDrawingWindow);
            } else if (string.equals("Save Data Set")) {
                int n = SGMainFunctions.this.mDataSetManager.saveDataSetFromDialog(sGDrawingWindow);
                sGDrawingWindow.setSaved(n == 0);
            } else if (string.equals("Load Data Set")) {
                boolean bl;
                if (sGDrawingWindow.needsConfirmationBeforeDiscard() && (bl = SGMainFunctions.this.beforeDiscard(sGDrawingWindow))) {
                    return;
                }
                bl = SGMainFunctions.this.mDataSetManager.loadDataSetFromDialog(sGDrawingWindow);
                sGDrawingWindow.setSaved(bl);
            } else if (string.equals("Load Background Image")) {
                String string2;
                SGFileChooser sGFileChooser = new SGFileChooser();
                SGExtensionFileFilter sGExtensionFileFilter = new SGExtensionFileFilter();
                sGExtensionFileFilter.setDescription("Image File");
                String[] stringArray = SGIImageConstants.DRAWABLE_IMAGE_EXTENSIONS;
                for (int i = 0; i < stringArray.length; ++i) {
                    sGExtensionFileFilter.addExtension(stringArray[i]);
                }
                sGFileChooser.setFileFilter(sGExtensionFileFilter);
                String string3 = string2 = SGMainFunctions.this.getCurrentFileDirectory();
                if (SGMainFunctions.this.mCurrentImageFileName != null) {
                    string3 = string3 + SGIConstants.FILE_SEPARATOR + SGMainFunctions.this.mCurrentImageFileName;
                }
                ((JFileChooser)sGFileChooser).setSelectedFile(new File(string3));
                int n = sGFileChooser.showOpenDialog(sGDrawingWindow);
                File file = null;
                if (n == 0) {
                    file = sGFileChooser.getSelectedFile();
                }
                if (file != null) {
                    SGMainFunctions.this.updateCurrentFile(file, 3);
                    if (!sGDrawingWindow.setImage(file)) {
                        return;
                    }
                }
            } else if (string.equals("Cut")) {
                SGMainFunctions.this.mClipBoardManager.cutAndCopy(sGDrawingWindow, false);
            } else if (string.equals("Copy")) {
                SGMainFunctions.this.mClipBoardManager.cutAndCopy(sGDrawingWindow, true);
            } else if (string.equals("Paste")) {
                SGMainFunctions.this.mClipBoardManager.pasteToWindow(sGDrawingWindow);
            } else if (string.equals("Duplicate")) {
                SGMainFunctions.this.duplicateFocusedFigures(sGDrawingWindow);
            } else if (string.equals("Export as Image")) {
                this.mImageFileCreator.setBaseDirectory(SGMainFunctions.this.getCurrentFileDirectory());
                sGDrawingWindow.exportAsImage(false);
                SGMainFunctions.this.setCurrentFileDirectory(this.mImageFileCreator.getBaseDirectory());
            } else if (string.equals("Print")) {
                sGDrawingWindow.printImage(false);
            } else if (string.equals("Upgrade")) {
                SGMainFunctions.this.mUpgradeManager.showUpgradeDialog(sGDrawingWindow);
            } else if (string.equals("Change Log")) {
                SGMainFunctions.this.showChangeLogDialog(sGDrawingWindow);
            } else if (string.equals("Proxy")) {
                SGMainFunctions.this.mProxyManager.showProxySettingDialog(sGDrawingWindow);
            } else if (string.equals("About")) {
                SGMainFunctions.this.showAboutDialog(sGDrawingWindow);
            }
        }

        public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
            dropTargetDragEvent.acceptDrag(3);
        }

        public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
        }

        public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
        }

        public void dragExit(DropTargetEvent dropTargetEvent) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void drop(DropTargetDropEvent dropTargetDropEvent) {
            DropTarget dropTarget = (DropTarget)dropTargetDropEvent.getSource();
            Component component = dropTarget.getComponent();
            SGDrawingWindow sGDrawingWindow = (SGDrawingWindow)component;
            dropTargetDropEvent.acceptDrop(3);
            try {
                if ((dropTargetDropEvent.getDropAction() & 3) != 0) {
                    Object object;
                    Transferable transferable = dropTargetDropEvent.getTransferable();
                    ArrayList<File> arrayList = null;
                    if (dropTargetDropEvent.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                        object = (List)transferable.getTransferData(DataFlavor.javaFileListFlavor);
                        arrayList = new ArrayList<File>((Collection<File>)object);
                    } else if (dropTargetDropEvent.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                        String string = (String)transferable.getTransferData(DataFlavor.stringFlavor);
                        StringTokenizer stringTokenizer = new StringTokenizer(string, "\n");
                        arrayList = new ArrayList();
                        while (stringTokenizer.hasMoreTokens()) {
                            object = stringTokenizer.nextToken();
                            File file = new File(new URI(((String)object).trim()));
                            arrayList.add(file);
                        }
                    }
                    if (arrayList != null) {
                        object = new DropEventHandler(dropTargetDropEvent, arrayList);
                    }
                }
            }
            catch (Exception exception) {
            }
            finally {
                dropTargetDropEvent.dropComplete(false);
            }
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            Object object = propertyChangeEvent.getSource();
            String string = propertyChangeEvent.getPropertyName();
            if (object instanceof SGDrawingWindow && "Tool Bar".equals(string)) {
                SGDrawingWindow sGDrawingWindow = (SGDrawingWindow)object;
                SGMainFunctions.this.updateToolBarPatternInPreferences(sGDrawingWindow.getToolBarPattern());
            }
        }

        public void windowOpened(WindowEvent windowEvent) {
        }

        public void windowClosing(WindowEvent windowEvent) {
            Object object = windowEvent.getSource();
            SGDrawingWindow sGDrawingWindow = (SGDrawingWindow)windowEvent.getSource();
            this.closeWindow(sGDrawingWindow);
        }

        public void windowClosed(WindowEvent windowEvent) {
        }

        public void windowIconified(WindowEvent windowEvent) {
        }

        public void windowDeiconified(WindowEvent windowEvent) {
        }

        public void windowActivated(WindowEvent windowEvent) {
        }

        public void windowDeactivated(WindowEvent windowEvent) {
        }
    }

    private class DataSetManager {
        private static final String DATASET_TEMPDIR_NAME = "SamuraiGraphArcvhive";
        private static final String DATASET_PROPERTY_FILENAME = "property.sgp";
        private static final String MSG_SAVE_DATASET_FAILED = "Failed save dataset";
        private static final String MSG_LOAD_DATASET_FAILED = "Failed load dataset";
        private SGArchiveFileExtractor mArchiveFileExtractor = null;
        private SGArchiveFileCreator mArchiveFileCreator = null;

        private DataSetManager(SGSplashWindow sGSplashWindow, float f, float f2) {
            float f3 = (f2 - f) / 3.0f;
            sGSplashWindow.setProgressValue(f + f3);
            this.mArchiveFileExtractor = new SGArchiveFileExtractor();
            sGSplashWindow.setProgressValue(f + f3 * 2.0f);
            this.mArchiveFileCreator = new SGArchiveFileCreator();
        }

        public boolean loadDataSetFromDialog(SGDrawingWindow sGDrawingWindow) {
            return this.loadDataSetFromEventDispatchThread(sGDrawingWindow, null);
        }

        private boolean loadDataSet(SGDrawingWindow sGDrawingWindow, File file) {
            File file2 = this._createTemporaryDirectory(sGDrawingWindow);
            if (file2 == null) {
                return false;
            }
            int n = -1;
            n = file == null ? this.mArchiveFileExtractor.extract(sGDrawingWindow, file2.getPath()) : this.mArchiveFileExtractor.extract(sGDrawingWindow, file2.getPath(), file);
            ArrayList arrayList = this.mArchiveFileExtractor.getExtractedFileList();
            if (n != 0) {
                this.mArchiveFileExtractor.deleteExtractedFiles();
                file2.delete();
                return false;
            }
            String string = file2.getAbsolutePath() + SGIConstants.FILE_SEPARATOR + DATASET_PROPERTY_FILENAME;
            if (!arrayList.contains(new File(string))) {
                this.mArchiveFileExtractor.deleteExtractedFiles();
                file2.delete();
                return false;
            }
            ArrayList arrayList2 = new ArrayList();
            this._sortDataList(file2, arrayList, arrayList2);
            boolean bl = this._loadDataSet(sGDrawingWindow, string, arrayList2);
            this.mArchiveFileExtractor.deleteExtractedFiles();
            file2.delete();
            File file3 = this.mArchiveFileExtractor.getSelectedFile();
            if (file3 != null) {
                SGMainFunctions.this.updateCurrentFile(file3, 2);
            }
            return bl;
        }

        private boolean loadDataSetFromEventDispatchThread(final SGDrawingWindow sGDrawingWindow, final File file) {
            sGDrawingWindow.setWaitCursor(true);
            Boolean bl = Boolean.FALSE;
            try {
                bl = (Boolean)Worker.post((Task)new Task(){

                    public Object run() throws Exception {
                        if (!this.loadDataSet(sGDrawingWindow, file)) {
                            return Boolean.FALSE;
                        }
                        return Boolean.TRUE;
                    }
                });
            }
            catch (Exception exception) {
                bl = Boolean.FALSE;
            }
            sGDrawingWindow.setWaitCursor(false);
            return bl;
        }

        private File _createTemporaryDirectory(Component component) {
            String string = MSG_LOAD_DATASET_FAILED;
            File file = new File(SGIConstants.TMP_DIR + SGIConstants.FILE_SEPARATOR + DATASET_TEMPDIR_NAME + System.currentTimeMillis());
            if (!file.mkdir()) {
                JOptionPane.showMessageDialog(component, string);
                return null;
            }
            return file;
        }

        private void _sortDataList(File file, ArrayList arrayList, ArrayList arrayList2) {
            int n = 0;
            int n2 = 0;
            while (true) {
                String string;
                n = 0;
                while (arrayList.contains(new File(string = file.getAbsolutePath() + SGIConstants.FILE_SEPARATOR + "id" + n2 + "-" + n + ".csv"))) {
                    arrayList2.add(string);
                    ++n;
                }
                if (n == 0) break;
                ++n2;
            }
        }

        private boolean _loadDataSet(SGDrawingWindow sGDrawingWindow, String string, ArrayList arrayList) {
            Object object;
            File file = new File(string);
            if (!file.exists()) {
                return false;
            }
            String string2 = SGUtility.getCanonicalPath(file.getPath());
            if (string2 == null) {
                return false;
            }
            URL uRL = null;
            try {
                uRL = file.toURL();
            }
            catch (MalformedURLException malformedURLException) {
                return false;
            }
            Document document = SGUtilityText.getDocument(uRL);
            if (document == null) {
                return false;
            }
            Element element = SGMainFunctions.this.mPropertyFileManager.getWindowElement(document);
            NodeList nodeList = element.getElementsByTagName("Figure");
            int n = nodeList.getLength();
            int n2 = 0;
            int[] nArray = new int[n];
            for (int i = 0; i < n; ++i) {
                Node node = nodeList.item(i);
                if (!(node instanceof Element)) {
                    return false;
                }
                Element element2 = (Element)node;
                object = element2.getElementsByTagName("Data");
                nArray[i] = object.getLength();
                n2 += nArray[i];
            }
            if (n2 != arrayList.size()) {
                return false;
            }
            TreeMap<Integer, Object> treeMap = new TreeMap<Integer, Object>();
            n2 = 0;
            for (int i = 0; i < n; ++i) {
                int n3 = nArray[i];
                object = new ArrayList();
                for (int j = 0; j < n3; ++j) {
                    ((ArrayList)object).add(arrayList.get(n2 + j));
                }
                treeMap.put(new Integer(i), object);
                n2 += n3;
            }
            sGDrawingWindow.clearUndoBuffer();
            sGDrawingWindow.removeAllFigures();
            sGDrawingWindow.updateClientRect();
            return SGMainFunctions.this.mPropertyFileManager.setPropertyFile(sGDrawingWindow, document, treeMap);
        }

        public int saveDataSetFromDialog(SGDrawingWindow sGDrawingWindow) {
            String string = SGMainFunctions.this.getCurrentFileDirectory();
            String string2 = SGMainFunctions.this.mCurrentArchiveFileName;
            File file = new File(SGIConstants.TMP_DIR + SGIConstants.FILE_SEPARATOR + DATASET_TEMPDIR_NAME + System.currentTimeMillis());
            if (!file.mkdir()) {
                JOptionPane.showMessageDialog(sGDrawingWindow, MSG_SAVE_DATASET_FAILED);
                return -1;
            }
            ArrayList arrayList = this._dumpDataSet(sGDrawingWindow, file);
            if (arrayList == null) {
                JOptionPane.showMessageDialog(sGDrawingWindow, MSG_SAVE_DATASET_FAILED);
                file.delete();
                return -1;
            }
            this.mArchiveFileCreator.setFile(string, string2);
            int n = this.mArchiveFileCreator.create(sGDrawingWindow, file.getPath());
            for (int i = 0; i < arrayList.size(); ++i) {
                File file2 = (File)arrayList.get(i);
                file2.delete();
            }
            file.delete();
            if (n != 0) {
                return n;
            }
            File file3 = this.mArchiveFileCreator.getSelectedFile();
            if (file3 != null) {
                SGMainFunctions.this.updateCurrentFile(file3, 2);
            }
            return 0;
        }

        public int saveDataSet(SGDrawingWindow sGDrawingWindow, String string) {
            File file = new File(SGIConstants.TMP_DIR + SGIConstants.FILE_SEPARATOR + DATASET_TEMPDIR_NAME + System.currentTimeMillis());
            if (!file.mkdir()) {
                JOptionPane.showMessageDialog(sGDrawingWindow, MSG_SAVE_DATASET_FAILED);
                return -1;
            }
            ArrayList arrayList = this._dumpDataSet(sGDrawingWindow, file);
            if (arrayList == null) {
                JOptionPane.showMessageDialog(sGDrawingWindow, MSG_SAVE_DATASET_FAILED);
                file.delete();
                return -1;
            }
            int n = this.mArchiveFileCreator.create(sGDrawingWindow, file.getPath(), string);
            for (int i = 0; i < arrayList.size(); ++i) {
                File file2 = (File)arrayList.get(i);
                file2.delete();
            }
            file.delete();
            if (n != 0) {
                return n;
            }
            File file3 = this.mArchiveFileCreator.getSelectedFile();
            if (file3 != null) {
                SGMainFunctions.this.updateCurrentFile(file3, 2);
            }
            return 0;
        }

        private ArrayList _dumpDataSet(SGDrawingWindow sGDrawingWindow, File file) {
            ArrayList<File> arrayList = new ArrayList<File>();
            String string = file.getPath() + SGIConstants.FILE_SEPARATOR + DATASET_PROPERTY_FILENAME;
            int n = SGMainFunctions.this.mPropertyFileManager.saveProperties(sGDrawingWindow, string);
            if (n != 0) {
                return null;
            }
            arrayList.add(new File(string));
            ArrayList arrayList2 = sGDrawingWindow.getVisibleFigureList();
            for (int i = 0; i < arrayList2.size(); ++i) {
                SGFigure sGFigure = (SGFigure)arrayList2.get(i);
                List list = sGFigure.getVisibleDataList();
                for (int j = 0; j < list.size(); ++j) {
                    String string2;
                    File file2;
                    SGData sGData = (SGData)list.get(j);
                    if (!sGData.saveData(file2 = new File(string2 = file.getPath() + SGIConstants.FILE_SEPARATOR + "id" + i + "-" + j + ".csv"))) {
                        for (int k = 0; k < arrayList.size(); ++k) {
                            File file3 = (File)arrayList.get(k);
                            file3.delete();
                        }
                        return null;
                    }
                    arrayList.add(file2);
                }
            }
            return arrayList;
        }
    }

    private class Initializer
    extends Thread {
        private String mStartupFilePath = null;
        private int mStartupFileType = -1;

        private Initializer() {
        }

        private Initializer(String string, int n) {
            this.mStartupFilePath = string;
            this.mStartupFileType = n;
        }

        public void run() {
            SGSplashWindow sGSplashWindow = this.createSplashWindow();
            this.removeTemporaryFiles();
            if (sGSplashWindow == null) {
                SGMainFunctions.this.exitApplication(1);
            }
            sGSplashWindow.setCursor(Cursor.getPredefinedCursor(3));
            sGSplashWindow.setProgressValue(0.0f);
            sGSplashWindow.show();
            SGMainFunctions.this.mDataCreator = new SGDataCreator();
            sGSplashWindow.setProgressValue(0.15f);
            SGMainFunctions.this.mPropertyFileManager = new PropertyFileManager();
            SGMainFunctions.this.mDataSetManager = new DataSetManager(sGSplashWindow, 0.15f, 0.5f);
            sGSplashWindow.setProgressValue(0.5f);
            SGMainFunctions.this.mProxyManager = new SGProxyManager();
            sGSplashWindow.setProgressValue(0.6f);
            SGMainFunctions.this.mUpgradeManager = new SGUpgradeManager(SGMainFunctions.this.mProxyManager, SGMainFunctions.this.mAppProp);
            SGMainFunctions.this.mWindowManager = new WindowManager(sGSplashWindow, 0.6f, 0.8f);
            sGSplashWindow.setProgressValue(0.8f);
            SGMainFunctions.this.mPropertyManager = new PropertyManager();
            SGMainFunctions.this.mClipBoardManager = new ClipBoardManager(sGSplashWindow, 0.8f, 1.0f);
            SGMainFunctions.this.mFigureCreator = new SGFigureCreator(true);
            if (!SGMainFunctions.this.mFigureCreator.validateClasses()) {
                SGMainFunctions.this.exitApplication(1);
            }
            sGSplashWindow.setProgressValue(1.0f);
            SGDrawingWindow sGDrawingWindow = SGMainFunctions.this.mWindowManager.createNewWindow();
            SGMainFunctions.this.mWindowManager.setActiveWindow(sGDrawingWindow);
            sGDrawingWindow.setVisible(true);
            sGSplashWindow.hide();
            sGSplashWindow.setCursor(Cursor.getDefaultCursor());
            if (this.mStartupFileType == 1) {
                int n;
                File file = new File(this.mStartupFilePath);
                if (!SGMainFunctions.this.mPropertyFileManager.showMultiDataFileChooserDialog(file, new ArrayList(), sGDrawingWindow)) {
                    SGMainFunctions.this.exitApplication(1);
                }
                if ((n = SGMainFunctions.this.mPropertyFileManager.mMultiDataFileChooserWizardDialogDD.getCloseOption()) == 1) {
                    SGMainFunctions.this.exitApplication(0);
                }
            } else if (this.mStartupFileType == 2) {
                sGDrawingWindow.setWaitCursor(true);
                File file = new File(this.mStartupFilePath);
                if (!SGMainFunctions.this.mDataSetManager.loadDataSet(sGDrawingWindow, file)) {
                    SGMainFunctions.this.exitApplication(0);
                }
                sGDrawingWindow.setWaitCursor(false);
            }
            this.updatePreferences();
            SGMainFunctions.this.mUpgradeManager.upgradeWithCheckDate(sGDrawingWindow);
        }

        private SGSplashWindow createSplashWindow() {
            Class<?> clazz = this.getClass();
            String string = "/resources/Splash.png";
            URL uRL = clazz.getResource(string);
            Image image = Toolkit.getDefaultToolkit().getImage(uRL);
            if (image == null) {
                return null;
            }
            SGSplashWindow sGSplashWindow = new SGSplashWindow(image, SGMainFunctions.this.mAppProp.getVersionString());
            return sGSplashWindow;
        }

        private void updatePreferences() {
            Preferences preferences = Preferences.userNodeForPackage(this.getClass());
            int n = preferences.getInt("Upgrade Cycle", -1);
            if (n == -1) {
                preferences.putInt("Upgrade Cycle", 3);
            }
            String string = preferences.get("Date", null);
            preferences.putLong("Date", System.currentTimeMillis());
            preferences.remove("Major Version");
            preferences.remove("Minor Version");
            preferences.remove("Micro Version");
        }

        private void removeTemporaryFiles() {
            File file = new File(SGIConstants.TMP_DIR + SGIConstants.FILE_SEPARATOR + "SamuraiGraphTemp");
            try {
                file = file.getCanonicalFile();
            }
            catch (IOException iOException) {
                return;
            }
            if (file.exists()) {
                SGApplicationUtility.deleteRecursively(file);
            }
        }
    }
}

