
package jp.riken.brain.ni.samuraigraph.base;

/**
 * A generic 2 element tuple that is represented by two float numbers.
 */
public class SGTuple2f implements Cloneable
{

	/**
	 * The x coordinate.
	 */
	public float x;

	/**
	 * The y coordinate.
	 */
	public float y;


	/**
	 * 
	 */
	public SGTuple2f(){}


	/**
	 * Constructs and initializes a SGTuple2d from the specified xy coordinates.
	 * @param x the x coordinate
	 * @param y the y coordinate
	 */
	public SGTuple2f( final float X, final float Y )
	{
		x = X;
		y = Y;
	}


	/**
	 * 
	 */
	public SGTuple2f( final SGTuple2f tuple )
	{
		x = tuple.x;
		y = tuple.y;
	}


	/**
	 * @param  x
	 * @uml.property  name="x"
	 */
	public void setX( final float X )
	{
		x = X;
	}


	/**
	 * @param  y
	 * @uml.property  name="y"
	 */
	public void setY( final float Y )
	{
		y = Y;
	}


	/**
	 * 
	 */
	public void setValues( final float X, final float Y )
	{
		x = X;
		y = Y;
	}


	/**
	 * 
	 * @param tuple
	 */
	public void setValues( final SGTuple2f tuple )
	{
		if( tuple==null )
		{
			new IllegalArgumentException("tuple==null");
		}
		this.setValues( tuple.x, tuple.y );
	}


	/**
	 * 
	 */
	public String toString()
	{
		final String str = new String("("+x+","+y+")");
		return str;
	}


	/**
	 * 
	 */
	public boolean equals( Object obj )
	{
		if( ( obj instanceof SGTuple2f ) == false ) return false;
		SGTuple2f t = (SGTuple2f)obj;
		if( t.x!=this.x | t.y!=this.y ) return false;
		return true;
	}


	/**
	 * 
	 *
	 */
	public void clear()
	{
		this.x = 0.0f;
		this.y = 0.0f;
	}



	/**
	 * 
	 * @return
	 */
	public boolean isInfinite()
	{
		return Float.isInfinite(x) || Float.isInfinite(y);
	}



	/**
	 * 
	 * @return
	 */
	public boolean isNaN()
	{
		return Float.isNaN(x) || Float.isNaN(y);
	}



	/**
	 * 
	 */
	public Object clone()
	{
		try
		{
			return super.clone();
		}
		catch( CloneNotSupportedException ex )
		{
			// this shouldn't happen, since we are Cloneable
			throw new InternalError();
		}
	}


}
