/* Generated By:JavaCC: Do not edit this line. CPPParser.java */
package org.freehep.jaco.rtti.cpp;

import java.io.*;
import java.util.*;

import org.freehep.jaco.*;
import org.freehep.jaco.rtti.*;
import org.freehep.jaco.generator.*;

public final class CPPParser implements CPPParserConstants {

    // added to build RTTI
    private String visibility;

    private static String vers = "0.1";
    private static String id = "C++ Parser";

    // per file
    private static Vector comments;
    private static Vector classComments;
    private static Vector methodComments;

    public static void storeComment(Token token) {
        comments = new Vector();

        // if no special tokens
        if (token.specialToken == null) {
            if (token.image != null) comments.addElement(token.image);
            return;
        }

        // walk back to the start, just after the last regular token
        Token t = token.specialToken;
        while (t.specialToken != null) {
            t = t.specialToken;
        }

        // walk forwards and fill vector of comments
        while (t != null) {
            comments.addElement(t.image);
            t = t.next;
        }
    }

    private static void msg(String s) {
        System.out.println(id + " Version " + vers +": " + s);
    }

    public static void main(String args[]) {

        if (args.length < 1) {
            msg("Usage: java " + id + " inputfiles");
            return;
        }

        for (int i=0; i<args.length; i++) {

            try {
                msg("Reading from file " + args[i] + " . . .");

                Parser parser = new CPlusPlusParser(args[i]);
                parser.parse();
            } catch (FileNotFoundException e) {
                msg("File " + args[i] + " not found.");
            } catch (org.freehep.jaco.rtti.ParseException e) {
                msg(e.getMessage());
            }
        }

        addGlobalClasses();

        System.out.println(Jaco.getRTTI().toString("package_prefix"));
    }


    // keeps global methods in a Vector, hashed by dotted namespace name in a Hashtable
    // keeps being available across new Parsers
    private static Hashtable staticMethods = new Hashtable();
    private static final String defaultNamespace = "";      // should be empty

    /**
     * adds a global method in the default namespace
     */
    static void addGlobalMethod(IMethod method) {
        addGlobalMethod(method, defaultNamespace);
    }

    /**
     * adds a global method in a namespace
     */
    static void addGlobalMethod(IMethod method, String name) {
        Vector m;
        if ((m = (Vector)staticMethods.get(name)) == null) {
            m = new Vector();
            staticMethods.put(name, m);
        }

        // FIXME: what if it is already defined!
        m.addElement(method);
    }

    /**
     * adds all the Global classes to the RTTI
     */
    static void addGlobalClasses() {
        for (Enumeration e=staticMethods.keys(); e.hasMoreElements(); ) {
            String ns = (String)e.nextElement();

            Vector methods = (Vector)staticMethods.get(ns);

            // create global class
            Jaco.getRTTI().createClass("Globals", true,
                                       ns, null,
                                       null, null,
                                       null, null, null, methods, null);
        }
    }

    // keeps the namespace names
    private Stack namespace = new Stack();

    /**
     * return the current namespace in dotted format.
     */
    String getCurrentNamespace() {
        StringBuffer s = new StringBuffer(defaultNamespace);

        for (Enumeration e=namespace.elements(); e.hasMoreElements(); ) {
            if (s.length() != 0) s.append(".");
            s.append((String)e.nextElement());
        }

        return s.toString();
    }

  /**
   * A symbol table manager object. Currently only types are recorded for
   * doing semantic predicates for parsing.
   */
  SymtabManager sym = new SymtabManager();

  /*
   * Methods used in semantics predicates.
   */

  /**
   * Reads a fully qualified name (since it is used during lookahead, we
   * cannot use token. We have to explicitly use getToken).
   */
  String getFullyScopedName()
  {
     Token t = getToken(1);

     if (t.kind != ID && t.kind != SCOPE)
        return null;

     StringBuffer s = new StringBuffer();

     int i;
     if (t.kind != SCOPE)
     {
        s.append(t.image);
        t = getToken(2);
        i = 3;
     }
     else
        i = 2;

     while (t.kind == SCOPE)
     {
        s.append(t.image);
        s.append((t = getToken(i++)).image);
        t = getToken(i++);
     }

     return s.toString();
  }

  /**
   * This method first tries to read a sequence of tokens of the form
   *             ("::")? <ID> ("::" <ID>)*
   * and if it succeeds then asks the symbol table manager  if this is
   * the name of a constructor.
   */
  boolean isCtor()
  {
      return sym.isCtor(getFullyScopedName());
  }

  final public void translation_unit() throws ParseException {
  visibility = "global";
                          sym.openScope(null, false);
    declaration_list();
                          sym.closeScope();
    jj_consume_token(0);
  }

  final public void declaration_list() throws ParseException {
  comments = null; classComments = null; methodComments = null; visibility = "global";
    label_1:
    while (true) {
      if (jj_2_1(1)) {
        ;
      } else {
        break label_1;
      }
                      visibility = "global";
      if (jj_2_2(1)) {
        external_declaration();
      } else {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case NAMESPACE:
          namespace_definition();
          break;
        default:
          jj_la1[0] = jj_gen;
          if (jj_2_3(2)) {
            using_declaration();
          } else if (jj_2_4(2147483647)) {
            using_directive();
          } else {
            jj_consume_token(-1);
            throw new ParseException();
          }
        }
      }
                      visibility = "global";
    }
  }

  final public void namespace_definition() throws ParseException {
 String name = defaultNamespace; Token t;
    jj_consume_token(NAMESPACE);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case ID:
      t = jj_consume_token(ID);
                          name = t.image;
      break;
    default:
      jj_la1[1] = jj_gen;
      ;
    }
                          sym.openScope(name, false);
                          namespace.push(name);
    jj_consume_token(LCURLYBRACE);
    declaration_list();
    jj_consume_token(RCURLYBRACE);
                          namespace.pop();
                          sym.closeScope();
  }

  final public void namespace_alias_definition() throws ParseException {
  Token t;
    t = jj_consume_token(NAMESPACE);
    jj_consume_token(ID);
    jj_consume_token(ASSIGNEQUAL);
    namespace_name();
    jj_consume_token(SEMICOLON);
                          {if (true) throw new UnsupportedException("namespace alias definition NOT ALLOWED", t.beginLine);}
  }

// strictly this should always end in ::ID, but since the rule is easier like this, and this is not a compiler...
  final public void using_declaration() throws ParseException {
 String namespace;
    jj_consume_token(USING);
    namespace = namespace_name();
    jj_consume_token(SEMICOLON);
                          sym.putUsingName(namespace);
  }

  final public void using_directive() throws ParseException {
 String namespace; Token t;
    t = jj_consume_token(USING);
    jj_consume_token(NAMESPACE);
    namespace = namespace_name();
    jj_consume_token(SEMICOLON);
                          {if (true) throw new UnsupportedException("using directive NOT ALLOWED", t.beginLine);}
  }

  final public String namespace_name() throws ParseException {
 String namespace = ""; Token t;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case SCOPE:
      jj_consume_token(SCOPE);
                          namespace += "::";
      break;
    default:
      jj_la1[2] = jj_gen;
      ;
    }
    t = jj_consume_token(ID);
                          namespace += t.image;
    label_2:
    while (true) {
      if (jj_2_5(2147483647)) {
        ;
      } else {
        break label_2;
      }
      jj_consume_token(SCOPE);
      t = jj_consume_token(ID);
                          namespace += "::"+t.image;
    }
                          {if (true) return namespace;}
    throw new Error("Missing return statement in function");
  }

  final public void external_declaration() throws ParseException {
  Declaration declaration; Vector constructors = new Vector(); Vector methods = new Vector();
    if (jj_2_9(2147483647)) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case TEMPLATE:
        template_head();
        break;
      default:
        jj_la1[3] = jj_gen;
        ;
      }
      declaration();
    } else if (jj_2_10(2147483647)) {
      enum_specifier();
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case LPARENTHESIS:
      case SCOPE:
      case AMPERSAND:
      case STAR:
      case TILDE:
      case OPERATOR:
      case ID:
        init_declarator_list(false);
        break;
      default:
        jj_la1[4] = jj_gen;
        ;
      }
      jj_consume_token(SEMICOLON);
    } else if (jj_2_11(2147483647)) {
      dtor_definition();
    } else if (jj_2_12(2147483647)) {
      ctor_definition(constructors);
    } else if (jj_2_13(2147483647)) {
      function_definition(methods);
    } else if (jj_2_14(2147483647)) {
      conversion_function_decl_or_def();
    } else {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case TEMPLATE:
        template_head();
        if (jj_2_6(2147483647)) {
          ctor_definition(constructors);
        } else if (jj_2_7(2147483647)) {
          function_definition(methods);
        } else if (jj_2_8(1)) {
          declaration = declaration_specifiers();
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case LPARENTHESIS:
          case SCOPE:
          case AMPERSAND:
          case STAR:
          case TILDE:
          case OPERATOR:
          case ID:
            init_declarator_list(declaration.isTypedef);
            break;
          default:
            jj_la1[5] = jj_gen;
            ;
          }
          jj_consume_token(SEMICOLON);
        } else {
          jj_consume_token(-1);
          throw new ParseException();
        }
        break;
      default:
        jj_la1[6] = jj_gen;
        if (jj_2_15(1)) {
          declaration();
        } else {
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case SEMICOLON:
            jj_consume_token(SEMICOLON);
            break;
          default:
            jj_la1[7] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
        }
      }
    }
  }

  final public void function_definition(Vector methods) throws ParseException {
   Scope sc = null;
   Declaration declaration;
    if (jj_2_16(3)) {
      declaration = declaration_specifiers();
      sc = function_declarator(declaration.isTypedef, declaration, methods);
      func_decl_def(sc);
    } else {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case SCOPE:
      case AMPERSAND:
      case STAR:
      case OPERATOR:
      case ID:
        sc = function_declarator(false, null, methods);
        func_decl_def(sc);
        break;
      default:
        jj_la1[8] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
  }

  final public void func_decl_def(Scope sc) throws ParseException {
   boolean closeReqd = false;
     if (closeReqd = (sc != null && sc != sym.getCurScope()))
        sym.openScope(sc);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case SEMICOLON:
      jj_consume_token(SEMICOLON);
      break;
    case LCURLYBRACE:
      compound_statement();
      break;
    default:
      jj_la1[9] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    if (closeReqd) sym.closeScope();
  }

  final public void linkage_specification() throws ParseException {
    jj_consume_token(EXTERN);
    jj_consume_token(STRING);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case LCURLYBRACE:
      jj_consume_token(LCURLYBRACE);
      label_3:
      while (true) {
        if (jj_2_17(1)) {
          ;
        } else {
          break label_3;
        }
        external_declaration();
      }
      jj_consume_token(RCURLYBRACE);
      if (jj_2_18(2147483647)) {
        jj_consume_token(SEMICOLON);
      } else {
        ;
      }
      break;
    default:
      jj_la1[10] = jj_gen;
      if (jj_2_19(1)) {
        declaration();
      } else {
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
  }

  final public void declaration() throws ParseException {
  Declaration declaration;
    if (jj_2_20(2)) {
      declaration = declaration_specifiers();
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case LPARENTHESIS:
      case SCOPE:
      case AMPERSAND:
      case STAR:
      case TILDE:
      case OPERATOR:
      case ID:
        init_declarator_list(declaration.isTypedef);
        break;
      default:
        jj_la1[11] = jj_gen;
        ;
      }
      jj_consume_token(SEMICOLON);
    } else {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case EXTERN:
        linkage_specification();
        break;
      default:
        jj_la1[12] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
  }

/**
 * Very temporary. Just returns true if it sees a typedef. Finally, we will
 * need a structure that stores all the attributes.
 */
  final public Modifiers type_modifiers() throws ParseException {
  Modifiers modifiers = new Modifiers();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case AUTO:
    case EXTERN:
    case REGISTER:
    case STATIC:
    case TYPEDEF:
      storage_class_specifier(modifiers);
      break;
    case CONST:
    case VOLATILE:
      type_qualifier();
      break;
    case INLINE:
      jj_consume_token(INLINE);
      break;
    case VIRTUAL:
      jj_consume_token(VIRTUAL);
      break;
    case FRIEND:
      jj_consume_token(FRIEND);
      break;
    default:
      jj_la1[13] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
     {if (true) return modifiers;}
    throw new Error("Missing return statement in function");
  }

/**
 * Very temporary. Just returns true if it sees a typedef. Finally, we will
 * need a structure that stores all the attributes.
 */
  final public Declaration declaration_specifiers() throws ParseException {
   Token t;
   Declaration dec = new Declaration();
   dec.name = "neverSet";
   dec.isStatic = false;
   dec.isTypedef = false;
   dec.isClass = false;
   Modifiers modifiers;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case AUTO:
    case CONST:
    case EXTERN:
    case FRIEND:
    case INLINE:
    case REGISTER:
    case STATIC:
    case TYPEDEF:
    case VIRTUAL:
    case VOLATILE:
      label_4:
      while (true) {
        modifiers = type_modifiers();
                                          dec.isTypedef |= modifiers.isTypedef;
                                          dec.isStatic = modifiers.isStatic;
        if (jj_2_21(2147483647)) {
          ;
        } else {
          break label_4;
        }
      }
      if (jj_2_29(2)) {
        if (jj_2_27(2147483647)) {
          dec.name = builtin_type_specifier();
          label_5:
          while (true) {
            if (jj_2_22(2)) {
              ;
            } else {
              break label_5;
            }
            if (jj_2_23(2147483647)) {
              dec.name = builtin_type_specifier();
            } else if (jj_2_24(2147483647)) {
              modifiers = type_modifiers();
            } else {
              jj_consume_token(-1);
              throw new ParseException();
            }
                                          dec.isTypedef |= modifiers.isTypedef;
                                          dec.isStatic = modifiers.isStatic;
          }
        } else if (jj_2_28(1)) {
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case STRUCT:
          case CLASS:
          case UNION:
            dec.name = class_specifier();
            break;
          case ENUM:
            enum_specifier();
            break;
          default:
            jj_la1[14] = jj_gen;
            if (jj_2_25(1)) {
              dec.name = qualified_type();
            } else {
              jj_consume_token(-1);
              throw new ParseException();
            }
          }
          label_6:
          while (true) {
            if (jj_2_26(2)) {
              ;
            } else {
              break label_6;
            }
            modifiers = type_modifiers();
                                          dec.isTypedef |= modifiers.isTypedef;
                                          dec.isStatic = modifiers.isStatic;
          }
                          dec.isClass = true;
        } else {
          jj_consume_token(-1);
          throw new ParseException();
        }
      } else {
        ;
      }
      break;
    default:
      jj_la1[17] = jj_gen;
      if (jj_2_34(2147483647)) {
        dec.name = builtin_type_specifier();
        label_7:
        while (true) {
          if (jj_2_30(2)) {
            ;
          } else {
            break label_7;
          }
          if (jj_2_31(2147483647)) {
            dec.name = builtin_type_specifier();
          } else {
            switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
            case AUTO:
            case CONST:
            case EXTERN:
            case FRIEND:
            case INLINE:
            case REGISTER:
            case STATIC:
            case TYPEDEF:
            case VIRTUAL:
            case VOLATILE:
              modifiers = type_modifiers();
                                          dec.isTypedef |= modifiers.isTypedef;
                                          dec.isStatic = modifiers.isStatic;
              break;
            default:
              jj_la1[15] = jj_gen;
              jj_consume_token(-1);
              throw new ParseException();
            }
          }
        }
      } else if (jj_2_35(1)) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case STRUCT:
        case CLASS:
        case UNION:
          dec.name = class_specifier();
          break;
        case ENUM:
          enum_specifier();
          break;
        default:
          jj_la1[16] = jj_gen;
          if (jj_2_32(1)) {
            dec.name = qualified_type();
          } else {
            jj_consume_token(-1);
            throw new ParseException();
          }
        }
        label_8:
        while (true) {
          if (jj_2_33(2)) {
            ;
          } else {
            break label_8;
          }
          modifiers = type_modifiers();
                                          dec.isTypedef |= modifiers.isTypedef;
                                          dec.isStatic = modifiers.isStatic;
        }
                          dec.isClass = true;
      } else {
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
   {if (true) return dec;}
    throw new Error("Missing return statement in function");
  }

/*
void type_specifier() :
{}
{
    simple_type_specifier()
   |
    class_specifier()
   |
    enum_specifier()
}
*/
  final public void simple_type_specifier() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case CHAR:
    case DOUBLE:
    case FLOAT:
    case INT:
    case LONG:
    case SHORT:
    case SIGNED:
    case UNSIGNED:
    case VOID:
    case 141:
      builtin_type_specifier();
      break;
    default:
      jj_la1[18] = jj_gen;
      if (jj_2_36(1)) {
        qualified_type();
      } else {
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
  }

  final public void scope_override_lookahead() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case SCOPE:
      jj_consume_token(SCOPE);
      break;
    case ID:
      jj_consume_token(ID);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case LESSTHAN:
        jj_consume_token(LESSTHAN);
        template_argument_list();
        jj_consume_token(GREATERTHAN);
        break;
      default:
        jj_la1[19] = jj_gen;
        ;
      }
      jj_consume_token(SCOPE);
      break;
    default:
      jj_la1[20] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

  final public String scope_override() throws ParseException {
   String name = "";
   Token t;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case SCOPE:
      jj_consume_token(SCOPE);
              name += "::";
      label_9:
      while (true) {
        if (jj_2_37(2)) {
          ;
        } else {
          break label_9;
        }
        t = jj_consume_token(ID);
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case LESSTHAN:
          jj_consume_token(LESSTHAN);
          template_argument_list();
          jj_consume_token(GREATERTHAN);
          break;
        default:
          jj_la1[21] = jj_gen;
          ;
        }
        jj_consume_token(SCOPE);
                     name += t.image + "::";
      }
      break;
    case ID:
      label_10:
      while (true) {
        t = jj_consume_token(ID);
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case LESSTHAN:
          jj_consume_token(LESSTHAN);
          template_argument_list();
          jj_consume_token(GREATERTHAN);
          break;
        default:
          jj_la1[22] = jj_gen;
          ;
        }
        jj_consume_token(SCOPE);
                     name += t.image + "::";
        if (jj_2_38(2)) {
          ;
        } else {
          break label_10;
        }
      }
      break;
    default:
      jj_la1[23] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    {if (true) return name;}
    throw new Error("Missing return statement in function");
  }

  final public String qualified_id() throws ParseException {
   String name = "";
   Token t;
    if (jj_2_39(2147483647)) {
      name = scope_override();
    } else {
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case ID:
      t = jj_consume_token(ID);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case LESSTHAN:
        jj_consume_token(LESSTHAN);
        template_argument_list();
        jj_consume_token(GREATERTHAN);
        break;
      default:
        jj_la1[24] = jj_gen;
        ;
      }
        {if (true) return name + t.image;}
      break;
    case OPERATOR:
      jj_consume_token(OPERATOR);
      optor();
                           {if (true) return "operator";}
      break;
    default:
      jj_la1[25] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

  final public void ptr_to_member() throws ParseException {
    scope_override();
    jj_consume_token(STAR);
  }

//
//  (MD) we ignore the scoped name here since we assume that all names are valid
//  (previous)  LOOKAHEAD({ sym.isFullyScopedTypeName(getFullyScopedName()) } )
  final public String qualified_type() throws ParseException {
  String name;
    if (true) {

    } else {
      jj_consume_token(-1);
      throw new ParseException();
    }
    name = qualified_id();
                          {if (true) return sym.getName(name);}
    throw new Error("Missing return statement in function");
  }

  final public void type_qualifier() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case CONST:
      jj_consume_token(CONST);
      break;
    case VOLATILE:
      jj_consume_token(VOLATILE);
      break;
    default:
      jj_la1[26] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

/**
 * Very temporary. Just returns true if it sees a typedef. Finally, we will
 * need a structure that stores all the attributes.
 */
  final public void storage_class_specifier(Modifiers modifiers) throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case AUTO:
    case EXTERN:
    case REGISTER:
    case STATIC:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case AUTO:
        jj_consume_token(AUTO);
        break;
      case REGISTER:
        jj_consume_token(REGISTER);
        break;
      case STATIC:
        jj_consume_token(STATIC);
                  modifiers.isStatic = true;
        break;
      case EXTERN:
        jj_consume_token(EXTERN);
        break;
      default:
        jj_la1[27] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
    case TYPEDEF:
      jj_consume_token(TYPEDEF);
                  modifiers.isTypedef = true;
      break;
    default:
      jj_la1[28] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

  final public String builtin_type_specifier() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case VOID:
      jj_consume_token(VOID);
              {if (true) return getToken(0).image;}
      break;
    case 141:
      jj_consume_token(141);
              {if (true) return getToken(0).image;}
      break;
    case CHAR:
      jj_consume_token(CHAR);
              {if (true) return getToken(0).image;}
      break;
    case SHORT:
      jj_consume_token(SHORT);
              {if (true) return getToken(0).image;}
      break;
    case INT:
      jj_consume_token(INT);
              {if (true) return getToken(0).image;}
      break;
    case LONG:
      jj_consume_token(LONG);
              {if (true) return getToken(0).image;}
      break;
    case FLOAT:
      jj_consume_token(FLOAT);
              {if (true) return getToken(0).image;}
      break;
    case DOUBLE:
      jj_consume_token(DOUBLE);
              {if (true) return getToken(0).image;}
      break;
    case SIGNED:
      jj_consume_token(SIGNED);
              {if (true) return getToken(0).image;}
      break;
    case UNSIGNED:
      jj_consume_token(UNSIGNED);
              {if (true) return getToken(0).image;}
      break;
    default:
      jj_la1[29] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

  final public void init_declarator_list(boolean isTypedef) throws ParseException {
    init_declarator(isTypedef);
    label_11:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case COMMA:
        ;
        break;
      default:
        jj_la1[30] = jj_gen;
        break label_11;
      }
      jj_consume_token(COMMA);
      init_declarator(isTypedef);
    }
  }

  final public void init_declarator(boolean isTypedef) throws ParseException {
  Declarator declarator;
    declarator = declarator();
      if (isTypedef)
         sym.putTypeName(declarator.name);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case LPARENTHESIS:
    case ASSIGNEQUAL:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case ASSIGNEQUAL:
        jj_consume_token(ASSIGNEQUAL);
        initializer();
        break;
      case LPARENTHESIS:
        jj_consume_token(LPARENTHESIS);
        expression_list();
        jj_consume_token(RPARENTHESIS);
        break;
      default:
        jj_la1[31] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
    default:
      jj_la1[32] = jj_gen;
      ;
    }
  }

  final public void class_head() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case STRUCT:
      jj_consume_token(STRUCT);
      break;
    case UNION:
      jj_consume_token(UNION);
      break;
    case CLASS:
      jj_consume_token(CLASS);
      break;
    default:
      jj_la1[33] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case ID:
      jj_consume_token(ID);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case COLON:
        base_clause(null);
        break;
      default:
        jj_la1[34] = jj_gen;
        ;
      }
      break;
    default:
      jj_la1[35] = jj_gen;
      ;
    }
  }

  final public String class_specifier() throws ParseException {
   Vector superclasses = null;
   Vector constructors = new Vector();
   Vector methods = new Vector();
   ClassScope sc = null;
   Token t;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case STRUCT:
      jj_consume_token(STRUCT);
      break;
    case UNION:
      jj_consume_token(UNION);
      break;
    case CLASS:
      jj_consume_token(CLASS);
      break;
    default:
      jj_la1[36] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
                      classComments = comments; comments = null;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case LCURLYBRACE:
      jj_consume_token(LCURLYBRACE);
           sym.openScope(null, false);
      label_12:
      while (true) {
        if (jj_2_40(1)) {
          ;
        } else {
          break label_12;
        }
        member_declaration(constructors, methods);
      }
      jj_consume_token(RCURLYBRACE);
           sym.closeScope();
           {if (true) return null;}
      break;
    default:
      jj_la1[38] = jj_gen;
      if (jj_2_43(2)) {
        t = jj_consume_token(ID);
        sc = (ClassScope)sym.openScope(t.image, true);
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case COLON:
          superclasses = base_clause(sc);
          break;
        default:
          jj_la1[37] = jj_gen;
          ;
        }
        jj_consume_token(LCURLYBRACE);
        label_13:
        while (true) {
          if (jj_2_41(1)) {
            ;
          } else {
            break label_13;
          }
          member_declaration(constructors, methods);
        }
        jj_consume_token(RCURLYBRACE);
           sym.closeScope();
                      Jaco.getRTTI().createClass(t.image, true,
                                                 getCurrentNamespace(), null,
                                                 classComments, null,
                                                 superclasses, constructors, null, methods, null);
                      comments = null;
                      methodComments = null;
                      classComments = null;
                      {if (true) return null;}
      } else {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case ID:
          t = jj_consume_token(ID);
          if (jj_2_42(2)) {
            jj_consume_token(LESSTHAN);
            template_argument_list();
            jj_consume_token(GREATERTHAN);
          } else {
            ;
          }
                      sym.putTypeName(t.image);
                      {if (true) return t.image;}
          break;
        default:
          jj_la1[39] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
    }
    throw new Error("Missing return statement in function");
  }

  final public Vector base_clause(ClassScope scope) throws ParseException {
  Vector superclasses = new Vector(); String className;
    jj_consume_token(COLON);
    className = base_specifier(scope);
                  superclasses.addElement(className);
    label_14:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case COMMA:
        ;
        break;
      default:
        jj_la1[40] = jj_gen;
        break label_14;
      }
      jj_consume_token(COMMA);
      className = base_specifier(scope);
                  superclasses.addElement(className);
    }
                  {if (true) return superclasses;}
    throw new Error("Missing return statement in function");
  }

  final public String base_specifier(ClassScope scope) throws ParseException {
  Token t;
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case PRIVATE:
    case PROTECTED:
    case PUBLIC:
    case VIRTUAL:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case VIRTUAL:
        jj_consume_token(VIRTUAL);
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case PRIVATE:
        case PROTECTED:
        case PUBLIC:
          access_specifier();
          break;
        default:
          jj_la1[41] = jj_gen;
          ;
        }
        break;
      case PRIVATE:
      case PROTECTED:
      case PUBLIC:
        access_specifier();
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case VIRTUAL:
          jj_consume_token(VIRTUAL);
          break;
        default:
          jj_la1[42] = jj_gen;
          ;
        }
        break;
      default:
        jj_la1[43] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
    default:
      jj_la1[44] = jj_gen;
      ;
    }
    if (jj_2_44(2147483647)) {
      scope_override();
    } else {
      ;
    }
    t = jj_consume_token(ID);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case LESSTHAN:
      jj_consume_token(LESSTHAN);
      template_argument_list();
      jj_consume_token(GREATERTHAN);
      break;
    default:
      jj_la1[45] = jj_gen;
      ;
    }
      scope.addSuper(sym.getScope(t.image));
      {if (true) return t.image;}
    throw new Error("Missing return statement in function");
  }

  final public String access_specifier() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case PUBLIC:
      jj_consume_token(PUBLIC);
                      {if (true) return "public";}
      break;
    case PROTECTED:
      jj_consume_token(PROTECTED);
                      {if (true) return "protected";}
      break;
    case PRIVATE:
      jj_consume_token(PRIVATE);
                      {if (true) return "private";}
      break;
    default:
      jj_la1[46] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
    throw new Error("Missing return statement in function");
  }

  final public void member_declaration(Vector constructors, Vector methods) throws ParseException {
  Declaration declaration;
    if (jj_2_45(2147483647)) {
      using_declaration();
    } else if (jj_2_46(2147483647)) {
      declaration();
    } else if (jj_2_47(2147483647)) {
      enum_specifier();
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case LPARENTHESIS:
      case SCOPE:
      case AMPERSAND:
      case STAR:
      case TILDE:
      case OPERATOR:
      case ID:
        member_declarator_list(false);
        break;
      default:
        jj_la1[47] = jj_gen;
        ;
      }
      jj_consume_token(SEMICOLON);
    } else if (jj_2_48(2147483647)) {
      conversion_function_decl_or_def();
    } else if (jj_2_49(2147483647)) {
      dtor_definition();
    } else if (jj_2_50(2147483647)) {
      dtor_ctor_decl_spec();
      simple_dtor_declarator();
      jj_consume_token(SEMICOLON);
    } else if (jj_2_51(2147483647)) {
      ctor_definition(constructors);
    } else if (jj_2_52(2147483647)) {
      dtor_ctor_decl_spec();
      ctor_declarator(constructors);
      jj_consume_token(SEMICOLON);
    } else if (jj_2_53(2147483647)) {
      function_definition(methods);
    } else if (jj_2_54(2147483647)) {
      declaration = declaration_specifiers();
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case LPARENTHESIS:
      case SCOPE:
      case AMPERSAND:
      case STAR:
      case TILDE:
      case OPERATOR:
      case ID:
        member_declarator_list(declaration.isTypedef);
        break;
      default:
        jj_la1[48] = jj_gen;
        ;
      }
      jj_consume_token(SEMICOLON);
    } else if (jj_2_55(2147483647)) {
      function_declarator(false, null, methods);
      jj_consume_token(SEMICOLON);
    } else if (jj_2_56(3)) {
      qualified_id();
      jj_consume_token(SEMICOLON);
    } else {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case PRIVATE:
      case PROTECTED:
      case PUBLIC:
        visibility = access_specifier();
        jj_consume_token(COLON);
        break;
      case SEMICOLON:
        jj_consume_token(SEMICOLON);
        break;
      default:
        jj_la1[49] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
  }

  final public void member_declarator_list(boolean isTypedef) throws ParseException {
    member_declarator(isTypedef);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case ASSIGNEQUAL:
      jj_consume_token(ASSIGNEQUAL);
      jj_consume_token(OCTALINT);
      break;
    default:
      jj_la1[50] = jj_gen;
      ;
    }
    label_15:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case COMMA:
        ;
        break;
      default:
        jj_la1[51] = jj_gen;
        break label_15;
      }
      jj_consume_token(COMMA);
      member_declarator(isTypedef);
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case ASSIGNEQUAL:
        jj_consume_token(ASSIGNEQUAL);
        jj_consume_token(OCTALINT);
        break;
      default:
        jj_la1[52] = jj_gen;
        ;
      }
    }
  }

  final public void member_declarator(boolean isTypedef) throws ParseException {
  Declarator declarator;
    declarator = declarator();
      if (isTypedef)
         sym.putTypeName(declarator.name);
  }

  final public void conversion_function_decl_or_def() throws ParseException {
   Scope sc = null;
   String name = null;
    if (jj_2_57(2147483647)) {
      name = scope_override();
    } else {
      ;
    }
    jj_consume_token(OPERATOR);
    declaration_specifiers();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case AMPERSAND:
    case STAR:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case STAR:
        jj_consume_token(STAR);
        break;
      case AMPERSAND:
        jj_consume_token(AMPERSAND);
        break;
      default:
        jj_la1[53] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
    default:
      jj_la1[54] = jj_gen;
      ;
    }
    jj_consume_token(LPARENTHESIS);
    if (jj_2_58(1)) {
      parameter_list();
    } else {
      ;
    }
    jj_consume_token(RPARENTHESIS);
    if (jj_2_59(2)) {
      type_qualifier();
    } else {
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case THROW:
      exception_spec();
      break;
    default:
      jj_la1[55] = jj_gen;
      ;
    }
    func_decl_def(null);
  }

  final public void enum_specifier() throws ParseException {
  Token t;
    jj_consume_token(ENUM);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case LCURLYBRACE:
      jj_consume_token(LCURLYBRACE);
      enumerator_list();
      jj_consume_token(RCURLYBRACE);
      break;
    case ID:
      t = jj_consume_token(ID);
      if (jj_2_60(2)) {
        jj_consume_token(LCURLYBRACE);
        enumerator_list();
        jj_consume_token(RCURLYBRACE);
      } else {
        ;
      }
             sym.putTypeName(t.image);
      break;
    default:
      jj_la1[56] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

  final public void enumerator_list() throws ParseException {
    enumerator();
    label_16:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case COMMA:
        ;
        break;
      default:
        jj_la1[57] = jj_gen;
        break label_16;
      }
      jj_consume_token(COMMA);
      enumerator();
    }
  }

  final public void enumerator() throws ParseException {
    jj_consume_token(ID);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case ASSIGNEQUAL:
      jj_consume_token(ASSIGNEQUAL);
      constant_expression();
      break;
    default:
      jj_la1[58] = jj_gen;
      ;
    }
  }

  final public void ptr_operator(Declaration declaration) throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case AMPERSAND:
      jj_consume_token(AMPERSAND);
      cv_qualifier_seq();
                  declaration.isReference = true;
      break;
    case STAR:
      jj_consume_token(STAR);
      cv_qualifier_seq();
                  declaration.pointer++;
      break;
    case SCOPE:
    case ID:
      ptr_to_member();
      cv_qualifier_seq();
                  declaration.pointer++;
      break;
    default:
      jj_la1[59] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

  final public void cv_qualifier_seq() throws ParseException {
    if (jj_2_63(2)) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case CONST:
        jj_consume_token(CONST);
        if (jj_2_61(2)) {
          jj_consume_token(VOLATILE);
        } else {
          ;
        }
        break;
      case VOLATILE:
        jj_consume_token(VOLATILE);
        if (jj_2_62(2)) {
          jj_consume_token(CONST);
        } else {
          ;
        }
        break;
      default:
        jj_la1[60] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    } else {
      ;
    }
  }

  final public Declarator declarator() throws ParseException {
  Declarator declarator; Declaration declaration = new Declaration(); Declaration dummy = new Declaration();
    if (jj_2_64(2147483647)) {
      ptr_operator(declaration);
      declarator = declarator();
                    declarator.isReference = declaration.isReference;
                    declarator.pointer = declaration.pointer;
    } else {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case LPARENTHESIS:
      case SCOPE:
      case TILDE:
      case OPERATOR:
      case ID:
        declarator = direct_declarator();
        break;
      default:
        jj_la1[61] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    {if (true) return declarator;}
    throw new Error("Missing return statement in function");
  }

  final public Declarator direct_declarator() throws ParseException {
   String name;
   Token t;
   Declarator declarator = new Declarator();
    if (jj_2_68(2)) {
      jj_consume_token(TILDE);
      t = jj_consume_token(ID);
      if (jj_2_65(2)) {
        declarator_suffixes();
      } else {
        ;
      }
          declarator.name = "~" + t.image;
          {if (true) return declarator;}
    } else {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case LPARENTHESIS:
        jj_consume_token(LPARENTHESIS);
        declarator = declarator();
        jj_consume_token(RPARENTHESIS);
        if (jj_2_66(2)) {
          declarator_suffixes();
        } else {
          ;
        }
          {if (true) return declarator;}
        break;
      case SCOPE:
      case OPERATOR:
      case ID:
        name = qualified_id();
        if (jj_2_67(2)) {
          declarator_suffixes();
        } else {
          ;
        }
      declarator.name = name;
      {if (true) return declarator;}
        break;
      default:
        jj_la1[62] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    throw new Error("Missing return statement in function");
  }

  final public void declarator_suffixes() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case LSQUAREBRACKET:
      label_17:
      while (true) {
        jj_consume_token(LSQUAREBRACKET);
        if (jj_2_69(1)) {
          constant_expression();
        } else {
          ;
        }
        jj_consume_token(RSQUAREBRACKET);
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case LSQUAREBRACKET:
          ;
          break;
        default:
          jj_la1[63] = jj_gen;
          break label_17;
        }
      }
      break;
    case LPARENTHESIS:
      jj_consume_token(LPARENTHESIS);
      if (jj_2_70(1)) {
        parameter_list();
      } else {
        ;
      }
      jj_consume_token(RPARENTHESIS);
      if (jj_2_71(2)) {
        type_qualifier();
      } else {
        ;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case THROW:
        exception_spec();
        break;
      default:
        jj_la1[64] = jj_gen;
        ;
      }
      break;
    default:
      jj_la1[65] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

/**
 * Used only for lookahead.
 */
  final public void function_declarator_lookahead() throws ParseException {
  Declaration dummy = new Declaration();
    label_18:
    while (true) {
      if (jj_2_72(2)) {
        ;
      } else {
        break label_18;
      }
      ptr_operator(dummy);
    }
    qualified_id();
    jj_consume_token(LPARENTHESIS);
  }

  final public Scope function_declarator(boolean isTypedef, Declaration returnDec, Vector methods) throws ParseException {
  Scope sc = null; int pointer; Declaration dummy = new Declaration();
    if (jj_2_73(2147483647)) {
      ptr_operator(returnDec);
      sc = function_declarator(isTypedef, returnDec, methods);
    } else {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case SCOPE:
      case OPERATOR:
      case ID:
        sc = function_direct_declarator(isTypedef, returnDec, methods);
        break;
      default:
        jj_la1[66] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    {if (true) return sc;}
    throw new Error("Missing return statement in function");
  }

  final public Scope function_direct_declarator(boolean isTypedef, Declaration returnDec, Vector methods) throws ParseException {
  Vector parameterList = null;
  String name;
  Scope sc = null;
  boolean closeReqd = false;
  methodComments = comments; comments = null;
    name = qualified_id();
        sc = sym.getScopeOfFullyScopedName(name);

        if (closeReqd = (sc != null && sc != sym.getCurScope()))
           sym.openScope(sc);
    jj_consume_token(LPARENTHESIS);
    if (jj_2_74(1)) {
      parameterList = parameter_list();
    } else {
      ;
    }
    jj_consume_token(RPARENTHESIS);
    if (jj_2_75(2)) {
      type_qualifier();
    } else {
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case THROW:
      exception_spec();
      break;
    default:
      jj_la1[67] = jj_gen;
      ;
    }
    if (jj_2_76(2147483647)) {
      jj_consume_token(ASSIGNEQUAL);
      jj_consume_token(OCTALINT);
    } else {
      ;
    }
        // FIXME: does not handle typedefs, arrays...
        // FIXME: check that an undeclared return is an int!!!
        IType type = (returnDec == null) ? Jaco.getRTTI().createType("int", false, true, false, 0, 0, null)
                        : Jaco.getRTTI().createType(returnDec.name, false, !returnDec.isClass, returnDec.isReference, returnDec.pointer, 0, null);
        if (visibility.equals("public")) {
            methods.addElement(Jaco.getRTTI().createMethod(name, methodComments, returnDec.isStatic, type, false, parameterList, null));
        } else if (visibility.equals("global")) {
            addGlobalMethod(Jaco.getRTTI().createMethod(name, methodComments, true, type, false, parameterList, null), getCurrentNamespace());
        }

        comments = null;
        methodComments = null;
        if (closeReqd)
           sym.closeScope();

        if (isTypedef)
           sym.putTypeName(name);

        {if (true) return sc;}
    throw new Error("Missing return statement in function");
  }

  final public void dtor_ctor_decl_spec() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case INLINE:
    case VIRTUAL:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case VIRTUAL:
        jj_consume_token(VIRTUAL);
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case INLINE:
          jj_consume_token(INLINE);
          break;
        default:
          jj_la1[68] = jj_gen;
          ;
        }
        break;
      case INLINE:
        jj_consume_token(INLINE);
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case VIRTUAL:
          jj_consume_token(VIRTUAL);
          break;
        default:
          jj_la1[69] = jj_gen;
          ;
        }
        break;
      default:
        jj_la1[70] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      break;
    default:
      jj_la1[71] = jj_gen;
      ;
    }
  }

  final public void dtor_definition() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case TEMPLATE:
      template_head();
      break;
    default:
      jj_la1[72] = jj_gen;
      ;
    }
    dtor_ctor_decl_spec();
    dtor_declarator();
    compound_statement();
  }

  final public void ctor_definition(Vector constructors) throws ParseException {
   Scope sc = null;
   boolean closeReqd = false;
    dtor_ctor_decl_spec();
    sc = ctor_declarator(constructors);
      if (closeReqd = (sc != null && sc != sym.getCurScope()))
         sym.openScope(sc);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case THROW:
      exception_spec();
      break;
    default:
      jj_la1[73] = jj_gen;
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case SEMICOLON:
      jj_consume_token(SEMICOLON);
      break;
    case LCURLYBRACE:
    case COLON:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case COLON:
        ctor_initializer();
        break;
      default:
        jj_la1[74] = jj_gen;
        ;
      }
      compound_statement();
      break;
    default:
      jj_la1[75] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
     if (closeReqd) sym.closeScope();
  }

  final public void ctor_declarator_lookahead() throws ParseException {
    if (isCtor()) {

    } else {
      jj_consume_token(-1);
      throw new ParseException();
    }
    qualified_id();
    jj_consume_token(LPARENTHESIS);
  }

  final public Scope ctor_declarator(Vector constructors) throws ParseException {
  String name;
  Vector parameterList = null;
  Scope sc = null;
  boolean closeReqd = false;
  methodComments = comments;
    if (isCtor()) {

    } else {
      jj_consume_token(-1);
      throw new ParseException();
    }
    name = qualified_id();
        sc = sym.getScopeOfFullyScopedName(name);

        if (closeReqd = (sc != null && sc != sym.getCurScope()))
           sym.openScope(sc);
    jj_consume_token(LPARENTHESIS);
    if (jj_2_77(2)) {
      parameterList = parameter_list();
    } else {
      ;
    }
    jj_consume_token(RPARENTHESIS);
    if (jj_2_78(2)) {
      exception_spec();
    } else {
      ;
    }
        if (visibility.equals("public")) {
            constructors.addElement(Jaco.getRTTI().createConstructor(name, comments, parameterList, null));
            methodComments = null;
            comments = null;
        }

        if (closeReqd)
           sym.closeScope();

        {if (true) return sc;}
    throw new Error("Missing return statement in function");
  }

  final public void ctor_initializer() throws ParseException {
    jj_consume_token(COLON);
    superclass_init();
    label_19:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case COMMA:
        ;
        break;
      default:
        jj_la1[76] = jj_gen;
        break label_19;
      }
      jj_consume_token(COMMA);
      superclass_init();
    }
  }

  final public void superclass_init() throws ParseException {
    qualified_id();
    jj_consume_token(LPARENTHESIS);
    if (jj_2_79(1)) {
      expression_list();
    } else {
      ;
    }
    jj_consume_token(RPARENTHESIS);
  }

  final public void dtor_declarator() throws ParseException {
    if (jj_2_80(2147483647)) {
      scope_override();
    } else {
      ;
    }
    simple_dtor_declarator();
  }

  final public void simple_dtor_declarator() throws ParseException {
    jj_consume_token(TILDE);
    if (isCtor()) {

    } else {
      jj_consume_token(-1);
      throw new ParseException();
    }
    jj_consume_token(ID);
    jj_consume_token(LPARENTHESIS);
    if (jj_2_81(1)) {
      parameter_list();
    } else {
      ;
    }
    jj_consume_token(RPARENTHESIS);
  }

  final public Vector parameter_list() throws ParseException {
 Vector list;
    if (jj_2_83(1)) {
      list = parameter_declaration_list();
      if (jj_2_82(2)) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case COMMA:
          jj_consume_token(COMMA);
          break;
        default:
          jj_la1[77] = jj_gen;
          ;
        }
        jj_consume_token(ELLIPSIS);
      } else {
        ;
      }
                          {if (true) return list;}
    } else {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case ELLIPSIS:
        jj_consume_token(ELLIPSIS);
                          {if (true) return new Vector();}
        break;
      default:
        jj_la1[78] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
    throw new Error("Missing return statement in function");
  }

  final public Vector parameter_declaration_list() throws ParseException {
  INamedType namedType; Vector list = new Vector();
    namedType = parameter_declaration();
                          list.addElement(namedType);
    label_20:
    while (true) {
      if (jj_2_84(2)) {
        ;
      } else {
        break label_20;
      }
      jj_consume_token(COMMA);
      namedType = parameter_declaration();
                          list.addElement(namedType);
    }
                          {if (true) return list;}
    throw new Error("Missing return statement in function");
  }

  final public INamedType parameter_declaration() throws ParseException {
  Declaration declaration; Declarator declarator;
    declaration = declaration_specifiers();
    if (jj_2_85(2147483647)) {
      declarator = declarator();
    } else {
      abstract_declarator();
                          declarator = new Declarator();
                          declarator.name = "AbstractDeclarator !! Not Implemented";
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case ASSIGNEQUAL:
      jj_consume_token(ASSIGNEQUAL);
      assignment_expression();
      break;
    default:
      jj_la1[79] = jj_gen;
      ;
    }
                          // FIXME: this does not handle typedefs, arrays or name scopes!
                          IType type = Jaco.getRTTI().createType(declaration.name, false, !declaration.isClass, declaration.isReference, declarator.pointer, 0, null);
                          {if (true) return Jaco.getRTTI().createNamedType(declarator.name, type, null);}
    throw new Error("Missing return statement in function");
  }

  final public void initializer() throws ParseException {
    if (jj_2_86(3)) {
      jj_consume_token(LCURLYBRACE);
      initializer();
      label_21:
      while (true) {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case COMMA:
          ;
          break;
        default:
          jj_la1[80] = jj_gen;
          break label_21;
        }
        jj_consume_token(COMMA);
        initializer();
      }
      jj_consume_token(RCURLYBRACE);
    } else if (jj_2_87(1)) {
      assignment_expression();
    } else {
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

  final public void type_name() throws ParseException {
    declaration_specifiers();
    abstract_declarator();
  }

  final public void abstract_declarator() throws ParseException {
  Declaration dummy = new Declaration();
    if (jj_2_89(2)) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case LPARENTHESIS:
        jj_consume_token(LPARENTHESIS);
        abstract_declarator();
        jj_consume_token(RPARENTHESIS);
        label_22:
        while (true) {
          abstract_declarator_suffix();
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case LSQUAREBRACKET:
          case LPARENTHESIS:
            ;
            break;
          default:
            jj_la1[81] = jj_gen;
            break label_22;
          }
        }
        break;
      case LSQUAREBRACKET:
        label_23:
        while (true) {
          jj_consume_token(LSQUAREBRACKET);
          if (jj_2_88(1)) {
            constant_expression();
          } else {
            ;
          }
          jj_consume_token(RSQUAREBRACKET);
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case LSQUAREBRACKET:
            ;
            break;
          default:
            jj_la1[82] = jj_gen;
            break label_23;
          }
        }
        break;
      case SCOPE:
      case AMPERSAND:
      case STAR:
      case ID:
        ptr_operator(dummy);
        abstract_declarator();
        break;
      default:
        jj_la1[83] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    } else {
      ;
    }
  }

  final public void abstract_declarator_suffix() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case LSQUAREBRACKET:
      jj_consume_token(LSQUAREBRACKET);
      if (jj_2_90(1)) {
        constant_expression();
      } else {
        ;
      }
      jj_consume_token(RSQUAREBRACKET);
      break;
    case LPARENTHESIS:
      jj_consume_token(LPARENTHESIS);
      if (jj_2_91(1)) {
        parameter_list();
      } else {
        ;
      }
      jj_consume_token(RPARENTHESIS);
      break;
    default:
      jj_la1[84] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

  final public void template_head() throws ParseException {
    jj_consume_token(TEMPLATE);
    jj_consume_token(LESSTHAN);
    template_parameter_list();
    jj_consume_token(GREATERTHAN);
  }

  final public void template_parameter_list() throws ParseException {
    template_parameter();
    label_24:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case COMMA:
        ;
        break;
      default:
        jj_la1[85] = jj_gen;
        break label_24;
      }
      jj_consume_token(COMMA);
      template_parameter();
    }
  }

  final public void template_parameter() throws ParseException {
  Token t;
    if (jj_2_92(3)) {
      jj_consume_token(CLASS);
      t = jj_consume_token(ID);
                       sym.putTypeName(t.image);
    } else if (jj_2_93(1)) {
      parameter_declaration();
    } else {
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

  final public void template_id() throws ParseException {
    jj_consume_token(ID);
    jj_consume_token(LESSTHAN);
    template_argument_list();
    jj_consume_token(GREATERTHAN);
  }

  final public void template_argument_list() throws ParseException {
    template_argument();
    label_25:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case COMMA:
        ;
        break;
      default:
        jj_la1[86] = jj_gen;
        break label_25;
      }
      jj_consume_token(COMMA);
      template_argument();
    }
  }

  final public void template_argument() throws ParseException {
    if (jj_2_94(3)) {
      type_name();
    } else if (jj_2_95(1)) {
      shift_expression();
    } else {
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

  final public void statement_list() throws ParseException {
    label_26:
    while (true) {
      statement();
      if (jj_2_96(2147483647)) {
        ;
      } else {
        break label_26;
      }
    }
  }

  final public void statement() throws ParseException {
    if (jj_2_97(2147483647)) {
      declaration();
    } else if (jj_2_98(2147483647)) {
      expression();
      jj_consume_token(SEMICOLON);
    } else {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case LCURLYBRACE:
        compound_statement();
        break;
      case IF:
      case SWITCH:
        selection_statement();
        break;
      case BREAK:
      case CONTINUE:
      case GOTO:
      case RETURN:
        jump_statement();
        break;
      case SEMICOLON:
        jj_consume_token(SEMICOLON);
        break;
      case TRY:
        try_block();
        break;
      case THROW:
        throw_statement();
        break;
      default:
        jj_la1[87] = jj_gen;
        if (jj_2_99(2)) {
          labeled_statement();
        } else {
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case DO:
          case FOR:
          case WHILE:
            iteration_statement();
            break;
          default:
            jj_la1[88] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
        }
      }
    }
  }

  final public void labeled_statement() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case ID:
      jj_consume_token(ID);
      jj_consume_token(COLON);
      statement();
      break;
    case CASE:
      jj_consume_token(CASE);
      constant_expression();
      jj_consume_token(COLON);
      statement();
      break;
    case _DEFAULT:
      jj_consume_token(_DEFAULT);
      jj_consume_token(COLON);
      statement();
      break;
    default:
      jj_la1[89] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

  final public void compound_statement() throws ParseException {
    jj_consume_token(LCURLYBRACE);
     sym.openScope(null, false);
    if (jj_2_100(1)) {
      statement_list();
    } else {
      ;
    }
     sym.closeScope();
    jj_consume_token(RCURLYBRACE);
  }

  final public void selection_statement() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case IF:
      jj_consume_token(IF);
      jj_consume_token(LPARENTHESIS);
      expression();
      jj_consume_token(RPARENTHESIS);
      statement();
      if (jj_2_101(2)) {
        jj_consume_token(ELSE);
        statement();
      } else {
        ;
      }
      break;
    case SWITCH:
      jj_consume_token(SWITCH);
      jj_consume_token(LPARENTHESIS);
      expression();
      jj_consume_token(RPARENTHESIS);
      statement();
      break;
    default:
      jj_la1[90] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

  final public void iteration_statement() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case WHILE:
      jj_consume_token(WHILE);
      jj_consume_token(LPARENTHESIS);
      expression();
      jj_consume_token(RPARENTHESIS);
      statement();
      break;
    case DO:
      jj_consume_token(DO);
      statement();
      jj_consume_token(WHILE);
      jj_consume_token(LPARENTHESIS);
      expression();
      jj_consume_token(RPARENTHESIS);
      jj_consume_token(SEMICOLON);
      break;
    case FOR:
      jj_consume_token(FOR);
      jj_consume_token(LPARENTHESIS);
      if (jj_2_102(3)) {
        declaration();
      } else if (jj_2_103(1)) {
        expression();
        jj_consume_token(SEMICOLON);
      } else {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case SEMICOLON:
          jj_consume_token(SEMICOLON);
          break;
        default:
          jj_la1[91] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
      if (jj_2_104(1)) {
        expression();
      } else {
        ;
      }
      jj_consume_token(SEMICOLON);
      if (jj_2_105(1)) {
        expression();
      } else {
        ;
      }
      jj_consume_token(RPARENTHESIS);
      statement();
      break;
    default:
      jj_la1[92] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

  final public void jump_statement() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case GOTO:
      jj_consume_token(GOTO);
      jj_consume_token(ID);
      jj_consume_token(SEMICOLON);
      break;
    case CONTINUE:
      jj_consume_token(CONTINUE);
      jj_consume_token(SEMICOLON);
      break;
    case BREAK:
      jj_consume_token(BREAK);
      jj_consume_token(SEMICOLON);
      break;
    case RETURN:
      jj_consume_token(RETURN);
      if (jj_2_106(1)) {
        expression();
      } else {
        ;
      }
      jj_consume_token(SEMICOLON);
      break;
    default:
      jj_la1[93] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

  final public void try_block() throws ParseException {
    jj_consume_token(TRY);
    compound_statement();
    label_27:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case CATCH:
      case 142:
        ;
        break;
      default:
        jj_la1[94] = jj_gen;
        break label_27;
      }
      handler();
    }
  }

  final public void handler() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case CATCH:
      jj_consume_token(CATCH);
      jj_consume_token(LPARENTHESIS);
      exception_declaration();
      jj_consume_token(RPARENTHESIS);
      compound_statement();
      break;
    case 142:
      jj_consume_token(142);
      compound_statement();
      break;
    default:
      jj_la1[95] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

  final public void exception_declaration() throws ParseException {
    if (jj_2_107(1)) {
      parameter_declaration_list();
    } else {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case ELLIPSIS:
        jj_consume_token(ELLIPSIS);
        break;
      default:
        jj_la1[96] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
  }

  final public void throw_statement() throws ParseException {
    jj_consume_token(THROW);
    if (jj_2_108(1)) {
      assignment_expression();
    } else {
      ;
    }
    jj_consume_token(SEMICOLON);
  }

  final public void expression() throws ParseException {
    assignment_expression();
    label_28:
    while (true) {
      if (jj_2_109(2)) {
        ;
      } else {
        break label_28;
      }
      jj_consume_token(COMMA);
      assignment_expression();
    }
  }

  final public void assignment_expression() throws ParseException {
    conditional_expression();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case ASSIGNEQUAL:
    case TIMESEQUAL:
    case DIVIDEEQUAL:
    case MODEQUAL:
    case PLUSEQUAL:
    case MINUSEQUAL:
    case SHIFTLEFTEQUAL:
    case SHIFTRIGHTEQUAL:
    case BITWISEANDEQUAL:
    case BITWISEXOREQUAL:
    case BITWISEOREQUAL:
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case ASSIGNEQUAL:
        jj_consume_token(ASSIGNEQUAL);
        break;
      case TIMESEQUAL:
        jj_consume_token(TIMESEQUAL);
        break;
      case DIVIDEEQUAL:
        jj_consume_token(DIVIDEEQUAL);
        break;
      case MODEQUAL:
        jj_consume_token(MODEQUAL);
        break;
      case PLUSEQUAL:
        jj_consume_token(PLUSEQUAL);
        break;
      case MINUSEQUAL:
        jj_consume_token(MINUSEQUAL);
        break;
      case SHIFTLEFTEQUAL:
        jj_consume_token(SHIFTLEFTEQUAL);
        break;
      case SHIFTRIGHTEQUAL:
        jj_consume_token(SHIFTRIGHTEQUAL);
        break;
      case BITWISEANDEQUAL:
        jj_consume_token(BITWISEANDEQUAL);
        break;
      case BITWISEXOREQUAL:
        jj_consume_token(BITWISEXOREQUAL);
        break;
      case BITWISEOREQUAL:
        jj_consume_token(BITWISEOREQUAL);
        break;
      default:
        jj_la1[97] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      assignment_expression();
      break;
    default:
      jj_la1[98] = jj_gen;
      ;
    }
  }

  final public void conditional_expression() throws ParseException {
    logical_or_expression();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case QUESTIONMARK:
      jj_consume_token(QUESTIONMARK);
      conditional_expression();
      jj_consume_token(COLON);
      conditional_expression();
      break;
    default:
      jj_la1[99] = jj_gen;
      ;
    }
  }

  final public void constant_expression() throws ParseException {
    conditional_expression();
  }

  final public void logical_or_expression() throws ParseException {
    logical_and_expression();
    label_29:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case OR:
        ;
        break;
      default:
        jj_la1[100] = jj_gen;
        break label_29;
      }
      jj_consume_token(OR);
      logical_and_expression();
    }
  }

  final public void logical_and_expression() throws ParseException {
    inclusive_or_expression();
    label_30:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case AND:
        ;
        break;
      default:
        jj_la1[101] = jj_gen;
        break label_30;
      }
      jj_consume_token(AND);
      inclusive_or_expression();
    }
  }

  final public void inclusive_or_expression() throws ParseException {
    exclusive_or_expression();
    label_31:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case BITWISEOR:
        ;
        break;
      default:
        jj_la1[102] = jj_gen;
        break label_31;
      }
      jj_consume_token(BITWISEOR);
      exclusive_or_expression();
    }
  }

  final public void exclusive_or_expression() throws ParseException {
    and_expression();
    label_32:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case BITWISEXOR:
        ;
        break;
      default:
        jj_la1[103] = jj_gen;
        break label_32;
      }
      jj_consume_token(BITWISEXOR);
      and_expression();
    }
  }

  final public void and_expression() throws ParseException {
    equality_expression();
    label_33:
    while (true) {
      if (jj_2_110(2)) {
        ;
      } else {
        break label_33;
      }
      jj_consume_token(AMPERSAND);
      equality_expression();
    }
  }

  final public void equality_expression() throws ParseException {
    relational_expression();
    label_34:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case EQUAL:
      case NOTEQUAL:
        ;
        break;
      default:
        jj_la1[104] = jj_gen;
        break label_34;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case NOTEQUAL:
        jj_consume_token(NOTEQUAL);
        break;
      case EQUAL:
        jj_consume_token(EQUAL);
        break;
      default:
        jj_la1[105] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      relational_expression();
    }
  }

  final public void relational_expression() throws ParseException {
    shift_expression();
    label_35:
    while (true) {
      if (jj_2_111(2)) {
        ;
      } else {
        break label_35;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case LESSTHAN:
        jj_consume_token(LESSTHAN);
        break;
      case GREATERTHAN:
        jj_consume_token(GREATERTHAN);
        break;
      case LESSTHANOREQUALTO:
        jj_consume_token(LESSTHANOREQUALTO);
        break;
      case GREATERTHANOREQUALTO:
        jj_consume_token(GREATERTHANOREQUALTO);
        break;
      default:
        jj_la1[106] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      shift_expression();
    }
  }

  final public void shift_expression() throws ParseException {
    additive_expression();
    label_36:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case SHIFTLEFT:
      case SHIFTRIGHT:
        ;
        break;
      default:
        jj_la1[107] = jj_gen;
        break label_36;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case SHIFTLEFT:
        jj_consume_token(SHIFTLEFT);
        break;
      case SHIFTRIGHT:
        jj_consume_token(SHIFTRIGHT);
        break;
      default:
        jj_la1[108] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      additive_expression();
    }
  }

  final public void additive_expression() throws ParseException {
    multiplicative_expression();
    label_37:
    while (true) {
      if (jj_2_112(2)) {
        ;
      } else {
        break label_37;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case PLUS:
        jj_consume_token(PLUS);
        break;
      case MINUS:
        jj_consume_token(MINUS);
        break;
      default:
        jj_la1[109] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      multiplicative_expression();
    }
  }

  final public void multiplicative_expression() throws ParseException {
    pm_expression();
    label_38:
    while (true) {
      if (jj_2_113(2)) {
        ;
      } else {
        break label_38;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case STAR:
        jj_consume_token(STAR);
        break;
      case DIVIDE:
        jj_consume_token(DIVIDE);
        break;
      case MOD:
        jj_consume_token(MOD);
        break;
      default:
        jj_la1[110] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      pm_expression();
    }
  }

  final public void pm_expression() throws ParseException {
    cast_expression();
    label_39:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case DOTSTAR:
      case ARROWSTAR:
        ;
        break;
      default:
        jj_la1[111] = jj_gen;
        break label_39;
      }
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case DOTSTAR:
        jj_consume_token(DOTSTAR);
        break;
      case ARROWSTAR:
        jj_consume_token(ARROWSTAR);
        break;
      default:
        jj_la1[112] = jj_gen;
        jj_consume_token(-1);
        throw new ParseException();
      }
      cast_expression();
    }
  }

  final public void cast_expression() throws ParseException {
    if (jj_2_114(2147483647)) {
      jj_consume_token(LPARENTHESIS);
      type_name();
      jj_consume_token(RPARENTHESIS);
      cast_expression();
    } else if (jj_2_115(1)) {
      unary_expression();
    } else {
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

  final public void unary_expression() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case PLUSPLUS:
      jj_consume_token(PLUSPLUS);
      unary_expression();
      break;
    case MINUSMINUS:
      jj_consume_token(MINUSMINUS);
      unary_expression();
      break;
    default:
      jj_la1[113] = jj_gen;
      if (jj_2_118(3)) {
        unary_operator();
        cast_expression();
      } else {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case SIZEOF:
          jj_consume_token(SIZEOF);
          if (jj_2_116(2147483647)) {
            jj_consume_token(LPARENTHESIS);
            type_name();
            jj_consume_token(RPARENTHESIS);
          } else if (jj_2_117(1)) {
            unary_expression();
          } else {
            jj_consume_token(-1);
            throw new ParseException();
          }
          break;
        default:
          jj_la1[114] = jj_gen;
          if (jj_2_119(1)) {
            postfix_expression();
          } else {
            jj_consume_token(-1);
            throw new ParseException();
          }
        }
      }
    }
  }

  final public void new_expression() throws ParseException {
    if (jj_2_120(2147483647)) {
      jj_consume_token(SCOPE);
    } else {
      ;
    }
    jj_consume_token(NEW);
    if (jj_2_124(2147483647)) {
      jj_consume_token(LPARENTHESIS);
      type_name();
      jj_consume_token(RPARENTHESIS);
    } else if (jj_2_125(1)) {
      if (jj_2_121(2147483647)) {
        jj_consume_token(LPARENTHESIS);
        expression_list();
        jj_consume_token(RPARENTHESIS);
      } else {
        ;
      }
      if (jj_2_122(2147483647)) {
        jj_consume_token(LPARENTHESIS);
        type_name();
        jj_consume_token(RPARENTHESIS);
      } else if (jj_2_123(2147483647)) {
        new_type_id();
      } else {
        jj_consume_token(-1);
        throw new ParseException();
      }
    } else {
      jj_consume_token(-1);
      throw new ParseException();
    }
    if (jj_2_126(2147483647)) {
      new_initializer();
    } else {
      ;
    }
  }

  final public void new_type_id() throws ParseException {
    declaration_specifiers();
    if (jj_2_127(2147483647)) {
      new_declarator();
    } else {
      ;
    }
  }

  final public void new_declarator() throws ParseException {
  Declaration dummy = new Declaration();
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case LSQUAREBRACKET:
      direct_new_declarator();
      break;
    case SCOPE:
    case AMPERSAND:
    case STAR:
    case ID:
      ptr_operator(dummy);
      cv_qualifier_seq();
      if (jj_2_128(2)) {
        new_declarator();
      } else {
        ;
      }
      break;
    default:
      jj_la1[115] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

  final public void direct_new_declarator() throws ParseException {
    label_40:
    while (true) {
      jj_consume_token(LSQUAREBRACKET);
      expression();
      jj_consume_token(RSQUAREBRACKET);
      if (jj_2_129(2)) {
        ;
      } else {
        break label_40;
      }
    }
  }

  final public void new_initializer() throws ParseException {
    jj_consume_token(LPARENTHESIS);
    if (jj_2_130(1)) {
      expression_list();
    } else {
      ;
    }
    jj_consume_token(RPARENTHESIS);
  }

  final public void delete_expression() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case SCOPE:
      jj_consume_token(SCOPE);
      break;
    default:
      jj_la1[116] = jj_gen;
      ;
    }
    jj_consume_token(DELETE);
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case LSQUAREBRACKET:
      jj_consume_token(LSQUAREBRACKET);
      jj_consume_token(RSQUAREBRACKET);
      break;
    default:
      jj_la1[117] = jj_gen;
      ;
    }
    cast_expression();
  }

  final public void unary_operator() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case AMPERSAND:
      jj_consume_token(AMPERSAND);
      break;
    case STAR:
      jj_consume_token(STAR);
      break;
    case PLUS:
      jj_consume_token(PLUS);
      break;
    case MINUS:
      jj_consume_token(MINUS);
      break;
    case TILDE:
      jj_consume_token(TILDE);
      break;
    case NOT:
      jj_consume_token(NOT);
      break;
    default:
      jj_la1[118] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

  final public void postfix_expression() throws ParseException {
    if (jj_2_134(3)) {
      primary_expression();
      label_41:
      while (true) {
        if (jj_2_131(2)) {
          ;
        } else {
          break label_41;
        }
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case LSQUAREBRACKET:
          jj_consume_token(LSQUAREBRACKET);
          expression();
          jj_consume_token(RSQUAREBRACKET);
          break;
        case LPARENTHESIS:
          jj_consume_token(LPARENTHESIS);
          if (jj_2_132(1)) {
            expression_list();
          } else {
            ;
          }
          jj_consume_token(RPARENTHESIS);
          break;
        case DOT:
          jj_consume_token(DOT);
          id_expression();
          break;
        case POINTERTO:
          jj_consume_token(POINTERTO);
          id_expression();
          break;
        case PLUSPLUS:
          jj_consume_token(PLUSPLUS);
          break;
        case MINUSMINUS:
          jj_consume_token(MINUSMINUS);
          break;
        default:
          jj_la1[119] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
    } else if (jj_2_135(1)) {
      simple_type_specifier();
      jj_consume_token(LPARENTHESIS);
      if (jj_2_133(1)) {
        expression_list();
      } else {
        ;
      }
      jj_consume_token(RPARENTHESIS);
    } else {
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

  final public void id_expression() throws ParseException {
    if (jj_2_136(2147483647)) {
      scope_override();
    } else {
      ;
    }
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case ID:
      jj_consume_token(ID);
      break;
    case OPERATOR:
      jj_consume_token(OPERATOR);
      optor();
      break;
    case TILDE:
      jj_consume_token(TILDE);
      jj_consume_token(ID);
      break;
    default:
      jj_la1[120] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

  final public void primary_expression() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case THIS:
      jj_consume_token(THIS);
      break;
    case STRING:
      label_42:
      while (true) {
        jj_consume_token(STRING);
        if (jj_2_137(2)) {
          ;
        } else {
          break label_42;
        }
      }
      break;
    case LPARENTHESIS:
      jj_consume_token(LPARENTHESIS);
      expression();
      jj_consume_token(RPARENTHESIS);
      break;
    default:
      jj_la1[121] = jj_gen;
      if (jj_2_138(2147483647)) {
        new_expression();
      } else if (jj_2_139(2147483647)) {
        delete_expression();
      } else {
        switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
        case SCOPE:
        case TILDE:
        case OPERATOR:
        case ID:
          id_expression();
          break;
        case TRUETOK:
        case FALSETOK:
        case OCTALINT:
        case OCTALLONG:
        case UNSIGNED_OCTALINT:
        case UNSIGNED_OCTALLONG:
        case DECIMALINT:
        case DECIMALLONG:
        case UNSIGNED_DECIMALINT:
        case UNSIGNED_DECIMALLONG:
        case HEXADECIMALINT:
        case HEXADECIMALLONG:
        case UNSIGNED_HEXADECIMALINT:
        case UNSIGNED_HEXADECIMALLONG:
        case FLOATONE:
        case FLOATTWO:
        case CHARACTER:
          constant();
          break;
        default:
          jj_la1[122] = jj_gen;
          jj_consume_token(-1);
          throw new ParseException();
        }
      }
    }
  }

  final public void expression_list() throws ParseException {
    assignment_expression();
    label_43:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case COMMA:
        ;
        break;
      default:
        jj_la1[123] = jj_gen;
        break label_43;
      }
      jj_consume_token(COMMA);
      assignment_expression();
    }
  }

  final public void constant() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case OCTALINT:
      jj_consume_token(OCTALINT);
      break;
    case OCTALLONG:
      jj_consume_token(OCTALLONG);
      break;
    case DECIMALINT:
      jj_consume_token(DECIMALINT);
      break;
    case DECIMALLONG:
      jj_consume_token(DECIMALLONG);
      break;
    case HEXADECIMALINT:
      jj_consume_token(HEXADECIMALINT);
      break;
    case HEXADECIMALLONG:
      jj_consume_token(HEXADECIMALLONG);
      break;
    case UNSIGNED_OCTALINT:
      jj_consume_token(UNSIGNED_OCTALINT);
      break;
    case UNSIGNED_OCTALLONG:
      jj_consume_token(UNSIGNED_OCTALLONG);
      break;
    case UNSIGNED_DECIMALINT:
      jj_consume_token(UNSIGNED_DECIMALINT);
      break;
    case UNSIGNED_DECIMALLONG:
      jj_consume_token(UNSIGNED_DECIMALLONG);
      break;
    case UNSIGNED_HEXADECIMALINT:
      jj_consume_token(UNSIGNED_HEXADECIMALINT);
      break;
    case UNSIGNED_HEXADECIMALLONG:
      jj_consume_token(UNSIGNED_HEXADECIMALLONG);
      break;
    case CHARACTER:
      jj_consume_token(CHARACTER);
      break;
    case FLOATONE:
      jj_consume_token(FLOATONE);
      break;
    case FLOATTWO:
      jj_consume_token(FLOATTWO);
      break;
    case TRUETOK:
      jj_consume_token(TRUETOK);
      break;
    case FALSETOK:
      jj_consume_token(FALSETOK);
      break;
    default:
      jj_la1[124] = jj_gen;
      jj_consume_token(-1);
      throw new ParseException();
    }
  }

  final public void optor() throws ParseException {
    switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
    case NEW:
      jj_consume_token(NEW);
      if (jj_2_140(2)) {
        jj_consume_token(LSQUAREBRACKET);
        jj_consume_token(RSQUAREBRACKET);
      } else {
        ;
      }
      break;
    case DELETE:
      jj_consume_token(DELETE);
      if (jj_2_141(2)) {
        jj_consume_token(LSQUAREBRACKET);
        jj_consume_token(RSQUAREBRACKET);
      } else {
        ;
      }
      break;
    case PLUS:
      jj_consume_token(PLUS);
      break;
    case MINUS:
      jj_consume_token(MINUS);
      break;
    case STAR:
      jj_consume_token(STAR);
      break;
    case DIVIDE:
      jj_consume_token(DIVIDE);
      break;
    case MOD:
      jj_consume_token(MOD);
      break;
    case BITWISEXOR:
      jj_consume_token(BITWISEXOR);
      break;
    case AMPERSAND:
      jj_consume_token(AMPERSAND);
      break;
    case BITWISEOR:
      jj_consume_token(BITWISEOR);
      break;
    case TILDE:
      jj_consume_token(TILDE);
      break;
    case NOT:
      jj_consume_token(NOT);
      break;
    case ASSIGNEQUAL:
      jj_consume_token(ASSIGNEQUAL);
      break;
    case LESSTHAN:
      jj_consume_token(LESSTHAN);
      break;
    case GREATERTHAN:
      jj_consume_token(GREATERTHAN);
      break;
    case PLUSEQUAL:
      jj_consume_token(PLUSEQUAL);
      break;
    case MINUSEQUAL:
      jj_consume_token(MINUSEQUAL);
      break;
    case TIMESEQUAL:
      jj_consume_token(TIMESEQUAL);
      break;
    case DIVIDEEQUAL:
      jj_consume_token(DIVIDEEQUAL);
      break;
    case MODEQUAL:
      jj_consume_token(MODEQUAL);
      break;
    case BITWISEXOREQUAL:
      jj_consume_token(BITWISEXOREQUAL);
      break;
    case BITWISEANDEQUAL:
      jj_consume_token(BITWISEANDEQUAL);
      break;
    case BITWISEOREQUAL:
      jj_consume_token(BITWISEOREQUAL);
      break;
    case SHIFTLEFT:
      jj_consume_token(SHIFTLEFT);
      break;
    case SHIFTRIGHT:
      jj_consume_token(SHIFTRIGHT);
      break;
    case SHIFTRIGHTEQUAL:
      jj_consume_token(SHIFTRIGHTEQUAL);
      break;
    case SHIFTLEFTEQUAL:
      jj_consume_token(SHIFTLEFTEQUAL);
      break;
    case EQUAL:
      jj_consume_token(EQUAL);
      break;
    case NOTEQUAL:
      jj_consume_token(NOTEQUAL);
      break;
    case LESSTHANOREQUALTO:
      jj_consume_token(LESSTHANOREQUALTO);
      break;
    case GREATERTHANOREQUALTO:
      jj_consume_token(GREATERTHANOREQUALTO);
      break;
    case AND:
      jj_consume_token(AND);
      break;
    case OR:
      jj_consume_token(OR);
      break;
    case PLUSPLUS:
      jj_consume_token(PLUSPLUS);
      break;
    case MINUSMINUS:
      jj_consume_token(MINUSMINUS);
      break;
    case COMMA:
      jj_consume_token(COMMA);
      break;
    case ARROWSTAR:
      jj_consume_token(ARROWSTAR);
      break;
    case POINTERTO:
      jj_consume_token(POINTERTO);
      break;
    case LPARENTHESIS:
      jj_consume_token(LPARENTHESIS);
      jj_consume_token(RPARENTHESIS);
      break;
    case LSQUAREBRACKET:
      jj_consume_token(LSQUAREBRACKET);
      jj_consume_token(RSQUAREBRACKET);
      break;
    default:
      jj_la1[126] = jj_gen;
      if (jj_2_143(1)) {
        declaration_specifiers();
        if (jj_2_142(2)) {
          switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
          case STAR:
            jj_consume_token(STAR);
            break;
          case AMPERSAND:
            jj_consume_token(AMPERSAND);
            break;
          default:
            jj_la1[125] = jj_gen;
            jj_consume_token(-1);
            throw new ParseException();
          }
        } else {
          ;
        }
      } else {
        jj_consume_token(-1);
        throw new ParseException();
      }
    }
  }

  final public void exception_spec() throws ParseException {
    jj_consume_token(THROW);
    jj_consume_token(LPARENTHESIS);
    exception_list();
    jj_consume_token(RPARENTHESIS);
  }

  final public void exception_list() throws ParseException {
    type_name();
    label_44:
    while (true) {
      switch ((jj_ntk==-1)?jj_ntk():jj_ntk) {
      case COMMA:
        ;
        break;
      default:
        jj_la1[127] = jj_gen;
        break label_44;
      }
      jj_consume_token(COMMA);
      type_name();
    }
  }

  final private boolean jj_2_1(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_1();
    jj_save(0, xla);
    return retval;
  }

  final private boolean jj_2_2(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_2();
    jj_save(1, xla);
    return retval;
  }

  final private boolean jj_2_3(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_3();
    jj_save(2, xla);
    return retval;
  }

  final private boolean jj_2_4(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_4();
    jj_save(3, xla);
    return retval;
  }

  final private boolean jj_2_5(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_5();
    jj_save(4, xla);
    return retval;
  }

  final private boolean jj_2_6(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_6();
    jj_save(5, xla);
    return retval;
  }

  final private boolean jj_2_7(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_7();
    jj_save(6, xla);
    return retval;
  }

  final private boolean jj_2_8(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_8();
    jj_save(7, xla);
    return retval;
  }

  final private boolean jj_2_9(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_9();
    jj_save(8, xla);
    return retval;
  }

  final private boolean jj_2_10(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_10();
    jj_save(9, xla);
    return retval;
  }

  final private boolean jj_2_11(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_11();
    jj_save(10, xla);
    return retval;
  }

  final private boolean jj_2_12(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_12();
    jj_save(11, xla);
    return retval;
  }

  final private boolean jj_2_13(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_13();
    jj_save(12, xla);
    return retval;
  }

  final private boolean jj_2_14(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_14();
    jj_save(13, xla);
    return retval;
  }

  final private boolean jj_2_15(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_15();
    jj_save(14, xla);
    return retval;
  }

  final private boolean jj_2_16(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_16();
    jj_save(15, xla);
    return retval;
  }

  final private boolean jj_2_17(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_17();
    jj_save(16, xla);
    return retval;
  }

  final private boolean jj_2_18(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_18();
    jj_save(17, xla);
    return retval;
  }

  final private boolean jj_2_19(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_19();
    jj_save(18, xla);
    return retval;
  }

  final private boolean jj_2_20(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_20();
    jj_save(19, xla);
    return retval;
  }

  final private boolean jj_2_21(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_21();
    jj_save(20, xla);
    return retval;
  }

  final private boolean jj_2_22(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_22();
    jj_save(21, xla);
    return retval;
  }

  final private boolean jj_2_23(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_23();
    jj_save(22, xla);
    return retval;
  }

  final private boolean jj_2_24(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_24();
    jj_save(23, xla);
    return retval;
  }

  final private boolean jj_2_25(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_25();
    jj_save(24, xla);
    return retval;
  }

  final private boolean jj_2_26(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_26();
    jj_save(25, xla);
    return retval;
  }

  final private boolean jj_2_27(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_27();
    jj_save(26, xla);
    return retval;
  }

  final private boolean jj_2_28(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_28();
    jj_save(27, xla);
    return retval;
  }

  final private boolean jj_2_29(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_29();
    jj_save(28, xla);
    return retval;
  }

  final private boolean jj_2_30(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_30();
    jj_save(29, xla);
    return retval;
  }

  final private boolean jj_2_31(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_31();
    jj_save(30, xla);
    return retval;
  }

  final private boolean jj_2_32(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_32();
    jj_save(31, xla);
    return retval;
  }

  final private boolean jj_2_33(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_33();
    jj_save(32, xla);
    return retval;
  }

  final private boolean jj_2_34(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_34();
    jj_save(33, xla);
    return retval;
  }

  final private boolean jj_2_35(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_35();
    jj_save(34, xla);
    return retval;
  }

  final private boolean jj_2_36(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_36();
    jj_save(35, xla);
    return retval;
  }

  final private boolean jj_2_37(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_37();
    jj_save(36, xla);
    return retval;
  }

  final private boolean jj_2_38(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_38();
    jj_save(37, xla);
    return retval;
  }

  final private boolean jj_2_39(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_39();
    jj_save(38, xla);
    return retval;
  }

  final private boolean jj_2_40(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_40();
    jj_save(39, xla);
    return retval;
  }

  final private boolean jj_2_41(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_41();
    jj_save(40, xla);
    return retval;
  }

  final private boolean jj_2_42(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_42();
    jj_save(41, xla);
    return retval;
  }

  final private boolean jj_2_43(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_43();
    jj_save(42, xla);
    return retval;
  }

  final private boolean jj_2_44(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_44();
    jj_save(43, xla);
    return retval;
  }

  final private boolean jj_2_45(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_45();
    jj_save(44, xla);
    return retval;
  }

  final private boolean jj_2_46(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_46();
    jj_save(45, xla);
    return retval;
  }

  final private boolean jj_2_47(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_47();
    jj_save(46, xla);
    return retval;
  }

  final private boolean jj_2_48(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_48();
    jj_save(47, xla);
    return retval;
  }

  final private boolean jj_2_49(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_49();
    jj_save(48, xla);
    return retval;
  }

  final private boolean jj_2_50(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_50();
    jj_save(49, xla);
    return retval;
  }

  final private boolean jj_2_51(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_51();
    jj_save(50, xla);
    return retval;
  }

  final private boolean jj_2_52(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_52();
    jj_save(51, xla);
    return retval;
  }

  final private boolean jj_2_53(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_53();
    jj_save(52, xla);
    return retval;
  }

  final private boolean jj_2_54(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_54();
    jj_save(53, xla);
    return retval;
  }

  final private boolean jj_2_55(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_55();
    jj_save(54, xla);
    return retval;
  }

  final private boolean jj_2_56(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_56();
    jj_save(55, xla);
    return retval;
  }

  final private boolean jj_2_57(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_57();
    jj_save(56, xla);
    return retval;
  }

  final private boolean jj_2_58(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_58();
    jj_save(57, xla);
    return retval;
  }

  final private boolean jj_2_59(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_59();
    jj_save(58, xla);
    return retval;
  }

  final private boolean jj_2_60(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_60();
    jj_save(59, xla);
    return retval;
  }

  final private boolean jj_2_61(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_61();
    jj_save(60, xla);
    return retval;
  }

  final private boolean jj_2_62(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_62();
    jj_save(61, xla);
    return retval;
  }

  final private boolean jj_2_63(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_63();
    jj_save(62, xla);
    return retval;
  }

  final private boolean jj_2_64(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_64();
    jj_save(63, xla);
    return retval;
  }

  final private boolean jj_2_65(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_65();
    jj_save(64, xla);
    return retval;
  }

  final private boolean jj_2_66(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_66();
    jj_save(65, xla);
    return retval;
  }

  final private boolean jj_2_67(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_67();
    jj_save(66, xla);
    return retval;
  }

  final private boolean jj_2_68(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_68();
    jj_save(67, xla);
    return retval;
  }

  final private boolean jj_2_69(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_69();
    jj_save(68, xla);
    return retval;
  }

  final private boolean jj_2_70(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_70();
    jj_save(69, xla);
    return retval;
  }

  final private boolean jj_2_71(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_71();
    jj_save(70, xla);
    return retval;
  }

  final private boolean jj_2_72(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_72();
    jj_save(71, xla);
    return retval;
  }

  final private boolean jj_2_73(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_73();
    jj_save(72, xla);
    return retval;
  }

  final private boolean jj_2_74(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_74();
    jj_save(73, xla);
    return retval;
  }

  final private boolean jj_2_75(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_75();
    jj_save(74, xla);
    return retval;
  }

  final private boolean jj_2_76(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_76();
    jj_save(75, xla);
    return retval;
  }

  final private boolean jj_2_77(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_77();
    jj_save(76, xla);
    return retval;
  }

  final private boolean jj_2_78(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_78();
    jj_save(77, xla);
    return retval;
  }

  final private boolean jj_2_79(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_79();
    jj_save(78, xla);
    return retval;
  }

  final private boolean jj_2_80(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_80();
    jj_save(79, xla);
    return retval;
  }

  final private boolean jj_2_81(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_81();
    jj_save(80, xla);
    return retval;
  }

  final private boolean jj_2_82(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_82();
    jj_save(81, xla);
    return retval;
  }

  final private boolean jj_2_83(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_83();
    jj_save(82, xla);
    return retval;
  }

  final private boolean jj_2_84(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_84();
    jj_save(83, xla);
    return retval;
  }

  final private boolean jj_2_85(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_85();
    jj_save(84, xla);
    return retval;
  }

  final private boolean jj_2_86(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_86();
    jj_save(85, xla);
    return retval;
  }

  final private boolean jj_2_87(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_87();
    jj_save(86, xla);
    return retval;
  }

  final private boolean jj_2_88(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_88();
    jj_save(87, xla);
    return retval;
  }

  final private boolean jj_2_89(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_89();
    jj_save(88, xla);
    return retval;
  }

  final private boolean jj_2_90(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_90();
    jj_save(89, xla);
    return retval;
  }

  final private boolean jj_2_91(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_91();
    jj_save(90, xla);
    return retval;
  }

  final private boolean jj_2_92(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_92();
    jj_save(91, xla);
    return retval;
  }

  final private boolean jj_2_93(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_93();
    jj_save(92, xla);
    return retval;
  }

  final private boolean jj_2_94(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_94();
    jj_save(93, xla);
    return retval;
  }

  final private boolean jj_2_95(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_95();
    jj_save(94, xla);
    return retval;
  }

  final private boolean jj_2_96(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_96();
    jj_save(95, xla);
    return retval;
  }

  final private boolean jj_2_97(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_97();
    jj_save(96, xla);
    return retval;
  }

  final private boolean jj_2_98(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_98();
    jj_save(97, xla);
    return retval;
  }

  final private boolean jj_2_99(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_99();
    jj_save(98, xla);
    return retval;
  }

  final private boolean jj_2_100(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_100();
    jj_save(99, xla);
    return retval;
  }

  final private boolean jj_2_101(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_101();
    jj_save(100, xla);
    return retval;
  }

  final private boolean jj_2_102(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_102();
    jj_save(101, xla);
    return retval;
  }

  final private boolean jj_2_103(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_103();
    jj_save(102, xla);
    return retval;
  }

  final private boolean jj_2_104(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_104();
    jj_save(103, xla);
    return retval;
  }

  final private boolean jj_2_105(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_105();
    jj_save(104, xla);
    return retval;
  }

  final private boolean jj_2_106(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_106();
    jj_save(105, xla);
    return retval;
  }

  final private boolean jj_2_107(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_107();
    jj_save(106, xla);
    return retval;
  }

  final private boolean jj_2_108(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_108();
    jj_save(107, xla);
    return retval;
  }

  final private boolean jj_2_109(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_109();
    jj_save(108, xla);
    return retval;
  }

  final private boolean jj_2_110(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_110();
    jj_save(109, xla);
    return retval;
  }

  final private boolean jj_2_111(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_111();
    jj_save(110, xla);
    return retval;
  }

  final private boolean jj_2_112(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_112();
    jj_save(111, xla);
    return retval;
  }

  final private boolean jj_2_113(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_113();
    jj_save(112, xla);
    return retval;
  }

  final private boolean jj_2_114(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_114();
    jj_save(113, xla);
    return retval;
  }

  final private boolean jj_2_115(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_115();
    jj_save(114, xla);
    return retval;
  }

  final private boolean jj_2_116(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_116();
    jj_save(115, xla);
    return retval;
  }

  final private boolean jj_2_117(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_117();
    jj_save(116, xla);
    return retval;
  }

  final private boolean jj_2_118(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_118();
    jj_save(117, xla);
    return retval;
  }

  final private boolean jj_2_119(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_119();
    jj_save(118, xla);
    return retval;
  }

  final private boolean jj_2_120(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_120();
    jj_save(119, xla);
    return retval;
  }

  final private boolean jj_2_121(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_121();
    jj_save(120, xla);
    return retval;
  }

  final private boolean jj_2_122(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_122();
    jj_save(121, xla);
    return retval;
  }

  final private boolean jj_2_123(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_123();
    jj_save(122, xla);
    return retval;
  }

  final private boolean jj_2_124(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_124();
    jj_save(123, xla);
    return retval;
  }

  final private boolean jj_2_125(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_125();
    jj_save(124, xla);
    return retval;
  }

  final private boolean jj_2_126(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_126();
    jj_save(125, xla);
    return retval;
  }

  final private boolean jj_2_127(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_127();
    jj_save(126, xla);
    return retval;
  }

  final private boolean jj_2_128(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_128();
    jj_save(127, xla);
    return retval;
  }

  final private boolean jj_2_129(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_129();
    jj_save(128, xla);
    return retval;
  }

  final private boolean jj_2_130(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_130();
    jj_save(129, xla);
    return retval;
  }

  final private boolean jj_2_131(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_131();
    jj_save(130, xla);
    return retval;
  }

  final private boolean jj_2_132(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_132();
    jj_save(131, xla);
    return retval;
  }

  final private boolean jj_2_133(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_133();
    jj_save(132, xla);
    return retval;
  }

  final private boolean jj_2_134(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_134();
    jj_save(133, xla);
    return retval;
  }

  final private boolean jj_2_135(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_135();
    jj_save(134, xla);
    return retval;
  }

  final private boolean jj_2_136(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_136();
    jj_save(135, xla);
    return retval;
  }

  final private boolean jj_2_137(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_137();
    jj_save(136, xla);
    return retval;
  }

  final private boolean jj_2_138(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_138();
    jj_save(137, xla);
    return retval;
  }

  final private boolean jj_2_139(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_139();
    jj_save(138, xla);
    return retval;
  }

  final private boolean jj_2_140(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_140();
    jj_save(139, xla);
    return retval;
  }

  final private boolean jj_2_141(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_141();
    jj_save(140, xla);
    return retval;
  }

  final private boolean jj_2_142(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_142();
    jj_save(141, xla);
    return retval;
  }

  final private boolean jj_2_143(int xla) {
    jj_la = xla; jj_lastpos = jj_scanpos = token;
    boolean retval = !jj_3_143();
    jj_save(142, xla);
    return retval;
  }

  final private boolean jj_3R_111() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_239()) {
    jj_scanpos = xsp;
    if (jj_3R_240()) {
    jj_scanpos = xsp;
    if (jj_3R_241()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_239() {
    if (jj_scan_token(ID)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(COLON)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_109()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_238() {
    if (jj_3R_303()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_99() {
    if (jj_3R_111()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_237() {
    if (jj_3R_302()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_98() {
    if (jj_3R_110()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(SEMICOLON)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_236() {
    if (jj_3R_301()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_235() {
    if (jj_scan_token(SEMICOLON)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_97() {
    if (jj_3R_61()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_234() {
    if (jj_3R_300()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_233() {
    if (jj_3R_299()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_232() {
    if (jj_3R_298()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_96() {
    if (jj_3R_109()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_231() {
    if (jj_3R_110()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(SEMICOLON)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_109() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_230()) {
    jj_scanpos = xsp;
    if (jj_3R_231()) {
    jj_scanpos = xsp;
    if (jj_3R_232()) {
    jj_scanpos = xsp;
    if (jj_3R_233()) {
    jj_scanpos = xsp;
    if (jj_3R_234()) {
    jj_scanpos = xsp;
    if (jj_3R_235()) {
    jj_scanpos = xsp;
    if (jj_3R_236()) {
    jj_scanpos = xsp;
    if (jj_3R_237()) {
    jj_scanpos = xsp;
    if (jj_3_99()) {
    jj_scanpos = xsp;
    if (jj_3R_238()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_230() {
    if (jj_3R_61()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_424() {
    if (jj_scan_token(COMMA)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_208()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_242() {
    if (jj_3R_109()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_112() {
    Token xsp;
    if (jj_3R_242()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_242()) { jj_scanpos = xsp; break; }
      if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    }
    return false;
  }

  final private boolean jj_3_95() {
    if (jj_3R_108()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_94() {
    if (jj_3R_107()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_208() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_94()) {
    jj_scanpos = xsp;
    if (jj_3_95()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_319() {
    if (jj_scan_token(COMMA)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_318()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_80() {
    if (jj_3R_208()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_424()) { jj_scanpos = xsp; break; }
      if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    }
    return false;
  }

  final private boolean jj_3_93() {
    if (jj_3R_99()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_92() {
    if (jj_scan_token(CLASS)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(ID)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_318() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_92()) {
    jj_scanpos = xsp;
    if (jj_3_93()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_277() {
    if (jj_3R_318()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_319()) { jj_scanpos = xsp; break; }
      if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    }
    return false;
  }

  final private boolean jj_3R_167() {
    if (jj_scan_token(TEMPLATE)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(LESSTHAN)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_277()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(GREATERTHAN)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_91() {
    if (jj_3R_87()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_90() {
    if (jj_3R_94()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_454() {
    if (jj_scan_token(LPARENTHESIS)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_91()) jj_scanpos = xsp;
    else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(RPARENTHESIS)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_444() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_453()) {
    jj_scanpos = xsp;
    if (jj_3R_454()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_453() {
    if (jj_scan_token(LSQUAREBRACKET)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_90()) jj_scanpos = xsp;
    else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(RSQUAREBRACKET)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_88() {
    if (jj_3R_94()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_106() {
    if (jj_3R_92()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_227()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_102() {
    if (jj_scan_token(COMMA)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_101()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_228() {
    if (jj_scan_token(LSQUAREBRACKET)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_88()) jj_scanpos = xsp;
    else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(RSQUAREBRACKET)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_105() {
    Token xsp;
    if (jj_3R_228()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_228()) { jj_scanpos = xsp; break; }
      if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    }
    return false;
  }

  final private boolean jj_3R_434() {
    if (jj_3R_444()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_104() {
    if (jj_scan_token(LPARENTHESIS)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_227()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(RPARENTHESIS)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    Token xsp;
    if (jj_3R_434()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_434()) { jj_scanpos = xsp; break; }
      if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    }
    return false;
  }

  final private boolean jj_3_89() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_104()) {
    jj_scanpos = xsp;
    if (jj_3R_105()) {
    jj_scanpos = xsp;
    if (jj_3R_106()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_97() {
    if (jj_scan_token(COMMA)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_227() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_89()) jj_scanpos = xsp;
    else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_107() {
    if (jj_3R_53()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_227()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_87() {
    if (jj_3R_103()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_101() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_86()) {
    jj_scanpos = xsp;
    if (jj_3_87()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_82() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_97()) jj_scanpos = xsp;
    else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(ELLIPSIS)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_86() {
    if (jj_scan_token(LCURLYBRACE)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_101()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_102()) { jj_scanpos = xsp; break; }
      if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    }
    if (jj_scan_token(RCURLYBRACE)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_85() {
    if (jj_3R_100()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_81() {
    if (jj_3R_87()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_428() {
    if (jj_scan_token(ASSIGNEQUAL)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_103()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_427() {
    if (jj_3R_227()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_426() {
    if (jj_3R_100()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_99() {
    if (jj_3R_53()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_426()) {
    jj_scanpos = xsp;
    if (jj_3R_427()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    xsp = jj_scanpos;
    if (jj_3R_428()) jj_scanpos = xsp;
    else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_84() {
    if (jj_scan_token(COMMA)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_99()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_98() {
    if (jj_3R_99()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_84()) { jj_scanpos = xsp; break; }
      if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    }
    return false;
  }

  final private boolean jj_3R_215() {
    if (jj_scan_token(ELLIPSIS)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_87() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_83()) {
    jj_scanpos = xsp;
    if (jj_3R_215()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_79() {
    if (jj_3R_96()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_83() {
    if (jj_3R_98()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_82()) jj_scanpos = xsp;
    else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_500() {
    if (jj_scan_token(COMMA)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_499()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_80() {
    if (jj_3R_78()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_278() {
    return false;
  }

  final private boolean jj_3R_169() {
    if (jj_scan_token(TILDE)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    Token xsp;
    xsp = jj_scanpos;
    lookingAhead = true;
    jj_semLA = isCtor();
    lookingAhead = false;
    if (!jj_semLA || jj_3R_278()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(ID)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(LPARENTHESIS)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    xsp = jj_scanpos;
    if (jj_3_81()) jj_scanpos = xsp;
    else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(RPARENTHESIS)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_168() {
    if (jj_3R_170()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_58() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_168()) jj_scanpos = xsp;
    else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_169()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_499() {
    if (jj_3R_86()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(LPARENTHESIS)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_79()) jj_scanpos = xsp;
    else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(RPARENTHESIS)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_491() {
    if (jj_scan_token(COLON)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_499()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_500()) { jj_scanpos = xsp; break; }
      if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    }
    return false;
  }

  final private boolean jj_3_77() {
    if (jj_3R_87()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_78() {
    if (jj_3R_95()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_326() {
    return false;
  }

  final private boolean jj_3R_289() {
    Token xsp;
    xsp = jj_scanpos;
    lookingAhead = true;
    jj_semLA = isCtor();
    lookingAhead = false;
    if (!jj_semLA || jj_3R_326()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_86()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(LPARENTHESIS)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    xsp = jj_scanpos;
    if (jj_3_77()) jj_scanpos = xsp;
    else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(RPARENTHESIS)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    xsp = jj_scanpos;
    if (jj_3_78()) jj_scanpos = xsp;
    else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_158() {
    return false;
  }

  final private boolean jj_3R_50() {
    Token xsp;
    xsp = jj_scanpos;
    lookingAhead = true;
    jj_semLA = isCtor();
    lookingAhead = false;
    if (!jj_semLA || jj_3R_158()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_86()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(LPARENTHESIS)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_479() {
    if (jj_3R_491()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_472() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_479()) jj_scanpos = xsp;
    else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_298()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_471() {
    if (jj_scan_token(SEMICOLON)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_470() {
    if (jj_3R_95()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_269() {
    if (jj_3R_49()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_289()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_470()) jj_scanpos = xsp;
    else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    xsp = jj_scanpos;
    if (jj_3R_471()) {
    jj_scanpos = xsp;
    if (jj_3R_472()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_317() {
    if (jj_scan_token(VIRTUAL)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_316() {
    if (jj_scan_token(INLINE)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_313() {
    if (jj_3R_167()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_268() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_313()) jj_scanpos = xsp;
    else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_49()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_58()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_298()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_274() {
    if (jj_scan_token(INLINE)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_317()) jj_scanpos = xsp;
    else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_157() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_273()) {
    jj_scanpos = xsp;
    if (jj_3R_274()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_273() {
    if (jj_scan_token(VIRTUAL)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_316()) jj_scanpos = xsp;
    else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_49() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_157()) jj_scanpos = xsp;
    else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_76() {
    if (jj_scan_token(ASSIGNEQUAL)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_74() {
    if (jj_3R_87()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_498() {
    if (jj_scan_token(ASSIGNEQUAL)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(OCTALINT)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_497() {
    if (jj_3R_95()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_75() {
    if (jj_3R_88()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_282() {
    if (jj_3R_86()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(LPARENTHESIS)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_74()) jj_scanpos = xsp;
    else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(RPARENTHESIS)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    xsp = jj_scanpos;
    if (jj_3_75()) jj_scanpos = xsp;
    else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    xsp = jj_scanpos;
    if (jj_3R_497()) jj_scanpos = xsp;
    else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    xsp = jj_scanpos;
    if (jj_3R_498()) jj_scanpos = xsp;
    else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_73() {
    if (jj_3R_92()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_173() {
    if (jj_3R_282()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_66() {
    if (jj_3R_93()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_172() {
    if (jj_3R_92()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_62()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_62() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_172()) {
    jj_scanpos = xsp;
    if (jj_3R_173()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_67() {
    if (jj_3R_93()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_72() {
    if (jj_3R_92()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_52() {
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_72()) { jj_scanpos = xsp; break; }
      if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    }
    if (jj_3R_86()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(LPARENTHESIS)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_70() {
    if (jj_3R_87()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_69() {
    if (jj_3R_94()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_460() {
    if (jj_3R_95()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_71() {
    if (jj_3R_88()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_223() {
    if (jj_scan_token(LPARENTHESIS)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_70()) jj_scanpos = xsp;
    else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(RPARENTHESIS)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    xsp = jj_scanpos;
    if (jj_3_71()) jj_scanpos = xsp;
    else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    xsp = jj_scanpos;
    if (jj_3R_460()) jj_scanpos = xsp;
    else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_295() {
    if (jj_scan_token(LSQUAREBRACKET)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_69()) jj_scanpos = xsp;
    else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(RSQUAREBRACKET)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_93() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_222()) {
    jj_scanpos = xsp;
    if (jj_3R_223()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_222() {
    Token xsp;
    if (jj_3R_295()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_295()) { jj_scanpos = xsp; break; }
      if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    }
    return false;
  }

  final private boolean jj_3_65() {
    if (jj_3R_93()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_372() {
    if (jj_3R_86()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_67()) jj_scanpos = xsp;
    else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_371() {
    if (jj_scan_token(LPARENTHESIS)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_100()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(RPARENTHESIS)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_66()) jj_scanpos = xsp;
    else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_68() {
    if (jj_scan_token(TILDE)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(ID)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_65()) jj_scanpos = xsp;
    else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_297() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_68()) {
    jj_scanpos = xsp;
    if (jj_3R_371()) {
    jj_scanpos = xsp;
    if (jj_3R_372()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_64() {
    if (jj_3R_92()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_226() {
    if (jj_3R_297()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_62() {
    if (jj_scan_token(CONST)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_61() {
    if (jj_scan_token(VOLATILE)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_225() {
    if (jj_3R_92()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_100()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_100() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_225()) {
    jj_scanpos = xsp;
    if (jj_3R_226()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_91() {
    if (jj_scan_token(VOLATILE)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_62()) jj_scanpos = xsp;
    else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_90() {
    if (jj_scan_token(CONST)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_61()) jj_scanpos = xsp;
    else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_63() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_90()) {
    jj_scanpos = xsp;
    if (jj_3R_91()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_293() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_63()) jj_scanpos = xsp;
    else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_481() {
    if (jj_scan_token(AMPERSAND)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_221() {
    if (jj_3R_294()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_293()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_220() {
    if (jj_scan_token(STAR)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_293()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_480() {
    if (jj_scan_token(STAR)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_447() {
    if (jj_scan_token(COMMA)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_218()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_473() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_480()) {
    jj_scanpos = xsp;
    if (jj_3R_481()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_92() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_219()) {
    jj_scanpos = xsp;
    if (jj_3R_220()) {
    jj_scanpos = xsp;
    if (jj_3R_221()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_219() {
    if (jj_scan_token(AMPERSAND)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_293()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_459() {
    if (jj_scan_token(ASSIGNEQUAL)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_94()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_218() {
    if (jj_scan_token(ID)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_459()) jj_scanpos = xsp;
    else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_60() {
    if (jj_scan_token(LCURLYBRACE)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_89()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(RCURLYBRACE)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_89() {
    if (jj_3R_218()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_447()) { jj_scanpos = xsp; break; }
      if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    }
    return false;
  }

  final private boolean jj_3R_325() {
    if (jj_scan_token(ID)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_60()) jj_scanpos = xsp;
    else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_496() {
    if (jj_scan_token(ASSIGNEQUAL)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(OCTALINT)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_324() {
    if (jj_scan_token(LCURLYBRACE)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_89()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(RCURLYBRACE)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_192() {
    if (jj_scan_token(ENUM)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_324()) {
    jj_scanpos = xsp;
    if (jj_3R_325()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_57() {
    if (jj_3R_78()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_488() {
    if (jj_scan_token(ASSIGNEQUAL)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(OCTALINT)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_58() {
    if (jj_3R_87()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_474() {
    if (jj_3R_95()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_59() {
    if (jj_3R_88()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_315() {
    if (jj_3R_170()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_271() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_315()) jj_scanpos = xsp;
    else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(OPERATOR)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_53()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    xsp = jj_scanpos;
    if (jj_3R_473()) jj_scanpos = xsp;
    else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(LPARENTHESIS)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    xsp = jj_scanpos;
    if (jj_3_58()) jj_scanpos = xsp;
    else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(RPARENTHESIS)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    xsp = jj_scanpos;
    if (jj_3_59()) jj_scanpos = xsp;
    else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    xsp = jj_scanpos;
    if (jj_3R_474()) jj_scanpos = xsp;
    else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_475()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_487() {
    if (jj_3R_100()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_489() {
    if (jj_scan_token(COMMA)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_487()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_496()) jj_scanpos = xsp;
    else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_477() {
    if (jj_3R_487()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_488()) jj_scanpos = xsp;
    else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_489()) { jj_scanpos = xsp; break; }
      if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    }
    return false;
  }

  final private boolean jj_3_55() {
    if (jj_scan_token(ID)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_207() {
    if (jj_scan_token(SEMICOLON)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_54() {
    if (jj_3R_53()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_206() {
    if (jj_3R_290()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(COLON)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_469() {
    if (jj_3R_477()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_211() {
    if (jj_scan_token(VIRTUAL)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_85() {
    if (jj_3R_53()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_53() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_85()) jj_scanpos = xsp;
    else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_52()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_56() {
    if (jj_3R_86()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(SEMICOLON)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_457() {
    if (jj_scan_token(VIRTUAL)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_52() {
    if (jj_3R_49()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_50()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(SEMICOLON)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_205() {
    if (jj_3R_62()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(SEMICOLON)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_51() {
    if (jj_3R_49()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_50()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_204() {
    if (jj_3R_53()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_469()) jj_scanpos = xsp;
    else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(SEMICOLON)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_84() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_210()) {
    jj_scanpos = xsp;
    if (jj_3R_211()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_210() {
    if (jj_scan_token(INLINE)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_50() {
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_84()) { jj_scanpos = xsp; break; }
      if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    }
    if (jj_scan_token(TILDE)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_83() {
    if (jj_scan_token(ID)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_203() {
    if (jj_3R_270()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_49() {
    if (jj_3R_49()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_58()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(LCURLYBRACE)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_202() {
    if (jj_3R_49()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_289()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(SEMICOLON)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_48() {
    if (jj_scan_token(OPERATOR)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_201() {
    if (jj_3R_269()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_47() {
    if (jj_scan_token(ENUM)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_83()) jj_scanpos = xsp;
    else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(LCURLYBRACE)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_200() {
    if (jj_3R_49()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_169()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(SEMICOLON)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_82() {
    if (jj_scan_token(TYPEDEF)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_46() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_82()) jj_scanpos = xsp;
    else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_55()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(LCURLYBRACE)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_199() {
    if (jj_3R_268()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_446() {
    if (jj_3R_290()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_457()) jj_scanpos = xsp;
    else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_468() {
    if (jj_3R_477()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_45() {
    if (jj_scan_token(USING)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_198() {
    if (jj_3R_271()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_197() {
    if (jj_3R_192()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_468()) jj_scanpos = xsp;
    else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(SEMICOLON)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_196() {
    if (jj_3R_61()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_79() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_195()) {
    jj_scanpos = xsp;
    if (jj_3R_196()) {
    jj_scanpos = xsp;
    if (jj_3R_197()) {
    jj_scanpos = xsp;
    if (jj_3R_198()) {
    jj_scanpos = xsp;
    if (jj_3R_199()) {
    jj_scanpos = xsp;
    if (jj_3R_200()) {
    jj_scanpos = xsp;
    if (jj_3R_201()) {
    jj_scanpos = xsp;
    if (jj_3R_202()) {
    jj_scanpos = xsp;
    if (jj_3R_203()) {
    jj_scanpos = xsp;
    if (jj_3R_204()) {
    jj_scanpos = xsp;
    if (jj_3R_205()) {
    jj_scanpos = xsp;
    if (jj_3_56()) {
    jj_scanpos = xsp;
    if (jj_3R_206()) {
    jj_scanpos = xsp;
    if (jj_3R_207()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_195() {
    if (jj_3R_48()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_329() {
    if (jj_scan_token(PRIVATE)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_328() {
    if (jj_scan_token(PROTECTED)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_44() {
    if (jj_3R_78()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_290() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_327()) {
    jj_scanpos = xsp;
    if (jj_3R_328()) {
    jj_scanpos = xsp;
    if (jj_3R_329()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_327() {
    if (jj_scan_token(PUBLIC)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_438() {
    if (jj_scan_token(LESSTHAN)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_80()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(GREATERTHAN)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_456() {
    if (jj_3R_290()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_437() {
    if (jj_3R_170()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_436() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_445()) {
    jj_scanpos = xsp;
    if (jj_3R_446()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_445() {
    if (jj_scan_token(VIRTUAL)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_456()) jj_scanpos = xsp;
    else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_418() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_436()) jj_scanpos = xsp;
    else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    xsp = jj_scanpos;
    if (jj_3R_437()) jj_scanpos = xsp;
    else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(ID)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    xsp = jj_scanpos;
    if (jj_3R_438()) jj_scanpos = xsp;
    else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_419() {
    if (jj_scan_token(COMMA)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_418()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_42() {
    if (jj_scan_token(LESSTHAN)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_80()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(GREATERTHAN)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_209() {
    if (jj_scan_token(COLON)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_418()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_419()) { jj_scanpos = xsp; break; }
      if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    }
    return false;
  }

  final private boolean jj_3R_323() {
    if (jj_scan_token(ID)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_42()) jj_scanpos = xsp;
    else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_41() {
    if (jj_3R_79()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_287() {
    if (jj_scan_token(CLASS)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_81() {
    if (jj_3R_209()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_43() {
    if (jj_scan_token(ID)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_81()) jj_scanpos = xsp;
    else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(LCURLYBRACE)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_41()) { jj_scanpos = xsp; break; }
      if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    }
    if (jj_scan_token(RCURLYBRACE)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_40() {
    if (jj_3R_79()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_286() {
    if (jj_scan_token(UNION)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_165() {
    if (jj_scan_token(CLASS)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_322() {
    if (jj_scan_token(LCURLYBRACE)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_40()) { jj_scanpos = xsp; break; }
      if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    }
    if (jj_scan_token(RCURLYBRACE)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_285() {
    if (jj_scan_token(STRUCT)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_191() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_285()) {
    jj_scanpos = xsp;
    if (jj_3R_286()) {
    jj_scanpos = xsp;
    if (jj_3R_287()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    xsp = jj_scanpos;
    if (jj_3R_322()) {
    jj_scanpos = xsp;
    if (jj_3_43()) {
    jj_scanpos = xsp;
    if (jj_3R_323()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_164() {
    if (jj_scan_token(UNION)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_276() {
    if (jj_3R_209()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_431() {
    if (jj_scan_token(COMMA)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_283()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_166() {
    if (jj_scan_token(ID)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_276()) jj_scanpos = xsp;
    else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_163() {
    if (jj_scan_token(STRUCT)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_55() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_163()) {
    jj_scanpos = xsp;
    if (jj_3R_164()) {
    jj_scanpos = xsp;
    if (jj_3R_165()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    xsp = jj_scanpos;
    if (jj_3R_166()) jj_scanpos = xsp;
    else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_451() {
    if (jj_scan_token(LPARENTHESIS)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_96()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(RPARENTHESIS)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_442() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_450()) {
    jj_scanpos = xsp;
    if (jj_3R_451()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_450() {
    if (jj_scan_token(ASSIGNEQUAL)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_101()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_283() {
    if (jj_3R_100()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_442()) jj_scanpos = xsp;
    else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_174() {
    if (jj_3R_283()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_431()) { jj_scanpos = xsp; break; }
      if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    }
    return false;
  }

  final private boolean jj_3R_189() {
    if (jj_scan_token(UNSIGNED)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_188() {
    if (jj_scan_token(SIGNED)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_187() {
    if (jj_scan_token(DOUBLE)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_186() {
    if (jj_scan_token(FLOAT)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_422() {
    if (jj_scan_token(STATIC)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_185() {
    if (jj_scan_token(LONG)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_184() {
    if (jj_scan_token(INT)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_183() {
    if (jj_scan_token(SHORT)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_182() {
    if (jj_scan_token(CHAR)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_181() {
    if (jj_scan_token(141)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_421() {
    if (jj_scan_token(REGISTER)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_180() {
    if (jj_scan_token(VOID)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_67() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_180()) {
    jj_scanpos = xsp;
    if (jj_3R_181()) {
    jj_scanpos = xsp;
    if (jj_3R_182()) {
    jj_scanpos = xsp;
    if (jj_3R_183()) {
    jj_scanpos = xsp;
    if (jj_3R_184()) {
    jj_scanpos = xsp;
    if (jj_3R_185()) {
    jj_scanpos = xsp;
    if (jj_3R_186()) {
    jj_scanpos = xsp;
    if (jj_3R_187()) {
    jj_scanpos = xsp;
    if (jj_3R_188()) {
    jj_scanpos = xsp;
    if (jj_3R_189()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_321() {
    if (jj_scan_token(TYPEDEF)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_423() {
    if (jj_scan_token(EXTERN)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_420() {
    if (jj_scan_token(AUTO)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_217() {
    if (jj_scan_token(VOLATILE)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_284() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_320()) {
    jj_scanpos = xsp;
    if (jj_3R_321()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_320() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_420()) {
    jj_scanpos = xsp;
    if (jj_3R_421()) {
    jj_scanpos = xsp;
    if (jj_3R_422()) {
    jj_scanpos = xsp;
    if (jj_3R_423()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_190() {
    return false;
  }

  final private boolean jj_3R_88() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_216()) {
    jj_scanpos = xsp;
    if (jj_3R_217()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_216() {
    if (jj_scan_token(CONST)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_68() {
    Token xsp;
    xsp = jj_scanpos;
    lookingAhead = true;
    jj_semLA = true;
    lookingAhead = false;
    if (!jj_semLA || jj_3R_190()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_86()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_291() {
    if (jj_scan_token(LESSTHAN)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_80()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(GREATERTHAN)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_39() {
    if (jj_3R_78()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_294() {
    if (jj_3R_170()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(STAR)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_77() {
    if (jj_scan_token(LESSTHAN)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_80()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(GREATERTHAN)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_214() {
    if (jj_scan_token(OPERATOR)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_292()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_76() {
    if (jj_scan_token(LESSTHAN)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_80()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(GREATERTHAN)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_213() {
    if (jj_scan_token(ID)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_291()) jj_scanpos = xsp;
    else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_212() {
    if (jj_3R_170()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_86() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_212()) jj_scanpos = xsp;
    else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    xsp = jj_scanpos;
    if (jj_3R_213()) {
    jj_scanpos = xsp;
    if (jj_3R_214()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_38() {
    if (jj_scan_token(ID)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_77()) jj_scanpos = xsp;
    else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(SCOPE)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_280() {
    Token xsp;
    if (jj_3_38()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_38()) { jj_scanpos = xsp; break; }
      if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    }
    return false;
  }

  final private boolean jj_3_37() {
    if (jj_scan_token(ID)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_76()) jj_scanpos = xsp;
    else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(SCOPE)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_279() {
    if (jj_scan_token(SCOPE)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_37()) { jj_scanpos = xsp; break; }
      if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    }
    return false;
  }

  final private boolean jj_3R_170() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_279()) {
    jj_scanpos = xsp;
    if (jj_3R_280()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_288() {
    if (jj_scan_token(LESSTHAN)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_80()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(GREATERTHAN)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_194() {
    if (jj_scan_token(ID)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_288()) jj_scanpos = xsp;
    else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(SCOPE)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_78() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_193()) {
    jj_scanpos = xsp;
    if (jj_3R_194()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_193() {
    if (jj_scan_token(SCOPE)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_36() {
    if (jj_3R_68()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_266() {
    if (jj_3R_67()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_141() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_266()) {
    jj_scanpos = xsp;
    if (jj_3_36()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_31() {
    if (jj_3R_67()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_33() {
    if (jj_3R_64()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_32() {
    if (jj_3R_68()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_75() {
    if (jj_3R_192()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_74() {
    if (jj_3R_191()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_73() {
    if (jj_3R_64()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_35() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_74()) {
    jj_scanpos = xsp;
    if (jj_3R_75()) {
    jj_scanpos = xsp;
    if (jj_3_32()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_33()) { jj_scanpos = xsp; break; }
      if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    }
    return false;
  }

  final private boolean jj_3R_72() {
    if (jj_3R_67()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_34() {
    if (jj_3R_67()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_30() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_72()) {
    jj_scanpos = xsp;
    if (jj_3R_73()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_160() {
    if (jj_3R_67()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_30()) { jj_scanpos = xsp; break; }
      if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    }
    return false;
  }

  final private boolean jj_3_24() {
    if (jj_3R_64()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_23() {
    if (jj_3R_67()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_25() {
    if (jj_3R_68()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_26() {
    if (jj_3R_64()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_70() {
    if (jj_3R_192()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_69() {
    if (jj_3R_191()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_66() {
    if (jj_3R_64()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_27() {
    if (jj_3R_67()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_65() {
    if (jj_3R_67()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_28() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_69()) {
    jj_scanpos = xsp;
    if (jj_3R_70()) {
    jj_scanpos = xsp;
    if (jj_3_25()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_26()) { jj_scanpos = xsp; break; }
      if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    }
    return false;
  }

  final private boolean jj_3_22() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_65()) {
    jj_scanpos = xsp;
    if (jj_3R_66()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_21() {
    if (jj_3R_64()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_71() {
    if (jj_3R_67()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_22()) { jj_scanpos = xsp; break; }
      if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    }
    return false;
  }

  final private boolean jj_3_29() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_71()) {
    jj_scanpos = xsp;
    if (jj_3_28()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_275() {
    if (jj_3R_64()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_159() {
    Token xsp;
    if (jj_3R_275()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_275()) { jj_scanpos = xsp; break; }
      if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    }
    xsp = jj_scanpos;
    if (jj_3_29()) jj_scanpos = xsp;
    else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_53() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_159()) {
    jj_scanpos = xsp;
    if (jj_3R_160()) {
    jj_scanpos = xsp;
    if (jj_3_35()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_179() {
    if (jj_scan_token(FRIEND)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_178() {
    if (jj_scan_token(VIRTUAL)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_177() {
    if (jj_scan_token(INLINE)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_176() {
    if (jj_3R_88()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_175() {
    if (jj_3R_284()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_63() {
    if (jj_3R_174()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_64() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_175()) {
    jj_scanpos = xsp;
    if (jj_3R_176()) {
    jj_scanpos = xsp;
    if (jj_3R_177()) {
    jj_scanpos = xsp;
    if (jj_3R_178()) {
    jj_scanpos = xsp;
    if (jj_3R_179()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_18() {
    if (jj_scan_token(SEMICOLON)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_171() {
    if (jj_3R_281()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_61() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_20()) {
    jj_scanpos = xsp;
    if (jj_3R_171()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_20() {
    if (jj_3R_53()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_63()) jj_scanpos = xsp;
    else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(SEMICOLON)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_17() {
    if (jj_3R_47()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_432() {
    if (jj_scan_token(SEMICOLON)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_19() {
    if (jj_3R_61()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_383() {
    if (jj_scan_token(LCURLYBRACE)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_17()) { jj_scanpos = xsp; break; }
      if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    }
    if (jj_scan_token(RCURLYBRACE)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    xsp = jj_scanpos;
    if (jj_3R_432()) jj_scanpos = xsp;
    else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_281() {
    if (jj_scan_token(EXTERN)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(STRING)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_383()) {
    jj_scanpos = xsp;
    if (jj_3_19()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_483() {
    if (jj_3R_298()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_482() {
    if (jj_scan_token(SEMICOLON)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_475() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_482()) {
    jj_scanpos = xsp;
    if (jj_3R_483()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_314() {
    if (jj_3R_62()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_475()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_16() {
    if (jj_3R_53()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_62()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_475()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_270() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_16()) {
    jj_scanpos = xsp;
    if (jj_3R_314()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_476() {
    if (jj_3R_174()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_51() {
    if (jj_3R_53()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_7() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_51()) jj_scanpos = xsp;
    else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_52()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_6() {
    if (jj_3R_49()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_50()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_155() {
    if (jj_scan_token(SEMICOLON)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_15() {
    if (jj_3R_61()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_8() {
    if (jj_3R_53()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_476()) jj_scanpos = xsp;
    else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(SEMICOLON)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_464() {
    if (jj_3R_270()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_60() {
    if (jj_3R_170()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_14() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_60()) jj_scanpos = xsp;
    else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(OPERATOR)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_462() {
    if (jj_3R_174()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_463() {
    if (jj_3R_269()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_59() {
    if (jj_3R_53()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_162() {
    if (jj_3R_167()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_13() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_59()) jj_scanpos = xsp;
    else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_52()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_56() {
    if (jj_scan_token(ID)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_12() {
    if (jj_3R_49()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_50()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_154() {
    if (jj_3R_167()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_463()) {
    jj_scanpos = xsp;
    if (jj_3R_464()) {
    jj_scanpos = xsp;
    if (jj_3_8()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_57() {
    if (jj_3R_167()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_11() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_57()) jj_scanpos = xsp;
    else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_49()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_58()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(LCURLYBRACE)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_153() {
    if (jj_3R_271()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_152() {
    if (jj_3R_270()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_10() {
    if (jj_scan_token(ENUM)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_56()) jj_scanpos = xsp;
    else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(LCURLYBRACE)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_161() {
    if (jj_scan_token(TYPEDEF)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_54() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_161()) {
    jj_scanpos = xsp;
    if (jj_3R_162()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_151() {
    if (jj_3R_269()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_9() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_54()) jj_scanpos = xsp;
    else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_55()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(LCURLYBRACE)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_150() {
    if (jj_3R_268()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_267() {
    if (jj_3R_167()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_149() {
    if (jj_3R_192()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_462()) jj_scanpos = xsp;
    else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(SEMICOLON)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_5() {
    if (jj_scan_token(SCOPE)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_148() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_267()) jj_scanpos = xsp;
    else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_61()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_47() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_148()) {
    jj_scanpos = xsp;
    if (jj_3R_149()) {
    jj_scanpos = xsp;
    if (jj_3R_150()) {
    jj_scanpos = xsp;
    if (jj_3R_151()) {
    jj_scanpos = xsp;
    if (jj_3R_152()) {
    jj_scanpos = xsp;
    if (jj_3R_153()) {
    jj_scanpos = xsp;
    if (jj_3R_154()) {
    jj_scanpos = xsp;
    if (jj_3_15()) {
    jj_scanpos = xsp;
    if (jj_3R_155()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_486() {
    if (jj_scan_token(SCOPE)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(ID)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_272() {
    if (jj_scan_token(SCOPE)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_156() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_272()) jj_scanpos = xsp;
    else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(ID)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_486()) { jj_scanpos = xsp; break; }
      if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    }
    return false;
  }

  final private boolean jj_3R_147() {
    if (jj_scan_token(USING)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_48() {
    if (jj_scan_token(USING)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_156()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(SEMICOLON)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_4() {
    if (jj_scan_token(USING)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(NAMESPACE)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_146() {
    if (jj_scan_token(NAMESPACE)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_1() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_2()) {
    jj_scanpos = xsp;
    if (jj_3R_45()) {
    jj_scanpos = xsp;
    if (jj_3_3()) {
    jj_scanpos = xsp;
    if (jj_3R_46()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_46() {
    if (jj_3R_147()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_3() {
    if (jj_3R_48()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_45() {
    if (jj_3R_146()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_2() {
    if (jj_3R_47()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_145() {
    if (jj_scan_token(AMPERSAND)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_144() {
    if (jj_scan_token(STAR)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_142() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_144()) {
    jj_scanpos = xsp;
    if (jj_3R_145()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_490() {
    if (jj_scan_token(COMMA)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_107()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_478() {
    if (jj_3R_107()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_490()) { jj_scanpos = xsp; break; }
      if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    }
    return false;
  }

  final private boolean jj_3R_95() {
    if (jj_scan_token(THROW)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(LPARENTHESIS)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_478()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(RPARENTHESIS)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_143() {
    if (jj_3R_53()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_142()) jj_scanpos = xsp;
    else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_369() {
    if (jj_scan_token(LSQUAREBRACKET)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(RSQUAREBRACKET)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_368() {
    if (jj_scan_token(LPARENTHESIS)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(RPARENTHESIS)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_367() {
    if (jj_scan_token(POINTERTO)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_366() {
    if (jj_scan_token(ARROWSTAR)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_365() {
    if (jj_scan_token(COMMA)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_364() {
    if (jj_scan_token(MINUSMINUS)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_363() {
    if (jj_scan_token(PLUSPLUS)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_362() {
    if (jj_scan_token(OR)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_361() {
    if (jj_scan_token(AND)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_360() {
    if (jj_scan_token(GREATERTHANOREQUALTO)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_359() {
    if (jj_scan_token(LESSTHANOREQUALTO)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_358() {
    if (jj_scan_token(NOTEQUAL)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_357() {
    if (jj_scan_token(EQUAL)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_356() {
    if (jj_scan_token(SHIFTLEFTEQUAL)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_355() {
    if (jj_scan_token(SHIFTRIGHTEQUAL)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_354() {
    if (jj_scan_token(SHIFTRIGHT)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_353() {
    if (jj_scan_token(SHIFTLEFT)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_352() {
    if (jj_scan_token(BITWISEOREQUAL)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_351() {
    if (jj_scan_token(BITWISEANDEQUAL)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_350() {
    if (jj_scan_token(BITWISEXOREQUAL)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_349() {
    if (jj_scan_token(MODEQUAL)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_348() {
    if (jj_scan_token(DIVIDEEQUAL)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_347() {
    if (jj_scan_token(TIMESEQUAL)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_346() {
    if (jj_scan_token(MINUSEQUAL)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_345() {
    if (jj_scan_token(PLUSEQUAL)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_344() {
    if (jj_scan_token(GREATERTHAN)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_343() {
    if (jj_scan_token(LESSTHAN)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_141() {
    if (jj_scan_token(LSQUAREBRACKET)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(RSQUAREBRACKET)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_342() {
    if (jj_scan_token(ASSIGNEQUAL)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_341() {
    if (jj_scan_token(NOT)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_340() {
    if (jj_scan_token(TILDE)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_339() {
    if (jj_scan_token(BITWISEOR)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_140() {
    if (jj_scan_token(LSQUAREBRACKET)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(RSQUAREBRACKET)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_338() {
    if (jj_scan_token(AMPERSAND)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_337() {
    if (jj_scan_token(BITWISEXOR)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_336() {
    if (jj_scan_token(MOD)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_335() {
    if (jj_scan_token(DIVIDE)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_334() {
    if (jj_scan_token(STAR)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_333() {
    if (jj_scan_token(MINUS)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_332() {
    if (jj_scan_token(PLUS)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_331() {
    if (jj_scan_token(DELETE)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_141()) jj_scanpos = xsp;
    else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_292() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_330()) {
    jj_scanpos = xsp;
    if (jj_3R_331()) {
    jj_scanpos = xsp;
    if (jj_3R_332()) {
    jj_scanpos = xsp;
    if (jj_3R_333()) {
    jj_scanpos = xsp;
    if (jj_3R_334()) {
    jj_scanpos = xsp;
    if (jj_3R_335()) {
    jj_scanpos = xsp;
    if (jj_3R_336()) {
    jj_scanpos = xsp;
    if (jj_3R_337()) {
    jj_scanpos = xsp;
    if (jj_3R_338()) {
    jj_scanpos = xsp;
    if (jj_3R_339()) {
    jj_scanpos = xsp;
    if (jj_3R_340()) {
    jj_scanpos = xsp;
    if (jj_3R_341()) {
    jj_scanpos = xsp;
    if (jj_3R_342()) {
    jj_scanpos = xsp;
    if (jj_3R_343()) {
    jj_scanpos = xsp;
    if (jj_3R_344()) {
    jj_scanpos = xsp;
    if (jj_3R_345()) {
    jj_scanpos = xsp;
    if (jj_3R_346()) {
    jj_scanpos = xsp;
    if (jj_3R_347()) {
    jj_scanpos = xsp;
    if (jj_3R_348()) {
    jj_scanpos = xsp;
    if (jj_3R_349()) {
    jj_scanpos = xsp;
    if (jj_3R_350()) {
    jj_scanpos = xsp;
    if (jj_3R_351()) {
    jj_scanpos = xsp;
    if (jj_3R_352()) {
    jj_scanpos = xsp;
    if (jj_3R_353()) {
    jj_scanpos = xsp;
    if (jj_3R_354()) {
    jj_scanpos = xsp;
    if (jj_3R_355()) {
    jj_scanpos = xsp;
    if (jj_3R_356()) {
    jj_scanpos = xsp;
    if (jj_3R_357()) {
    jj_scanpos = xsp;
    if (jj_3R_358()) {
    jj_scanpos = xsp;
    if (jj_3R_359()) {
    jj_scanpos = xsp;
    if (jj_3R_360()) {
    jj_scanpos = xsp;
    if (jj_3R_361()) {
    jj_scanpos = xsp;
    if (jj_3R_362()) {
    jj_scanpos = xsp;
    if (jj_3R_363()) {
    jj_scanpos = xsp;
    if (jj_3R_364()) {
    jj_scanpos = xsp;
    if (jj_3R_365()) {
    jj_scanpos = xsp;
    if (jj_3R_366()) {
    jj_scanpos = xsp;
    if (jj_3R_367()) {
    jj_scanpos = xsp;
    if (jj_3R_368()) {
    jj_scanpos = xsp;
    if (jj_3R_369()) {
    jj_scanpos = xsp;
    if (jj_3_143()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_330() {
    if (jj_scan_token(NEW)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_140()) jj_scanpos = xsp;
    else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_254() {
    if (jj_scan_token(COMMA)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_103()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_417() {
    if (jj_scan_token(FALSETOK)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_416() {
    if (jj_scan_token(TRUETOK)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_415() {
    if (jj_scan_token(FLOATTWO)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_414() {
    if (jj_scan_token(FLOATONE)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_413() {
    if (jj_scan_token(CHARACTER)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_412() {
    if (jj_scan_token(UNSIGNED_HEXADECIMALLONG)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_411() {
    if (jj_scan_token(UNSIGNED_HEXADECIMALINT)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_410() {
    if (jj_scan_token(UNSIGNED_DECIMALLONG)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_409() {
    if (jj_scan_token(UNSIGNED_DECIMALINT)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_408() {
    if (jj_scan_token(UNSIGNED_OCTALLONG)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_407() {
    if (jj_scan_token(UNSIGNED_OCTALINT)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_406() {
    if (jj_scan_token(HEXADECIMALLONG)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_405() {
    if (jj_scan_token(HEXADECIMALINT)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_404() {
    if (jj_scan_token(DECIMALLONG)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_403() {
    if (jj_scan_token(DECIMALINT)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_402() {
    if (jj_scan_token(OCTALLONG)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_312() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_401()) {
    jj_scanpos = xsp;
    if (jj_3R_402()) {
    jj_scanpos = xsp;
    if (jj_3R_403()) {
    jj_scanpos = xsp;
    if (jj_3R_404()) {
    jj_scanpos = xsp;
    if (jj_3R_405()) {
    jj_scanpos = xsp;
    if (jj_3R_406()) {
    jj_scanpos = xsp;
    if (jj_3R_407()) {
    jj_scanpos = xsp;
    if (jj_3R_408()) {
    jj_scanpos = xsp;
    if (jj_3R_409()) {
    jj_scanpos = xsp;
    if (jj_3R_410()) {
    jj_scanpos = xsp;
    if (jj_3R_411()) {
    jj_scanpos = xsp;
    if (jj_3R_412()) {
    jj_scanpos = xsp;
    if (jj_3R_413()) {
    jj_scanpos = xsp;
    if (jj_3R_414()) {
    jj_scanpos = xsp;
    if (jj_3R_415()) {
    jj_scanpos = xsp;
    if (jj_3R_416()) {
    jj_scanpos = xsp;
    if (jj_3R_417()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_401() {
    if (jj_scan_token(OCTALINT)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_143() {
    if (jj_scan_token(SCOPE)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_139() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_143()) jj_scanpos = xsp;
    else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(DELETE)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_142() {
    if (jj_scan_token(SCOPE)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_96() {
    if (jj_3R_103()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_254()) { jj_scanpos = xsp; break; }
      if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    }
    return false;
  }

  final private boolean jj_3_138() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_142()) jj_scanpos = xsp;
    else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(NEW)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_133() {
    if (jj_3R_96()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_265() {
    if (jj_3R_312()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_264() {
    if (jj_3R_258()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_263() {
    if (jj_3R_311()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_262() {
    if (jj_3R_310()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_137() {
    if (jj_scan_token(STRING)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_261() {
    if (jj_scan_token(LPARENTHESIS)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_110()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(RPARENTHESIS)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_260() {
    Token xsp;
    if (jj_3_137()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_137()) { jj_scanpos = xsp; break; }
      if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    }
    return false;
  }

  final private boolean jj_3R_140() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_259()) {
    jj_scanpos = xsp;
    if (jj_3R_260()) {
    jj_scanpos = xsp;
    if (jj_3R_261()) {
    jj_scanpos = xsp;
    if (jj_3R_262()) {
    jj_scanpos = xsp;
    if (jj_3R_263()) {
    jj_scanpos = xsp;
    if (jj_3R_264()) {
    jj_scanpos = xsp;
    if (jj_3R_265()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_259() {
    if (jj_scan_token(THIS)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_136() {
    if (jj_3R_78()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_307() {
    if (jj_scan_token(ID)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_309() {
    if (jj_scan_token(TILDE)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(ID)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_308() {
    if (jj_scan_token(OPERATOR)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_292()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_306() {
    if (jj_3R_170()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_258() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_306()) jj_scanpos = xsp;
    else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    xsp = jj_scanpos;
    if (jj_3R_307()) {
    jj_scanpos = xsp;
    if (jj_3R_308()) {
    jj_scanpos = xsp;
    if (jj_3R_309()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_135() {
    if (jj_3R_141()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(LPARENTHESIS)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_133()) jj_scanpos = xsp;
    else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(RPARENTHESIS)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_139() {
    if (jj_scan_token(MINUSMINUS)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_138() {
    if (jj_scan_token(PLUSPLUS)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_132() {
    if (jj_3R_96()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_128() {
    if (jj_3R_133()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_137() {
    if (jj_scan_token(POINTERTO)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_258()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_136() {
    if (jj_scan_token(DOT)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_258()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_135() {
    if (jj_scan_token(LPARENTHESIS)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_132()) jj_scanpos = xsp;
    else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(RPARENTHESIS)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_400() {
    if (jj_scan_token(LSQUAREBRACKET)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(RSQUAREBRACKET)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_134() {
    if (jj_scan_token(LSQUAREBRACKET)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_110()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(RSQUAREBRACKET)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_131() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_134()) {
    jj_scanpos = xsp;
    if (jj_3R_135()) {
    jj_scanpos = xsp;
    if (jj_3R_136()) {
    jj_scanpos = xsp;
    if (jj_3R_137()) {
    jj_scanpos = xsp;
    if (jj_3R_138()) {
    jj_scanpos = xsp;
    if (jj_3R_139()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_128() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_134()) {
    jj_scanpos = xsp;
    if (jj_3_135()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_134() {
    if (jj_3R_140()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_131()) { jj_scanpos = xsp; break; }
      if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    }
    return false;
  }

  final private boolean jj_3R_252() {
    if (jj_scan_token(NOT)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_251() {
    if (jj_scan_token(TILDE)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_250() {
    if (jj_scan_token(MINUS)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_249() {
    if (jj_scan_token(PLUS)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_248() {
    if (jj_scan_token(STAR)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_126() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_247()) {
    jj_scanpos = xsp;
    if (jj_3R_248()) {
    jj_scanpos = xsp;
    if (jj_3R_249()) {
    jj_scanpos = xsp;
    if (jj_3R_250()) {
    jj_scanpos = xsp;
    if (jj_3R_251()) {
    jj_scanpos = xsp;
    if (jj_3R_252()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_247() {
    if (jj_scan_token(AMPERSAND)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_399() {
    if (jj_scan_token(SCOPE)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_130() {
    if (jj_3R_96()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_311() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_399()) jj_scanpos = xsp;
    else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(DELETE)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    xsp = jj_scanpos;
    if (jj_3R_400()) jj_scanpos = xsp;
    else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_127()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_132() {
    if (jj_scan_token(LPARENTHESIS)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_130()) jj_scanpos = xsp;
    else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(RPARENTHESIS)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_129() {
    if (jj_scan_token(LSQUAREBRACKET)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_110()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(RSQUAREBRACKET)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_305() {
    Token xsp;
    if (jj_3_129()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_129()) { jj_scanpos = xsp; break; }
      if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    }
    return false;
  }

  final private boolean jj_3_127() {
    if (jj_3R_133()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_257() {
    if (jj_3R_92()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_293()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_128()) jj_scanpos = xsp;
    else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_133() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_256()) {
    jj_scanpos = xsp;
    if (jj_3R_257()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_256() {
    if (jj_3R_305()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_126() {
    if (jj_3R_132()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_123() {
    if (jj_3R_53()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_455() {
    if (jj_3R_133()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_122() {
    if (jj_scan_token(LPARENTHESIS)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_107()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(RPARENTHESIS)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_255() {
    if (jj_3R_53()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_455()) jj_scanpos = xsp;
    else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_121() {
    if (jj_scan_token(LPARENTHESIS)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_96()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_398() {
    if (jj_3R_132()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_131() {
    if (jj_3R_255()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_124() {
    if (jj_scan_token(LPARENTHESIS)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_107()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(RPARENTHESIS)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_130() {
    if (jj_scan_token(LPARENTHESIS)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_107()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(RPARENTHESIS)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_120() {
    if (jj_scan_token(SCOPE)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_129() {
    if (jj_scan_token(LPARENTHESIS)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_96()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(RPARENTHESIS)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_125() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_129()) jj_scanpos = xsp;
    else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    xsp = jj_scanpos;
    if (jj_3R_130()) {
    jj_scanpos = xsp;
    if (jj_3R_131()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_397() {
    if (jj_scan_token(LPARENTHESIS)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_107()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(RPARENTHESIS)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_116() {
    if (jj_scan_token(LPARENTHESIS)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_396() {
    if (jj_scan_token(SCOPE)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_310() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_396()) jj_scanpos = xsp;
    else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(NEW)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    xsp = jj_scanpos;
    if (jj_3R_397()) {
    jj_scanpos = xsp;
    if (jj_3_125()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    xsp = jj_scanpos;
    if (jj_3R_398()) jj_scanpos = xsp;
    else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_119() {
    if (jj_3R_128()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_117() {
    if (jj_3R_125()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_495() {
    if (jj_scan_token(ARROWSTAR)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_435() {
    if (jj_scan_token(LPARENTHESIS)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_107()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(RPARENTHESIS)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_246() {
    if (jj_scan_token(SIZEOF)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_435()) {
    jj_scanpos = xsp;
    if (jj_3_117()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_494() {
    if (jj_scan_token(DOTSTAR)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_123() {
    if (jj_scan_token(MOD)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_118() {
    if (jj_3R_126()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_127()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_485() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_494()) {
    jj_scanpos = xsp;
    if (jj_3R_495()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_127()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_245() {
    if (jj_scan_token(MINUSMINUS)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_125()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_114() {
    if (jj_scan_token(LPARENTHESIS)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_107()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(RPARENTHESIS)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_125() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_244()) {
    jj_scanpos = xsp;
    if (jj_3R_245()) {
    jj_scanpos = xsp;
    if (jj_3_118()) {
    jj_scanpos = xsp;
    if (jj_3R_246()) {
    jj_scanpos = xsp;
    if (jj_3_119()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_244() {
    if (jj_scan_token(PLUSPLUS)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_125()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_122() {
    if (jj_scan_token(DIVIDE)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_467() {
    if (jj_scan_token(SHIFTRIGHT)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_115() {
    if (jj_3R_125()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_121() {
    if (jj_scan_token(STAR)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_119() {
    if (jj_scan_token(MINUS)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_466() {
    if (jj_scan_token(SHIFTLEFT)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_127() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_253()) {
    jj_scanpos = xsp;
    if (jj_3_115()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_253() {
    if (jj_scan_token(LPARENTHESIS)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_107()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(RPARENTHESIS)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_127()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_458() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_466()) {
    jj_scanpos = xsp;
    if (jj_3R_467()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_229()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_118() {
    if (jj_scan_token(PLUS)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_124() {
    if (jj_3R_127()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_485()) { jj_scanpos = xsp; break; }
      if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    }
    return false;
  }

  final private boolean jj_3R_493() {
    if (jj_scan_token(EQUAL)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_113() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_121()) {
    jj_scanpos = xsp;
    if (jj_3R_122()) {
    jj_scanpos = xsp;
    if (jj_3R_123()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_124()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_120() {
    if (jj_3R_124()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_113()) { jj_scanpos = xsp; break; }
      if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    }
    return false;
  }

  final private boolean jj_3R_492() {
    if (jj_scan_token(NOTEQUAL)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_112() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_118()) {
    jj_scanpos = xsp;
    if (jj_3R_119()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_120()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_229() {
    if (jj_3R_120()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_112()) { jj_scanpos = xsp; break; }
      if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    }
    return false;
  }

  final private boolean jj_3R_484() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_492()) {
    jj_scanpos = xsp;
    if (jj_3R_493()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_243()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_108() {
    if (jj_3R_229()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_458()) { jj_scanpos = xsp; break; }
      if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    }
    return false;
  }

  final private boolean jj_3_110() {
    if (jj_scan_token(AMPERSAND)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_113()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_117() {
    if (jj_scan_token(GREATERTHANOREQUALTO)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_116() {
    if (jj_scan_token(LESSTHANOREQUALTO)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_115() {
    if (jj_scan_token(GREATERTHAN)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_114() {
    if (jj_scan_token(LESSTHAN)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_452() {
    if (jj_scan_token(BITWISEOR)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_439()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_443() {
    if (jj_scan_token(AND)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_425()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_465() {
    if (jj_scan_token(BITWISEXOR)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_448()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_111() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_114()) {
    jj_scanpos = xsp;
    if (jj_3R_115()) {
    jj_scanpos = xsp;
    if (jj_3R_116()) {
    jj_scanpos = xsp;
    if (jj_3R_117()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_108()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_243() {
    if (jj_3R_108()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_111()) { jj_scanpos = xsp; break; }
      if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    }
    return false;
  }

  final private boolean jj_3R_433() {
    if (jj_scan_token(OR)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_370()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_113() {
    if (jj_3R_243()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_484()) { jj_scanpos = xsp; break; }
      if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    }
    return false;
  }

  final private boolean jj_3R_448() {
    if (jj_3R_113()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_110()) { jj_scanpos = xsp; break; }
      if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    }
    return false;
  }

  final private boolean jj_3R_439() {
    if (jj_3R_448()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_465()) { jj_scanpos = xsp; break; }
      if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    }
    return false;
  }

  final private boolean jj_3R_425() {
    if (jj_3R_439()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_452()) { jj_scanpos = xsp; break; }
      if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    }
    return false;
  }

  final private boolean jj_3R_370() {
    if (jj_3R_425()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_443()) { jj_scanpos = xsp; break; }
      if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    }
    return false;
  }

  final private boolean jj_3R_296() {
    if (jj_3R_370()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_433()) { jj_scanpos = xsp; break; }
      if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    }
    return false;
  }

  final private boolean jj_3R_94() {
    if (jj_3R_224()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_384() {
    if (jj_scan_token(QUESTIONMARK)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_224()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(COLON)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_224()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_109() {
    if (jj_scan_token(COMMA)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_103()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_224() {
    if (jj_3R_296()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_384()) jj_scanpos = xsp;
    else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_395() {
    if (jj_scan_token(BITWISEOREQUAL)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_394() {
    if (jj_scan_token(BITWISEXOREQUAL)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_393() {
    if (jj_scan_token(BITWISEANDEQUAL)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_392() {
    if (jj_scan_token(SHIFTRIGHTEQUAL)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_391() {
    if (jj_scan_token(SHIFTLEFTEQUAL)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_390() {
    if (jj_scan_token(MINUSEQUAL)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_430() {
    if (jj_scan_token(SEMICOLON)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_389() {
    if (jj_scan_token(PLUSEQUAL)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_388() {
    if (jj_scan_token(MODEQUAL)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_387() {
    if (jj_scan_token(DIVIDEEQUAL)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_385() {
    if (jj_scan_token(ASSIGNEQUAL)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_386() {
    if (jj_scan_token(TIMESEQUAL)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_304() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_385()) {
    jj_scanpos = xsp;
    if (jj_3R_386()) {
    jj_scanpos = xsp;
    if (jj_3R_387()) {
    jj_scanpos = xsp;
    if (jj_3R_388()) {
    jj_scanpos = xsp;
    if (jj_3R_389()) {
    jj_scanpos = xsp;
    if (jj_3R_390()) {
    jj_scanpos = xsp;
    if (jj_3R_391()) {
    jj_scanpos = xsp;
    if (jj_3R_392()) {
    jj_scanpos = xsp;
    if (jj_3R_393()) {
    jj_scanpos = xsp;
    if (jj_3R_394()) {
    jj_scanpos = xsp;
    if (jj_3R_395()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_103()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_103() {
    if (jj_3R_224()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_304()) jj_scanpos = xsp;
    else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_108() {
    if (jj_3R_103()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_379() {
    if (jj_3R_429()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_110() {
    if (jj_3R_103()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3_109()) { jj_scanpos = xsp; break; }
      if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    }
    return false;
  }

  final private boolean jj_3R_302() {
    if (jj_scan_token(THROW)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_108()) jj_scanpos = xsp;
    else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(SEMICOLON)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_103() {
    if (jj_3R_110()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(SEMICOLON)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_461() {
    if (jj_scan_token(ELLIPSIS)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_107() {
    if (jj_3R_98()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_449() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_107()) {
    jj_scanpos = xsp;
    if (jj_3R_461()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_441() {
    if (jj_scan_token(142)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_298()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_429() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_440()) {
    jj_scanpos = xsp;
    if (jj_3R_441()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_440() {
    if (jj_scan_token(CATCH)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(LPARENTHESIS)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_449()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(RPARENTHESIS)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_298()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_106() {
    if (jj_3R_110()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_105() {
    if (jj_3R_110()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_301() {
    if (jj_scan_token(TRY)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_298()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    Token xsp;
    while (true) {
      xsp = jj_scanpos;
      if (jj_3R_379()) { jj_scanpos = xsp; break; }
      if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    }
    return false;
  }

  final private boolean jj_3R_378() {
    if (jj_scan_token(RETURN)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_106()) jj_scanpos = xsp;
    else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(SEMICOLON)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_102() {
    if (jj_3R_61()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_377() {
    if (jj_scan_token(BREAK)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(SEMICOLON)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_376() {
    if (jj_scan_token(CONTINUE)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(SEMICOLON)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_300() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_375()) {
    jj_scanpos = xsp;
    if (jj_3R_376()) {
    jj_scanpos = xsp;
    if (jj_3R_377()) {
    jj_scanpos = xsp;
    if (jj_3R_378()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_375() {
    if (jj_scan_token(GOTO)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(ID)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(SEMICOLON)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_104() {
    if (jj_3R_110()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_382() {
    if (jj_scan_token(FOR)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(LPARENTHESIS)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_102()) {
    jj_scanpos = xsp;
    if (jj_3_103()) {
    jj_scanpos = xsp;
    if (jj_3R_430()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    xsp = jj_scanpos;
    if (jj_3_104()) jj_scanpos = xsp;
    else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(SEMICOLON)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    xsp = jj_scanpos;
    if (jj_3_105()) jj_scanpos = xsp;
    else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(RPARENTHESIS)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_109()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_381() {
    if (jj_scan_token(DO)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_109()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(WHILE)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(LPARENTHESIS)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_110()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(RPARENTHESIS)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(SEMICOLON)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_303() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_380()) {
    jj_scanpos = xsp;
    if (jj_3R_381()) {
    jj_scanpos = xsp;
    if (jj_3R_382()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_380() {
    if (jj_scan_token(WHILE)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(LPARENTHESIS)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_110()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(RPARENTHESIS)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_109()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_101() {
    if (jj_scan_token(ELSE)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_109()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_374() {
    if (jj_scan_token(SWITCH)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(LPARENTHESIS)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_110()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(RPARENTHESIS)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_109()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_299() {
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3R_373()) {
    jj_scanpos = xsp;
    if (jj_3R_374()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    } else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_373() {
    if (jj_scan_token(IF)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(LPARENTHESIS)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_110()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(RPARENTHESIS)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_109()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_101()) jj_scanpos = xsp;
    else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3_100() {
    if (jj_3R_112()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_298() {
    if (jj_scan_token(LCURLYBRACE)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    Token xsp;
    xsp = jj_scanpos;
    if (jj_3_100()) jj_scanpos = xsp;
    else if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(RCURLYBRACE)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_241() {
    if (jj_scan_token(_DEFAULT)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(COLON)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_109()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  final private boolean jj_3R_240() {
    if (jj_scan_token(CASE)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_94()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_scan_token(COLON)) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    if (jj_3R_109()) return true;
    if (jj_la == 0 && jj_scanpos == jj_lastpos) return false;
    return false;
  }

  public CPPParserTokenManager token_source;
  SimpleCharStream jj_input_stream;
  public Token token, jj_nt;
  private int jj_ntk;
  private Token jj_scanpos, jj_lastpos;
  private int jj_la;
  public boolean lookingAhead = false;
  private boolean jj_semLA;
  private int jj_gen;
  final private int[] jj_la1 = new int[128];
  static private int[] jj_la1_0;
  static private int[] jj_la1_1;
  static private int[] jj_la1_2;
  static private int[] jj_la1_3;
  static private int[] jj_la1_4;
  static {
      jj_la1_0();
      jj_la1_1();
      jj_la1_2();
      jj_la1_3();
      jj_la1_4();
   }
   private static void jj_la1_0() {
      jj_la1_0 = new int[] {0x0,0x0,0x40000000,0x0,0x50000000,0x50000000,0x0,0x0,0x40000000,0x1000000,0x1000000,0x50000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x40000000,0x0,0x0,0x40000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x10000000,0x10000000,0x0,0x80000000,0x0,0x0,0x80000000,0x1000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x50000000,0x50000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1000000,0x0,0x0,0x40000000,0x0,0x50000000,0x50000000,0x4000000,0x0,0x14000000,0x40000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x80000000,0x81000000,0x0,0x0,0x0,0x0,0x0,0x14000000,0x4000000,0x54000000,0x14000000,0x0,0x0,0x1000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x44000000,0x40000000,0x4000000,0x0,0x14000000,0x0,0x10000000,0x40000000,0x0,0x0,0x0,0x14000000,0x0,};
   }
   private static void jj_la1_1() {
      jj_la1_1 = new int[] {0x0,0x0,0x0,0x0,0x40080000,0x40080000,0x0,0x1,0x40080000,0x1,0x0,0x40080000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x400000,0x0,0x400000,0x400000,0x0,0x400000,0x0,0x0,0x0,0x0,0x0,0x2,0x10,0x10,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x2,0x0,0x0,0x0,0x0,0x400000,0x0,0x40080000,0x40080000,0x1,0x10,0x2,0x10,0x40080000,0x40080000,0x0,0x0,0x2,0x10,0x40080000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1,0x2,0x2,0x8,0x10,0x2,0x0,0x0,0x40080000,0x0,0x2,0x2,0x1,0x0,0x0,0x0,0x1,0x0,0x0,0x0,0x0,0x8,0x7ff0,0x7ff0,0x4,0x8000,0x10000,0x20000,0x40000,0x300000,0x300000,0x3c00000,0xc000000,0xc000000,0x30000000,0xc0000000,0x0,0x0,0x0,0x0,0x40080000,0x0,0x0,0x70080000,0x0,0x0,0x0,0x0,0x2,0x0,0x40080000,0xfffffff2,0x2,};
   }
   private static void jj_la1_2() {
      jj_la1_2 = new int[] {0x0,0x0,0x0,0x0,0x8,0x8,0x0,0x0,0x0,0x0,0x0,0x8,0x400000,0x12404200,0x200000,0x12404200,0x200000,0x12404200,0x60882000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x4000,0x400200,0x400200,0x60882000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x8,0x8,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x4000,0x8,0x0,0x0,0x0,0x0,0x0,0x0,0x10000000,0x0,0x10000000,0x10000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xc008400,0x1040000,0x10800,0x8000000,0x0,0x1040000,0x4008400,0x1000,0x1000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1,0x180,0x180,0x6,0x0,0x0,0x0,0x0,0x18,0x66,0x8,0x0,0x8,0x0,0x0,0x0,0x8002015f,0x0,};
   }
   private static void jj_la1_3() {
      jj_la1_3 = new int[] {0x10000000,0x0,0x0,0x2000,0x800000,0x800000,0x2000,0x0,0x800000,0x0,0x0,0x800000,0x0,0x290210,0x20c00,0x290210,0x20c00,0x290210,0x1400c0,0x0,0x0,0x0,0x0,0x0,0x0,0x800000,0x200000,0x210,0x10210,0x1400c0,0x0,0x0,0x0,0x20c00,0x0,0x0,0x20c00,0x0,0x0,0x0,0x0,0x7,0x80000,0x80007,0x80007,0x0,0x7,0x800000,0x800000,0x7,0x0,0x0,0x0,0x0,0x0,0x4000000,0x0,0x0,0x0,0x0,0x200000,0x800000,0x800000,0x0,0x4000000,0x0,0x800000,0x4000000,0x0,0x80000,0x80000,0x80000,0x2000,0x4000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x4009020,0x400000,0x0,0x1000,0x0,0x400000,0x20,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x100,0x0,0x0,0x0,0x0,0x0,0x800000,0x4000,0xe3800000,0x0,0xe3000000,0x0,0x0,0x0,};
   }
   private static void jj_la1_4() {
      jj_la1_4 = new int[] {0x0,0x8000,0x0,0x0,0x8000,0x8000,0x0,0x0,0x8000,0x0,0x0,0x8000,0x0,0x0,0x0,0x0,0x0,0x0,0x2000,0x0,0x8000,0x0,0x0,0x8000,0x0,0x8000,0x0,0x0,0x0,0x2000,0x0,0x0,0x0,0x0,0x0,0x8000,0x0,0x0,0x0,0x8000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x8000,0x8000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x8000,0x0,0x0,0x8000,0x0,0x8000,0x8000,0x0,0x0,0x0,0x8000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x8000,0x0,0x0,0x0,0x0,0x0,0x8000,0x0,0x0,0x0,0x0,0x4000,0x4000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x8000,0x0,0x0,0x0,0x0,0x8000,0x1000,0x8fff,0x0,0xfff,0x0,0x0,0x0,};
   }
  final private JJCalls[] jj_2_rtns = new JJCalls[143];
  private boolean jj_rescan = false;
  private int jj_gc = 0;

  public CPPParser(java.io.InputStream stream) {
    jj_input_stream = new SimpleCharStream(stream, 1, 1);
    token_source = new CPPParserTokenManager(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 128; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  public void ReInit(java.io.InputStream stream) {
    jj_input_stream.ReInit(stream, 1, 1);
    token_source.ReInit(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 128; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  public CPPParser(java.io.Reader stream) {
    jj_input_stream = new SimpleCharStream(stream, 1, 1);
    token_source = new CPPParserTokenManager(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 128; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  public void ReInit(java.io.Reader stream) {
    jj_input_stream.ReInit(stream, 1, 1);
    token_source.ReInit(jj_input_stream);
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 128; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  public CPPParser(CPPParserTokenManager tm) {
    token_source = tm;
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 128; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  public void ReInit(CPPParserTokenManager tm) {
    token_source = tm;
    token = new Token();
    jj_ntk = -1;
    jj_gen = 0;
    for (int i = 0; i < 128; i++) jj_la1[i] = -1;
    for (int i = 0; i < jj_2_rtns.length; i++) jj_2_rtns[i] = new JJCalls();
  }

  final private Token jj_consume_token(int kind) throws ParseException {
    Token oldToken;
    if ((oldToken = token).next != null) token = token.next;
    else token = token.next = token_source.getNextToken();
    jj_ntk = -1;
    if (token.kind == kind) {
      jj_gen++;
      if (++jj_gc > 100) {
        jj_gc = 0;
        for (int i = 0; i < jj_2_rtns.length; i++) {
          JJCalls c = jj_2_rtns[i];
          while (c != null) {
            if (c.gen < jj_gen) c.first = null;
            c = c.next;
          }
        }
      }
      return token;
    }
    token = oldToken;
    jj_kind = kind;
    throw generateParseException();
  }

  final private boolean jj_scan_token(int kind) {
    if (jj_scanpos == jj_lastpos) {
      jj_la--;
      if (jj_scanpos.next == null) {
        jj_lastpos = jj_scanpos = jj_scanpos.next = token_source.getNextToken();
      } else {
        jj_lastpos = jj_scanpos = jj_scanpos.next;
      }
    } else {
      jj_scanpos = jj_scanpos.next;
    }
    if (jj_rescan) {
      int i = 0; Token tok = token;
      while (tok != null && tok != jj_scanpos) { i++; tok = tok.next; }
      if (tok != null) jj_add_error_token(kind, i);
    }
    return (jj_scanpos.kind != kind);
  }

  final public Token getNextToken() {
    if (token.next != null) token = token.next;
    else token = token.next = token_source.getNextToken();
    jj_ntk = -1;
    jj_gen++;
    return token;
  }

  final public Token getToken(int index) {
    Token t = lookingAhead ? jj_scanpos : token;
    for (int i = 0; i < index; i++) {
      if (t.next != null) t = t.next;
      else t = t.next = token_source.getNextToken();
    }
    return t;
  }

  final private int jj_ntk() {
    if ((jj_nt=token.next) == null)
      return (jj_ntk = (token.next=token_source.getNextToken()).kind);
    else
      return (jj_ntk = jj_nt.kind);
  }

  private java.util.Vector jj_expentries = new java.util.Vector();
  private int[] jj_expentry;
  private int jj_kind = -1;
  private int[] jj_lasttokens = new int[100];
  private int jj_endpos;

  private void jj_add_error_token(int kind, int pos) {
    if (pos >= 100) return;
    if (pos == jj_endpos + 1) {
      jj_lasttokens[jj_endpos++] = kind;
    } else if (jj_endpos != 0) {
      jj_expentry = new int[jj_endpos];
      for (int i = 0; i < jj_endpos; i++) {
        jj_expentry[i] = jj_lasttokens[i];
      }
      boolean exists = false;
      for (java.util.Enumeration enume = jj_expentries.elements(); enume.hasMoreElements();) {
        int[] oldentry = (int[])(enume.nextElement());
        if (oldentry.length == jj_expentry.length) {
          exists = true;
          for (int i = 0; i < jj_expentry.length; i++) {
            if (oldentry[i] != jj_expentry[i]) {
              exists = false;
              break;
            }
          }
          if (exists) break;
        }
      }
      if (!exists) jj_expentries.addElement(jj_expentry);
      if (pos != 0) jj_lasttokens[(jj_endpos = pos) - 1] = kind;
    }
  }

  public ParseException generateParseException() {
    jj_expentries.removeAllElements();
    boolean[] la1tokens = new boolean[144];
    for (int i = 0; i < 144; i++) {
      la1tokens[i] = false;
    }
    if (jj_kind >= 0) {
      la1tokens[jj_kind] = true;
      jj_kind = -1;
    }
    for (int i = 0; i < 128; i++) {
      if (jj_la1[i] == jj_gen) {
        for (int j = 0; j < 32; j++) {
          if ((jj_la1_0[i] & (1<<j)) != 0) {
            la1tokens[j] = true;
          }
          if ((jj_la1_1[i] & (1<<j)) != 0) {
            la1tokens[32+j] = true;
          }
          if ((jj_la1_2[i] & (1<<j)) != 0) {
            la1tokens[64+j] = true;
          }
          if ((jj_la1_3[i] & (1<<j)) != 0) {
            la1tokens[96+j] = true;
          }
          if ((jj_la1_4[i] & (1<<j)) != 0) {
            la1tokens[128+j] = true;
          }
        }
      }
    }
    for (int i = 0; i < 144; i++) {
      if (la1tokens[i]) {
        jj_expentry = new int[1];
        jj_expentry[0] = i;
        jj_expentries.addElement(jj_expentry);
      }
    }
    jj_endpos = 0;
    jj_rescan_token();
    jj_add_error_token(0, 0);
    int[][] exptokseq = new int[jj_expentries.size()][];
    for (int i = 0; i < jj_expentries.size(); i++) {
      exptokseq[i] = (int[])jj_expentries.elementAt(i);
    }
    return new ParseException(token, exptokseq, tokenImage);
  }

  final public void enable_tracing() {
  }

  final public void disable_tracing() {
  }

  final private void jj_rescan_token() {
    jj_rescan = true;
    for (int i = 0; i < 143; i++) {
      JJCalls p = jj_2_rtns[i];
      do {
        if (p.gen > jj_gen) {
          jj_la = p.arg; jj_lastpos = jj_scanpos = p.first;
          switch (i) {
            case 0: jj_3_1(); break;
            case 1: jj_3_2(); break;
            case 2: jj_3_3(); break;
            case 3: jj_3_4(); break;
            case 4: jj_3_5(); break;
            case 5: jj_3_6(); break;
            case 6: jj_3_7(); break;
            case 7: jj_3_8(); break;
            case 8: jj_3_9(); break;
            case 9: jj_3_10(); break;
            case 10: jj_3_11(); break;
            case 11: jj_3_12(); break;
            case 12: jj_3_13(); break;
            case 13: jj_3_14(); break;
            case 14: jj_3_15(); break;
            case 15: jj_3_16(); break;
            case 16: jj_3_17(); break;
            case 17: jj_3_18(); break;
            case 18: jj_3_19(); break;
            case 19: jj_3_20(); break;
            case 20: jj_3_21(); break;
            case 21: jj_3_22(); break;
            case 22: jj_3_23(); break;
            case 23: jj_3_24(); break;
            case 24: jj_3_25(); break;
            case 25: jj_3_26(); break;
            case 26: jj_3_27(); break;
            case 27: jj_3_28(); break;
            case 28: jj_3_29(); break;
            case 29: jj_3_30(); break;
            case 30: jj_3_31(); break;
            case 31: jj_3_32(); break;
            case 32: jj_3_33(); break;
            case 33: jj_3_34(); break;
            case 34: jj_3_35(); break;
            case 35: jj_3_36(); break;
            case 36: jj_3_37(); break;
            case 37: jj_3_38(); break;
            case 38: jj_3_39(); break;
            case 39: jj_3_40(); break;
            case 40: jj_3_41(); break;
            case 41: jj_3_42(); break;
            case 42: jj_3_43(); break;
            case 43: jj_3_44(); break;
            case 44: jj_3_45(); break;
            case 45: jj_3_46(); break;
            case 46: jj_3_47(); break;
            case 47: jj_3_48(); break;
            case 48: jj_3_49(); break;
            case 49: jj_3_50(); break;
            case 50: jj_3_51(); break;
            case 51: jj_3_52(); break;
            case 52: jj_3_53(); break;
            case 53: jj_3_54(); break;
            case 54: jj_3_55(); break;
            case 55: jj_3_56(); break;
            case 56: jj_3_57(); break;
            case 57: jj_3_58(); break;
            case 58: jj_3_59(); break;
            case 59: jj_3_60(); break;
            case 60: jj_3_61(); break;
            case 61: jj_3_62(); break;
            case 62: jj_3_63(); break;
            case 63: jj_3_64(); break;
            case 64: jj_3_65(); break;
            case 65: jj_3_66(); break;
            case 66: jj_3_67(); break;
            case 67: jj_3_68(); break;
            case 68: jj_3_69(); break;
            case 69: jj_3_70(); break;
            case 70: jj_3_71(); break;
            case 71: jj_3_72(); break;
            case 72: jj_3_73(); break;
            case 73: jj_3_74(); break;
            case 74: jj_3_75(); break;
            case 75: jj_3_76(); break;
            case 76: jj_3_77(); break;
            case 77: jj_3_78(); break;
            case 78: jj_3_79(); break;
            case 79: jj_3_80(); break;
            case 80: jj_3_81(); break;
            case 81: jj_3_82(); break;
            case 82: jj_3_83(); break;
            case 83: jj_3_84(); break;
            case 84: jj_3_85(); break;
            case 85: jj_3_86(); break;
            case 86: jj_3_87(); break;
            case 87: jj_3_88(); break;
            case 88: jj_3_89(); break;
            case 89: jj_3_90(); break;
            case 90: jj_3_91(); break;
            case 91: jj_3_92(); break;
            case 92: jj_3_93(); break;
            case 93: jj_3_94(); break;
            case 94: jj_3_95(); break;
            case 95: jj_3_96(); break;
            case 96: jj_3_97(); break;
            case 97: jj_3_98(); break;
            case 98: jj_3_99(); break;
            case 99: jj_3_100(); break;
            case 100: jj_3_101(); break;
            case 101: jj_3_102(); break;
            case 102: jj_3_103(); break;
            case 103: jj_3_104(); break;
            case 104: jj_3_105(); break;
            case 105: jj_3_106(); break;
            case 106: jj_3_107(); break;
            case 107: jj_3_108(); break;
            case 108: jj_3_109(); break;
            case 109: jj_3_110(); break;
            case 110: jj_3_111(); break;
            case 111: jj_3_112(); break;
            case 112: jj_3_113(); break;
            case 113: jj_3_114(); break;
            case 114: jj_3_115(); break;
            case 115: jj_3_116(); break;
            case 116: jj_3_117(); break;
            case 117: jj_3_118(); break;
            case 118: jj_3_119(); break;
            case 119: jj_3_120(); break;
            case 120: jj_3_121(); break;
            case 121: jj_3_122(); break;
            case 122: jj_3_123(); break;
            case 123: jj_3_124(); break;
            case 124: jj_3_125(); break;
            case 125: jj_3_126(); break;
            case 126: jj_3_127(); break;
            case 127: jj_3_128(); break;
            case 128: jj_3_129(); break;
            case 129: jj_3_130(); break;
            case 130: jj_3_131(); break;
            case 131: jj_3_132(); break;
            case 132: jj_3_133(); break;
            case 133: jj_3_134(); break;
            case 134: jj_3_135(); break;
            case 135: jj_3_136(); break;
            case 136: jj_3_137(); break;
            case 137: jj_3_138(); break;
            case 138: jj_3_139(); break;
            case 139: jj_3_140(); break;
            case 140: jj_3_141(); break;
            case 141: jj_3_142(); break;
            case 142: jj_3_143(); break;
          }
        }
        p = p.next;
      } while (p != null);
    }
    jj_rescan = false;
  }

  final private void jj_save(int index, int xla) {
    JJCalls p = jj_2_rtns[index];
    while (p.gen > jj_gen) {
      if (p.next == null) { p = p.next = new JJCalls(); break; }
      p = p.next;
    }
    p.gen = jj_gen + xla - jj_la; p.first = token; p.arg = xla;
  }

  static final class JJCalls {
    int gen;
    Token first;
    int arg;
    JJCalls next;
  }

}
