/*
 * Decompiled with CFR 0.152.
 */
package jp.riken.brain.ni.samuraigraph.data;

import java.io.IOException;
import java.io.Writer;
import java.text.ParseException;
import java.util.Calendar;
import jp.riken.brain.ni.samuraigraph.base.SGData;
import jp.riken.brain.ni.samuraigraph.base.SGUtility;
import jp.riken.brain.ni.samuraigraph.base.SGUtilityText;
import jp.riken.brain.ni.samuraigraph.data.SGDateData;
import jp.riken.brain.ni.samuraigraph.data.SGISXYTypeData;
import jp.riken.brain.ni.samuraigraph.data.SGSXYData;

public class SGSXYDateData
extends SGDateData
implements SGISXYTypeData {
    private SGSXYData mData = null;

    public SGSXYDateData() {
    }

    public SGSXYDateData(String[] stringArray, String[] stringArray2, double[] dArray) throws ParseException {
        this(stringArray, stringArray2, dArray, null, null, null);
    }

    public SGSXYDateData(String[] stringArray, String[] stringArray2, double[] dArray, String[] stringArray3) throws ParseException {
        this(stringArray, stringArray2, dArray, null, null, stringArray3);
    }

    public SGSXYDateData(String[] stringArray, String[] stringArray2, double[] dArray, double[] dArray2, double[] dArray3) throws ParseException {
        this(stringArray, stringArray2, dArray, dArray2, dArray3, null);
    }

    public SGSXYDateData(String[] stringArray, String[] stringArray2, double[] dArray, double[] dArray2, double[] dArray3, String[] stringArray3) throws ParseException {
        super(stringArray, stringArray2);
        if (dArray.length != stringArray2.length) {
            throw new IllegalArgumentException("yValueArray.length!=dateArray.length");
        }
        if (dArray2 != null & dArray3 != null) {
            if (dArray2.length != stringArray2.length) {
                throw new IllegalArgumentException("lowerErrorArray.length!=dateArray.length");
            }
            if (dArray3.length != stringArray2.length) {
                throw new IllegalArgumentException("upperErrorArray.length!=dateArray.length");
            }
        }
        if (stringArray3 != null && stringArray3.length != stringArray2.length) {
            throw new IllegalArgumentException("labelArray.length!=dateArray.length");
        }
        double[] dArray4 = this.calcXValueArray();
        String[] stringArray4 = stringArray3 != null ? SGUtility.copyStringArray(stringArray3) : SGUtility.copyStringArray(stringArray2);
        this.mData = new SGSXYData(null, dArray4, dArray, dArray2, dArray3, stringArray4);
    }

    public SGSXYDateData(String[] stringArray, int[] nArray, int[] nArray2, int[] nArray3, double[] dArray) {
        this(stringArray, nArray, nArray2, nArray3, null, null, dArray);
    }

    public SGSXYDateData(String[] stringArray, int[] nArray, int[] nArray2, int[] nArray3, double[] dArray, double[] dArray2, double[] dArray3) {
        super(stringArray, nArray, nArray2, nArray3);
        if (dArray == null) {
            throw new IllegalArgumentException("yValueArray==null");
        }
        if (dArray.length != nArray.length) {
            throw new IllegalArgumentException("yValueArray.length!=yearArray.length");
        }
        if (dArray2 != null & dArray3 != null) {
            if (dArray2.length != nArray.length) {
                throw new IllegalArgumentException("lowerErrorArray.length!=yearArray.length");
            }
            if (dArray3.length != nArray.length) {
                throw new IllegalArgumentException("upperErrorArray.length!=yearArray.length");
            }
        }
        double[] dArray4 = this.calcXValueArray();
        String[] stringArray2 = this.getStringArray(nArray, nArray2, nArray3);
        this.mData = new SGSXYData(null, dArray4, dArray, dArray2, dArray3, stringArray2);
    }

    private double[] calcXValueArray() {
        SGDateData.InnerDate[] innerDateArray = this.mDateArray;
        int n = innerDateArray.length;
        double[] dArray = new double[n];
        Calendar calendar = Calendar.getInstance();
        for (int i = 0; i < n; ++i) {
            SGDateData.InnerDate innerDate = innerDateArray[i];
            calendar.set(innerDate.year, innerDate.month, innerDate.date);
            dArray[i] = calendar.getTimeInMillis() / 86400000L;
        }
        return dArray;
    }

    private String[] getStringArray(int[] nArray, int[] nArray2, int[] nArray3) {
        String[] stringArray = new String[nArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            SGDateData.InnerDate innerDate = new SGDateData.InnerDate(nArray[i], nArray2[i], nArray3[i]);
            stringArray[i] = innerDate.mDateString;
        }
        return stringArray;
    }

    public int getPointsNumber() {
        return this.mData.getPointsNumber();
    }

    public String getDataType() {
        return "SXY_DATE";
    }

    public boolean setData(SGData sGData) {
        if (!(sGData instanceof SGSXYDateData)) {
            throw new IllegalArgumentException("!(data instanceof SGSXYCalendarData)");
        }
        if (!super.setData(sGData)) {
            return false;
        }
        SGSXYDateData sGSXYDateData = (SGSXYDateData)sGData;
        this.mData = (SGSXYData)sGSXYDateData.mData.copy();
        return true;
    }

    public double getMinValueX() {
        return this.mData.getMinValueX();
    }

    public double getMaxValueX() {
        return this.mData.getMaxValueX();
    }

    public double getMinValueY() {
        return this.mData.getMinValueY();
    }

    public double getMaxValueY() {
        return this.mData.getMaxValueY();
    }

    public Double getXValue(int n) {
        return this.mData.getXValue(n);
    }

    public Double getYValue(int n) {
        return this.mData.getYValue(n);
    }

    public Double getLowerErrorValue(int n) {
        return this.mData.getLowerErrorValue(n);
    }

    public Double getUpperErrorValue(int n) {
        return this.mData.getUpperErrorValue(n);
    }

    public String getString(int n) {
        return this.mData.getString(n);
    }

    public double[] getXValueArray() {
        return this.mData.getXValueArray();
    }

    public double[] getYValueArray() {
        return this.mData.getYValueArray();
    }

    public double[] getLowerErrorValueArray() {
        return this.mData.getLowerErrorValueArray();
    }

    public double[] getUpperErrorValueArray() {
        return this.mData.getUpperErrorValueArray();
    }

    public String[] getStringArray() {
        return this.mData.getStringArray();
    }

    public boolean isErrorValueHolding() {
        return this.mData.isErrorValueHolding();
    }

    public boolean isStringArrayHolding() {
        return this.mData.isStringArrayHolding();
    }

    public void dispose() {
        super.dispose();
        this.mData = null;
    }

    protected boolean writeData(Writer writer) throws IOException {
        if (this.mData == null || this.mData.mXValueArray.length == 0) {
            return false;
        }
        for (int i = 0; i < this.mData.mXValueArray.length; ++i) {
            String string = this.mDateArray[i].mDateString + "," + this.mData.mYValueArray[i];
            if (this.mData.mUpperErrorArray != null) {
                string = string + "," + this.mData.mUpperErrorArray[i] + "," + this.mData.mLowerErrorArray[i];
            }
            if (this.mData.mStringArray[i] != null) {
                string = string + "," + SGUtilityText.getCSVString(this.mData.mStringArray[i]);
            }
            string = string + "\n";
            writer.write(string);
        }
        return true;
    }
}

