/*
 * Decompiled with CFR 0.152.
 */
package jp.riken.brain.ni.samuraigraph.base;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.MediaTracker;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.print.attribute.standard.MediaSize;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import jp.riken.brain.ni.samuraigraph.base.SGClientPanel;
import jp.riken.brain.ni.samuraigraph.base.SGData;
import jp.riken.brain.ni.samuraigraph.base.SGFigure;
import jp.riken.brain.ni.samuraigraph.base.SGIConstants;
import jp.riken.brain.ni.samuraigraph.base.SGIFigureElement;
import jp.riken.brain.ni.samuraigraph.base.SGIImageExportManager;
import jp.riken.brain.ni.samuraigraph.base.SGINode;
import jp.riken.brain.ni.samuraigraph.base.SGIPaintable;
import jp.riken.brain.ni.samuraigraph.base.SGIPropertyDialogObserver;
import jp.riken.brain.ni.samuraigraph.base.SGIRootObject;
import jp.riken.brain.ni.samuraigraph.base.SGIRootObjectConstants;
import jp.riken.brain.ni.samuraigraph.base.SGISelectable;
import jp.riken.brain.ni.samuraigraph.base.SGIUndoable;
import jp.riken.brain.ni.samuraigraph.base.SGIWindowDialogObserver;
import jp.riken.brain.ni.samuraigraph.base.SGImage;
import jp.riken.brain.ni.samuraigraph.base.SGMenuBar;
import jp.riken.brain.ni.samuraigraph.base.SGProperties;
import jp.riken.brain.ni.samuraigraph.base.SGPropertyDialog;
import jp.riken.brain.ni.samuraigraph.base.SGStatusBar;
import jp.riken.brain.ni.samuraigraph.base.SGToolBar;
import jp.riken.brain.ni.samuraigraph.base.SGTuple2f;
import jp.riken.brain.ni.samuraigraph.base.SGUndoManager;
import jp.riken.brain.ni.samuraigraph.base.SGUtility;
import jp.riken.brain.ni.samuraigraph.base.SGUtilityNumber;
import jp.riken.brain.ni.samuraigraph.base.SGUtilityText;
import jp.riken.brain.ni.samuraigraph.base.SGWindowDialog;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SGDrawingWindow
extends JFrame
implements ComponentListener,
PropertyChangeListener,
MenuListener,
ActionListener,
SGIUndoable,
SGINode,
SGIRootObject,
SGIWindowDialogObserver {
    private int mID;
    private float mMagnification = 1.0f;
    private boolean mAutoZoomFlag = false;
    private SGClientPanel mClientPanel;
    private SGWindowDialog mDialog = null;
    private SGIImageExportManager mImageExportManager;
    private final SGTuple2f mTemporaryViewportSize = new SGTuple2f();
    private SGToolBar mToolBar;
    private SGStatusBar mStatusBar;
    private boolean mLockFigureFlag = false;
    private int mMode = 1;
    private SGProperties mTemporaryProperties = null;
    private final SGTuple2f mPaperOrigin = new SGTuple2f();
    private Rectangle2D mClientRect = null;
    public static final String TITLE = "Samurai Graph";
    private ArrayList mCopiedFiguresList = new ArrayList();
    private ArrayList mCopiedObjectsList = new ArrayList();
    private ArrayList mCopiedDataObjectsList = new ArrayList();
    private ArrayList mCopiedDataNameList = new ArrayList();
    private ArrayList mCopiedDataPropertiesMapList = new ArrayList();
    private static final String[] IMAGE_FILENAMES_ARRAY = new String[]{"Samurai.gif"};
    private int mIDCounter = 0;
    private final List mFigureList = new ArrayList();
    private boolean mPaperPortraitFlag = true;
    public static final float PAPER_MARGIN = 56.692917f;
    protected final Point mTempMouseLocation = new Point();
    private ArrayList mActionListenerList = new ArrayList();
    private Map mInsertFlagMap;
    private ArrayList mPasteTargetList = new ArrayList();
    private final Rectangle2D mTempPaperRect = new Rectangle2D.Float();
    private static final float BOUNDING_BOX_MARGIN;
    private Rectangle2D mTempRect = new Rectangle2D.Double();
    private SGUndoManager mUndoManager = new SGUndoManager(this);
    private SGMenuBar mMenuBar = new SGMenuBar();
    private InfoForExport mExportInfo = null;
    private ExportPanel mExportTarget = null;
    private int mPropertyFileCreationModeOfFigures;
    private int mSavedListIndex = -1;

    public SGDrawingWindow() {
        this.setTitle(TITLE);
        this.create();
        this.setDefaultCloseOperation(2);
    }

    public String toString() {
        return new String("SGDrawingWindow:" + this.getID());
    }

    private Map loadImages() {
        String[] stringArray = IMAGE_FILENAMES_ARRAY;
        int n = stringArray.length;
        ImageIcon[] imageIconArray = new ImageIcon[n];
        for (int i = 0; i < n; ++i) {
            imageIconArray[i] = this.createIcon(stringArray[i]);
        }
        MediaTracker mediaTracker = new MediaTracker(this);
        HashMap<String, ImageIcon> hashMap = new HashMap<String, ImageIcon>();
        for (int i = 0; i < n; ++i) {
            hashMap.put(stringArray[i], imageIconArray[i]);
            mediaTracker.addImage(imageIconArray[i].getImage(), i);
        }
        try {
            mediaTracker.waitForAll();
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
        return hashMap;
    }

    private boolean create() {
        Map map = this.loadImages();
        SwingUtilities.updateComponentTreeUI(this);
        ImageIcon imageIcon = (ImageIcon)map.get("Samurai.gif");
        this.setIconImage(imageIcon.getImage());
        this.createPropertyDialog();
        this.createMenuBar();
        this.createToolBar();
        this.createStatusBar();
        this.createClientPanel();
        this.pack();
        this.initInsertFlagMap();
        this.updateItemsByFigureNumbers();
        this.updateGridItems();
        this.updatePaperItems();
        this.updateUndoItems();
        this.updateFocusedObjectItem();
        this.updateZoomItems();
        this.updateSnapToGridItems();
        this.updateModeMenuItems();
        this.setSaved(false);
        return true;
    }

    public void updateItemsByFigureNumbers() {
        boolean bl = this.getVisibleFigureList().size() != 0;
        SGToolBar sGToolBar = this.mToolBar;
        sGToolBar.setButtonEnabled("Export as Image", bl);
        sGToolBar.setButtonEnabled("Save Property", bl);
        sGToolBar.setButtonEnabled("Print", bl);
        sGToolBar.setButtonEnabled("Bounding Box", bl);
        sGToolBar.setInsertToggleButtonsEnabled(bl);
        SGMenuBar sGMenuBar = this.mMenuBar;
        sGMenuBar.setMenuItemEnabled("File", "Export as Image", bl);
        sGMenuBar.setMenuItemEnabled("File", "Save Property", bl);
        sGMenuBar.setMenuItemEnabled("File", "Save Data Set", bl);
        sGMenuBar.setMenuItemEnabled("File", "Print", bl);
        sGMenuBar.setMenuItemEnabled("Layout", "Bounding Box", bl);
        sGMenuBar.setMenuItemEnabled("Layout", "Snap to Grid", bl);
        sGMenuBar.setMenuItemEnabled("Arrange", "Auto Arrangement", bl);
        sGMenuBar.setInsertToggleButtonsEnabled(bl);
    }

    private void updateInsertItems() {
        String[] stringArray = SGIRootObjectConstants.INSERT_MENUBARCMD_ARRAY;
        for (int i = 0; i < stringArray.length; ++i) {
            this.updateInsertItems(stringArray[i]);
        }
    }

    private void updateInsertItems(String string) {
        SGToolBar sGToolBar;
        boolean bl = this.getInsertFlag(string);
        SGMenuBar sGMenuBar = this.mMenuBar;
        if (sGMenuBar.hasMenuItem(string)) {
            sGMenuBar.setInsertToggleItemSelected(string, bl);
        }
        if ((sGToolBar = this.mToolBar).hasButton(string)) {
            sGToolBar.setInsertTogglebuttonSelected(string, bl);
        }
    }

    public boolean init() {
        float f = 566.92914f;
        float f2 = f / SGIConstants.GOLDEN_RATIO;
        this.setViewportSize(f, f2);
        this.mToolBar.setPreferredSize(new Dimension((int)f, this.mToolBar.getHeight()));
        this.mTemporaryViewportSize.setValues(f, f2);
        this.setComponentBounds();
        this.mClientRect = new Rectangle2D.Float();
        this.setPaperOrigin(0.0f, 0.0f);
        float f3 = SGIRootObjectConstants.DEFAULT_PAPER_WIDTH;
        float f4 = SGIRootObjectConstants.DEFAULT_PAPER_HEIGHT;
        this.mClientPanel.setPaperSizeRoundingOff(f3, f4);
        this.updateClientRect();
        return true;
    }

    public void repaintContentPane() {
        this.getContentPane().repaint();
    }

    private ImageIcon createIcon(String string) {
        URL uRL = this.getClass().getResource("/resources/" + string);
        ImageIcon imageIcon = new ImageIcon(uRL);
        return imageIcon;
    }

    private void createClientPanel() {
        SGClientPanel sGClientPanel = new SGClientPanel(this);
        this.getContentPane().add((Component)sGClientPanel, "Center");
        this.mClientPanel = sGClientPanel;
    }

    private void createStatusBar() {
        SGStatusBar sGStatusBar = new SGStatusBar(this);
        this.getContentPane().add((Component)sGStatusBar, "South");
        this.mStatusBar = sGStatusBar;
    }

    private boolean createToolBar() {
        SGToolBar sGToolBar;
        this.mToolBar = sGToolBar = new SGToolBar();
        sGToolBar.setRoot(this);
        sGToolBar.addActionListener(this);
        sGToolBar.addPropertyChangeListener(this);
        this.addComponentListener(sGToolBar);
        sGToolBar.addComponentListener(this);
        this.addComponentListener(this);
        this.setToolBar();
        return true;
    }

    private boolean setToolBar() {
        this.getContentPane().remove(this.mToolBar);
        int n = this.mToolBar.getOrientation();
        if (n == 0) {
            this.getContentPane().add((Component)this.mToolBar, "North");
        } else if (n == 1) {
            this.getContentPane().add((Component)this.mToolBar, "West");
        }
        this.validate();
        return true;
    }

    private int getToolBarHeight() {
        int n = 0;
        if (this.mToolBar.isVisible()) {
            n = this.mToolBar.getHeight();
        }
        return n;
    }

    private int getToolBarWidth() {
        int n = 0;
        if (this.mToolBar.isVisible()) {
            n = this.mToolBar.getWidth();
        }
        return n;
    }

    public String[] getToolBarPattern() {
        String[] stringArray = this.mToolBar.getToolBarPattern();
        return stringArray;
    }

    public void setToolBarPattern(String[] stringArray) {
        this.mToolBar.setToolBarPattern(stringArray);
        this.updateToolBarVisibleMenuItems();
        this.updateToolBarVisibleItems();
    }

    private boolean createPropertyDialog() {
        this.mDialog = new SGWindowDialog((Frame)this, true);
        return true;
    }

    public int getID() {
        return this.mID;
    }

    public boolean setID(int n) {
        this.mID = n;
        return true;
    }

    public int getCurrentFigureId() {
        ++this.mIDCounter;
        return this.mIDCounter;
    }

    public int getTopWidth() {
        Insets insets = this.getInsets();
        int n = insets.top;
        JMenuBar jMenuBar = this.getJMenuBar();
        int n2 = jMenuBar.getHeight();
        int n3 = 0;
        if (this.mToolBar.getOrientation() == 0) {
            n3 = this.getToolBarHeight();
        }
        int n4 = n + n2 + n3;
        return n4;
    }

    public int getBottomWidth() {
        Insets insets = this.getInsets();
        int n = insets.bottom;
        return n;
    }

    public int getLeftWidth() {
        Insets insets = this.getInsets();
        int n = insets.left;
        int n2 = 0;
        if (this.mToolBar.getOrientation() == 1) {
            n2 = this.getToolBarWidth();
        }
        return n + n2;
    }

    public int getRightWidth() {
        Insets insets = this.getInsets();
        int n = insets.right;
        return n;
    }

    public float getMagnification() {
        return this.mMagnification;
    }

    public float getMagnificationPercent() {
        return this.mMagnification * 100.0f;
    }

    public void setImageFileCreator(SGIImageExportManager sGIImageExportManager) {
        this.mImageExportManager = sGIImageExportManager;
    }

    public SGFigure getFigure(int n) {
        List list = this.mFigureList;
        for (int i = 0; i < list.size(); ++i) {
            SGFigure sGFigure = (SGFigure)list.get(i);
            if (sGFigure.getID() != n) continue;
            return sGFigure;
        }
        return null;
    }

    public ArrayList getFigureList() {
        return new ArrayList(this.mFigureList);
    }

    public SGFigure[] getFigureArray() {
        return this.getFigureList().toArray(new SGFigure[0]);
    }

    public ArrayList getVisibleFigureList() {
        List list = this.mFigureList;
        ArrayList<SGFigure> arrayList = new ArrayList<SGFigure>();
        for (int i = 0; i < list.size(); ++i) {
            SGFigure sGFigure = (SGFigure)list.get(i);
            if (!sGFigure.isVisible()) continue;
            arrayList.add(sGFigure);
        }
        return arrayList;
    }

    private boolean hideFigure(SGFigure sGFigure) {
        sGFigure.setVisible(false);
        sGFigure.setChanged(true);
        return true;
    }

    public void removeAllFigures() {
        this.mFigureList.clear();
        this.updateClientRect();
    }

    public boolean removeFigure(SGFigure sGFigure) {
        return this.mFigureList.remove(sGFigure);
    }

    public boolean addFigure(SGFigure sGFigure, Point point) {
        if (!this.addFigure(sGFigure)) {
            return false;
        }
        Point2D point2D = this.getLocationInPane(point.x, point.y);
        sGFigure.setGraphRectLocation((float)point2D.getX(), (float)point2D.getY());
        sGFigure.snapToLines(0);
        sGFigure.setGraphRectOnDragging();
        return true;
    }

    public boolean addFigure(SGFigure sGFigure) {
        this.mFigureList.add(sGFigure);
        sGFigure.setViewBounds();
        sGFigure.zoom(this.getMagnification());
        this.updateItemsByFigureNumbers();
        return true;
    }

    public boolean needsConfirmationBeforeDiscard() {
        return this.getVisibleFigureList().size() != 0 & !this.isSaved();
    }

    private boolean _setImage(Image image) {
        boolean bl = false;
        if (image != null) {
            if (!image.equals(this.getImage())) {
                bl = true;
            }
        } else if (this.getImage() != null && !this.getImage().equals(image)) {
            bl = true;
        }
        if (!this.mClientPanel.setImage(image)) {
            return false;
        }
        this.setChanged(bl);
        this.notifyToRoot();
        this.repaintContentPane();
        return true;
    }

    public boolean setImage(File file) {
        try {
            URL uRL = file.toURL();
            Image image = Toolkit.getDefaultToolkit().getImage(uRL);
            MediaTracker mediaTracker = new MediaTracker(this);
            mediaTracker.addImage(image, 0);
            try {
                mediaTracker.waitForAll();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this._setImage(image);
        }
        catch (MalformedURLException malformedURLException) {
            malformedURLException.printStackTrace();
            return false;
        }
        return true;
    }

    public boolean deleteImage() {
        return this._setImage(null);
    }

    public boolean setImageLocation(int n, int n2) {
        return this.mClientPanel.setImageLocation(n, n2);
    }

    public boolean setImageSize(int n, int n2) {
        return this.mClientPanel.setImageSize(n, n2);
    }

    public Image getImage() {
        return this.mClientPanel.getImage();
    }

    public boolean drawBackAllVisibleFigures() {
        ArrayList arrayList = this.getVisibleFigureList();
        for (int i = 0; i < arrayList.size(); ++i) {
            SGFigure sGFigure = (SGFigure)arrayList.get(i);
            if (this.drawBackFigure(sGFigure)) continue;
            return false;
        }
        return true;
    }

    public boolean drawBackFigure(SGFigure sGFigure) {
        return sGFigure.drawbackFigure();
    }

    public ArrayList getChildNodes() {
        return this.getVisibleFigureList();
    }

    public boolean clearFocusedObjects() {
        ArrayList arrayList = this.getFocusedObjectsList();
        for (int i = 0; i < arrayList.size(); ++i) {
            SGISelectable sGISelectable = (SGISelectable)arrayList.get(i);
            sGISelectable.setSelected(false);
        }
        return true;
    }

    public ArrayList getFocusedObjectsList() {
        ArrayList arrayList = new ArrayList();
        this.getFocusedObjectsList(arrayList);
        return arrayList;
    }

    public boolean getFocusedObjectsList(ArrayList arrayList) {
        ArrayList arrayList2 = this.getVisibleFigureList();
        for (int i = 0; i < arrayList2.size(); ++i) {
            SGISelectable sGISelectable = (SGISelectable)arrayList2.get(i);
            if (!sGISelectable.isSelected()) continue;
            arrayList.add(sGISelectable);
        }
        return true;
    }

    public ArrayList getCopiedFiguresList() {
        return new ArrayList(this.mCopiedFiguresList);
    }

    public boolean hideSelectedObjects() {
        ArrayList arrayList = this.getVisibleFigureList();
        for (int i = 0; i < arrayList.size(); ++i) {
            SGFigure sGFigure = (SGFigure)arrayList.get(i);
            if (sGFigure.isSelected()) {
                this.hideFigure(sGFigure);
                continue;
            }
            if (sGFigure.hideSelectedObjects()) continue;
            return false;
        }
        if (arrayList.size() != 0) {
            this.setChanged(true);
            this.clearFocusedObjects();
            this.updateItemsByFigureNumbers();
        }
        return true;
    }

    protected void setSelectionSymbolsVisible(boolean bl) {
        ArrayList arrayList = this.getVisibleFigureList();
        for (int i = 0; i < arrayList.size(); ++i) {
            SGFigure sGFigure = (SGFigure)arrayList.get(i);
            sGFigure.setSelectionSymbolsVisible(bl);
        }
    }

    public boolean clearAllFocusedObjectsInFigures() {
        ArrayList arrayList = this.getVisibleFigureList();
        for (int i = 0; i < arrayList.size(); ++i) {
            SGFigure sGFigure = (SGFigure)arrayList.get(i);
            if (sGFigure.clearFocusedObjects()) continue;
            return false;
        }
        return this.clearFocusedFigures();
    }

    public boolean clearFocusedFigures() {
        ArrayList arrayList = this.getFocusedObjectsList();
        for (int i = arrayList.size() - 1; i >= 0; --i) {
            SGFigure sGFigure = (SGFigure)arrayList.get(i);
            this.setFocusedFigure(sGFigure, false);
        }
        return true;
    }

    public boolean setFocusedFigure(SGFigure sGFigure, boolean bl) {
        sGFigure.setSelected(bl);
        sGFigure.setSymbolsVisibleAroundAllObjects(bl);
        return true;
    }

    public SGTuple2f getViewportSize() {
        SGTuple2f sGTuple2f = this.getPaneSize();
        int n = this.mClientPanel.getRulerWidth();
        sGTuple2f.x -= (float)n;
        sGTuple2f.y -= (float)n;
        return sGTuple2f;
    }

    public SGTuple2f getPaneOrigin() {
        Rectangle2D rectangle2D = this.getPaneBounds();
        SGTuple2f sGTuple2f = new SGTuple2f((float)rectangle2D.getX(), (float)rectangle2D.getY());
        return sGTuple2f;
    }

    public SGTuple2f getPaneSize() {
        Rectangle2D rectangle2D = this.getPaneBounds();
        SGTuple2f sGTuple2f = new SGTuple2f((float)rectangle2D.getWidth(), (float)rectangle2D.getHeight());
        return sGTuple2f;
    }

    public Rectangle2D getPaneBounds() {
        Insets insets = this.getInsets();
        int n = insets.top;
        int n2 = insets.bottom;
        int n3 = insets.left;
        int n4 = insets.right;
        JMenuBar jMenuBar = this.getJMenuBar();
        int n5 = jMenuBar.getHeight();
        int n6 = this.getToolBarHeight();
        int n7 = this.mStatusBar.getHeight();
        float f = this.getWidth() - (n3 + n4);
        float f2 = this.getHeight() - (n + n2 + n5 + n6 + n7);
        float f3 = n3;
        float f4 = n + n5 + n6;
        Rectangle2D.Float float_ = new Rectangle2D.Float(f3, f4, f, f2);
        return float_;
    }

    public boolean setPaperSize(float f, float f2) {
        return this.mClientPanel.setPaperSize(f, f2);
    }

    public JComponent getFigurePanel() {
        return this.mClientPanel.getFigurePanel();
    }

    public float getGridLineInterval() {
        return this.mClientPanel.getGridLineInterval();
    }

    public boolean setPaperOrigin(float f, float f2) {
        Rectangle2D rectangle2D = this.getClientRect();
        float f3 = this.mMagnification;
        float f4 = (f - (float)rectangle2D.getX()) / f3;
        float f5 = (f2 - (float)rectangle2D.getY()) / f3;
        this.mPaperOrigin.setValues(f4, f5);
        return true;
    }

    public void setPaperPortrait(boolean bl) {
        this.mPaperPortraitFlag = bl;
        this.updatePaperItems();
    }

    public boolean getPaperPortrait() {
        return this.mPaperPortraitFlag;
    }

    public SGTuple2f getPaperSize() {
        return new SGTuple2f(this.mClientPanel.getPaperWidth(), this.mClientPanel.getPaperHeight());
    }

    public float getPaperX() {
        Rectangle2D rectangle2D = this.getClientRect();
        return (float)rectangle2D.getX() + this.mMagnification * this.mPaperOrigin.x;
    }

    public float getPaperY() {
        Rectangle2D rectangle2D = this.getClientRect();
        return (float)rectangle2D.getY() + this.mMagnification * this.mPaperOrigin.y;
    }

    public Rectangle2D getPaperRect() {
        float f = this.getMagnification();
        Rectangle2D.Float float_ = new Rectangle2D.Float(this.getPaperX(), this.getPaperY(), f * this.mClientPanel.getPaperWidth(), f * this.mClientPanel.getPaperHeight());
        return float_;
    }

    public Rectangle2D getBoundingBox() {
        Rectangle2D.Float float_ = new Rectangle2D.Float();
        float f = this.mMagnification * 56.692917f;
        Rectangle2D rectangle2D = this.getPaperRect();
        ((Rectangle2D)float_).setRect(rectangle2D.getX(), rectangle2D.getY(), rectangle2D.getWidth() + (double)f, rectangle2D.getHeight() + (double)f);
        return float_;
    }

    public boolean setViewportSize(float f, float f2) {
        this.mTemporaryViewportSize.setValues(f, f2);
        Insets insets = this.getInsets();
        int n = insets.top;
        int n2 = insets.bottom;
        int n3 = insets.left;
        int n4 = insets.right;
        JMenuBar jMenuBar = this.getJMenuBar();
        int n5 = jMenuBar.getHeight();
        int n6 = this.getToolBarHeight();
        int n7 = this.mClientPanel.getRulerWidth();
        float f3 = f + (float)n3 + (float)n4 + (float)n7;
        float f4 = f2 + (float)n + (float)n2 + (float)n5 + (float)n6 + (float)n7 + (float)this.mStatusBar.getHeight();
        this.setSize((int)f3, (int)f4);
        return true;
    }

    protected boolean setComponentBounds() {
        Rectangle2D rectangle2D = this.getPaneBounds();
        int n = (int)rectangle2D.getWidth();
        int n2 = (int)rectangle2D.getHeight();
        this.mClientPanel.setSize(n, n2);
        this.validate();
        return true;
    }

    private boolean onResized() {
        if (this.getClientRect() == null) {
            return false;
        }
        this.setComponentBounds();
        SGTuple2f sGTuple2f = this.getViewportSize();
        float f = sGTuple2f.x / this.mTemporaryViewportSize.x;
        float f2 = sGTuple2f.y / this.mTemporaryViewportSize.y;
        this.updateClientRect();
        SGTuple2f sGTuple2f2 = this.getViewportSize();
        ArrayList arrayList = this.getVisibleFigureList();
        for (int i = 0; i < arrayList.size(); ++i) {
            SGFigure sGFigure = (SGFigure)arrayList.get(i);
            sGFigure.recordFigureRect();
            sGFigure.setViewBounds();
        }
        if (this.isLocked()) {
            Rectangle2D rectangle2D = this.getPaperRect();
            float f3 = f * (float)rectangle2D.getWidth() / this.mMagnification;
            float f4 = f2 * (float)rectangle2D.getHeight() / this.mMagnification;
            this.mClientPanel.setPaperSizeRoundingOff(f3, f4);
            for (int i = 0; i < arrayList.size(); ++i) {
                SGFigure sGFigure = (SGFigure)arrayList.get(i);
                sGFigure.recordFigureRect();
                sGFigure.resize(f, f2);
                sGFigure.setChanged(true);
            }
            this.updateClientRect();
            if (!this.mTemporaryViewportSize.equals(sGTuple2f)) {
                this.setChanged(true);
                this.notifyToRoot();
            }
        }
        this.mTemporaryViewportSize.setValues(sGTuple2f);
        this.zoomWithBoundingBox();
        return true;
    }

    public boolean zoom(float f) {
        this.mMagnification = f;
        SGFigure[] sGFigureArray = this.getFigureArray();
        for (int i = 0; i < sGFigureArray.length; ++i) {
            if (sGFigureArray[i].zoom(this.mMagnification)) continue;
            throw new Error();
        }
        this.mClientPanel.setMagnification(f);
        this.updateClientRect();
        this.getContentPane().repaint();
        return true;
    }

    public void setAutoZoom(boolean bl) {
        this.mAutoZoomFlag = bl;
        this.mMenuBar.setMenuItemSelected("Layout", "Auto Zoom", bl);
        this.zoomWithBoundingBox();
    }

    public boolean isAutoZoom() {
        return this.mAutoZoomFlag;
    }

    private boolean zoomWithBoundingBox() {
        if (this.isAutoZoom()) {
            this.zoomWayOut();
        }
        this.updateZoomItems();
        return true;
    }

    private boolean zoomWayOut() {
        float f;
        Rectangle2D rectangle2D = this.getBoundingBox();
        SGTuple2f sGTuple2f = this.getViewportSize();
        float f2 = (float)((double)sGTuple2f.x / (rectangle2D.getWidth() / (double)this.mMagnification));
        float f3 = f2 < (f = (float)((double)sGTuple2f.y / (rectangle2D.getHeight() / (double)this.mMagnification))) ? f2 : f;
        int n = (int)Math.floor(f3 * 100.0f);
        this.setZoomValue(new Integer(n));
        return true;
    }

    public boolean setZoomValue(Number number) {
        this.mToolBar.setZoomValue(number);
        this.zoom(number.floatValue() / 100.0f);
        this.updateZoomItems();
        return true;
    }

    private boolean setDefaultZoom() {
        return this.setZoomValue(new Integer(100));
    }

    public boolean setFigureBoundingBox(int n) {
        Object object;
        if (n != 0 && n != 1 && n != 2) {
            return false;
        }
        ArrayList<Rectangle2D> arrayList = new ArrayList<Rectangle2D>();
        ArrayList arrayList2 = this.getVisibleFigureList();
        for (int i = 0; i < arrayList2.size(); ++i) {
            object = (SGFigure)arrayList2.get(i);
            arrayList.add(((SGFigure)object).getBoundingBox());
        }
        Rectangle2D rectangle2D = SGUtility.createUnion(arrayList);
        if (rectangle2D == null) {
            return false;
        }
        object = this.getClientRect();
        Rectangle2D rectangle2D2 = this.getPaperRect();
        float f = (float)rectangle2D2.getWidth();
        float f2 = (float)rectangle2D2.getHeight();
        float f3 = this.mMagnification;
        if (n == 0 | n == 1) {
            f = BOUNDING_BOX_MARGIN + (float)(-((RectangularShape)object).getX() + rectangle2D.getX() + rectangle2D.getWidth()) / f3;
        }
        if (n == 0 | n == 2) {
            f2 = BOUNDING_BOX_MARGIN + (float)(-((RectangularShape)object).getY() + rectangle2D.getY() + rectangle2D.getHeight()) / f3;
        }
        this.mClientPanel.setPaperSizeRoundingOut(f, f2);
        this.updateClientRect();
        return true;
    }

    public Rectangle2D getBoundingBoxOfFigures(ArrayList arrayList) {
        if (arrayList == null) {
            return null;
        }
        if (arrayList.size() == 0) {
            return new Rectangle2D.Float();
        }
        ArrayList<Rectangle2D> arrayList2 = new ArrayList<Rectangle2D>();
        for (int i = 0; i < arrayList.size(); ++i) {
            SGFigure sGFigure = (SGFigure)arrayList.get(i);
            if (sGFigure == null) continue;
            Rectangle2D rectangle2D = sGFigure.getBoundingBox();
            if (rectangle2D == null) {
                return null;
            }
            arrayList2.add(rectangle2D);
        }
        Rectangle2D rectangle2D = SGUtility.createUnion(arrayList2);
        return rectangle2D;
    }

    public Object getComponent(int n, int n2) {
        SGIUndoable sGIUndoable = this;
        SGFigure[] sGFigureArray = this.getFigureArray();
        for (int i = sGFigureArray.length - 1; i >= 0; --i) {
            Point2D point2D;
            Rectangle2D rectangle2D;
            if (!sGFigureArray[i].isVisible() || !(rectangle2D = sGFigureArray[i].getGraphRect()).contains(point2D = this.getLocationInPane(n, n2))) continue;
            sGIUndoable = sGFigureArray[i];
            break;
        }
        return sGIUndoable;
    }

    private boolean setDirectlyBefore() {
        return this.prepare();
    }

    private boolean setDirectlyAfter() {
        if (!this.commit()) {
            return false;
        }
        this.notifyToRoot();
        this.repaintContentPane();
        return true;
    }

    public boolean setPaperWidthDirectly(float f, String string) {
        if (!this.setDirectlyBefore()) {
            return false;
        }
        if (!this.mClientPanel.setPaperWidth(f, string)) {
            return false;
        }
        return this.setDirectlyAfter();
    }

    public boolean setPaperHeightDirectly(float f, String string) {
        if (!this.setDirectlyBefore()) {
            return false;
        }
        if (!this.mClientPanel.setPaperHeight(f, string)) {
            return false;
        }
        return this.setDirectlyAfter();
    }

    public boolean setPaperSizeDirectly(float f, String string, float f2, String string2) {
        if (!this.setDirectlyBefore()) {
            return false;
        }
        if (!this.mClientPanel.setPaperWidth(f, string)) {
            return false;
        }
        if (!this.mClientPanel.setPaperHeight(f2, string2)) {
            return false;
        }
        return this.setDirectlyAfter();
    }

    public boolean setGridLineWidthDirectly(float f, String string) {
        if (!this.setDirectlyBefore()) {
            return false;
        }
        if (!this.mClientPanel.setGridLineWidth(f, string)) {
            return false;
        }
        return this.setDirectlyAfter();
    }

    public boolean setGridLineIntervalDirectly(float f, String string) {
        if (!this.setDirectlyBefore()) {
            return false;
        }
        if (!this.mClientPanel.setGridLineInterval(f, string)) {
            return false;
        }
        return this.setDirectlyAfter();
    }

    public boolean setGridLineVisibleDirectly(boolean bl) {
        if (!this.setDirectlyBefore()) {
            return false;
        }
        if (!this.mClientPanel.setGridLineVisible(bl)) {
            return false;
        }
        return this.setDirectlyAfter();
    }

    public boolean setGridLineColorDirectly(Color color) {
        if (!this.setDirectlyBefore()) {
            return false;
        }
        if (!this.mClientPanel.setGridLineColor(color)) {
            return false;
        }
        return this.setDirectlyAfter();
    }

    public boolean setPaperColorDirectly(Color color) {
        if (!this.setDirectlyBefore()) {
            return false;
        }
        if (!this.mClientPanel.setPaperColor(color)) {
            return false;
        }
        return this.setDirectlyAfter();
    }

    public boolean setImageLocationXDirectly(float f, String string) {
        if (!this.setDirectlyBefore()) {
            return false;
        }
        if (!this.mClientPanel.setImageLocationX(f, string)) {
            return false;
        }
        return this.setDirectlyAfter();
    }

    public boolean setImageLocationYDirectly(float f, String string) {
        if (!this.setDirectlyBefore()) {
            return false;
        }
        if (!this.mClientPanel.setImageLocationY(f, string)) {
            return false;
        }
        return this.setDirectlyAfter();
    }

    public boolean setImageScalingFactorDirectly(float f) {
        if (!this.setDirectlyBefore()) {
            return false;
        }
        if (!this.mClientPanel.setImageScalingFactor(f)) {
            return false;
        }
        return this.setDirectlyAfter();
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        Object object = propertyChangeEvent.getSource();
        String string = propertyChangeEvent.getPropertyName();
        Object object2 = propertyChangeEvent.getOldValue();
        Object object3 = propertyChangeEvent.getNewValue();
        this.onResized();
        if (object.equals(this.mToolBar)) {
            this.updateToolBarVisibleMenuItems();
            this.firePropertyChange("Tool Bar", null, null);
        }
    }

    public void menuSelected(MenuEvent menuEvent) {
        this.createPropertyMenuBarItem();
    }

    public void menuDeselected(MenuEvent menuEvent) {
    }

    public void menuCanceled(MenuEvent menuEvent) {
    }

    public void componentShown(ComponentEvent componentEvent) {
    }

    public void componentHidden(ComponentEvent componentEvent) {
    }

    public void componentMoved(ComponentEvent componentEvent) {
    }

    public void componentResized(ComponentEvent componentEvent) {
        this.onResized();
    }

    private int getTopShift() {
        return this.getTopWidth() + this.mClientPanel.getRulerWidth();
    }

    private int getLeftShift() {
        return this.getLeftWidth() + this.mClientPanel.getRulerWidth();
    }

    protected boolean showPropertyDialog() {
        SGWindowDialog sGWindowDialog = this.mDialog;
        sGWindowDialog.addPropertyDialogObserver(this);
        sGWindowDialog.setLocation(this.getLocation());
        this.setDialogProperty();
        sGWindowDialog.setColorButtonBorder(true);
        this.prepare();
        sGWindowDialog.setVisible(true);
        sGWindowDialog.removePropertyDialogObserver(this);
        return true;
    }

    protected boolean insertSymbol(SGFigure sGFigure, int n, int n2) {
        boolean bl = false;
        if (this.getLabelInsertionFlag()) {
            bl = sGFigure.addString(n, n2);
        }
        if (this.getTimingLineInsertionFlag()) {
            bl = sGFigure.addTimingLine(n, n2);
        }
        if (this.getAxisBreakSymbolInsertionFlag()) {
            bl = sGFigure.addAxisBreakSymbol(n, n2);
        }
        if (this.getSignificantDifferenceSymbolInsertionFlag()) {
            bl = sGFigure.addSignificantDifferenceSymbol(n, n2);
        }
        if (this.getRectangleInsertionFlag()) {
            bl = sGFigure.addShape(0, n, n2);
        }
        if (this.getEllipseInsertionFlag()) {
            bl = sGFigure.addShape(1, n, n2);
        }
        if (this.getArrowInsertionFlag()) {
            bl = sGFigure.addShape(2, n, n2);
        }
        if (this.getLineInsertionFlag()) {
            bl = sGFigure.addShape(3, n, n2);
        }
        return bl;
    }

    void clearFocusedFiguresOtherThan(SGFigure sGFigure) {
        ArrayList arrayList = this.getVisibleFigureList();
        for (int i = 0; i < arrayList.size(); ++i) {
            SGFigure sGFigure2 = (SGFigure)arrayList.get(i);
            if (sGFigure2.equals(sGFigure)) continue;
            sGFigure2.setSelected(false);
        }
    }

    public boolean translateFocusedObjects(int n, int n2) {
        ArrayList arrayList = this.getVisibleFigureList();
        for (int i = 0; i < arrayList.size(); ++i) {
            SGFigure sGFigure = (SGFigure)arrayList.get(i);
            if (sGFigure.isSelected()) {
                sGFigure.translate(n, n2);
                continue;
            }
            sGFigure.translateSelectedObjects(n, n2);
        }
        return true;
    }

    protected boolean moveFocusedObjects(int n, int n2) {
        int n3 = n - this.mTempMouseLocation.x;
        int n4 = n2 - this.mTempMouseLocation.y;
        this.translateFocusedObjects(n3, n4);
        this.mTempMouseLocation.setLocation(this.mTempMouseLocation.x + n3, this.mTempMouseLocation.y + n4);
        return true;
    }

    private Point2D getLocationInPane(int n, int n2) {
        int n3 = n;
        int n4 = n2;
        Insets insets = this.getInsets();
        int n5 = insets.top;
        int n6 = insets.bottom;
        int n7 = insets.left;
        int n8 = insets.right;
        n3 -= n7;
        n4 -= n5;
        JMenuBar jMenuBar = this.getJMenuBar();
        double d = jMenuBar.getHeight();
        n4 = (int)((double)n4 - d);
        n4 -= this.getToolBarHeight();
        double d2 = this.mClientPanel.getRulerWidth();
        n3 = (int)((double)n3 - d2);
        n4 = (int)((double)n4 - d2);
        return new Point2D.Float(n3, n4);
    }

    public boolean setPositionLabel(int n, int n2) {
        Rectangle2D rectangle2D = this.getClientRect();
        float f = (float)rectangle2D.getX();
        float f2 = (float)rectangle2D.getY();
        float f3 = 0.035277776f / this.mMagnification;
        float f4 = (-f + (float)n) * f3;
        float f5 = (-f2 + (float)n2) * f3;
        this.mStatusBar.drawPosition(f4, f5);
        return true;
    }

    public void addActionListener(ActionListener actionListener) {
        ArrayList arrayList = this.mActionListenerList;
        for (int i = 0; i < arrayList.size(); ++i) {
            ActionListener actionListener2 = (ActionListener)arrayList.get(i);
            if (!actionListener2.equals(actionListener)) continue;
            return;
        }
        arrayList.add(actionListener);
    }

    public void removeActionListener(ActionListener actionListener) {
        ArrayList arrayList = this.mActionListenerList;
        for (int i = arrayList.size() - 1; i >= 0; --i) {
            ActionListener actionListener2 = (ActionListener)arrayList.get(i);
            if (!actionListener2.equals(actionListener)) continue;
            this.mActionListenerList.remove(actionListener);
        }
    }

    public void notifyToListener(String string) {
        ArrayList arrayList = this.mActionListenerList;
        for (int i = 0; i < arrayList.size(); ++i) {
            ActionListener actionListener = (ActionListener)arrayList.get(i);
            actionListener.actionPerformed(this.getActionEvent(string));
        }
    }

    private ActionEvent getActionEvent(String string) {
        return new ActionEvent(this, 0, string);
    }

    public boolean prepare() {
        this.mTemporaryProperties = this.getProperties();
        return true;
    }

    protected void setInsertToggleItemsUnselected() {
        this.mMenuBar.setInsertToggleItemsUnSelected();
        this.mToolBar.setInsertToggleItemsUnSelected();
        Map map = this.mInsertFlagMap;
        Boolean bl = Boolean.FALSE;
        String[] stringArray = SGIRootObjectConstants.INSERT_MENUBARCMD_ARRAY;
        for (int i = 0; i < stringArray.length; ++i) {
            map.put(stringArray[i], bl);
        }
        this.updateInsertItems();
    }

    private void initInsertFlagMap() {
        HashMap<String, Boolean> hashMap = new HashMap<String, Boolean>();
        Boolean bl = Boolean.FALSE;
        String[] stringArray = SGIRootObjectConstants.INSERT_MENUBARCMD_ARRAY;
        for (int i = 0; i < stringArray.length; ++i) {
            hashMap.put(stringArray[i], bl);
        }
        this.mInsertFlagMap = hashMap;
    }

    public boolean isInsertFlagSelected() {
        Map map = this.mInsertFlagMap;
        Iterator iterator = map.values().iterator();
        while (iterator.hasNext()) {
            Boolean bl = (Boolean)iterator.next();
            if (!bl.booleanValue()) continue;
            return true;
        }
        return false;
    }

    public boolean getInsertFlag(String string) {
        Object v = this.mInsertFlagMap.get(string);
        if (v == null) {
            throw new IllegalArgumentException();
        }
        Boolean bl = (Boolean)v;
        return bl;
    }

    public void setInsertFlag(String string, boolean bl) {
        this.mInsertFlagMap.put(string, bl);
    }

    public boolean getLabelInsertionFlag() {
        return this.getInsertFlag("Label");
    }

    public boolean getTimingLineInsertionFlag() {
        return this.getInsertFlag("Timing Line");
    }

    public boolean getAxisBreakSymbolInsertionFlag() {
        return this.getInsertFlag("Axis Break");
    }

    public boolean getSignificantDifferenceSymbolInsertionFlag() {
        return this.getInsertFlag("Significant Difference");
    }

    public boolean getRectangleInsertionFlag() {
        return this.getInsertFlag("Rectangle");
    }

    public boolean getEllipseInsertionFlag() {
        return this.getInsertFlag("Ellipse");
    }

    public boolean getArrowInsertionFlag() {
        return this.getInsertFlag("Arrow");
    }

    public boolean getLineInsertionFlag() {
        return this.getInsertFlag("Line");
    }

    public void pasteToFigures(ArrayList arrayList, ArrayList arrayList2, ArrayList arrayList3, ArrayList arrayList4) {
        ArrayList arrayList5 = this.getFocusedObjectsList();
        if (arrayList5.size() == 0) {
            return;
        }
        for (int i = 0; i < arrayList5.size(); ++i) {
            SGFigure sGFigure = (SGFigure)arrayList5.get(i);
            sGFigure.paste(arrayList);
            for (int j = 0; j < arrayList3.size(); ++j) {
                SGData sGData = (SGData)arrayList2.get(j);
                String string = (String)arrayList3.get(j);
                Map map = (Map)arrayList4.get(j);
                SGData sGData2 = (SGData)sGData.copy();
                sGFigure.addData(sGData2, string, map);
            }
        }
        this.repaintContentPane();
        this.notifyToRoot();
    }

    protected void updateDataItem() {
        this.updateFocusedObjectItem();
    }

    protected void updateFocusedObjectItem() {
        ActionListener actionListener;
        boolean bl = false;
        ArrayList arrayList = this.getVisibleFigureList();
        for (int i = 0; i < arrayList.size(); ++i) {
            actionListener = (SGFigure)arrayList.get(i);
            if (((SGFigure)actionListener).isSelected()) {
                bl = true;
                break;
            }
            SGIFigureElement[] sGIFigureElementArray = ((SGFigure)actionListener).getIFigureElementArray();
            for (int j = 0; j < sGIFigureElementArray.length; ++j) {
                if (sGIFigureElementArray[j].getFocusedObjectsList().size() == 0) continue;
                bl = true;
                break;
            }
            if (bl) break;
        }
        SGMenuBar sGMenuBar = this.mMenuBar;
        sGMenuBar.setMenuItemEnabled("Edit", "Cut", bl);
        sGMenuBar.setMenuItemEnabled("Edit", "Copy", bl);
        sGMenuBar.setMenuItemEnabled("Edit", "Delete", bl);
        sGMenuBar.setMenuItemEnabled("Edit", "Duplicate", bl);
        sGMenuBar.setMenuItemEnabled("Arrange", "Move to Front", bl);
        sGMenuBar.setMenuItemEnabled("Arrange", "Move to Back", bl);
        actionListener = this.mToolBar;
        ((SGToolBar)actionListener).setButtonEnabled("Cut", bl);
        ((SGToolBar)actionListener).setButtonEnabled("Copy", bl);
    }

    public void setPasteMenuEnabled(boolean bl) {
        this.mMenuBar.setMenuItemEnabled("Edit", "Paste", bl);
        this.mToolBar.setButtonEnabled("Paste", bl);
        this.mClientPanel.setPopupMenuEnabled("Paste", bl);
    }

    private void updateGridItems() {
        boolean bl = this.mClientPanel.isGridLineVisible();
        boolean bl2 = false;
        boolean bl3 = false;
        if (bl) {
            double d = this.mClientPanel.getGridLineInterval() * 0.035277776f;
            int n = (int)Math.ceil(d / 0.5);
            int n2 = (int)Math.floor(d / 0.5);
            int n3 = (int)Math.rint(1.0);
            int n4 = (int)Math.rint(20.0);
            if (n3 < n2) {
                bl3 = true;
            }
            if (n < n4) {
                bl2 = true;
            }
        }
        SGMenuBar sGMenuBar = this.mMenuBar;
        sGMenuBar.setMenuItemSelected("Layout", "Visible", bl);
        sGMenuBar.setMenuItemEnabled("Layout", "Plus", bl2);
        sGMenuBar.setMenuItemEnabled("Layout", "Minus", bl3);
    }

    private void updateModeMenuItems() {
    }

    void updateSnapToGridItems() {
        this.mMenuBar.setMenuItemSelected("Layout", "Snap to Grid", SGFigure.isSnappingToGrid());
    }

    private void updateZoomItems() {
        boolean bl;
        boolean bl2;
        boolean bl3;
        boolean bl4;
        int[] nArray = SGIRootObjectConstants.MAGNIFICATION_ARRAY;
        int n = nArray[0];
        int n2 = nArray[nArray.length - 1];
        int n3 = (int)this.getMagnificationPercent();
        if (this.isAutoZoom()) {
            bl4 = false;
            bl3 = false;
            bl2 = false;
            bl = false;
        } else {
            bl4 = n3 != n;
            bl3 = n3 != n2;
            bl2 = n3 != 100;
            bl = true;
        }
        SGMenuBar sGMenuBar = this.mMenuBar;
        sGMenuBar.setMenuItemEnabled("Layout", "Zoom In", bl4);
        sGMenuBar.setMenuItemEnabled("Layout", "Zoom Out", bl3);
        sGMenuBar.setMenuItemEnabled("Layout", "Default Zoom", bl2);
        sGMenuBar.setMenuItemEnabled("Layout", "Zoom Way Out", bl);
    }

    private void updateToolBarVisibleItems() {
        String[] stringArray = SGIRootObjectConstants.TOOLBAR_MENUCMD_ARRAY;
        SGToolBar sGToolBar = this.mToolBar;
        SGMenuBar sGMenuBar = this.mMenuBar;
        for (int i = 0; i < stringArray.length; ++i) {
            sGToolBar.setToolBarVisible(stringArray[i], sGMenuBar.isToolBarMenuSelected(stringArray[i]));
        }
    }

    private void updateToolBarVisibleMenuItems() {
        String[] stringArray = SGIRootObjectConstants.TOOLBAR_MENUCMD_ARRAY;
        SGToolBar sGToolBar = this.mToolBar;
        SGMenuBar sGMenuBar = this.mMenuBar;
        for (int i = 0; i < stringArray.length; ++i) {
            sGMenuBar.setToolBarMenuItemSelected(stringArray[i], sGToolBar.isToolBarVisible(stringArray[i]));
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object;
        String string = actionEvent.getActionCommand();
        Object object2 = actionEvent.getSource();
        if (string.equals("Exit")) {
            this.notifyToListener("Exit");
        } else if (string.equals("Create New Window")) {
            this.notifyToListener("Create New Window");
        } else if (string.equals("Close Window")) {
            this.notifyToListener("Close Window");
        } else if (string.equals("Draw Graph")) {
            this.notifyToListener("Draw Graph");
        } else if (string.equals("Load Property")) {
            this.notifyToListener("Load Property");
        } else if (string.equals("Save Property")) {
            this.mPropertyFileCreationModeOfFigures = 0;
            this.notifyToListener("Save Property");
        } else if (string.equals("Load Data Set")) {
            this.notifyToListener("Load Data Set");
        } else if (string.equals("Save Data Set")) {
            this.notifyToListener("Save Data Set");
        } else if (string.equals("Load Background Image")) {
            this.notifyToListener("Load Background Image");
        } else if (string.equals("Export as Image")) {
            this.notifyToListener("Export as Image");
        } else if (string.equals("Print")) {
            this.notifyToListener("Print");
        } else if (string.equals("Delete")) {
            this.deleteFocusedObjects();
        } else if (string.equals("Cut")) {
            this.cutFocusedObjects();
        } else if (string.equals("Copy")) {
            this.copyFocusedObjects();
        }
        if (string.equals("Paste")) {
            this.pasteCopiedObjects();
        } else if (string.equals("Duplicate")) {
            this.duplicateFocusedObjects();
        } else if (string.equals("Delete Background Image")) {
            this.deleteImage();
        } else if (string.equals("Move to Front")) {
            this.moveFocusedObjectsToFront();
        } else if (string.equals("Move to Back")) {
            this.moveFocusedObjectsToBack();
        } else if (string.equals("Undo")) {
            this.undo();
            this.repaintContentPane();
        } else if (string.equals("Redo")) {
            this.redo();
            this.repaintContentPane();
        } else if (string.equals("Clear Undo Buffer")) {
            this.clearUndoBuffer();
        } else if (string.equals("A4") || string.equals("B5") || string.equals("US Letter")) {
            MediaSize mediaSize = SGUtilityText.getMediaSize(string);
            if (mediaSize == null) {
                return;
            }
            this.setPaperSizeDirectly(mediaSize);
        } else if (string.equals("Portrait") || string.equals("Landscape")) {
            boolean bl = string.equals("Portrait");
            this.setPaperPortrait(bl);
        } else if (string.equals("Bounding Box")) {
            this.setBoundingBox();
        } else if (string.equals("User Customize")) {
            this.showPropertyDialog();
        } else if (string.equals("Mode")) {
            int n = this.getMode() == 0 ? 1 : 0;
            this.setMode(n);
            this.updateModeMenuItems();
        } else if (string.equals("Auto Arrangement")) {
            this.alignFigures();
        } else if (string.equals("Visible")) {
            this.mClientPanel.setGridLineVisible(!this.mClientPanel.isGridLineVisible());
            this.updateGridItems();
            this.setChanged(true);
            this.notifyToRoot();
            this.repaintContentPane();
        } else if (string.equals("Plus")) {
            int n;
            double d = this.mClientPanel.getGridLineInterval() * 0.035277776f;
            double d2 = SGUtilityNumber.stepValue(true, d, 0.5, 10.0, 0.5, 0.001f);
            int n2 = (int)Math.rint(d2 / 0.5);
            if (n2 != (n = (int)Math.rint(20.0)) + 1) {
                if (d2 > 10.0) {
                    d2 = 10.0;
                }
                this.mClientPanel.setGridLineInterval((float)d2 / 0.035277776f);
                this.updateGridItems();
                this.getContentPane().repaint();
                this.setChanged(true);
                this.notifyToRoot();
            }
        } else if (string.equals("Minus")) {
            int n;
            double d = this.mClientPanel.getGridLineInterval() * 0.035277776f;
            double d3 = SGUtilityNumber.stepValue(false, d, 0.5, 10.0, 0.5, 0.001f);
            int n3 = (int)Math.rint(d3 / 0.5);
            if (n3 != (n = (int)Math.rint(1.0)) - 1) {
                if (d3 < 0.5) {
                    d3 = 0.5;
                }
                this.mClientPanel.setGridLineInterval((float)d3 / 0.035277776f);
                this.updateGridItems();
                this.getContentPane().repaint();
                this.setChanged(true);
                this.notifyToRoot();
            }
        } else if (string.equals("Snap to Grid")) {
            SGFigure.setSnappingToGrid(!SGFigure.isSnappingToGrid());
            this.updateSnapToGridItems();
        } else if (string.equals("Zoom In")) {
            int n = (int)this.getMagnificationPercent();
            object = SGIRootObjectConstants.MAGNIFICATION_ARRAY;
            for (int i = ((Object)object).length - 1; i >= 0; --i) {
                if (object[i] <= n) continue;
                this.setZoomValue(new Integer((int)object[i]));
                break;
            }
        } else if (string.equals("Zoom Out")) {
            int n = (int)this.getMagnificationPercent();
            object = SGIRootObjectConstants.MAGNIFICATION_ARRAY;
            for (int i = 0; i < ((Object)object).length; ++i) {
                if (object[i] >= n) continue;
                this.setZoomValue(new Integer((int)object[i]));
                break;
            }
        } else if (string.equals("Default Zoom")) {
            this.setDefaultZoom();
        } else if (string.equals("Zoom Way Out")) {
            this.zoomWayOut();
        } else if (string.equals("Auto Zoom")) {
            this.setAutoZoom(!this.isAutoZoom());
        } else if (string.equals("Lock")) {
            this.setLocked(!this.isLocked());
        } else if (string.equals("Window")) {
            this.createPropertyMenuBarItem();
        } else if (string.equals("Upgrade")) {
            this.notifyToListener("Upgrade");
        } else if (string.equals("Change Log")) {
            this.notifyToListener("Change Log");
        } else if (string.equals("Proxy")) {
            this.notifyToListener("Proxy");
        } else if (string.equals("About")) {
            this.notifyToListener("About");
        }
        if (Arrays.asList(SGIRootObjectConstants.INSERT_MENUBARCMD_ARRAY).contains(string)) {
            boolean bl;
            if (object2.equals(this.mMenuBar)) {
                bl = this.mMenuBar.isInsertToggleItemSelected(string);
            } else if (object2.equals(this.mToolBar)) {
                bl = this.mToolBar.isInsertTogglebuttonSelected(string);
            } else {
                return;
            }
            this.setInsertToggleItemsUnselected();
            this.setInsertFlag(string, bl);
            this.updateInsertItems();
            if (bl) {
                object = new Cursor(1);
                this.setCursor((Cursor)object);
            } else {
                this.setCursor(null);
            }
        }
        if (Arrays.asList(SGIRootObjectConstants.TOOLBAR_MENUCMD_ARRAY).contains(string)) {
            if (object2.equals(this.mMenuBar)) {
                this.updateToolBarVisibleItems();
            } else if (object2.equals(this.mToolBar)) {
                this.updateToolBarVisibleMenuItems();
            }
            this.firePropertyChange("Tool Bar", null, null);
        }
    }

    public void setMode(int n) {
        this.mMode = n;
        SGFigure[] sGFigureArray = this.getFigureArray();
        for (int i = 0; i < sGFigureArray.length; ++i) {
            sGFigureArray[i].setMode(n);
        }
    }

    public int getMode() {
        return this.mMode;
    }

    public int exportAsImage(Properties properties, String string, String string2) {
        this.startExport();
        Component component = this.getExportTarget();
        if (!this.mImageExportManager.export(component, component.getWidth(), component.getHeight(), string, string2, properties)) {
            this.endExport();
            return -1;
        }
        this.endExport();
        return 0;
    }

    void moveFocusedObjectsToFront() {
        this.moveFocusedObjects(true);
    }

    void moveFocusedObjectsToBack() {
        this.moveFocusedObjects(false);
    }

    void moveFocusedObjects(boolean bl) {
        Object object;
        ArrayList arrayList = this.getVisibleFigureList();
        for (int i = 0; i < arrayList.size(); ++i) {
            object = (SGFigure)arrayList.get(i);
            ((SGFigure)object).moveFocusedObjects(bl);
        }
        ArrayList arrayList2 = this.getFocusedObjectsList();
        object = this.mFigureList;
        ArrayList arrayList3 = new ArrayList(object);
        if (bl) {
            for (int i = 0; i < arrayList2.size(); ++i) {
                Object e = arrayList2.get(i);
                SGUtility.moveObject(e, (List)object, object.size() - 1);
            }
        } else {
            for (int i = arrayList2.size() - 1; i >= 0; --i) {
                Object e = arrayList2.get(i);
                SGUtility.moveObject(e, (List)object, 0);
            }
        }
        if (!object.equals(arrayList3)) {
            this.setChanged(true);
            this.notifyToRoot();
            this.updateDataItem();
            this.repaintContentPane();
        }
    }

    public boolean moveFigure(int n, boolean bl) {
        boolean bl2;
        SGFigure sGFigure = this.getFigure(n);
        if (sGFigure == null) {
            return false;
        }
        if (!sGFigure.isVisible()) {
            return false;
        }
        List list = this.mFigureList;
        ArrayList arrayList = new ArrayList(list);
        if (bl) {
            SGUtility.moveObject(sGFigure, list, list.size() - 1);
        } else {
            SGUtility.moveObject(sGFigure, list, 0);
        }
        boolean bl3 = bl2 = !((Object)this.mFigureList).equals(arrayList);
        if (bl2) {
            this.setChanged(true);
            this.notifyToRoot();
            this.updateDataItem();
            this.repaintContentPane();
        }
        return true;
    }

    public void doCopy() {
        this.copyFocusedObjects();
    }

    void copyFocusedObjects() {
        this.copyAllObjectsInVisibleFigures();
        this.notifyToListener("Copy");
        this.updateFocusedObjectItem();
    }

    public void doCut() {
        this.cutFocusedObjects();
    }

    private void cutFocusedObjects() {
        this.cutAllObjectsInVisibleFigures();
        this.notifyToListener("Cut");
        this.notifyToRoot();
        this.updateFocusedObjectItem();
        this.repaintContentPane();
    }

    public boolean cutOrCopyFigure(int n, boolean bl) {
        SGFigure sGFigure = this.getFigure(n);
        if (sGFigure == null) {
            return false;
        }
        if (!sGFigure.isVisible()) {
            return false;
        }
        this.mCopiedFiguresList.add(sGFigure);
        if (!bl) {
            this.hideFigure(sGFigure);
        }
        if (bl) {
            this.notifyToListener("Copy");
        } else {
            this.notifyToListener("Cut");
        }
        this.notifyToRoot();
        this.updateFocusedObjectItem();
        this.repaintContentPane();
        return true;
    }

    public void doPaste() {
        this.pasteCopiedObjects();
    }

    private void pasteCopiedObjects() {
        this.notifyToListener("Paste");
        this.notifyToRoot();
    }

    public void doDuplicate() {
        this.duplicateFocusedObjects();
    }

    void duplicateFocusedObjects() {
        ArrayList arrayList = this.getVisibleFigureList();
        for (int i = 0; i < arrayList.size(); ++i) {
            SGFigure sGFigure = (SGFigure)arrayList.get(i);
            if (sGFigure.duplicateFocusedObjects()) continue;
            return;
        }
        this.repaintContentPane();
        this.notifyToListener("Duplicate");
        ArrayList arrayList2 = this.getFocusedObjectsList();
        for (int i = 0; i < arrayList2.size(); ++i) {
            SGFigure sGFigure = (SGFigure)arrayList2.get(i);
            this.setFocusedFigure(sGFigure, false);
        }
        ArrayList arrayList3 = this.getVisibleFigureList();
        for (int i = 0; i < arrayList3.size(); ++i) {
            SGFigure sGFigure = (SGFigure)arrayList3.get(i);
            if (arrayList.contains(sGFigure)) continue;
            this.setFocusedFigure(sGFigure, true);
        }
        this.notifyToRoot();
    }

    public void doDelete() {
        this.deleteFocusedObjects();
    }

    private void deleteFocusedObjects() {
        this.hideSelectedObjects();
        this.notifyToRoot();
        this.updateDataItem();
        this.repaintContentPane();
    }

    public boolean hideFigure(int n) {
        SGFigure sGFigure = this.getFigure(n);
        if (sGFigure == null) {
            return false;
        }
        if (!this.hideFigure(sGFigure)) {
            return false;
        }
        this.clearFocusedObjects();
        this.setChanged(true);
        this.notifyToRoot();
        this.updateItemsByFigureNumbers();
        this.repaintContentPane();
        return true;
    }

    private void cutAllObjectsInVisibleFigures() {
        this.cutOrCopyAllObjectsInVisibleFigures(false);
    }

    private void copyAllObjectsInVisibleFigures() {
        this.cutOrCopyAllObjectsInVisibleFigures(true);
    }

    private void cutOrCopyAllObjectsInVisibleFigures(boolean bl) {
        int n;
        ArrayList arrayList = this.getVisibleFigureList();
        ArrayList arrayList2 = new ArrayList();
        ArrayList arrayList3 = new ArrayList();
        ArrayList arrayList4 = new ArrayList();
        ArrayList arrayList5 = new ArrayList();
        if (bl) {
            for (n = 0; n < arrayList.size(); ++n) {
                SGFigure sGFigure = (SGFigure)arrayList.get(n);
                arrayList2.addAll(sGFigure.createCopiedObjects());
                sGFigure.createCopiedDataObjects(arrayList3, arrayList4, arrayList5);
            }
        } else {
            for (n = 0; n < arrayList.size(); ++n) {
                SGFigure sGFigure = (SGFigure)arrayList.get(n);
                arrayList2.addAll(sGFigure.cutFocusedObjects());
                sGFigure.cutFocusedDataObjects(arrayList3, arrayList4, arrayList5);
            }
        }
        ArrayList arrayList6 = new ArrayList();
        SGUtility.copyObjects(arrayList3, arrayList6);
        this.clearCopiedObjectsList();
        this.mCopiedObjectsList.addAll(arrayList2);
        this.mCopiedDataObjectsList.addAll(arrayList6);
        this.mCopiedDataNameList.addAll(arrayList4);
        this.mCopiedDataPropertiesMapList.addAll(arrayList5);
        this.mCopiedFiguresList.addAll(this.getFocusedObjectsList());
    }

    public ArrayList getCopiedObjectsList() {
        return new ArrayList(this.mCopiedObjectsList);
    }

    public ArrayList getCopiedObjectsDataList() {
        return new ArrayList(this.mCopiedDataObjectsList);
    }

    public ArrayList getCopiedDataNameList() {
        return new ArrayList(this.mCopiedDataNameList);
    }

    public ArrayList getCopiedDataPropertiesMapList() {
        return new ArrayList(this.mCopiedDataPropertiesMapList);
    }

    private void clearCopiedObjectsList() {
        this.mCopiedObjectsList.clear();
        this.mCopiedDataObjectsList.clear();
        this.mCopiedDataNameList.clear();
        this.mCopiedDataPropertiesMapList.clear();
        this.mCopiedFiguresList.clear();
    }

    void notifyPasteToFocusedFigures() {
        this.mPasteTargetList.clear();
        this.mPasteTargetList.addAll(this.getFocusedObjectsList());
        this.notifyToListener("Paste");
    }

    private void setLookAndFeel(String string) {
        try {
            UIManager.setLookAndFeel(string);
            SwingUtilities.updateComponentTreeUI(this);
        }
        catch (Exception exception) {
            System.out.println("Error L&F Setting");
        }
    }

    public boolean isLocked() {
        return this.mLockFigureFlag;
    }

    public boolean setLocked(boolean bl) {
        this.mLockFigureFlag = bl;
        this.updateLockItems();
        return true;
    }

    private void updateLockItems() {
        boolean bl = this.isLocked();
        this.mToolBar.setButtonSelected("Lock", bl);
        this.mMenuBar.setMenuItemSelected("Layout", "Lock", bl);
    }

    public void clearUndoBuffer() {
        boolean bl = this.isSaved();
        this.initUndoBuffer();
        if (bl) {
            this.mSavedListIndex = 0;
            this.updateStatusBarMessage();
        } else {
            this.initSavedHistory();
        }
        this.removeUselessFigures();
        this.updateUndoItems();
    }

    public boolean setSelectedFigure(int[] nArray) {
        for (int i = 0; i < nArray.length; ++i) {
            SGFigure sGFigure = this.getFigure(nArray[i]);
            sGFigure.setSelected(true);
        }
        this.updateFocusedObjectItem();
        this.repaintContentPane();
        return true;
    }

    public String getClassDescription() {
        return this.getInstanceDescription();
    }

    public String getInstanceDescription() {
        return "Window: " + this.mID;
    }

    private void createPropertyMenuBarItem() {
        TreeMenuItemListener treeMenuItemListener = new TreeMenuItemListener();
        this.mMenuBar.createPropertyMenuBarItem(this, treeMenuItemListener);
    }

    public boolean createTree(StringBuffer stringBuffer) {
        this.createTree(this, stringBuffer, 0);
        return true;
    }

    private void createTree(SGINode sGINode, StringBuffer stringBuffer, int n) {
        ArrayList arrayList = sGINode.getChildNodes();
        String string = sGINode.getClassDescription();
        String string2 = sGINode.getInstanceDescription();
        boolean bl = sGINode instanceof SGIPropertyDialogObserver;
        if (arrayList.size() != 0) {
            if (string != null & string2 != null) {
                this.append(stringBuffer, string2, n);
                int n2 = n + 1;
                for (int i = 0; i < arrayList.size(); ++i) {
                    SGINode sGINode2 = (SGINode)arrayList.get(i);
                    this.createTree(sGINode2, stringBuffer, n2);
                }
            }
        } else if (string2 != null && bl) {
            this.append(stringBuffer, string2, n);
        }
    }

    private void append(StringBuffer stringBuffer, String string, int n) {
        for (int i = 0; i < n; ++i) {
            stringBuffer.append("  ");
        }
        stringBuffer.append(string);
        stringBuffer.append(SGIConstants.LINE_SEPARATOR);
    }

    public void setProgressValue(float f) {
        this.mStatusBar.setProgressValue(f);
    }

    public boolean startProgress() {
        return this.mStatusBar.startProgress();
    }

    public boolean endProgress() {
        return this.mStatusBar.endProgress();
    }

    public void setMessage(String string) {
        this.mStatusBar.setMessage(string);
    }

    public void clearMessage() {
        this.mStatusBar.setMessage("");
    }

    private Rectangle2D getPaperRectInClientRect() {
        Rectangle2D.Float float_ = new Rectangle2D.Float(this.mPaperOrigin.x, this.mPaperOrigin.y, this.mClientPanel.getPaperWidth(), this.mClientPanel.getPaperHeight());
        return float_;
    }

    boolean recordPaperRect() {
        this.mTempPaperRect.setRect(this.getPaperRectInClientRect());
        return true;
    }

    public boolean isPaperBoundsChanged() {
        Rectangle rectangle;
        Rectangle rectangle2 = this.mTempPaperRect.getBounds();
        return !rectangle2.equals(rectangle = this.getPaperRectInClientRect().getBounds());
    }

    public boolean alignFigures() {
        SGFigure sGFigure;
        int n;
        ArrayList arrayList = this.getVisibleFigureList();
        for (n = 0; n < arrayList.size(); ++n) {
            sGFigure = (SGFigure)arrayList.get(n);
            sGFigure.recordFigureRect();
        }
        this.recordPaperRect();
        if (!this.alignFiguresByGraphAreaNew()) {
            return false;
        }
        for (n = 0; n < arrayList.size(); ++n) {
            sGFigure = (SGFigure)arrayList.get(n);
            if (!sGFigure.isFigureMoved()) continue;
            sGFigure.setChanged(true);
        }
        if (this.isPaperBoundsChanged()) {
            this.setChanged(true);
        }
        this.notifyToRoot();
        return true;
    }

    public boolean setPaperSizeDirectly(MediaSize mediaSize) {
        Rectangle rectangle = this.getPaperRect().getBounds();
        this.mClientPanel.setPaperSize(mediaSize, this.getPaperPortrait());
        Rectangle rectangle2 = this.getPaperRect().getBounds();
        if (rectangle.equals(rectangle2)) {
            return true;
        }
        this.updateClientRect();
        this.setChanged(true);
        this.notifyToRoot();
        this.zoomWithBoundingBox();
        return true;
    }

    public boolean setBoundingBox() {
        Rectangle rectangle = this.getPaperRect().getBounds();
        Rectangle2D rectangle2D = this.getClientRect();
        ArrayList arrayList = this.getVisibleFigureList();
        if (arrayList.size() != 0) {
            for (int i = 0; i < arrayList.size(); ++i) {
                SGFigure sGFigure = (SGFigure)arrayList.get(i);
                sGFigure.recordFigureRect();
            }
            this.recordPaperRect();
            Rectangle2D rectangle2D2 = this.getBoundingBoxOfFigures(arrayList);
            for (int i = 0; i < arrayList.size(); ++i) {
                SGFigure sGFigure = (SGFigure)arrayList.get(i);
                float f = BOUNDING_BOX_MARGIN + (float)(rectangle2D.getX() + (double)sGFigure.getGraphRectX() - rectangle2D2.getX());
                float f2 = BOUNDING_BOX_MARGIN + (float)(rectangle2D.getY() + (double)sGFigure.getGraphRectY() - rectangle2D2.getY());
                sGFigure.setGraphRectLocationRoundingOut(f, f2);
                if (!sGFigure.isFigureMoved()) continue;
                sGFigure.setChanged(true);
            }
            this.setFigureBoundingBox(0);
            if (this.isPaperBoundsChanged()) {
                this.setChanged(true);
            }
            this.notifyToRoot();
        } else {
            SGUtility.showMessageDialog(this, "There is no figure.", "Failed to get the Bounding box.", 2);
        }
        return true;
    }

    public boolean initPropertiesHistory() {
        return this.mUndoManager.initPropertiesHistory();
    }

    private void updatePaperItems() {
        this.mMenuBar.setMenuItemSelected("Layout", "Portrait", this.getPaperPortrait());
    }

    public boolean commit() {
        this.updateClientRect();
        this.zoomWithBoundingBox();
        this.updateGridItems();
        SGProperties sGProperties = this.mTemporaryProperties;
        SGProperties sGProperties2 = this.getProperties();
        if (!sGProperties.equals(sGProperties2)) {
            this.mUndoManager.setChanged(true);
        }
        this.mTemporaryProperties = null;
        this.getContentPane().repaint();
        this.notifyToRoot();
        return true;
    }

    public boolean updateHistory() {
        this.updateSavedListIndex();
        boolean bl = this.isChanged();
        SGUndoManager sGUndoManager = this.mUndoManager;
        if (!sGUndoManager.updateHistory(this.getVisibleFigureList())) {
            return false;
        }
        if (bl) {
            this.removeUselessFigures();
        }
        this.updateUndoItems();
        this.updateStatusBarMessage();
        return true;
    }

    private void updateSavedListIndex() {
        int n;
        boolean bl = false;
        if (this.isChanged()) {
            bl = true;
        } else {
            ArrayList arrayList = this.getVisibleFigureList();
            for (int i = 0; i < arrayList.size(); ++i) {
                SGFigure sGFigure = (SGFigure)arrayList.get(i);
                if (!sGFigure.isChanged()) continue;
                bl = true;
                break;
            }
        }
        if (bl && (n = this.mUndoManager.getChangedObjectListIndex()) < this.mSavedListIndex) {
            this.initSavedHistory();
        }
    }

    private void updateStatusBarMessage() {
        String string = "";
        if (this.getVisibleFigureList().size() != 0) {
            int n = this.mUndoManager.getChangedObjectListIndex();
            string = n == this.mSavedListIndex ? "" : "*";
        }
        this.mStatusBar.setMessage(string);
    }

    public void initSavedHistory() {
        this.mSavedListIndex = -1;
        this.updateStatusBarMessage();
    }

    private boolean removeUselessFigures() {
        Set set = this.getAvailableChildSet();
        if (set.size() != 0) {
            boolean bl = false;
            ArrayList arrayList = new ArrayList(this.mFigureList);
            for (int i = arrayList.size() - 1; i >= 0; --i) {
                Object e = arrayList.get(i);
                if (!set.contains(e)) {
                    this.mFigureList.remove(e);
                    SGFigure sGFigure = (SGFigure)e;
                    sGFigure.dispose();
                    bl = true;
                }
                e = null;
            }
            if (bl) {
                arrayList.clear();
                set.clear();
                System.gc();
            }
        }
        return true;
    }

    protected Set getAvailableChildSet() {
        HashSet hashSet = new HashSet();
        List list = this.mUndoManager.getMementoList();
        for (int i = 0; i < list.size(); ++i) {
            WindowProperties windowProperties = (WindowProperties)list.get(i);
            hashSet.addAll(windowProperties.mVisibleFigureList);
        }
        return hashSet;
    }

    public void initUndoBuffer() {
        this.mUndoManager.initUndoBuffer();
        ArrayList arrayList = this.getVisibleFigureList();
        for (int i = 0; i < arrayList.size(); ++i) {
            SGFigure sGFigure = (SGFigure)arrayList.get(i);
            sGFigure.initUndoBuffer();
        }
    }

    public boolean isUndoable() {
        return this.mUndoManager.isUndoable();
    }

    public boolean isRedoable() {
        return this.mUndoManager.isRedoable();
    }

    public boolean cancel() {
        if (!this.setProperties(this.mTemporaryProperties)) {
            return false;
        }
        this.mTemporaryProperties = null;
        this.updateClientRect();
        this.getContentPane().repaint();
        return true;
    }

    public boolean preview() {
        this.updateClientRect();
        this.zoomWithBoundingBox();
        this.updateGridItems();
        this.getContentPane().repaint();
        return true;
    }

    public void setCursor(Cursor cursor) {
        if (this.isEnabled()) {
            super.setCursor(cursor);
        }
    }

    public void setEnabled(boolean bl) {
        if (bl) {
            super.setCursor(null);
        } else {
            super.setCursor(Cursor.getPredefinedCursor(3));
        }
        super.setEnabled(bl);
    }

    private boolean setDialogProperty() {
        SGWindowDialog sGWindowDialog = this.mDialog;
        String string = "Window Properties : " + this.getID();
        sGWindowDialog.setTitle(string);
        sGWindowDialog.setDialogProperty();
        return true;
    }

    public SGPropertyDialog getPropertyDialog() {
        return this.mDialog;
    }

    public boolean updateClientRect() {
        this.updateClientRectOld();
        return true;
    }

    private boolean updateClientRectNew() {
        float f;
        float f2;
        System.out.println("-- updateClientRect --");
        Rectangle2D rectangle2D = this.getClientRect();
        Rectangle2D rectangle2D2 = this.getPaperRect();
        Rectangle2D rectangle2D3 = this.getBoundingBox();
        Rectangle2D rectangle2D4 = this.getViewportBounds();
        ArrayList arrayList = this.getVisibleFigureList();
        float f3 = this.getMagnification();
        float f4 = (float)rectangle2D.getX();
        float f5 = (float)rectangle2D.getY();
        float f6 = (float)rectangle2D.getWidth();
        float f7 = (float)rectangle2D.getHeight();
        float f8 = (float)rectangle2D4.getX();
        float f9 = (float)rectangle2D4.getY();
        float f10 = (float)rectangle2D4.getWidth();
        float f11 = (float)rectangle2D4.getHeight();
        float f12 = this.getPaperX();
        float f13 = this.getPaperY();
        float f14 = f3 * this.mClientPanel.getPaperWidth();
        float f15 = f3 * this.mClientPanel.getPaperHeight();
        Rectangle2D.Float float_ = new Rectangle2D.Float();
        ((Rectangle2D)float_).setRect(rectangle2D3);
        boolean bl = (int)f8 <= (int)((RectangularShape)float_).getX();
        boolean bl2 = (int)(((RectangularShape)float_).getX() + ((RectangularShape)float_).getWidth()) <= (int)(f8 + f10);
        double d = ((RectangularShape)float_).getX();
        double d2 = ((RectangularShape)float_).getWidth();
        if (bl & bl2) {
            d = f8;
            d2 = f10;
        } else if (bl) {
            d = f8;
            if (d2 < (double)f10) {
                d2 = f10;
            }
        } else if (bl2) {
            d = (double)(f8 + f10) - d2;
            if ((double)f8 < d) {
                d = f8;
            }
            if (d2 < (double)f10) {
                d2 = f10;
            }
        }
        ((Rectangle2D)float_).setRect(d, ((RectangularShape)float_).getY(), d2, ((RectangularShape)float_).getHeight());
        bl = (double)f9 < float_.getMinY();
        bl2 = float_.getMinY() + ((RectangularShape)float_).getHeight() < (double)(f9 + f11);
        d = ((RectangularShape)float_).getY();
        d2 = ((RectangularShape)float_).getHeight();
        if (bl & bl2) {
            d = f9;
            d2 = f11;
        } else if (bl) {
            d = f9;
            if (d2 < (double)f11) {
                d2 = f11;
            }
        } else if (bl2) {
            d = (double)(f9 + f11) - d2;
            if ((double)f9 < d) {
                d = f9;
            }
            if (d2 < (double)f11) {
                d2 = f11;
            }
        }
        ((Rectangle2D)float_).setRect(((RectangularShape)float_).getX(), d, ((RectangularShape)float_).getWidth(), d2);
        this.mTempRect.setRect(float_);
        if (arrayList.size() == 0) {
            f2 = (float)((RectangularShape)float_).getX() + 0.0f;
            f = (float)((RectangularShape)float_).getY() + 0.0f;
        } else {
            SGFigure sGFigure = null;
            SGFigure sGFigure2 = null;
            float f16 = f12;
            float f17 = f13;
            for (int i = 0; i < arrayList.size(); ++i) {
                SGFigure sGFigure3 = (SGFigure)arrayList.get(i);
                Rectangle2D rectangle2D5 = sGFigure3.getBoundingBox();
                float f18 = (float)rectangle2D5.getX();
                float f19 = (float)rectangle2D5.getY();
                if (f18 < f16) {
                    f16 = f18;
                    sGFigure = sGFigure3;
                }
                if (!(f19 < f17)) continue;
                f17 = f19;
                sGFigure2 = sGFigure3;
            }
            f2 = sGFigure != null ? f12 - f16 : f12;
            f = sGFigure2 != null ? f13 - f17 : f13;
        }
        System.out.println(f12 + "  " + f13);
        System.out.println(f2 + "  " + f);
        this.setClientRect(float_);
        this.setPaperOrigin(f2, f);
        this.updateGraphRectOfAllFigures();
        this.mClientPanel.setEnableScrollBars(rectangle2D4, rectangle2D3);
        this.mClientPanel.setScrollBarValue(rectangle2D, rectangle2D4);
        System.out.println();
        return true;
    }

    private boolean updateClientRectOld() {
        double d;
        boolean bl;
        boolean bl2;
        Rectangle2D rectangle2D;
        Rectangle2D rectangle2D2;
        this.fitRect(this.mClientRect, this.getBoundingBox(), true);
        if (SGUtility.isRectContains(this.getViewportBounds(), this.getBoundingBox(), true)) {
            this.fitRect(this.mClientRect, this.getViewportBounds(), true);
        }
        if (!SGUtility.isRectContains(this.getClientRect(), this.getViewportBounds(), true)) {
            rectangle2D2 = this.getClientRect();
            rectangle2D = this.getViewportBounds();
            bl2 = SGUtility.isRectContains(rectangle2D2, rectangle2D.getX(), true);
            bl = SGUtility.isRectContains(rectangle2D2, rectangle2D.getX() + rectangle2D.getWidth(), true);
            d = 0.0;
            if (!bl2 && bl) {
                d = rectangle2D.getX() - rectangle2D2.getX();
            } else if (bl2 && !bl) {
                d = rectangle2D.getX() + rectangle2D.getWidth() - (rectangle2D2.getX() + rectangle2D2.getWidth());
            } else if (!bl2 && !bl) {
                d = rectangle2D2.getX() < rectangle2D.getX() ? rectangle2D.getX() + rectangle2D.getWidth() - (rectangle2D2.getX() + rectangle2D2.getWidth()) : rectangle2D.getX() - rectangle2D2.getX();
            }
            this.setClientRect((float)(rectangle2D2.getX() + d), (float)rectangle2D2.getY(), (float)rectangle2D2.getWidth(), (float)rectangle2D2.getHeight());
        }
        this.fitRect(this.mClientRect, this.getBoundingBox(), false);
        if (SGUtility.isRectContains(this.getViewportBounds(), this.getBoundingBox(), false)) {
            this.fitRect(this.mClientRect, this.getViewportBounds(), false);
        }
        if (!SGUtility.isRectContains(this.getClientRect(), this.getViewportBounds(), false)) {
            rectangle2D2 = this.getClientRect();
            rectangle2D = this.getViewportBounds();
            bl2 = SGUtility.isRectContains(rectangle2D2, rectangle2D.getY(), false);
            bl = SGUtility.isRectContains(rectangle2D2, rectangle2D.getY() + rectangle2D.getHeight(), false);
            d = 0.0;
            if (!bl2 && bl) {
                d = rectangle2D.getY() - rectangle2D2.getY();
            } else if (bl2 && !bl) {
                d = rectangle2D.getY() + rectangle2D.getHeight() - (rectangle2D2.getY() + rectangle2D2.getHeight());
            } else if (!bl2 && !bl) {
                d = rectangle2D2.getY() < rectangle2D.getY() ? rectangle2D.getY() + rectangle2D.getHeight() - (rectangle2D2.getY() + rectangle2D2.getHeight()) : rectangle2D.getY() - rectangle2D2.getY();
            }
            this.setClientRect((float)rectangle2D2.getX(), (float)(rectangle2D2.getY() + d), (float)rectangle2D2.getWidth(), (float)rectangle2D2.getHeight());
        }
        rectangle2D2 = this.getBoundingBox();
        rectangle2D = this.getViewportBounds();
        Rectangle2D rectangle2D3 = this.getClientRect();
        this.mClientPanel.setScrollBarValue(rectangle2D3, rectangle2D);
        this.mClientPanel.setEnableScrollBars(rectangle2D, rectangle2D2);
        if (SGUtility.isRectContains(rectangle2D, rectangle2D2, true)) {
            this.fitRect(this.mClientRect, rectangle2D, true);
        }
        if (SGUtility.isRectContains(rectangle2D, rectangle2D2, false)) {
            this.fitRect(this.mClientRect, rectangle2D, false);
        }
        this.mClientPanel.setScrollBarValue(rectangle2D3, rectangle2D);
        return true;
    }

    private void fitRect(Rectangle2D rectangle2D, Rectangle2D rectangle2D2, boolean bl) {
        if (bl) {
            rectangle2D.setRect(rectangle2D2.getX(), rectangle2D.getY(), rectangle2D2.getWidth(), rectangle2D.getHeight());
        } else {
            rectangle2D.setRect(rectangle2D.getX(), rectangle2D2.getY(), rectangle2D.getWidth(), rectangle2D2.getHeight());
        }
    }

    public boolean setProperties(SGProperties sGProperties) {
        if (!(sGProperties instanceof WindowProperties)) {
            return false;
        }
        WindowProperties windowProperties = (WindowProperties)sGProperties;
        Float f = windowProperties.getPaperWidth();
        Float f2 = windowProperties.getPaperHeight();
        if (f == null || f2 == null) {
            return false;
        }
        this.mClientPanel.setPaperSize(f.floatValue(), f2.floatValue());
        Color color = windowProperties.getBackgroundColor();
        if (color == null) {
            return false;
        }
        this.mClientPanel.setPaperColor(color);
        Color color2 = windowProperties.getGridColor();
        if (color2 == null) {
            return false;
        }
        this.mClientPanel.setGridLineColor(color2);
        Boolean bl = windowProperties.getGridVisible();
        if (bl == null) {
            return false;
        }
        this.mClientPanel.setGridLineVisible(bl);
        Float f3 = windowProperties.getGridInterval();
        if (f3 == null) {
            return false;
        }
        this.mClientPanel.setGridLineInterval(f3.floatValue());
        Float f4 = windowProperties.getGridLineWidth();
        if (f4 == null) {
            return false;
        }
        this.mClientPanel.setGridLineWidth(f4.floatValue());
        Float f5 = windowProperties.getImageLocationX();
        if (f5 == null) {
            return false;
        }
        this.mClientPanel.setImageLocationX(f5.floatValue());
        Float f6 = windowProperties.getImageLocationY();
        if (f6 == null) {
            return false;
        }
        this.mClientPanel.setImageLocationY(f6.floatValue());
        Float f7 = windowProperties.getImageScalingFactor();
        if (f7 == null) {
            return false;
        }
        this.mClientPanel.setImageScalingFactor(f7.floatValue());
        Image image = windowProperties.getImage();
        this.mClientPanel.setImage(image);
        this.setVisibleFigure(windowProperties.getVisibleFigureList());
        return true;
    }

    public SGProperties getProperties() {
        WindowProperties windowProperties = new WindowProperties();
        windowProperties.setPaperWidth(this.mClientPanel.getPaperWidth());
        windowProperties.setPaperHeight(this.mClientPanel.getPaperHeight());
        windowProperties.setBackGroundColor(this.mClientPanel.getPaperColor());
        windowProperties.setGridColor(this.mClientPanel.getGridLineColor());
        windowProperties.setGridVisible(this.mClientPanel.isGridLineVisible());
        windowProperties.setGridInterval(this.mClientPanel.getGridLineInterval());
        windowProperties.setGridLineWidth(this.mClientPanel.getGridLineWidth());
        windowProperties.setVisibleFigureList(this.getVisibleFigureList());
        windowProperties.setImageLocationX(this.getImageLocationX());
        windowProperties.setImageLocationY(this.getImageLocationY());
        windowProperties.setImageScalingFactor(this.getImageScalingFactor());
        windowProperties.setImage(this.getImage());
        return windowProperties;
    }

    protected boolean setVisibleFigure(List list) {
        return SGUtility.setVisibleList(this.mFigureList, list);
    }

    public Rectangle2D getClientRect() {
        if (this.mClientRect == null) {
            return null;
        }
        return (Rectangle2D)this.mClientRect.clone();
    }

    public boolean setClientRect(float f, float f2, float f3, float f4) {
        this.mClientRect.setRect(f, f2, f3, f4);
        return true;
    }

    public boolean setClientRect(Rectangle2D rectangle2D) {
        this.mClientRect.setRect(rectangle2D);
        return true;
    }

    public Rectangle2D getViewportBounds() {
        SGTuple2f sGTuple2f = this.getViewportSize();
        float f = sGTuple2f.x;
        float f2 = sGTuple2f.y;
        Rectangle2D.Float float_ = new Rectangle2D.Float(0.0f, 0.0f, f, f2);
        return float_;
    }

    public Rectangle2D getViewportBoundsInLayeredPane() {
        SGTuple2f sGTuple2f = this.getViewportSize();
        float f = sGTuple2f.x;
        float f2 = sGTuple2f.y;
        int n = this.mClientPanel.getRulerWidth();
        Rectangle2D.Float float_ = new Rectangle2D.Float(n, n, f, f2);
        return float_;
    }

    public Rectangle2D getViewportBoundsInComponent() {
        int n = this.getTopWidth();
        int n2 = this.getLeftWidth();
        int n3 = this.mClientPanel.getRulerWidth();
        SGTuple2f sGTuple2f = this.getViewportSize();
        float f = sGTuple2f.x + (float)n3;
        float f2 = sGTuple2f.y + (float)n3;
        Rectangle2D.Float float_ = new Rectangle2D.Float(n2, n, f, f2);
        return float_;
    }

    protected SGFigure[][] getOrderedFigureArray() {
        int n;
        int n2;
        int n3;
        ArrayList arrayList = this.getVisibleFigureList();
        int n4 = arrayList.size();
        if (n4 == 0) {
            return new SGFigure[0][0];
        }
        int n5 = 0;
        for (n3 = 1; n3 <= 16; ++n3) {
            n2 = (n3 - 1) * (n3 - 1);
            n = n3 * n3;
            if (n2 >= n4 || n4 > n) continue;
            n5 = n3;
            break;
        }
        n3 = n5;
        n2 = n4 / n3;
        n = n4 % n3 == 0 ? n2 : n2 + 1;
        SGFigure[][] sGFigureArray = new SGFigure[n][n3];
        boolean bl = true;
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n3; ++j) {
                int n6 = i * n3 + j;
                if (n6 >= arrayList.size()) {
                    bl = false;
                    break;
                }
                sGFigureArray[i][j] = (SGFigure)arrayList.get(n6);
            }
            if (!bl) break;
        }
        return sGFigureArray;
    }

    private ArrayList[][] getFigureListArray() {
        int n;
        int n2;
        int n3;
        int n4;
        Rectangle2D rectangle2D;
        ArrayList arrayList = this.getVisibleFigureList();
        if (arrayList.size() == 0) {
            return null;
        }
        float f = Float.MAX_VALUE;
        float f2 = Float.MAX_VALUE;
        for (int i = 0; i < arrayList.size(); ++i) {
            SGFigure sGFigure = (SGFigure)arrayList.get(i);
            rectangle2D = sGFigure.getGraphRect();
            if (rectangle2D.getWidth() < (double)f) {
                f = (float)rectangle2D.getWidth();
            }
            if (!(rectangle2D.getHeight() < (double)f2)) continue;
            f2 = (float)rectangle2D.getHeight();
        }
        float f3 = f;
        float f4 = f2;
        rectangle2D = this.getBoundingBoxOfFigures(arrayList);
        int n5 = (int)((float)rectangle2D.getWidth() / f3) + 1;
        int n6 = (int)((float)rectangle2D.getHeight() / f4) + 1;
        ArrayList[][] arrayListArray = new ArrayList[n5][n6];
        for (n4 = 0; n4 < n5; ++n4) {
            for (int i = 0; i < n6; ++i) {
                arrayListArray[n4][i] = new ArrayList();
            }
        }
        for (n4 = 0; n4 < arrayList.size(); ++n4) {
            SGFigure sGFigure = (SGFigure)arrayList.get(n4);
            Rectangle2D rectangle2D2 = sGFigure.getGraphRect();
            n3 = (int)((rectangle2D2.getCenterX() - rectangle2D.getX()) / (double)f3);
            n2 = (int)((rectangle2D2.getCenterY() - rectangle2D.getY()) / (double)f4);
            arrayListArray[n3][n2].add(sGFigure);
        }
        ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
        for (int i = 0; i < n5; ++i) {
            boolean bl = false;
            for (n3 = 0; n3 < n6; ++n3) {
                if (arrayListArray[i][n3].size() == 0) continue;
                bl = true;
                break;
            }
            if (!bl) continue;
            arrayList2.add(new Integer(i));
        }
        ArrayList<Integer> arrayList3 = new ArrayList<Integer>();
        for (n = 0; n < n6; ++n) {
            n3 = 0;
            for (n2 = 0; n2 < n5; ++n2) {
                if (arrayListArray[n2][n].size() == 0) continue;
                n3 = 1;
                break;
            }
            if (n3 == 0) continue;
            arrayList3.add(new Integer(n));
        }
        n = arrayList2.size();
        n3 = arrayList3.size();
        ArrayList[][] arrayListArray2 = new ArrayList[n][n3];
        for (int i = 0; i < n; ++i) {
            int n7 = (Integer)arrayList2.get(i);
            for (int j = 0; j < n3; ++j) {
                int n8 = (Integer)arrayList3.get(j);
                arrayListArray2[i][j] = arrayListArray[n7][n8];
            }
        }
        return arrayListArray2;
    }

    private boolean alignFiguresLeftAndBottom(ArrayList[][] arrayListArray) {
        int n;
        float f;
        float f2;
        float f3;
        float f4;
        int n2;
        int n3 = arrayListArray.length;
        int n4 = arrayListArray[0].length;
        float[][] fArray = new float[n3][n4];
        float[][] fArray2 = new float[n3][n4];
        float[][] fArray3 = new float[n3][n4];
        float[][] fArray4 = new float[n3][n4];
        for (int i = 0; i < n3; ++i) {
            for (n2 = 0; n2 < n4; ++n2) {
                ArrayList arrayList = arrayListArray[i][n2];
                float f5 = 0.0f;
                f4 = 0.0f;
                f3 = 0.0f;
                f2 = 0.0f;
                for (int j = 0; j < arrayList.size(); ++j) {
                    SGFigure sGFigure = (SGFigure)arrayList.get(j);
                    Rectangle2D rectangle2D = sGFigure.getGraphRect();
                    f = (float)rectangle2D.getWidth();
                    float f6 = (float)rectangle2D.getHeight();
                    SGTuple2f sGTuple2f = new SGTuple2f();
                    SGTuple2f sGTuple2f2 = new SGTuple2f();
                    sGFigure.calcMargin(sGTuple2f, sGTuple2f2);
                    float f7 = sGTuple2f.x;
                    float f8 = sGTuple2f.y;
                    float f9 = sGTuple2f2.x;
                    float f10 = sGTuple2f2.y;
                    if (f7 + f6 > f5) {
                        f5 = f7 + f6;
                    }
                    if (f8 > f4) {
                        f4 = f8;
                    }
                    if (f9 > f3) {
                        f3 = f9;
                    }
                    if (!(f10 + f > f2)) continue;
                    f2 = f10 + f;
                }
                fArray[i][n2] = f5;
                fArray2[i][n2] = f4;
                fArray3[i][n2] = f3;
                fArray4[i][n2] = f2;
            }
        }
        float[] fArray5 = new float[n3];
        for (n2 = 0; n2 < n3; ++n2) {
            float f11 = 0.0f;
            for (int i = 0; i < n4; ++i) {
                f4 = fArray3[n2][i] + fArray4[n2][i];
                if (!(f4 > f11)) continue;
                f11 = f4;
            }
            fArray5[n2] = f11;
        }
        float[] fArray6 = new float[n4];
        for (int i = 0; i < n4; ++i) {
            float f12 = 0.0f;
            for (int j = 0; j < n3; ++j) {
                f3 = fArray[j][i] + fArray2[j][i];
                if (!(f3 > f12)) continue;
                f12 = f3;
            }
            fArray6[i] = f12;
        }
        float[] fArray7 = new float[n3];
        for (int i = 0; i < n3; ++i) {
            float f13 = 0.0f;
            for (int j = 0; j < n4; ++j) {
                f2 = fArray3[i][j];
                if (!(f2 > f13)) continue;
                f13 = f2;
            }
            fArray7[i] = f13;
        }
        float[] fArray8 = new float[n3];
        for (int i = 0; i < n3; ++i) {
            float f14 = 0.0f;
            for (int j = 0; j < n4; ++j) {
                float f15 = fArray4[i][j];
                if (!(f15 > f14)) continue;
                f14 = f15;
            }
            fArray8[i] = f14;
        }
        float[] fArray9 = new float[n4];
        for (int i = 0; i < n4; ++i) {
            float f16 = 0.0f;
            for (int j = 0; j < n3; ++j) {
                float f17 = fArray2[j][i];
                if (!(f17 > f16)) continue;
                f16 = f17;
            }
            fArray9[i] = f16;
        }
        float f18 = this.getMagnification() * this.mClientPanel.getGridLineInterval();
        Rectangle2D rectangle2D = this.getPaperRect();
        float f19 = (float)rectangle2D.getX();
        float f20 = (float)rectangle2D.getY();
        float f21 = f19;
        f = f20;
        float[] fArray10 = new float[n3];
        for (int i = 0; i < n3; ++i) {
            float f22 = f21 + fArray7[i];
            int n5 = (int)((f22 - f19) / f18) + 1;
            fArray10[i] = f19 + (float)n5 * f18;
            f21 = fArray10[i] + fArray8[i];
        }
        float[] fArray11 = new float[n4];
        for (n = 0; n < n4; ++n) {
            float f23 = f + fArray6[n] - fArray9[n];
            int n6 = (int)((f23 - f20) / f18) + 1;
            fArray11[n] = f20 + (float)n6 * f18;
            f = fArray11[n] + fArray9[n];
        }
        n = 1;
        for (int i = 0; i < n4; ++i) {
            for (int j = 0; j < n3; ++j) {
                ArrayList arrayList = arrayListArray[j][i];
                for (int k = 0; k < arrayList.size(); ++k) {
                    SGFigure sGFigure = (SGFigure)arrayList.get(k);
                    if (sGFigure == null) {
                        n = 0;
                        break;
                    }
                    if (sGFigure.setGraphRectLocationByLeftBottom(fArray10[j], fArray11[i])) continue;
                    return false;
                }
                if (n == 0) break;
            }
            if (n == 0) break;
        }
        return true;
    }

    private Float findCeilingValue(float[] fArray, float f) {
        float[] fArray2 = (float[])fArray.clone();
        Arrays.sort(fArray2);
        for (int i = 0; i < fArray2.length; ++i) {
            if (!(f <= fArray2[i])) continue;
            return new Float(fArray2[i]);
        }
        return null;
    }

    public boolean alignFiguresByGraphArea() {
        int n;
        Cloneable cloneable;
        float f;
        float f2;
        float f3;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        Rectangle2D rectangle2D;
        ArrayList arrayList = this.getVisibleFigureList();
        if (arrayList.size() == 0) {
            return true;
        }
        Rectangle2D rectangle2D2 = this.mClientRect;
        float f4 = Float.MAX_VALUE;
        float f5 = Float.MAX_VALUE;
        for (int i = 0; i < arrayList.size(); ++i) {
            SGFigure sGFigure = (SGFigure)arrayList.get(i);
            rectangle2D = sGFigure.getGraphRect();
            if (rectangle2D.getWidth() < (double)f4) {
                f4 = (float)rectangle2D.getWidth();
            }
            if (!(rectangle2D.getHeight() < (double)f5)) continue;
            f5 = (float)rectangle2D.getHeight();
        }
        float f6 = f4;
        float f7 = f5;
        rectangle2D = this.getBoundingBoxOfFigures(arrayList);
        int n7 = (int)((float)rectangle2D.getWidth() / f6) + 1;
        int n8 = (int)((float)rectangle2D.getHeight() / f7) + 1;
        ArrayList[][] arrayListArray = new ArrayList[n7][n8];
        for (n6 = 0; n6 < n7; ++n6) {
            for (int i = 0; i < n8; ++i) {
                arrayListArray[n6][i] = new ArrayList();
            }
        }
        for (n6 = 0; n6 < arrayList.size(); ++n6) {
            SGFigure sGFigure = (SGFigure)arrayList.get(n6);
            Rectangle2D rectangle2D3 = sGFigure.getGraphRect();
            n5 = (int)((rectangle2D3.getCenterX() - rectangle2D.getX()) / (double)f6);
            n4 = (int)((rectangle2D3.getCenterY() - rectangle2D.getY()) / (double)f7);
            arrayListArray[n5][n4].add(sGFigure);
        }
        ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
        for (int i = 0; i < n7; ++i) {
            boolean bl = false;
            for (n5 = 0; n5 < n8; ++n5) {
                if (arrayListArray[i][n5].size() == 0) continue;
                bl = true;
                break;
            }
            if (!bl) continue;
            arrayList2.add(new Integer(i));
        }
        ArrayList<Integer> arrayList3 = new ArrayList<Integer>();
        for (n3 = 0; n3 < n8; ++n3) {
            n5 = 0;
            for (n4 = 0; n4 < n7; ++n4) {
                if (arrayListArray[n4][n3].size() == 0) continue;
                n5 = 1;
                break;
            }
            if (n5 == 0) continue;
            arrayList3.add(new Integer(n3));
        }
        n3 = arrayList2.size();
        n5 = arrayList3.size();
        ArrayList[][] arrayListArray2 = new ArrayList[n3][n5];
        for (int i = 0; i < n3; ++i) {
            int n9 = (Integer)arrayList2.get(i);
            for (int j = 0; j < n5; ++j) {
                int n10 = (Integer)arrayList3.get(j);
                arrayListArray2[i][j] = arrayListArray[n9][n10];
            }
        }
        float[][] fArray = new float[n3][n5];
        float[][] fArray2 = new float[n3][n5];
        float[][] fArray3 = new float[n3][n5];
        float[][] fArray4 = new float[n3][n5];
        for (int i = 0; i < n3; ++i) {
            for (n2 = 0; n2 < n5; ++n2) {
                if (arrayListArray2[i][n2] == null) continue;
                ArrayList arrayList4 = arrayListArray2[i][n2];
                float f8 = 0.0f;
                f3 = 0.0f;
                f2 = 0.0f;
                f = 0.0f;
                for (int j = 0; j < arrayList4.size(); ++j) {
                    SGFigure sGFigure = (SGFigure)arrayList4.get(j);
                    Rectangle2D rectangle2D4 = sGFigure.getGraphRect();
                    SGTuple2f sGTuple2f = new SGTuple2f();
                    cloneable = new SGTuple2f();
                    sGFigure.calcMargin(sGTuple2f, (SGTuple2f)cloneable);
                    if (sGTuple2f.x + (float)rectangle2D4.getHeight() > f8) {
                        f8 = sGTuple2f.x + (float)rectangle2D4.getHeight();
                    }
                    if (sGTuple2f.y > f3) {
                        f3 = sGTuple2f.y;
                    }
                    if (((SGTuple2f)cloneable).x > f2) {
                        f2 = ((SGTuple2f)cloneable).x;
                    }
                    if (!(((SGTuple2f)cloneable).y + (float)rectangle2D4.getWidth() > f)) continue;
                    f = ((SGTuple2f)cloneable).y + (float)rectangle2D4.getWidth();
                }
                fArray[i][n2] = f8;
                fArray2[i][n2] = f3;
                fArray3[i][n2] = f2;
                fArray4[i][n2] = f;
            }
        }
        float[] fArray5 = new float[n3];
        for (n2 = 0; n2 < n3; ++n2) {
            float f9 = 0.0f;
            for (int i = 0; i < n5; ++i) {
                f3 = fArray3[n2][i] + fArray4[n2][i];
                if (!(f3 > f9)) continue;
                f9 = f3;
            }
            fArray5[n2] = f9;
        }
        float[] fArray6 = new float[n5];
        for (int i = 0; i < n5; ++i) {
            float f10 = 0.0f;
            for (int j = 0; j < n3; ++j) {
                f2 = fArray[j][i] + fArray2[j][i];
                if (!(f2 > f10)) continue;
                f10 = f2;
            }
            fArray6[i] = f10;
        }
        float[] fArray7 = new float[n3];
        for (int i = 0; i < n3; ++i) {
            float f11 = 0.0f;
            for (int j = 0; j < n5; ++j) {
                f = fArray3[i][j];
                if (!(f > f11)) continue;
                f11 = f;
            }
            fArray7[i] = f11;
        }
        float[] fArray8 = new float[n5];
        for (int i = 0; i < n5; ++i) {
            float f12 = 0.0f;
            for (int j = 0; j < n3; ++j) {
                float f13 = fArray2[j][i];
                if (!(f13 > f12)) continue;
                f12 = f13;
            }
            fArray8[i] = f12;
        }
        float[] fArray9 = new float[n3];
        float f14 = (float)rectangle2D2.getX();
        for (int i = 0; i < n3; ++i) {
            fArray9[i] = f14 + fArray7[i];
            f14 += fArray5[i];
        }
        float[] fArray10 = new float[n5];
        float f15 = (float)rectangle2D2.getY();
        for (n = 0; n < n5; ++n) {
            fArray10[n] = f15 + fArray6[n] - fArray8[n];
            f15 += fArray6[n];
        }
        n = 1;
        for (int i = 0; i < n5; ++i) {
            for (int j = 0; j < n3; ++j) {
                cloneable = arrayListArray2[j][i];
                for (int k = 0; k < ((ArrayList)cloneable).size(); ++k) {
                    SGFigure sGFigure = (SGFigure)((ArrayList)cloneable).get(k);
                    if (sGFigure == null) {
                        n = 0;
                        break;
                    }
                    if (sGFigure.setGraphRectLocationByLeftBottom(fArray9[j], fArray10[i])) continue;
                    return false;
                }
                if (n == 0) break;
            }
            if (n == 0) break;
        }
        return this.setFigureBoundingBox(0);
    }

    private boolean alignFiguresByGraphAreaNew() {
        ArrayList arrayList = this.getVisibleFigureList();
        if (arrayList.size() == 0) {
            return true;
        }
        ArrayList[][] arrayListArray = this.getFigureListArray();
        if (arrayListArray == null) {
            return false;
        }
        if (arrayListArray.length == 0) {
            return false;
        }
        if (!this.alignFiguresLeftAndBottom(arrayListArray)) {
            return false;
        }
        return this.setFigureBoundingBox(0);
    }

    public boolean alignFiguresByBoundingBox() {
        boolean bl;
        int n;
        int n2;
        float f;
        int n3;
        SGFigure[][] sGFigureArray = this.getOrderedFigureArray();
        if (sGFigureArray == null) {
            return false;
        }
        if (sGFigureArray.length == 0) {
            return true;
        }
        int n4 = sGFigureArray.length;
        int n5 = sGFigureArray[0].length;
        Rectangle2D[][] rectangle2DArray = new Rectangle2D[n4][n5];
        boolean bl2 = true;
        for (int i = 0; i < n4; ++i) {
            for (n3 = 0; n3 < n5; ++n3) {
                if (sGFigureArray[i][n3] == null) {
                    bl2 = false;
                    break;
                }
                rectangle2DArray[i][n3] = sGFigureArray[i][n3].getBoundingBox();
            }
            if (!bl2) break;
        }
        float[] fArray = new float[n5];
        for (n3 = 0; n3 < n5; ++n3) {
            Rectangle2D rectangle2D;
            float f2 = 0.0f;
            for (int i = 0; i < n4 && (rectangle2D = rectangle2DArray[i][n3]) != null; ++i) {
                float f3 = (float)rectangle2DArray[i][n3].getWidth();
                if (!(f3 > f2)) continue;
                f2 = f3;
            }
            fArray[n3] = f2;
        }
        float[] fArray2 = new float[n4];
        for (int i = 0; i < n4; ++i) {
            Rectangle2D rectangle2D;
            float f4 = 0.0f;
            for (int j = 0; j < n5 && (rectangle2D = rectangle2DArray[i][j]) != null; ++j) {
                f = (float)rectangle2DArray[i][j].getHeight();
                if (!(f > f4)) continue;
                f4 = f;
            }
            fArray2[i] = f4;
        }
        Rectangle2D rectangle2D = this.getClientRect();
        float[] fArray3 = new float[n5];
        float f5 = (float)rectangle2D.getX();
        for (int i = 0; i < n5; ++i) {
            fArray3[i] = f5 + fArray[i] / 2.0f;
            f5 += fArray[i];
        }
        float[] fArray4 = new float[n4];
        f = (float)rectangle2D.getY();
        for (n2 = 0; n2 < n4; ++n2) {
            fArray4[n2] = f + fArray2[n2] / 2.0f;
            f += fArray2[n2];
        }
        bl2 = true;
        for (n2 = 0; n2 < n4; ++n2) {
            for (int i = 0; i < n5; ++i) {
                int n6 = n2 * n5 + i;
                SGFigure sGFigure = sGFigureArray[n2][i];
                if (sGFigure == null) {
                    bl2 = false;
                    break;
                }
                if (sGFigure.setCenter(fArray3[i], fArray4[n2])) continue;
                return false;
            }
            if (!bl2) break;
        }
        n2 = -1;
        float f6 = 0.0f;
        float f7 = 0.0f;
        for (n = 0; n < fArray.length; ++n) {
            f6 += fArray[n];
        }
        for (n = 0; n < fArray2.length; ++n) {
            f7 += fArray2[n];
        }
        Rectangle2D rectangle2D2 = this.getPaperRect();
        boolean bl3 = rectangle2D2.getWidth() < (double)f6;
        boolean bl4 = bl = rectangle2D2.getHeight() < (double)f7;
        if (bl3 & bl) {
            n2 = 0;
        } else if (bl3) {
            n2 = 1;
        } else if (bl) {
            n2 = 2;
        }
        return n2 == -1 || this.setFigureBoundingBox(n2);
    }

    public SGProperties getMemento() {
        return this.getProperties();
    }

    public boolean setMemento(SGProperties sGProperties) {
        return this.setProperties(sGProperties);
    }

    public boolean setMementoBackward() {
        return this.mUndoManager.setMementoBackward();
    }

    public boolean setMementoForward() {
        return this.mUndoManager.setMementoForward();
    }

    boolean updateGraphRectOfAllFigures() {
        ArrayList arrayList = this.getVisibleFigureList();
        for (int i = 0; i < arrayList.size(); ++i) {
            SGFigure sGFigure = (SGFigure)arrayList.get(i);
            sGFigure.updateGraphRect();
        }
        return true;
    }

    private boolean updateOnUndo() {
        this.clearAllFocusedObjectsInFigures();
        this.updateClientRect();
        this.updateGraphRectOfAllFigures();
        this.updateUndoItems();
        this.updateItemsByFigureNumbers();
        this.updateDataItem();
        this.updateGridItems();
        return true;
    }

    public boolean undo() {
        if (!this.mUndoManager.undo()) {
            return false;
        }
        this.updateOnUndo();
        this.updateStatusBarMessage();
        return true;
    }

    public boolean redo() {
        if (!this.mUndoManager.redo()) {
            return false;
        }
        this.updateOnUndo();
        this.updateStatusBarMessage();
        return true;
    }

    public boolean isChanged() {
        return this.mUndoManager.isChanged();
    }

    public boolean isChangedRoot() {
        if (this.isChanged()) {
            return true;
        }
        ArrayList arrayList = this.getVisibleFigureList();
        for (int i = 0; i < arrayList.size(); ++i) {
            SGIUndoable sGIUndoable = (SGIUndoable)arrayList.get(i);
            if (!sGIUndoable.isChangedRoot()) continue;
            return true;
        }
        return false;
    }

    public void setChanged(boolean bl) {
        this.mUndoManager.setChanged(bl);
    }

    private void updateUndoItems() {
        boolean bl = this.mUndoManager.isUndoable();
        boolean bl2 = this.mUndoManager.isRedoable();
        SGMenuBar sGMenuBar = this.mMenuBar;
        sGMenuBar.setMenuItemEnabled("Edit", "Undo", bl);
        sGMenuBar.setMenuItemEnabled("Edit", "Redo", bl2);
        SGToolBar sGToolBar = this.mToolBar;
        sGToolBar.setButtonEnabled("Undo", bl);
        sGToolBar.setButtonEnabled("Redo", bl2);
    }

    public void notifyToRoot() {
        this.updateHistoryTree();
    }

    private boolean updateHistoryTree() {
        return this.updateHistory();
    }

    private boolean createMenuBar() {
        SGMenuBar sGMenuBar = this.mMenuBar;
        this.setJMenuBar(sGMenuBar);
        sGMenuBar.addActionListener(this);
        sGMenuBar.addMenuListener(this);
        return true;
    }

    public boolean exportAsImage(boolean bl) {
        return this.toImage(1, bl);
    }

    public boolean startExport() {
        int n = (int)this.mClientPanel.getPaperWidth();
        int n2 = (int)this.mClientPanel.getPaperHeight();
        InfoForExport infoForExport = new InfoForExport();
        ExportPanel exportPanel = new ExportPanel();
        exportPanel.setOpaque(true);
        exportPanel.setBackground(this.mClientPanel.getPaperColor());
        exportPanel.setPreferredSize(new Dimension(n, n2));
        this.beforeExport(exportPanel, infoForExport);
        this.mExportTarget = exportPanel;
        this.mExportInfo = infoForExport;
        return true;
    }

    public boolean endExport() {
        this.afterExport(this.mExportTarget, this.mExportInfo);
        this.mExportTarget = null;
        this.mExportInfo = null;
        return true;
    }

    public Component getExportTarget() {
        return this.mExportTarget;
    }

    public boolean printImage(boolean bl) {
        return this.toImage(2, bl);
    }

    private boolean toImage(int n, boolean bl) {
        boolean bl2;
        int n2 = (int)this.mClientPanel.getPaperWidth();
        int n3 = (int)this.mClientPanel.getPaperHeight();
        InfoForExport infoForExport = new InfoForExport();
        ExportPanel exportPanel = new ExportPanel();
        exportPanel.setOpaque(true);
        exportPanel.setBackground(this.mClientPanel.getPaperColor());
        exportPanel.setPreferredSize(new Dimension(n2, n3));
        this.beforeExport(exportPanel, infoForExport);
        SGIImageExportManager sGIImageExportManager = this.mImageExportManager;
        switch (n) {
            case 1: {
                if (!bl) {
                    bl2 = sGIImageExportManager.export(exportPanel, this, n2, n3, bl);
                    break;
                }
                bl2 = sGIImageExportManager.export(exportPanel, this, n2, n3, bl);
                break;
            }
            case 2: {
                JPanel jPanel = new JPanel();
                jPanel.setLayout(null);
                jPanel.setSize(n2, n3);
                jPanel.add(exportPanel);
                jPanel.setOpaque(true);
                jPanel.setBackground(exportPanel.getBackground());
                bl2 = sGIImageExportManager.print(jPanel, this, n2, n3, bl);
                break;
            }
            default: {
                bl2 = false;
            }
        }
        this.afterExport(exportPanel, infoForExport);
        return bl2;
    }

    private boolean beforeExport(ExportPanel exportPanel, InfoForExport infoForExport) {
        int n;
        Object object;
        Object object2;
        Object object3;
        SGFigure sGFigure;
        int n2;
        float f = this.mMagnification;
        SGTuple2f sGTuple2f = this.mClientPanel.getScrollRatio();
        float f2 = sGTuple2f.x;
        float f3 = sGTuple2f.y;
        ArrayList arrayList = this.getVisibleFigureList();
        boolean bl = true;
        Rectangle rectangle = this.getPaperRect().getBounds();
        for (n2 = 0; n2 < arrayList.size(); ++n2) {
            sGFigure = (SGFigure)arrayList.get(n2);
            object3 = sGFigure.getBoundingBox().getBounds();
            if (rectangle.contains((Rectangle)object3)) continue;
            bl = false;
            break;
        }
        if (!bl) {
            SGUtility.showMessageDialog(this, "Some figures run off the edge of paper.", "Warning", 2);
        }
        this.setSelectionSymbolsVisible(false);
        for (n2 = 0; n2 < arrayList.size(); ++n2) {
            sGFigure = (SGFigure)arrayList.get(n2);
            sGFigure.setSymbolsVisibleAroundAllObjects(false);
        }
        SGTuple2f[] sGTuple2fArray = new SGTuple2f[arrayList.size()];
        for (int i = 0; i < arrayList.size(); ++i) {
            object3 = (SGFigure)arrayList.get(i);
            sGTuple2fArray[i] = new SGTuple2f(((SGFigure)object3).mGraphRectX, ((SGFigure)object3).mGraphRectY);
        }
        this.zoom(1.0f);
        Rectangle2D rectangle2D = this.getClientRect();
        for (int i = 0; i < arrayList.size(); ++i) {
            SGFigure sGFigure2 = (SGFigure)arrayList.get(i);
            sGFigure2.setGraphRectLocation(sGFigure2.getGraphRectX() - (float)rectangle2D.getX(), sGFigure2.getGraphRectY() - (float)rectangle2D.getY());
        }
        float f4 = this.mClientPanel.getPaperWidth();
        float f5 = this.mClientPanel.getPaperHeight();
        exportPanel.setOpaque(false);
        exportPanel.setLocation(0, 0);
        exportPanel.setSize((int)f4, (int)f5);
        Rectangle2D.Float float_ = new Rectangle2D.Float(0.0f, 0.0f, f4, f5);
        for (int i = arrayList.size() - 1; i >= 0; --i) {
            object2 = (SGFigure)arrayList.get(i);
            exportPanel.add((SGFigure)object2);
            object = new Rectangle(0, 0, ((SGFigure)object2).getWidth(), ((SGFigure)object2).getHeight());
            ((SGFigure)object2).setViewBounds(float_);
        }
        Image image = this.mClientPanel.getImage();
        if (image != null) {
            object2 = this.mClientPanel.getImageLocation();
            object = this.mClientPanel.getImageSize();
            float f6 = this.mClientPanel.getImageScalingFactor();
            exportPanel.setImage(image, ((SGTuple2f)object2).x, ((SGTuple2f)object2).y, ((SGTuple2f)object).x, ((SGTuple2f)object).y, f6);
        }
        for (n = 0; n < arrayList.size(); ++n) {
            object = (SGFigure)arrayList.get(n);
            ((SGFigure)object).setVisible(false);
        }
        for (n = 0; n < arrayList.size(); ++n) {
            object = (SGFigure)arrayList.get(n);
            ((SGFigure)object).setMode(0);
        }
        infoForExport.mag = f;
        infoForExport.hValue = f2;
        infoForExport.vValue = f3;
        infoForExport.locationArray = sGTuple2fArray;
        infoForExport.visibleList = arrayList;
        return true;
    }

    private boolean afterExport(ExportPanel exportPanel, InfoForExport infoForExport) {
        SGFigure sGFigure;
        int n;
        SGFigure sGFigure2;
        int n2;
        float f = infoForExport.mag;
        float f2 = infoForExport.hValue;
        float f3 = infoForExport.vValue;
        SGTuple2f[] sGTuple2fArray = infoForExport.locationArray;
        ArrayList arrayList = infoForExport.visibleList;
        this.zoom(f);
        this.mClientPanel.setScrollRatio(f3, f2);
        SGTuple2f sGTuple2f = this.getViewportSize();
        for (n2 = 0; n2 < arrayList.size(); ++n2) {
            sGFigure2 = (SGFigure)arrayList.get(n2);
            sGFigure2.mGraphRectX = sGTuple2fArray[n2].x;
            sGFigure2.mGraphRectY = sGTuple2fArray[n2].y;
            sGFigure2.updateGraphRect();
            sGFigure2.setViewBounds();
        }
        for (n2 = 0; n2 < arrayList.size(); ++n2) {
            sGFigure2 = (SGFigure)arrayList.get(n2);
            sGFigure2.setVisible(true);
        }
        this.setSelectionSymbolsVisible(true);
        ArrayList arrayList2 = this.getFocusedObjectsList();
        for (n = 0; n < arrayList2.size(); ++n) {
            sGFigure = (SGFigure)arrayList2.get(n);
            sGFigure.setSymbolsVisibleAroundAllObjects(true);
        }
        for (n = 0; n < arrayList.size(); ++n) {
            sGFigure = (SGFigure)arrayList.get(n);
            sGFigure.setMode(1);
        }
        this.repaintContentPane();
        return true;
    }

    public Element createElement(Document document) {
        Element element = document.createElement("Window");
        if (!this.writeProperty(element)) {
            return null;
        }
        return element;
    }

    public Element createElementForFocusedFiguresInBoundingBox(Document document) {
        Element element = document.createElement("Window");
        if (!this.writePropertyForFocusedFiguresInBoundingBox(element)) {
            return null;
        }
        return element;
    }

    public boolean createDOMTree(Document document) {
        boolean bl;
        switch (this.mPropertyFileCreationModeOfFigures) {
            case 0: {
                bl = this.createDOMTreeForAllFigures(document);
                break;
            }
            case 1: {
                bl = this.createDOMTreeForFocusedFiguresForDuplication(document);
                break;
            }
            case 2: {
                bl = this.createDOMTreeForFocusedFiguresInBoundingBox(document);
                break;
            }
            case 3: {
                bl = this.createDOMTreeForFocusedFiguresForDuplication(document);
                break;
            }
            default: {
                throw new Error();
            }
        }
        return bl;
    }

    public boolean createDOMTree(Document document, int n) {
        this.mPropertyFileCreationModeOfFigures = n;
        return this.createDOMTree(document);
    }

    private boolean createDOMTreeForAllFigures(Document document) {
        Element element = document.getDocumentElement();
        Element element2 = this.createElement(document);
        if (element2 == null) {
            return false;
        }
        element.appendChild(element2);
        ArrayList arrayList = this.getVisibleFigureList();
        for (int i = 0; i < arrayList.size(); ++i) {
            SGFigure sGFigure = (SGFigure)arrayList.get(i);
            Element element3 = sGFigure.createElement(document);
            if (element3 == null) {
                return false;
            }
            element2.appendChild(element3);
        }
        return true;
    }

    boolean createPropertyFileFromFocusedFigures() {
        this.mPropertyFileCreationModeOfFigures = 2;
        this.notifyToListener("Save Property");
        return true;
    }

    private boolean createDOMTreeForFocusedFiguresInBoundingBox(Document document) {
        Element element = document.getDocumentElement();
        Element element2 = this.createElementForFocusedFiguresInBoundingBox(document);
        if (element2 == null) {
            return false;
        }
        element.appendChild(element2);
        ArrayList arrayList = this.getFocusedObjectsList();
        for (int i = 0; i < arrayList.size(); ++i) {
            SGFigure sGFigure = (SGFigure)arrayList.get(i);
            Element element3 = sGFigure.createElementForFocusedInBoundingBox(document);
            if (element3 == null) {
                return false;
            }
            element2.appendChild(element3);
        }
        return true;
    }

    private boolean createDOMTreeForFocusedFiguresForDuplication(Document document) {
        Element element = document.getDocumentElement();
        Element element2 = this.createElement(document);
        if (element2 == null) {
            return false;
        }
        element.appendChild(element2);
        ArrayList arrayList = this.getFocusedObjectsList();
        for (int i = 0; i < arrayList.size(); ++i) {
            SGFigure sGFigure = (SGFigure)arrayList.get(i);
            Element element3 = sGFigure.createElementForFocusedForDuplication(document);
            if (element3 == null) {
                return false;
            }
            element2.appendChild(element3);
        }
        return true;
    }

    public boolean writePropertyForFocusedFiguresInBoundingBox(Element element) {
        Rectangle2D rectangle2D = this.getBoundingBoxOfFigures(this.getFocusedObjectsList());
        float f = (float)rectangle2D.getWidth() * 0.035277776f / this.mMagnification;
        float f2 = (float)rectangle2D.getHeight() * 0.035277776f / this.mMagnification;
        element.setAttribute("PaperWidth", Float.toString(f) + "cm");
        element.setAttribute("PaperHeight", Float.toString(f2) + "cm");
        this.writeProperty_(element);
        return true;
    }

    public boolean writeProperty(Element element) {
        element.setAttribute("PaperWidth", Float.toString(this.mClientPanel.getPaperWidth() * 0.035277776f) + "cm");
        element.setAttribute("PaperHeight", Float.toString(this.mClientPanel.getPaperHeight() * 0.035277776f) + "cm");
        this.writeProperty_(element);
        return true;
    }

    private boolean writeProperty_(Element element) {
        element.setAttribute("GridVisible", Boolean.toString(this.mClientPanel.isGridLineVisible()));
        element.setAttribute("GridInterval", Float.toString(this.mClientPanel.getGridLineInterval() * 0.035277776f) + "cm");
        element.setAttribute("GridLineWidth", Float.toString(this.mClientPanel.getGridLineWidth()) + "pt");
        element.setAttribute("BackgroundColor", SGUtilityText.getColorString(this.mClientPanel.getPaperColor()));
        element.setAttribute("GridLineColor", SGUtilityText.getColorString(this.mClientPanel.getGridLineColor()));
        return true;
    }

    public boolean readProperty(Element element) {
        float f;
        StringBuffer stringBuffer;
        String string = null;
        Number number = null;
        Boolean bl = null;
        Color color = null;
        string = element.getAttribute("PaperWidth");
        if (string.length() != 0) {
            stringBuffer = new StringBuffer();
            number = SGUtilityText.getNumber(string, stringBuffer);
            if (number == null) {
                return false;
            }
            f = number.floatValue();
            if (!this.mClientPanel.setPaperWidth(f, stringBuffer.toString())) {
                return false;
            }
        }
        if ((string = element.getAttribute("PaperHeight")).length() != 0) {
            stringBuffer = new StringBuffer();
            number = SGUtilityText.getNumber(string, stringBuffer);
            if (number == null) {
                return false;
            }
            f = number.floatValue();
            if (!this.mClientPanel.setPaperHeight(f, stringBuffer.toString())) {
                return false;
            }
        }
        if ((string = element.getAttribute("GridVisible")).length() != 0) {
            bl = SGUtilityText.getBoolean(string);
            if (bl == null) {
                return false;
            }
            boolean bl2 = bl;
            if (!this.mClientPanel.setGridLineVisible(bl2)) {
                return false;
            }
        }
        if ((string = element.getAttribute("GridInterval")).length() != 0) {
            StringBuffer stringBuffer2 = new StringBuffer();
            number = SGUtilityText.getNumber(string, stringBuffer2);
            if (number == null) {
                return false;
            }
            f = number.floatValue();
            if (!this.mClientPanel.setGridLineInterval(f, stringBuffer2.toString())) {
                return false;
            }
        }
        if ((string = element.getAttribute("GridLineWidth")).length() != 0) {
            StringBuffer stringBuffer3 = new StringBuffer();
            number = SGUtilityText.getNumber(string, stringBuffer3);
            if (number == null) {
                return false;
            }
            f = number.floatValue();
            if (!this.mClientPanel.setGridLineWidth(f, stringBuffer3.toString())) {
                return false;
            }
        }
        if ((string = element.getAttribute("BackgroundColor")).length() != 0) {
            color = SGUtilityText.getColorFromString(string);
            if (color == null) {
                return false;
            }
            Color color2 = color;
            if (!this.mClientPanel.setPaperColor(color2)) {
                return false;
            }
        }
        if ((string = element.getAttribute("GridLineColor")).length() != 0) {
            color = SGUtilityText.getColorFromString(string);
            if (color == null) {
                return false;
            }
            Color color3 = color;
            if (!this.mClientPanel.setGridLineColor(color3)) {
                return false;
            }
        }
        return true;
    }

    boolean showPropertyDialogForSelectedFigures() {
        ActionListener actionListener;
        ArrayList arrayList = this.getFocusedObjectsList();
        ArrayList<SGPropertyDialog> arrayList2 = new ArrayList<SGPropertyDialog>();
        for (int i = 0; i < arrayList.size(); ++i) {
            SGFigure sGFigure = (SGFigure)arrayList.get(i);
            actionListener = sGFigure.getPropertyDialog();
            if (actionListener == null) continue;
            arrayList2.add((SGPropertyDialog)actionListener);
        }
        List list = this.mFigureList;
        for (int i = 0; i < list.size(); ++i) {
            actionListener = (SGFigure)list.get(i);
            ((SGFigure)actionListener).clearFocusedObjects();
        }
        SGPropertyDialog sGPropertyDialog = (SGPropertyDialog)arrayList2.get(0);
        this.showPropertyDialog(sGPropertyDialog, arrayList);
        return true;
    }

    boolean showPropertyDialogForSelectedObjects(SGFigure sGFigure, SGIFigureElement sGIFigureElement) {
        ArrayList arrayList;
        SGFigure sGFigure2;
        int n;
        ArrayList arrayList2 = new ArrayList();
        ArrayList<SGPropertyDialog> arrayList3 = new ArrayList<SGPropertyDialog>();
        Class<?> clazz = sGIFigureElement.getClass();
        ArrayList arrayList4 = this.getVisibleFigureList();
        for (n = 0; n < arrayList4.size(); ++n) {
            sGFigure2 = (SGFigure)arrayList4.get(n);
            SGIFigureElement sGIFigureElement2 = sGFigure2.getIFigureElement(clazz);
            if (sGIFigureElement2 == null || (arrayList = sGIFigureElement2.getPropertyDialogObserverList()).size() == 0) continue;
            arrayList2.addAll(arrayList);
            SGIPropertyDialogObserver sGIPropertyDialogObserver = (SGIPropertyDialogObserver)arrayList2.get(0);
            SGPropertyDialog sGPropertyDialog = sGIPropertyDialogObserver.getPropertyDialog();
            arrayList3.add(sGPropertyDialog);
        }
        if (arrayList2.size() == 0) {
            return true;
        }
        for (n = 0; n < arrayList3.size() - 1; ++n) {
            sGFigure2 = arrayList3.get(n);
            for (int i = n; i < arrayList3.size(); ++i) {
                arrayList = arrayList3.get(i);
                if (sGFigure2.getClass().equals(arrayList.getClass())) continue;
                return false;
            }
        }
        for (n = 0; n < arrayList4.size(); ++n) {
            sGFigure2 = (SGFigure)arrayList4.get(n);
            sGFigure2.clearFocusedObjectsOtherThan(sGIFigureElement);
            if (sGFigure2.equals(sGFigure)) continue;
            sGFigure2.setSelected(false);
        }
        this.getContentPane().repaint();
        SGPropertyDialog sGPropertyDialog = (SGPropertyDialog)arrayList3.get(0);
        this.showPropertyDialog(sGPropertyDialog, arrayList2);
        return true;
    }

    private void showPropertyDialog(SGPropertyDialog sGPropertyDialog, SGIPropertyDialogObserver sGIPropertyDialogObserver) {
        ArrayList<SGIPropertyDialogObserver> arrayList = new ArrayList<SGIPropertyDialogObserver>();
        arrayList.add(sGIPropertyDialogObserver);
        this.showPropertyDialog(sGPropertyDialog, arrayList);
    }

    private void showPropertyDialog(SGPropertyDialog sGPropertyDialog, ArrayList arrayList) {
        for (int i = 0; i < arrayList.size(); ++i) {
            SGIPropertyDialogObserver sGIPropertyDialogObserver = (SGIPropertyDialogObserver)arrayList.get(i);
            sGPropertyDialog.addPropertyDialogObserver(sGIPropertyDialogObserver);
            sGIPropertyDialogObserver.prepare();
        }
        sGPropertyDialog.setDialogProperty();
        sGPropertyDialog.setLocation(this.getLocation());
        sGPropertyDialog.setVisible(true);
        sGPropertyDialog.removeAllPropertyDialogObserver();
        this.notifyToRoot();
    }

    public void setSaved(boolean bl) {
        if (bl) {
            this.mSavedListIndex = this.mUndoManager.getChangedObjectListIndex();
        }
        this.updateStatusBarMessage();
    }

    public boolean isSaved() {
        return this.mSavedListIndex == this.mUndoManager.getChangedObjectListIndex();
    }

    public float getPaperWidth(String string) {
        return this.mClientPanel.getPaperWidth(string);
    }

    public float getPaperHeight(String string) {
        return this.mClientPanel.getPaperHeight(string);
    }

    public float getGridLineInterval(String string) {
        return this.mClientPanel.getGridLineInterval(string);
    }

    public float getGridLineWidth(String string) {
        return this.mClientPanel.getGridLineWidth(string);
    }

    public boolean isGridLineVisible() {
        return this.mClientPanel.isGridLineVisible();
    }

    public Color getPaperColor() {
        return this.mClientPanel.getPaperColor();
    }

    public Color getGridLineColor() {
        return this.mClientPanel.getGridLineColor();
    }

    public float getImageLocationX() {
        return this.mClientPanel.getImageLocationX();
    }

    public float getImageLocationX(String string) {
        return this.mClientPanel.getImageLocationX(string);
    }

    public float getImageLocationY() {
        return this.mClientPanel.getImageLocationY();
    }

    public float getImageLocationY(String string) {
        return this.mClientPanel.getImageLocationY(string);
    }

    public float getImageWidth() {
        return this.mClientPanel.getImageWidth();
    }

    public float getImageWidth(String string) {
        return this.mClientPanel.getImageWidth(string);
    }

    public float getImageHeight() {
        return this.mClientPanel.getImageHeight();
    }

    public float getImageHeight(String string) {
        return this.mClientPanel.getImageHeight(string);
    }

    public float getImageScalingFactor() {
        return this.mClientPanel.getImageScalingFactor();
    }

    public boolean setPaperWidth(float f, String string) {
        return this.mClientPanel.setPaperWidth(f, string);
    }

    public boolean setPaperHeight(float f, String string) {
        return this.mClientPanel.setPaperHeight(f, string);
    }

    public boolean setGridLineInterval(float f, String string) {
        return this.mClientPanel.setGridLineInterval(f, string);
    }

    public boolean setGridLineWidth(float f, String string) {
        return this.mClientPanel.setGridLineWidth(f, string);
    }

    public boolean setGridLineVisible(boolean bl) {
        return this.mClientPanel.setGridLineVisible(bl);
    }

    public boolean setPaperColor(Color color) {
        return this.mClientPanel.setPaperColor(color);
    }

    public boolean setGridLineColor(Color color) {
        return this.mClientPanel.setGridLineColor(color);
    }

    public boolean setImageLocationX(float f, String string) {
        return this.mClientPanel.setImageLocationX(f, string);
    }

    public boolean setImageLocationY(float f, String string) {
        return this.mClientPanel.setImageLocationY(f, string);
    }

    public boolean setImageWidth(float f, String string) {
        return this.mClientPanel.setImageWidth(f, string);
    }

    public boolean setImageHeight(float f, String string) {
        return this.mClientPanel.setImageHeight(f, string);
    }

    public boolean setImageScalingFactor(float f) {
        return this.mClientPanel.setImageScalingFactor(f);
    }

    static {
        float f = (float)SGUtilityNumber.getPowersOfTen(-1);
        BOUNDING_BOX_MARGIN = f / 0.035277776f;
    }

    public static class WindowProperties
    extends SGProperties {
        private ArrayList mVisibleFigureList = new ArrayList();
        private float mPaperWidth;
        private float mPaperHeight;
        private Color mBackgroundColor;
        private boolean mGridVisible;
        private Color mGridColor;
        private float mGridInverval;
        private float mGridLineWidth;
        private float mImageLocationX;
        private float mImageLocationY;
        private float mImageScalingFactor;
        private Image mImage;

        public void dispose() {
            this.mVisibleFigureList.clear();
            this.mVisibleFigureList = null;
            this.mBackgroundColor = null;
            this.mGridColor = null;
            this.mImage = null;
        }

        public boolean equals(Object object) {
            if (!(object instanceof WindowProperties)) {
                return false;
            }
            WindowProperties windowProperties = (WindowProperties)object;
            if (!windowProperties.mVisibleFigureList.equals(this.mVisibleFigureList)) {
                return false;
            }
            if (windowProperties.mPaperWidth != this.mPaperWidth) {
                return false;
            }
            if (windowProperties.mPaperHeight != this.mPaperHeight) {
                return false;
            }
            if (!windowProperties.mBackgroundColor.equals(this.mBackgroundColor)) {
                return false;
            }
            if (windowProperties.mGridVisible != this.mGridVisible) {
                return false;
            }
            if (!windowProperties.mGridColor.equals(this.mGridColor)) {
                return false;
            }
            if (windowProperties.mGridInverval != this.mGridInverval) {
                return false;
            }
            if (windowProperties.mGridLineWidth != this.mGridLineWidth) {
                return false;
            }
            if (windowProperties.mImageLocationX != this.mImageLocationX) {
                return false;
            }
            if (windowProperties.mImageLocationY != this.mImageLocationY) {
                return false;
            }
            if (windowProperties.mImageScalingFactor != this.mImageScalingFactor) {
                return false;
            }
            return windowProperties.mImage.equals(this.mImage);
        }

        public List getVisibleFigureList() {
            ArrayList arrayList = new ArrayList(this.mVisibleFigureList);
            return arrayList;
        }

        public Float getPaperWidth() {
            return new Float(this.mPaperWidth);
        }

        public Float getPaperHeight() {
            return new Float(this.mPaperHeight);
        }

        public Color getBackgroundColor() {
            return this.mBackgroundColor;
        }

        public Color getGridColor() {
            return this.mGridColor;
        }

        public Boolean getGridVisible() {
            return this.mGridVisible;
        }

        public Float getGridInterval() {
            return new Float(this.mGridInverval);
        }

        public Float getGridLineWidth() {
            return new Float(this.mGridLineWidth);
        }

        public Float getImageLocationX() {
            return new Float(this.mImageLocationX);
        }

        public Float getImageLocationY() {
            return new Float(this.mImageLocationY);
        }

        public Float getImageScalingFactor() {
            return new Float(this.mImageScalingFactor);
        }

        public Image getImage() {
            return this.mImage;
        }

        public void setVisibleFigureList(List list) {
            if (list == null) {
                throw new IllegalArgumentException("list==null");
            }
            this.mVisibleFigureList = new ArrayList(list);
        }

        public void setPaperWidth(float f) {
            if (f < 0.0f) {
                throw new IllegalArgumentException("w<0.0f");
            }
            this.mPaperWidth = f;
        }

        public void setPaperHeight(float f) {
            if (f < 0.0f) {
                throw new IllegalArgumentException("h<0.0f");
            }
            this.mPaperHeight = f;
        }

        public void setBackGroundColor(Color color) {
            if (color == null) {
                throw new IllegalArgumentException("cl==null");
            }
            this.mBackgroundColor = color;
        }

        public void setGridColor(Color color) {
            if (color == null) {
                throw new IllegalArgumentException("cl==null");
            }
            this.mGridColor = color;
        }

        public void setGridVisible(boolean bl) {
            this.mGridVisible = bl;
        }

        public void setGridInterval(float f) {
            if (f < 0.0f) {
                throw new IllegalArgumentException("num<0.0f");
            }
            this.mGridInverval = f;
        }

        public void setGridLineWidth(float f) {
            if (f < 0.0f) {
                throw new IllegalArgumentException("num<0.0f");
            }
            this.mGridLineWidth = f;
        }

        public boolean setImageLocationX(float f) {
            this.mImageLocationX = f;
            return true;
        }

        public boolean setImageLocationY(float f) {
            this.mImageLocationY = f;
            return true;
        }

        public boolean setImageScalingFactor(float f) {
            if (f < 0.0f) {
                throw new IllegalArgumentException("num<0.0f");
            }
            this.mImageScalingFactor = f;
            return true;
        }

        public boolean setImage(Image image) {
            this.mImage = image;
            return true;
        }
    }

    public static class ExportPanel
    extends JPanel {
        private ArrayList mPrintableList = new ArrayList();
        private boolean mClipFlag = true;
        private SGImage mImage = null;

        private ExportPanel() {
        }

        private void add(SGFigure sGFigure) {
            ArrayList arrayList = this.mPrintableList;
            arrayList.add(sGFigure);
            SGIFigureElement[] sGIFigureElementArray = sGFigure.getIFigureElementArray();
            for (int i = 0; i < sGIFigureElementArray.length; ++i) {
                arrayList.add(sGIFigureElementArray[i]);
            }
        }

        public void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            if (this.mImage != null) {
                this.mImage.drawImage(graphics);
            }
            ArrayList arrayList = this.mPrintableList;
            boolean bl = this.getClipFlag();
            for (int i = 0; i < arrayList.size(); ++i) {
                SGIPaintable sGIPaintable = (SGIPaintable)arrayList.get(i);
                sGIPaintable.paint(graphics, bl);
            }
        }

        public boolean getClipFlag() {
            return this.mClipFlag;
        }

        public void setClipFlag(boolean bl) {
            this.mClipFlag = bl;
        }

        public SGImage getImage() {
            return this.mImage;
        }

        public SGTuple2f getImageSize() {
            return this.mImage.getImageSize();
        }

        public SGTuple2f getImageLocation() {
            return this.mImage.getImageLocation();
        }

        public boolean setImage(Image image, float f, float f2, float f3, float f4, float f5) {
            this.mImage = new SGImage(image, this, f, f2, f3, f4);
            this.mImage.setScalingFactor(f5);
            return true;
        }
    }

    private static class InfoForExport {
        float mag;
        float hValue;
        float vValue;
        SGTuple2f[] locationArray;
        ArrayList visibleList;

        private InfoForExport() {
        }
    }

    static class NodeMenuItem
    extends JMenuItem {
        SGINode node;

        NodeMenuItem(String string) {
            super(string);
        }

        SGINode getNode() {
            return this.node;
        }

        void setNode(SGINode sGINode) {
            this.node = sGINode;
        }
    }

    private class TreeMenuItemListener
    implements ActionListener {
        private TreeMenuItemListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            NodeMenuItem nodeMenuItem = (NodeMenuItem)object;
            SGINode sGINode = nodeMenuItem.node;
            SGIPropertyDialogObserver sGIPropertyDialogObserver = (SGIPropertyDialogObserver)((Object)sGINode);
            SGPropertyDialog sGPropertyDialog = sGIPropertyDialogObserver.getPropertyDialog();
            SGDrawingWindow.this.showPropertyDialog(sGPropertyDialog, sGIPropertyDialogObserver);
        }
    }
}

