/*
 * Decompiled with CFR 0.152.
 */
package jp.riken.brain.ni.samuraigraph.base;

import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import jp.riken.brain.ni.samuraigraph.base.SGIDisposable;
import jp.riken.brain.ni.samuraigraph.base.SGIDrawingElementConstants;
import jp.riken.brain.ni.samuraigraph.base.SGIVisible;
import jp.riken.brain.ni.samuraigraph.base.SGProperties;

public abstract class SGDrawingElement
implements SGIDrawingElementConstants,
SGIVisible,
SGIDisposable {
    protected float mMagnification = 1.0f;
    protected List mColorList = new ArrayList();
    protected boolean mVisibleFlag = true;

    public abstract boolean contains(int var1, int var2);

    public boolean zoom(float f) {
        this.setMagnification(f);
        return true;
    }

    public boolean isVisible() {
        return this.mVisibleFlag;
    }

    public void setVisible(boolean bl) {
        this.mVisibleFlag = bl;
    }

    public boolean setMagnification(float f) {
        this.mMagnification = f;
        return true;
    }

    public boolean setColor(List list) {
        if (list == null) {
            new NullPointerException("list==null");
        }
        if (list.size() == 0) {
            new IllegalArgumentException("list.size()==0");
        }
        for (int i = 0; i < list.size(); ++i) {
            if (list.get(i) instanceof Color) continue;
            throw new ClassCastException();
        }
        this.mColorList.clear();
        this.mColorList.addAll(list);
        return true;
    }

    public boolean setColor(Color color) {
        if (color == null) {
            new NullPointerException("cl==null");
        }
        this.mColorList.clear();
        this.mColorList.add(color);
        return true;
    }

    public boolean addColor(Color color) {
        if (color == null) {
            new NullPointerException("cl==null");
        }
        this.mColorList.add(color);
        return true;
    }

    public List getColorList() {
        return new ArrayList(this.mColorList);
    }

    public Color getColor(int n) {
        if (n >= this.mColorList.size()) {
            new IllegalArgumentException("index >= this.mColorList.size()");
        }
        return (Color)this.mColorList.get(n);
    }

    public float getMagnification() {
        return this.mMagnification;
    }

    public boolean setProperties(SGDrawingElement sGDrawingElement) {
        SGProperties sGProperties = sGDrawingElement.getProperties();
        if (sGProperties == null) {
            return false;
        }
        return this.setProperties(sGProperties);
    }

    public boolean setProperties(SGProperties sGProperties) {
        if (!(sGProperties instanceof DrawingElementProperties)) {
            return false;
        }
        DrawingElementProperties drawingElementProperties = (DrawingElementProperties)sGProperties;
        Boolean bl = drawingElementProperties.isVisible();
        if (bl == null) {
            return false;
        }
        this.setVisible(bl);
        List list = drawingElementProperties.getColorList();
        if (list == null) {
            return false;
        }
        this.setColor(list);
        return true;
    }

    public SGProperties getProperties() {
        DrawingElementProperties drawingElementProperties = new DrawingElementProperties();
        if (!this.getProperties(drawingElementProperties)) {
            return null;
        }
        return drawingElementProperties;
    }

    public boolean getProperties(SGProperties sGProperties) {
        if (!(sGProperties instanceof DrawingElementProperties)) {
            return false;
        }
        DrawingElementProperties drawingElementProperties = (DrawingElementProperties)sGProperties;
        drawingElementProperties.setVisible(this.isVisible());
        drawingElementProperties.setColor(this.getColorList());
        return true;
    }

    public void dispose() {
        this.mColorList.clear();
        this.mColorList = null;
    }

    public static class DrawingElementProperties
    extends SGProperties {
        private boolean mVisible = true;
        private List mColorList = new ArrayList();

        public void dispose() {
            this.mColorList.clear();
            this.mColorList = null;
        }

        public boolean equals(Object object) {
            if (!(object instanceof DrawingElementProperties)) {
                return false;
            }
            DrawingElementProperties drawingElementProperties = (DrawingElementProperties)object;
            if (this.mVisible != drawingElementProperties.mVisible) {
                return false;
            }
            return ((Object)this.mColorList).equals(drawingElementProperties.mColorList);
        }

        public Boolean isVisible() {
            return this.mVisible;
        }

        public List getColorList() {
            return new ArrayList(this.mColorList);
        }

        public void setVisible(boolean bl) {
            this.mVisible = bl;
        }

        public void setColor(Color color) {
            if (color == null) {
                new NullPointerException("cl==null");
            }
            this.mColorList.clear();
            this.mColorList.add(color);
        }

        public void setColor(List list) {
            if (list == null) {
                new NullPointerException("list==null");
            }
            if (list.size() == 0) {
                new IllegalArgumentException("list.size()==0");
            }
            for (int i = 0; i < list.size(); ++i) {
                if (list.get(i) instanceof Color) continue;
                throw new ClassCastException();
            }
            this.mColorList.clear();
            this.mColorList.addAll(list);
        }
    }
}

