/*
 * Decompiled with CFR 0.152.
 */
package jp.riken.brain.ni.samuraigraph.base;

import jp.riken.brain.ni.samuraigraph.base.SGTuple2d;

public class SGAxis {
    public static final int LINEAR_SCALE = 0;
    public static final int LOG_SCALE = 1;
    private int mScaleType = 0;
    private double mMinValue;
    private double mMaxValue;

    public SGAxis(double d, double d2) {
        this(d, d2, 0);
    }

    public SGAxis(double d, double d2, int n) {
        this.setRange(d, d2);
        this.setScaleType(n);
    }

    public SGAxis(SGTuple2d sGTuple2d) {
        this(sGTuple2d, 0);
    }

    public SGAxis(SGTuple2d sGTuple2d, int n) {
        this.setRange(sGTuple2d);
        this.setScaleType(n);
    }

    public boolean setRange(double d, double d2) {
        if (d >= d2) {
            new IllegalArgumentException("minValue>=maxValue");
        }
        if (this.getScaleType() == 1 && d <= 0.0) {
            new IllegalArgumentException("this.getScaleType()==LOG_SCALE && minValue<=0.0");
        }
        this.mMinValue = d;
        this.mMaxValue = d2;
        return true;
    }

    public boolean setRange(SGTuple2d sGTuple2d) {
        if (sGTuple2d == null) {
            throw new NullPointerException("range==null");
        }
        return this.setRange(sGTuple2d.x, sGTuple2d.y);
    }

    public boolean setScaleType(int n) {
        if (n != 0 && n != 1) {
            new IllegalArgumentException("scaleType!=LINEAR_SCALE && scaleType!=LOG_SCALE");
        }
        if (n == 1 && this.getMinValue() <= 0.0) {
            new IllegalArgumentException("scaleType==LOG_SCALE && this.getMinValue()<=0.0");
        }
        this.mScaleType = n;
        return true;
    }

    public double getMinValue() {
        return this.mMinValue;
    }

    public double getMaxValue() {
        return this.mMaxValue;
    }

    public SGTuple2d getRange() {
        return new SGTuple2d(this.mMinValue, this.mMaxValue);
    }

    public int getScaleType() {
        return this.mScaleType;
    }

    public boolean insideRange(double d) {
        return this.mMinValue <= d && d <= this.mMaxValue;
    }

    public boolean isValidValue(double d) {
        int n = this.getScaleType();
        return n != 1 || !(d <= 0.0);
    }
}

