
package jp.riken.brain.ni.samuraigraph.figure;

import jp.riken.brain.ni.samuraigraph.base.SGIDrawingElementConstants;

/**
 * Constants for drawing elements in figure.
 */
public interface SGIFigureDrawingElementConstants extends SGIDrawingElementConstants
{

	// line
	public static final double LINE_WIDTH_MIN = LINE_WIDTH_MIN_VALUE;
	public static final double LINE_WIDTH_MAX = LINE_WIDTH_MAX_VALUE;


	// symbol
	public static final String SYMBOL_SIZE_UNIT = cm;
	public static final double SYMBOL_SIZE_MIN = 0.05;
	public static final double SYMBOL_SIZE_MAX = 2.0;

	public static final double SYMBOL_LINE_WIDTH_MIN = LINE_WIDTH_MIN_VALUE;
	public static final double SYMBOL_LINE_WIDTH_MAX = LINE_WIDTH_MAX_VALUE;


	// bar
//	public static final float BAR_WIDTH_MIN = 0.05f/CM_POINT_RATIO;
//	public static final float BAR_WIDTH_MAX = 5.0f/CM_POINT_RATIO;
	public static final double BAR_EDGE_LINE_WIDTH_MIN = LINE_WIDTH_MIN_VALUE;
	public static final double BAR_EDGE_LINE_WIDTH_MAX = LINE_WIDTH_MAX_VALUE;


	// error bar
	public static final double ERROR_BAR_LINE_WIDTH_MIN = LINE_WIDTH_MIN_VALUE;
	public static final double ERROR_BAR_LINE_WIDTH_MAX = LINE_WIDTH_MAX_VALUE;

	public static final String ERROR_BAR_HEAD_SIZE_UNIT = SYMBOL_SIZE_UNIT;
	public static final double ERROR_BAR_HEAD_SIZE_MIN = SYMBOL_SIZE_MIN;
	public static final double ERROR_BAR_HEAD_SIZE_MAX = SYMBOL_SIZE_MAX;


	// tick label
	public static final double TICK_LABEL_FONT_SIZE_MIN = FONT_SIZE_MIN_VALUE;
	public static final double TICK_LABEL_FONT_SIZE_MAX = FONT_SIZE_MAX_VALUE;


}

