
package jp.riken.brain.ni.samuraigraph.base;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;

/**
 * The base class of all data classes.
 */

public abstract class SGData
	implements SGIData, SGICopiable, SGIDisposable
{

	/**
	 * Default constructor.
	 *
	 */
	public SGData()
	{
		super();
	}


	/**
	 * Set values with a given data.
	 * @param data - data to be copied
	 * @return
	 */
	public abstract boolean setData( final SGData data );

	
	/**
	 * Save values to given file.
	 * @param data
	 * @return
	 */
	public boolean saveData( final File file )
	{
		boolean status = false;
		try {
			FileWriter fw = new FileWriter(file);
			status = this.writeData(fw);
			fw.close();
		}
		catch(IOException ex)
		{
			return false;
		}
		return status;
	}


	/**
	 * Save values to given output file stream.
	 * @param data
	 * @throws IOException
	 * @return
	 */
	protected abstract boolean writeData( Writer fw ) throws IOException;


	/**
	 * 
	 */
	public void dispose()
	{
	}


	/**
	 * 
	 * @param array
	 * @return
	 */
	protected String toDoubleArrayString( double[] array )
	{
		if( array==null )
		{
			return "null";
		}

		String str = "{";
		for( int ii=0; ii<array.length; ii++ )
		{
			str += Double.toString( array[ii] );
			if( ii==array.length-1 )
			{
				break;
			}
			str += ",";
		}
		str += "}";
		return str;
	}


}

