
package jp.riken.brain.ni.samuraigraph.base;

import java.awt.Component;
import java.awt.Frame;
import java.util.Properties;

/**
 * An interface to export as an image.
 */
public interface SGIImageExportManager
{
	/**
	 * Export as image the target object.
	 * @param target - target object for export
	 * @param owner - owner object
	 * @param w - width of image
	 * @param h - height of image
	 * @param silent - flag for the silent mode
	 * @return true:succeeded, false:failed
	 */
	public boolean export( Component target, Frame owner, int w, int h, boolean silent );

	/**
	 * 
	 * @param target
	 * @param w
	 * @param h
	 * @param format
	 * @param path
	 * @param prop
	 * @return
	 */
	public boolean export(
		final Component target, final int w, final int h,
		final String format, final String path,
		final Properties prop );

	/**
	 * Print image of the target object.
	 * @param target - target object for export
	 * @param owner - owner object
	 * @param w - width of image
	 * @param h - height of image
	 * @param silent - flag for the silent mode
	 * @return true:succeeded, false:failed
	 */
	public boolean print( Component target, Frame owner, int w, int h, boolean silent );


}
