
package jp.riken.brain.ni.samuraigraph.base;


import java.awt.Color;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;



/**
 * An interface for the legend in figures.
 * 
 */
public interface SGILegendElement extends SGIFigureElement
{

	/**
	 * 
	 */
	public boolean setGraphElement( SGIGraphElement element );

	
	/**
	 * 
	 * @param element
	 * @return
	 */
	public boolean setAxisElement( SGIAxisElement element );
	

	/**
	 * 
	 */
	public ArrayList getDrawingElementList( SGData data );


	/**
	 * 
	 */
	public String getDataName( SGData data );


	/**
	 * 
	 */
	public boolean isDataVisible( SGData data );


	/**
	 * 
	 */
	public boolean setLegendVisible( boolean flag );



	/**
	 * 
	 */
	public boolean isLegendVisible();



	/**
	 * 
	 */
	public SGAxis getXAxis( final SGData data );


	/**
	 * 
	 */
	public SGAxis getYAxis( final SGData data );


	/**
	 * 
	 */
	public SGAxis getZAxis( final SGData data );


	/**
	 * 
	 */
	public Rectangle2D getLegendRect();


	/**
	 * 
	 */
	public ArrayList getVisibleFlagList( SGData data );



	public static final String TAG_NAME_LEGEND = "Legend";
	public static final String KEY_LEGEND_X = "X";
	public static final String KEY_LEGEND_Y = "Y";
	public static final String KEY_LEGEND_VISIBLE = "LegendVisible";
	public static final String KEY_FRAME_VISIBLE = "FrameVisible";
	public static final String KEY_FRAME_LINE_WIDTH = "FrameLineWidth";
	public static final String KEY_FRAME_LINE_COLOR = "FrameLineColor";
	public static final String KEY_BACKGROUND_COLOR = "BackgroundColor";
	public static final String KEY_BACKGROUND_TRANSPARENT = "BackgroundTransparent";
	public static final String KEY_SYMBOL_SPAN = "SymbolSpan";


	public boolean setAxisXDirectly( final int value );
	public boolean setAxisYDirectly( final int value );
	public boolean setXValueDirectly( final double value );
	public boolean setYValueDirectly( final double value );
	public boolean setLegendVisibleDirectly( final boolean value );
	public boolean setFontNameDirectly( final String value );
	public boolean setFontStyleDirectly( final int value );
	public boolean setFontSizeDirectly( final float value, final String unit );
	public boolean setFontColorDirectly( final Color value );
	public boolean setFrameVisibleDirectly( final boolean value );
	public boolean setFrameLineWidthDirectly( final float value, final String unit );
	public boolean setFrameColorDirectly( final Color value );
	public boolean setBackgroundTransparentDirectly( final boolean value );
	public boolean setBackgroundColorDirectly( final Color value );
	public boolean setSymbolSpanDirectly( final float value, final String unit );

}

