/*
 * Decompiled with CFR 0.152.
 */
package jp.riken.brain.ni.samuraigraph.data;

import java.io.IOException;
import java.io.Writer;
import jp.riken.brain.ni.samuraigraph.base.SGData;
import jp.riken.brain.ni.samuraigraph.base.SGUtility;
import jp.riken.brain.ni.samuraigraph.base.SGUtilityNumber;
import jp.riken.brain.ni.samuraigraph.data.SGIVXYTypeData;

public class SGVXYData
extends SGData
implements SGIVXYTypeData,
Cloneable {
    private double[] mXCoordinateArray = null;
    private double[] mYCoordinateArray = null;
    private double[] mComponentArray1 = null;
    private double[] mComponentArray2 = null;
    private boolean mPolarFlag = false;

    public SGVXYData() {
    }

    public SGVXYData(double[] dArray, double[] dArray2, double[] dArray3, double[] dArray4, boolean bl) {
        if (dArray == null || dArray2 == null || dArray3 == null || dArray4 == null) {
            throw new IllegalArgumentException("xArray==null || yArray==null || array1==null || array2==null");
        }
        if (dArray.length != dArray2.length || dArray.length != dArray3.length || dArray.length != dArray4.length) {
            throw new IllegalArgumentException("xArray.length!=yArray.length || xArray.length!=array1.length || xArray.length!=array2.length");
        }
        if (bl) {
            for (int i = 0; i < dArray3.length; ++i) {
                if (!(dArray3[i] < 0.0)) continue;
                throw new IllegalArgumentException("Negative values for the magnitude are unacceptable.");
            }
        }
        this.mXCoordinateArray = SGUtility.copyDoubleArray(dArray);
        this.mYCoordinateArray = SGUtility.copyDoubleArray(dArray2);
        this.mComponentArray1 = SGUtility.copyDoubleArray(dArray3);
        this.mComponentArray2 = SGUtility.copyDoubleArray(dArray4);
        this.mPolarFlag = bl;
    }

    public SGVXYData(SGData sGData) {
        this.setData(sGData);
    }

    public boolean setData(SGData sGData) {
        if (!(sGData instanceof SGVXYData)) {
            return false;
        }
        SGVXYData sGVXYData = (SGVXYData)sGData;
        this.mXCoordinateArray = sGVXYData.getXCoordinateArray();
        this.mYCoordinateArray = sGVXYData.getYCoordinateArray();
        this.mComponentArray1 = this.copyArray(sGVXYData.mComponentArray1);
        this.mComponentArray2 = this.copyArray(sGVXYData.mComponentArray2);
        this.mPolarFlag = sGVXYData.isPolar();
        return true;
    }

    public int getPointsNumber() {
        if (this.mXCoordinateArray == null) {
            return -1;
        }
        return this.mXCoordinateArray.length;
    }

    public String getDataType() {
        return "VXY";
    }

    public double getMinValueX() {
        return SGUtilityNumber.min(this.mXCoordinateArray);
    }

    public double getMinValueY() {
        return SGUtilityNumber.min(this.mYCoordinateArray);
    }

    public double getMaxValueX() {
        return SGUtilityNumber.max(this.mXCoordinateArray);
    }

    public double getMaxValueY() {
        return SGUtilityNumber.max(this.mYCoordinateArray);
    }

    public double[] getXCoordinateArray() {
        return SGUtility.copyDoubleArray(this.mXCoordinateArray);
    }

    public double[] getYCoordinateArray() {
        return SGUtility.copyDoubleArray(this.mYCoordinateArray);
    }

    public double[] getXComponentArray() {
        if (this.isPolar()) {
            int n = this.getPointsNumber();
            double[] dArray = new double[n];
            for (int i = 0; i < n; ++i) {
                dArray[i] = this.mComponentArray1[i] * Math.cos(this.mComponentArray2[i]);
            }
            return dArray;
        }
        return this.copyArray(this.mComponentArray1);
    }

    public double[] getYComponentArray() {
        if (this.isPolar()) {
            int n = this.getPointsNumber();
            double[] dArray = new double[n];
            for (int i = 0; i < n; ++i) {
                dArray[i] = this.mComponentArray1[i] * Math.sin(this.mComponentArray2[i]);
            }
            return dArray;
        }
        return this.copyArray(this.mComponentArray2);
    }

    public double[] getMagnitudeArray() {
        if (this.isPolar()) {
            return this.copyArray(this.mComponentArray1);
        }
        int n = this.getPointsNumber();
        double[] dArray = new double[n];
        for (int i = 0; i < n; ++i) {
            double d = this.mComponentArray1[i];
            double d2 = this.mComponentArray2[i];
            dArray[i] = Math.sqrt(d * d + d2 * d2);
        }
        return dArray;
    }

    public double[] getAngleArray() {
        if (this.isPolar()) {
            return this.copyArray(this.mComponentArray2);
        }
        int n = this.getPointsNumber();
        double[] dArray = new double[n];
        for (int i = 0; i < n; ++i) {
            double d = this.mComponentArray1[i];
            double d2 = this.mComponentArray2[i];
            dArray[i] = Math.atan2(d2, d);
        }
        return dArray;
    }

    private double[] copyArray(double[] dArray) {
        return SGUtility.copyDoubleArray(dArray);
    }

    public boolean isPolar() {
        return this.mPolarFlag;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public Object copy() {
        return this.clone();
    }

    public void dispose() {
        super.dispose();
        this.mXCoordinateArray = null;
        this.mYCoordinateArray = null;
        this.mComponentArray1 = null;
        this.mComponentArray2 = null;
    }

    protected boolean writeData(Writer writer) throws IOException {
        if (this.mXCoordinateArray == null) {
            return false;
        }
        if (this.mXCoordinateArray.length == 0) {
            return false;
        }
        for (int i = 0; i < this.mXCoordinateArray.length; ++i) {
            String string = this.mXCoordinateArray[i] + "," + this.mYCoordinateArray[i] + "," + this.mComponentArray1[i] + "," + this.mComponentArray2[i] + "\n";
            writer.write(string);
        }
        return true;
    }
}

