/*
 * Decompiled with CFR 0.152.
 */
package jp.riken.brain.ni.samuraigraph.base;

import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.math.BigDecimal;
import java.util.ArrayList;
import javax.print.attribute.standard.MediaSize;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollBar;
import javax.swing.SwingUtilities;
import javax.swing.event.MouseInputListener;
import jp.riken.brain.ni.samuraigraph.base.SGDrawingWindow;
import jp.riken.brain.ni.samuraigraph.base.SGFigure;
import jp.riken.brain.ni.samuraigraph.base.SGIClientPanel;
import jp.riken.brain.ni.samuraigraph.base.SGIDrawingElementConstants;
import jp.riken.brain.ni.samuraigraph.base.SGIFigureElement;
import jp.riken.brain.ni.samuraigraph.base.SGIRootObjectConstants;
import jp.riken.brain.ni.samuraigraph.base.SGImage;
import jp.riken.brain.ni.samuraigraph.base.SGTuple2f;
import jp.riken.brain.ni.samuraigraph.base.SGUtility;
import jp.riken.brain.ni.samuraigraph.base.SGUtilityNumber;
import jp.riken.brain.ni.samuraigraph.base.SGUtilityText;

public class SGClientPanel
extends JLayeredPane
implements SGIRootObjectConstants,
SGIDrawingElementConstants,
SGIClientPanel,
MouseWheelListener {
    public static final int LAYER_GRID_PANEL = 10;
    public static final int LAYER_IMAGE_PANEL = 20;
    public static final int LAYER_FIGURE = 30;
    public static final int LAYER_ANCHOR_PANEL = 40;
    public static final int LAYER_RULER_PANEL = 50;
    public static final int LAYER_SCROLLBARS_PANEL = 60;
    protected boolean mRulerVisibleFlag = true;
    private final SGTuple2f mPaperSize = new SGTuple2f();
    private BackgroundPanel mBackgroundPanel;
    private FigurePanel mFigurePanel;
    private ForegroundPanel mForegroundPanel;
    private ImagePanel mImagePanel;
    private ScrollBarsPanel mScrollBarsPanel;
    private RulerPanel mRulerPanel;
    private Rectangle2D mClientRect = null;

    public SGClientPanel(SGDrawingWindow sGDrawingWindow) {
        this.createFigurePanel(sGDrawingWindow);
        this.createBackgroundPanel(sGDrawingWindow);
        this.createForegroundPanel(sGDrawingWindow);
        this.createImagePanel(sGDrawingWindow);
        this.createScrollBarsPanel(sGDrawingWindow);
        this.createRulerPanel(sGDrawingWindow);
        this.addMouseWheelListener(this);
        this.addMouseListener(this.mRulerPanel);
        this.addMouseMotionListener(this.mRulerPanel);
    }

    public boolean setMagnification(float f) {
        this.mRulerPanel.setMagnification(f);
        this.mBackgroundPanel.setMagnification(f);
        this.mImagePanel.setMagnification(f);
        this.mFigurePanel.setMagnification(f);
        this.mForegroundPanel.setMagnification(f);
        this.mScrollBarsPanel.setMagnification(f);
        return true;
    }

    public void setSize(int n, int n2) {
        super.setSize(n, n2);
        int n3 = this.getRulerWidth();
        int n4 = n - n3;
        int n5 = n2 - n3;
        this.mRulerPanel.setBounds(0, 0, n, n2);
        this.mForegroundPanel.setBounds(n3, n3, n4, n5);
        this.mForegroundPanel.setPreferredSize(new Dimension(n4, n5));
        this.mForegroundPanel.validate();
        this.mScrollBarsPanel.setBounds(n3, n3, n4, n5);
        this.mBackgroundPanel.setBounds(n3, n3, n4, n5);
        this.mImagePanel.setBounds(n3, n3, n4, n5);
        this.mFigurePanel.setBounds(n3, n3, n4, n5);
    }

    public void setPopupMenuEnabled(String string, boolean bl) {
        this.mFigurePanel.setPopupMenuEnabled(string, bl);
    }

    private boolean createFigurePanel(SGDrawingWindow sGDrawingWindow) {
        FigurePanel figurePanel = new FigurePanel(sGDrawingWindow);
        this.add(figurePanel);
        this.setLayer(figurePanel, 30);
        figurePanel.addMouseWheelListener(this);
        figurePanel.setLayout(null);
        this.mFigurePanel = figurePanel;
        return true;
    }

    public JComponent getFigurePanel() {
        return this.mFigurePanel;
    }

    private boolean createForegroundPanel(SGDrawingWindow sGDrawingWindow) {
        ForegroundPanel foregroundPanel = new ForegroundPanel(sGDrawingWindow);
        this.add(foregroundPanel);
        this.setLayer(foregroundPanel, 40);
        this.mForegroundPanel = foregroundPanel;
        return true;
    }

    static float getAnchorSize() {
        return 6.0f;
    }

    private boolean createImagePanel(SGDrawingWindow sGDrawingWindow) {
        ImagePanel imagePanel = new ImagePanel(sGDrawingWindow);
        this.add(imagePanel);
        this.setLayer(imagePanel, 20);
        this.mImagePanel = imagePanel;
        return true;
    }

    public boolean setImage(Image image) {
        return this.mImagePanel.setImage(image);
    }

    public boolean setImageLocation(int n, int n2) {
        return this.mImagePanel.setImageLocation(n, n2);
    }

    public boolean setImageSize(int n, int n2) {
        return this.mImagePanel.setImageSize(n, n2);
    }

    public Image getImage() {
        return this.mImagePanel.getImage();
    }

    public SGTuple2f getImageLocation() {
        return this.mImagePanel.getImageLocation();
    }

    public SGTuple2f getImageSize() {
        return this.mImagePanel.getImageSize();
    }

    private boolean createBackgroundPanel(SGDrawingWindow sGDrawingWindow) {
        BackgroundPanel backgroundPanel = new BackgroundPanel(sGDrawingWindow);
        this.add(backgroundPanel);
        this.setLayer(backgroundPanel, 10);
        this.mBackgroundPanel = backgroundPanel;
        return true;
    }

    public float getPaperWidth() {
        return this.mPaperSize.x;
    }

    public float getPaperHeight() {
        return this.mPaperSize.y;
    }

    public float getPaperWidth(String string) {
        return (float)SGUtilityText.convertFromPoint(this.getPaperWidth(), string);
    }

    public float getPaperHeight(String string) {
        return (float)SGUtilityText.convertFromPoint(this.getPaperHeight(), string);
    }

    public boolean setPaperWidth(float f) {
        return this.setPaperSize(f, this.getPaperHeight());
    }

    public boolean setPaperWidth(float f, String string) {
        double d = SGUtilityText.convert(f, string, "cm");
        if (d < 1.0) {
            return false;
        }
        if (d > 99.0) {
            return false;
        }
        double d2 = SGUtilityText.convertToPoint(f, string);
        return this.setPaperSize((float)d2, this.getPaperHeight());
    }

    public boolean setPaperHeight(float f) {
        return this.setPaperSize(this.getPaperWidth(), f);
    }

    public boolean setPaperHeight(float f, String string) {
        double d = SGUtilityText.convert(f, string, "cm");
        if (d < 1.0) {
            return false;
        }
        if (d > 99.0) {
            return false;
        }
        double d2 = SGUtilityText.convertToPoint(f, string);
        return this.setPaperSize(this.getPaperWidth(), (float)d2);
    }

    public boolean setPaperSize(float f, float f2) {
        return this.setPaperSizeRoundingOff(f, f2);
    }

    public boolean setPaperSize(MediaSize mediaSize, boolean bl) {
        if (mediaSize == null) {
            return false;
        }
        BigDecimal bigDecimal = new BigDecimal(mediaSize.getX(1000));
        BigDecimal bigDecimal2 = new BigDecimal(mediaSize.getY(1000));
        bigDecimal = bigDecimal.movePointLeft(1);
        bigDecimal2 = bigDecimal2.movePointLeft(1);
        float f = bigDecimal.floatValue();
        float f2 = bigDecimal2.floatValue();
        if (bl) {
            this.setPaperSizeRoundingOffInCMUnit(f, f2);
        } else {
            this.setPaperSizeRoundingOffInCMUnit(f2, f);
        }
        return true;
    }

    private boolean setPaperSizeRoundingOffInCMUnit(float f, float f2) {
        float f3 = (float)SGUtilityNumber.roundOffNumber(f, -2);
        float f4 = (float)SGUtilityNumber.roundOffNumber(f2, -2);
        if ((double)f3 < 1.0) {
            return false;
        }
        if ((double)f3 > 99.0) {
            return false;
        }
        if ((double)f4 < 1.0) {
            return false;
        }
        if ((double)f4 > 99.0) {
            return false;
        }
        float f5 = f3 / 0.035277776f;
        float f6 = f4 / 0.035277776f;
        this.mPaperSize.setValues(f5, f6);
        return true;
    }

    private boolean setPaperSizeRoundingOutInCMUnit(float f, float f2) {
        float f3 = (float)SGUtilityNumber.roundOutNumber(f, -2);
        float f4 = (float)SGUtilityNumber.roundOutNumber(f2, -2);
        if ((double)f3 < 1.0) {
            return false;
        }
        if ((double)f3 > 99.0) {
            return false;
        }
        if ((double)f4 < 1.0) {
            return false;
        }
        if ((double)f4 > 99.0) {
            return false;
        }
        float f5 = f3 / 0.035277776f;
        float f6 = f4 / 0.035277776f;
        this.mPaperSize.setValues(f5, f6);
        return true;
    }

    public boolean setPaperSizeRoundingOff(float f, float f2) {
        float f3 = f * 0.035277776f;
        float f4 = f2 * 0.035277776f;
        return this.setPaperSizeRoundingOffInCMUnit(f3, f4);
    }

    public boolean setPaperSizeRoundingOut(float f, float f2) {
        float f3 = f * 0.035277776f;
        float f4 = f2 * 0.035277776f;
        return this.setPaperSizeRoundingOutInCMUnit(f3, f4);
    }

    public boolean isGridLineVisible() {
        return this.mBackgroundPanel.isGridVisible();
    }

    public float getGridLineWidth() {
        return this.mBackgroundPanel.getGridLineWidth();
    }

    public float getGridLineWidth(String string) {
        return (float)SGUtilityText.convertFromPoint(this.getGridLineWidth(), string);
    }

    public float getGridLineInterval() {
        return this.mBackgroundPanel.getGridInterval();
    }

    public float getGridLineInterval(String string) {
        return (float)SGUtilityText.convertFromPoint(this.getGridLineInterval(), string);
    }

    public Color getGridLineColor() {
        return this.mBackgroundPanel.getGridLineColor();
    }

    public float getImageLocationX() {
        return this.mImagePanel.getImageLocation().x;
    }

    public float getImageLocationX(String string) {
        return (float)SGUtilityText.convertFromPoint(this.getImageLocationX(), string);
    }

    public float getImageLocationY() {
        return this.mImagePanel.getImageLocation().y;
    }

    public float getImageLocationY(String string) {
        return (float)SGUtilityText.convertFromPoint(this.getImageLocationY(), string);
    }

    public float getImageWidth() {
        return this.mImagePanel.getImageSize().x;
    }

    public float getImageWidth(String string) {
        return (float)SGUtilityText.convertFromPoint(this.getImageWidth(), string);
    }

    public float getImageHeight() {
        return this.mImagePanel.getImageSize().y;
    }

    public float getImageHeight(String string) {
        return (float)SGUtilityText.convertFromPoint(this.getImageHeight(), string);
    }

    public boolean setGridLineWidth(float f) {
        this.mBackgroundPanel.setGridLineWidth(f);
        return true;
    }

    public boolean setGridLineWidth(float f, String string) {
        double d = SGUtilityText.convert(f, string, "pt");
        if (d < 0.25) {
            return false;
        }
        if (d > 6.0) {
            return false;
        }
        double d2 = SGUtilityText.convertToPoint(f, string);
        return this.setGridLineWidth((float)d2);
    }

    public boolean setGridLineColor(Color color) {
        this.mBackgroundPanel.setGridLineColor(color);
        return true;
    }

    public boolean setPaperColor(Color color) {
        this.mBackgroundPanel.setPaperColor(color);
        return true;
    }

    public boolean setGridLineVisible(boolean bl) {
        this.mBackgroundPanel.setGridVisible(bl);
        return true;
    }

    public boolean setGridLineInterval(float f) {
        this.mBackgroundPanel.setGridInterval(f);
        return true;
    }

    public boolean setGridLineInterval(float f, String string) {
        double d = SGUtilityText.convert(f, string, "cm");
        if (d < 0.5) {
            return false;
        }
        if (d > 10.0) {
            return false;
        }
        double d2 = SGUtilityText.convertToPoint(f, string);
        return this.setGridLineInterval((float)d2);
    }

    public boolean setImageLocationX(float f) {
        return this.mImagePanel.setImageLocation(f, this.getImageLocationY());
    }

    public boolean setImageLocationX(float f, String string) {
        double d = SGUtilityText.convert(f, string, "cm");
        if (d < -50.0) {
            return false;
        }
        if (d > 150.0) {
            return false;
        }
        double d2 = SGUtilityText.convertToPoint(f, string);
        return this.setImageLocationX((float)d2);
    }

    public boolean setImageLocationY(float f) {
        return this.mImagePanel.setImageLocation(this.getImageLocationX(), f);
    }

    public boolean setImageLocationY(float f, String string) {
        double d = SGUtilityText.convert(f, string, "cm");
        if (d < -50.0) {
            return false;
        }
        if (d > 150.0) {
            return false;
        }
        double d2 = SGUtilityText.convertToPoint(f, string);
        return this.setImageLocationY((float)d2);
    }

    public boolean setImageWidth(float f) {
        return this.mImagePanel.setImageSize(f, this.getImageHeight());
    }

    public boolean setImageWidth(float f, String string) {
        double d = SGUtilityText.convert(f, string, "cm");
        if (d < 0.0) {
            return false;
        }
        if (d > 99.0) {
            return false;
        }
        double d2 = SGUtilityText.convertToPoint(f, string);
        return this.setImageWidth((float)d2);
    }

    public boolean setImageHeight(float f) {
        return this.mImagePanel.setImageSize(this.getImageWidth(), f);
    }

    public boolean setImageHeight(float f, String string) {
        double d = SGUtilityText.convert(f, string, "cm");
        if (d < 0.0) {
            return false;
        }
        if (d > 99.0) {
            return false;
        }
        double d2 = SGUtilityText.convertToPoint(f, string);
        return this.setImageHeight((float)d2);
    }

    public float getImageScalingFactor() {
        return this.mImagePanel.getScalingFactor();
    }

    public boolean setImageScalingFactor(float f) {
        if ((double)f < 0.01) {
            return false;
        }
        if ((double)f > 100.0) {
            return false;
        }
        return this.mImagePanel.setScalingFactor(f);
    }

    public Color getPaperColor() {
        return this.mBackgroundPanel.getPaperColor();
    }

    private boolean createScrollBarsPanel(SGDrawingWindow sGDrawingWindow) {
        ScrollBarsPanel scrollBarsPanel = new ScrollBarsPanel(sGDrawingWindow);
        this.add(scrollBarsPanel);
        this.setLayer(scrollBarsPanel, 60);
        this.mScrollBarsPanel = scrollBarsPanel;
        return true;
    }

    public boolean setScrollRatio(float f, float f2) {
        return this.mScrollBarsPanel.setScrollRatio(f, f2);
    }

    public SGTuple2f getScrollRatio() {
        return this.mScrollBarsPanel.getScrollRatio();
    }

    public boolean setScrollBarValue(Rectangle2D rectangle2D, Rectangle2D rectangle2D2) {
        return this.mScrollBarsPanel.setScrollBarValue(rectangle2D, rectangle2D2);
    }

    public boolean setEnableScrollBars(Rectangle2D rectangle2D, Rectangle2D rectangle2D2) {
        return this.mScrollBarsPanel.setEnableScrollBars(rectangle2D, rectangle2D2);
    }

    private boolean createRulerPanel(SGDrawingWindow sGDrawingWindow) {
        RulerPanel rulerPanel = new RulerPanel(sGDrawingWindow);
        this.add(rulerPanel);
        this.setLayer(rulerPanel, 50);
        this.mRulerPanel = rulerPanel;
        return true;
    }

    public int getRulerWidth() {
        int n = 0;
        if (this.mRulerVisibleFlag) {
            n = 20;
        }
        return n;
    }

    public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
        int n = mouseWheelEvent.getScrollAmount() * mouseWheelEvent.getWheelRotation();
        this.mScrollBarsPanel.onMouseWheelMoved(n);
    }

    private static class RulerPanel
    extends InnerPanel
    implements MouseInputListener {
        private static final float RULER_FONT_SIZE = 11.0f;
        private static final String RULER_FONT_NAME = "Serif";
        private static final int RULER_FONT_STYLE = 0;
        private static final int RULER_WIDTH = 20;
        private static final int ANCHOR_SIZE = 12;
        private static final Color INNER_COLOR_1 = new Color(234, 238, 232);
        private static final Color INNER_COLOR_2 = new Color(124, 155, 64);
        private static final Color ANCHOR_INNER_COLOR = new Color(222, 222, 222);
        private static final float ANCHOR_EDGE_LINE_WIDTH = 4.0f;
        private static final Color ANCHOR_EDGE_LINE_COLOR = Color.WHITE;
        private static final Color LINE_COLOR = Color.BLACK;
        private static final float LINE_WIDTH = 2.0f;
        private static final BasicStroke LINE_STROKE = new BasicStroke(2.0f, 0, 0, 1.0f, new float[]{10.0f, 2.0f, 2.0f, 4.0f}, 0.0f);
        private Font mRulerFont = null;
        private Point2D mHorizontalLocation = null;
        private Point2D mVerticalLocation = null;
        private boolean mDrawHorizontalLineFlag = false;
        private boolean mDrawVerticalLineFlag = false;

        protected RulerPanel(SGDrawingWindow sGDrawingWindow) {
            super(sGDrawingWindow);
            this.setVisible(true);
            this.setOpaque(false);
            this.mRulerFont = new Font(RULER_FONT_NAME, 0, 11);
        }

        public void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            Graphics2D graphics2D = (Graphics2D)graphics;
            this.drawRuler(graphics2D);
            if (this.mDrawHorizontalLineFlag) {
                this.drawHorizontalLine(graphics2D);
            }
            if (this.mDrawVerticalLineFlag) {
                this.drawVerticalLine(graphics2D);
            }
            Point2D point2D = null;
            point2D = this.mDrawHorizontalLineFlag ? this.mHorizontalLocation : this.getHorizontalAnchorLocationFromPaper();
            this.drawHorizontalAnchor((int)point2D.getX(), (Graphics2D)graphics2D.create());
            point2D = null;
            point2D = this.mDrawVerticalLineFlag ? this.mVerticalLocation : this.getVerticalAnchorLocationFromPaper();
            this.drawVerticalAnchor((int)point2D.getY(), (Graphics2D)graphics2D.create());
        }

        private void drawHorizontalAnchor(int n, Graphics2D graphics2D) {
            int[] nArray = new int[7];
            int[] nArray2 = new int[7];
            int n2 = (int)this.getHorizontalAnchorLocationFromPaper().getY() - 1;
            nArray[0] = n + 3;
            nArray2[0] = n2 - 10;
            nArray[1] = nArray[0];
            nArray2[1] = n2 - 6;
            nArray[2] = n + 6;
            nArray2[2] = nArray2[1];
            nArray[3] = n;
            nArray2[3] = n2;
            nArray[4] = n - 6;
            nArray2[4] = nArray2[2];
            nArray[5] = n - 3;
            nArray2[5] = nArray2[4];
            nArray[6] = nArray[5];
            nArray2[6] = nArray2[0];
            this.drawAnchor(nArray, nArray2, 7, graphics2D);
        }

        private void drawVerticalAnchor(int n, Graphics2D graphics2D) {
            int[] nArray = new int[7];
            int[] nArray2 = new int[7];
            int n2 = (int)this.getVerticalAnchorLocationFromPaper().getX() - 1;
            nArray[0] = n2 - 10;
            nArray2[0] = n + 3;
            nArray[1] = n2 - 6;
            nArray2[1] = nArray2[0];
            nArray[2] = nArray[1];
            nArray2[2] = n + 6;
            nArray[3] = n2;
            nArray2[3] = n;
            nArray[4] = nArray[2];
            nArray2[4] = n - 6;
            nArray[5] = nArray[4];
            nArray2[5] = n - 3;
            nArray[6] = nArray[0];
            nArray2[6] = nArray2[5];
            this.drawAnchor(nArray, nArray2, 7, graphics2D);
        }

        private void drawAnchor(int[] nArray, int[] nArray2, int n, Graphics2D graphics2D) {
            Polygon polygon = new Polygon(nArray, nArray2, n);
            int n2 = nArray[6];
            int n3 = nArray2[6];
            int n4 = (nArray[2] + nArray[3]) / 2;
            int n5 = (nArray2[2] + nArray2[3]) / 2;
            GradientPaint gradientPaint = new GradientPaint(n2, n3, INNER_COLOR_1, n4, n5, INNER_COLOR_2);
            graphics2D.setPaint(gradientPaint);
            graphics2D.fill(polygon);
            graphics2D.setStroke(new BasicStroke(1.0f));
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            graphics2D.setPaint(Color.BLACK);
            graphics2D.draw(polygon);
        }

        private void drawHorizontalLine(Graphics2D graphics2D) {
            if (this.mHorizontalLocation == null) {
                return;
            }
            Point2D point2D = this.mHorizontalLocation;
            float f = (float)point2D.getX();
            Line2D.Float float_ = new Line2D.Float();
            ((Line2D)float_).setLine(point2D.getX(), this.getHorizontalAnchorLocationFromPaper().getY(), point2D.getX(), this.getHeight());
            graphics2D.setPaint(LINE_COLOR);
            graphics2D.setStroke(LINE_STROKE);
            graphics2D.draw(float_);
        }

        private void drawVerticalLine(Graphics2D graphics2D) {
            if (this.mVerticalLocation == null) {
                return;
            }
            Point2D point2D = this.mVerticalLocation;
            Line2D.Float float_ = new Line2D.Float();
            ((Line2D)float_).setLine(this.getVerticalAnchorLocationFromPaper().getX(), point2D.getY(), this.getWidth(), point2D.getY());
            graphics2D.setPaint(LINE_COLOR);
            graphics2D.setStroke(LINE_STROKE);
            graphics2D.draw(float_);
        }

        private boolean isPressed() {
            return this.mDrawHorizontalLineFlag | this.mDrawVerticalLineFlag;
        }

        private Point2D getHorizontalAnchorLocationFromPaper() {
            Rectangle2D rectangle2D = this.mWnd.getPaperRect();
            float f = (float)rectangle2D.getX();
            float f2 = (float)rectangle2D.getY();
            float f3 = (float)rectangle2D.getWidth();
            Point2D.Float float_ = new Point2D.Float(f + 20.0f + f3, 20.0f);
            return float_;
        }

        private Point2D getVerticalAnchorLocationFromPaper() {
            Rectangle2D rectangle2D = this.mWnd.getPaperRect();
            float f = (float)rectangle2D.getX();
            float f2 = (float)rectangle2D.getY();
            float f3 = (float)rectangle2D.getHeight();
            Point2D.Float float_ = new Point2D.Float(20.0f, f2 + 20.0f + f3);
            return float_;
        }

        private float getPaperStartX() {
            Rectangle2D rectangle2D = this.mWnd.getPaperRect();
            float f = (float)rectangle2D.getX();
            return f + 20.0f;
        }

        private float getPaperStartY() {
            Rectangle2D rectangle2D = this.mWnd.getPaperRect();
            float f = (float)rectangle2D.getY();
            return f + 20.0f;
        }

        private float getPaperEndX() {
            Rectangle2D rectangle2D = this.mWnd.getPaperRect();
            float f = (float)rectangle2D.getX();
            float f2 = (float)rectangle2D.getWidth();
            return f + 20.0f + f2;
        }

        private float getPaperEndY() {
            Rectangle2D rectangle2D = this.mWnd.getPaperRect();
            float f = (float)rectangle2D.getY();
            float f2 = (float)rectangle2D.getHeight();
            return f + 20.0f + f2;
        }

        private boolean drawRuler(Graphics2D graphics2D) {
            int n = this.getWidth();
            int n2 = this.getHeight();
            int[] nArray = new int[6];
            int[] nArray2 = new int[6];
            nArray[0] = 0;
            nArray2[0] = 0;
            nArray[1] = n;
            nArray2[1] = 0;
            nArray[2] = n;
            nArray2[2] = 20;
            nArray[3] = 20;
            nArray2[3] = 20;
            nArray[4] = 20;
            nArray2[4] = n2;
            nArray[5] = 0;
            nArray2[5] = n2;
            Polygon polygon = new Polygon(nArray, nArray2, 6);
            Color color = this.getBackground();
            Color color2 = Color.BLACK;
            graphics2D.setPaint(color);
            graphics2D.fill(polygon);
            graphics2D.setPaint(color2);
            graphics2D.setStroke(new BasicStroke(1.0f));
            graphics2D.draw(polygon);
            this.drawNumbersAndLines(graphics2D);
            Rectangle2D.Float float_ = new Rectangle2D.Float(0.0f, 0.0f, 20.0f, 20.0f);
            graphics2D.setPaint(color);
            graphics2D.fill(float_);
            graphics2D.setPaint(color2);
            graphics2D.draw(float_);
            return true;
        }

        private boolean drawNumbersAndLines(Graphics2D graphics2D) {
            float f;
            int n;
            float f2;
            float f3;
            int n2;
            float f4;
            int n3;
            int n4;
            float f5 = this.mMagnification;
            int n5 = this.getWidth();
            int n6 = this.getHeight();
            Rectangle rectangle = new Rectangle(0, 0, n5 - 20, n6 - 20);
            Rectangle2D rectangle2D = this.mWnd.getPaperRect();
            Rectangle2D rectangle2D2 = this.mWnd.getClientRect();
            Line2D.Float float_ = new Line2D.Float();
            graphics2D.setPaint(Color.BLACK);
            graphics2D.setStroke(new BasicStroke(2.0f));
            float f6 = n5;
            ((Line2D)float_).setLine(20.0, 20.0, f6, 20.0);
            graphics2D.draw(float_);
            float f7 = n6;
            ((Line2D)float_).setLine(20.0, 20.0, 20.0, f7);
            graphics2D.draw(float_);
            Font font = this.mRulerFont;
            graphics2D.setStroke(new BasicStroke(1.0f));
            graphics2D.setFont(font);
            f6 = font.getSize();
            if (f5 < 0.5f) {
                n4 = 4;
                n3 = 8;
            } else if (f5 < 1.0f) {
                n4 = 2;
                n3 = 4;
            } else {
                n4 = 1;
                n3 = 4;
            }
            float f8 = f5 / 0.035277776f;
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            float f9 = (float)rectangle2D.getX();
            float f10 = -f9;
            float f11 = f10 / f8;
            float f12 = (float)rectangle.getWidth() + f10;
            int n7 = (int)f11;
            if (n7 % n4 != 0) {
                n7 = n7 / n4 * n4;
            }
            int n8 = n7;
            while (!((f4 = f8 * (float)n8) > f12)) {
                arrayList.add(new Integer(n8));
                n8 += n4;
            }
            for (int i = 0; i < arrayList.size(); ++i) {
                n2 = (Integer)arrayList.get(i);
                f3 = (float)n2 * f8;
                f2 = f9 + 20.0f + f3;
                ((Line2D)float_).setLine(f2, 4.0, f2, 20.0);
                graphics2D.draw(float_);
                int n9 = (int)(f2 + 0.3f * f6);
                n = (int)f6 + 1;
                graphics2D.drawString(Integer.toString(n2), n9, n);
                for (int j = 0; j < n3; ++j) {
                    float f13 = f2 + 0.2f * (float)(j + 1) * f8 * (float)n4;
                    ((Line2D)float_).setLine(f13, 15.0, f13, 20.0);
                    graphics2D.draw(float_);
                }
            }
            arrayList = new ArrayList();
            f9 = (float)rectangle2D.getY();
            f10 = -f9;
            f11 = f10 / f8;
            f12 = (float)rectangle.getHeight() + f10;
            n7 = (int)f11;
            if (n7 % n4 != 0) {
                n7 = n7 / n4 * n4;
            }
            n8 = n7;
            while (!((f = f8 * (float)n8) > f12)) {
                arrayList.add(new Integer(n8));
                n8 += n4;
            }
            for (int i = 0; i < arrayList.size(); ++i) {
                int n10;
                n2 = (Integer)arrayList.get(i);
                f3 = (float)n2 * f8;
                f2 = f9 + 20.0f + f3;
                ((Line2D)float_).setLine(4.0, f2, 20.0, f2);
                graphics2D.draw(float_);
                n = (int)(f2 + f6 + 1.0f);
                char[] cArray = Integer.toString(n2).toCharArray();
                for (n10 = 0; n10 < cArray.length; ++n10) {
                    Character c = new Character(cArray[n10]);
                    graphics2D.drawString(c.toString(), 4, n);
                    n += (int)f6;
                }
                for (n10 = 0; n10 < n3; ++n10) {
                    float f14 = f2 + 0.2f * (float)(n10 + 1) * f8 * (float)n4;
                    ((Line2D)float_).setLine(15.0, f14, 20.0, f14);
                    graphics2D.draw(float_);
                }
            }
            return true;
        }

        public void mouseClicked(MouseEvent mouseEvent) {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            int n;
            Point2D point2D = this.getHorizontalAnchorLocationFromPaper();
            int n2 = (int)point2D.getX();
            Rectangle rectangle = new Rectangle(n2 - 5, (n = (int)point2D.getY()) - 10, 10, 10);
            if (rectangle.contains(mouseEvent.getPoint())) {
                this.mDrawHorizontalLineFlag = true;
                this.mHorizontalLocation = point2D;
                this.repaint();
                return;
            }
            point2D = this.getVerticalAnchorLocationFromPaper();
            n2 = (int)point2D.getX();
            rectangle = new Rectangle(n2 - 10, (n = (int)point2D.getY()) - 5, 10, 10);
            if (rectangle.contains(mouseEvent.getPoint())) {
                this.mDrawVerticalLineFlag = true;
                this.mVerticalLocation = point2D;
                this.repaint();
                return;
            }
            this.mDrawHorizontalLineFlag = false;
            this.mDrawVerticalLineFlag = false;
            this.mHorizontalLocation = null;
            this.mVerticalLocation = null;
            this.repaint();
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            if (this.isPressed()) {
                float f;
                int n = mouseEvent.getX();
                int n2 = mouseEvent.getY();
                Rectangle2D rectangle2D = this.mWnd.getPaperRect();
                SGTuple2f sGTuple2f = this.mWnd.getPaperSize();
                float f2 = this.getPaperStartX();
                float f3 = this.getPaperStartY();
                float f4 = (float)rectangle2D.getWidth();
                float f5 = (float)rectangle2D.getHeight();
                if (this.mDrawHorizontalLineFlag) {
                    f = ((float)n - f2) / this.mMagnification;
                    if (f < 28.346458f) {
                        f = 28.346458f;
                    }
                    if (f > 2806.2993f) {
                        f = 2806.2993f;
                    }
                    this.mWnd.setPaperSize(f, sGTuple2f.y);
                    this.mWnd.setChanged(true);
                }
                if (this.mDrawVerticalLineFlag) {
                    f = ((float)n2 - f3) / this.mMagnification;
                    if (f < 28.346458f) {
                        f = 28.346458f;
                    }
                    if (f > 2806.2993f) {
                        f = 2806.2993f;
                    }
                    this.mWnd.setPaperSize(sGTuple2f.x, f);
                    this.mWnd.setChanged(true);
                }
                if (this.mDrawHorizontalLineFlag | this.mDrawVerticalLineFlag) {
                    this.mWnd.updateClientRect();
                    this.mWnd.notifyToRoot();
                    this.repaint();
                }
                this.mDrawHorizontalLineFlag = false;
                this.mDrawVerticalLineFlag = false;
                this.mHorizontalLocation = null;
                this.mVerticalLocation = null;
                this.mWnd.repaintContentPane();
            }
        }

        public void mouseEntered(MouseEvent mouseEvent) {
        }

        public void mouseExited(MouseEvent mouseEvent) {
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            if (this.isPressed()) {
                this.mHorizontalLocation = mouseEvent.getPoint();
                this.mVerticalLocation = mouseEvent.getPoint();
                this.mWnd.repaintContentPane();
            }
        }

        public void mouseMoved(MouseEvent mouseEvent) {
        }
    }

    private static class BackgroundPanel
    extends InnerPanel {
        private boolean mGridVisibleFlag = true;
        private float mGridInterval = 28.346458f;
        private float mGridLineWidth = 1.0f;
        private Color mGridLineColor = SGIRootObjectConstants.DEFAULT_GRID_LINE_COLOR;
        private Color mPaperColor = SGIRootObjectConstants.DEFAULT_PAPER_COLOR;

        protected BackgroundPanel(SGDrawingWindow sGDrawingWindow) {
            super(sGDrawingWindow);
            this.setVisible(true);
            this.setOpaque(true);
        }

        public void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            Graphics2D graphics2D = (Graphics2D)graphics;
            Rectangle2D rectangle2D = this.mWnd.getPaperRect();
            float f = (float)rectangle2D.getX();
            float f2 = (float)rectangle2D.getY();
            float f3 = (float)rectangle2D.getWidth();
            float f4 = (float)rectangle2D.getHeight();
            Rectangle2D rectangle2D2 = this.mWnd.getViewportBounds();
            float f5 = (float)rectangle2D2.getX();
            float f6 = (float)rectangle2D2.getY();
            float f7 = (float)rectangle2D2.getWidth();
            float f8 = (float)rectangle2D2.getHeight();
            graphics2D.setPaint(this.getPaperColor());
            graphics2D.fill(rectangle2D);
            Line2D.Float float_ = new Line2D.Float();
            if (this.isGridVisible()) {
                graphics2D.setStroke(new BasicStroke(this.getGridLineWidth()));
                graphics2D.setPaint(this.getGridLineColor());
                float[] fArray = this.getVerticalGridLocation();
                for (int i = 0; i < fArray.length; ++i) {
                    float f9 = fArray[i];
                    ((Line2D)float_).setLine(f9, f2, f9, f2 + f4);
                    graphics2D.draw(float_);
                }
                float[] fArray2 = this.getHorizontalGridLocation();
                for (int i = 0; i < fArray2.length; ++i) {
                    float f10 = fArray2[i];
                    ((Line2D)float_).setLine(f, f10, f + f3, f10);
                    graphics2D.draw(float_);
                }
            }
            graphics2D.setPaint(Color.BLACK);
            graphics2D.setStroke(new BasicStroke(1.0f));
            graphics2D.draw(rectangle2D);
        }

        public float[] getVerticalGridLocation() {
            float f;
            float f2 = this.mMagnification * this.getGridInterval();
            Rectangle2D rectangle2D = this.mWnd.getPaperRect();
            float f3 = (float)rectangle2D.getX();
            float f4 = (float)rectangle2D.getWidth();
            Rectangle2D rectangle2D2 = this.mWnd.getViewportBounds();
            float f5 = (float)rectangle2D2.getX();
            float f6 = (float)rectangle2D2.getWidth();
            ArrayList<Float> arrayList = new ArrayList<Float>();
            int n = (int)((f5 - f3) / f2) + 1;
            while (!((f = (float)n * f2 + f3) > f5 + f6) && !(f > f3 + f4)) {
                arrayList.add(new Float(f));
                ++n;
            }
            float[] fArray = new float[arrayList.size()];
            for (int i = 0; i < fArray.length; ++i) {
                fArray[i] = ((Float)arrayList.get(i)).floatValue();
            }
            return fArray;
        }

        public float[] getHorizontalGridLocation() {
            float f;
            float f2 = this.mMagnification * this.getGridInterval();
            Rectangle2D rectangle2D = this.mWnd.getPaperRect();
            float f3 = (float)rectangle2D.getY();
            float f4 = (float)rectangle2D.getHeight();
            Rectangle2D rectangle2D2 = this.mWnd.getViewportBounds();
            float f5 = (float)rectangle2D2.getY();
            float f6 = (float)rectangle2D2.getHeight();
            ArrayList<Float> arrayList = new ArrayList<Float>();
            int n = (int)((f5 - f3) / f2) + 1;
            while (!((f = (float)n * f2 + f3) > f5 + f6) && !(f > f3 + f4)) {
                arrayList.add(new Float(f));
                ++n;
            }
            float[] fArray = new float[arrayList.size()];
            for (int i = 0; i < fArray.length; ++i) {
                fArray[i] = ((Float)arrayList.get(i)).floatValue();
            }
            return fArray;
        }

        public float getGridInterval() {
            return this.mGridInterval;
        }

        public Color getGridLineColor() {
            return this.mGridLineColor;
        }

        public float getGridLineWidth() {
            return this.mGridLineWidth;
        }

        public boolean isGridVisible() {
            return this.mGridVisibleFlag;
        }

        public void setGridInterval(float f) {
            this.mGridInterval = f;
        }

        public void setGridLineColor(Color color) {
            this.mGridLineColor = color;
        }

        public void setGridLineWidth(float f) {
            this.mGridLineWidth = f;
        }

        public void setGridVisible(boolean bl) {
            this.mGridVisibleFlag = bl;
        }

        public Color getPaperColor() {
            return this.mPaperColor;
        }

        public void setPaperColor(Color color) {
            this.mPaperColor = color;
        }
    }

    private static class ImagePanel
    extends InnerPanel {
        private SGImage mImage;
        private float mImageLocationX;
        private float mImageLocationY;

        protected ImagePanel(SGDrawingWindow sGDrawingWindow) {
            super(sGDrawingWindow);
            this.setVisible(true);
            this.setOpaque(false);
            this.mImage = new SGImage(this);
        }

        public boolean setImage(Image image) {
            if (!this.mImage.setImage(image)) {
                return false;
            }
            this.mImage.setDafaultImageSize();
            return true;
        }

        public boolean setImageLocation(float f, float f2) {
            this.mImageLocationX = f;
            this.mImageLocationY = f2;
            return true;
        }

        public boolean setImageSize(float f, float f2) {
            return this.mImage.setImageSize(f, f2);
        }

        public Image getImage() {
            return this.mImage.getImage();
        }

        public SGTuple2f getImageLocation() {
            return new SGTuple2f(this.mImageLocationX, this.mImageLocationY);
        }

        public SGTuple2f getImageSize() {
            return this.mImage.getImageSize();
        }

        public void setMagnification(float f) {
            super.setMagnification(f);
            this.mImage.setMagnification(f);
        }

        public float getScalingFactor() {
            return this.mImage.getScalingFactor();
        }

        public boolean setScalingFactor(float f) {
            return this.mImage.setScalingFactor(f);
        }

        public void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            if (this.mImage == null) {
                return;
            }
            Rectangle2D rectangle2D = this.mWnd.getClientRect();
            float f = this.mMagnification;
            float f2 = (float)rectangle2D.getX() + f * this.mImageLocationX;
            float f3 = (float)rectangle2D.getY() + f * this.mImageLocationY;
            this.mImage.setImageLocation(f2, f3);
            this.mImage.drawImage(graphics);
        }
    }

    private static class FigurePanel
    extends InnerPanel
    implements MouseInputListener,
    ActionListener {
        private static final String DIALOG_TITLE_ADDITION_ERROR = "Failed to add a symbol.";
        private static final String ERRMSG_CLICK_GRAPH_RECTANGLE = "Click within the recatngle of figure.";
        private JPopupMenu mPopupMenu = new JPopupMenu();

        protected FigurePanel(SGDrawingWindow sGDrawingWindow) {
            super(sGDrawingWindow);
            this.setVisible(true);
            this.setOpaque(false);
            this.createPopupMenu();
            this.addMouseListener(this);
            this.addMouseMotionListener(this);
        }

        public void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            SGFigure[] sGFigureArray = this.mWnd.getFigureArray();
            for (int i = 0; i < sGFigureArray.length; ++i) {
                if (!sGFigureArray[i].isVisible()) continue;
                sGFigureArray[i].paint(graphics, true);
            }
        }

        private boolean createPopupMenu() {
            JPopupMenu jPopupMenu = this.mPopupMenu;
            jPopupMenu.setBounds(0, 0, 100, 100);
            jPopupMenu.add(new JLabel("  -- Window --"));
            jPopupMenu.addSeparator();
            SGUtility.addItem(jPopupMenu, this, "Paste");
            jPopupMenu.addSeparator();
            SGUtility.addItem(jPopupMenu, this, "Property");
            return true;
        }

        protected void setPopupMenuEnabled(String string, boolean bl) {
            Component[] componentArray = this.mPopupMenu.getComponents();
            for (int i = 0; i < componentArray.length; ++i) {
                JMenuItem jMenuItem;
                if (!(componentArray[i] instanceof JMenuItem) || !(jMenuItem = (JMenuItem)componentArray[i]).getActionCommand().equals(string)) continue;
                jMenuItem.setEnabled(bl);
            }
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            Object object = actionEvent.getSource();
            if (string.equals("Paste")) {
                this.mWnd.doPaste();
            } else if (string.equals("Property")) {
                this.mWnd.showPropertyDialog();
            }
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            this.grabFocus();
            boolean bl = this.clickFigures(mouseEvent);
            if (!bl) {
                this.mWnd.clearAllFocusedObjectsInFigures();
                this.mWnd.setDefaultCursor();
                if (SwingUtilities.isLeftMouseButton(mouseEvent) && mouseEvent.getClickCount() == 2) {
                    this.mWnd.showPropertyDialog();
                }
                if (SwingUtilities.isRightMouseButton(mouseEvent) && mouseEvent.getClickCount() == 1) {
                    this.mPopupMenu.show(this, mouseEvent.getX(), mouseEvent.getY());
                }
            }
            this.mWnd.updateDataItem();
            this.mWnd.updateFocusedObjectItem();
        }

        public void mousePressed(MouseEvent mouseEvent) {
            this.mWnd.mTempMouseLocation.setLocation(mouseEvent.getPoint());
            if (this.pressFigures(mouseEvent)) {
                this.mWnd.repaintContentPane();
                return;
            }
            this.mWnd.clearAllFocusedObjectsInFigures();
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            int n = mouseEvent.getX();
            int n2 = mouseEvent.getY();
            ArrayList arrayList = this.mWnd.getVisibleFigureList();
            if (arrayList.size() == 0) {
                return;
            }
            boolean bl = this.mWnd.isInsertFlagSelected();
            if (bl) {
                Object var6_6 = null;
                for (int i = arrayList.size() - 1; i >= 0; --i) {
                    SGFigure sGFigure = (SGFigure)arrayList.get(i);
                    sGFigure.onMouseReleased(mouseEvent);
                    if (!this.mWnd.insertSymbol(sGFigure, n, n2)) continue;
                    this.mWnd.setDefaultCursor();
                    this.mWnd.setInsertToggleItemsUnselected();
                    return;
                }
                SGUtility.showErrorMessageDialog(this, ERRMSG_CLICK_GRAPH_RECTANGLE, DIALOG_TITLE_ADDITION_ERROR);
            } else {
                SGFigure sGFigure;
                int n3;
                for (int i = 0; i < arrayList.size(); ++i) {
                    SGFigure sGFigure2 = (SGFigure)arrayList.get(i);
                    sGFigure2.onMouseReleased(mouseEvent);
                }
                ArrayList arrayList2 = this.mWnd.getFocusedObjectsList();
                for (n3 = 0; n3 < arrayList2.size(); ++n3) {
                    sGFigure = (SGFigure)arrayList2.get(n3);
                    if (!sGFigure.isFigureMoved()) continue;
                    sGFigure.setChanged(true);
                }
                arrayList2 = this.mWnd.getVisibleFigureList();
                for (n3 = 0; n3 < arrayList2.size(); ++n3) {
                    sGFigure = (SGFigure)arrayList2.get(n3);
                    SGIFigureElement[] sGIFigureElementArray = sGFigure.getIFigureElementArray();
                    for (int i = sGIFigureElementArray.length - 1; i >= 0; --i) {
                        sGIFigureElementArray[i].setChangedFocusedObjects();
                    }
                }
                this.mWnd.updateClientRect();
                this.mWnd.repaintContentPane();
                this.mWnd.notifyToRoot();
            }
        }

        public void mouseEntered(MouseEvent mouseEvent) {
        }

        public void mouseExited(MouseEvent mouseEvent) {
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            if (this.mWnd.isInsertFlagSelected()) {
                return;
            }
            if (SwingUtilities.isRightMouseButton(mouseEvent)) {
                return;
            }
            this.mWnd.setPositionLabel(mouseEvent.getX(), mouseEvent.getY());
            ArrayList arrayList = this.mWnd.getVisibleFigureList();
            for (int i = arrayList.size() - 1; i >= 0; --i) {
                SGFigure sGFigure = (SGFigure)arrayList.get(i);
                if (!sGFigure.onMouseDragged(mouseEvent)) continue;
                this.mWnd.repaintContentPane();
                return;
            }
            this.mWnd.mTempMouseLocation.setLocation(mouseEvent.getPoint());
            this.mWnd.repaintContentPane();
        }

        public void mouseMoved(MouseEvent mouseEvent) {
            ArrayList arrayList = this.mWnd.getVisibleFigureList();
            for (int i = arrayList.size() - 1; i >= 0; --i) {
                SGFigure sGFigure = (SGFigure)arrayList.get(i);
                if (!sGFigure.onMouseMoved(mouseEvent)) continue;
                return;
            }
            this.mWnd.setPositionLabel(mouseEvent.getX(), mouseEvent.getY());
        }

        private boolean clickFigures(MouseEvent mouseEvent) {
            ArrayList arrayList = this.mWnd.getVisibleFigureList();
            for (int i = arrayList.size() - 1; i >= 0; --i) {
                SGFigure sGFigure = (SGFigure)arrayList.get(i);
                if (!sGFigure.onMouseClicked(mouseEvent)) continue;
                return true;
            }
            return false;
        }

        private boolean pressFigures(MouseEvent mouseEvent) {
            ArrayList arrayList = this.mWnd.getVisibleFigureList();
            for (int i = arrayList.size() - 1; i >= 0; --i) {
                SGFigure sGFigure = (SGFigure)arrayList.get(i);
                if (!sGFigure.onMousePressed(mouseEvent)) continue;
                return true;
            }
            return false;
        }
    }

    private static class ScrollBarsPanel
    extends InnerPanel
    implements AdjustmentListener {
        private JScrollBar mVScrollBar = null;
        private JScrollBar mHScrollBar = null;

        protected ScrollBarsPanel(SGDrawingWindow sGDrawingWindow) {
            super(sGDrawingWindow);
            this.setVisible(true);
            this.setOpaque(false);
            this.createScrollBars();
        }

        public void onMouseWheelMoved(int n) {
            int n2 = this.mVScrollBar.getValue() + n;
            this.mVScrollBar.setValue(n2);
        }

        private boolean createScrollBars() {
            this.mVScrollBar = new JScrollBar(1, 0, 100, 0, 100);
            this.mHScrollBar = new JScrollBar(0, 0, 100, 0, 100);
            this.mVScrollBar.setVisible(false);
            this.mHScrollBar.setVisible(false);
            this.setLayout(new BorderLayout());
            this.add((Component)this.mVScrollBar, "East");
            this.add((Component)this.mHScrollBar, "South");
            int n = this.mHScrollBar.getMinimum();
            int n2 = this.mHScrollBar.getMaximum();
            int n3 = this.mHScrollBar.getVisibleAmount();
            this.mHScrollBar.setValue((n2 - n3 - n) / 2);
            n = this.mVScrollBar.getMinimum();
            n2 = this.mVScrollBar.getMaximum();
            n3 = this.mVScrollBar.getVisibleAmount();
            this.mVScrollBar.setValue((n2 - n3 - n) / 2);
            this.mHScrollBar.addAdjustmentListener(this);
            this.mVScrollBar.addAdjustmentListener(this);
            return true;
        }

        public boolean setScrollRatio(double d, double d2) {
            int n = this.mVScrollBar.getMinimum();
            int n2 = this.mVScrollBar.getMaximum();
            int n3 = this.mVScrollBar.getVisibleAmount();
            int n4 = n2 - n - n3;
            double d3 = d * (double)n4;
            this.mVScrollBar.setValue((int)d3);
            int n5 = this.mHScrollBar.getMinimum();
            int n6 = this.mHScrollBar.getMaximum();
            int n7 = this.mHScrollBar.getVisibleAmount();
            int n8 = n6 - n5 - n7;
            double d4 = d2 * (double)n8;
            this.mHScrollBar.setValue((int)d4);
            return true;
        }

        protected boolean setEnableScrollBars(Rectangle2D rectangle2D, Rectangle2D rectangle2D2) {
            Rectangle rectangle = rectangle2D.getBounds();
            Rectangle rectangle2 = rectangle2D2.getBounds();
            boolean bl = SGUtilityNumber.contains(rectangle.x, rectangle.x + rectangle.width, rectangle2.x, rectangle2.x + rectangle2.width);
            boolean bl2 = SGUtilityNumber.contains(rectangle.y, rectangle.y + rectangle.height, rectangle2.y, rectangle2.y + rectangle2.height);
            this.mHScrollBar.setVisible(!bl);
            this.mVScrollBar.setVisible(!bl2);
            return true;
        }

        private boolean setScrollBarValue(Rectangle2D rectangle2D, Rectangle2D rectangle2D2) {
            if (this.mHScrollBar.isVisible()) {
                this.setScrollBarValue(true, rectangle2D, rectangle2D2);
            }
            if (this.mVScrollBar.isVisible()) {
                this.setScrollBarValue(false, rectangle2D, rectangle2D2);
            }
            return true;
        }

        private boolean setScrollBarValue(boolean bl, Rectangle2D rectangle2D, Rectangle2D rectangle2D2) {
            JScrollBar jScrollBar = null;
            float f = 0.0f;
            float f2 = 0.0f;
            float f3 = 0.0f;
            if (bl) {
                jScrollBar = this.mHScrollBar;
                f = (float)rectangle2D.getWidth();
                f2 = (float)rectangle2D.getX();
                f3 = (float)rectangle2D2.getWidth();
            } else {
                jScrollBar = this.mVScrollBar;
                f = (float)rectangle2D.getHeight();
                f2 = (float)rectangle2D.getY();
                f3 = (float)rectangle2D2.getHeight();
            }
            int n = jScrollBar.getMinimum();
            int n2 = jScrollBar.getMaximum();
            int n3 = (int)(f3 / f * (float)(n2 - n));
            jScrollBar.setVisibleAmount(n3);
            float f4 = -f2 / (f - f3);
            int n4 = n + (int)(f4 * (float)(n2 - n3 - n));
            jScrollBar.setValue(n4);
            jScrollBar.setBlockIncrement(n3);
            return true;
        }

        public SGTuple2f getScrollRatio() {
            int n;
            float f = 0.0f;
            float f2 = 0.0f;
            int n2 = this.mHScrollBar.getMinimum();
            int n3 = this.mHScrollBar.getMaximum();
            if (n3 - n2 - (n = this.mHScrollBar.getVisibleAmount()) != 0) {
                f = (float)this.mHScrollBar.getValue() / (float)(n3 - n2 - n);
            }
            n2 = this.mVScrollBar.getMinimum();
            n3 = this.mVScrollBar.getMaximum();
            if (n3 - n2 - (n = this.mVScrollBar.getVisibleAmount()) != 0) {
                f2 = (float)this.mVScrollBar.getValue() / (float)(n3 - n2 - n);
            }
            SGTuple2f sGTuple2f = new SGTuple2f(f, f2);
            return sGTuple2f;
        }

        private boolean setClientRectByValueOfScrollBar(boolean bl) {
            float f = 0.0f;
            SGTuple2f sGTuple2f = this.getScrollRatio();
            f = bl ? sGTuple2f.x : sGTuple2f.y;
            Rectangle2D rectangle2D = this.mWnd.getClientRect();
            Rectangle2D rectangle2D2 = this.mWnd.getViewportBounds();
            float f2 = (float)rectangle2D.getX();
            float f3 = (float)rectangle2D.getY();
            float f4 = (float)rectangle2D.getWidth();
            float f5 = (float)rectangle2D.getHeight();
            float f6 = (float)rectangle2D2.getWidth();
            float f7 = (float)rectangle2D2.getHeight();
            if (bl) {
                float f8 = f4 - f6;
                float f9 = -f * f8;
                this.mWnd.setClientRect(f9, f3, f4, f5);
            } else {
                float f10 = f5 - f7;
                float f11 = -f * f10;
                this.mWnd.setClientRect(f2, f11, f4, f5);
            }
            return true;
        }

        public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
            Object object = adjustmentEvent.getSource();
            if (object instanceof JScrollBar) {
                JScrollBar jScrollBar = (JScrollBar)object;
                if (this.mHScrollBar.equals(jScrollBar)) {
                    this.setClientRectByValueOfScrollBar(true);
                } else if (this.mVScrollBar.equals(jScrollBar)) {
                    this.setClientRectByValueOfScrollBar(false);
                }
                this.mWnd.updateGraphRectOfAllFigures();
                this.mWnd.repaintContentPane();
            }
        }
    }

    private static class ForegroundPanel
    extends InnerPanel {
        public static final float ANCHOR_SIZE = 6.0f;

        protected ForegroundPanel(SGDrawingWindow sGDrawingWindow) {
            super(sGDrawingWindow);
            this.setVisible(true);
            this.setOpaque(false);
        }

        public void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            Graphics2D graphics2D = (Graphics2D)graphics.create();
            ArrayList arrayList = this.mWnd.getFocusedObjectsList();
            for (int i = 0; i < arrayList.size(); ++i) {
                SGFigure sGFigure = (SGFigure)arrayList.get(i);
                if (!sGFigure.isSelectionSymbolsVisible()) continue;
                Rectangle2D rectangle2D = sGFigure.getRubberBandRect();
                if (SGFigure.mRubberBandFlag & SGFigure.mRubberBandVisibleFlag) {
                    this.drawRubberBand(graphics2D, rectangle2D.getBounds());
                }
                Rectangle2D rectangle2D2 = sGFigure.getGraphRect();
                int n = (int)rectangle2D2.getX();
                int n2 = (int)rectangle2D2.getY();
                int n3 = (int)rectangle2D2.getWidth();
                int n4 = (int)rectangle2D2.getHeight();
                this.drawAnchor(graphics2D, n, n2);
                this.drawAnchor(graphics2D, n + n3, n2);
                this.drawAnchor(graphics2D, n, n2 + n4);
                this.drawAnchor(graphics2D, n + n3, n2 + n4);
                this.drawAnchor(graphics2D, n + n3 / 2, n2);
                this.drawAnchor(graphics2D, n, n2 + n4 / 2);
                this.drawAnchor(graphics2D, n + n3 / 2, n2 + n4);
                this.drawAnchor(graphics2D, n + n3, n2 + n4 / 2);
            }
        }

        private void drawAnchor(Graphics2D graphics2D, int n, int n2) {
            Ellipse2D.Float float_ = new Ellipse2D.Float((float)n - 3.0f, (float)n2 - 3.0f, 6.0f, 6.0f);
            graphics2D.setPaint(Color.BLACK);
            graphics2D.setStroke(new BasicStroke(3.0f));
            graphics2D.draw(float_);
            graphics2D.setPaint(Color.WHITE);
            graphics2D.fill(float_);
        }

        private void drawRubberBand(Graphics2D graphics2D, Rectangle rectangle) {
            graphics2D.setPaint(Color.BLACK);
            float[] fArray = new float[]{4.0f, 2.0f};
            graphics2D.setStroke(new BasicStroke(2.0f, 0, 0, 10.0f, fArray, 0.0f));
            graphics2D.draw(rectangle);
        }
    }

    private static abstract class InnerPanel
    extends JPanel {
        protected float mMagnification = 1.0f;
        protected SGDrawingWindow mWnd = null;

        protected InnerPanel(SGDrawingWindow sGDrawingWindow) {
            this.mWnd = sGDrawingWindow;
        }

        public void setMagnification(float f) {
            this.mMagnification = f;
        }
    }
}

