/*
 * Decompiled with CFR 0.152.
 */
package jp.riken.brain.ni.samuraigraph.application;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.NoSuchElementException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jp.riken.brain.ni.samuraigraph.base.SGCSVTokenizer;
import jp.riken.brain.ni.samuraigraph.base.SGData;
import jp.riken.brain.ni.samuraigraph.base.SGUtilityText;
import jp.riken.brain.ni.samuraigraph.data.SGISXYTypeData;
import jp.riken.brain.ni.samuraigraph.data.SGIVXYTypeData;
import jp.riken.brain.ni.samuraigraph.data.SGSXYData;
import jp.riken.brain.ni.samuraigraph.data.SGSXYDateData;
import jp.riken.brain.ni.samuraigraph.data.SGSXYMultipleData;
import jp.riken.brain.ni.samuraigraph.data.SGSXYSamplingData;
import jp.riken.brain.ni.samuraigraph.data.SGVXYData;

public class SGDataCreator {
    public SGData create(String string, ArrayList arrayList) throws FileNotFoundException {
        if (string == null || arrayList == null) {
            throw new NullPointerException("path==null || infoList==null");
        }
        if (arrayList.size() == 0) {
            return null;
        }
        SGData sGData = null;
        String string2 = (String)arrayList.get(0);
        if (string2.equals("SXY")) {
            sGData = (SGData)((Object)this.createSXYData(string));
        } else if (string2.equals("SXY_DATE")) {
            sGData = (SGData)((Object)this.createSXYDateData(string));
        } else if (string2.equals("VXY")) {
            if (arrayList.size() <= 1) {
                return null;
            }
            Object e = arrayList.get(1);
            if (!(e instanceof Boolean)) {
                return null;
            }
            Boolean bl = (Boolean)e;
            sGData = (SGData)((Object)this.createVXYData(string, bl));
        } else if (string2.equals("SXY_MULTIPLE")) {
            sGData = this.createSXYMultipleData(string);
        } else if (string2.equals("SXY_SAMPLING")) {
            if (arrayList.size() <= 1) {
                return null;
            }
            Object e = arrayList.get(1);
            if (!(e instanceof Number)) {
                return null;
            }
            Number number = (Number)e;
            sGData = this.createSXYSamplingData(string, number.doubleValue());
        }
        return sGData;
    }

    private static ArrayList getSXYTextColumnIndexList(int n) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (int i = 0; i < n; ++i) {
            if (n == 3 && i == 2 || n == 5 && i == 4) {
                arrayList.add(new Integer(0));
                continue;
            }
            arrayList.add(new Integer(1));
        }
        return arrayList;
    }

    private static ArrayList getVXYTextColumnIndexList(int n) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (int i = 0; i < n; ++i) {
            arrayList.add(new Integer(1));
        }
        return arrayList;
    }

    private static ArrayList getSXYMultipleTextColumnIndexList(int n) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (int i = 0; i < n; ++i) {
            arrayList.add(new Integer(1));
        }
        return arrayList;
    }

    private static ArrayList getSXYDateTextColumnIndexList(int n) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (int i = 0; i < n; ++i) {
            if (i == 0 || n == 3 && i == 2 || n == 5 && i == 4) {
                arrayList.add(new Integer(0));
                continue;
            }
            arrayList.add(new Integer(1));
        }
        return arrayList;
    }

    private SGISXYTypeData createSXYData(String string) throws FileNotFoundException {
        int n = this.getColumnNumber(string);
        if (n == -1) {
            return null;
        }
        if (n < 2) {
            return null;
        }
        ArrayList arrayList = SGDataCreator.getSXYTextColumnIndexList(n);
        ArrayList[] arrayListArray = this.createListArray(string, n, arrayList);
        if (arrayListArray == null) {
            return null;
        }
        int n2 = arrayListArray[0].size();
        for (int i = 1; i < arrayListArray.length; ++i) {
            if (arrayListArray[i].size() == n2) continue;
            return null;
        }
        ArrayList arrayList2 = new ArrayList();
        if (!this.getFileTypeCandidateList(string, arrayList2)) {
            return null;
        }
        SGSXYData sGSXYData = null;
        String string2 = null;
        Double d = null;
        double[] dArray = new double[n2];
        double[] dArray2 = new double[n2];
        for (int i = 0; i < n2; ++i) {
            string2 = (String)arrayListArray[0].get(i);
            d = SGUtilityText.getDouble(string2);
            if (d == null) {
                return null;
            }
            dArray[i] = d;
            string2 = (String)arrayListArray[1].get(i);
            d = SGUtilityText.getDouble(string2);
            if (d == null) {
                return null;
            }
            dArray2[i] = d;
        }
        double[] dArray3 = null;
        double[] dArray4 = null;
        String[] stringArray = null;
        switch (n) {
            case 2: {
                break;
            }
            case 4: {
                dArray3 = new double[n2];
                dArray4 = new double[n2];
                for (int i = 0; i < n2; ++i) {
                    string2 = (String)arrayListArray[2].get(i);
                    d = SGUtilityText.getDouble(string2);
                    if (d == null) {
                        return null;
                    }
                    dArray3[i] = d;
                    string2 = (String)arrayListArray[3].get(i);
                    d = SGUtilityText.getDouble(string2);
                    if (d == null) {
                        return null;
                    }
                    dArray4[i] = d;
                }
                break;
            }
            case 3: {
                stringArray = new String[n2];
                for (int i = 0; i < n2; ++i) {
                    stringArray[i] = (String)arrayListArray[2].get(i);
                }
                break;
            }
            case 5: {
                dArray3 = new double[n2];
                dArray4 = new double[n2];
                stringArray = new String[n2];
                for (int i = 0; i < n2; ++i) {
                    string2 = (String)arrayListArray[2].get(i);
                    d = SGUtilityText.getDouble(string2);
                    if (d == null) {
                        return null;
                    }
                    dArray3[i] = d;
                    string2 = (String)arrayListArray[3].get(i);
                    d = SGUtilityText.getDouble(string2);
                    if (d == null) {
                        return null;
                    }
                    dArray4[i] = d;
                    stringArray[i] = (String)arrayListArray[4].get(i);
                }
                break;
            }
        }
        sGSXYData = new SGSXYData(dArray, dArray2, dArray3, dArray4, stringArray);
        return sGSXYData;
    }

    private SGISXYTypeData createSXYDateData(String string) throws FileNotFoundException {
        int n = this.getColumnNumber(string);
        if (n == -1) {
            return null;
        }
        if (n < 2) {
            return null;
        }
        ArrayList arrayList = SGDataCreator.getSXYDateTextColumnIndexList(n);
        ArrayList[] arrayListArray = this.createListArray(string, n, arrayList);
        if (arrayListArray == null) {
            return null;
        }
        int n2 = arrayListArray[0].size();
        for (int i = 1; i < arrayListArray.length; ++i) {
            if (arrayListArray[i].size() == n2) continue;
            return null;
        }
        ArrayList arrayList2 = new ArrayList();
        if (!this.getFileTypeCandidateList(string, arrayList2)) {
            return null;
        }
        SGSXYDateData sGSXYDateData = null;
        String string2 = null;
        Double d = null;
        String[] stringArray = new String[n2];
        for (int i = 0; i < n2; ++i) {
            stringArray[i] = (String)arrayListArray[0].get(i);
        }
        double[] dArray = new double[n2];
        for (int i = 0; i < n2; ++i) {
            string2 = (String)arrayListArray[1].get(i);
            d = SGUtilityText.getDouble(string2);
            if (d == null) {
                return null;
            }
            dArray[i] = d;
        }
        double[] dArray2 = null;
        double[] dArray3 = null;
        if (n == 4 | n == 5) {
            dArray2 = new double[n2];
            dArray3 = new double[n2];
            for (int i = 0; i < n2; ++i) {
                string2 = (String)arrayListArray[2].get(i);
                d = SGUtilityText.getDouble(string2);
                if (d == null) {
                    return null;
                }
                dArray2[i] = d;
                string2 = (String)arrayListArray[3].get(i);
                d = SGUtilityText.getDouble(string2);
                if (d == null) {
                    return null;
                }
                dArray3[i] = d;
            }
        }
        String[] stringArray2 = null;
        int n3 = -1;
        if (n == 3) {
            n3 = 2;
        } else if (n == 5) {
            n3 = 4;
        }
        if (n3 != -1) {
            stringArray2 = new String[n2];
            for (int i = 0; i < n2; ++i) {
                string2 = (String)arrayListArray[n3].get(i);
                stringArray2[i] = new String(string2);
            }
        }
        try {
            sGSXYDateData = new SGSXYDateData(stringArray, dArray, dArray2, dArray3, stringArray2);
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        return sGSXYDateData;
    }

    private SGSXYMultipleData createSXYMultipleData(String string) throws FileNotFoundException {
        int n = this.getColumnNumber(string);
        if (n == -1) {
            return null;
        }
        if (n < 2) {
            return null;
        }
        ArrayList arrayList = SGDataCreator.getSXYMultipleTextColumnIndexList(n);
        ArrayList[] arrayListArray = this.createListArray(string, n, arrayList);
        if (arrayListArray == null) {
            return null;
        }
        int n2 = arrayListArray[0].size();
        for (int i = 1; i < arrayListArray.length; ++i) {
            if (arrayListArray[i].size() == n2) continue;
            return null;
        }
        SGSXYMultipleData sGSXYMultipleData = null;
        double[] dArray = new double[n2];
        for (int i = 0; i < n2; ++i) {
            String string2 = (String)arrayListArray[0].get(i);
            Double d = SGUtilityText.getDouble(string2);
            if (d == null) {
                return null;
            }
            dArray[i] = d;
        }
        double[][] dArrayArray = new double[n - 1][];
        for (int i = 0; i < n - 1; ++i) {
            dArrayArray[i] = new double[n2];
            for (int j = 0; j < n2; ++j) {
                String string3 = (String)arrayListArray[i + 1].get(j);
                Double d = SGUtilityText.getDouble(string3);
                if (d == null) {
                    return null;
                }
                dArrayArray[i][j] = d;
            }
        }
        sGSXYMultipleData = new SGSXYMultipleData(dArray, dArrayArray);
        return sGSXYMultipleData;
    }

    private SGSXYMultipleData createSXYSamplingData(String string, double d) throws FileNotFoundException {
        int n = this.getColumnNumber(string);
        if (n == -1) {
            return null;
        }
        if (n < 1) {
            return null;
        }
        ArrayList arrayList = SGDataCreator.getSXYMultipleTextColumnIndexList(n);
        ArrayList[] arrayListArray = this.createListArray(string, n, arrayList);
        if (arrayListArray == null) {
            return null;
        }
        int n2 = arrayListArray[0].size();
        for (int i = 1; i < arrayListArray.length; ++i) {
            if (arrayListArray[i].size() == n2) continue;
            return null;
        }
        SGSXYSamplingData sGSXYSamplingData = null;
        Double d2 = null;
        String string2 = null;
        double[][] dArrayArray = new double[n][];
        for (int i = 0; i < n; ++i) {
            dArrayArray[i] = new double[n2];
            for (int j = 0; j < n2; ++j) {
                string2 = (String)arrayListArray[i].get(j);
                d2 = SGUtilityText.getDouble(string2);
                if (d2 == null) {
                    return null;
                }
                dArrayArray[i][j] = d2;
            }
        }
        sGSXYSamplingData = new SGSXYSamplingData(d, (double[][])dArrayArray);
        return sGSXYSamplingData;
    }

    private SGIVXYTypeData createVXYData(String string, boolean bl) throws FileNotFoundException {
        int n;
        int n2 = this.getColumnNumber(string);
        if (n2 == -1) {
            return null;
        }
        if (n2 < 4) {
            return null;
        }
        ArrayList arrayList = SGDataCreator.getVXYTextColumnIndexList(n2);
        ArrayList[] arrayListArray = this.createListArray(string, n2, arrayList);
        if (arrayListArray == null) {
            return null;
        }
        int n3 = arrayListArray[0].size();
        for (int i = 1; i < arrayListArray.length; ++i) {
            if (arrayListArray[i].size() == n3) continue;
            return null;
        }
        ArrayList arrayList2 = new ArrayList();
        if (!this.getFileTypeCandidateList(string, arrayList2)) {
            return null;
        }
        SGVXYData sGVXYData = null;
        String string2 = null;
        Double d = null;
        double[] dArray = new double[n3];
        double[] dArray2 = new double[n3];
        double[] dArray3 = new double[n3];
        double[] dArray4 = new double[n3];
        for (n = 0; n < n3; ++n) {
            string2 = (String)arrayListArray[0].get(n);
            d = SGUtilityText.getDouble(string2);
            if (d == null) {
                return null;
            }
            dArray[n] = d;
            string2 = (String)arrayListArray[1].get(n);
            d = SGUtilityText.getDouble(string2);
            if (d == null) {
                return null;
            }
            dArray2[n] = d;
        }
        for (n = 0; n < n3; ++n) {
            string2 = (String)arrayListArray[2].get(n);
            d = SGUtilityText.getDouble(string2);
            if (d == null) {
                return null;
            }
            if (bl && d < 0.0) {
                return null;
            }
            dArray3[n] = d;
            string2 = (String)arrayListArray[3].get(n);
            d = SGUtilityText.getDouble(string2);
            if (d == null) {
                return null;
            }
            dArray4[n] = d;
        }
        sGVXYData = new SGVXYData(dArray, dArray2, dArray3, dArray4, bl);
        return sGVXYData;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int getColumnNumber(String string) throws FileNotFoundException {
        int n = -1;
        BufferedReader bufferedReader = null;
        try {
            bufferedReader = new BufferedReader(new FileReader(string));
            ArrayList arrayList = this.getFirstTokenList(bufferedReader);
            n = arrayList.size();
            Object var6_6 = null;
            if (bufferedReader == null) return n;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            if (bufferedReader == null) throw throwable;
            try {
                bufferedReader.close();
                throw throwable;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (IOException iOException) {}
        bufferedReader.close();
        return n;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ArrayList[] createListArray(String var1_1, int var2_2, ArrayList var3_3) throws FileNotFoundException {
        block20: {
            block19: {
                block18: {
                    block17: {
                        var4_4 = new ArrayList[var2_2];
                        for (var5_5 = 0; var5_5 < var4_4.length; ++var5_5) {
                            var4_4[var5_5] = new ArrayList<E>();
                        }
                        var5_6 = null;
                        try {
                            var5_6 = new BufferedReader(new FileReader(var1_1));
                            while ((var6_7 = SGUtilityText.readLine(var5_6)) != null) {
                                var7_9 = new ArrayList<E>();
                                if (!SGUtilityText.tokenize(var6_7, var7_9)) {
                                    var8_10 = null;
                                    var13_14 = null;
                                    if (var5_6 == null) return var8_10;
                                    break block17;
                                }
                                if (var7_9.size() != var2_2) {
                                    if (var7_9.size() == 0) continue;
                                    var8_10 = null;
                                    break block18;
                                }
                                var8_10 = SGDataCreator.getColumnIndexListOfNumber(var7_9);
                                if (!this.machesNumberColumnIndex(var3_3, var8_10)) {
                                    var9_11 = null;
                                    break block19;
                                }
                                var9_11 = new String[var2_2];
                                for (var10_12 = 0; var10_12 < var2_2; ++var10_12) {
                                    var11_13 = (String)var7_9.get(var10_12);
                                    var4_4[var10_12].add(var11_13);
                                }
                            }
                            break block20;
                        }
                        catch (Throwable var12_24) {
                            var13_18 = null;
                            if (var5_6 == null) throw var12_24;
                            try {
                                var5_6.close();
                                throw var12_24;
                            }
                            catch (IOException var14_23) {
                                // empty catch block
                            }
                            throw var12_24;
                        }
                    }
                    ** try [egrp 2[TRYBLOCK] [9 : 220->228)] { 
lbl49:
                    // 1 sources

                    var5_6.close();
                    return var8_10;
lbl51:
                    // 1 sources

                    catch (IOException var14_19) {
                        // empty catch block
                    }
                    return var8_10;
                }
                var13_15 = null;
                if (var5_6 == null) return var8_10;
                ** try [egrp 2[TRYBLOCK] [9 : 220->228)] { 
lbl58:
                // 1 sources

                var5_6.close();
                return var8_10;
lbl60:
                // 1 sources

                catch (IOException var14_20) {
                    // empty catch block
                }
                return var8_10;
            }
            var13_16 = null;
            if (var5_6 == null) return var9_11;
            ** try [egrp 2[TRYBLOCK] [9 : 220->228)] { 
lbl67:
            // 1 sources

            var5_6.close();
            return var9_11;
lbl69:
            // 1 sources

            catch (IOException var14_21) {
                // empty catch block
            }
            return var9_11;
        }
        var13_17 = null;
        if (var5_6 == null) return var4_4;
        try {}
        catch (IOException var14_22) {}
        var5_6.close();
        return var4_4;
        return var4_4;
    }

    private boolean machesNumberColumnIndex(ArrayList arrayList, ArrayList arrayList2) {
        if (arrayList.size() != arrayList2.size()) {
            return false;
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            Integer n = (Integer)arrayList.get(i);
            Integer n2 = (Integer)arrayList2.get(i);
            if (n != 1 || n2 != 0) continue;
            return false;
        }
        return true;
    }

    public static void main(String[] stringArray) throws Exception {
        System.out.println("start");
        String string = "D:\\Tmp\\test.txt";
        ArrayList<Object> arrayList = new ArrayList<Object>();
        arrayList.add("VXY");
        arrayList.add(Boolean.FALSE);
        SGDataCreator sGDataCreator = new SGDataCreator();
        SGData sGData = sGDataCreator.create(string, arrayList);
        System.out.println(sGData);
        System.out.println("end");
    }

    private static ArrayList getColumnIndexListOfNumber(ArrayList arrayList) {
        ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
        Pattern pattern = Pattern.compile("^[+-]?[0-9]+(\\.[0-9]*)?([eE][+-]?[0-9]+)?$");
        for (int i = 0; i < arrayList.size(); ++i) {
            String string = (String)arrayList.get(i);
            Matcher matcher = pattern.matcher(string);
            if (matcher.matches()) {
                arrayList2.add(new Integer(1));
                continue;
            }
            arrayList2.add(new Integer(0));
        }
        return arrayList2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean getFileTypeCandidateList(String string, ArrayList arrayList) throws FileNotFoundException {
        BufferedReader bufferedReader = null;
        try {
            ArrayList arrayList2;
            bufferedReader = new BufferedReader(new FileReader(string));
            ArrayList arrayList3 = this.getFirstTokenList(bufferedReader);
            int n = arrayList3.size();
            HashSet<String> hashSet = new HashSet<String>();
            ArrayList arrayList4 = SGDataCreator.getColumnIndexListOfNumber(arrayList3);
            if (this.evaluateDataTypeSXY(arrayList3) && this.machesNumberColumnIndex(arrayList2 = SGDataCreator.getSXYTextColumnIndexList(n), arrayList4)) {
                hashSet.add("SXY");
            }
            if (this.evaluateDataTypeVXY(arrayList3) && this.machesNumberColumnIndex(arrayList2 = SGDataCreator.getVXYTextColumnIndexList(n), arrayList4)) {
                hashSet.add("VXY");
            }
            if (this.evaluateDataTypeSXYMultiple(arrayList3) && this.machesNumberColumnIndex(arrayList2 = SGDataCreator.getSXYMultipleTextColumnIndexList(n), arrayList4)) {
                if (n >= 3) {
                    hashSet.add("SXY_MULTIPLE");
                }
                if (n >= 1) {
                    hashSet.add("SXY_SAMPLING");
                }
            }
            if (this.evaluateDataTypeSXYDate(arrayList3) && this.machesNumberColumnIndex(arrayList2 = SGDataCreator.getSXYDateTextColumnIndexList(n), arrayList4)) {
                hashSet.add("SXY_DATE");
            }
            arrayList.addAll(hashSet);
            Object var10_10 = null;
            if (bufferedReader == null) return true;
        }
        catch (Throwable throwable) {
            Object var10_11 = null;
            if (bufferedReader == null) throw throwable;
            try {
                bufferedReader.close();
                throw throwable;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (IOException iOException) {}
        bufferedReader.close();
        return true;
    }

    private boolean evaluateDataTypeSXY(ArrayList arrayList) {
        int n;
        int n2 = arrayList.size();
        ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
        if (n2 == 2 | n2 == 4) {
            for (n = 0; n < n2; ++n) {
                arrayList2.add(new Integer(n));
            }
        } else if (n2 == 3) {
            arrayList2.add(new Integer(0));
            arrayList2.add(new Integer(1));
        } else if (n2 == 5) {
            for (n = 0; n < 4; ++n) {
                arrayList2.add(new Integer(n));
            }
        } else {
            return false;
        }
        n = 1;
        for (int i = 0; i < arrayList2.size(); ++i) {
            int n3 = (Integer)arrayList2.get(i);
            String string = (String)arrayList.get(n3);
            Double d = SGUtilityText.getDouble(string);
            if (d != null) continue;
            n = 0;
            break;
        }
        return n != 0;
    }

    private boolean evaluateDataTypeVXY(ArrayList arrayList) {
        boolean bl = true;
        int n = arrayList.size();
        if (n != 4) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            String string = (String)arrayList.get(i);
            Double d = SGUtilityText.getDouble(string);
            if (d != null) continue;
            bl = false;
            break;
        }
        return bl;
    }

    private boolean evaluateDataTypeSXYMultiple(ArrayList arrayList) {
        boolean bl = true;
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            String string = (String)arrayList.get(i);
            Double d = SGUtilityText.getDouble(string);
            if (d != null) continue;
            bl = false;
            break;
        }
        return bl;
    }

    private boolean evaluateDataTypeSXYDate(ArrayList arrayList) {
        Object object;
        int n = arrayList.size();
        if (n != 2 & n != 3 & n != 4 & n != 5) {
            return false;
        }
        ArrayList arrayList2 = new ArrayList();
        arrayList2.add(arrayList.get(0));
        DateFormat dateFormat = DateFormat.getDateInstance();
        for (int i = 0; i < arrayList2.size(); ++i) {
            String string = (String)arrayList2.get(i);
            object = SGUtilityText.getDate(string);
            if (object != null) continue;
            return false;
        }
        ArrayList arrayList3 = new ArrayList();
        arrayList3.add(arrayList.get(1));
        if (n == 4 | n == 5) {
            arrayList3.add(arrayList.get(1));
            arrayList3.add(arrayList.get(2));
            arrayList3.add(arrayList.get(3));
        }
        for (int i = 0; i < arrayList3.size(); ++i) {
            object = (String)arrayList3.get(i);
            Double d = SGUtilityText.getDouble((String)object);
            if (d != null) continue;
            return false;
        }
        return true;
    }

    private ArrayList getFirstTokenList(BufferedReader bufferedReader) {
        String string;
        ArrayList<String> arrayList = new ArrayList<String>();
        while ((string = SGUtilityText.readLine(bufferedReader)) != null) {
            arrayList.clear();
            SGCSVTokenizer sGCSVTokenizer = new SGCSVTokenizer(string);
            while (sGCSVTokenizer.hasMoreTokens()) {
                try {
                    String string2 = sGCSVTokenizer.nextToken();
                    arrayList.add(string2);
                }
                catch (NoSuchElementException noSuchElementException) {}
            }
            int n = arrayList.size();
            if (n == 0) continue;
            break;
        }
        return arrayList;
    }
}

