/*
 * Decompiled with CFR 0.152.
 */
package jp.riken.brain.ni.samuraigraph.application;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipOutputStream;
import javax.swing.JFileChooser;
import jp.riken.brain.ni.samuraigraph.application.SGIArchiveFileConstants;
import jp.riken.brain.ni.samuraigraph.base.SGDrawingWindow;
import jp.riken.brain.ni.samuraigraph.base.SGExtensionFileFilter;
import jp.riken.brain.ni.samuraigraph.base.SGFileChooser;
import jp.riken.brain.ni.samuraigraph.base.SGIConstants;

public class SGArchiveFileCreator
implements SGIConstants,
SGIArchiveFileConstants {
    protected static final int EOF = -1;
    private JFileChooser mFileChooser;

    public SGArchiveFileCreator() {
        this.init();
    }

    private void init() {
        SGFileChooser sGFileChooser = new SGFileChooser();
        this.mFileChooser = sGFileChooser;
        SGExtensionFileFilter sGExtensionFileFilter = new SGExtensionFileFilter();
        sGExtensionFileFilter.setDescription("Samurai Graph Archive File");
        sGExtensionFileFilter.addExtension("sga");
        sGFileChooser.setFileFilter(sGExtensionFileFilter);
        String string = SGIConstants.USER_HOME;
        String string2 = "My Documents";
        File file = new File(string);
        String[] stringArray = file.list();
        if (stringArray == null) {
            throw new Error();
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].endsWith(string2)) continue;
            string = string + SGIConstants.FILE_SEPARATOR + string2;
            break;
        }
        String string3 = string + SGIConstants.FILE_SEPARATOR + "dataset" + "." + "sga";
        ((JFileChooser)sGFileChooser).setSelectedFile(new File(string3));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int create(SGDrawingWindow sGDrawingWindow, String string, File file) {
        int n;
        ArrayList arrayList = SGArchiveFileCreator.getTargetFileList(string);
        if (arrayList.size() == 0) {
            return -2;
        }
        ZipOutputStream zipOutputStream = null;
        try {
            try {
                zipOutputStream = new ZipOutputStream(new FileOutputStream(file));
                n = this.create(sGDrawingWindow, string, arrayList, zipOutputStream);
                Object var9_8 = null;
                if (zipOutputStream == null) return n;
            }
            catch (Exception exception) {
                int n2 = -1;
                Object var9_9 = null;
                if (zipOutputStream == null) return n2;
                try {
                    zipOutputStream.close();
                    return n2;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                return n2;
            }
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            if (zipOutputStream == null) throw throwable;
            try {}
            catch (IOException iOException) {
                throw throwable;
            }
            zipOutputStream.close();
            throw throwable;
        }
        try {}
        catch (IOException iOException) {
            // empty catch block
            return n;
        }
        zipOutputStream.close();
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int create(SGDrawingWindow sGDrawingWindow, String string, String string2) {
        int n;
        ArrayList arrayList = SGArchiveFileCreator.getTargetFileList(string);
        if (arrayList.size() == 0) {
            return -2;
        }
        ZipOutputStream zipOutputStream = null;
        try {
            try {
                zipOutputStream = new ZipOutputStream(new FileOutputStream(string2));
                n = this.create(sGDrawingWindow, string, arrayList, zipOutputStream);
                Object var9_8 = null;
                if (zipOutputStream == null) return n;
            }
            catch (Exception exception) {
                int n2 = -1;
                Object var9_9 = null;
                if (zipOutputStream == null) return n2;
                try {
                    zipOutputStream.close();
                    return n2;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                return n2;
            }
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            if (zipOutputStream == null) throw throwable;
            try {}
            catch (IOException iOException) {
                throw throwable;
            }
            zipOutputStream.close();
            throw throwable;
        }
        try {}
        catch (IOException iOException) {
            // empty catch block
            return n;
        }
        zipOutputStream.close();
        return n;
    }

    private int create(SGDrawingWindow sGDrawingWindow, String string, ArrayList arrayList, ZipOutputStream zipOutputStream) {
        File file = new File(string);
        if (!file.isDirectory()) {
            return -1;
        }
        String string2 = file.getAbsolutePath() + File.separator;
        try {
            for (int i = 0; i < arrayList.size(); ++i) {
                File file2 = (File)arrayList.get(i);
                String string3 = file2.getAbsolutePath();
                if (!string3.startsWith(string2)) continue;
                String string4 = string3.substring(string2.length());
                if (!file2.isFile()) continue;
                SGArchiveFileCreator.addTargetFile(zipOutputStream, file2, string4);
            }
            zipOutputStream.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
            return -1;
        }
        catch (ZipException zipException) {
            zipException.printStackTrace();
            return -1;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return -1;
        }
        return 0;
    }

    public int create(SGDrawingWindow sGDrawingWindow, String string) {
        File file = this.getArchiveFileFromFileChooser(sGDrawingWindow);
        if (file == null) {
            return 1;
        }
        return this.create(sGDrawingWindow, string, file);
    }

    private File getArchiveFileFromFileChooser(SGDrawingWindow sGDrawingWindow) {
        JFileChooser jFileChooser = this.mFileChooser;
        int n = jFileChooser.showSaveDialog(sGDrawingWindow);
        File file = null;
        if (n == 0) {
            file = jFileChooser.getSelectedFile();
        }
        return file;
    }

    public File getSelectedFile() {
        if (this.mFileChooser == null) {
            return null;
        }
        return this.mFileChooser.getSelectedFile();
    }

    public File setFile(String string, String string2) {
        if (string2 == null) {
            string2 = "";
        }
        this.mFileChooser.setCurrentDirectory(new File(string));
        String string3 = string + SGIConstants.FILE_SEPARATOR + string2;
        File file = new File(string3);
        this.mFileChooser.setSelectedFile(file);
        return file;
    }

    private static ArrayList getTargetFileList(String string) {
        ArrayList<File> arrayList = new ArrayList<File>();
        File file = new File(string);
        if (!file.isDirectory()) {
            return arrayList;
        }
        File[] fileArray = file.listFiles();
        for (int i = 0; i < fileArray.length; ++i) {
            if (fileArray[i].isFile()) {
                arrayList.add(fileArray[i]);
                continue;
            }
            if (!fileArray[i].isDirectory()) continue;
            ArrayList arrayList2 = SGArchiveFileCreator.getTargetFileList(string + File.separator + fileArray[i].getName());
            arrayList.addAll(arrayList2);
        }
        return arrayList;
    }

    private static void addTargetFile(ZipOutputStream zipOutputStream, File file, String string) throws FileNotFoundException, ZipException, IOException {
        try {
            int n;
            BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
            ZipEntry zipEntry = new ZipEntry(string);
            zipOutputStream.putNextEntry(zipEntry);
            byte[] byArray = new byte[1024];
            while ((n = bufferedInputStream.read(byArray, 0, 1024)) != -1) {
                zipOutputStream.write(byArray, 0, n);
            }
            bufferedInputStream.close();
            zipOutputStream.closeEntry();
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw fileNotFoundException;
        }
        catch (ZipException zipException) {
            throw zipException;
        }
        catch (IOException iOException) {
            throw iOException;
        }
    }
}

