/*
 * TLDialog.java
 *
 * Created on 2005/05/09, 16:11
 */

package jp.riken.brain.ni.samuraigraph.figure.java2d;

import java.awt.Color;
import java.util.ArrayList;

import jp.riken.brain.ni.samuraigraph.base.SGIPropertyDialogObserver;
import jp.riken.brain.ni.samuraigraph.base.SGPropertyDialog;
import jp.riken.brain.ni.samuraigraph.base.SGUtilityText;
import jp.riken.brain.ni.samuraigraph.figure.SGDrawingElementLine;

/**
 *
 * @author  kuromaru
 */
public class SGTimingLineDialog extends SGPropertyDialog
{
    
	/**
	 * 
	 */
	public static final String TITLE = "Timing Line Properties";


    /** Creates new form SGTimingLineDialog */
    public SGTimingLineDialog(java.awt.Frame parent, boolean modal)
    {
        super(parent, modal);
        initComponents();
        this.initProperty();
		this.initialize();
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    private void initComponents() {//GEN-BEGIN:initComponents
        java.awt.GridBagConstraints gridBagConstraints;

        mStartValueLabel = new javax.swing.JLabel();
        mStartValueTextField = new jp.riken.brain.ni.samuraigraph.base.SGTextField();
        mEndValueLabel = new javax.swing.JLabel();
        mEndValueTextField = new jp.riken.brain.ni.samuraigraph.base.SGTextField();
        mAxisPanel = new jp.riken.brain.ni.samuraigraph.base.SGSingleAxisSelectionPanel();
        mButtonPanel = new javax.swing.JPanel();
        mOKButton = new javax.swing.JButton();
        mCancelButton = new javax.swing.JButton();
        mPreviewButton = new javax.swing.JButton();
        mTimingLinePanel = new javax.swing.JPanel();
        mTimingValueLabel = new javax.swing.JLabel();
        mLineTypeLabel = new javax.swing.JLabel();
        mLineWidthLabel = new javax.swing.JLabel();
        mColorLabel = new javax.swing.JLabel();
        mTimingValueTextField = new jp.riken.brain.ni.samuraigraph.base.SGTextField();
        mLineWidthSpinner = new jp.riken.brain.ni.samuraigraph.base.SGSpinner();
        mLineColorButton = new jp.riken.brain.ni.samuraigraph.base.SGColorSelectionButton();
        mLineTypeComboBox = new javax.swing.JComboBox();
        mRightSpaceLabel = new javax.swing.JLabel();
        mLeftSpaceLabel = new javax.swing.JLabel();

        mStartValueLabel.setFont(new java.awt.Font("Dialog", 0, 12));
        mStartValueLabel.setText("Start");
        mStartValueTextField.setColumns(6);
        mStartValueTextField.setFont(new java.awt.Font("Dialog", 0, 12));
        mEndValueLabel.setFont(new java.awt.Font("Dialog", 0, 12));
        mEndValueLabel.setText("End");
        mEndValueTextField.setColumns(6);
        mEndValueTextField.setFont(new java.awt.Font("Dialog", 0, 12));

        getContentPane().setLayout(new java.awt.GridBagLayout());

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(0, 0, 5, 0);
        getContentPane().add(mAxisPanel, gridBagConstraints);

        mOKButton.setFont(new java.awt.Font("Dialog", 1, 12));
        mOKButton.setText("OK");
        mButtonPanel.add(mOKButton);

        mCancelButton.setFont(new java.awt.Font("Dialog", 1, 12));
        mCancelButton.setText("Cancel");
        mButtonPanel.add(mCancelButton);

        mPreviewButton.setFont(new java.awt.Font("Dialog", 1, 12));
        mPreviewButton.setText("Preview");
        mButtonPanel.add(mPreviewButton);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        getContentPane().add(mButtonPanel, gridBagConstraints);

        mTimingLinePanel.setLayout(new java.awt.GridBagLayout());

        mTimingLinePanel.setBorder(new javax.swing.border.BevelBorder(javax.swing.border.BevelBorder.RAISED));
        mTimingLinePanel.setFont(new java.awt.Font("MS Sans Serif", 0, 10));
        mTimingValueLabel.setFont(new java.awt.Font("Dialog", 0, 12));
        mTimingValueLabel.setText("Value");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(10, 5, 5, 5);
        mTimingLinePanel.add(mTimingValueLabel, gridBagConstraints);

        mLineTypeLabel.setFont(new java.awt.Font("Dialog", 0, 12));
        mLineTypeLabel.setText("Type");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        gridBagConstraints.insets = new java.awt.Insets(10, 20, 5, 5);
        mTimingLinePanel.add(mLineTypeLabel, gridBagConstraints);

        mLineWidthLabel.setFont(new java.awt.Font("Dialog", 0, 12));
        mLineWidthLabel.setText("Width");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 10, 5);
        mTimingLinePanel.add(mLineWidthLabel, gridBagConstraints);

        mColorLabel.setFont(new java.awt.Font("Dialog", 0, 12));
        mColorLabel.setText("Color");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        gridBagConstraints.insets = new java.awt.Insets(5, 20, 10, 5);
        mTimingLinePanel.add(mColorLabel, gridBagConstraints);

        mTimingValueTextField.setColumns(6);
        mTimingValueTextField.setFont(new java.awt.Font("Dialog", 0, 12));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(10, 5, 5, 5);
        mTimingLinePanel.add(mTimingValueTextField, gridBagConstraints);

        mLineWidthSpinner.setFont(new java.awt.Font("Dialog", 0, 12));
        mLineWidthSpinner.setPreferredSize(new java.awt.Dimension(70, 22));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 10, 5);
        mTimingLinePanel.add(mLineWidthSpinner, gridBagConstraints);

        mLineColorButton.setPreferredSize(new java.awt.Dimension(65, 20));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 10, 5);
        mTimingLinePanel.add(mLineColorButton, gridBagConstraints);

        mLineTypeComboBox.setFont(new java.awt.Font("Dialog", 0, 12));
        mLineTypeComboBox.setPreferredSize(new java.awt.Dimension(140, 22));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(10, 5, 5, 5);
        mTimingLinePanel.add(mLineTypeComboBox, gridBagConstraints);

        mRightSpaceLabel.setText("    ");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new java.awt.Insets(10, 0, 0, 0);
        mTimingLinePanel.add(mRightSpaceLabel, gridBagConstraints);

        mLeftSpaceLabel.setText("    ");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new java.awt.Insets(10, 0, 0, 0);
        mTimingLinePanel.add(mLeftSpaceLabel, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        getContentPane().add(mTimingLinePanel, gridBagConstraints);

        pack();
    }//GEN-END:initComponents
    
   
    // ϐ錾 - ҏWs//GEN-BEGIN:variables
    private jp.riken.brain.ni.samuraigraph.base.SGSingleAxisSelectionPanel mAxisPanel;
    private javax.swing.JPanel mButtonPanel;
    private javax.swing.JButton mCancelButton;
    private javax.swing.JLabel mColorLabel;
    private javax.swing.JLabel mEndValueLabel;
    private jp.riken.brain.ni.samuraigraph.base.SGTextField mEndValueTextField;
    private javax.swing.JLabel mLeftSpaceLabel;
    private jp.riken.brain.ni.samuraigraph.base.SGColorSelectionButton mLineColorButton;
    private javax.swing.JComboBox mLineTypeComboBox;
    private javax.swing.JLabel mLineTypeLabel;
    private javax.swing.JLabel mLineWidthLabel;
    private jp.riken.brain.ni.samuraigraph.base.SGSpinner mLineWidthSpinner;
    private javax.swing.JButton mOKButton;
    private javax.swing.JButton mPreviewButton;
    private javax.swing.JLabel mRightSpaceLabel;
    private javax.swing.JLabel mStartValueLabel;
    private jp.riken.brain.ni.samuraigraph.base.SGTextField mStartValueTextField;
    private javax.swing.JPanel mTimingLinePanel;
    private javax.swing.JLabel mTimingValueLabel;
    private jp.riken.brain.ni.samuraigraph.base.SGTextField mTimingValueTextField;
    // ϐ錾̏I//GEN-END:variables


//	/**
//	 * 
//	 *
//	 */
//	public void dispose()
//	{
//		if( this.mAxisPanel!=null )
//		{
//			this.mAxisPanel.dispose();
//			this.mAxisPanel = null;
//		}
//		
//		super.dispose();
//	}


   	/**
	 * 
	 */
	private boolean initProperty()
	{

		// set the title
		this.setTitle( SGTimingLineDialog.TITLE );


		//
		{
			final String typeArray[] = {
				SGDrawingElementLine.LINE_NAME_SOLID,
				SGDrawingElementLine.LINE_NAME_BROKEN,
				SGDrawingElementLine.LINE_NAME_DOT,
				SGDrawingElementLine.LINE_NAME_DASHED,
				SGDrawingElementLine.LINE_NAME_DOUBLE_DASHED
			};
			for(int ii=0 ; ii<typeArray.length ; ii++)
			{
				this.mLineTypeComboBox.addItem( typeArray[ii] );
			}
		}


		this.pack();

		
		//
		// Xsi[f̓Kp
		//

		// line
		this.mLineWidthSpinner.initProperties(
			getLineWidthSpinnerNumberModel(),
			pt, 1, 2 );


		// tH[JXꂽF{^̏
		this.mFocusedColorSetButton = this.mLineColorButton;


		// set the name
		this.mTimingValueTextField.setDescription("Value");
		this.mLineWidthSpinner.setDescription("Width");


		{
			this.mOKButton.addActionListener(this);
			this.mCancelButton.addActionListener(this);
			this.mPreviewButton.addActionListener(this);
		}


		return true;
	}

	
	


	/**
	 * 
	 */
	public String getTimingValueString()
	{
		return this.mTimingValueTextField.getText();
	}

	
	/**
	 * 
	 * @return
	 */
	public Number getTimingValue()
	{
		String str = this.getTimingValueString();
		if( str==null )
		{
			return null;
		}

		Number num = SGUtilityText.getDouble(str);		
		
		return num;
	}
	

	/**
	 * 
	 */
	public boolean setValue( final Object obj )
	{
		return this.setValue( this.mTimingValueTextField, obj );
	}


	/**
	 * 
	 */
	public boolean setLineType( final Integer type )
	{
		if( type!=null )
		{
			final String typeName = SGDrawingElementLine.getLineTypeName( type.intValue() );
			this.mLineTypeComboBox.setSelectedItem(typeName);
		}
		else
		{
			this.mLineTypeComboBox.setSelectedItem( null );
		}

		return true;
	}


	/**
	 * 
	 */
	public int getLineType()
	{
		final String typeName = (String)this.mLineTypeComboBox.getSelectedItem();
		if( typeName==null )
		{
			return -1;
		}
		final Integer num = SGDrawingElementLine.getLineTypeFromName(typeName);
		return num.intValue();
	}


	/**
	 * 
	 */
	public boolean setLineWidth( final Object obj )
	{
		return this.setValue( this.mLineWidthSpinner, obj );
	}


	/**
	 * 
	 */
	public Number getLineWidth()
	{
		return this.mLineWidthSpinner.getNumber();
	}


	/**
	 * 
	 */
	public boolean setColor( final Color cl )
	{
		this.mLineColorButton.setColor( cl );
		return true;
	}


	/**
	 * 
	 */
	public Color getColor()
	{
		return this.mLineColorButton.getColor();
	}


	
	/**
	 * 
	 */
	public ArrayList getColorSelectionButtonsList()
	{
		final ArrayList list = new ArrayList();
		list.add(this.mLineColorButton);

		return list;
	}


	/**
	 * 
	 */
	public ArrayList getTextFieldComponentsList()
	{
		final ArrayList list = this.getFormattedTextFieldsListFromSpinners();
		list.addAll( this.getNumberTextFieldList() );
		return list;
	}


	/**
	 * Returns a list of text fields to set number.
	 * @return
	 */
	public ArrayList getNumberTextFieldList()
	{
		final ArrayList list = new ArrayList();
		list.add(this.mTimingValueTextField);
		return list;
	}


	/**
	 * 
	 */
	public ArrayList getSpinnerList()
	{
		ArrayList list = new ArrayList();
		list.add( this.mLineWidthSpinner );
		return list;
	}



	/**
	 * Set properties to all listeners.
	 * @param l
	 * @return
	 */
	public boolean setPropertiesToListeners( SGIPropertyDialogObserver l )
	{
		SGITimingLineDialogObserver line
			= (SGITimingLineDialogObserver)l;

		// get values
		final int config = this.mAxisPanel.getAxisConfiguration();
		final Number value = this.getTimingValue();
		final int type = this.getLineType();
		final Number lineWidth = this.getLineWidth();
		final Color cl = this.getColor();


		// check values
		if( line.hasValidValue( config, value ) == false )
		{
			this.setInputErrorMessage( ERRMSG_AXIS_VALUE_INVALID );
			return false;
		}


		// set the related axes
		if( config!=-1 )
		{
			line.setAxisConfiguration( config );
		}

		// value
		if( value!=null )
		{
			line.setValue( value.doubleValue() );
		}

		// line type
		if( type!=-1 )
		{
			line.setLineType( type );
		}

		// line width
		if( lineWidth!=null )
		{
			line.setLineWidth( lineWidth.floatValue(), pt );
		}

		// color
		if( cl!=null )
		{
			line.setColor( cl );
		}

		return true;
	}



	/**
	 * 
	 * @return
	 */
	public boolean setDialogProperty()
	{
		final SGTimingLineDialog dg = this;

		ArrayList list = this.mPropertyDialogObserverList;

		if( this.mAxisPanel.setSelected( list ) == false )
		{
			return false;
		}


		SGITimingLineDialogObserver line0
			= (SGITimingLineDialogObserver)list.get(0);

		final double value0 = line0.getValue();
		final float lineWidth0 = line0.getLineWidth( pt );
		final int lineType0 = line0.getLineType();
		final Color color0 = line0.getColor();

		Double value = new Double( value0 );
		Float lineWidth = new Float( lineWidth0 );
		Integer lineType = new Integer( lineType0 );
		Color color = color0;

		if( list.size() > 1 )
		{
			for( int ii=1; ii<list.size(); ii++ )
			{
				SGITimingLineDialogObserver line1
					= (SGITimingLineDialogObserver)list.get(ii);

				final double xValue1 = line1.getValue();
				if( value0!=xValue1 )
				{
					value = null;
					break;
				}
			}

			for( int ii=1; ii<list.size(); ii++ )
			{
				SGITimingLineDialogObserver line1
					= (SGITimingLineDialogObserver)list.get(ii);

				final float fontSize1 = line1.getLineWidth( pt );
				if( lineWidth0!=fontSize1 )
				{
					lineWidth = null;
					break;
				}
			}

			for( int ii=1; ii<list.size(); ii++ )
			{
				SGITimingLineDialogObserver line1
					= (SGITimingLineDialogObserver)list.get(ii);

				final int fontStyle1 = line1.getLineType();
				if( lineType0!=fontStyle1 )
				{
					lineType = null;
					break;
				}
			}

			for( int ii=1; ii<list.size(); ii++ )
			{
				SGITimingLineDialogObserver line1
					= (SGITimingLineDialogObserver)list.get(ii);

				final Color color1 = line1.getColor();
				if( color0.equals(color1) == false )
				{
					color = null;
					break;
				}
			}
		}


		//
		this.setValue( value );

		this.setLineWidth( lineWidth );
		this.setLineType( lineType );
		this.setColor( color );


		this.setColorButtonBorder(true);

		return true;
	}

}

