
package jp.riken.brain.ni.samuraigraph.figure.java2d;

import java.awt.Color;

import jp.riken.brain.ni.samuraigraph.base.*;
import jp.riken.brain.ni.samuraigraph.base.SGIPropertyDialogObserver;

/**
 *
 *
 */
public interface SGILabelDialogObserver
	extends SGIPropertyDialogObserver, SGITwoAxesHolder
{

	/**
	 * 
	 * @return
	 */
	public double getXValue();
	
	
	/**
	 * 
	 * @return
	 */
	public double getYValue();


	/**
	 * 
	 * @return
	 */
	public String getString();


	/**
	 * 
	 * @return
	 */
	public Color getStringColor();


	/**
	 * 
	 * @return
	 */
	public String getFontName();



	/**
	 *
	 */
	public float getFontSize( final String unit );



	/**
	 *
	 */
	public int getFontStyle();


	/**
	 * 
	 * @return
	 */
	public float getAngle();


	/**
	 * 
	 * @param value
	 */
	public void setXValue( final double value );


	/**
	 * 
	 * @param value
	 */
	public void setYValue( final double value );



	/**
	 * 
	 * @param str
	 * @return
	 */
	public boolean setString( final String str );


	/**
	 * 
	 * @param color
	 */
	public void setStringColor( final Color color );


	public void setFontName( final String name );

	public void setFontStyle( final int style );

	public void setFontSize( final float size, final String unit );


	/**
	 * 
	 * @param angle
	 * @return
	 */
	public boolean setAngle( final float angle );


	/**
	 * 
	 * @param config
	 * @param value
	 * @return
	 */
	public boolean hasValidXValue( final int config, final Number value );

	/**
	 * 
	 * @param config
	 * @param value
	 * @return
	 */
	public boolean hasValidYValue( final int config, final Number value );


}

