/*
 * Created on 2004/08/06
 *
 * To change the template for this generated file go to
 * Window>Preferences>Java>Code Generation>Code and Comments
 */
package jp.riken.brain.ni.samuraigraph.figure.java2d;

import java.awt.Color;
import java.util.ArrayList;

import jp.riken.brain.ni.samuraigraph.base.SGProperties;
import jp.riken.brain.ni.samuraigraph.base.SGUtilityNumber;
import jp.riken.brain.ni.samuraigraph.base.SGUtilityText;

import org.w3c.dom.Element;


/**
 * @author kuromaru
 *
 * To change the template for this generated type comment go to
 * Window>Preferences>Java>Code Generation>Code and Comments
 */
public abstract class SGElementGroupTickLabel extends SGElementGroupString
{


	/**
	 * 
	 */
	public static final float ANGLE_HORIZONTAL = 0.0f;


	/**
	 * 
	 */
	public static final float ANGLE_INCLINED = (float)Math.PI/6.0f;


	/**
	 * 
	 */
	public static final String HORIZONTAL = "Horizontal";


	/**
	 * 
	 */
	public static final String INCLINED = "Inclined";



	/**
	 * 
	 */
	public static final String TAG_NAME_TICK_LABELS = "TickLabels";



	/**
	 * 
	 *
	 */
	public SGElementGroupTickLabel()
	{
		super();
	}



	/**
	 * 
	 */
	public static Float getTickLabelAngleFromName( final String name )
	{
		if( name==null )
		{
			return null;
		}

		Float angle = null;
		if( name.equals( SGElementGroupTickLabel.HORIZONTAL ) )
		{
			angle = new Float( SGElementGroupTickLabel.ANGLE_HORIZONTAL );
		}
		else if( name.equals( SGElementGroupTickLabel.INCLINED ) )
		{
			angle = new Float( SGElementGroupTickLabel.ANGLE_INCLINED );
		}
		
		return angle;
	}



	/**
	 * 
	 */
	public static String getTickLabelAngleName( final double angle )
	{
		String name = null;

		// angle
		if( angle == SGElementGroupTickLabel.ANGLE_HORIZONTAL )
		{
			name = SGElementGroupTickLabel.HORIZONTAL;
		}
		else if( angle == SGElementGroupTickLabel.ANGLE_INCLINED )
		{
			name = SGElementGroupTickLabel.INCLINED;
		}
		else
		{
			throw new Error();
		}

		return name;
	}



	/**
	 * 
	 */
	public boolean writeProperty( final Element el )
	{
		String pt = SGUtilityNumber.pt;
		String degree = SGUtilityNumber.degree;
		el.setAttribute( KEY_VISIBLE, Boolean.toString( this.mVisibleFlag ) );
		el.setAttribute( KEY_FONT_SIZE, Float.toString( this.mFontSize ) + pt );
		el.setAttribute( KEY_FONT_NAME, this.mFontName );
		el.setAttribute( KEY_FONT_STYLE, SGUtilityText.getFontStyleName( this.mFontStyle ) );
		el.setAttribute( KEY_COLOR_LIST, SGUtilityText.getColorListString( this.mColorList ) );

		String strAngle = getTickLabelAngleName( this.mAngle );
		el.setAttribute( KEY_ANGLE, strAngle );

		return true;
	}

	
	
	/**
	 * 
	 * @param el
	 * @return
	 */
	public SGProperties readProperties( final Element el )
	{
		String str = null;
		Number num = null;
		Color cl = null;
		Boolean b = null;
		ArrayList list = null;

		StringProperties p = new StringProperties();


		// visible
		str = el.getAttribute( KEY_VISIBLE );
		if( str.length()==0 )
		{
			return null;
		}
		b = SGUtilityText.getBoolean(str);
		if( b==null )
		{
			return null;
		}
		p.setVisible( b.booleanValue() );
		
		
		// set font size
		str = el.getAttribute( KEY_FONT_SIZE );
		if( str.length()==0 )
		{
			return null;
		}
		num = SGUtilityText.getLengthInPoint(str);
		if( num==null )
		{
			return null;
		}
		p.setFontSize( num.floatValue() );


		// set font name
		str = el.getAttribute( KEY_FONT_NAME );
		if( str.length()==0 )
		{
			return null;
		}
		p.setFontName( str );


		// set font style
		str = el.getAttribute( KEY_FONT_STYLE );
		if( str.length()==0 )
		{
			return null;
		}
		final int fontStyle = SGUtilityText.getFontStyle(str);
		p.setFontStyle( fontStyle );


		// color
		str = el.getAttribute( KEY_COLOR_LIST );
		if( str.length()==0 )
		{
			return null;
		}
		list = SGUtilityText.getColorList(str);
		if( list==null )
		{
			return null;
		}
		p.setColorList( list );


		// angle
		str = el.getAttribute( KEY_ANGLE );
		if( str.length()==0 )
		{
			return null;
		}
		num = getTickLabelAngleFromName(str);
		if( num == null )
		{
			return null;
		}
		p.setAngle( num.floatValue() );

		
		return p;
		
	}

	

	/**
	 * 
	 */
	public static class TickLabelProperties extends StringProperties
	{

		public TickLabelProperties()
		{
			super();
		}

	}

}

