
package jp.riken.brain.ni.samuraigraph.figure.java2d;

import java.awt.Color;

import jp.riken.brain.ni.samuraigraph.base.SGDrawingElement;
import jp.riken.brain.ni.samuraigraph.figure.SGDrawingElementRectangle;


/**
 * 
 */
public abstract class SGElementGroupRectangle extends SGElementGroupSXY
{


	/**
	 * 
	 */
	protected float mRectangleWidth;


	/**
	 * 
	 */
	protected float mRectangleHeight;


	/**
	 * 
	 */
	protected float mEdgeLineWidth;


	/**
	 * 
	 */
	protected Color mEdgeLineColor;



	/**
	 * 
	 */
	protected final String SET_EDGE_LINE_WIDTH = "Set the width of edge line";


	/**
	 * 
	 */
	protected final String SET_EDGE_COLOR = "Set the edge color";



	/**
	 *
	 */
	public SGElementGroupRectangle()
	{
		super();
	}


	/**
	 * 
	 */
	public void dispose()
	{
		super.dispose();

		this.mEdgeLineColor = null;
	}


	/**
	 * 
	 */
	public float getRectangleWidth()
	{
		return this.mRectangleWidth;
	}


	/**
	 * 
	 */
	public float getRectangleHeight()
	{
		return this.mRectangleHeight;
	}


	/**
	 * 
	 */
	public float getEdgeLineWidth()
	{
		return this.mEdgeLineWidth;
	}
	
	
	/**
	 * 
	 */
	public Color getEdgeLineColor()
	{
		return this.mEdgeLineColor;
	}



	/**
	 * 
	 */
	public boolean setRectangleWidth( final float width )
	{
		this.mRectangleWidth = width;
		return true;
	}


	/**
	 * 
	 */
	public boolean setRectangleHeight( final float height )
	{
		this.mRectangleHeight = height;
		return true;
	}


	/**
	 *
	 */
	public boolean setEdgeLineWidth( final float width )
	{
		mEdgeLineWidth = width;
		if( this.mDrawingElementArray!=null )
		{
			for( int ii=0; ii<this.mDrawingElementArray.length; ii++ )
			{
				SGDrawingElementBar2D el = (SGDrawingElementBar2D)mDrawingElementArray[ii];
				el.setEdgeLineWidth(mEdgeLineWidth);
			}
		}
		return true;
	}



	/**
	 *
	 */
	public boolean setEdgeLineColor( final Color color )
	{
		mEdgeLineColor = color;
		if( this.mDrawingElementArray!=null )
		{
			for( int ii=0; ii<this.mDrawingElementArray.length; ii++ )
			{
				SGDrawingElementBar2D el = (SGDrawingElementBar2D)mDrawingElementArray[ii];
				el.setEdgeLineColor(mEdgeLineColor);
			}
		}
		return true;
	}






	/**
	 * 
	 */
	public boolean setProperty( final SGDrawingElement element )
	{
		if( !(element instanceof SGDrawingElementRectangle) )
		{
			return false;
		}

		if( super.setProperty( element ) == false )
		{
			return false;
		}

		SGDrawingElementRectangle rect = (SGDrawingElementRectangle)element;
		this.setRectangleWidth( rect.getWidth() );
		this.setRectangleHeight( rect.getHeight() );
		this.setEdgeLineWidth( rect.getEdgeLineWidth() );
		this.setEdgeLineColor( rect.getEdgeLineColor() );

		return true;
	}



}
