/*
 * SGAxisDialog.java
 *
 * Created on 2004/06/09, 15:04
 */

package jp.riken.brain.ni.samuraigraph.figure.java2d;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;

import javax.swing.JPanel;
import javax.swing.SpinnerNumberModel;

import jp.riken.brain.ni.samuraigraph.base.SGIAxisElement;
import jp.riken.brain.ni.samuraigraph.base.SGIConstants;
import jp.riken.brain.ni.samuraigraph.base.SGIPropertyDialogObserver;
import jp.riken.brain.ni.samuraigraph.base.SGPropertyDialog;
import jp.riken.brain.ni.samuraigraph.base.SGUtility;
import jp.riken.brain.ni.samuraigraph.base.SGUtilityText;

/**
 *
 * @author  kuromaru
 */
public class SGAxisDialog extends SGPropertyDialog
{

	/**
	 * 
	 */
	public static final String TITLE = "Axis Properties";


	public static final String AXIS_TOP = "Top";
	public static final String AXIS_BOTTOM = "Bottom";
	public static final String AXIS_LEFT = "Left";
	public static final String AXIS_RIGHT = "Right";


    /** Creates new form SGAxisDialog */
    public SGAxisDialog(java.awt.Frame parent, boolean modal)
    {
        super(parent, modal);
        initComponents();

		this.mBottomPanel.add( new SGAxisPanel( AXIS_BOTTOM ) );
		this.mTopPanel.add( new SGAxisPanel( AXIS_TOP ) );
		this.mLeftPanel.add( new SGAxisPanel( AXIS_LEFT ) );
		this.mRightPanel.add( new SGAxisPanel( AXIS_RIGHT ) );

	    this.initProperty();
		this.initialize();
    }
    
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    private void initComponents() {//GEN-BEGIN:initComponents
        java.awt.GridBagConstraints gridBagConstraints;

        mTabbedPane = new javax.swing.JTabbedPane();
        mBottomPanel = new javax.swing.JPanel();
        mTopPanel = new javax.swing.JPanel();
        mLeftPanel = new javax.swing.JPanel();
        mRightPanel = new javax.swing.JPanel();
        mButtonPanel = new javax.swing.JPanel();
        mOKButton = new javax.swing.JButton();
        mCancelButton = new javax.swing.JButton();
        mPreviewButton = new javax.swing.JButton();
        mAxisCommonPanel = new javax.swing.JPanel();
        mAxisLinePanel = new javax.swing.JPanel();
        mAxisLineSeparator = new javax.swing.JSeparator();
        mAxisWidthLabel1 = new javax.swing.JLabel();
        mAxisWidthLabel2 = new javax.swing.JLabel();
        mScaleWidthLabel1 = new javax.swing.JLabel();
        mScaleWidthLabel2 = new javax.swing.JLabel();
        mScaleLengthLabel1 = new javax.swing.JLabel();
        mScaleLengthLabel2 = new javax.swing.JLabel();
        mLineColorLabel = new javax.swing.JLabel();
        mAxisLineWidthSpinner = new jp.riken.brain.ni.samuraigraph.base.SGSpinner();
        mScaleLineWidthSpinner = new jp.riken.brain.ni.samuraigraph.base.SGSpinner();
        mScaleLineLengthSpinner = new jp.riken.brain.ni.samuraigraph.base.SGSpinner();
        mLineColorButton = new jp.riken.brain.ni.samuraigraph.base.SGColorSelectionButton();
        mAxisLineLeftSpaceLabel = new javax.swing.JLabel();
        mAxisLineRightSpaceLabel = new javax.swing.JLabel();
        mFontSeparator = new javax.swing.JSeparator();
        mFontLabel = new javax.swing.JLabel();
        mFontFamilyLabel = new javax.swing.JLabel();
        mFontSizeLabel = new javax.swing.JLabel();
        mFontColorLabel = new javax.swing.JLabel();
        mFontTypeComboBox = new javax.swing.JComboBox();
        mFontSizeSpinner = new jp.riken.brain.ni.samuraigraph.base.SGSpinner();
        mFontNameComboBox = new javax.swing.JComboBox();
        mFontColorButton = new jp.riken.brain.ni.samuraigraph.base.SGColorSelectionButton();
        mFrameLabel = new javax.swing.JLabel();
        mFrameVisibleCheckBox = new jp.riken.brain.ni.samuraigraph.base.SGCheckBox();
        mFrameLineWidthLabel = new javax.swing.JLabel();
        mFrameLineColorLabel = new javax.swing.JLabel();
        mFrameLineWidthSpinner = new jp.riken.brain.ni.samuraigraph.base.SGSpinner();
        mFrameColorButton = new jp.riken.brain.ni.samuraigraph.base.SGColorSelectionButton();
        mFontStyleLabel = new javax.swing.JLabel();

        getContentPane().setLayout(new java.awt.GridBagLayout());

        mTabbedPane.setFont(new java.awt.Font("Dialog", 1, 12));
        mBottomPanel.setLayout(new java.awt.GridBagLayout());

        mTabbedPane.addTab("Bottom", mBottomPanel);

        mTopPanel.setLayout(new java.awt.GridBagLayout());

        mTopPanel.setFont(new java.awt.Font("Dialog", 1, 14));
        mTabbedPane.addTab("Top", mTopPanel);

        mLeftPanel.setLayout(new java.awt.GridBagLayout());

        mTabbedPane.addTab("Left", mLeftPanel);

        mRightPanel.setLayout(new java.awt.GridBagLayout());

        mTabbedPane.addTab("Right", mRightPanel);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        getContentPane().add(mTabbedPane, gridBagConstraints);

        mOKButton.setFont(new java.awt.Font("Dialog", 1, 12));
        mOKButton.setText("OK");
        mButtonPanel.add(mOKButton);

        mCancelButton.setFont(new java.awt.Font("Dialog", 1, 12));
        mCancelButton.setText("Cancel");
        mButtonPanel.add(mCancelButton);

        mPreviewButton.setFont(new java.awt.Font("Dialog", 1, 12));
        mPreviewButton.setText("Preview");
        mButtonPanel.add(mPreviewButton);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        getContentPane().add(mButtonPanel, gridBagConstraints);

        mAxisCommonPanel.setLayout(new java.awt.GridBagLayout());

        mAxisLinePanel.setLayout(new java.awt.GridBagLayout());

        mAxisLinePanel.setBorder(new javax.swing.border.BevelBorder(javax.swing.border.BevelBorder.RAISED));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 8;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        gridBagConstraints.insets = new java.awt.Insets(10, 5, 5, 5);
        mAxisLinePanel.add(mAxisLineSeparator, gridBagConstraints);

        mAxisWidthLabel1.setFont(new java.awt.Font("Dialog", 0, 12));
        mAxisWidthLabel1.setText("Axis Line");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(0, 15, 0, 0);
        mAxisLinePanel.add(mAxisWidthLabel1, gridBagConstraints);

        mAxisWidthLabel2.setFont(new java.awt.Font("Dialog", 0, 12));
        mAxisWidthLabel2.setText("Width");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        gridBagConstraints.insets = new java.awt.Insets(0, 15, 10, 0);
        mAxisLinePanel.add(mAxisWidthLabel2, gridBagConstraints);

        mScaleWidthLabel1.setFont(new java.awt.Font("Dialog", 0, 12));
        mScaleWidthLabel1.setText("Tick Mark");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        gridBagConstraints.insets = new java.awt.Insets(0, 20, 0, 5);
        mAxisLinePanel.add(mScaleWidthLabel1, gridBagConstraints);

        mScaleWidthLabel2.setFont(new java.awt.Font("Dialog", 0, 12));
        mScaleWidthLabel2.setText("Width");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        gridBagConstraints.insets = new java.awt.Insets(0, 20, 10, 5);
        mAxisLinePanel.add(mScaleWidthLabel2, gridBagConstraints);

        mScaleLengthLabel1.setFont(new java.awt.Font("Dialog", 0, 12));
        mScaleLengthLabel1.setText("Tick Mark");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        gridBagConstraints.insets = new java.awt.Insets(0, 20, 0, 5);
        mAxisLinePanel.add(mScaleLengthLabel1, gridBagConstraints);

        mScaleLengthLabel2.setFont(new java.awt.Font("Dialog", 0, 12));
        mScaleLengthLabel2.setText("Length");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        gridBagConstraints.insets = new java.awt.Insets(0, 20, 10, 5);
        mAxisLinePanel.add(mScaleLengthLabel2, gridBagConstraints);

        mLineColorLabel.setFont(new java.awt.Font("Dialog", 0, 12));
        mLineColorLabel.setText("Color");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 7;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        gridBagConstraints.insets = new java.awt.Insets(5, 20, 10, 5);
        mAxisLinePanel.add(mLineColorLabel, gridBagConstraints);

        mAxisLineWidthSpinner.setFont(new java.awt.Font("Dialog", 0, 12));
        mAxisLineWidthSpinner.setPreferredSize(new java.awt.Dimension(70, 22));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(0, 5, 5, 0);
        mAxisLinePanel.add(mAxisLineWidthSpinner, gridBagConstraints);

        mScaleLineWidthSpinner.setFont(new java.awt.Font("Dialog", 0, 12));
        mScaleLineWidthSpinner.setPreferredSize(new java.awt.Dimension(70, 22));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(0, 5, 5, 0);
        mAxisLinePanel.add(mScaleLineWidthSpinner, gridBagConstraints);

        mScaleLineLengthSpinner.setFont(new java.awt.Font("Dialog", 0, 12));
        mScaleLineLengthSpinner.setPreferredSize(new java.awt.Dimension(75, 22));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(0, 5, 5, 0);
        mAxisLinePanel.add(mScaleLineLengthSpinner, gridBagConstraints);

        mLineColorButton.setPreferredSize(new java.awt.Dimension(65, 20));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 8;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(0, 5, 5, 0);
        mAxisLinePanel.add(mLineColorButton, gridBagConstraints);

        mAxisLineLeftSpaceLabel.setText("    ");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        mAxisLinePanel.add(mAxisLineLeftSpaceLabel, gridBagConstraints);

        mAxisLineRightSpaceLabel.setText("    ");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 9;
        gridBagConstraints.gridy = 0;
        mAxisLinePanel.add(mAxisLineRightSpaceLabel, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 6;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        gridBagConstraints.insets = new java.awt.Insets(5, 50, 5, 5);
        mAxisLinePanel.add(mFontSeparator, gridBagConstraints);

        mFontLabel.setFont(new java.awt.Font("Dialog", 3, 12));
        mFontLabel.setText("Font");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        mAxisLinePanel.add(mFontLabel, gridBagConstraints);

        mFontFamilyLabel.setFont(new java.awt.Font("Dialog", 0, 12));
        mFontFamilyLabel.setText("Family");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        gridBagConstraints.insets = new java.awt.Insets(5, 15, 5, 5);
        mAxisLinePanel.add(mFontFamilyLabel, gridBagConstraints);

        mFontSizeLabel.setFont(new java.awt.Font("Dialog", 0, 12));
        mFontSizeLabel.setText("Size");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        gridBagConstraints.insets = new java.awt.Insets(5, 15, 5, 5);
        mAxisLinePanel.add(mFontSizeLabel, gridBagConstraints);

        mFontColorLabel.setFont(new java.awt.Font("Dialog", 0, 12));
        mFontColorLabel.setText("Color");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        gridBagConstraints.insets = new java.awt.Insets(5, 20, 5, 5);
        mAxisLinePanel.add(mFontColorLabel, gridBagConstraints);

        mFontTypeComboBox.setFont(new java.awt.Font("Dialog", 0, 12));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        mAxisLinePanel.add(mFontTypeComboBox, gridBagConstraints);

        mFontSizeSpinner.setFont(new java.awt.Font("Dialog", 0, 12));
        mFontSizeSpinner.setPreferredSize(new java.awt.Dimension(70, 22));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        mAxisLinePanel.add(mFontSizeSpinner, gridBagConstraints);

        mFontNameComboBox.setFont(new java.awt.Font("Dialog", 0, 12));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        mAxisLinePanel.add(mFontNameComboBox, gridBagConstraints);

        mFontColorButton.setPreferredSize(new java.awt.Dimension(65, 20));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        mAxisLinePanel.add(mFontColorButton, gridBagConstraints);

        mFrameLabel.setFont(new java.awt.Font("Dialog", 3, 12));
        mFrameLabel.setText("Frame");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 7;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        gridBagConstraints.insets = new java.awt.Insets(5, 15, 5, 5);
        mAxisLinePanel.add(mFrameLabel, gridBagConstraints);

        mFrameVisibleCheckBox.setFont(new java.awt.Font("Dialog", 0, 12));
        mFrameVisibleCheckBox.setText("Visible");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 8;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        gridBagConstraints.insets = new java.awt.Insets(5, 0, 5, 5);
        mAxisLinePanel.add(mFrameVisibleCheckBox, gridBagConstraints);

        mFrameLineWidthLabel.setFont(new java.awt.Font("Dialog", 0, 12));
        mFrameLineWidthLabel.setText("Width");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 7;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        gridBagConstraints.insets = new java.awt.Insets(5, 20, 5, 5);
        mAxisLinePanel.add(mFrameLineWidthLabel, gridBagConstraints);

        mFrameLineColorLabel.setFont(new java.awt.Font("Dialog", 0, 12));
        mFrameLineColorLabel.setText("Color");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 7;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        gridBagConstraints.insets = new java.awt.Insets(5, 20, 5, 5);
        mAxisLinePanel.add(mFrameLineColorLabel, gridBagConstraints);

        mFrameLineWidthSpinner.setFont(new java.awt.Font("Dialog", 0, 12));
        mFrameLineWidthSpinner.setPreferredSize(new java.awt.Dimension(70, 22));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 8;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        mAxisLinePanel.add(mFrameLineWidthSpinner, gridBagConstraints);

        mFrameColorButton.setPreferredSize(new java.awt.Dimension(65, 20));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 8;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(5, 5, 5, 5);
        mAxisLinePanel.add(mFrameColorButton, gridBagConstraints);

        mFontStyleLabel.setFont(new java.awt.Font("Dialog", 0, 12));
        mFontStyleLabel.setText("Style");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        gridBagConstraints.insets = new java.awt.Insets(5, 20, 5, 5);
        mAxisLinePanel.add(mFontStyleLabel, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTH;
        mAxisCommonPanel.add(mAxisLinePanel, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        getContentPane().add(mAxisCommonPanel, gridBagConstraints);

        pack();
    }//GEN-END:initComponents
    
    
    // ϐ錾 - ҏWs//GEN-BEGIN:variables
    private javax.swing.JPanel mAxisCommonPanel;
    private javax.swing.JLabel mAxisLineLeftSpaceLabel;
    private javax.swing.JPanel mAxisLinePanel;
    private javax.swing.JLabel mAxisLineRightSpaceLabel;
    private javax.swing.JSeparator mAxisLineSeparator;
    private jp.riken.brain.ni.samuraigraph.base.SGSpinner mAxisLineWidthSpinner;
    private javax.swing.JLabel mAxisWidthLabel1;
    private javax.swing.JLabel mAxisWidthLabel2;
    private javax.swing.JPanel mBottomPanel;
    private javax.swing.JPanel mButtonPanel;
    private javax.swing.JButton mCancelButton;
    private jp.riken.brain.ni.samuraigraph.base.SGColorSelectionButton mFontColorButton;
    private javax.swing.JLabel mFontColorLabel;
    private javax.swing.JLabel mFontFamilyLabel;
    private javax.swing.JLabel mFontLabel;
    private javax.swing.JComboBox mFontNameComboBox;
    private javax.swing.JSeparator mFontSeparator;
    private javax.swing.JLabel mFontSizeLabel;
    private jp.riken.brain.ni.samuraigraph.base.SGSpinner mFontSizeSpinner;
    private javax.swing.JLabel mFontStyleLabel;
    private javax.swing.JComboBox mFontTypeComboBox;
    private jp.riken.brain.ni.samuraigraph.base.SGColorSelectionButton mFrameColorButton;
    private javax.swing.JLabel mFrameLabel;
    private javax.swing.JLabel mFrameLineColorLabel;
    private javax.swing.JLabel mFrameLineWidthLabel;
    private jp.riken.brain.ni.samuraigraph.base.SGSpinner mFrameLineWidthSpinner;
    private jp.riken.brain.ni.samuraigraph.base.SGCheckBox mFrameVisibleCheckBox;
    private javax.swing.JPanel mLeftPanel;
    private jp.riken.brain.ni.samuraigraph.base.SGColorSelectionButton mLineColorButton;
    private javax.swing.JLabel mLineColorLabel;
    private javax.swing.JButton mOKButton;
    private javax.swing.JButton mPreviewButton;
    private javax.swing.JPanel mRightPanel;
    private javax.swing.JLabel mScaleLengthLabel1;
    private javax.swing.JLabel mScaleLengthLabel2;
    private jp.riken.brain.ni.samuraigraph.base.SGSpinner mScaleLineLengthSpinner;
    private jp.riken.brain.ni.samuraigraph.base.SGSpinner mScaleLineWidthSpinner;
    private javax.swing.JLabel mScaleWidthLabel1;
    private javax.swing.JLabel mScaleWidthLabel2;
    private javax.swing.JTabbedPane mTabbedPane;
    private javax.swing.JPanel mTopPanel;
    // ϐ錾̏I//GEN-END:variables

    
    
   	/**
	 * 
	 */
	private boolean initProperty()
	{

		// set the title
		this.setTitle( SGAxisDialog.TITLE );


		//
		// Xsi[f̐ݒ
		//

		// axis line width
		this.mAxisLineWidthSpinner.initProperties(
			getLineWidthSpinnerNumberModel(),
			pt, 1, 2 );

		// scale line width
		this.mScaleLineWidthSpinner.initProperties(
			getLineWidthSpinnerNumberModel(),
			pt, 1, 2 );

		// scale line length
		this.mScaleLineLengthSpinner.initProperties(
			new SpinnerNumberModel( 0.10, 0.0, 0.5, 0.05 ),
			cm, 1, 2 );

		// font size
		this.mFontSizeSpinner.initProperties(
			getFontSizeSpinnerNumberModel(),
			pt, 1, 2 );

		// frame line width
		this.mFrameLineWidthSpinner.initProperties(
			getLineWidthSpinnerNumberModel(),
			pt, 1, 2 );

		// font name
		final String fontArray[] = SGUtility.getAvailableFontFamilyNames();
		for(int ii=0 ; ii<fontArray.length ; ii++)
		{
			this.mFontNameComboBox.addItem( fontArray[ii] );
		}

		// font style
		final String[] styleNameArray = {
			SGIConstants.FONT_PLAIN,
			SGIConstants.FONT_ITALIC,
			SGIConstants.FONT_BOLD,
			SGIConstants.FONT_BOLD_ITALIC
		};
		for( int ii=0; ii<styleNameArray.length; ii++ )
		{
			this.mFontTypeComboBox.addItem( styleNameArray[ii] );
		}

		this.pack();


		//
		// add an action listener
		//

		this.mOKButton.addActionListener( this );
		this.mCancelButton.addActionListener( this );
		this.mPreviewButton.addActionListener( this );

		// check box
		this.mFrameVisibleCheckBox.addActionListener(this);


		// tH[JXꂽF{^̏
		this.mFocusedColorSetButton = this.mLineColorButton;


		// set the name
		this.mFontSizeSpinner.setDescription("Font-> Size");
		this.mFrameLineWidthSpinner.setDescription("Frame-> Width");
		this.mAxisLineWidthSpinner.setDescription("Axis Line Width");
		this.mScaleLineWidthSpinner.setDescription("Tick Mark Width");
		this.mScaleLineLengthSpinner.setDescription("Tick Mark Length");

		return true;
	}


//	/**
//	 * 
//	 */
//	public void dispose()
//	{
//		SGAxisPanel p = null;
//
//		p = this.getBottomPanel();
//		if( p!=null ) p.dispose();
//
//		p = this.getTopPanel();
//		if( p!=null ) p.dispose();
//
//		p = this.getLeftPanel();
//		if( p!=null ) p.dispose();
//
//		p = this.getRightPanel();
//		if( p!=null ) p.dispose();
//
//		p = null;
//
//		super.dispose();
//	}


	/**
	 * 
	 */
	public void actionPerformed( final ActionEvent e )
	{
		super.actionPerformed(e);

		Object source = e.getSource();
//System.out.println(source);

		if( source.equals( this.mFrameVisibleCheckBox ) )
		{
			this.setFrameLineComponentsEnabled( this.mFrameVisibleCheckBox.isSelected() );
		}
	}




	private SGAxisPanel getBottomPanel()
	{
		return (SGAxisPanel)this.mBottomPanel.getComponent(0);
	}

	private SGAxisPanel getTopPanel()
	{
		return (SGAxisPanel)this.mTopPanel.getComponent(0);
	}

	private SGAxisPanel getLeftPanel()
	{
		return (SGAxisPanel)this.mLeftPanel.getComponent(0);
	}

	private SGAxisPanel getRightPanel()
	{
		return (SGAxisPanel)this.mRightPanel.getComponent(0);
	}



	/**
	 * 
	 * @return
	 */
	private boolean setFrameLineComponentsEnabled( final boolean b )
	{
		this.mFrameLineWidthLabel.setEnabled(b);
		this.mFrameLineWidthSpinner.setEnabled(b);
		this.mFrameLineColorLabel.setEnabled(b);
		this.mFrameColorButton.setEnabled(b);
		return true;
	}


	/**
	 * 
	 */
	public Number getAxisLineWidth()
	{
		return this.mAxisLineWidthSpinner.getNumber();
	}

	/**
	 * 
	 */
	public Number getScaleLineWidth()
	{
		return this.mScaleLineWidthSpinner.getNumber();
	}

	/**
	 * 
	 */
	public Number getScaleLineLength()
	{
		return this.mScaleLineLengthSpinner.getNumber();
	}

	/**
	 * 
	 */
	public Color getLineColor()
	{
		return this.mLineColorButton.getColor();
	}

	/**
	 * 
	 */
	public String getFontName()
	{
		return this.mFontNameComboBox.getSelectedItem().toString();
	}

	/**
	 * 
	 */
	public Number getFontSize()
	{
		return this.mFontSizeSpinner.getNumber();
	}

	/**
	 * 
	 */
	public int getFontStyle()
	{
		final String item = (String)this.mFontTypeComboBox.getSelectedItem();
		return SGUtilityText.getFontStyle(item);
	}

	/**
	 * 
	 */
	public Color getStringColor()
	{
		return this.mFontColorButton.getColor();
	}

	/**
	 * 
	 */
	public Boolean isFrameLinesVisible()
	{
		return this.mFrameVisibleCheckBox.getSelected();
	}

	/**
	 * 
	 */
	public Number getFrameLineWidth()
	{
		return this.mFrameLineWidthSpinner.getNumber();
	}

	/**
	 * 
	 */
	public Color getFrameLineColor()
	{
		return this.mFrameColorButton.getColor();
	}



	/**
	 * 
	 */
	public boolean setAxisLineWidth( final Object value )
	{
		return this.setValue( this.mAxisLineWidthSpinner, value );
	}


	/**
	 * 
	 */
	public boolean setScaleLineWidth( final Object value )
	{
		return this.setValue( this.mScaleLineWidthSpinner, value );
	}


	/**
	 * 
	 */
	public boolean setScaleLineLength( final Object value )
	{
		return this.setValue( this.mScaleLineLengthSpinner, value );
	}


	/**
	 * 
	 */
	public boolean setLineColor( final Color cl )
	{
		this.mLineColorButton.setColor( cl );
		return true;
	}


	/**
	 * 
	 */
	public boolean setFontName( final String name )
	{
		this.mFontNameComboBox.setSelectedItem( name );
		return true;
	}


	/**
	 * 
	 */
	public boolean setFontSize( final Object value )
	{
		return this.setValue( this.mFontSizeSpinner, value );
	}


	/**
	 * 
	 */
	public boolean setStringColor( final Color cl )
	{
		this.mFontColorButton.setColor( cl );
		return true;
	}


	/**
	 * 
	 */
	public boolean setFontStyle( final Integer style )
	{
		String styleName = null;
		if( style!=null )
		{
			styleName = SGUtilityText.getFontStyleName( style.intValue() );
		}
		this.mFontTypeComboBox.setSelectedItem( styleName );

		return true;
	}

	/**
	 * 
	 */
	public void setFrameVisible( final Boolean b )
	{
		this.mFrameVisibleCheckBox.setSelected( b );
		boolean flag = true;;
		if( b!=null )
		{
			flag = b.booleanValue();
		}
		this.setFrameLineComponentsEnabled( flag );
	}


	/**
	 * 
	 */
	public boolean setFrameLineWidth( final Object value )
	{
		return this.setValue( this.mFrameLineWidthSpinner, value );
	}


	/**
	 * 
	 */
	public boolean setFrameLineColor( final Color cl )
	{
		this.mFrameColorButton.setColor( cl );
		return true;
	}


	/**
	 * 
	 */
	public ArrayList getColorSelectionButtonsList()
	{
		final ArrayList list = new ArrayList();

		list.add( this.mLineColorButton );
		list.add( this.mFontColorButton );
		list.add( this.mFrameColorButton );

		return list;
	}


	/**
	 * 
	 */
	public ArrayList getTextFieldComponentsList()
	{
		final ArrayList list = this.getFormattedTextFieldsListFromSpinners();
		list.addAll( this.getBottomPanel().getTextFieldComponentsList() );
		list.addAll( this.getTopPanel().getTextFieldComponentsList() );
		list.addAll( this.getLeftPanel().getTextFieldComponentsList() );
		list.addAll( this.getRightPanel().getTextFieldComponentsList() );

		return list;
	}


	/**
	 * Returns a list of text fields to set number.
	 * @return
	 */
	public ArrayList getNumberTextFieldList()
	{
		ArrayList list = new ArrayList();
		list.addAll( this.getBottomPanel().getNumberTextFieldList() );
		list.addAll( this.getTopPanel().getNumberTextFieldList() );
		list.addAll( this.getLeftPanel().getNumberTextFieldList() );
		list.addAll( this.getRightPanel().getNumberTextFieldList() );
		return list;
	}


	/**
	 * 
	 */
	public ArrayList getSpinnerList()
	{
		ArrayList list = new ArrayList();

		list.add( this.mAxisLineWidthSpinner );
		list.add( this.mScaleLineWidthSpinner );
		list.add( this.mScaleLineLengthSpinner );
		list.add( this.mFontSizeSpinner );
		list.add( this.mFrameLineWidthSpinner );

		list.addAll( this.getBottomPanel().getSpinnerList() );
		list.addAll( this.getTopPanel().getSpinnerList() );
		list.addAll( this.getLeftPanel().getSpinnerList() );
		list.addAll( this.getRightPanel().getSpinnerList() );

		return list;
	}



	/**
	 * 
	 * @param panel
	 * @return
	 */
	public boolean setSelectedPanel( final SGAxisPanel panel )
	{
		Component[] array = this.mTabbedPane.getComponents();
		for( int ii=0; ii<array.length; ii++ )
		{
			JPanel p = (JPanel)array[ii];
			Component com = p.getComponent(0);
			if( com.equals(panel) )
			{
				this.mTabbedPane.setSelectedComponent(p);
				break;
			}
		}

		return true;
	}




	/**
	 * 
	 */
	public boolean setDialogProperty()
	{

		ArrayList list = this.mPropertyDialogObserverList;

		SGIAxisDialogObserver axes
			= (SGIAxisDialogObserver)list.get(0);

		final String fontName0 = axes.getFontName();
		final float fontSize0 = axes.getFontSize( pt );
		final int fontStyle0 = axes.getFontStyle();
		final Color stringColor0 = axes.getStringColor();

		final float frameLineWidth0 = axes.getFrameLineWidth( pt );
		final Color frameLineColor0 = axes.getFrameLineColor();
		final boolean frameLineVisible0 = axes.isFrameLineVisible();

		final float axisLineWidth0 = axes.getAxisLineWidth( pt );
		final float tickMarkWidth0 = axes.getTickMarkWidth( pt );
		final float tickMarkLength0 = axes.getTickMarkLength( cm );
		final Color lineColor0 = axes.getLineColor();

		String fontName = new String( fontName0 );
		Float fontSize = new Float( fontSize0 );
		Integer fontStyle = new Integer( fontStyle0 );
		Color stringColor = stringColor0;

		Float frameLineWidth = new Float( frameLineWidth0 );
		Color frameLineColor = frameLineColor0;
		Boolean frameLineVisible = Boolean.valueOf( frameLineVisible0 );

		Float axisLineWidth = new Float( axisLineWidth0 );
		Float tickMarkWidth = new Float( tickMarkWidth0 );
		Float tickMarkLength = new Float( tickMarkLength0 );
		Color lineColor = lineColor0;


		if( list.size() > 1 )
		{
			for( int ii=1; ii<list.size(); ii++ )
			{
				SGIAxisDialogObserver legend1
					= (SGIAxisDialogObserver)list.get(ii);

				final String fontName1 = legend1.getFontName();
				if( fontName0.equals(fontName1) == false )
				{
					fontName = null;
					break;
				}
			}

			for( int ii=1; ii<list.size(); ii++ )
			{
				SGIAxisDialogObserver legend1
					= (SGIAxisDialogObserver)list.get(ii);

				final float fontSize1 = legend1.getFontSize( pt );
				if( fontSize0!=fontSize1 )
				{
					fontSize = null;
					break;
				}
			}

			for( int ii=1; ii<list.size(); ii++ )
			{
				SGIAxisDialogObserver legend1
					= (SGIAxisDialogObserver)list.get(ii);

				final int fontStyle1 = legend1.getFontStyle();
				if( fontStyle0!=fontStyle1 )
				{
					fontStyle = null;
					break;
				}
			}

			for( int ii=1; ii<list.size(); ii++ )
			{
				SGIAxisDialogObserver legend1
					= (SGIAxisDialogObserver)list.get(ii);

				final Color stringColor1 = legend1.getStringColor();
				if( stringColor.equals(stringColor1) == false )
				{
					stringColor = null;
					break;
				}
			}

			for( int ii=1; ii<list.size(); ii++ )
			{
				SGIAxisDialogObserver legend1
					= (SGIAxisDialogObserver)list.get(ii);

				final boolean frameLineVisible1 = legend1.isFrameLineVisible();
				if( frameLineVisible0!=frameLineVisible1 )
				{
					frameLineVisible = null;
					break;
				}
			}

			for( int ii=1; ii<list.size(); ii++ )
			{
				SGIAxisDialogObserver legend1
					= (SGIAxisDialogObserver)list.get(ii);

				final float frameLineWidth1 = legend1.getFrameLineWidth( pt );
				if( frameLineWidth0!=frameLineWidth1 )
				{
					frameLineWidth = null;
					break;
				}
			}

			for( int ii=1; ii<list.size(); ii++ )
			{
				SGIAxisDialogObserver legend1
					= (SGIAxisDialogObserver)list.get(ii);

				final Color frameLineColor1 = legend1.getFrameLineColor();
				if( frameLineColor.equals(frameLineColor1) == false )
				{
					frameLineColor = null;
					break;
				}
			}

			for( int ii=1; ii<list.size(); ii++ )
			{
				SGIAxisDialogObserver legend1
					= (SGIAxisDialogObserver)list.get(ii);

				final float axisLineWidth1 = legend1.getAxisLineWidth( pt );
				if( axisLineWidth0!=axisLineWidth1 )
				{
					axisLineWidth = null;
					break;
				}
			}

			for( int ii=1; ii<list.size(); ii++ )
			{
				SGIAxisDialogObserver legend1
					= (SGIAxisDialogObserver)list.get(ii);

				final float tickMarkWidth1 = legend1.getTickMarkWidth( pt );
				if( tickMarkWidth0!=tickMarkWidth1 )
				{
					tickMarkWidth = null;
					break;
				}
			}

			for( int ii=1; ii<list.size(); ii++ )
			{
				SGIAxisDialogObserver legend1
					= (SGIAxisDialogObserver)list.get(ii);

				final float tickMarkLength1 = legend1.getTickMarkLength( cm );
				if( tickMarkLength0!=tickMarkLength1 )
				{
					tickMarkLength = null;
					break;
				}
			}

			for( int ii=1; ii<list.size(); ii++ )
			{
				SGIAxisDialogObserver legend1
					= (SGIAxisDialogObserver)list.get(ii);

				final Color lineColor1 = legend1.getLineColor();
				if( lineColor.equals(lineColor1) == false )
				{
					lineColor = null;
					break;
				}
			}

		}


		//
		this.setFontName( fontName );
		this.setFontSize( fontSize );
		this.setFontStyle( fontStyle );
		this.setStringColor( stringColor );
		
		this.setFrameVisible( frameLineVisible );
		this.setFrameLineWidth( frameLineWidth );
		this.setFrameLineColor( frameLineColor );
		
		this.setAxisLineWidth( axisLineWidth );
		this.setScaleLineWidth( tickMarkWidth );

//		if( tickMarkLength!=null )
//		{
//			tickMarkLength = new Float( tickMarkLength.floatValue()*SGIConstants.CM_POINT_RATIO );
//		}
		this.setScaleLineLength( tickMarkLength );
		this.setLineColor( lineColor );



		//
		ArrayList bottomList = new ArrayList();
		ArrayList topList = new ArrayList();
		ArrayList leftList = new ArrayList();
		ArrayList rightList = new ArrayList();
		for( int ii=0; ii<list.size(); ii++ )
		{
			SGIAxisDialogObserver obs = (SGIAxisDialogObserver)list.get(ii);
			SGIAxisPanelObserver bottom
				= obs.getAxisPanelObserverInPlane( SGIAxisElement.AXIS_HORIZONTAL_1 );
			SGIAxisPanelObserver top
				= obs.getAxisPanelObserverInPlane( SGIAxisElement.AXIS_HORIZONTAL_2 );
			SGIAxisPanelObserver left
				= obs.getAxisPanelObserverInPlane( SGIAxisElement.AXIS_PERPENDICULAR_1 );
			SGIAxisPanelObserver right
				= obs.getAxisPanelObserverInPlane( SGIAxisElement.AXIS_PERPENDICULAR_2 );
			bottomList.add( bottom );
			topList.add( top );
			leftList.add( left );
			rightList.add( right );
		}


		SGAxisPanel bottomPanel = this.getBottomPanel();
		SGAxisPanel topPanel = this.getTopPanel();
		SGAxisPanel leftPanel = this.getLeftPanel();
		SGAxisPanel rightPanel = this.getRightPanel();
		bottomPanel.setComponentsProperty( bottomList );
		topPanel.setComponentsProperty( topList );
		leftPanel.setComponentsProperty( leftList );
		rightPanel.setComponentsProperty( rightList );


		// get clicked object index
		int config = -1;
		for( int ii=0; ii<list.size(); ii++ )
		{
			SGIAxisDialogObserver l
				= (SGIAxisDialogObserver)list.get(ii);
			final int num = l.getAxisConfigurationForSelectedTab();
			if( num!=-1 )
			{
				config = num;
				break;
			}
		}

		if( config==-1 )
		{
			config = SGIAxisElement.AXIS_HORIZONTAL_1;
		}

		Component com = null;
		switch( config )
		{
			case SGIAxisElement.AXIS_HORIZONTAL_1 :
			{
				com = this.mBottomPanel;
				break;
			}

			case SGIAxisElement.AXIS_HORIZONTAL_2 :
			{
				com = this.mTopPanel;
				break;
			}

			case SGIAxisElement.AXIS_PERPENDICULAR_1 :
			{
				com = this.mLeftPanel;
				break;
			}

			case SGIAxisElement.AXIS_PERPENDICULAR_2 :
			{
				com = this.mRightPanel;
				break;
			}
		}
		this.mTabbedPane.setSelectedComponent( com );


		this.setColorButtonBorder(true);

		return true;
	}




	/**
	 * Set properties to all listeners.
	 * @param l
	 * @return
	 */
	public boolean setPropertiesToListeners( SGIPropertyDialogObserver l )
	{

		SGIAxisDialogObserver obs = (SGIAxisDialogObserver)l;

		final String fontName = this.getFontName();
		if( fontName!=null )
		{
			obs.setFontName( fontName );
		}

		final int fontStyle = this.getFontStyle();
		if( fontStyle!=-1 )
		{
			obs.setFontStyle( fontStyle );
		}
		
		final Number fontSize = this.getFontSize();
		if( fontSize!=null )
		{
			obs.setFontSize( fontSize.floatValue() );
		}

		final Color stringColor = this.getStringColor();
		if( stringColor!=null )
		{
			obs.setStringColor( stringColor );
		}
		
		final Boolean frameVisible = this.isFrameLinesVisible();
		if( frameVisible!=null )
		{
			obs.setFrameVisible( frameVisible.booleanValue() );
		}

		final Number frameLineWidth = this.getFrameLineWidth();
		if( frameLineWidth!=null )
		{
			obs.setFrameLineWidth( frameLineWidth.floatValue(), pt );
		}

		final Color frameLineColor = this.getFrameLineColor();
		if( frameLineColor!=null )
		{
			obs.setFrameLineColor( frameLineColor );
		}

		final Number axisLineWidth = this.getAxisLineWidth();
		if( axisLineWidth!=null )
		{
			obs.setAxisLineWidth( axisLineWidth.floatValue(), pt );
		}
		
		final Number tickMarkWidth = this.getScaleLineWidth();
		if( tickMarkWidth!=null )
		{
			obs.setTickMarkWidth( tickMarkWidth.floatValue(), pt );
		}

		final Number tickMarkLength = this.getScaleLineLength();
		if( tickMarkLength!=null )
		{
			obs.setTickMarkLength( tickMarkLength.floatValue(), cm );
		}

		final Color lineColor = this.getLineColor();
		if( lineColor!=null )
		{
			obs.setLineColor( lineColor );
		}



		//
		// set properties from AxisPanel
		//

		SGIAxisPanelObserver bottom
			= obs.getAxisPanelObserverInPlane( SGIAxisElement.AXIS_HORIZONTAL_1 );

		SGIAxisPanelObserver top
			= obs.getAxisPanelObserverInPlane( SGIAxisElement.AXIS_HORIZONTAL_2 );

		SGIAxisPanelObserver left
			= obs.getAxisPanelObserverInPlane( SGIAxisElement.AXIS_PERPENDICULAR_1 );

		SGIAxisPanelObserver right
			= obs.getAxisPanelObserverInPlane( SGIAxisElement.AXIS_PERPENDICULAR_2 );

		if( this.setPropertiesToListeners( bottom, this.getBottomPanel() ) == false )
		{
			return false;
		}

		if( this.setPropertiesToListeners( top, this.getTopPanel() ) == false )
		{
			return false;
		}

		if( this.setPropertiesToListeners( left, this.getLeftPanel() ) == false )
		{
			return false;
		}

		if( this.setPropertiesToListeners( right, this.getRightPanel() ) == false )
		{
			return false;
		}

		return true;
	}


	private boolean setPropertiesToListeners( SGIAxisPanelObserver l, SGAxisPanel p )
	{
		if( p.setPropertiesToListeners(l) == false )
		{
			final String msg = p.getInputErrorMessage();
			if( msg!=null )
			{
				this.setInputErrorMessage( msg );
			}
			return false;
		}
		return true;
	}


	/**
	 * 
	 */
	protected boolean hasValidInputValues()
	{
		if( super.hasValidInputValues() == false )
		{
			return false;
		}

		if( this.getBottomPanel().hasValidInputValues() == false )
		{
			return false;
		}

		if( this.getTopPanel().hasValidInputValues() == false )
		{
			return false;
		}

		if( this.getLeftPanel().hasValidInputValues() == false )
		{
			return false;
		}

		if( this.getRightPanel().hasValidInputValues() == false )
		{
			return false;
		}

		return true;
	}

}

