
package jp.riken.brain.ni.samuraigraph.figure;

import jp.riken.brain.ni.samuraigraph.base.SGDrawingElement;
import jp.riken.brain.ni.samuraigraph.base.SGIDrawingElementConstants;
import jp.riken.brain.ni.samuraigraph.base.SGProperties;


/**
 *
 */
public abstract class SGDrawingElementBar extends SGDrawingElementRectangle
	implements SGIBarConstants, SGIDrawingElementConstants
{

	/**
	 * The axis value of baseline.
	 */
	protected double mBaselineValue;


	/**
	 * The axis value of width of bar.
	 */
	protected double mWidthValue;


	/**
	 * A flag whether this bar is horizontal.
	 */
	protected boolean mHorizontalFlag = false;


	/**
	 * 
	 */
	public SGDrawingElementBar()
	{
		super();
	}


	/**
	 * 
	 */
	public double getBaselineValue()
	{
		return this.mBaselineValue;
	}


	/**
	 * 
	 */
	public boolean setBaselineValue( final double value )
	{
		this.mBaselineValue = value;
		return true;
	}


	/**
	 * @return
	 */
	public double getWidthValue()
	{
		return this.mWidthValue;
	}


	/**
	 * @param d
	 */
	public void setWidthValue( final double d )
	{
		this.mWidthValue = d;
	}


	/**
	 * @return
	 */
	public boolean isHorizontal()
	{
		return mHorizontalFlag;
	}


	/**
	 * @param b
	 */
	public void setHorizontal( boolean b )
	{
		mHorizontalFlag = b;
	}


	/**
	 * 
	 */
	public boolean setProperty( final SGDrawingElement element )
	{
		if( !(element instanceof SGDrawingElementBar) )
		{
			return false;
		}

		if( super.setProperty( element ) == false )
		{
			return false;
		}

		SGDrawingElementBar bar = (SGDrawingElementBar)element;
		this.setBaselineValue( bar.getBaselineValue() );
		this.setBaselineValue( bar.getWidthValue() );

		return true;
	}


	/**
	 * 
	 */
	public SGProperties getProperties()
	{
		BarProperties p = new BarProperties();
		this.getProperties(p);
		return p;
	}


	/**
	 * 
	 */
	public boolean getProperties( SGProperties p )
	{
		if( p==null ) return false;
		if( ( p instanceof BarProperties ) == false ) return false;

		super.getProperties(p);

		BarProperties bp = (BarProperties)p;
		bp.setBaselineValue( this.getBaselineValue() );
		bp.setWidthValue( this.getWidthValue() );

		return true;
	}



	/**
	 * 
	 */
	public static class BarProperties extends RectangleProperties
	{
		private double mBaselineValue;

		private double mWidthValue;

		/**
		 * 
		 */
		public BarProperties()
		{
			super();
		}


		/**
		 * 
		 */
		public boolean equals( final Object obj )
		{
			if( ( obj instanceof BarProperties ) == false )
			{
				return false;
			}

			if( super.equals(obj) == false ) return false;

			BarProperties p = (BarProperties)obj;
			if( this.mBaselineValue!=p.mBaselineValue ) return false;
			if( this.mWidthValue!=p.mWidthValue ) return false;

			return true;
		}

		public Double getBaselineValue()
		{
			return new Double( this.mBaselineValue );
		}

		public boolean setBaselineValue( final double value )
		{
			this.mBaselineValue = value;
			return true;
		}

		public Double getWidthValue()
		{
			return new Double( this.mWidthValue );
		}

		public boolean setWidthValue( final double value )
		{
			this.mWidthValue = value;
			return true;
		}

	}

}

