
package jp.riken.brain.ni.samuraigraph.base;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;

import javax.swing.JPanel;


/**
 * A panel class holding an Image object.
 */
public class SGImagePanel extends JPanel implements SGIDisposable
{

	/**
	 * An image object.
	 */
	private Image mImage = null;


	/**
	 * Location of the image.
	 */
	private Point mLocation = null;


	/**
	 * Size of the image.
	 */
	private Dimension mSize = null;


	/**
	 *  
	 *
	 */
	public SGImagePanel()
	{
		super();
	}


	/**
	 * 
	 * @param image
	 */
	public SGImagePanel( Image image )
	{
		super();
		this.setImage(image);
	}


	/**
	 * 
	 * @param image
	 */
	public SGImagePanel( Image image, final int x, final int y, final int w, final int h )
	{
		super();
		this.setImage(image);
		this.setImageBounds(x,y,w,h);
	}


	/**
	 * 
	 */
	public void dispose()
	{
		this.mImage = null;
		this.mLocation = null;
		this.mSize = null;
	}


	/**
	 * 
	 * @param x
	 * @param y
	 */
	public void setImageLocation( final int x, final int y )
	{
		this.mLocation = new Point(x,y);
	}


	/**
	 * 
	 * @param w
	 * @param h
	 */
	public void setImageSize( final int w, final int h )
	{
		this.mSize = new Dimension(w,h);
	}


	/**
	 * 
	 * @param x
	 * @param y
	 * @param w
	 * @param h
	 */
	public void setImageBounds( final int x, final int y, final int w, final int h )
	{
		this.setImageLocation(x,y);
		this.setImageSize(w,h);
	}


	/**
	 * 
	 * @return
	 */
	public Point getImageLocation()
	{
		if( this.mLocation!=null )
		{
			return new Point( this.mLocation );
		}
		else
		{
			return new Point();
		}
	}


	/**
	 * 
	 * @return
	 */
	public Dimension getImageSize()
	{
		if( this.mSize!=null )
		{
			return new Dimension( this.mSize );
		}
		else
		{
			return new Dimension( this.getWidth(), this.getHeight() );
		}
	}


	/**
	 * 
	 * @param image
	 */
	public void setImage( final Image image )
	{
		this.mImage = image;
	}



	/**
	 * Returns the image.
	 * @return
	 */
	public Image getImage()
	{
		return this.mImage;
	}


	/**
	 * 
	 */
	public void paintComponent( Graphics g )
	{
		if( mImage == null )
		{
			return;
		}
		
		super.paintComponent(g);

		int width;
		int height;
		if( this.mSize!=null )
		{
			width = this.mSize.width;
			height = this.mSize.height;
		}
		else
		{
			width = mImage.getWidth( this );
			height = mImage.getHeight( this );
		}

		int x;
		int y;
		if( this.mLocation!=null )
		{
			x = this.mLocation.x;
			y = this.mLocation.y;
		}
		else
		{
			x = 0;
			y = 0;
		}

		g.drawImage( this.mImage, x, y, width, height, this );

	}


}
