
package jp.riken.brain.ni.samuraigraph.base;

/**
 * The base class of all data classes.
 */

public abstract class SGData implements SGIData, SGICopiable, SGIDisposable
{

	/**
	 * Default constructor.
	 *
	 */
	public SGData()
	{
		super();
	}


	public void finalize()
	{
//		System.out.println("finalize:"+this);
	}


	/**
	 * Set values in given data.
	 * @param data
	 * @return
	 */
	public abstract boolean setData( final SGData data );



	/**
	 * 
	 */
	public void dispose()
	{
	}


	/**
	 * 
	 * @param array
	 * @return
	 */
	protected String toDoubleArrayString( double[] array )
	{
		if( array==null )
		{
			return "null";
		}

		String str = "{";
		for( int ii=0; ii<array.length; ii++ )
		{
			str += Double.toString( array[ii] );
			if( ii==array.length-1 )
			{
				break;
			}
			str += ",";
		}
		str += "}";
		return str;
	}


}
