/*
 * Decompiled with CFR 0.152.
 */
package jp.riken.brain.ni.samuraigraph.figure.java2d;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import javax.swing.JLabel;
import javax.swing.JPopupMenu;
import jp.riken.brain.ni.samuraigraph.base.SGAxis;
import jp.riken.brain.ni.samuraigraph.base.SGData;
import jp.riken.brain.ni.samuraigraph.base.SGDefaultValues;
import jp.riken.brain.ni.samuraigraph.base.SGDrawingElement;
import jp.riken.brain.ni.samuraigraph.base.SGIAxisElement;
import jp.riken.brain.ni.samuraigraph.base.SGILegendElement;
import jp.riken.brain.ni.samuraigraph.base.SGIVisible;
import jp.riken.brain.ni.samuraigraph.base.SGProperties;
import jp.riken.brain.ni.samuraigraph.base.SGPropertyDialog;
import jp.riken.brain.ni.samuraigraph.base.SGTuple2d;
import jp.riken.brain.ni.samuraigraph.base.SGTuple2f;
import jp.riken.brain.ni.samuraigraph.base.SGUtility;
import jp.riken.brain.ni.samuraigraph.base.SGUtilityText;
import jp.riken.brain.ni.samuraigraph.data.SGISXYTypeData;
import jp.riken.brain.ni.samuraigraph.data.SGISXYTypeMultipleData;
import jp.riken.brain.ni.samuraigraph.data.SGSXYSamplingData;
import jp.riken.brain.ni.samuraigraph.figure.SGDrawingElementBar;
import jp.riken.brain.ni.samuraigraph.figure.SGDrawingElementErrorBar;
import jp.riken.brain.ni.samuraigraph.figure.SGDrawingElementLine;
import jp.riken.brain.ni.samuraigraph.figure.SGDrawingElementString;
import jp.riken.brain.ni.samuraigraph.figure.SGDrawingElementSymbol;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGDrawingElementBar2D;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGDrawingElementString2DExtended;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGDrawingElementSymbol2D;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGElementGroup;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGElementGroupBar;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGElementGroupErrorBar;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGElementGroupLine;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGElementGroupSXY;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGElementGroupSet;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGElementGroupSymbol;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGElementGroupTickLabel;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGGraphElement;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGISXYDataDialogObserver;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGPropertyDialogSXYData;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGUtilityForFigureElement;
import jp.riken.brain.ni.samuraigraph.figure.java2d.SGUtilityJava2D;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class SGSXYGraphElement
extends SGGraphElement {
    protected boolean createDataDialog() {
        SGPropertyDialogSXYData sGPropertyDialogSXYData = new SGPropertyDialogSXYData(this.mDialogOwner, true);
        this.mDialog = sGPropertyDialogSXYData;
        return true;
    }

    public String getClassDescription() {
        return "SXY Graph";
    }

    public boolean addData(SGData sGData, String string) {
        if (!(sGData instanceof SGISXYTypeData) & !(sGData instanceof SGISXYTypeMultipleData)) {
            return false;
        }
        if (!super.addData(sGData, string)) {
            return false;
        }
        SGGraphElement.ElementGroupSetInGraph elementGroupSetInGraph = this.createGroupSet(sGData, string);
        if (elementGroupSetInGraph == null) {
            return false;
        }
        elementGroupSetInGraph.initPropertiesHistory();
        if (this.mDialog == null) {
            this.createDataDialog();
        }
        this.setChanged(true);
        this.notifyToRoot();
        return true;
    }

    public boolean addData(SGData sGData, String string, SGProperties sGProperties) {
        if (!(sGData instanceof SGISXYTypeData) & !(sGData instanceof SGISXYTypeMultipleData)) {
            return false;
        }
        if (!super.addData(sGData, string)) {
            return false;
        }
        SGGraphElement.ElementGroupSetInGraph elementGroupSetInGraph = this.createGroupSet(sGData, string);
        if (elementGroupSetInGraph == null) {
            return false;
        }
        if (!elementGroupSetInGraph.setWholeProperties(sGProperties)) {
            return false;
        }
        elementGroupSetInGraph.setVisible(true);
        elementGroupSetInGraph.setName(string);
        elementGroupSetInGraph.initPropertiesHistory();
        if (this.mDialog == null) {
            this.createDataDialog();
        }
        this.setChanged(true);
        this.notifyToRoot();
        return true;
    }

    private SGGraphElement.ElementGroupSetInGraph createGroupSet(SGData sGData, String string) {
        SGAxis sGAxis = this.mAxisElement.getAxisInPlane(0);
        SGAxis sGAxis2 = this.mAxisElement.getAxisInPlane(1);
        SGAxis sGAxis3 = this.mAxisElement.getAxisInPlane(2);
        SGAxis sGAxis4 = this.mAxisElement.getAxisInPlane(3);
        SGAxis sGAxis5 = null;
        SGAxis sGAxis6 = null;
        if ("Left-Bottom".equals("Left-Bottom")) {
            sGAxis5 = sGAxis;
            sGAxis6 = sGAxis3;
        } else if ("Left-Bottom".equals("Left-Top")) {
            sGAxis5 = sGAxis2;
            sGAxis6 = sGAxis3;
        } else if ("Left-Bottom".equals("Right-Bottom")) {
            sGAxis5 = sGAxis;
            sGAxis6 = sGAxis4;
        } else if ("Left-Bottom".equals("Right-Top")) {
            sGAxis5 = sGAxis2;
            sGAxis6 = sGAxis4;
        } else {
            return null;
        }
        SGGraphElement.ElementGroupSetInGraph elementGroupSetInGraph = null;
        if (sGData instanceof SGISXYTypeData) {
            elementGroupSetInGraph = this.createSingleGroupSet((SGISXYTypeData)((Object)sGData), sGAxis5, sGAxis6, string);
        } else if (sGData instanceof SGISXYTypeMultipleData) {
            elementGroupSetInGraph = this.createMultipleGroupSet((SGISXYTypeMultipleData)((Object)sGData), sGAxis5, sGAxis6, string);
        } else {
            return null;
        }
        this.mChildList.add(elementGroupSetInGraph);
        return elementGroupSetInGraph;
    }

    private SGGraphElement.ElementGroupSetForMultipleData createMultipleGroupSet(SGISXYTypeMultipleData sGISXYTypeMultipleData, SGAxis sGAxis, SGAxis sGAxis2, String string) {
        ElementGroupSetForMultipleDataInSXYGraph elementGroupSetForMultipleDataInSXYGraph = new ElementGroupSetForMultipleDataInSXYGraph();
        elementGroupSetForMultipleDataInSXYGraph.setName(string);
        elementGroupSetForMultipleDataInSXYGraph.setXAxis(sGAxis);
        elementGroupSetForMultipleDataInSXYGraph.setYAxis(sGAxis2);
        SGISXYTypeData[] sGISXYTypeDataArray = sGISXYTypeMultipleData.getSXYDataArray();
        for (int i = 0; i < sGISXYTypeDataArray.length; ++i) {
            ElementGroupSetInSXYGraph elementGroupSetInSXYGraph = this.createGroupSetSXYInstance(sGISXYTypeDataArray[i], sGAxis, sGAxis2);
            elementGroupSetInSXYGraph.setName(string);
            elementGroupSetInSXYGraph.initPropertiesHistory();
            elementGroupSetForMultipleDataInSXYGraph.mElementGroupSetList.add(elementGroupSetInSXYGraph);
        }
        return elementGroupSetForMultipleDataInSXYGraph;
    }

    private ElementGroupSetInSXYGraph createSingleGroupSet(SGISXYTypeData sGISXYTypeData, SGAxis sGAxis, SGAxis sGAxis2, String string) {
        ElementGroupSetInSXYGraph elementGroupSetInSXYGraph = this.createGroupSetSXYInstance(sGISXYTypeData, sGAxis, sGAxis2);
        elementGroupSetInSXYGraph.setName(string);
        return elementGroupSetInSXYGraph;
    }

    private ElementGroupSetInSXYGraph createGroupSetSXYInstance(SGISXYTypeData sGISXYTypeData, SGAxis sGAxis, SGAxis sGAxis2) {
        ElementGroupTickLabels elementGroupTickLabels;
        ElementGroupErrorBar elementGroupErrorBar;
        ElementGroupSetInSXYGraph elementGroupSetInSXYGraph = new ElementGroupSetInSXYGraph();
        elementGroupSetInSXYGraph.setXAxis(sGAxis);
        elementGroupSetInSXYGraph.setYAxis(sGAxis2);
        int n = sGISXYTypeData.getPointsNumber();
        SGTuple2f[] sGTuple2fArray = new SGTuple2f[n];
        for (int i = 0; i < n; ++i) {
            sGTuple2fArray[i] = new SGTuple2f();
        }
        ElementGroupSetInSXYGraph.access$002(elementGroupSetInSXYGraph, sGTuple2fArray);
        if (!elementGroupSetInSXYGraph.addDrawingElementGroup(2)) {
            return null;
        }
        double[] dArray = sGISXYTypeData.getXValueArray();
        double d = Double.MAX_VALUE;
        for (int i = 0; i < dArray.length - 1; ++i) {
            double d2 = Math.abs(dArray[i + 1] - dArray[i]);
            if (!(d2 < d)) continue;
            d = d2;
        }
        d = this.getNumberInRangeOrder(d, sGAxis);
        ElementGroupBar elementGroupBar = (ElementGroupBar)elementGroupSetInSXYGraph.getBarGroup();
        elementGroupBar.setWidthValue(d);
        if (sGISXYTypeData.isErrorValueHolding() && !(elementGroupErrorBar = elementGroupSetInSXYGraph.createErrorBars(sGISXYTypeData)).setPropertiesOfDrawingElements()) {
            return null;
        }
        if (!elementGroupSetInSXYGraph.addDrawingElementGroup(0)) {
            return null;
        }
        if (!elementGroupSetInSXYGraph.addDrawingElementGroup(1)) {
            return null;
        }
        if (sGISXYTypeData.isStringArrayHolding() && !(elementGroupTickLabels = elementGroupSetInSXYGraph.createTickLabels(sGISXYTypeData)).setPropertiesOfDrawingElements()) {
            return null;
        }
        if (!elementGroupSetInSXYGraph.setDrawingElementsLocation((SGData)((Object)sGISXYTypeData))) {
            return null;
        }
        elementGroupSetInSXYGraph.setMagnification(this.getMagnification());
        return elementGroupSetInSXYGraph;
    }

    private JPopupMenu createGroupSetPopupMenu(SGGraphElement.ElementGroupSetInGraph elementGroupSetInGraph) {
        JPopupMenu jPopupMenu = new JPopupMenu();
        jPopupMenu.setBounds(0, 0, 100, 100);
        jPopupMenu.add(new JLabel("  -- Data --"));
        jPopupMenu.addSeparator();
        SGUtility.addItem(jPopupMenu, elementGroupSetInGraph, "Move to Front");
        SGUtility.addItem(jPopupMenu, elementGroupSetInGraph, "Move to Back");
        jPopupMenu.addSeparator();
        SGUtility.addItem(jPopupMenu, elementGroupSetInGraph, "Cut");
        SGUtility.addItem(jPopupMenu, elementGroupSetInGraph, "Copy");
        SGUtility.addItem(jPopupMenu, elementGroupSetInGraph, "Paste");
        jPopupMenu.addSeparator();
        SGUtility.addItem(jPopupMenu, elementGroupSetInGraph, "Delete");
        jPopupMenu.addSeparator();
        SGUtility.addItem(jPopupMenu, elementGroupSetInGraph, "Property");
        return jPopupMenu;
    }

    protected boolean synchronizeToLegendElement(SGILegendElement sGILegendElement) {
        boolean bl = super.synchronizeToLegendElement(sGILegendElement);
        if (!bl) {
            return bl;
        }
        ArrayList arrayList = new ArrayList(this.mDataList);
        ArrayList arrayList2 = new ArrayList(this.mChildList);
        for (int i = arrayList.size() - 1; i >= 0; --i) {
            boolean bl2;
            String string;
            SGData sGData = (SGData)arrayList.get(i);
            SGGraphElement.ElementGroupSetInGraph elementGroupSetInGraph = (SGGraphElement.ElementGroupSetInGraph)arrayList2.get(i);
            boolean bl3 = false;
            String string2 = sGILegendElement.getDataName(sGData);
            if (!string2.equals(string = elementGroupSetInGraph.getName())) {
                elementGroupSetInGraph.setChanged(true);
            }
            elementGroupSetInGraph.setName(string2);
            SGAxis sGAxis = sGILegendElement.getXAxis(sGData);
            if (sGAxis != null & elementGroupSetInGraph.getXAxis() != null && !sGAxis.equals(elementGroupSetInGraph.getXAxis())) {
                elementGroupSetInGraph.setChanged(true);
            }
            elementGroupSetInGraph.setXAxis(sGAxis);
            SGAxis sGAxis2 = sGILegendElement.getYAxis(sGData);
            if (sGAxis2 != null & elementGroupSetInGraph.getYAxis() != null && !sGAxis2.equals(elementGroupSetInGraph.getYAxis())) {
                elementGroupSetInGraph.setChanged(true);
            }
            elementGroupSetInGraph.setYAxis(sGAxis2);
            SGAxis sGAxis3 = sGILegendElement.getZAxis(sGData);
            if (sGAxis3 != null & elementGroupSetInGraph.mZAxis != null) {
                if (!sGAxis3.equals(elementGroupSetInGraph.mZAxis)) {
                    elementGroupSetInGraph.setChanged(true);
                }
                elementGroupSetInGraph.setZAxis(sGAxis3);
            }
            if ((bl2 = sGILegendElement.isDataVisible(sGData)) != elementGroupSetInGraph.isVisible()) {
                this.setChanged(true);
            }
            elementGroupSetInGraph.setVisible(bl2);
            ArrayList arrayList3 = sGILegendElement.getDrawingElementList(sGData);
            boolean bl4 = ((IElementGroupSetInSXYGraph)((Object)elementGroupSetInGraph)).synchronizeDrawingElement(arrayList3);
            if (bl4) {
                bl3 = true;
            }
            if (!bl3) continue;
            elementGroupSetInGraph.setChanged(true);
        }
        this.setAllDrawingElementsLocation();
        this.updateImage();
        return bl;
    }

    protected boolean synchronizeToAxisElement(SGIAxisElement sGIAxisElement) {
        if (!super.synchronizeToAxisElement(sGIAxisElement)) {
            return false;
        }
        this.notifyChange();
        return true;
    }

    public void paintGraphics(Graphics graphics, boolean bl) {
        SGElementGroupSet sGElementGroupSet;
        int n;
        Graphics2D graphics2D = (Graphics2D)graphics;
        ArrayList arrayList = this.mChildList;
        for (n = 0; n < arrayList.size(); ++n) {
            sGElementGroupSet = (SGElementGroupSet)arrayList.get(n);
            if (!sGElementGroupSet.isVisible()) continue;
            IElementGroupSetInSXYGraph iElementGroupSetInSXYGraph = (IElementGroupSetInSXYGraph)((Object)sGElementGroupSet);
            iElementGroupSetInSXYGraph.paintDataString(graphics2D);
        }
        if (bl) {
            SGUtilityForFigureElement.clipGraphRect(this, graphics2D);
        }
        for (n = 0; n < arrayList.size(); ++n) {
            sGElementGroupSet = (SGGraphElement.ElementGroupSetInGraph)arrayList.get(n);
            if (!sGElementGroupSet.isVisible()) continue;
            ((SGGraphElement.ElementGroupSetInGraph)sGElementGroupSet).setClipFlag(bl);
            sGElementGroupSet.paintGraphics2D(graphics2D);
        }
        if (bl) {
            graphics2D.setClip(this.getViewBounds());
        }
    }

    private ElementGroupLine getGroupLine(ElementGroupSetInSXYGraph elementGroupSetInSXYGraph) {
        ArrayList arrayList = elementGroupSetInSXYGraph.mDrawingElementGroupList;
        for (int i = 0; i < arrayList.size(); ++i) {
            SGElementGroup sGElementGroup = (SGElementGroup)arrayList.get(i);
            if (!(sGElementGroup instanceof ElementGroupLine)) continue;
            return (ElementGroupLine)sGElementGroup;
        }
        return null;
    }

    private ElementGroupBar getGroupBar(ElementGroupSetInSXYGraph elementGroupSetInSXYGraph) {
        ArrayList arrayList = elementGroupSetInSXYGraph.mDrawingElementGroupList;
        for (int i = 0; i < arrayList.size(); ++i) {
            SGElementGroup sGElementGroup = (SGElementGroup)arrayList.get(i);
            if (!(sGElementGroup instanceof ElementGroupBar)) continue;
            return (ElementGroupBar)sGElementGroup;
        }
        return null;
    }

    private ElementGroupSymbol getGroupSymbol(ElementGroupSetInSXYGraph elementGroupSetInSXYGraph) {
        ArrayList arrayList = elementGroupSetInSXYGraph.mDrawingElementGroupList;
        for (int i = 0; i < arrayList.size(); ++i) {
            SGElementGroup sGElementGroup = (SGElementGroup)arrayList.get(i);
            if (!(sGElementGroup instanceof ElementGroupSymbol)) continue;
            return (ElementGroupSymbol)sGElementGroup;
        }
        return null;
    }

    public boolean getMarginAroundGraphRect(SGTuple2f sGTuple2f, SGTuple2f sGTuple2f2) {
        if (!super.getMarginAroundGraphRect(sGTuple2f, sGTuple2f2)) {
            return false;
        }
        ArrayList<Rectangle2D> arrayList = new ArrayList<Rectangle2D>();
        for (int i = 0; i < this.mChildList.size(); ++i) {
            SGData sGData;
            SGGraphElement.ElementGroupSetInGraph elementGroupSetInGraph = (SGGraphElement.ElementGroupSetInGraph)this.mChildList.get(i);
            Rectangle2D rectangle2D = ((IElementGroupSetInSXYGraph)((Object)elementGroupSetInGraph)).getTickLabelsBoundingBox(sGData = this.getData(elementGroupSetInGraph));
            if (rectangle2D == null) {
                return false;
            }
            if (rectangle2D.getWidth() < Double.MIN_VALUE || rectangle2D.getHeight() < Double.MIN_VALUE) continue;
            arrayList.add(rectangle2D);
        }
        if (arrayList.size() == 0) {
            return true;
        }
        Rectangle2D rectangle2D = SGUtility.createUnion(arrayList);
        float f = this.mGraphRectY - (float)rectangle2D.getY();
        float f2 = -(this.mGraphRectY + this.mGraphRectHeight) + (float)(rectangle2D.getY() + rectangle2D.getHeight());
        float f3 = this.mGraphRectX - (float)rectangle2D.getX();
        float f4 = -(this.mGraphRectX + this.mGraphRectWidth) + (float)(rectangle2D.getX() + rectangle2D.getWidth());
        sGTuple2f.x += f;
        sGTuple2f.y += f2;
        sGTuple2f2.x += f3;
        sGTuple2f2.y += f4;
        return true;
    }

    protected boolean setAllDrawingElementsLocation() {
        for (int i = 0; i < this.mChildList.size(); ++i) {
            SGData sGData;
            SGGraphElement.ElementGroupSetInGraph elementGroupSetInGraph = (SGGraphElement.ElementGroupSetInGraph)this.mChildList.get(i);
            if (!elementGroupSetInGraph.isVisible() || ((IElementGroupSetInSXYGraph)((Object)elementGroupSetInGraph)).setDrawingElementsLocation(sGData = (SGData)this.mDataList.get(i))) continue;
            return false;
        }
        return true;
    }

    protected SGGraphElement.ElementGroupSetInGraph getGroupSetNewInstance(SGData sGData) {
        SGGraphElement.ElementGroupSetInGraph elementGroupSetInGraph = null;
        if (sGData instanceof SGISXYTypeData) {
            elementGroupSetInGraph = new ElementGroupSetInSXYGraph();
        } else if (sGData instanceof SGISXYTypeMultipleData) {
            elementGroupSetInGraph = new ElementGroupSetForMultipleDataInSXYGraph();
        }
        return elementGroupSetInGraph;
    }

    public boolean createDataObject(Element element, SGData sGData) {
        if (!(sGData instanceof SGISXYTypeData) && !(sGData instanceof SGISXYTypeMultipleData)) {
            return false;
        }
        if (!super.createDataObject(element, sGData)) {
            return false;
        }
        SGGraphElement.ElementGroupSetInGraph elementGroupSetInGraph = this.getGroupSetNewInstance(sGData);
        if (elementGroupSetInGraph == null) {
            return false;
        }
        this.mChildList.add(elementGroupSetInGraph);
        int n = this.setProperty(element, elementGroupSetInGraph);
        if (n == 1) {
            return false;
        }
        this.createDataDialog();
        return true;
    }

    private int setProperty(Element element, SGGraphElement.ElementGroupSetInGraph elementGroupSetInGraph) {
        SGData sGData = this.getData(elementGroupSetInGraph);
        int n = 1;
        if (sGData instanceof SGISXYTypeData) {
            SGISXYTypeData sGISXYTypeData = (SGISXYTypeData)((Object)sGData);
            ElementGroupSetInSXYGraph elementGroupSetInSXYGraph = (ElementGroupSetInSXYGraph)elementGroupSetInGraph;
            n = this.setPropertyOfElementGroupSetInSXYGraph(element, elementGroupSetInSXYGraph, sGISXYTypeData);
        } else if (sGData instanceof SGISXYTypeMultipleData) {
            SGISXYTypeMultipleData sGISXYTypeMultipleData = (SGISXYTypeMultipleData)((Object)sGData);
            ElementGroupSetForMultipleDataInSXYGraph elementGroupSetForMultipleDataInSXYGraph = (ElementGroupSetForMultipleDataInSXYGraph)elementGroupSetInGraph;
            n = this.setPropertyOfElementGroupSetForMultipleDataInSXYGraph(element, elementGroupSetForMultipleDataInSXYGraph, sGISXYTypeMultipleData);
        }
        return n;
    }

    private int setPropertyOfElementGroupSetForMultipleDataInSXYGraph(Element element, ElementGroupSetForMultipleDataInSXYGraph elementGroupSetForMultipleDataInSXYGraph, SGISXYTypeMultipleData sGISXYTypeMultipleData) {
        elementGroupSetForMultipleDataInSXYGraph.mDrawingElementGroupList.clear();
        SGISXYTypeData[] sGISXYTypeDataArray = sGISXYTypeMultipleData.getSXYDataArray();
        ElementGroupSetInSXYGraph elementGroupSetInSXYGraph = new ElementGroupSetInSXYGraph();
        int n = this.setPropertyOfElementGroupSetInSXYGraph(element, elementGroupSetInSXYGraph, sGISXYTypeDataArray[0]);
        if (n == 1) {
            return n;
        }
        SGProperties sGProperties = elementGroupSetInSXYGraph.getProperties();
        SGProperties sGProperties2 = elementGroupSetInSXYGraph.getWholeProperties();
        ArrayList<ElementGroupSetInSXYGraph> arrayList = new ArrayList<ElementGroupSetInSXYGraph>();
        for (int i = 0; i < sGISXYTypeDataArray.length; ++i) {
            ElementGroupSetInSXYGraph elementGroupSetInSXYGraph2 = new ElementGroupSetInSXYGraph();
            if (!elementGroupSetInSXYGraph2.setProperties(sGProperties)) {
                return 1;
            }
            int n2 = sGISXYTypeDataArray[i].getPointsNumber();
            SGTuple2f[] sGTuple2fArray = new SGTuple2f[n2];
            for (int j = 0; j < n2; ++j) {
                sGTuple2fArray[j] = new SGTuple2f();
            }
            ElementGroupSetInSXYGraph.access$002(elementGroupSetInSXYGraph2, sGTuple2fArray);
            elementGroupSetInSXYGraph2.setDrawingElementsLocation((SGData)((Object)sGISXYTypeDataArray[i]));
            elementGroupSetInSXYGraph2.addDrawingElementGroup(2);
            elementGroupSetInSXYGraph2.addDrawingElementGroup(0);
            elementGroupSetInSXYGraph2.addDrawingElementGroup(1);
            if (!elementGroupSetInSXYGraph2.setWholeProperties(sGProperties2)) {
                return 1;
            }
            elementGroupSetInSXYGraph2.initPropertiesHistory();
            arrayList.add(elementGroupSetInSXYGraph2);
        }
        elementGroupSetForMultipleDataInSXYGraph.mElementGroupSetList = new ArrayList(arrayList);
        elementGroupSetForMultipleDataInSXYGraph.setName(elementGroupSetInSXYGraph.getName());
        elementGroupSetForMultipleDataInSXYGraph.setXAxis(elementGroupSetInSXYGraph.getXAxis());
        elementGroupSetForMultipleDataInSXYGraph.setYAxis(elementGroupSetInSXYGraph.getYAxis());
        elementGroupSetForMultipleDataInSXYGraph.setZAxis(elementGroupSetInSXYGraph.getZAxis());
        elementGroupSetForMultipleDataInSXYGraph.initPropertiesHistory();
        return 0;
    }

    private int setPropertyOfElementGroupSetInSXYGraph(Element element, ElementGroupSetInSXYGraph elementGroupSetInSXYGraph, SGISXYTypeData sGISXYTypeData) {
        Object object;
        SGIAxisElement sGIAxisElement = this.mAxisElement;
        String string = null;
        string = element.getAttribute("Name");
        if (string.length() == 0) {
            return 1;
        }
        String string2 = string;
        elementGroupSetInSXYGraph.setName(string2);
        string = element.getAttribute("XAxisPosition");
        if (string.length() == 0) {
            return 1;
        }
        int n = sGIAxisElement.getConfigurationInCube(string);
        string = element.getAttribute("YAxisPosition");
        if (string.length() == 0) {
            return 1;
        }
        int n2 = sGIAxisElement.getConfigurationInCube(string);
        elementGroupSetInSXYGraph.setXAxis(sGIAxisElement.getAxisInCube(n));
        elementGroupSetInSXYGraph.setYAxis(sGIAxisElement.getAxisInCube(n2));
        string = element.getAttribute("VisibleInLegend");
        if (string.length() == 0) {
            return 1;
        }
        Boolean bl = SGUtilityText.getBoolean(string);
        if (bl == null) {
            return 1;
        }
        boolean bl2 = bl;
        elementGroupSetInSXYGraph.setVisibleInLegend(bl2);
        int n3 = sGISXYTypeData.getPointsNumber();
        SGTuple2f[] sGTuple2fArray = new SGTuple2f[n3];
        for (int i = 0; i < n3; ++i) {
            sGTuple2fArray[i] = new SGTuple2f();
        }
        ElementGroupSetInSXYGraph.access$002(elementGroupSetInSXYGraph, sGTuple2fArray);
        SGElementGroupSXY sGElementGroupSXY = null;
        NodeList nodeList = null;
        nodeList = element.getElementsByTagName("Bar");
        if (nodeList.getLength() != 1) {
            return 1;
        }
        if (!elementGroupSetInSXYGraph.addDrawingElementGroup(2)) {
            return 1;
        }
        Element element2 = (Element)nodeList.item(0);
        sGElementGroupSXY = elementGroupSetInSXYGraph.getBarGroup();
        if (!sGElementGroupSXY.readProperty(element2)) {
            return 1;
        }
        ElementGroupBar elementGroupBar = (ElementGroupBar)sGElementGroupSXY;
        float f = elementGroupBar.getRectangleWidth();
        if (f != 0.0f) {
            object = elementGroupSetInSXYGraph.getXAxis();
            double d = ((SGAxis)object).getMaxValue();
            double d2 = ((SGAxis)object).getMinValue();
            float f2 = f / this.mGraphRectWidth;
            double d3 = (d - d2) * (double)f2;
            d3 = this.getNumberInRangeOrder(d3, (SGAxis)object);
            elementGroupBar.setWidthValue(d3);
        }
        if ((nodeList = element.getElementsByTagName("ErrorBar")).getLength() == 1) {
            if (sGISXYTypeData.isErrorValueHolding()) {
                Element element3;
                object = elementGroupSetInSXYGraph.createErrorBars(sGISXYTypeData);
                if (!((SGElementGroup)object).readProperty(element3 = (Element)nodeList.item(0))) {
                    return 1;
                }
                if (!((SGElementGroupErrorBar)object).setPropertiesOfDrawingElements()) {
                    return 1;
                }
                ((SGElementGroupErrorBar)object).setLocation(((ElementGroupErrorBar)object).mStartArray, ((ElementGroupErrorBar)object).mEndArray);
            }
        } else if (nodeList.getLength() == 0) {
            if (sGISXYTypeData.isErrorValueHolding() && !((SGElementGroupErrorBar)(object = elementGroupSetInSXYGraph.createErrorBars(sGISXYTypeData))).setPropertiesOfDrawingElements()) {
                return 1;
            }
        } else {
            return 1;
        }
        if ((nodeList = element.getElementsByTagName("Line")).getLength() != 1) {
            return 1;
        }
        if (!elementGroupSetInSXYGraph.addDrawingElementGroup(0)) {
            return 1;
        }
        object = (Element)nodeList.item(0);
        sGElementGroupSXY = elementGroupSetInSXYGraph.getLineGroup();
        if (!sGElementGroupSXY.readProperty((Element)object)) {
            return 1;
        }
        nodeList = element.getElementsByTagName("Symbol");
        if (nodeList.getLength() != 1) {
            return 1;
        }
        if (!elementGroupSetInSXYGraph.addDrawingElementGroup(1)) {
            return 1;
        }
        Element element4 = (Element)nodeList.item(0);
        sGElementGroupSXY = elementGroupSetInSXYGraph.getSymbolGroup();
        if (!sGElementGroupSXY.readProperty(element4)) {
            return 1;
        }
        nodeList = element.getElementsByTagName("TickLabels");
        if (nodeList.getLength() == 1) {
            if (sGISXYTypeData.isStringArrayHolding()) {
                Element element5;
                ElementGroupTickLabels elementGroupTickLabels = elementGroupSetInSXYGraph.createTickLabels(sGISXYTypeData);
                if (!elementGroupTickLabels.readProperty(element5 = (Element)nodeList.item(0))) {
                    return 1;
                }
                if (!elementGroupTickLabels.setPropertiesOfDrawingElements()) {
                    return 1;
                }
                elementGroupTickLabels.setLocation(elementGroupTickLabels.mPointsArray);
            }
        } else if (nodeList.getLength() == 0) {
            ElementGroupTickLabels elementGroupTickLabels;
            if (sGISXYTypeData.isStringArrayHolding() && !(elementGroupTickLabels = elementGroupSetInSXYGraph.createTickLabels(sGISXYTypeData)).setPropertiesOfDrawingElements()) {
                return 1;
            }
        } else {
            return 1;
        }
        elementGroupSetInSXYGraph.initPropertiesHistory();
        return 0;
    }

    public static class TickLabelStringElement
    extends SGDrawingElementString2DExtended {
        protected TickLabelStringElement() {
        }
    }

    class ElementGroupTickLabels
    extends SGElementGroupTickLabel
    implements SGGraphElement.IElementGroupInGraph {
        private SGTuple2f[] mPointsArray = null;
        private boolean mFocusedFlag = false;

        public void setFocused(boolean bl) {
            this.mFocusedFlag = bl;
        }

        public boolean isFocused() {
            return this.mFocusedFlag;
        }

        protected ElementGroupTickLabels(SGISXYTypeData sGISXYTypeData) {
            int n = sGISXYTypeData.getPointsNumber();
            this.initDrawingElement(n);
            SGTuple2f[] sGTuple2fArray = new SGTuple2f[n];
            for (int i = 0; i < n; ++i) {
                sGTuple2fArray[i] = new SGTuple2f();
            }
            this.mPointsArray = sGTuple2fArray;
            String[] stringArray = sGISXYTypeData.getStringArray();
            SGDrawingElementString[] sGDrawingElementStringArray = (SGDrawingElementString[])this.mDrawingElementArray;
            for (int i = 0; i < n; ++i) {
                SGDrawingElementString sGDrawingElementString = sGDrawingElementStringArray[i];
                sGDrawingElementString.setString(stringArray[i]);
            }
            if (!this.init()) {
                throw new Error();
            }
        }

        private boolean init() {
            this.setVisible(false);
            this.setFont("Serif", SGUtilityText.getFontStyle("Plain"), 16.0f);
            Float f = SGElementGroupTickLabel.getTickLabelAngleFromName("Horizontal");
            if (f == null) {
                return false;
            }
            this.setAngle(f.floatValue());
            this.setColor(SGDefaultValues.TICK_LABEL_COLOR);
            return true;
        }

        public void dispose() {
            super.dispose();
            this.mPointsArray = null;
        }

        private boolean drawStringBounds(SGDrawingElementString2DExtended sGDrawingElementString2DExtended, Graphics2D graphics2D) {
            Color color = Color.BLACK;
            graphics2D.setPaint(color);
            graphics2D.setStroke(new BasicStroke(1.0f));
            Rectangle2D rectangle2D = sGDrawingElementString2DExtended.getElementBounds();
            graphics2D.drawRect((int)rectangle2D.getX(), (int)rectangle2D.getY(), (int)rectangle2D.getWidth(), (int)rectangle2D.getHeight());
            return true;
        }

        protected boolean initDrawingElement(int n) {
            TickLabelStringElement[] tickLabelStringElementArray = new TickLabelStringElement[n];
            for (int i = 0; i < n; ++i) {
                tickLabelStringElementArray[i] = new TickLabelStringElement();
            }
            this.mDrawingElementArray = tickLabelStringElementArray;
            return true;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private boolean calcTickLabelLocation(SGISXYTypeData sGISXYTypeData, SGAxis sGAxis, SGTuple2f[] sGTuple2fArray) {
            float f = SGSXYGraphElement.this.mGraphRectX;
            float f2 = SGSXYGraphElement.this.mGraphRectY;
            float f3 = SGSXYGraphElement.this.mGraphRectWidth;
            float f4 = SGSXYGraphElement.this.mGraphRectHeight;
            int n = SGSXYGraphElement.this.mAxisElement.getConfigurationInPlane(sGAxis);
            float f5 = this.getAngle();
            float f6 = SGSXYGraphElement.this.mAxisElement.getSpaceAxisLineAndNumber() * this.mMagnification;
            int n2 = sGISXYTypeData.getPointsNumber();
            for (int i = 0; i < n2; ++i) {
                TickLabelStringElement tickLabelStringElement = (TickLabelStringElement)this.mDrawingElementArray[i];
                double d = sGISXYTypeData.getXValue(i);
                float f7 = SGSXYGraphElement.this.calcLocation(d, sGAxis, true);
                Rectangle2D rectangle2D = tickLabelStringElement.getElementBounds();
                float f8 = (float)rectangle2D.getWidth();
                float f9 = (float)rectangle2D.getHeight();
                Rectangle2D rectangle2D2 = tickLabelStringElement.getStringRect();
                float f10 = (float)rectangle2D2.getWidth();
                float f11 = (float)rectangle2D2.getHeight();
                float f12 = 0.0f;
                float f13 = 0.0f;
                float f14 = 0.0f;
                if (f5 == 0.0f) {
                    f12 = f7 - 0.5f * f8;
                } else {
                    if (f5 != 0.5235988f) throw new Error();
                    if (n == 0) {
                        f12 = f7 - f10 * (float)Math.cos(f5);
                    } else {
                        if (n != 1) throw new Error();
                        f12 = f7 - f11 * (float)Math.sin(f5);
                    }
                }
                if (n == 0) {
                    f14 = f2 + f4 + f6;
                } else {
                    if (n != 1) throw new Error();
                    f14 = f2 - f6 - f9;
                }
                tickLabelStringElement.setLocation(f12, f14);
                float f15 = (float)tickLabelStringElement.getElementBounds().getY();
                f13 = f14 + (f14 - f15);
                sGTuple2fArray[i].setValues(f12, f13);
            }
            return true;
        }

        public boolean setLocation(SGTuple2f[] sGTuple2fArray) {
            super.setLocation(sGTuple2fArray);
            ElementGroupSetInSXYGraph elementGroupSetInSXYGraph = (ElementGroupSetInSXYGraph)this.mGroupSet;
            SGAxis sGAxis = elementGroupSetInSXYGraph.getXAxis();
            SGISXYTypeData sGISXYTypeData = (SGISXYTypeData)((Object)SGSXYGraphElement.this.getData(elementGroupSetInSXYGraph));
            for (int i = 0; i < sGTuple2fArray.length; ++i) {
                double d = sGISXYTypeData.getXValue(i);
                TickLabelStringElement tickLabelStringElement = (TickLabelStringElement)this.mDrawingElementArray[i];
                tickLabelStringElement.setVisible(sGAxis.insideRange(d));
            }
            return true;
        }

        public String getTagName() {
            return "TickLabels";
        }
    }

    class ElementGroupErrorBar
    extends SGElementGroupErrorBar
    implements SGGraphElement.IElementGroupInGraph {
        protected SGTuple2f[] mStartArray = null;
        protected SGTuple2f[] mEndArray = null;
        private boolean mFocusedFlag = false;

        public void setFocused(boolean bl) {
            this.mFocusedFlag = bl;
        }

        public boolean isFocused() {
            return this.mFocusedFlag;
        }

        protected ElementGroupErrorBar(SGISXYTypeData sGISXYTypeData) {
            int n = sGISXYTypeData.getPointsNumber();
            this.initDrawingElement(n);
            SGTuple2f[] sGTuple2fArray = new SGTuple2f[n];
            SGTuple2f[] sGTuple2fArray2 = new SGTuple2f[n];
            for (int i = 0; i < n; ++i) {
                sGTuple2fArray[i] = new SGTuple2f();
                sGTuple2fArray2[i] = new SGTuple2f();
            }
            this.mStartArray = sGTuple2fArray;
            this.mEndArray = sGTuple2fArray2;
            if (!this.init()) {
                throw new Error();
            }
        }

        public void dispose() {
            super.dispose();
            this.mStartArray = null;
            this.mEndArray = null;
        }

        private boolean init() {
            this.setVisible(true);
            this.setLineWidth(1.0f);
            this.setHeadSize(7.0866146f);
            Integer n = SGDrawingElementSymbol.getSymbolTypeFromName("Transverse Line");
            if (n == null) {
                return false;
            }
            this.setHeadType(n);
            this.setLineWidth(1.0f);
            Integer n2 = SGDrawingElementErrorBar.getErrorBarStyleFromName("Bothsides");
            if (n2 == null) {
                return false;
            }
            this.setErrorBarStyle(n2);
            this.setColor(SGDefaultValues.ERROR_BAR_COLOR);
            return true;
        }

        private boolean calcErrorBarLocation(SGISXYTypeData sGISXYTypeData, SGAxis sGAxis, SGAxis sGAxis2, SGTuple2f[] sGTuple2fArray, SGTuple2f[] sGTuple2fArray2) {
            int n = sGISXYTypeData.getPointsNumber();
            double[] dArray = sGISXYTypeData.getXValueArray();
            double[] dArray2 = sGISXYTypeData.getYValueArray();
            SGTuple2d[] sGTuple2dArray = new SGTuple2d[n];
            SGTuple2d[] sGTuple2dArray2 = new SGTuple2d[n];
            for (int i = 0; i < n; ++i) {
                sGTuple2dArray[i] = new SGTuple2d();
                sGTuple2dArray2[i] = new SGTuple2d();
                sGTuple2dArray[i].x = dArray[i];
                sGTuple2dArray2[i].x = dArray[i];
            }
            if (this.mErrorBarStyle == 1) {
                double[] dArray3 = sGISXYTypeData.getUpperErrorValueArray();
                double[] dArray4 = sGISXYTypeData.getLowerErrorValueArray();
                for (int i = 0; i < n; ++i) {
                    sGTuple2dArray[i].y = dArray2[i] + dArray4[i];
                    sGTuple2dArray2[i].y = dArray2[i] + dArray3[i];
                }
            } else if (this.mErrorBarStyle == 2) {
                double[] dArray5 = sGISXYTypeData.getUpperErrorValueArray();
                for (int i = 0; i < n; ++i) {
                    sGTuple2dArray[i].y = dArray2[i];
                    sGTuple2dArray2[i].y = dArray2[i] + dArray5[i];
                }
            } else if (this.mErrorBarStyle == 3) {
                double[] dArray6 = sGISXYTypeData.getLowerErrorValueArray();
                for (int i = 0; i < n; ++i) {
                    sGTuple2dArray[i].y = dArray2[i] + dArray6[i];
                    sGTuple2dArray2[i].y = dArray2[i];
                }
            } else {
                throw new Error();
            }
            SGSXYGraphElement.this.calcLocationOfVXYData(sGTuple2dArray, sGTuple2dArray2, sGAxis, sGAxis2, sGTuple2fArray, sGTuple2fArray2);
            return true;
        }
    }

    class ElementGroupSymbol
    extends SGElementGroupSymbol
    implements SGGraphElement.IElementGroupInGraph {
        private boolean mFocusedFlag = false;

        public void setFocused(boolean bl) {
            this.mFocusedFlag = bl;
        }

        public boolean isFocused() {
            return this.mFocusedFlag;
        }

        protected ElementGroupSymbol() {
            if (!this.init()) {
                throw new Error();
            }
        }

        private boolean init() {
            this.setVisible(false);
            Integer n = SGDrawingElementSymbol.getSymbolTypeFromName("Circle");
            if (n == null) {
                return false;
            }
            this.setType(n);
            this.setSize(8.503938f);
            this.setColor(SGDefaultValues.SYMBOL_BODY_COLOR);
            this.setLineWidth(1.0f);
            this.setLineColor(SGDefaultValues.SYMBOL_LINE_COLOR);
            return true;
        }

        private boolean drawRectangle(Shape shape, Graphics2D graphics2D) {
            Rectangle2D rectangle2D = shape.getBounds2D();
            graphics2D.setPaint(Color.black);
            graphics2D.setStroke(new BasicStroke(1.0f));
            int n = (int)rectangle2D.getX();
            int n2 = (int)rectangle2D.getY();
            int n3 = (int)rectangle2D.getWidth();
            int n4 = (int)rectangle2D.getHeight();
            graphics2D.drawRect(n, n2, n3, n4);
            return true;
        }

        public boolean setLocation(SGTuple2f[] sGTuple2fArray) {
            return true;
        }

        public boolean paintElement(Graphics2D graphics2D, Rectangle2D rectangle2D) {
            block4: {
                super.paintElement(graphics2D, rectangle2D);
                ElementGroupSetInSXYGraph elementGroupSetInSXYGraph = (ElementGroupSetInSXYGraph)this.mGroupSet;
                SGDrawingElement[] sGDrawingElementArray = this.mDrawingElementArray;
                if (!this.isFocused() || !SGSXYGraphElement.this.mSymbolsVisibleFlagAroundFocusedObjects || elementGroupSetInSXYGraph.isBarVisible()) break block4;
                int n = sGDrawingElementArray.length;
                if (n <= 8) {
                    for (int i = 0; i < n; ++i) {
                        SGDrawingElementSymbol2D sGDrawingElementSymbol2D = (SGDrawingElementSymbol2D)sGDrawingElementArray[i];
                        this.emphasisSymbol(sGDrawingElementSymbol2D, graphics2D);
                    }
                } else {
                    int n2 = n / 8;
                    int n3 = 0;
                    do {
                        SGDrawingElementSymbol2D sGDrawingElementSymbol2D = (SGDrawingElementSymbol2D)sGDrawingElementArray[n3];
                        this.emphasisSymbol(sGDrawingElementSymbol2D, graphics2D);
                    } while ((n3 += n2) < n);
                }
            }
            return true;
        }

        private boolean emphasisSymbol(SGDrawingElementSymbol2D sGDrawingElementSymbol2D, Graphics2D graphics2D) {
            SGSXYGraphElement.this.drawAnchorsOnRectangle(sGDrawingElementSymbol2D.getElementBounds(), graphics2D);
            return true;
        }
    }

    class ElementGroupBar
    extends SGElementGroupBar
    implements SGGraphElement.IElementGroupInGraph {
        private boolean mFocusedFlag = false;

        public void setFocused(boolean bl) {
            this.mFocusedFlag = bl;
        }

        public boolean isFocused() {
            return this.mFocusedFlag;
        }

        protected ElementGroupBar() {
            this.init();
        }

        private void init() {
            this.setVisible(false);
            this.setBaselineValue(0.0);
            this.setColor(SGDefaultValues.BAR_COLOR);
            this.setEdgeLineWidth(0.5f);
            this.setEdgeLineColor(SGDefaultValues.BAR_LINE_COLOR);
        }

        protected boolean initDrawingElement(int n) {
            super.initDrawingElement(n);
            this.setHorizontal(false);
            return true;
        }

        protected boolean initDrawingElement(SGTuple2f[] sGTuple2fArray) {
            super.initDrawingElement(sGTuple2fArray);
            this.setHorizontal(false);
            return true;
        }

        private float getBaselineLocation(double d) {
            SGAxis sGAxis = ((ElementGroupSetInSXYGraph)this.mGroupSet).getYAxis();
            return SGSXYGraphElement.this.calcLocation(d, sGAxis, false);
        }

        public boolean setLocation(SGTuple2f[] sGTuple2fArray) {
            if (this.mDrawingElementArray == null) {
                return true;
            }
            float f = this.getBaselineLocation(this.getBaselineValue());
            boolean bl = true;
            if (Float.isInfinite(f) | Float.isNaN(f)) {
                bl = false;
            }
            ElementGroupSetInSXYGraph elementGroupSetInSXYGraph = (ElementGroupSetInSXYGraph)this.mGroupSet;
            SGAxis sGAxis = elementGroupSetInSXYGraph.getXAxis();
            double d = sGAxis.getMinValue();
            double d2 = sGAxis.getMaxValue();
            float f2 = SGSXYGraphElement.this.mGraphRectWidth * (float)(this.getWidthValue() / (d2 - d));
            this.setRectangleWidth(f2);
            SGDrawingElement[] sGDrawingElementArray = this.mDrawingElementArray;
            for (int i = 0; i < sGDrawingElementArray.length; ++i) {
                SGDrawingElementBar2D sGDrawingElementBar2D = (SGDrawingElementBar2D)sGDrawingElementArray[i];
                float f3 = sGTuple2fArray[i].x;
                float f4 = sGTuple2fArray[i].y;
                if (Float.isInfinite(f4) | Float.isNaN(f4) | !bl) {
                    sGDrawingElementBar2D.setVisible(false);
                    continue;
                }
                float f5 = f - f4;
                sGDrawingElementBar2D.setVisible(true);
                sGDrawingElementBar2D.setBounds(f3, f4, f2, f5);
            }
            return true;
        }

        public boolean paintElement(Graphics2D graphics2D, Rectangle2D rectangle2D) {
            block4: {
                super.paintElement(graphics2D, rectangle2D);
                SGGraphElement.ElementGroupSetInGraph elementGroupSetInGraph = (SGGraphElement.ElementGroupSetInGraph)this.mGroupSet;
                SGDrawingElement[] sGDrawingElementArray = this.mDrawingElementArray;
                if (!this.isFocused() || !SGSXYGraphElement.this.mSymbolsVisibleFlagAroundFocusedObjects) break block4;
                int n = sGDrawingElementArray.length;
                if (n <= 8) {
                    for (int i = 0; i < n; ++i) {
                        SGDrawingElementBar2D sGDrawingElementBar2D = (SGDrawingElementBar2D)sGDrawingElementArray[i];
                        this.emphasisBar(sGDrawingElementBar2D, graphics2D);
                    }
                } else {
                    int n2 = n / 8;
                    int n3 = 0;
                    do {
                        SGDrawingElementBar2D sGDrawingElementBar2D = (SGDrawingElementBar2D)sGDrawingElementArray[n3];
                        this.emphasisBar(sGDrawingElementBar2D, graphics2D);
                    } while ((n3 += n2) < n);
                }
            }
            return true;
        }

        private boolean emphasisBar(SGDrawingElementBar2D sGDrawingElementBar2D, Graphics2D graphics2D) {
            SGSXYGraphElement.this.drawAnchorsOnRectangle(sGDrawingElementBar2D.getElementBounds(), graphics2D);
            return true;
        }
    }

    class ElementGroupLine
    extends SGElementGroupLine
    implements SGGraphElement.IElementGroupInGraph {
        private boolean mFocusedFlag = false;

        public void setFocused(boolean bl) {
            this.mFocusedFlag = bl;
        }

        public boolean isFocused() {
            return this.mFocusedFlag;
        }

        protected ElementGroupLine() {
            if (!this.init()) {
                throw new Error();
            }
        }

        private boolean init() {
            this.setVisible(true);
            this.setLineWidth(1.0f);
            Integer n = SGDrawingElementLine.getLineTypeFromName("Solid");
            if (n == null) {
                return false;
            }
            this.setLineType(n);
            this.setColor(SGDefaultValues.LINE_COLOR);
            return true;
        }

        public boolean setLocation(SGTuple2f[] sGTuple2fArray) {
            return this.setLocation(sGTuple2fArray, false);
        }

        public boolean paintElement(Graphics2D graphics2D, Rectangle2D rectangle2D) {
            super.paintElement(graphics2D, rectangle2D);
            ElementGroupSetInSXYGraph elementGroupSetInSXYGraph = (ElementGroupSetInSXYGraph)this.mGroupSet;
            if (this.isFocused() && SGSXYGraphElement.this.mSymbolsVisibleFlagAroundFocusedObjects && !elementGroupSetInSXYGraph.isSymbolVisible() && !elementGroupSetInSXYGraph.isBarVisible()) {
                ArrayList arrayList = this.mConnectedPathList;
                for (int i = 0; i < arrayList.size(); ++i) {
                    int n;
                    GeneralPath generalPath = (GeneralPath)arrayList.get(i);
                    int n2 = 0;
                    ArrayList<Point2D.Float> arrayList2 = new ArrayList<Point2D.Float>();
                    PathIterator pathIterator = generalPath.getPathIterator(new AffineTransform());
                    float[] fArray = new float[6];
                    pathIterator.currentSegment(fArray);
                    Point2D.Float float_ = new Point2D.Float(fArray[0], fArray[1]);
                    pathIterator.next();
                    while (!pathIterator.isDone()) {
                        pathIterator.currentSegment(fArray);
                        Point2D.Float float_2 = new Point2D.Float(fArray[0], fArray[1]);
                        ((Point2D)float_2).setLocation((((Point2D)float_).getX() + ((Point2D)float_2).getX()) / 2.0, (((Point2D)float_).getY() + ((Point2D)float_2).getY()) / 2.0);
                        ((Point2D)float_).setLocation(fArray[0], fArray[1]);
                        arrayList2.add(float_2);
                        pathIterator.next();
                        ++n2;
                    }
                    if (n2 <= 8) {
                        for (n = 0; n < n2; ++n) {
                            Point2D point2D = (Point2D)arrayList2.get(n);
                            SGSXYGraphElement.this.drawAnchorsForFocusedObjects(point2D, graphics2D);
                        }
                        continue;
                    }
                    n = n2 / 8;
                    int n3 = 0;
                    do {
                        Point2D point2D = (Point2D)arrayList2.get(n3);
                        SGSXYGraphElement.this.drawAnchorsForFocusedObjects(point2D, graphics2D);
                    } while ((n3 += n) < n2);
                }
            }
            return true;
        }
    }

    class ElementGroupSetInSXYGraph
    extends SGGraphElement.ElementGroupSetInGraph
    implements IElementGroupSetInSXYGraph,
    SGISXYDataDialogObserver {
        private int mSelectedTabIndex = -1;
        private SGTuple2f[] mPointsArray = null;

        protected ElementGroupSetInSXYGraph() {
            this.mPopupMenu = SGSXYGraphElement.this.createGroupSetPopupMenu(this);
        }

        public void dispose() {
            super.dispose();
            this.mPointsArray = null;
        }

        public String getClassDescription() {
            return "";
        }

        private boolean setProperties(ArrayList arrayList, SGProperties sGProperties) {
            for (int i = 0; i < arrayList.size(); ++i) {
                SGElementGroup sGElementGroup = (SGElementGroup)arrayList.get(i);
                if (sGElementGroup.setProperties(sGProperties)) continue;
                return false;
            }
            return true;
        }

        public boolean getLegendVisibleFlag() {
            return this.isVisibleInLegend();
        }

        public int getXAxisConfiguration() {
            return SGSXYGraphElement.this.mAxisElement.getConfigurationInPlane(this.getXAxis());
        }

        public int getYAxisConfiguration() {
            return SGSXYGraphElement.this.mAxisElement.getConfigurationInPlane(this.getYAxis());
        }

        public ArrayList getLineGroupList() {
            return this.getLineGroups();
        }

        public ArrayList getSymbolGroupList() {
            return this.getSymbolGroups();
        }

        public ArrayList getBarGroupList() {
            return this.getBarGroups();
        }

        public ArrayList getErrorBarGroupList() {
            return this.getErrorBarGroups();
        }

        public ArrayList getTickLabelGroupList() {
            return this.getTickLabelGroups();
        }

        public int getSelectedTabIndex() {
            return this.mSelectedTabIndex;
        }

        public boolean isLineVisible() {
            return this.getLineGroup().isVisible();
        }

        public float getLineWidth() {
            return this.getLineGroup().getLineWidth();
        }

        public float getLineWidth(String string) {
            return (float)SGUtilityText.convertFromPoint(this.getLineWidth(), string);
        }

        public int getLineType() {
            return this.getLineGroup().getLineType();
        }

        public Color getLineColor() {
            return this.getLineGroup().getColor(0);
        }

        public boolean setLineVisible(boolean bl) {
            this.getLineGroup().setVisible(bl);
            return true;
        }

        public boolean setLineWidth(float f) {
            return this.getLineGroup().setLineWidth(f);
        }

        public boolean setLineWidth(float f, String string) {
            return this.setLineWidth((float)SGUtilityText.convertToPoint(f, string));
        }

        public boolean setLineType(int n) {
            return this.getLineGroup().setLineType(n);
        }

        public boolean setLineColor(Color color) {
            return this.getLineGroup().setColor(color);
        }

        public boolean isSymbolVisible() {
            return this.getSymbolGroup().isVisible();
        }

        public int getSymbolType() {
            return this.getSymbolGroup().getType();
        }

        public float getSymbolSize() {
            return this.getSymbolGroup().getSize();
        }

        public float getSymbolSize(String string) {
            return (float)SGUtilityText.convertFromPoint(this.getSymbolSize(), string);
        }

        public float getSymbolLineWidth() {
            return this.getSymbolGroup().getLineWidth();
        }

        public float getSymbolLineWidth(String string) {
            return (float)SGUtilityText.convertFromPoint(this.getSymbolLineWidth(), string);
        }

        public Color getSymbolInnerColor() {
            return this.getSymbolGroup().getColor(0);
        }

        public Color getSymbolLineColor() {
            return this.getSymbolGroup().getLineColor();
        }

        public boolean setSymbolVisible(boolean bl) {
            this.getSymbolGroup().setVisible(bl);
            return true;
        }

        public boolean setSymbolType(int n) {
            return this.getSymbolGroup().setType(n);
        }

        public boolean setSymbolSize(float f) {
            return this.getSymbolGroup().setSize(f);
        }

        public boolean setSymbolSize(float f, String string) {
            return this.setSymbolSize((float)SGUtilityText.convertToPoint(f, string));
        }

        public boolean setSymbolLineWidth(float f) {
            return this.getSymbolGroup().setLineWidth(f);
        }

        public boolean setSymbolLineWidth(float f, String string) {
            return this.setSymbolLineWidth((float)SGUtilityText.convertToPoint(f, string));
        }

        public boolean setSymbolInnerColor(Color color) {
            return this.getSymbolGroup().setColor(color);
        }

        public boolean setSymbolLineColor(Color color) {
            return this.getSymbolGroup().setLineColor(color);
        }

        public boolean isBarVisible() {
            return this.getBarGroup().isVisible();
        }

        public double getBarBaselineValue() {
            return this.getBarGroup().getBaselineValue();
        }

        public float getBarWidth() {
            return this.getBarGroup().getRectangleWidth();
        }

        public double getBarWidthValue() {
            return this.getBarGroup().getWidthValue();
        }

        public float getBarEdgeLineWidth() {
            return this.getBarGroup().getEdgeLineWidth();
        }

        public float getBarEdgeLineWidth(String string) {
            return (float)SGUtilityText.convertFromPoint(this.getBarEdgeLineWidth(), string);
        }

        public Color getBarInnerColor() {
            return this.getBarGroup().getColor(0);
        }

        public Color getBarEdgeLineColor() {
            return this.getBarGroup().getEdgeLineColor();
        }

        public boolean setBarVisible(boolean bl) {
            this.getBarGroup().setVisible(bl);
            return true;
        }

        public boolean setBarBaselineValue(double d) {
            return this.getBarGroup().setBaselineValue(d);
        }

        public boolean setBarWidth(float f) {
            return this.getBarGroup().setRectangleWidth(f);
        }

        public boolean setBarWidthValue(double d) {
            return this.getBarGroup().setWidthValue(d);
        }

        public boolean setBarEdgeLineWidth(float f) {
            return this.getBarGroup().setEdgeLineWidth(f);
        }

        public boolean setBarEdgeLineWidth(float f, String string) {
            return this.setBarEdgeLineWidth((float)SGUtilityText.convertToPoint(f, string));
        }

        public boolean setBarInnerColor(Color color) {
            return this.getBarGroup().setColor(color);
        }

        public boolean setBarEdgeLineColor(Color color) {
            return this.getBarGroup().setEdgeLineColor(color);
        }

        public boolean hasValidBaselineValue(int n, Number number) {
            SGAxis sGAxis = n == -1 ? this.mYAxis : SGSXYGraphElement.this.mAxisElement.getAxisInPlane(n);
            double d = number != null ? number.doubleValue() : this.getBarBaselineValue();
            return sGAxis.isValidValue(d);
        }

        public boolean isErrorBarHolding() {
            return this.getErrorBarGroup() != null;
        }

        public boolean isErrorBarVisible() {
            return this.getErrorBarGroup().isVisible();
        }

        public int getErrorBarHeadType() {
            return this.getErrorBarGroup().getHeadType();
        }

        public float getErrorBarHeadSize() {
            return this.getErrorBarGroup().getHeadSize();
        }

        public float getErrorBarHeadSize(String string) {
            return (float)SGUtilityText.convertFromPoint(this.getErrorBarHeadSize(), string);
        }

        public Color getErrorBarColor() {
            return this.getErrorBarGroup().getColor(0);
        }

        public float getErrorBarLineWidth() {
            return this.getErrorBarGroup().getLineWidth();
        }

        public float getErrorBarLineWidth(String string) {
            return (float)SGUtilityText.convertFromPoint(this.getErrorBarLineWidth(), string);
        }

        public int getErrorBarStyle() {
            return this.getErrorBarGroup().getErrorBarStyle();
        }

        public boolean setErrorBarVisible(boolean bl) {
            this.getErrorBarGroup().setVisible(bl);
            return true;
        }

        public boolean setErrorBarHeadType(int n) {
            this.getErrorBarGroup().setHeadType(n);
            return true;
        }

        public boolean setErrorBarHeadSize(float f) {
            this.getErrorBarGroup().setHeadSize(f);
            return true;
        }

        public boolean setErrorBarHeadSize(float f, String string) {
            return this.setErrorBarHeadSize((float)SGUtilityText.convertToPoint(f, string));
        }

        public boolean setErrorBarColor(Color color) {
            return this.getErrorBarGroup().setColor(color);
        }

        public boolean setErrorBarLineWidth(float f) {
            this.getErrorBarGroup().setLineWidth(f);
            return true;
        }

        public boolean setErrorBarLineWidth(float f, String string) {
            return this.setErrorBarLineWidth((float)SGUtilityText.convertToPoint(f, string));
        }

        public boolean setErrorBarStyle(int n) {
            this.getErrorBarGroup().setErrorBarStyle(n);
            return true;
        }

        public boolean isTickLabelHolding() {
            return this.getTickLabelGroup() != null;
        }

        public boolean isTickLabelVisible() {
            return this.getTickLabelGroup().isVisible();
        }

        public String getTickLabelFontName() {
            return this.getTickLabelGroup().getFontName();
        }

        public int getTickLabelFontStyle() {
            return this.getTickLabelGroup().getFontStyle();
        }

        public float getTickLabelFontSize() {
            return this.getTickLabelGroup().getFontSize();
        }

        public float getTickLabelFontSize(String string) {
            return (float)SGUtilityText.convertFromPoint(this.getTickLabelFontSize(), string);
        }

        public Color getTickLabelColor() {
            return this.getTickLabelGroup().getColor(0);
        }

        public boolean isTickLabelHorizontal() {
            return this.getTickLabelGroup().getAngle() == 0.0f;
        }

        public boolean setTickLabelVisible(boolean bl) {
            this.getTickLabelGroup().setVisible(bl);
            return true;
        }

        public boolean setTickLabelFontName(String string) {
            return this.getTickLabelGroup().setFontName(string);
        }

        public boolean setTickLabelFontStyle(int n) {
            return this.getTickLabelGroup().setFontStyle(n);
        }

        public boolean setTickLabelFontSize(float f) {
            return this.getTickLabelGroup().setFontSize(f);
        }

        public boolean setTickLabelFontSize(float f, String string) {
            return this.setTickLabelFontSize((float)SGUtilityText.convertToPoint(f, string));
        }

        public boolean setTickLabelColor(Color color) {
            return this.getTickLabelGroup().setColor(color);
        }

        public boolean setTickLabelHorizontal(boolean bl) {
            float f = bl ? 0.0f : 0.5235988f;
            return this.getTickLabelGroup().setAngle(f);
        }

        public boolean addDrawingElementGroup(int n) {
            SGElementGroupSXY sGElementGroupSXY = null;
            if (n == 0) {
                sGElementGroupSXY = new ElementGroupLine();
            } else if (n == 2) {
                sGElementGroupSXY = new ElementGroupBar();
            } else if (n == 1) {
                sGElementGroupSXY = new ElementGroupSymbol();
            } else {
                return false;
            }
            if (!this.checkGroupType(sGElementGroupSXY)) {
                return false;
            }
            this.addElementGroup(sGElementGroupSXY);
            return true;
        }

        private boolean checkGroupType(SGElementGroup sGElementGroup) {
            Class<?> clazz = sGElementGroup.getClass();
            ArrayList arrayList = this.mDrawingElementGroupList;
            for (int i = 0; i < arrayList.size(); ++i) {
                SGElementGroup sGElementGroup2 = (SGElementGroup)arrayList.get(i);
                Class<?> clazz2 = sGElementGroup2.getClass();
                if (!clazz.equals(clazz2)) continue;
                return false;
            }
            return true;
        }

        private ElementGroupErrorBar createErrorBars(SGISXYTypeData sGISXYTypeData) {
            ElementGroupErrorBar elementGroupErrorBar = new ElementGroupErrorBar(sGISXYTypeData);
            this.mDrawingElementGroupList.add(elementGroupErrorBar);
            elementGroupErrorBar.mGroupSet = this;
            return elementGroupErrorBar;
        }

        private ElementGroupTickLabels createTickLabels(SGISXYTypeData sGISXYTypeData) {
            ElementGroupTickLabels elementGroupTickLabels = new ElementGroupTickLabels(sGISXYTypeData);
            this.mDrawingElementGroupList.add(elementGroupTickLabels);
            elementGroupTickLabels.mGroupSet = this;
            return elementGroupTickLabels;
        }

        public boolean synchronizeDrawingElement(ArrayList arrayList) {
            SGIVisible sGIVisible;
            int n;
            ArrayList<SGElementGroupErrorBar> arrayList2 = new ArrayList<SGElementGroupErrorBar>();
            for (n = 0; n < arrayList.size(); ++n) {
                SGDrawingElement sGDrawingElement = (SGDrawingElement)arrayList.get(n);
                sGIVisible = null;
                if (sGDrawingElement instanceof SGDrawingElementErrorBar) {
                    sGIVisible = this.getErrorBarGroup();
                } else if (sGDrawingElement instanceof SGDrawingElementLine) {
                    sGIVisible = this.getLineGroup();
                } else if (sGDrawingElement instanceof SGDrawingElementSymbol) {
                    sGIVisible = this.getSymbolGroup();
                } else if (sGDrawingElement instanceof SGDrawingElementBar) {
                    sGIVisible = this.getBarGroup();
                } else if (sGDrawingElement instanceof SGDrawingElementString) {
                    sGIVisible = this.getTickLabelGroup();
                }
                if (sGIVisible == null) continue;
                arrayList2.add((SGElementGroupErrorBar)sGIVisible);
            }
            n = 0;
            for (int i = 0; i < arrayList.size(); ++i) {
                SGProperties sGProperties;
                sGIVisible = (SGDrawingElement)arrayList.get(i);
                SGElementGroup sGElementGroup = (SGElementGroup)arrayList2.get(i);
                SGDrawingElement sGDrawingElement = sGElementGroup.getDrawingElement();
                SGProperties sGProperties2 = ((SGDrawingElement)sGIVisible).getProperties();
                if (!sGProperties2.equals(sGProperties = sGDrawingElement.getProperties())) {
                    n = 1;
                }
                sGElementGroup.setProperty((SGDrawingElement)sGIVisible);
            }
            return n != 0;
        }

        public boolean setDrawingElementsLocation(SGData sGData) {
            if (!(sGData instanceof SGISXYTypeData)) {
                return false;
            }
            SGISXYTypeData sGISXYTypeData = (SGISXYTypeData)((Object)sGData);
            int n = sGISXYTypeData.getPointsNumber();
            if (!SGSXYGraphElement.this.calcLocationOfSXYData(sGISXYTypeData, this.getXAxis(), this.getYAxis(), this.mPointsArray)) {
                return false;
            }
            ArrayList arrayList = this.mDrawingElementGroupList;
            for (int i = 0; i < arrayList.size(); ++i) {
                SGTuple2f[] sGTuple2fArray;
                SGElementGroup sGElementGroup;
                SGElementGroup sGElementGroup2 = (SGElementGroup)arrayList.get(i);
                if (!sGElementGroup2.isVisible()) continue;
                if (sGElementGroup2 instanceof SGElementGroupErrorBar) {
                    sGElementGroup = (ElementGroupErrorBar)sGElementGroup2;
                    sGTuple2fArray = ((ElementGroupErrorBar)sGElementGroup).mStartArray;
                    SGTuple2f[] sGTuple2fArray2 = ((ElementGroupErrorBar)sGElementGroup).mEndArray;
                    if (!((ElementGroupErrorBar)sGElementGroup).calcErrorBarLocation(sGISXYTypeData, this.getXAxis(), this.getYAxis(), sGTuple2fArray, sGTuple2fArray2)) {
                        return false;
                    }
                    if (((SGElementGroupErrorBar)sGElementGroup).setLocation(sGTuple2fArray, sGTuple2fArray2)) continue;
                    return false;
                }
                if (sGElementGroup2 instanceof SGElementGroupTickLabel) {
                    sGElementGroup = (ElementGroupTickLabels)sGElementGroup2;
                    sGTuple2fArray = ((ElementGroupTickLabels)sGElementGroup).mPointsArray;
                    if (!((ElementGroupTickLabels)sGElementGroup).calcTickLabelLocation(sGISXYTypeData, this.getXAxis(), sGTuple2fArray)) {
                        return false;
                    }
                    if (((ElementGroupTickLabels)sGElementGroup).setLocation(sGTuple2fArray)) continue;
                    return false;
                }
                if (!(sGElementGroup2 instanceof SGElementGroupLine | sGElementGroup2 instanceof SGElementGroupSymbol | sGElementGroup2 instanceof SGElementGroupBar) || ((SGElementGroupSXY)(sGElementGroup = (SGElementGroupSXY)sGElementGroup2)).setLocation(this.mPointsArray)) continue;
                return false;
            }
            return true;
        }

        protected boolean createDrawingElements() {
            ArrayList arrayList = this.mDrawingElementGroupList;
            for (int i = 0; i < arrayList.size(); ++i) {
                SGElementGroup sGElementGroup;
                SGElementGroup sGElementGroup2 = (SGElementGroup)arrayList.get(i);
                if (!sGElementGroup2.isVisible()) continue;
                if (sGElementGroup2 instanceof SGElementGroupSXY) {
                    sGElementGroup = (SGElementGroupSXY)sGElementGroup2;
                    ((SGElementGroupSXY)sGElementGroup).setLocation(this.mPointsArray);
                    continue;
                }
                if (sGElementGroup2 instanceof ElementGroupErrorBar) {
                    sGElementGroup = (ElementGroupErrorBar)sGElementGroup2;
                    ((SGElementGroupErrorBar)sGElementGroup).setLocation(((ElementGroupErrorBar)sGElementGroup).mStartArray, ((ElementGroupErrorBar)sGElementGroup).mEndArray);
                    continue;
                }
                if (!(sGElementGroup2 instanceof ElementGroupTickLabels)) continue;
                sGElementGroup = (ElementGroupTickLabels)sGElementGroup2;
                ((ElementGroupTickLabels)sGElementGroup).setLocation(((ElementGroupTickLabels)sGElementGroup).mPointsArray);
            }
            return true;
        }

        private boolean addElementGroup(SGElementGroupSXY sGElementGroupSXY) {
            sGElementGroupSXY.mGroupSet = this;
            if (!sGElementGroupSXY.initDrawingElement(this.mPointsArray)) {
                throw new Error();
            }
            if (!sGElementGroupSXY.setPropertiesOfDrawingElements()) {
                return false;
            }
            this.mDrawingElementGroupList.add(sGElementGroupSXY);
            return true;
        }

        public Rectangle2D getTickLabelsBoundingBox(SGData sGData) {
            if (!(sGData instanceof SGISXYTypeData)) {
                return null;
            }
            SGISXYTypeData sGISXYTypeData = (SGISXYTypeData)((Object)sGData);
            ArrayList<Rectangle2D> arrayList = new ArrayList<Rectangle2D>();
            ArrayList arrayList2 = this.getTickLabelGroups();
            if (arrayList2.size() == 0) {
                return new Rectangle2D.Float();
            }
            ElementGroupTickLabels elementGroupTickLabels = (ElementGroupTickLabels)arrayList2.get(0);
            if (!elementGroupTickLabels.isVisible()) {
                return new Rectangle2D.Float();
            }
            ArrayList<SGDrawingElement> arrayList3 = new ArrayList<SGDrawingElement>();
            SGDrawingElement[] sGDrawingElementArray = elementGroupTickLabels.mDrawingElementArray;
            for (int i = 0; i < sGDrawingElementArray.length; ++i) {
                if (!sGDrawingElementArray[i].isVisible()) continue;
                arrayList3.add(sGDrawingElementArray[i]);
            }
            Rectangle2D rectangle2D = SGUtilityJava2D.getBoundingBox(arrayList3);
            if (rectangle2D == null) {
                return new Rectangle2D.Float();
            }
            arrayList.add(rectangle2D);
            Rectangle2D rectangle2D2 = SGUtility.createUnion(arrayList);
            if (rectangle2D2 == null) {
                new Rectangle2D.Float();
            }
            return rectangle2D2;
        }

        public void paintGraphics2D(Graphics2D graphics2D) {
            ElementGroupSymbol elementGroupSymbol;
            SGElementGroup sGElementGroup;
            ArrayList arrayList;
            ElementGroupBar elementGroupBar;
            Rectangle2D rectangle2D = null;
            if (!this.getClipFlag()) {
                rectangle2D = SGSXYGraphElement.this.getGraphRect();
            }
            if ((elementGroupBar = SGSXYGraphElement.this.getGroupBar(this)) != null && elementGroupBar.isVisible()) {
                elementGroupBar.paintElement(graphics2D, rectangle2D);
            }
            if ((arrayList = this.getErrorBarGroups()).size() != 0 && (sGElementGroup = (ElementGroupErrorBar)arrayList.get(0)) != null && sGElementGroup.isVisible()) {
                ((SGElementGroupErrorBar)sGElementGroup).paintElement(graphics2D, rectangle2D);
            }
            if ((sGElementGroup = SGSXYGraphElement.this.getGroupLine(this)) != null && sGElementGroup.isVisible()) {
                ((ElementGroupLine)sGElementGroup).paintElement(graphics2D, rectangle2D);
            }
            if ((elementGroupSymbol = SGSXYGraphElement.this.getGroupSymbol(this)) != null && elementGroupSymbol.isVisible()) {
                elementGroupSymbol.paintElement(graphics2D, rectangle2D);
            }
        }

        public boolean paintDataString(Graphics2D graphics2D) {
            ElementGroupTickLabels elementGroupTickLabels;
            ArrayList arrayList = this.getTickLabelGroups();
            if (arrayList.size() != 0 && (elementGroupTickLabels = (ElementGroupTickLabels)arrayList.get(0)) != null && elementGroupTickLabels.isVisible()) {
                elementGroupTickLabels.paintElement(graphics2D);
            }
            return true;
        }

        public void setXAxisConfiguration(int n) {
            this.setXAxis(this.getAxis(n));
        }

        public void setYAxisConfiguration(int n) {
            this.setYAxis(this.getAxis(n));
        }

        private SGAxis getAxis(int n) {
            return SGSXYGraphElement.this.mAxisElement.getAxisInPlane(n);
        }

        public boolean prepare() {
            this.mTemporaryProperties = this.getWholeProperties();
            return true;
        }

        public SGPropertyDialog getPropertyDialog() {
            return SGSXYGraphElement.this.mDialog;
        }

        public boolean writeProperty(Element element) {
            if (!super.writeProperty(element)) {
                return false;
            }
            int n = SGSXYGraphElement.this.mAxisElement.getConfigurationInCube(this.getXAxis());
            int n2 = SGSXYGraphElement.this.mAxisElement.getConfigurationInCube(this.getYAxis());
            String string = SGSXYGraphElement.this.mAxisElement.getConfigurationString(n);
            String string2 = SGSXYGraphElement.this.mAxisElement.getConfigurationString(n2);
            element.setAttribute("XAxisPosition", string);
            element.setAttribute("YAxisPosition", string2);
            return true;
        }

        protected boolean onMouseClicked(MouseEvent mouseEvent) {
            if (!super.onMouseClicked(mouseEvent)) {
                return false;
            }
            SGElementGroup sGElementGroup = this.getElementGroupAt(mouseEvent.getX(), mouseEvent.getY());
            int n = -1;
            if (sGElementGroup instanceof ElementGroupLine) {
                n = 0;
            } else if (sGElementGroup instanceof ElementGroupSymbol) {
                n = 1;
            } else if (sGElementGroup instanceof ElementGroupBar) {
                n = 2;
            } else if (sGElementGroup instanceof ElementGroupErrorBar) {
                n = 3;
            } else if (sGElementGroup instanceof ElementGroupTickLabels) {
                n = 4;
            }
            this.mSelectedTabIndex = n;
            return true;
        }

        static /* synthetic */ SGTuple2f[] access$002(ElementGroupSetInSXYGraph elementGroupSetInSXYGraph, SGTuple2f[] sGTuple2fArray) {
            elementGroupSetInSXYGraph.mPointsArray = sGTuple2fArray;
            return sGTuple2fArray;
        }
    }

    class ElementGroupSetForMultipleDataInSXYGraph
    extends SGGraphElement.ElementGroupSetForMultipleData
    implements IElementGroupSetInSXYGraph,
    SGISXYDataDialogObserver {
        private int mSelectedTabIndex = -1;

        protected ElementGroupSetForMultipleDataInSXYGraph() {
            this.mPopupMenu = SGSXYGraphElement.this.createGroupSetPopupMenu(this);
        }

        public String getClassDescription() {
            return "";
        }

        protected boolean createDrawingElements() {
            for (int i = 0; i < this.mElementGroupSetList.size(); ++i) {
                SGGraphElement.ElementGroupSetInGraph elementGroupSetInGraph = (SGGraphElement.ElementGroupSetInGraph)this.mElementGroupSetList.get(i);
                if (elementGroupSetInGraph.createDrawingElements()) continue;
                return false;
            }
            return true;
        }

        public boolean setDrawingElementsLocation(SGData sGData) {
            if (!(sGData instanceof SGISXYTypeMultipleData)) {
                return false;
            }
            SGISXYTypeMultipleData sGISXYTypeMultipleData = (SGISXYTypeMultipleData)((Object)sGData);
            SGISXYTypeData[] sGISXYTypeDataArray = sGISXYTypeMultipleData.getSXYDataArray();
            for (int i = 0; i < this.mElementGroupSetList.size(); ++i) {
                IElementGroupSetInSXYGraph iElementGroupSetInSXYGraph = (IElementGroupSetInSXYGraph)this.mElementGroupSetList.get(i);
                if (iElementGroupSetInSXYGraph.setDrawingElementsLocation((SGData)((Object)sGISXYTypeDataArray[i]))) continue;
                return false;
            }
            return true;
        }

        public Rectangle2D getTickLabelsBoundingBox(SGData sGData) {
            if (!(sGData instanceof SGISXYTypeMultipleData)) {
                return null;
            }
            SGISXYTypeMultipleData sGISXYTypeMultipleData = (SGISXYTypeMultipleData)((Object)sGData);
            SGISXYTypeData[] sGISXYTypeDataArray = sGISXYTypeMultipleData.getSXYDataArray();
            ArrayList<Rectangle2D> arrayList = new ArrayList<Rectangle2D>();
            for (int i = 0; i < this.mElementGroupSetList.size(); ++i) {
                IElementGroupSetInSXYGraph iElementGroupSetInSXYGraph = (IElementGroupSetInSXYGraph)this.mElementGroupSetList.get(i);
                Rectangle2D rectangle2D = iElementGroupSetInSXYGraph.getTickLabelsBoundingBox((SGData)((Object)sGISXYTypeDataArray[i]));
                if (rectangle2D == null) {
                    return null;
                }
                arrayList.add(rectangle2D);
            }
            Rectangle2D rectangle2D = SGUtility.createUnion(arrayList);
            return rectangle2D;
        }

        public boolean paintDataString(Graphics2D graphics2D) {
            for (int i = 0; i < this.mElementGroupSetList.size(); ++i) {
                IElementGroupSetInSXYGraph iElementGroupSetInSXYGraph = (IElementGroupSetInSXYGraph)this.mElementGroupSetList.get(i);
                iElementGroupSetInSXYGraph.paintDataString(graphics2D);
            }
            return true;
        }

        public boolean prepare() {
            this.mTemporaryProperties = this.getWholeProperties();
            return true;
        }

        public SGPropertyDialog getPropertyDialog() {
            return SGSXYGraphElement.this.mDialog;
        }

        public void setXAxisConfiguration(int n) {
            this.setXAxis(this.getAxis(n));
        }

        public void setYAxisConfiguration(int n) {
            this.setYAxis(this.getAxis(n));
        }

        private SGAxis getAxis(int n) {
            return SGSXYGraphElement.this.mAxisElement.getAxisInPlane(n);
        }

        public boolean setXAxis(SGAxis sGAxis) {
            super.setXAxis(sGAxis);
            ArrayList arrayList = this.mElementGroupSetList;
            for (int i = 0; i < arrayList.size(); ++i) {
                SGGraphElement.ElementGroupSetInGraph elementGroupSetInGraph = (SGGraphElement.ElementGroupSetInGraph)arrayList.get(i);
                elementGroupSetInGraph.setXAxis(sGAxis);
            }
            return true;
        }

        public boolean setYAxis(SGAxis sGAxis) {
            super.setYAxis(sGAxis);
            ArrayList arrayList = this.mElementGroupSetList;
            for (int i = 0; i < arrayList.size(); ++i) {
                SGGraphElement.ElementGroupSetInGraph elementGroupSetInGraph = (SGGraphElement.ElementGroupSetInGraph)arrayList.get(i);
                elementGroupSetInGraph.setYAxis(sGAxis);
            }
            return true;
        }

        public double getSamplingRate() {
            SGData sGData = SGSXYGraphElement.this.getData(this);
            SGSXYSamplingData sGSXYSamplingData = (SGSXYSamplingData)sGData;
            return sGSXYSamplingData.getSamplingRate();
        }

        public SGProperties getWholeProperties() {
            SGElementGroupSet.WholeProperties wholeProperties;
            ElementGroupSetInSXYGraph elementGroupSetInSXYGraph = this.getFirst();
            if (!elementGroupSetInSXYGraph.getWholeProperties(wholeProperties = new SGElementGroupSet.WholeProperties())) {
                return null;
            }
            return wholeProperties;
        }

        public boolean setWholeProperties(SGProperties sGProperties) {
            if (!(sGProperties instanceof SGElementGroupSet.WholeProperties)) {
                return false;
            }
            SGElementGroupSet.WholeProperties wholeProperties = (SGElementGroupSet.WholeProperties)sGProperties;
            ArrayList arrayList = this.mElementGroupSetList;
            for (int i = 0; i < arrayList.size(); ++i) {
                ElementGroupSetInSXYGraph elementGroupSetInSXYGraph = (ElementGroupSetInSXYGraph)arrayList.get(i);
                if (elementGroupSetInSXYGraph.setWholeProperties(sGProperties)) continue;
                return false;
            }
            return true;
        }

        public Element createElement(Document document) {
            Element element = document.createElement(this.getTagName());
            if (!this.writeProperty(element)) {
                return null;
            }
            ElementGroupSetInSXYGraph elementGroupSetInSXYGraph = this.getFirst();
            SGAxis sGAxis = elementGroupSetInSXYGraph.getXAxis();
            SGAxis sGAxis2 = elementGroupSetInSXYGraph.getYAxis();
            int n = SGSXYGraphElement.this.mAxisElement.getConfigurationInCube(sGAxis);
            int n2 = SGSXYGraphElement.this.mAxisElement.getConfigurationInCube(sGAxis2);
            String string = SGSXYGraphElement.this.mAxisElement.getConfigurationString(n);
            String string2 = SGSXYGraphElement.this.mAxisElement.getConfigurationString(n2);
            element.setAttribute("XAxisPosition", string);
            element.setAttribute("YAxisPosition", string2);
            ArrayList arrayList = elementGroupSetInSXYGraph.mDrawingElementGroupList;
            for (int i = 0; i < arrayList.size(); ++i) {
                SGElementGroup sGElementGroup = (SGElementGroup)arrayList.get(i);
                Element element2 = sGElementGroup.createElement(document);
                if (element2 == null) {
                    return null;
                }
                element.appendChild(element2);
            }
            return element;
        }

        public boolean writeProperty(Element element) {
            SGISXYTypeMultipleData sGISXYTypeMultipleData = (SGISXYTypeMultipleData)((Object)SGSXYGraphElement.this.getData(this));
            if (!super.writeProperty(element)) {
                return false;
            }
            if (sGISXYTypeMultipleData instanceof SGSXYSamplingData) {
                double d = this.getSamplingRate();
                element.setAttribute("SamplingRate", Double.toString(d));
            }
            return true;
        }

        public boolean isLineVisible() {
            return this.getLineGroup().isVisible();
        }

        public float getLineWidth() {
            return this.getLineGroup().getLineWidth();
        }

        public float getLineWidth(String string) {
            return (float)SGUtilityText.convertFromPoint(this.getLineWidth(), string);
        }

        public int getLineType() {
            return this.getLineGroup().getLineType();
        }

        public Color getLineColor() {
            return this.getLineGroup().getColor(0);
        }

        public boolean setLineVisible(boolean bl) {
            ArrayList arrayList = this.getLineGroups();
            for (int i = 0; i < arrayList.size(); ++i) {
                ElementGroupLine elementGroupLine = (ElementGroupLine)arrayList.get(i);
                elementGroupLine.setVisible(bl);
            }
            return true;
        }

        public boolean setLineWidth(float f) {
            ArrayList arrayList = this.getLineGroups();
            for (int i = 0; i < arrayList.size(); ++i) {
                ElementGroupLine elementGroupLine = (ElementGroupLine)arrayList.get(i);
                elementGroupLine.setLineWidth(f);
            }
            return true;
        }

        public boolean setLineWidth(float f, String string) {
            ArrayList arrayList = this.getLineGroups();
            float f2 = (float)SGUtilityText.convertToPoint(f, string);
            for (int i = 0; i < arrayList.size(); ++i) {
                ElementGroupLine elementGroupLine = (ElementGroupLine)arrayList.get(i);
                elementGroupLine.setLineWidth(f2);
            }
            return true;
        }

        public boolean setLineType(int n) {
            ArrayList arrayList = this.getLineGroups();
            for (int i = 0; i < arrayList.size(); ++i) {
                ElementGroupLine elementGroupLine = (ElementGroupLine)arrayList.get(i);
                elementGroupLine.setLineType(n);
            }
            return true;
        }

        public boolean setLineColor(Color color) {
            ArrayList arrayList = this.getLineGroups();
            for (int i = 0; i < arrayList.size(); ++i) {
                ElementGroupLine elementGroupLine = (ElementGroupLine)arrayList.get(i);
                elementGroupLine.setColor(color);
            }
            return true;
        }

        public boolean isSymbolVisible() {
            return this.getSymbolGroup().isVisible();
        }

        public int getSymbolType() {
            return this.getSymbolGroup().getType();
        }

        public float getSymbolSize() {
            return this.getSymbolGroup().getSize();
        }

        public float getSymbolSize(String string) {
            return (float)SGUtilityText.convertFromPoint(this.getSymbolSize(), string);
        }

        public float getSymbolLineWidth() {
            return this.getSymbolGroup().getLineWidth();
        }

        public float getSymbolLineWidth(String string) {
            return (float)SGUtilityText.convertFromPoint(this.getSymbolLineWidth(), string);
        }

        public Color getSymbolInnerColor() {
            return this.getSymbolGroup().getColor(0);
        }

        public Color getSymbolLineColor() {
            return this.getSymbolGroup().getLineColor();
        }

        public boolean setSymbolVisible(boolean bl) {
            ArrayList arrayList = this.getSymbolGroups();
            for (int i = 0; i < arrayList.size(); ++i) {
                ElementGroupSymbol elementGroupSymbol = (ElementGroupSymbol)arrayList.get(i);
                elementGroupSymbol.setVisible(bl);
            }
            return true;
        }

        public boolean setSymbolType(int n) {
            ArrayList arrayList = this.getSymbolGroups();
            for (int i = 0; i < arrayList.size(); ++i) {
                ElementGroupSymbol elementGroupSymbol = (ElementGroupSymbol)arrayList.get(i);
                elementGroupSymbol.setType(n);
            }
            return true;
        }

        public boolean setSymbolSize(float f) {
            ArrayList arrayList = this.getSymbolGroups();
            for (int i = 0; i < arrayList.size(); ++i) {
                ElementGroupSymbol elementGroupSymbol = (ElementGroupSymbol)arrayList.get(i);
                elementGroupSymbol.setSize(f);
            }
            return true;
        }

        public boolean setSymbolSize(float f, String string) {
            ArrayList arrayList = this.getSymbolGroups();
            float f2 = (float)SGUtilityText.convertToPoint(f, string);
            for (int i = 0; i < arrayList.size(); ++i) {
                ElementGroupSymbol elementGroupSymbol = (ElementGroupSymbol)arrayList.get(i);
                elementGroupSymbol.setSize(f2);
            }
            return true;
        }

        public boolean setSymbolLineWidth(float f) {
            ArrayList arrayList = this.getSymbolGroups();
            for (int i = 0; i < arrayList.size(); ++i) {
                ElementGroupSymbol elementGroupSymbol = (ElementGroupSymbol)arrayList.get(i);
                elementGroupSymbol.setLineWidth(f);
            }
            return true;
        }

        public boolean setSymbolLineWidth(float f, String string) {
            ArrayList arrayList = this.getSymbolGroups();
            float f2 = (float)SGUtilityText.convertToPoint(f, string);
            for (int i = 0; i < arrayList.size(); ++i) {
                ElementGroupSymbol elementGroupSymbol = (ElementGroupSymbol)arrayList.get(i);
                elementGroupSymbol.setLineWidth(f2);
            }
            return true;
        }

        public boolean setSymbolInnerColor(Color color) {
            ArrayList arrayList = this.getSymbolGroups();
            for (int i = 0; i < arrayList.size(); ++i) {
                ElementGroupSymbol elementGroupSymbol = (ElementGroupSymbol)arrayList.get(i);
                elementGroupSymbol.setColor(color);
            }
            return true;
        }

        public boolean setSymbolLineColor(Color color) {
            ArrayList arrayList = this.getSymbolGroups();
            for (int i = 0; i < arrayList.size(); ++i) {
                ElementGroupSymbol elementGroupSymbol = (ElementGroupSymbol)arrayList.get(i);
                elementGroupSymbol.setLineColor(color);
            }
            return true;
        }

        public boolean isBarVisible() {
            return this.getBarGroup().isVisible();
        }

        public double getBarBaselineValue() {
            return this.getBarGroup().getBaselineValue();
        }

        public float getBarWidth() {
            return this.getBarGroup().getRectangleWidth();
        }

        public double getBarWidthValue() {
            return this.getBarGroup().getWidthValue();
        }

        public float getBarEdgeLineWidth() {
            return this.getBarGroup().getEdgeLineWidth();
        }

        public float getBarEdgeLineWidth(String string) {
            return (float)SGUtilityText.convertFromPoint(this.getBarEdgeLineWidth(), string);
        }

        public Color getBarInnerColor() {
            return this.getBarGroup().getColor(0);
        }

        public Color getBarEdgeLineColor() {
            return this.getBarGroup().getEdgeLineColor();
        }

        public boolean setBarVisible(boolean bl) {
            ArrayList arrayList = this.getBarGroups();
            for (int i = 0; i < arrayList.size(); ++i) {
                ElementGroupBar elementGroupBar = (ElementGroupBar)arrayList.get(i);
                elementGroupBar.setVisible(bl);
            }
            return true;
        }

        public boolean setBarBaselineValue(double d) {
            ArrayList arrayList = this.getBarGroups();
            for (int i = 0; i < arrayList.size(); ++i) {
                ElementGroupBar elementGroupBar = (ElementGroupBar)arrayList.get(i);
                elementGroupBar.setBaselineValue(d);
            }
            return true;
        }

        public boolean setBarWidth(float f) {
            ArrayList arrayList = this.getBarGroups();
            for (int i = 0; i < arrayList.size(); ++i) {
                ElementGroupBar elementGroupBar = (ElementGroupBar)arrayList.get(i);
                elementGroupBar.setRectangleWidth(f);
            }
            return true;
        }

        public boolean setBarWidthValue(double d) {
            ArrayList arrayList = this.getBarGroups();
            for (int i = 0; i < arrayList.size(); ++i) {
                ElementGroupBar elementGroupBar = (ElementGroupBar)arrayList.get(i);
                elementGroupBar.setWidthValue(d);
            }
            return true;
        }

        public boolean setBarEdgeLineWidth(float f) {
            ArrayList arrayList = this.getBarGroups();
            for (int i = 0; i < arrayList.size(); ++i) {
                ElementGroupBar elementGroupBar = (ElementGroupBar)arrayList.get(i);
                elementGroupBar.setEdgeLineWidth(f);
            }
            return true;
        }

        public boolean setBarEdgeLineWidth(float f, String string) {
            ArrayList arrayList = this.getBarGroups();
            float f2 = (float)SGUtilityText.convertToPoint(f, string);
            for (int i = 0; i < arrayList.size(); ++i) {
                ElementGroupBar elementGroupBar = (ElementGroupBar)arrayList.get(i);
                elementGroupBar.setEdgeLineWidth(f2);
            }
            return true;
        }

        public boolean setBarInnerColor(Color color) {
            ArrayList arrayList = this.getBarGroups();
            for (int i = 0; i < arrayList.size(); ++i) {
                ElementGroupBar elementGroupBar = (ElementGroupBar)arrayList.get(i);
                elementGroupBar.setColor(color);
            }
            return true;
        }

        public boolean setBarEdgeLineColor(Color color) {
            ArrayList arrayList = this.getBarGroups();
            for (int i = 0; i < arrayList.size(); ++i) {
                ElementGroupBar elementGroupBar = (ElementGroupBar)arrayList.get(i);
                elementGroupBar.setEdgeLineColor(color);
            }
            return true;
        }

        public boolean hasValidBaselineValue(int n, Number number) {
            return this.getFirst().hasValidBaselineValue(n, number);
        }

        public boolean isErrorBarHolding() {
            return this.getErrorBarGroup() != null;
        }

        public boolean isErrorBarVisible() {
            return this.getErrorBarGroup().isVisible();
        }

        public int getErrorBarHeadType() {
            return this.getErrorBarGroup().getHeadType();
        }

        public float getErrorBarHeadSize() {
            return this.getErrorBarGroup().getHeadSize();
        }

        public float getErrorBarHeadSize(String string) {
            return (float)SGUtilityText.convertFromPoint(this.getErrorBarHeadSize(), string);
        }

        public Color getErrorBarColor() {
            return this.getErrorBarGroup().getColor(0);
        }

        public float getErrorBarLineWidth() {
            return this.getErrorBarGroup().getLineWidth();
        }

        public float getErrorBarLineWidth(String string) {
            return (float)SGUtilityText.convertFromPoint(this.getErrorBarLineWidth(), string);
        }

        public int getErrorBarStyle() {
            return this.getErrorBarGroup().getErrorBarStyle();
        }

        public boolean setErrorBarVisible(boolean bl) {
            return true;
        }

        public boolean setErrorBarHeadType(int n) {
            return true;
        }

        public boolean setErrorBarHeadSize(float f) {
            return true;
        }

        public boolean setErrorBarHeadSize(float f, String string) {
            return true;
        }

        public boolean setErrorBarColor(Color color) {
            return true;
        }

        public boolean setErrorBarLineWidth(float f) {
            return true;
        }

        public boolean setErrorBarLineWidth(float f, String string) {
            return true;
        }

        public boolean setErrorBarStyle(int n) {
            return true;
        }

        public boolean isTickLabelHolding() {
            return this.getTickLabelGroup() != null;
        }

        public boolean isTickLabelVisible() {
            return this.getTickLabelGroup().isVisible();
        }

        public String getTickLabelFontName() {
            return this.getTickLabelGroup().getFontName();
        }

        public int getTickLabelFontStyle() {
            return this.getTickLabelGroup().getFontStyle();
        }

        public float getTickLabelFontSize() {
            return this.getTickLabelGroup().getFontSize();
        }

        public float getTickLabelFontSize(String string) {
            return (float)SGUtilityText.convertFromPoint(this.getTickLabelFontSize(), string);
        }

        public Color getTickLabelColor() {
            return this.getTickLabelGroup().getColor(0);
        }

        public boolean isTickLabelHorizontal() {
            return this.getTickLabelGroup().getAngle() == 0.0f;
        }

        public boolean setTickLabelVisible(boolean bl) {
            return true;
        }

        public boolean setTickLabelFontName(String string) {
            return true;
        }

        public boolean setTickLabelFontStyle(int n) {
            return true;
        }

        public boolean setTickLabelFontSize(float f) {
            return true;
        }

        public boolean setTickLabelFontSize(float f, String string) {
            return true;
        }

        public boolean setTickLabelColor(Color color) {
            return true;
        }

        public boolean setTickLabelHorizontal(boolean bl) {
            return true;
        }

        public ArrayList getLineGroups() {
            ArrayList arrayList = new ArrayList();
            ArrayList arrayList2 = this.mElementGroupSetList;
            for (int i = 0; i < arrayList2.size(); ++i) {
                ElementGroupSetInSXYGraph elementGroupSetInSXYGraph = (ElementGroupSetInSXYGraph)arrayList2.get(i);
                arrayList.addAll(elementGroupSetInSXYGraph.getLineGroups());
            }
            return arrayList;
        }

        public ArrayList getSymbolGroups() {
            ArrayList arrayList = new ArrayList();
            ArrayList arrayList2 = this.mElementGroupSetList;
            for (int i = 0; i < arrayList2.size(); ++i) {
                ElementGroupSetInSXYGraph elementGroupSetInSXYGraph = (ElementGroupSetInSXYGraph)arrayList2.get(i);
                arrayList.addAll(elementGroupSetInSXYGraph.getSymbolGroups());
            }
            return arrayList;
        }

        public ArrayList getBarGroups() {
            ArrayList arrayList = new ArrayList();
            ArrayList arrayList2 = this.mElementGroupSetList;
            for (int i = 0; i < arrayList2.size(); ++i) {
                ElementGroupSetInSXYGraph elementGroupSetInSXYGraph = (ElementGroupSetInSXYGraph)arrayList2.get(i);
                arrayList.addAll(elementGroupSetInSXYGraph.getBarGroups());
            }
            return arrayList;
        }

        public ArrayList getErrorBarGroups() {
            ArrayList arrayList = new ArrayList();
            ArrayList arrayList2 = this.mElementGroupSetList;
            for (int i = 0; i < arrayList2.size(); ++i) {
                ElementGroupSetInSXYGraph elementGroupSetInSXYGraph = (ElementGroupSetInSXYGraph)arrayList2.get(i);
                arrayList.addAll(elementGroupSetInSXYGraph.getErrorBarGroups());
            }
            return arrayList;
        }

        public ArrayList getTickLabelGroups() {
            ArrayList arrayList = new ArrayList();
            ArrayList arrayList2 = this.mElementGroupSetList;
            for (int i = 0; i < arrayList2.size(); ++i) {
                ElementGroupSetInSXYGraph elementGroupSetInSXYGraph = (ElementGroupSetInSXYGraph)arrayList2.get(i);
                arrayList.addAll(elementGroupSetInSXYGraph.getTickLabelGroups());
            }
            return arrayList;
        }

        public int getSelectedTabIndex() {
            return this.mSelectedTabIndex;
        }

        protected boolean onMouseClicked(MouseEvent mouseEvent) {
            if (!super.onMouseClicked(mouseEvent)) {
                return false;
            }
            SGElementGroup sGElementGroup = this.getElementGroupAt(mouseEvent.getX(), mouseEvent.getY());
            int n = -1;
            if (sGElementGroup instanceof ElementGroupLine) {
                n = 0;
            } else if (sGElementGroup instanceof ElementGroupSymbol) {
                n = 1;
            } else if (sGElementGroup instanceof ElementGroupBar) {
                n = 2;
            }
            this.mSelectedTabIndex = n;
            return true;
        }

        private ElementGroupSetInSXYGraph getFirst() {
            ElementGroupSetInSXYGraph elementGroupSetInSXYGraph = (ElementGroupSetInSXYGraph)this.mElementGroupSetList.get(0);
            return elementGroupSetInSXYGraph;
        }

        public int getXAxisConfiguration() {
            return this.getFirst().getXAxisConfiguration();
        }

        public int getYAxisConfiguration() {
            return this.getFirst().getYAxisConfiguration();
        }

        public boolean getLegendVisibleFlag() {
            return this.isVisibleInLegend();
        }

        public boolean synchronizeDrawingElement(ArrayList arrayList) {
            boolean bl = false;
            ArrayList arrayList2 = this.mElementGroupSetList;
            for (int i = 0; i < arrayList2.size(); ++i) {
                ElementGroupSetInSXYGraph elementGroupSetInSXYGraph = (ElementGroupSetInSXYGraph)arrayList2.get(i);
                boolean bl2 = elementGroupSetInSXYGraph.synchronizeDrawingElement(arrayList);
                if (!bl2) continue;
                bl = true;
            }
            return bl;
        }
    }

    private static interface IElementGroupSetInSXYGraph {
        public Rectangle2D getTickLabelsBoundingBox(SGData var1);

        public boolean setDrawingElementsLocation(SGData var1);

        public boolean paintDataString(Graphics2D var1);

        public boolean synchronizeDrawingElement(ArrayList var1);
    }
}

