/*
 * Decompiled with CFR 0.152.
 */
package jp.riken.brain.ni.samuraigraph.figure;

import java.awt.Color;
import java.util.ArrayList;
import jp.riken.brain.ni.samuraigraph.base.SGDrawingElement;
import jp.riken.brain.ni.samuraigraph.base.SGIDrawingElementConstants;
import jp.riken.brain.ni.samuraigraph.base.SGProperties;
import jp.riken.brain.ni.samuraigraph.figure.SGDrawingElementString;
import jp.riken.brain.ni.samuraigraph.figure.SGISignificantDifferenceSymbolConstants;

public abstract class SGSignificantDifferenceSymbol
extends SGDrawingElement
implements SGISignificantDifferenceSymbolConstants,
SGIDrawingElementConstants {
    protected float mX;
    protected float mY;
    protected float mWidth;
    protected float mPerpendicularHeight1;
    protected float mPerpendicularHeight2;
    protected float mSpace;
    protected float mLineWidth;
    protected boolean mLineVisibleFlag = true;

    public boolean isLineVisible() {
        return this.mLineVisibleFlag;
    }

    public void setLineVisible(boolean bl) {
        this.mLineVisibleFlag = bl;
    }

    public SGSignificantDifferenceSymbol() {
    }

    public SGSignificantDifferenceSymbol(float f, float f2, float f3, float f4, float f5) {
        this.setLocation(f, f2);
        this.setSize(f3, f4, f5);
    }

    public float getX() {
        return this.mX;
    }

    public float getY() {
        return this.mY;
    }

    public float getX1() {
        return this.getX();
    }

    public float getX2() {
        return this.getX1() + this.getMagnification() * this.getWidth();
    }

    public float getY1() {
        return this.getY() + this.getMagnification() * this.getPerpendicularHeight1();
    }

    public float getY2() {
        return this.getY() + this.getMagnification() * this.getPerpendicularHeight2();
    }

    public float getWidth() {
        return this.mWidth;
    }

    public float getPerpendicularHeight1() {
        return this.mPerpendicularHeight1;
    }

    public float getPerpendicularHeight2() {
        return this.mPerpendicularHeight2;
    }

    public float getSpace() {
        return this.mSpace;
    }

    public abstract SGDrawingElementString getStringElement();

    public String getText() {
        return this.getStringElement().getString();
    }

    public float getFontSize() {
        return this.getStringElement().getFontSize();
    }

    public int getFontStyle() {
        return this.getStringElement().getFontStyle();
    }

    public String getFontName() {
        return this.getStringElement().getFontName();
    }

    public float getLineWidth() {
        return this.mLineWidth;
    }

    public Color getColor() {
        return this.getColor(0);
    }

    public boolean setColor(ArrayList arrayList) {
        super.setColor(arrayList);
        this.getStringElement().setColor(arrayList);
        return true;
    }

    public boolean setColor(Color color) {
        super.setColor(color);
        this.getStringElement().setColor(color);
        return true;
    }

    public boolean addColor(Color color) {
        super.addColor(color);
        this.getStringElement().addColor(color);
        return true;
    }

    public boolean setLocation(float f, float f2) {
        this.setX(f);
        this.setY(f2);
        return true;
    }

    public boolean setX(float f) {
        this.mX = f;
        return true;
    }

    public boolean setY(float f) {
        this.mY = f;
        return true;
    }

    public boolean setSize(float f, float f2, float f3) {
        this.setWidth(f);
        this.setPerpendicularHeight1(f2);
        this.setPerpendicularHeight2(f3);
        return true;
    }

    public boolean setWidth(float f) {
        this.mWidth = f;
        return true;
    }

    public boolean setPerpendicularHeight1(float f) {
        this.mPerpendicularHeight1 = f;
        return true;
    }

    public boolean setPerpendicularHeight2(float f) {
        this.mPerpendicularHeight2 = f;
        return true;
    }

    public boolean setSpace(float f) {
        this.mSpace = f;
        return true;
    }

    public boolean setText(String string) {
        if (string == null) {
            throw new IllegalArgumentException("text==null");
        }
        this.getStringElement().setString(string);
        return true;
    }

    public boolean setLineWidth(float f) {
        if (f < Float.MIN_VALUE) {
            throw new IllegalArgumentException("lineWidth < Float.MIN_VALUE");
        }
        this.mLineWidth = f;
        return true;
    }

    public boolean setFont(String string, int n, float f) {
        if (f < Float.MIN_VALUE) {
            throw new IllegalArgumentException("size < Float.MIN_VALUE");
        }
        this.getStringElement().setFont(string, n, f);
        return true;
    }

    public void setFontName(String string) {
        int n = this.getFontStyle();
        float f = this.getFontSize();
        this.setFont(string, n, f);
    }

    public void setFontStyle(int n) {
        String string = this.getFontName();
        float f = this.getFontSize();
        this.setFont(string, n, f);
    }

    public void setFontSize(float f) {
        String string = this.getFontName();
        int n = this.getFontStyle();
        this.setFont(string, n, f);
    }

    public boolean isFlippingHorizontal() {
        return this.mWidth < 0.0f;
    }

    public boolean isFlippingVertical() {
        return this.isFlippingVertical1() & this.isFlippingVertical2();
    }

    public boolean isFlippingVertical1() {
        return this.mPerpendicularHeight1 < 0.0f;
    }

    public boolean isFlippingVertical2() {
        return this.mPerpendicularHeight2 < 0.0f;
    }

    public boolean isFlippingVerticalLeft() {
        return !this.isFlippingHorizontal() ? this.isFlippingVertical1() : this.isFlippingVertical2();
    }

    public boolean isFlippingVerticalRight() {
        return !this.isFlippingHorizontal() ? this.isFlippingVertical2() : this.isFlippingVertical1();
    }

    public float getLeftHeight() {
        if (!this.isFlippingHorizontal()) {
            return this.getPerpendicularHeight1();
        }
        return this.getPerpendicularHeight2();
    }

    public float getRightHeight() {
        if (!this.isFlippingHorizontal()) {
            return this.getPerpendicularHeight2();
        }
        return this.getPerpendicularHeight1();
    }

    public boolean setLeftHeight(float f) {
        if (!this.isFlippingHorizontal()) {
            this.setPerpendicularHeight1(f);
        } else {
            this.setPerpendicularHeight2(f);
        }
        return true;
    }

    public boolean setRightHeight(float f) {
        if (!this.isFlippingHorizontal()) {
            this.setPerpendicularHeight2(f);
        } else {
            this.setPerpendicularHeight1(f);
        }
        return true;
    }

    public boolean setNodePointLocation(float f, float f2, float f3, float f4, float f5) {
        float f6 = this.getMagnification();
        float f7 = (f3 - f) / f6;
        this.setX(f);
        this.setWidth(f7);
        this.setY(f5);
        float f8 = (f2 - f5) / f6;
        float f9 = (f4 - f5) / f6;
        this.setPerpendicularHeight1(f8);
        this.setPerpendicularHeight2(f9);
        return true;
    }

    public SGProperties getProperties() {
        SigDiffProperties sigDiffProperties = new SigDiffProperties();
        if (!this.getProperties(sigDiffProperties)) {
            return null;
        }
        return sigDiffProperties;
    }

    public boolean getProperties(SGProperties sGProperties) {
        if (!(sGProperties instanceof SigDiffProperties)) {
            return false;
        }
        if (!super.getProperties(sGProperties)) {
            return false;
        }
        SigDiffProperties sigDiffProperties = (SigDiffProperties)sGProperties;
        sigDiffProperties.mSpace = this.mSpace;
        sigDiffProperties.mLineVisible = this.mLineVisibleFlag;
        sigDiffProperties.mLineWidth = this.mLineWidth;
        sigDiffProperties.mText = this.getText();
        sigDiffProperties.mFontName = this.getFontName();
        sigDiffProperties.mFontSize = this.getFontSize();
        sigDiffProperties.mFontStyle = this.getFontStyle();
        return true;
    }

    public boolean setProperties(SGProperties sGProperties) {
        if (!(sGProperties instanceof SigDiffProperties)) {
            return false;
        }
        if (!super.setProperties(sGProperties)) {
            return false;
        }
        SigDiffProperties sigDiffProperties = (SigDiffProperties)sGProperties;
        this.mSpace = sigDiffProperties.mSpace;
        this.setText(sigDiffProperties.mText);
        this.setFont(sigDiffProperties.mFontName, sigDiffProperties.mFontStyle, sigDiffProperties.mFontSize);
        this.setLineVisible(sigDiffProperties.mLineVisible);
        this.setLineWidth(sigDiffProperties.mLineWidth);
        return true;
    }

    public static class SigDiffProperties
    extends SGDrawingElement.DrawingElementProperties {
        private float mSpace;
        private float mLineWidth;
        private String mText;
        private String mFontName;
        private float mFontSize;
        private int mFontStyle;
        private boolean mLineVisible;

        public boolean equals(Object object) {
            if (!(object instanceof SigDiffProperties)) {
                return false;
            }
            if (!super.equals(object)) {
                return false;
            }
            SigDiffProperties sigDiffProperties = (SigDiffProperties)object;
            if (sigDiffProperties.mSpace != this.mSpace) {
                return false;
            }
            if (sigDiffProperties.mLineWidth != this.mLineWidth) {
                return false;
            }
            if (!sigDiffProperties.mText.equals(this.mText)) {
                return false;
            }
            if (!sigDiffProperties.mFontName.equals(this.mFontName)) {
                return false;
            }
            if (sigDiffProperties.mFontSize != this.mFontSize) {
                return false;
            }
            if (sigDiffProperties.mFontStyle != this.mFontStyle) {
                return false;
            }
            return sigDiffProperties.mLineVisible == this.mLineVisible;
        }

        public Float getSpace() {
            return new Float(this.mSpace);
        }

        public Float getLineWidth() {
            return new Float(this.mLineWidth);
        }

        public String getText() {
            return this.mText;
        }

        public String getFontName() {
            return this.mFontName;
        }

        public Float getFontSize() {
            return new Float(this.mFontSize);
        }

        public Integer getFontStyle() {
            return new Integer(this.mFontStyle);
        }

        public Boolean getLineVisible() {
            return this.mLineVisible;
        }

        public void setSpace(float f) {
            this.mSpace = f;
        }

        public void setLineWidth(float f) {
            if (f < 0.0f) {
                throw new IllegalArgumentException("value<0.0f");
            }
            this.mLineWidth = f;
        }

        public void setText(String string) {
            if (string == null) {
                throw new IllegalArgumentException("str==null");
            }
            this.mText = string;
        }

        public void setFontName(String string) {
            if (string == null) {
                throw new IllegalArgumentException("str==null");
            }
            this.mFontName = string;
        }

        public void setFontSize(float f) {
            if (f < 0.0f) {
                throw new IllegalArgumentException("value<0.0f");
            }
            this.mFontSize = f;
        }

        public void setFontStyle(int n) {
            this.mFontStyle = n;
        }

        public void setLineVisible(boolean bl) {
            this.mLineVisible = bl;
        }
    }
}

